<?php

	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articlecategories.class.php" );
	lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryalbums.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/dao/atompasswords.class.php" );	
	
	/**
	 * loads and displays the plugin settings
	 */
	class AdminAtomPluginSettingsView extends AdminPluginTemplatedView
	{
	
		var $_userInfo;
	
		function AdminAtomPluginSettingsView( $blogInfo, $userInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "atom", "pluginsettings" );
			
			$this->_userInfo = $userInfo;
		}
		
		function render()
		{
			$blogSettings = $this->_blogInfo->getSettings();

			// fetch the current settings
			$categoryId = $blogSettings->getValue( "plugin_atom_article_category_id" );
			$albumId = $blogSettings->getValue( "plugin_atom_gallery_resource_album_id" );
			$resourcePreviewType = $blogSettings->getValue( "plugin_atom_resource_preview_type" );
			$passwords = new AtomPasswords();
			$atomPassword = $passwords->getPassword( $this->_userInfo->getId());
			
			// fetch all the current article categories
			$categories = new ArticleCategories();
			$blogCategories = $categories->getBlogCategories( $this->_blogInfo->getId());
			// fetch all the current gallery albums
			$albums = new GalleryAlbums();
			$blogAlbums = $albums->getUserAlbums( $this->_blogInfo->getId());		
			
			// if the user is an admin, then we also have to export a couple more things
			if( $this->_userInfo->isSiteAdmin()) {
			     $config =& Config::getConfig();
			     $loggingEnabled = $config->getValue( "atom_logging_enabled" );
			     $dontSetHeaders = $config->getValue( "atom_dont_set_headers" );
			}
			else {
				$loggingEnabled = false;
				$dontSetHeaders = false;
			}
			
			// finally pass all these things to the templates
			$this->setValue( "atomPassword", $atomPassword );
			$this->setValue( "categoryId", $categoryId );
			$this->setValue( "albumId", $albumId );
			$this->setValue( "albums", $blogAlbums );
			$this->setValue( "categories", $blogCategories );
			$this->setValue( "password", $atomPassword );
			$this->setValue( "loggingEnabled", $loggingEnabled );
			$this->setValue( "dontSetHeaders", $dontSetHeaders );
			$this->setValue( "resourcePreviewType", $resourcePreviewType );
			
		
			parent::render();
		}
	}
?>