<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/wsseauthentication.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/users.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/dao/atompasswords.class.php" );
	
	/**
	 * pLog-specific authentication class for Atom
	 *
	 * It only reimplements the getUserData method, which is the only one that is
	 * application-specific
	 */
	class PlogAtomAuthentication extends WSSEAuthentication
	{
	
		function PlogAtomAuthentication()
		{
			$this->WSSEAuthentication();
		}
		
		/**
		 * loads the user data from the plog_users table
		 *
		 * @see WSSEAuthentication::getUserData()
		 */
		function getUserData( $userName )
		{
			$users = new Users();
			$userInfo = $users->getUserInfoFromUsername( $userName );
			
			// error checking...
			if( !$userInfo )
				return false;
				
            // try to load the password
            $passwords = new AtomPasswords();
            $userPassword = $passwords->getPassword( $userInfo->getId());
            
            AtomLogger::Log( "PlogAtomAuthentication: using password = $userPassword" );
				
			// otherwise, fetch the information we need
			$result = Array ( "username" => $userInfo->getUsername(),
			                  "password" => $userPassword );
			                  
			return $result;
		}
	}
?>