<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

    /**
	* offers features to inset google analytics javascript codes in tempalte header.
	*/
    class PluginBlogLook extends PluginBase
    {
        var $pluginEnabled;
		var $blogid;

        function PluginBlogLook($source = "")
        {
			$this->PluginBase($source);

            $this->id = "bloglook";
            $this->author = "twu2";
            $this->desc = "This plugin offers features to inset BlogLook codes in tempalte header.";
            $this->version = "20070321";

            $this->locales = Array( "en_UK" , "zh_TW" );

	    if ($source == "admin")
            	$this->initAdmin();
        }

		function initAdmin()
		{
			$this->registerAdminAction( "bloglook", "PluginBlogLookConfigAction" );
			$this->registerAdminAction( "updatebloglook", "PluginBlogLookUpdateConfigAction" );

			$menu =& Menu::getMenu();
            $this->addMenuEntry( "/menu/controlCenter/manageSettings", "BlogLook", "?op=bloglook");
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_bloglook_enabled" );
	        $this->blogid = $blogSettings->getValue( "plugin_bloglook_blogid" );
	    }

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

        /**
		* Returns google analytics javascript
		*/
        function getBlogID()
        {
            $jsCode = "";
            if( $this->isEnabled() ){
                $jsCode = $this->blogid;
            }
			return $jsCode;
        }
    }
?>
