<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the tag cloud plugin
	 */
	class PluginCategoryCloudConfigView extends AdminPluginTemplatedView
	{

		function PluginCategoryCloudConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "categorycloud", "categorycloud" );
		}
		
		function render()
		{
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_categorycloud_enabled" );
			$minSize = $blogSettings->getValue( "plugin_categorycloud_min_size" );
			if ($minSize == "") $minSize = .4;
			$maxSize = $blogSettings->getValue( "plugin_categorycloud_max_size" );
			if ($maxSize == "") $maxSize = 3;
			$minWeight = $blogSettings->getValue( "plugin_categorycloud_min_weight" );
			if ($minWeight == "") $minWeight = 100;
			$maxWeight = $blogSettings->getValue( "plugin_categorycloud_max_weight" );
			if ($maxWeight == "") $maxWeight = 900;
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "minFont", $minSize );
			$this->setValue( "maxFont", $maxSize );
			$this->setValue( "minWeight", $minWeight );
			$this->setValue( "maxWeight", $maxWeight );

			parent::render();
		}
	}
?>
