<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    //lt_include( PLOG_CLASS_PATH."class/logger/loggermanager.class.php" );

	class PluginCssNaked extends PluginBase
	{

        var $_pluginEnabled;
        var $_startDate;
        var $_endDate;
        var $_timeFrame = 48;
        var $_addNotice;
        var $_l;
        
		function PluginCssNaked ( $source = '' )
		{
			$this->PluginBase( $source );
			
			// only used for logging
			//$this->_l =& LoggerManager::getLogger( "naked" );
			
			$this->id = "cssnaked";
			$this->version = "20070403";
			$this->author = "Reto Hugi";
			$this->desc = "Deactivates all CSS Styles on the active template. This Template was written to easily participate at the <a href=\"http://naked.dustindiaz.com/\">CSS Naked Day</a>. The idea behind this event is to promote Web Standards. Plain and simple. This includes proper use of (x)html, semantic markup, a good hierarchy structure, and of course, a good 'ol play on words. It's time to show off your &lt;body&gt;.";
			
			$this->locales = Array( "en_UK" );
			
			if( $source == "admin" ) {
				
                // register an action for the plugin configuration
                $this->registerAdminAction( "cssnakedConfig", "AdminCssNakedConfigAction" );
                $this->registerAdminAction( "cssnakedUpdateConfig", "AdminCssNakedConfigUpdateAction" );
                
                // add a menu entry
                $menu =& Menu::getMenu();
                if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))                     
                    $this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "", "" );
                $this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "cssnaked", "?op=cssnakedConfig");
                
			}
			else {
			
			    // hook up to our event if we are not in admin mode
				$this->registerNotification( EVENT_PROCESS_BLOG_TEMPLATE_OUTPUT );
			}
		}

		function register()
		{
            //$this->_l->debug( "----- START REGISTER() ---------" );
	    }

		function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_cssnaked_enabled", "type" => "boolean" )
			));
		}
		
		function process( $event, $params )
		{
		    //$this->_l->debug( "----- START PROCESS() ---------" );
		    //$this->_l->debug( $params['blogInfo'] );
		    //$this->_l->debug( $params['userInfo'] );
  
		    // load the settings needed
		    $blogSettings =& $params['blogInfo']->getSettings();
		    $this->_pluginEnabled = $blogSettings->getValue( "plugin_cssnaked_enabled" );
		    $this->_startDate = $blogSettings->getValue( "plugin_cssnaked_startDate" );
		    $this->_endDate = $blogSettings->getValue( "plugin_cssnaked_endDate" );
		    $this->_addNotice = $blogSettings->getValue( "plugin_cssnaked_addNotice" );

		    //TODO
		    //$this->_timeFrame = $blogSettings->getValue( "plugin_cssnaked_timeFrame" );	    
		     
		    /*
		    $this->_l->debug( "Enabled: ".$this->_pluginEnabled
		        ."\nStart Date: ".$this->_startDate
                ."\nEnd Date: ".$this->_endDate
                ."\nadd Notice: ".$this->_addNotice
		     );
		     */
		    
            // check if the plugin is enabled and do nothing if not.
            if (!$this->_pluginEnabled) { return true; }
            //$this->_l->debug( "[info] Plugin Enabled" );
            
            // check if today is a naked day ;)
            if ( !$this->isNakedDay() ) { return true; }
            //$this->_l->debug( "[info] is Naked Day" );
            
			// all checks passed, so let's get naked!
			$content = $params["content"];
			$content =& $this->_strip($content);
			
			// check if we want to add a notice at the top
			if ($this->_addNotice) { 
			
		        // get the notice we want to display from the locale
		        $locale =& $this->blogInfo->getLocale();
			    $content =& $this->_addNotice( $content, $locale->tr('cssnaked_notice') );
			}
			
			// write the naked content back to send the content to the browser
			$params["content"] = $content;
		}

        // parts of this method where inspired by http://www.ajalapus.com
        function isNakedDay() {
            
            //$this->_l->debug( "----- START isNakedDay() ---------" );	

        	if ($this->_timeFrame === 48) {

        		// Start of the Day on GMT+12
        		$stime = gmmktime( -12, 0, 0, date('n',$this->_startDate), date('j',$this->_startDate) ); 
        		// End of the Day on GMT-12
        		$etime = gmmktime(36, 0, 0, date('n',$this->_endDate), date('j',$this->_endDate) );
        	}
        	else {
        	    //TODO: other time frame than 48h and taking the blogs time offset into account
        	}

        	$ntime = time(); // Time now

            //$this->_l->debug( "Start Time:$stime, End Time:$etime, Now:$ntime" );
            
        	if ($ntime >= $stime && $ntime <= $etime) {
        		return true;
        	}
        	else {
        		return false;
        	}
        }

        // parts of this method where inspired by http://www.ajalapus.com
        function _strip(&$content) {
            
        	$pattern = array(
        		'/<\?xml-stylesheet.*\?>/sU',                // x(ht)ml stylesheet directive
        		'/<link.*rel\s*=\s*["\'].*stylesheet.*>/sU', // (x)html stylesheet reference
        		'/<style.*<\/style>/sU',                     // (x)html embedded stylesheet
        		'/style\s*=\s*".*"/U',                       // (x)html inline stylesheet "
        		'/style\s*=\s*\'.*\'/U'                      // (x)html inline stylesheet '
        	);
        	
        	return preg_replace($pattern, '', $content);
        }
        
        
        function _addNotice(&$content, &$notice) {
	
            $pattern = '/<body(.*)>/U';
            
            return preg_replace($pattern, $notice, $content);
        }
	}
?>
