<?php
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	
	class PluginEditComments extends PluginBase{

		function PluginEditComments($source = ""){
			$this->PluginBase($source);

			$this->id = "editcomments";
			$this->desc = "Allows blog owner to edit comment text";
			$this->author = "Jon Daley";
			$this->locales = Array( "en_UK" );
            $this->version = "20070511";
            
			if($source == "admin")
                $this->initAdmin();
		}
		
		/**
		 * registers all of the actions that we're going to use
		 */
		function initAdmin(){			
            $this->registerNotification( EVENT_PROCESS_BLOG_ADMIN_TEMPLATE_OUTPUT );
            
                // Here are our additional features that we are adding to the regular
                // comment adding
            $this->registerAdminAction( "editComment", "AdminEditCommentAction" );
			$this->registerAdminAction( "updateComment", "AdminUpdateCommentAction" );
            
            $this->registerAdminAction( "editTrackback", "AdminEditTrackbackAction" );
			$this->registerAdminAction( "updateTrackback", "AdminUpdateTrackbackAction" );
		}

        function process($event, $params){
                // only process our expected event
            if($event != EVENT_PROCESS_BLOG_ADMIN_TEMPLATE_OUTPUT)
                return;
                    
                // only process the editcomments and edittrackbacks template
            if($params["template"] == "editcomments")
                $action = "editComment";
            else if($params["template"] == "edittrackbacks")
                $action = "editTrackback";
            else
                return;

                // load the current contents of the template
            $content = $params["content"];
            $regexp = "/<div class=\"list_action_button\">.*?<\/div>/s";
            preg_match_all($regexp, $content, $matches, PREG_SET_ORDER);

                // now process each one of the matches and do the replacements
            foreach($matches as $match){
                if($action == "editTrackback"){
                        // fetch the trackback id
                    $res = preg_match(
                        "/<a href=\"\?op=deleteTrackback&amp;articleId=[0-9]+&amp;trackbackId=([0-9]+)\"/i",
                        $match[0], $result);
                }
                else if($action == "editComment"){
                        // fetch the comment id
                    $res = preg_match(
                        "/<a href=\"\?op=deleteComment&amp;commentId=([0-9]+)&amp;/i",
                        $match[0], $result);
                }
                

                if($res){
                        // regenerate the block, adding the new markup
                    $artId = $result[1];
                    $toAdd = "<a href='?op=$action&amp;commentId={$artId}'>".
                        "<img src='imgs/admin/icon_edit-16.png' " .
                        "alt='{\$locale->tr('edit')}' /></a></div>";
                    $newStr = str_replace( "</div>", $toAdd, $match[0] );
                        // and now replace the old block with the new one in the global $content variable
                    $content = str_replace( $match[0], $newStr, $content );
                }
                else{
                    print "couldn't find id";
                }
            }
            
            $params["content"] = $content;
        }
        
    }  
?>