<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/xml/rssparser/rssparser.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/feedreader/class/dao/feedreaderdata.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/feedreader/class/view/feedlistview.class.php" );		
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	
	class ReadFeedAction extends AdminAction
	{
	
		var $_feedId;
	
		function ReadFeedAction(  $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );			
		
			$this->registerFieldValidator( "feedId", new IntegerValidator());
			$view = new AdminPluginTemplatedView( $this->_blogInfo, "feedreader", "feedlist" );
			$view->setErrorMessage( $this->_locale->tr("error_invalid_feed_id" ));
			$this->setValidationErrorView( $view );
		}
		
		function perform()
		{
			// get the feed id
			$this->_feedId = $this->_request->getValue( "feedId" );		
		
			// load the feed
			$feeds = new FeedReaderData();
			$feed = $feeds->getFeed( $this->_feedId );
			
			// and check if it is correct
			if( !$feed ) {
				$this->_view = new FeedListView( $this->_blogInfo );
				$this->_view->setErrorMessage( $this->_locale->tr("error_loading_feed" ));
				$this->setCommonData();
				return false;			
			}
			
			// also, make sure it has a link to an rss feed
			$link = $feed->getMyLink();
			if( $link->getRssFeed() == "" ) {
				$this->_view = new FeedListView( $this->_blogInfo );
				$this->_view->setErrorMessage( $this->_locale->tr("error_loading_feed" ));
				$this->setCommonData();
				return false;			
			}
			
			// update the date when this feed was last read
			$feeds->updateFeedLastReadDate( $feed );
			
			// if everything went fine, we can now try to parse the feed
			$config =& Config::getConfig();
			$tmpDir = $config->getValue( "temp_folder" );
			define( "MAGPIE_CACHE_ON", true );

			define( "MAGPIE_CACHE_AGE", 3600 );
			define( "MAGPIE_DEBUG", 0 );
			
			$rssParser = new RssParser();
			if( !$rssParser->parse( $link->getRssFeed())) {
				$this->_view = new FeedListView( $this->_blogInfo );
				$this->_view->setErrorMessage( $this->_locale->tr("error_loading_feed" ));
				$this->setCommonData();
				return false;
			}
			
			$this->_view = new AdminPluginTemplatedView( $this->_blogInfo, "feedreader", "feed" );
			$this->_view->setValue( "rss", $rssParser );
			$this->_view->setValue( "feed", $link );
			$this->setCommonData();
			
			return true;
		}
	}
?>