<?php

	lt_include( PLOG_CLASS_PATH."class/dao/model.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/feedreader/class/dao/feeddata.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/mylinks.class.php" );
	
	/**
	 * reads and stores data from feeds
	 */
	class FeedReaderData extends Model
	{
	
		function FeedReaderData()
		{
			$this->Model();
			
			// checks if our tables are there and available
			$this->_initializeDb();
			$this->_checkTables();
		}
		
		/**
		 * @private
		 */
		function _checkTables()
		{			
			// use adodb's data dictionaries to build the table for us
			$table = $this->getPrefix()."feedreader_data";
			$fields = "
			      id I(10) NOTNULL AUTO PRIMARY,
				  feed_id I(10) NOT NULL,
				  last_read T(14) DEFDATE
				  ";
            $dict = NewPDbDataDictionary( $this->_db );
            $sqlArray = $dict->ChangeTableSQL( $table, $fields );
            $result = $dict->ExecuteSQLArray( $sqlArray );
			
			return true;
		}
		
		/**
		 * updates the data when a feed was last read
		 *
		 * @param feed
		 * @return true if successful or false otherwise
		 */
		function updateFeedLastReadDate( $feed )
		{
			$prefix = $this->getPrefix();
			$link = $feed->getMyLink();
			$feedId = $link->getId();
			$query = "UPDATE {$prefix}feedreader_data
			          SET last_read = NOW() 
					  WHERE feed_id = $feedId";
					  
			$result = $this->_db->Execute( $query );
			
			if( $this->_db->Affected_Rows() == 0 ) {
				// nothing happened with the update, let's try to add
				// a record to the db...
				$this->_insertFeedData( $feed );
			}
			
			return $result;
		}
		
		function _insertFeedData( $feed )
		{
			$prefix = $this->getPrefix();
			$link = $feed->getMyLink();
			$feedId = $link->getId();
			$query = "INSERT INTO {$prefix}feedreader_data(last_read, feed_id)
			          VALUES (NOW(), $feedId )";
					  
			$result = $this->_db->Execute( $query );
			return $result;		
		}
		
		/**
		 * returns information about a feed
		 *
		 * @feedId The feed identifier in the db (the link id)
		 * @return a FeedData object
		 */
		function getFeedLastReadDate( $feedId )
		{

		}
		
		/**
		 * gets data about a feed
		 *
		 * @return A FeedData object
		 */
		function getFeedData( $myLink )
		{
			$id = $myLink->getId();
			$query = "SELECT * FROM ".$this->getPrefix()."feedreader_data
			          WHERE feed_id = '$id'";
					  
			$result = $this->Execute( $query );
			
			if( $result ) {
				$row = $result->FetchRow();
				$feedData = new FeedData( $myLink, $row["last_read"], $row["id"] );
			}
			else {
				$feedData = new FeedData( $myLink, "" );
			}
			
			return $feedData;
		}
		
		function getFeed( $feedId )
		{
			$myLinks = new MyLinks();
			$link = $myLinks->getMyLink( $feedId );
			
			if( !$link )
				return false;
				
			return $this->getFeedData( $link );
		}
		
		/**
		 * returns information about all the feeds of a blog
		 *
		 * @param blogId
		 * @param linkCategoryId
		 * @return An array of FeedData objects or an empty array if there
		 * was any problem
		 */
		function getBlogFeeds( $blogId, $linkCategoryId = 0 )
		{
			// get the mylinks objects for the blog
			$myLinks = new MyLinks();
			$blogLinks = $myLinks->getLinks( $blogId, $linkCategoryId );
			
			// if error, return an empty array
			if( !$blogLinks )
				return Array();
			
			$blogFeeds = Array();
			foreach( $blogLinks as $blogLink ) {
				$feedData = $this->getFeedData( $blogLink );
				if( $feedData )
					array_push( $blogFeeds, $feedData );
			}
			
			return $blogFeeds;
		}
	}
?>