<?php


/**
 * This class calls the gallery embedding functions. 
 *
 * @version 0.1
 * @author Laurent Vauthrin
 */
class GalleryHelper 
{
    /**
     * @private
     */
    var $_absolutePath;
    var $_embedUri;
    var $_embedPath;
    var $_relativePath;
    var $_title;
    var $_css;
    var $_javascript;
    var $_body;
    var $_error;

    /**
     * Constructor used to make a request to Gallery
     *
     * @param $absolutePath Path to the gallery application
     * @param $embedUri File to plog main file
     * @param $embedPath Path to document root from pLog
     * @param $relativePath Path to gallery from pLog
     * @return None.
     */
    function GalleryHelper( $absolutePath,
			    $embedUri,
                            $embedPath,
                            $relativePath )
    {

	$this->_absolutePath = $absolutePath;
	$this->_embedUri = $embedUri;
	$this->_embedPath = $embedPath;
	$this->_relativePath = $relativePath;
    }

    /**
     * Function which retrieves your galleries
     *
     * @param $sidebarEnabled Boolean used to show/hide the side bar
     * @param $sidebarGreetingEnabled Boolean used to show/hide the side greeting
     * @param $pathbarEnabled Boolean used to show/hide the path bar
     * @return Error object or Gallery HTML.
     */
    function getGallery( $sidebarEnabled,
			 $sidebarGreetingEnabled,
			 $pathbarEnabled )
    {
	require_once( $this->_absolutePath );

	// Set up the gallery call
        $ret = GalleryEmbed::init( array( 'embedUri' => $this->_embedUri,
					  'g2Uri' => $this->_relativePath,
					  'loginRedirect' => '/index.php',
                                          'activeUserId' => '' ) );

        // Return error details if there is a problem
        if ($ret != null) {
            $this->_error = $ret->getAsHtml();
            return;
        }

        // Set gallery options
        GalleryCapabilities::set( 'showSidebar', $sidebarEnabled );
        GalleryCapabilities::set( 'showSidebarGreeting', $sidebarGreetingEnabled );
        GalleryCapabilities::set( 'showPathbar', $pathbarEnabled );

        // Process the request
        $g2data = GalleryEmbed::handleRequest();

        // Gallery has already sent output (redirect or binary data)
        if ( $g2data['isDone'] ) {
	    exit;
        }

        // Retrieve the html head
        if ( isset( $g2data['headHtml'] ) ) {
            list( $title, $css, $javascript ) = GalleryEmbed::parseHead( $g2data['headHtml'] );
            $this->_title = $title;	    
            $this->_css = $css;
            $this->_javascript = $javascript;
        }
 
        // Tell gallery that you are done
        $ret = GalleryEmbed::done();

        // Check for errors
        if ($ret != null) {
            return $ret->getAsHtml();
        }

        // Retrieve the html body     
        $this->_body = $g2data['bodyHtml'];
    }

    /**
     * Function which retrieve's Gallery's image block
     *
     * @param $blocks Identifies what image you want to see.
     * @param $show Identifies what to display with the image.
     * @param $itemid The Itemd ID of the image to be shown (must specify in blocks).
     * @return Error object or image block HTML.
     */
    function getImageBlock( $blocks,
			    $show,
			    $itemid)

    {
	require_once($this->_absolutePath);

	// Set up the gallery call

	$ret = GalleryEmbed::init( array( 'embedUri' => $this->_embedUri,
					  'g2Uri' => $this->_relativePath,
					  'loginRedirect' => '/index.php',
					  'activeUserId' => '', 
					  'fullInit' => true) ); 
	    
	// Check for errors
        if ($ret != null) {
            return $ret->getAsHtml();
        }

	// Get the image block
        if ( $itemid != "" ) {
	    if (is_numeric($itemid) == false) {
		list($ret, $itemid) = GalleryCoreApi::fetchItemIdByPath($itemid);
	    }
	    list($ret, $g2data) = GalleryEmbed::getImageBlock( array( 'blocks' => $blocks, 
								      'show' => $show,
								      'itemId' => $itemid) );
	} else {
	    list($ret, $g2data) = GalleryEmbed::getImageBlock( array( 'blocks' => $blocks,
								      'show' => $show ) );
	}

	// Check for errors
	if ($ret != null) {
	    return $ret->getAsHtml();
	}

	// Tell gallery that you are done
        $ret = GalleryEmbed::done();
	
	// Check for errors
        if ($ret != null) {
            return $ret->getAsHtml();
        }

	return $g2data;
    }

    /**
     * Accessor function used to retrieve the gallery title
     *
     * @param None.
     * @return Gallery title.
     */
    function getTitle()
    {
        return $this->_title; 
    }

    /**
     * Accessor function used to retrieve the gallery style sheet
     *
     * @param None.
     * @return Gallery style sheet.
     */
    function getCSS()
    {
        return $this->_css; 
    }

    /**
     * Accessor function used to retrieve the gallery javascript
     *
     * @param None.
     * @return Gallery javascript.
     */
    function getJavascript()
    {
        return $this->_javascript; 
    }

    /**
     * Accessor function used to retrieve the actual gallery
     *
     * @param None.
     * @return Gallery body.
     */
    function getBody()
    {
        return $this->_body; 
    }

    /**
     * Accessor function used to retrieve error messages
     *
     * @param None.
     * @return Gallery error message.
     */
    function getError()
    {
        return $this->_error;
    }
}
