<?php

lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

/**
 * Implements the config view for the gallery plugin
 * 
 * @version 0.1
 * @author Laurent Vauthrin
 */
class PluginGalleryConfigView extends AdminPluginTemplatedView {
  
    /**
     * Constructor
     *
     * @param $blogInfo Blog specific information.
     * @return None.
     */
    function PluginGalleryConfigView( $blogInfo ) {
	$this->AdminPluginTemplatedView( $blogInfo, "gallery", "galleryAdmin" );
    }

    /**
     * This function renders the admin view
     *
     * @param None.
     * @return Returns true.
     */
    function render() {
	
	// Get the current gallery plugin settings
	$blogSettings = $this->_blogInfo->getSettings();
	$pluginEnabled = $blogSettings->getValue( "plugin_gallery_enabled" );
	$sidebarEnabled = $blogSettings->getValue( "gallery_sidebar_enabled" );
	$sidebarGreetingEnabled = $blogSettings->getValue( "gallery_sidebarGreeting_enabled" );
	$pathbarEnabled = $blogSettings->getValue( "gallery_pathbar_enabled" );
	$absolutePath = $blogSettings->getValue( "gallery_absolute_path" );
	$embedUri = $blogSettings->getValue( "gallery_embed_uri" );
	$embedPath = $blogSettings->getValue( "gallery_embed_path" );
	$relativePath = $blogSettings->getValue( "gallery_relative_path" );
	$blocks = $blogSettings->getValue( "gallery_blocks" );
	$show = $blogSettings->getValue( "gallery_show" );
	$itemid = $blogSettings->getValue( "gallery_itemid" );
	
	// Export the settings to the template
	$this->setValue( "pluginEnabled", $pluginEnabled );
	$this->setValue( "sidebarEnabled", $sidebarEnabled );
	$this->setValue( "sidebarGreetingEnabled", $sidebarGreetingEnabled );
	$this->setValue( "pathbarEnabled", $pathbarEnabled );
	$this->setValue( "absolutePath", $absolutePath );
	$this->setValue( "embedUri", $embedUri );
	$this->setValue( "embedPath", $embedPath );
	$this->setValue( "relativePath", $relativePath );
        $this->setValue( "blocks", $blocks );
        $this->setValue( "show", $show );
        $this->setValue( "itemid", $itemid );

	parent::render();

	return true;
    }
}
?>
