<?php
lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/gallery/class/gallery/galleryhelper.class.php" );

/**
 * This class creates the view for the embedded gallery.
 *
 * @version 0.1
 * @author Laurent Vauthrin
 */
class PluginGalleryShowView extends PluginTemplatedView 
{
  
    /**
     * Constructor to create a non-cached view
     *
     * @param $blogInfo Blog specific information.
     * @return None.
     */
    function PluginGalleryShowView( $blogInfo ) 
    { 
        $this->PluginTemplatedView( $blogInfo, 
                                    "gallery", 
                                    "galleryShow", 
                                    SMARTY_VIEW_CACHE_DISABLED );
    }

    /**
     * This function renders the gallery view
     *
     * @param None.
     * @return Returns true.
     */
    function render() 
    {
	// Get the current gallery settings
        $blogSettings = $this->_blogInfo->getSettings();
        $pluginEnabled = $blogSettings->getValue( "plugin_gallery_enabled" );
        $sidebarEnabled = $blogSettings->getValue( "gallery_sidebar_enabled" );
        $sidebarGreetingEnabled = $blogSettings->getValue( "gallery_sidebarGreeting_enabled" );
        $pathbarEnabled = $blogSettings->getValue( "gallery_pathbar_enabled" );
	$absolutePath = $blogSettings->getValue( "gallery_absolute_path" );
	$embedUri = $blogSettings->getValue( "gallery_embed_uri" );
	$embedPath = $blogSettings->getValue( "gallery_embed_path" );
	$relativePath = $blogSettings->getValue( "gallery_relative_path" );
  
        // Create a gallery helper object to interact with gallery
        $gallery = new GalleryHelper( $absolutePath,
				      $embedUri,
				      $embedPath,
				      $relativePath);

	$gallery->getGallery($sidebarEnabled,
			     $sidebarGreetingEnabled,
			     $pathbarEnabled);

        // Export values to the template
        $this->setValue( "pluginEnabled", $pluginEnabled );
        $this->setValue( "galleryTitle", $gallery->getTitle() );
        $this->setValue( "galleryCSS", $gallery->getCSS() );
        $this->setValue( "galleryJavascript", $gallery->getJavascript() );
        $this->setValue( "galleryBody", $gallery->getBody() );
        $this->setValue( "galleryError", $gallery->getError() );

        parent::render();

        return true;
    }
}
?>
