<?php
lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/gallery/class/gallery/galleryhelper.class.php" );

/**
 * This class is responsible for initializing the gallery plugin.  The gallery plugin
 * creates one blog action (to display the photo gallery) and two admin actions to change
 * the plugin's settings.  This class also sets up an menu option in the control center. 
 *
 * @version 0.1
 * @author Laurent Vauthrin
 */
class PluginGallery extends PluginBase 
{
    /**
     * @private
     */
    var $_pluginEnabled;

    /**
     * Constructor.
     *
     * @param None.
     * @return None.
     */
    function Plugingallery($source = "") 
    {
        $this->PluginBase($source);

        // Setup the plugin information
        $this->id = "gallery";
        $this->author = "Laurent Vauthrin";
        $this->desc = "Integrates gallery2 into LifeType 1.2.";
        $this->version = "20070405";

        // Setup the locale
        $this->locales = Array( "en_UK" );

		if ($source == "admin")
	    	$this->initAdmin();
		else
		    $this->init();	
    }

	function init()
	{
		// Register the actions
		$this->registerBlogAction( "gallery", "PluginGalleryShowAction" );
	}
    
    function initAdmin()
    {
        // Register the actions
        $this->registerBlogAction( "gallery", "PluginGalleryShowAction" );
        $this->registerAdminAction( "gallery", "PluginGalleryConfigAction" );
        $this->registerAdminAction( "updateGalleryConfig", "PluginGalleryUpdateConfigAction" );

        // Set up the Admin menu options
        $menu =& Menu::getMenu();
        if( !$menu->entryExists( "/menu/controlCenter/embeddedApps" ) ) {
            $this->addMenuEntry( "/menu/controlCenter", "embeddedApps", "", "", true, false );
        }
        $this->addMenuEntry( "/menu/controlCenter/embeddedApps", "Gallery", "?op=gallery", "" );
    }

    /**
     * This function initialites the plugin's default values
     *
     * @param None.
     * @return Returns true.
     */
    function register()
    {
	$blogSettings = $this->blogInfo->getSettings();
	$this->_pluginEnabled = $blogSettings->getValue( "plugin_gallery_enabled" );
 
        return true;
    }

    /**
     * This function gets Gallery's image block
     *
     * @param
     * @return Returns error or image block.
     */
    function getImageBlock() 
    {
	// Get the necessary blog settings
	$blogSettings = $this->blogInfo->getSettings();
	$absolutePath = $blogSettings->getValue( "gallery_absolute_path" );
	$embedUri = $blogSettings->getValue( "gallery_embed_uri" );
	$embedPath = $blogSettings->getValue( "gallery_embed_path" );
	$relativePath = $blogSettings->getValue( "gallery_relative_path" );
	$blocks = $blogSettings->getValue( "gallery_blocks" );
	$show = $blogSettings->getValue( "gallery_show" );
	$itemid = $blogSettings->getValue( "gallery_itemid" );

        // Create a gallery helper object to interact with gallery
        $gallery = new GalleryHelper( $absolutePath,
                                      $embedUri,
                                      $embedPath,
                                      $relativePath);
	
	if ( $blocks == "" ) {
	    $blocks = "randomImage";
	}
	if ( $show == "" ) {
	    $show = "none";
	}

	// Get the image block
        return $gallery->getImageBlock($blocks,
				       $show,
				       $itemid);
    }

    /**
     * Accessor function used to determine if the plugin is enabled.
     *
     * @param None.
     * @return A boolean value that tells whether the plugin is enabled or disabled.
     */
    function isEnabled() 
    {
        return $this->_pluginEnabled;
    }
}
?>
