<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Generates all sorts of feeds from our resources. This plugin is perfect for generating
     * RSS 2.0 feeds with enclosures, for example
     */
    class PluginGalleryFeeds extends PluginBase
    {
    
        function PluginGalleryFeeds()
        {
            $this->PluginBase();
            
            $this->id = "galleryfeeds";
            $this->desc = "Generates feeds/playlists based on the contents of albums";
            $this->author = "The LifeType Project";
            $this->version = "20070226";
            
            // register a new action for us
            $this->registerBlogAction( "generateGalleryFeed", "GenerateFeedAction" );
        }
        
        /**
         * Given a GalleryAlbum object, this will automatically genereate the right link to the
         * SMIL playlist, so that we don't have to manually type the same URL every time with
         * only one different parameter
         *
         *@param album A GalleryAlbum obejct
         * @param feedType The type of feed that we're trying to generate. Defaults to "rss20".
         * @return a string
         */
        function feed( $album, $feedType = "rss20" )
        {
            $rg =& $this->blogInfo->getBlogRequestGenerator();
            $blogId = $this->blogInfo->getId();
            $albumId = $album->getId();
            $smilPage = $rg->getIndexUrl()."?op=generateGalleryFeed&amp;blogId={$blogId}&amp;albumId={$albumId}&amp;feed={$feedType}";
            
            return( $smilPage );
        }
    }
?>