<?php

/**
 * Please change this before running this file
 */
define( "PLOG_CLASS_PATH", "/Users/oscar/lifetype-1.2/" );

/**
 * current LT version
 */
define( "LIFETYPE_VERSION", "1.2" );

include_once( PLOG_CLASS_PATH."class/bootstrap.php" );
lt_include( PLOG_CLASS_PATH."class/misc/glob.class.php" );
lt_include( PLOG_CLASS_PATH."class/file/file.class.php" );

class SvnRepository
{
	var $_url;
	
	function SvnRepository( $url )
	{
		$this->_url = $url;
	}
	
	function getUrl()
	{
		return( $this->_url );
	}
}

class SvnClient 
{
	var $_r;
	
	function SvnClient( $repository )
	{
		$this->_r = $repository;
		
		$this->_svn = $this->_findSvnClient();
	}
	
	/**
	 * @private
	 */
	function _findSvnClient()
	{
		$folders = Array(
			"/usr/bin/svn",
			"/usr/local/bin/svn"
		);
		
		foreach( $folders as $path ) {
			if( File::isReadable( $path )) 
				return( $path );
		}
		
		return( "svn" );
	}
	
	function checkOut( $path, $dest = "" )
	{
		$cmd = $this->_svn." co ".$this->_r->getUrl().$path." ".$dest;
		
		$result = exec( $cmd, $output, $code );
		
		return( $code == 0 );
	}
	
	function export( $path, $dest = "" )
	{
		$cmd = $this->_svn." export ".$this->_r->getUrl().$path." ".$dest;
		
		$result = exec( $cmd, $output, $code );
		
		return( $code == 0 );		
	}
}

class PluginFeedWriter
{
	var $_dest;
	
	function PluginFeedWriter( $dest )
	{
		$this->_dest = $dest;
		
		// open the file
		$this->_out = new File( $this->_dest );
		$this->_out->open( "w+" );
	}
	
	function open()
	{
		// header
		$this->_out->write( "<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>\n");
		$this->_out->write( "<rss version=\"2.0\" xmlns:lt=\"http://www.lifetype.net\">\n" );
		$this->_out->write( "<channel>\n");
		$this->_out->write( "<title>Lifetype plugin feed</title>\n" );
		$this->_out->write( "<link>http://www.lifetype.net</link>\n" );
		$this->_out->write( "<description>This feed lists all the plugins available, their version and download link</description>\n" );		
	}
	
	function writePluginInfo( $plugin, $data )
	{
		$this->_out->write( "<item>\n" );
		$this->_out->write( "<title>".$plugin."</title>\n" );
		$this->_out->write( "<link>".$data["url"]."</link>\n" );
		$this->_out->write( "<author>".htmlentities($data["author"])."</author>\n" );
		$this->_out->write( "<description>".$data["description"]."</description>\n" );
		$this->_out->write( "<lt:version>".$data["version"]."</lt:version>\n" );
		$this->_out->write( "</item>\n" );		
	}
	
	function close()
	{
		$this->_out->write( "</channel>\n" );
		$this->_out->write( "</rss>\n" );
		$this->_out->close();		
	}
}

// check that the amount of parameters is correct
if( count( $argv ) < 3 ) {
	die( "Usage: genpluginfeeds.php svnfolder destfile\n" );
}

// get the data from the command line
$svnFolder = $argv[1];
$feedFile = $argv[2];

// use svn to check files out
$repo = new SvnRepository( "http://devel.lifetype.net/svn/plog" );
$svn = new SvnClient( $repo );
if( !$svn->checkOut( $svnFolder )) {
	die("There was a problem while checking out data from the Subversion repository" );
}

// intialize the feed writer
$w = new PluginFeedWriter( $feedFile );
$w->open();

$files = Glob::Glob( basename( $svnFolder ));
foreach( $files as $file ) {
	
	// get the plugin name
	$pluginName = basename( $file );
	
	// ignore those that are not folders, the 'unported' folder and some more
	if( !is_dir( $file ) || $pluginName == "unported" || $pluginName == "bin" )
		continue;
	
	// load the plugin file and try to extract some information from it...
	$f = new File( $file."/plugin{$pluginName}.class.php" );
	$f->open( "r" );

	$contents = $f->readFile();
	
	// try to find the 'version' lines
	$found = false;
	$i = 0;
	$version = "";
	while( !$found && $i < count( $contents )) {
		if( $res = preg_match( '/\$this->version *= *["\'](.*)["\'];/i', $contents[$i], $matches )) {
			$found = true;
			$version = $matches[1];
		}
		
		if( $res = preg_match( '/\$this->author *= *["\'](.*)["\'];/i', $contents[$i], $matches )) {
			$author = $matches[1];
		}		
		
		$i++;
	}
	
	if( !$found ) {
		$version = "not found";
	}

	$data["version"] = $version;
	$data["url"] = "http://downloads.sourceforge.net/lifetype/".LIFETYPE_VERSION."_{$pluginName}.zip";
	$data["author"] = $author;
	$data["description"] = "Plugin $pluginName - version $version";
	
	$w->writePluginInfo( $pluginName, $data );	
}

// close the feed writer
$w->close();
?>