<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Mostra un avatar a cada comentari descarregant-lo de Gravatar.com. Versi 0.2
     */

    define( "AVATAR_FILE_PATH", PLOG_CLASS_PATH."/plugins/gravatar/avatars/" );

    class PluginGravatar extends PluginBase
    {
        var $pluginEnabled;
        var $rating;
        var $default;
        var $size;

        function PluginGravatar( $source = "" )
        {
            $this->PluginBase( $source );

            $this->id = "gravatar";            
            $this->author = "Original by Dani Armengol, Modified by Mark Wu";
            $this->desc = "Returns the URL of an (gr)avatar for every comment. The image is loaded from Gravatar.com";
            $this->version = "20070302";

            $this->init();            
        }
        
		function init()
		{
            if( $this->getSource() == "admin") {
                $this->registerAdminAction( "gravatar", "PluginGravatarConfigAction" );
                $this->registerAdminAction( "updateGravatarConfig", "PluginGravatarUpdateConfigAction" );
			
                $menu =& Menu::getMenu();
                if( !$menu->entryExists("/menu/controlCenter/manageAppearancePlugins" ))
                    $this->addMenuEntry("/menu/controlCenter", "manageAppearancePlugins",
                                         "", "", true, false );
                $this->addMenuEntry("/menu/controlCenter/manageAppearancePlugins",
                                     "Gravatar", "?op=gravatar", "" );
            }
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_gravatar_enabled" );
		    $this->rating = $blogSettings->getValue( "plugin_gravatar_rating" );
	        $this->default = $blogSettings->getValue( "plugin_gravatar_default" );
	        $this->size = $blogSettings->getValue( "plugin_gravatar_size", 40 );	
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

	    function getSize()
	    {
	        return $this->size;
	    } 	       

        /**
         * Returns the gravatar object from www.gravatar.com
         */
         
        function gravatar($comment, $rating="", $default = "", $size="" )
        {
			if ( $rating == "") {
			    $rating = $this->rating;
			} else {
			    if ( $rating != "G" && $rating != "PG" && $rating != "R" && $rating != "X" )
			        $rating = "G";
			}

			if ( $default == "" ) {
			    $rg = $this->blogInfo->getBlogRequestGenerator();
				$default = $rg->getUrl( "/plugins/gravatar/avatars/".$this->default);
            }
			
			if ( $size == "") {
			    $size = $this->size;
			} else {
			    if ( $size < 30 || $size > 80)
			        $size = 40;
			
			}          
                
            if($comment->getUserEmail() != "")
            {
	            $gravatar_url = "http://www.gravatar.com/avatar.php?rating=".$rating."&amp;gravatar_id=".md5($comment->getUserEmail())."&amp;default=".urlencode($default)."&amp;size=".$size;
            } else {
	            $gravatar_url = $default;
            }

            return $gravatar_url;
        }

		/**
		 * Settings supported by this plugin
		 */
		function getPluginConfigurationKeys()
		{
			lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
			
			return( Array(
			  Array( "name" => "plugin_gravatar_enabled", "type" => "boolean" ),
			  Array( "name" => "plugin_gravatar_rating", "type" => "list", "options" => Array( "G" => "G", "PG" => "PG", "R" => "R", "X" => "X" )),			
			  Array( "name" => "plugin_gravatar_size", "type" => "list", "options" => Array( "30" => "30", "40" => "40", "50" => "50", "60" => "60", "70" => "70", "80" => "80" )),
			  Array( "name" => "plugin_gravatar_default", "type" => "list", "options" => Array( "baby.jpg" => "baby.jpg", "bigson.jpg" => "bigson.jpg", "daughter.jpg" => "daughter.jpg", "default.jpg" => "default.jpg", "father.jpg" => "father.jpg", "mother.jpg" => "mother.jpg" ))
			));			
		}
    }
?>
