<?php

	lt_include( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );

    // custom error code that will be returned to the pipeline whenever an
    // error is found... Be careful so as to not to have two different modules
    // use the same code!!

    /**
     * Filters the text posted in a comment by a user, to prevent spam-bots. This
     * filter only works if the incoming request has the "op" parameter as
     * "AddComment", because then it means that we're posting a comment. If it's not
     * like that, then we'll quit. Otherwise, the process will continue as normally.
     */
    define( "HIDDEN_INPUT_MATCH_FOUND", 700 );
     
	class HiddenInputFilter extends PipelineFilter 
	{

    	function HiddenInputFilter( $pipelineRequest )
        {
        	$this->PipelineFilter( $pipelineRequest );
        }

        function filter()
        {
        	// get some info
            $blogInfo = $this->_pipelineRequest->getBlogInfo();
            $request  = $this->_pipelineRequest->getHttpRequest();

        	// check if this section has been enabled or disabled
            $blogSettings = $blogInfo->getSettings();
            $locale = $blogInfo->getLocale();
		    $pluginEnabled = $blogSettings->getValue( "plugin_hiddeninput_enabled" );
            if( !$pluginEnabled) {
            	// if not, nothing to do here...
                //_debug("ip address filter not enabled! quitting...<br/>");
            	return new PipelineResult();
            }

            // we only have to filter the contents if the user is posting a comment
            // so there's no point in doing anything else if that's not the case
            if( $request->getValue( "op" ) != "AddComment" ) {
            	return new PipelineResult();
            }

            // if this is already rejected, there is no reason to do anything here
            if ( $this->_pipelineRequest->getRejectedState() )
                return new PipelineResult();
                
			$hiddenFields = $blogSettings->getValue( "plugin_hiddeninput_hiddenfields" );
		    $hiddenFieldsList = explode(",", $hiddenFields);            
            
            lt_include(PLOG_CLASS_PATH."plugins/hiddeninput/class/dao/hiddeninput.class.php");
            foreach( $hiddenFieldsList as $hiddenField ) {
                $hiddenField = trim($hiddenField);
            	$commentHiddenField = $request->getValue($hiddenField);
                if($commentHiddenField != HiddenInput::generateValue($blogSettings, $hiddenField)){
                	// if there is a match, we can quit and reject this request
                    $result = new PipelineResult( false, HIDDEN_INPUT_MATCH_FOUND, $locale->tr("error_hiddeninput_field_missing"));
                    return $result;
                }                                                    
            }

            // if everything went fine, we can say so by returning
            // a positive PipelineResult object
            $result = new PipelineResult( true );
            
            return $result;
        }
    }
?>
