<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/hostblock/class/dao/blockedhosts.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/hostblock/class/view/admineditblockedhostview.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/hostblock/class/view/adminblockedhostsview.class.php" );      

    /**
     * Changes the settings of a blocked host
     */
    class AdminEditBlockedHostAction extends AdminAction
    {

    	var $_hostId;

    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminEditBlockedHostAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );

            $this->requirePermission( "manage_admin_plugins" );            

			// data validation stuff
			$this->registerFieldValidator( "hostId", new IntegerValidator());
			$view = new AdminBlockedHostsView( $this->_blogInfo );
			$view->setErrorMessage( $this->_locale->tr("error_incorrect_host_id") );
			$this->setValidationErrorView( $view );             	
        }

        /**
         * Carries out the specified action
         */
        function perform()
        {
        	// fetch the data
        	$this->_hostId = $this->_request->getValue( "hostId" );

        	$blockedHosts = new BlockedHosts();
            $blockedHost = $blockedHosts->getBlockedHost( $this->_hostId );

            // check if the info about the blocked host is correct
            if( !$blockedHost ) {
            	$this->_view = new AdminBlockedHostsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_fetching_blocked_host"));
                $this->setCommonData();

            	return false;                
            }

            // if so, continue
            $this->_view = new AdminEditBlockedHostView( $this->_blogInfo, $this->_hostId );

            $this->setCommonData();

            // better to return true if everything fine
            return true;
        }
    }
?>
