<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PluginHttpBL extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginHttpBL( $source = "" )
		{
			$this->PluginBase( $source );

			$this->id      = "httpbl";
			$this->desc    = "http:BL checks your comments against the Project Honeypot's http:BL.";
			$this->author  = "Paul Westbrook ";
			$this->locales = Array( "en_UK" );
            $this->version = "200707014";

			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
		}

        function init()
        {
            lt_include( PLOG_CLASS_PATH."plugins/httpbl/class/security/httpblfilter.class.php" );
            //register the filter
            $this->registerFilter( "HttpBLFilter" );
        }
        
		function initAdmin()
		{
            $this->init();

            $this->registerAdminAction( "httpbl", "PluginHttpBLConfigAction" );
			$this->registerAdminAction( "updateHttpBLConfig", "PluginHttpBLUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "httpbl", "?op=httpbl", "" );            
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_httpbl_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function getPluginConfigurationKeys()
		{
			lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
			lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
			
			return( Array(
				Array( "name" => "plugin_httpbl_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_httpbl_api_key", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
				Array( "name" => "plugin_httpbl_max_stale", "validator" => new IntegerValidator(), "type" => "string", "allowEmpty" => true ),
			));
		}

	}
?>