<?php

	lt_include( PLOG_CLASS_PATH."class/action/blogaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/karma/class/karma/karmalib.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/errorview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/net/client.class.php" );
	lt_include( PLOG_CLASS_PATH."class/template/cachecontrol.class.php" );

	class KarmaRateAction extends BlogAction
	{
	
		var $_blogId;
		var $_articleId;
		var $_mode;
	
		function KarmaRateAction( $actionInfo, $request )
		{
			$this->BlogAction( $actionInfo, $request );
		}		
		
		function validate()
		{
			// we need the following parameters:
			// blogId
			// articleId
			// mode=1 or 2, where 1 means positive vote and 2 means negative vote

			$this->_blogId = $this->_blogInfo->getId();
			$this->_articleId = $this->_request->getValue( "articleId" );
			$this->_mode = $this->_request->getValue( "mode" );
			
			// check if they're valid
			$val1 = new IntegerValidator();
			if( !$val1->validate( $this->_blogId )) {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", $this->_locale->tr("error_karma_blogid_not_valid") );
				$this->setCommonData();
				
				return false;
			}
				
			$val2 = new IntegerValidator();
			if( !$val2->validate( $this->_articleId )) {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", $this->_locale->tr("error_karma_articleid_not_valid") );
				$this->setCommonData();
				
				return false;
			}
			
			$val3 = new IntegerValidator();
			if( !$val3->validate( $this->_mode )) {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", $this->_locale->tr("error_karma_modeid_not_valid") );
				$this->setCommonData();
				
				return false;
			}
				
			// check if the article exists and belongs to the given blog
			$articles = new Articles();
			$this->_article = $articles->getBlogArticle( $this->_articleId, $this->_blogId );
			if( !$this->_article ) {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", $this->_locale->tr("error_karma_article_not_exist") );
				$this->setCommonData();
				
				return false;
			}
			
			return true;
		}
						
		function perform()
		{
			$karmas = new KarmaScores();
		
			// fetch the blog settings, because it might be that the plugin has been disabled!
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_karma_enabled" );
			$pluginTrackVoters = $blogSettings->getValue( "plugin_karma_track_voters" );
			$negativeThreshold = $blogSettings->getValue( "plugin_karma_negative_threshold" );
			if( $negativeThreshold == "" ) $negativeThreshold = PLUGIN_KARMA_DEFAULT_NEGATIVE_THRESHOLD;
			$pluginCoefficient = $blogSettings->getValue( "plugin_karma_scoring_coefficient" );
			if( $pluginCoefficient == "" ) $pluginCoefficient = PLUGIN_KARMA_DEFAULT_COEFFICIENT;
			// try to record the vote
			if( $pluginEnabled ) {
				$clientIp = Client::getIp();
				if( $pluginTrackVoters ) {
					$karmaVoters = new KarmaVoters();
					if( $karmaVoters->clientHasVoted( $clientIp, $this->_articleId )) {
						$voteAllowed = false;
						$this->_view = new ErrorView( $this->_blogInfo );
						$message = $this->_locale->tr("error_karma_vote_per_article");
						$this->_view->setValue( "message", $message );
						$this->setCommonData();
						
						return true;
					}
					else {
						$voteAllowed = true;
						// and store a vote
						$karmaVoters->storeClientVote( $clientIp, $this->_articleId );
					}
				}
				else {
					$voteAllowed = true;
				}
				
				// if we're allowing the user to vote...
				if( $voteAllowed )
					$result = $karmas->recordVote( $this->_articleId, $this->_blogId, $this->_mode );
			}
			else {
				// if we don't set this to true, it will generate an error
				$result = true;
			}
			
			// and check how it went
			if( !$result ) {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", $this->_locale->tr("error_karma_storing_vote") );
				$this->setCommonData();
			}

			// see if the post has to be moderated down
			$disableModeratedDown = $blogSettings->getValue( "plugin_karma_disable_negative_articles" );
			if( $disableModeratedDown ) {
				// we have to disable this article
				$articles = new Articles();
				$article = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId());
				// get the score
				$positiveScore = $article->getField( "positiveKarma" );
				$negativeScore = $article->getField( "negativeKarma" );
				if( KarmaScoreLogic::karmaScore( $positiveScore, $negativeScore, $negativeThreshold, $pluginCoefficient ) == KARMA_SCORE_MODERATE_DOWN ) {
					// check if the post has to be moderated down
					if( $article->getStatus() != POST_STATUS_KARMA_MODERATED_DOWN ) {
						$article->setStatus( POST_STATUS_KARMA_MODERATED_DOWN );
						$articles->updateArticle( $article );
					}
				}
				else {
					// maybe it has to be moderated up!!
					if( $article->getStatus() != POST_STATUS_PUBLISHED ) {
						$article->setStatus( POST_STATUS_PUBLISHED );
						$articles->updateArticle( $article );
					}						
				}
				// move the action flow to "ViewArticle" if the article is moderated up... if not, then
				// we have to use an alternative action
				if( $article->getStatus() == POST_STATUS_PUBLISHED )
					BlogController::setForwardAction( "ViewArticle" );
				else
					BlogController::setForwardAction( "viewModeratedDownArticle" );

			    // clear the cache
			    CacheControl::resetBlogCache( $this->_blogInfo->getId());	

				// and return everything normal
				return true;		
			} else {
                // if moderated down disable, we just need to call the normal view article action
				BlogController::setForwardAction( "ViewArticle" );

			    // clear the cache
			    CacheControl::resetBlogCache( $this->_blogInfo->getId());	

				// and return everything normal
				return true;				    
			}
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());	
			
			return true;
		}	
	}
?>