<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/karma/class/karma/karmalib.class.php" );

	/**
	 * implements the main view of the feed reader plugin
	 */
	class AdminKarmaPluginSettingsView extends AdminPluginTemplatedView
	{

		function AdminKarmaPluginSettingsView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "karma", "pluginsettings" );
		}
		
		function render()
		{
			// load some configuration settings
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_karma_enabled" );
            $disableNegative = $blogSettings->getValue( "plugin_karma_disable_negative_articles" );
            $negativeThreshold = $blogSettings->getValue( "plugin_karma_negative_threshold" );
            if ($negativeThreshold == "") $negativeThreshold = PLUGIN_KARMA_DEFAULT_NEGATIVE_THRESHOLD;
            $trackVoters = $blogSettings->getValue( "plugin_karma_track_voters" );
            $scoring = $blogSettings->getValue( "plugin_karma_scoring_coefficient" );
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "disableNegative", $disableNegative );	
			$this->setValue( "negativeThreshold", $negativeThreshold );	
			$this->setValue( "trackVoters", $trackVoters );	
			$this->setValue( "scoring", $scoring );	
			
			parent::render();
		}
	}
?>