<?php

    lt_include( MOBILE_PLOG_CLASS_PATH."class/view/mobileview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/pager/pager.class.php" );
    
    class MobileDefaultView extends MobileView
    {
    
        var $_page;
    
        function MobileDefaultView( $blogInfo, $tInfo )
        {
            $this->MobileView( $blogInfo, $tInfo, "main" );
        }
        
        function render()
        {
            // load the current page
            $this->_page = $this->getCurrentPageFromRequest();
        
            // load some posts
            $articles = new Articles();
            $blogArticles = $articles->getBlogArticles( $this->_blogInfo->getId(),
                                                        -1,
                                                        $this->_tInfo->getNumItemsPerPage(),
                                                        0,
                                                        POST_STATUS_PUBLISHED,
                                                        0,
                                                        0,
                                                        "",
                                                        $this->_page );
            // number of articles
            $numPosts = $articles->getNumBlogArticles( $this->_blogInfo->getId(), // blog id
                                                        -1, // date
                                                        0, // category id
                                                        POST_STATUS_PUBLISHED, // status
                                                        0, // user id
                                                        0, // max date
                                                        "" ); // search terms

            // pass them to the template
            $this->setValue( "posts", $blogArticles );
            
            // create the pager and pass it to the template too
            $murl = new MobileRequestGenerator( $this->_blogInfo );            
            $pager = new Pager( $murl->getMobileUrl()."?op=Default&amp;blogId=".
                                $this->_blogInfo->getId()."&amp;page=",
                                $this->_page,
                                $numPosts,
                                $this->_tInfo->getNumItemsPerPage());
            $this->setValue( "pager", $pager );                                
            
            parent::render();        
        }
    }
?>