<?php

    lt_include( MOBILE_PLOG_CLASS_PATH."class/view/mobileview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/articlecomments.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/pager/pager.class.php" );
    
    class MobileViewArticleView extends MobileView
    {
    
        var $_page;
    
        function MobileViewArticleView( $blogInfo, $tInfo )
        {
            $this->MobileView( $blogInfo, $tInfo, "postandcomments" );
            
            $this->_page = $this->getCurrentPageFromRequest();
        }
        
        function render()
        {
            // load a paginated view of the article comments
            $comments = new ArticleComments();
            $article = $this->getValue( "post" );
            $articleComments = $comments->getPostComments( $article->getId(),
                                                           COMMENT_ORDER_OLDEST_FIRST,
                                                           COMMENT_STATUS_NONSPAM,
                                                           $this->_page,
                                                           $this->_tInfo->getNumItemsPerPage());
            // get the number of comments
            $numComments = $comments->getNumPostComments( $article->getId(),
                                                          COMMENT_STATUS_NONSPAM );
                                                          
            // and finally, generate the pager
            $murl = new MobileRequestGenerator( $this->_blogInfo );
            $pager = new Pager( $murl->getMobileUrl()."?op=ViewArticle&amp;blogId=".
                                $this->_blogInfo->getId()."&amp;articleId=".$article->getId()."&amp;page=",
                                $this->_page,
                                $numComments,
                                $this->_tInfo->getNumItemsPerPage());
                                
            // pass everything to the templates
            $this->setValue( "comments", $articleComments );
            $this->setValue( "pager", $pager );
            
            parent::render();
        }
    }
?>