<?php

/**
 * known headers so far
 *
 * Opera 6.20 / Nokia7610
 *      Mozilla/4.1 (compatible; MSIE 5.0; Symbian OS; Nokia 7610;451) Opera 6.20  [en]
 *
 *
 * How to add new terminal definitions: create an array with the following values:
 *
 *  - regexp: The regular expression that will be applied agains the User-Agent
 *            string of the device. Make sure that it does not collide with any of the
 *            other regexps already defined.
 *  - content: The name of the template folder where terminal-specific templates can be found. 
 *             The folder must exist and be readable in the plugins/mobile/templates/ folder.
 *  - content-type: The "Content-Type" header that will be sent to the device when sending a
 *                  response
 *  - id: The unique identifier assigned to this definition.
 *  - itemsPerPage: The number of items per page that will be displayed (number of posts, number
 *                  of comments, etc) This can be configured on a per-platform basis so that 
 *                  we can reduce the amount of items for WAP platforms, which usually have less
 *                  memory available for pages.
 * - desc: A generic string describing this platform.
 */

$config["terminals"] = Array (

    Array( "regexp" => "/.*Nokia.*/",
           "content" => "html-light",
           "content-type" => "text/html",
           "id" => "nokia",
           "itemsPerPage" => 5,
           "desc" => "Nokia Series60 Browser/Opera" ),
           
    Array( "regexp" => "/.*/",  // please keep this rule always as the last one
           "content" => "html-light",
           "content-type" => "text/html",
           "id" => "default",
           "itemsPerPage" => 5,           
           "desc" => "Any other browser" )
);
?>