<?php
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */
    

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PluginOpenid extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginOpenid( $source = "" )
		{
			$this->PluginBase($source);

			$this->id      = "openid";
			$this->author  = "Paul Westbrook (phpMyID provided by <a href=\"http://siege.org/projects/phpMyID/\">CJ Niemira</a>)";
			$this->desc    = "Plugin to add OpenID support to LifeType.";
            $this->version = "20070302";

			$this->locales = Array( "en_UK");

			if( $source == "admin" )
				$this->initAdmin();
		}

		function initAdmin()
		{
			$this->registerAdminAction( "openidConfig", "PluginOpenidConfigAction" );
			$this->registerAdminAction( "updateOpenidConfig", "PluginOpenidUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageIntegrationPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageIntegrationPlugins", "", "", true, false );			
	        $this->addMenuEntry( "/menu/controlCenter/manageIntegrationPlugins", "openid", "?op=openidConfig", "" );            
		}
 
		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_openid_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function show()
	    {

			$str = '';
	    
            if ($this->isEnabled())
            {
                $rg = $this->blogInfo->getBlogRequestGenerator();

                $str .= '<link rel="openid.server" href="' . $rg->blogLink() . '/OpenID.php">';
                $str .= "\n";
                $str .= '<link rel="openid.delegate" href="' . $rg->blogLink() . '/OpenID.php">';
                $str .= "\n";
             }
	    	return $str;
		}
		
   	    function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_openid_enabled", "type" => "boolean" ),
			));
		}

	}
?>