<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articlecomments.class.php" );

	class PluginRecentCommentsRssView extends PluginTemplatedView
	{
		function PluginRecentCommentsRssView($blogInfo){
			$this->PluginTemplatedView( $blogInfo, "recentcomments", "rss20" );
		}
		
		function render(){
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_recentcomments_enabled" );
			$maxComments = $blogSettings->getValue( "plugin_recentcomments_maxcomments" );
			if($maxComments == "")
                $maxComments = DEFAULT_ITEMS_PER_PAGE;

            $blogComments = array();
            $articleComments = new ArticleComments();
            $blogComments = $articleComments->getBlogComments($this->_blogInfo->getId(),
                                                              COMMENT_ORDER_NEWEST_FIRST,
                                                              COMMENT_STATUS_NONSPAM,
                                                              "",
                                                              1,
                                                              $maxComments);
                 
			$this->setValue("comments", $blogComments);
            $this->setContentType( 'text/xml' );
			parent::render();
		}

    }
?>