<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/recommended/class/view/pluginrecommendedconfigview.class.php" );	
		
	/**
	 * updates the plugin configuration
	 */
	class PluginRecommendedUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_recommendedPosts;
		
		function PluginRecommendedUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
            $this->_recommendedPosts = explode(" ", 
                 $this->_request->getValue( "recommendedPosts" ));

            if(!$this->_recommendedPosts || !$this->_recommendedPosts[0]){
		$this->_recommendedPosts = Array();
            }

            foreach($this->_recommendedPosts as $id){
                if(!ctype_digit($id)){
                  $errors = true;
                  break;
                }
            }
              
            if( $errors ) {
                $this->_view = new PluginRecommendedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("recommended_error_posts"));
                $this->setCommonData();

                return false;                   
            }        	                
			
			return true;
		}
		        
		function perform()
		{
            // // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_recommended_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_recommended_posts", $this->_recommendedPosts );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginRecommendedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;                  
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginRecommendedConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("recommended_settings_saved_ok"));
			$this->setCommonData();	

			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());							
            
            return true;		
		}
	}
?>