<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/related/class/view/pluginrelatedconfigview.class.php" ); 

    $apiKeyValid = true;
    
    class PluginRelatedUpdateConfigAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_numRelatedArticles;
		var $_minWordLength;
		var $_refreshInterval;
		var $_parseBody;
		var $_bannedKeywords;


    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function PluginRelatedUpdateConfigAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{

            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
        

            $this->_numRelatedArticles = $this->_request->getValue( "numArticles" );
            $this->_minWordLength = $this->_request->getValue( "minWordLength" );
            $this->_refreshInterval = $this->_request->getValue( "interval" );
            $this->_parseBody = $this->_request->getValue( "parseBody" );
            $this->_parseBody = ($this->_parseBody != "" );			
            $this->_bannedKeywords = $this->_request->getValue( "bannedKeywords" );

            
            lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
                
            if( $this->_pluginEnabled == true ) {
                if( $this->_numRelatedArticles == "" ) {
                    $this->_view = new PluginRelatedConfigView( $this->_blogInfo );
                    $this->_view->setErrorMessage( $this->_locale->tr("related_missing_num_articles"));
                    $this->setCommonData();
    
                    return false;    
                }
                else {
                    $val1 = new IntegerValidator();
                    if( !$val1->validate( $this->_numRelatedArticles )) {
                        $this->_view = new PluginRelatedConfigView( $this->_blogInfo );
                        $this->_view->setErrorMessage( $this->_locale->tr("related_invalid_num_articles"));
                        $this->setCommonData();
        
                        return false;    
                    }

                }

                
                if( $this->_minWordLength == "" ) {
                    $this->_view = new PluginRelatedConfigView( $this->_blogInfo );
                    $this->_view->setErrorMessage( $this->_locale->tr("related_missing_min_length"));
                    $this->setCommonData();
    
                    return false;                
                }
                else {
                    $val2 = new IntegerValidator();
                    if( !$val2->validate( $this->_minWordLength )) {
                        $this->_view = new PluginRelatedConfigView( $this->_blogInfo );
                        $this->_view->setErrorMessage( $this->_locale->tr("related_invalid_min_length"));
                        $this->setCommonData();
        
                        return false;    
                    }
                }
            }
			return true;
		}
		
        /**
         * Carries out the specified action
         */
        function perform()
        {
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_related_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_related_num_articles", $this->_numRelatedArticles );
            $blogSettings->setValue( "plugin_related_min_word_length", $this->_minWordLength );
            $blogSettings->setValue( "plugin_related_refresh_interval", $this->_refreshInterval );
            $blogSettings->setValue( "plugin_related_extract_keywords_from_body", $this->_parseBody );
            $blogSettings->setValue( "plugin_related_banned_keywords", $this->_bannedKeywords );

            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginRelatedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;                       
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginRelatedConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("related_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());					
            
            return true;		
        }
    }
    
?>
