<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );

    
    // custom error code that will be returned to the pipeline whenever an
    // error is found... Be careful so as to not to have two different modules
    // use the same code!!
    define( "REQUIREEMAIL_SPAM", 810 );

	class RequireEmailFilter extends PipelineFilter 
	{

    	function RequireEmailFilter( $pipelineRequest )
        {
        	$this->PipelineFilter( $pipelineRequest );
        }

        function filter()
        {

        	// get some info
            $blogInfo = $this->_pipelineRequest->getBlogInfo();
            $request  = $this->_pipelineRequest->getHttpRequest();

        	// check if this section has been enabled or disabled
            $blogSettings = $blogInfo->getSettings();
		    $pluginEnabled = $blogSettings->getValue( "plugin_requireemail_enabled" );
            if( !$pluginEnabled) {
            	// if not, nothing to do here...
                //_debug("ip address filter not enabled! quitting...<br/>");
            	return new PipelineResult();
            }

            // we only have to filter the contents if the user is posting a comment
            // so there's no point in doing anything else if that's not the case
            if( $request->getValue( "op" ) != "AddComment" ) {
            	$result = new PipelineResult();
                return $result;
            }

            // if this is already rejected, there is no reason to do anything here
            if ( $this->_pipelineRequest->getRejectedState() )
                return new PipelineResult();
                
            // text and topic of the comment
            $userEmail = $request->getValue( "userEmail" );
            
            if (trim($userEmail) == "") {
                //  Assume that if the user had entered something in this field, that 
                // LifeType has validated the input.
               $locale = $blogInfo->getLocale();
               $result = new PipelineResult( false, REQUIREEMAIL_SPAM, $locale->tr("requireemail_missing_email") );
               return $result;            
            
            }


            // if everything went fine, we can say so by returning
            // a positive PipelineResult object
            $result = new PipelineResult( true );
            
            return $result;
        }

    }
    

?>
