<?php
	
	/**
	 * deals with smileys in disk and so on...
	 */
	class Smileys
	{
        /**
         * tries to detect and load all the different smiley sets that can be found in the
         * smileys folder, so that the user can chose the nicest one :)
		 *
		 * @static
         */
        function scanSmileysFolder()
        {
			lt_include( PLOG_CLASS_PATH."class/file/file.class.php" );		
			lt_include( PLOG_CLASS_PATH."class/misc/glob.class.php" );			
		
            // first of all, find how many folders are available
            $smileyFolders = Glob::glob( SMILEY_FILE_PATH );
            
            $availableSets = Array();
            
            // now, for every folder, we can try to load the properties file with the mappings
            foreach( $smileyFolders as $folder ) {
                $setId = array_pop(explode("/", $folder));
                $filePath = $folder."/emoticons.properties.php";
                if( File::isReadable( $filePath )) {
                    // if the file is readable, load it
                    include( $filePath );
                    $currentSet = Array();
                    $currentSet["description"] = $smileys_description;
                    if( !is_array($smileys)) $smileys = Array();
                    $currentSet["smileys"] = $smileys;
                    $currentSet["id"] = $setId;
                    $availableSets["$setId"] = $currentSet;
                }
            }
            
            return $availableSets;
        }
		
		/**
		 * loads a set of smileys from disk
		 *
		 * @return An array of smileys
		 *@static
		 */
		function loadSmileySet( $setName )
		{
			lt_include( PLOG_CLASS_PATH."class/file/file.class.php" );
		
            // define the path to the smiley file
            $file = SMILEY_FILE_PATH.$setName."/emoticons.properties.php";
            
            // check if the file is readable... if not, then quit
            if( !File::isReadable( $file )) {
                throw( new Exception( "Sorry, could not open smiley file $file" ));
                die();
            }
            
            // otherwise continue
            include( $file );
			
			return $smileys;
		}
		
        /**
         * It will render any smiley in the text to its icon
		 *
		 * @param text
		 * @param smileySet
		 * @static
		 * @return 
         */
        function smileys( $blogInfo, $text, $setName, $smileySet )
        {
			$rg = $blogInfo->getBlogRequestGenerator();
			foreach( $smileySet as $smiley => $icon ) {
				$iconTag = "<img alt=\"$smiley\" src=\"".
							$rg->getUrl( "/plugins/smileys/icons/".$setName."/".$icon."\" />" );
				$text = str_replace( $smiley, $iconTag, $text );
			}
            
            return $text;
        }
	}
?>