<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );	
    
    define( "DEFAULT_SMILEY_SET", "default" );
    
    define( "SMILEY_FILE_PATH", PLOG_CLASS_PATH."/plugins/smileys/icons/" );
	
	/**
	 * base class that registers everything
	 */
    class PluginSmileys extends PluginBase
    {
        var $_smileySet;
        var $_pluginEnabled;
        
        function PluginSmileys( $source = "" )
        {
            $this->PluginBase( $source );
			
			// ---
			// set some information
			// ---
			$this->id = "smileys";
            $this->author = "The LifeType Project";
            $this->desc = "The plugin offer smileys to comments and articles.";
            $this->version = "20070226";

			$this->locales = Array( "en_UK" , "zh_TW" , "zh_CN", "es_ES" );

            $this->init();  
        }

		function init()
		{
            if( $this->getSource() == "admin") {
                    // ---
                    // register two actions for this plugin plus an option in the menu
                    // ---
                $this->registerAdminAction( "smileys", "PluginSmileysConfigAction" );
                $this->registerAdminAction( "updateSmileysConfig", "PluginSmileysUpdateConfigAction" );
			
                    // ---
                    // register two actions for this plugin plus an option in the menu
                    // ---
                $menu =& Menu::getMenu();
                if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))						
                    $this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "", "" );			
                $this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "Smileys", "?op=smileys", "" );
            }
                
			// ---
			// finally, register the event-based plugin that will finally take care of 
			// 'translating' the smileys
			// ---
			$this->registerNotification( EVENT_POST_LOADED );
			$this->registerNotification( EVENT_POSTS_LOADED );			
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->_pluginEnabled = $blogSettings->getValue( "plugin_smileys_enabled" );
	        $this->_smileySet = $blogSettings->getValue( "plugin_smileys_iconset" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->_pluginEnabled;
	    }		

		function _smileizePost( $post, $smileySet, $smileys )
		{
			lt_include( PLOG_CLASS_PATH."plugins/smileys/class/smileys/smileys.class.php" );
			
			// modify the text...
			$postIntroText = $post->getIntroText();
			$postIntroText = Smileys::smileys( $this->blogInfo, $postIntroText, $smileySet, $smileys );
			$postExtendedText = $post->getExtendedText();
			$postExtendedText = Smileys::smileys( $this->blogInfo, $postExtendedText, $smileySet, $smileys );
			$post->setText( $postIntroText.POST_EXTENDED_TEXT_MODIFIER.$postExtendedText );
			// ...modify the comments...
			$comments = $post->getComments();
			
			// check if there's anything to do with the comments
			if( !is_array($comments)) {
				return $post;
			}
			
			$output = Array();
			foreach( $comments as $comment ) {
				$tmpText = $comment->getText();
				$commentText = Smileys::smileys( $this->blogInfo, $tmpText, $smileySet, $smileys );
				$comment->setText( $commentText );
				array_push( $output, $comment );
			}

			$post->setComments( $output );
			
			return $post;
		}
		
		/**
		 * Receives and processes events
		 *
		 * @param eventType
		 *@param params
		 */
		function process( $eventType, $params )
		{
			lt_include( PLOG_CLASS_PATH."plugins/smileys/class/smileys/smileys.class.php" );				

			// get the objects we need from the parameters array
			$blogInfo = $params[ "blogInfo" ];
			$blogSettings = $blogInfo->getSettings();
		    $pluginEnabled = $blogSettings->getValue( "plugin_smileys_enabled" );
			
            if ( $pluginEnabled != 1 )
                return true;			
			
			$smileySet = $blogSettings->getValue( "plugin_smileys_iconset" );
			if( $smileySet == "" )
				$smileySet = DEFAULT_SMILEY_SET;
				
			// load the set
			$smileys = Smileys::loadSmileySet( $smileySet );
			
			// process the event, as long as it's not coming from the "editPost" action
			// in order to avoid double processing
			if( $eventType == EVENT_POST_LOADED && $params["from"] != "editPost" ) {
				$post = $params[ "article" ];
				$post = $this->_smileizePost( $post, $smileySet, $smileys );
				// ...and finally put everything back together
				$params["article"] = $post;
			}
			elseif( $eventType == EVENT_POSTS_LOADED ) {
			     if( isset( $params["articles"] )) {
                    $posts = $params[ "articles" ];
                    $result = Array();
                    if (count($posts) != 0 ){
                        foreach( $posts as $post ) {
                            $post = $this->_smileizePost( $post, $smileySet, $smileys );
                            array_push( $result, $post );
                        }
                    }
                    $params[ "articles" ] = $result;
				}
			}
			
			//return $params;
			
			return true;
		}

        function generateSmileysBar()
        {
			lt_include( PLOG_CLASS_PATH."plugins/smileys/class/smileys/smileys.class.php" );		
		
            if( $this->_pluginEnabled ) {
			    // load the set
			    $smileys = Smileys::loadSmileySet( $this->_smileySet );
			                
                $text = "";
                $rg = $this->blogInfo->getBlogRequestGenerator();
                $prevIcon = "";
                $currentIcon = "";
                foreach( $smileys as $smiley => $icon ) {
                    $currentIcon = $icon;
                    if ($currentIcon != $prevIcon) {
                        $iconTag = "<img style=\"vertical-align:middle;\" onClick=\"writeImgTag('".addslashes($smiley)."')\" alt=\"".$smiley."\" title=\"".$smiley."\" src=\"".
                                    $rg->getUrl( "/plugins/smileys/icons/".$this->_smileySet."/".$icon."\" />" );
                        $text .= $iconTag;
                        $prevIcon = $currentIcon;
                    }
                }
            } else {
                $locale = $this->blogInfo->getLocale();
                $text = $locale->tr("error_smileys_not_enabled");
            }
            
            return $text;
        }

		function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_smileys_enabled", "type" => "boolean" )
			));
		}			
    }
?>