<?php
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    Based on Sociable by Peter Harkins
    http://push.cx/sociable
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */



	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/sociable/class/sociable/sociable.php" );
	lt_include( PLOG_CLASS_PATH."plugins/sociable/class/extra/pluginsociableextrasites.inc.php" );


	class PluginSociable extends PluginBase
	{
		var $pluginEnabled;

		
		function PluginSociable( $source = "" )
		{
			$this->PluginBase($source);

			$this->id      = "sociable";
			$this->author  = "Paul Westbrook";
			$this->desc    = "The Sociable plugin appends links for your readers to use those sites to the end of each of your blog's posts, increasing your potential audience.";
            $this->version = "20070226";

			$this->locales = Array( "en_UK");

			if( $source == "admin" )
				$this->initAdmin();
		}
		
		function initAdmin()
		{
            $this->registerAdminAction( "sociableConfig", "PluginSociableConfigAction" );
			$this->registerAdminAction( "updateSociableConfig", "PluginSociableUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "sociable", "?op=sociableConfig", "" );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_sociable_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function showCSS()
	    {
			$str = '';
	    
            if ($this->isEnabled())
            {
    
               $rg = $this->blogInfo->getBlogRequestGenerator();

	           $str .=  '<link rel="stylesheet" type="text/css" media="screen" href="' . $rg->getBaseUrl() .'/plugins/sociable/class/sociable/sociable.css" />';
            
            }	
            
            return $str;

	    }
	    
	    
	    function show($postId)
	    {
            global $sociable_builtin_known_sites;
            
            global $sociable_plugin_extra_sites;
        
            
            include( PLOG_CLASS_PATH."plugins/sociable/class/sociable/sociable.php" );
        	include( PLOG_CLASS_PATH."plugins/sociable/class/extra/pluginsociableextrasites.inc.php" );

			$str = '';
	    
            if ($this->isEnabled())
            {
            
                // articles object
                $articles = new Articles;
    
    
                $rg = $this->blogInfo->getBlogRequestGenerator();
				$rg->setXHTML( false );
                $post = $articles->getBlogArticle($postId);
	            $blogSettings = $this->blogInfo->getSettings();
   			    $locale =& $this->blogInfo->getLocale();

                $blogname = urlencode($this->blogInfo->getBlog());
                $permalink = urlencode($rg->postPermalink($post));
                $title = urlencode($post->getTopic());
                
                $str .= '<div class="sociable"><span class="sociable_tagline">';
                $str .= '<strong>' . $locale->tr("tagline")  . '</strong>';
                $str .= '<span>These icons link to social bookmarking sites where readers can share and discover new web pages.</span></span><ul>' . "\n";

		        foreach($sociable_builtin_known_sites as $sitename=>$site)
		        {
                    $siteEnabled = $blogSettings->getValue("plugin_sociable_" . $sitename . "_enabled");
                    $siteEnabled = ($siteEnabled != "");
                    if( !$siteEnabled )
                        continue;
                    
                    $url = $site['url'];
                    $url = str_replace('PERMALINK', $permalink, $url);
                    $url = str_replace('TITLE', $title, $url);
                    $url = str_replace('BLOGNAME', $blogname, $url);
 
                    $str .= "<a href=\"$url\" title=\"$sitename\">";
                    $str .= '<img src="'. $rg->getBaseUrl() .'/plugins/sociable/class/sociable/images/' . $site['favicon'] . '" alt="' . $sitename .'" />';
                    $str .= "</a></li>\n";

                }                

		        foreach($sociable_plugin_extra_sites as $sitename=>$site)
		        {
                    $siteEnabled = $blogSettings->getValue("plugin_sociable_" . $sitename . "_enabled");
                    $siteEnabled = ($siteEnabled != "");
                    if( !$siteEnabled )
                        continue;
                    
                    $url = $site['url'];
                    $url = str_replace('PERMALINK', $permalink, $url);
                    $url = str_replace('TITLE', str_replace("+", "%20", $title), $url);
                    $url = str_replace('BLOGNAME', $blogname, $url);
 
                    $str .= "<a href=\"$url\" title=\"$sitename\">";
                    $str .= '<img src="'. $rg->getBaseUrl() .'/plugins/sociable/class/extra/images/' . $site['favicon'] . '" alt="' . $sitename .'" />';
                    $str .= "</a></li>\n";
                }                
             	$str .= "</ul></div>\n";

             }
	    	return $str;
		}
		
		function showAdmin()
		{
		      global $sociable_builtin_known_sites;
		      
		      global $sociable_plugin_extra_sites;

        	include( PLOG_CLASS_PATH."plugins/sociable/class/sociable/sociable.php" );
            
        	include( PLOG_CLASS_PATH."plugins/sociable/class/extra/pluginsociableextrasites.inc.php" );


		      $str = '';
		      
	           $blogSettings = $this->blogInfo->getSettings();
               $rg = $this->blogInfo->getBlogRequestGenerator();
			   $locale =& $this->blogInfo->getLocale();


		      foreach($sociable_builtin_known_sites as $sitename=>$site)
		      {
		          $str .= '<div class="field">';
		          $str .= '<label for="'. $sitename . '">'.$sitename .'</label>';
                  $str .= '<div class="formHelp">';
                  $str .= '<img src="'. $rg->getBaseUrl() .'/plugins/sociable/class/sociable/images/' . $site['favicon'] . '" alt="' . $sitename .'" />';
                  $str .= '<input class="checkbox" type="checkbox" name="'. strtr($sitename, ".", "_") .'" id="'. strtr($sitename, ".", "_") .'"';
                  
                  $siteEnabled = $blogSettings->getValue("plugin_sociable_" . $sitename . "_enabled");
                  $siteEnabled = ($siteEnabled != "");
                  if ($siteEnabled)
                  {
                      $str .= 'checked="checked"';
                  }
                  $str .= 'value="1" /> '. $locale->tr("label_enable") . ' '.  $sitename;
                  $str .= '  </div>';
                  $str .= '  </div>';
		      }
		      foreach($sociable_plugin_extra_sites as $sitename=>$site)
		      {
		          $str .= '<div class="field">';
		          $str .= '<label for="'. $sitename . '">'.$sitename .'</label>';
                  $str .= '<div class="formHelp">';
                  $str .= '<img src="'. $rg->getBaseUrl() .'/plugins/sociable/class/extra/images/' . $site['favicon'] . '" alt="' . $sitename .'" />';
                  $str .= '<input class="checkbox" type="checkbox" name="'. strtr($sitename, ".", "_") .'" id="'. strtr($sitename, ".", "_") .'"';
                  
                  $siteEnabled = $blogSettings->getValue("plugin_sociable_" . $sitename . "_enabled");
                  $siteEnabled = ($siteEnabled != "");
                  if ($siteEnabled)
                  {
                      $str .= 'checked="checked"';
                  }
                  $str .= 'value="1" /> '. $locale->tr("label_enable") . ' '.  $sitename;
                  $str .= '  </div>';
                  $str .= '  </div>';
		      }
		      
		      return $str;
		}
	}
?>