<?php

    lt_include( PLOG_CLASS_PATH."class/action/blogaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/textfilter.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfields.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfieldsvalues.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
    
    /**
     * Checks an incoming submission and adds it to the database if all is correct
     */
    class AddSubmissionAction extends BlogAction
    {
        var $_userName;
        var $_userEmailAddress;
        var $_topic;
        var $_text;
        var $_categoryIds;
    
        function ShowSubmissionFormAction( $actionInfo, $request )
        {
            $this->BlogAction( $actionInfo, $request );
        }
        
        function validate()
        {
            $errors = false;
        
            // these two are optional
            $this->_userName = $this->_request->getValue( "userName" );
            $this->_userEmailAddress = $this->_request->getValue( "userEmailAddress" );
            
            // these ones are mandatory, of course...
            $this->_topic = $this->_request->getValue( "submissionTopic" );
            $val1 = new StringValidator();
            if( !$val1->validate( $this->_topic )) {
                $errors["submissionTopic"] = true;
                $message["submissionTopic"] = $this->_locale->tr("error_submission_no_topic");
            }
            
            $this->_text = $this->_request->getValue( "submissionText" );
            $val2 = new StringValidator();
            if( !$val2->validate( $this->_text )) {
                $errors["submissionText"] = true;
                $message["submissionText"] = $this->_locale->tr("error_submission_no_text");
            }
            
            $this->_categoryIds = $this->_request->getValue( "submissionCategory" );
            if( !is_array($this->_categoryIds)) {
                $errors["submissionCategory"] = true;
                $message["submissionCategory"] = $this->_locale->tr("error_submission_no_category");          
            }
            
            if( $errors ) {
                $this->_view = new PluginTemplatedView( $this->_blogInfo, "submissions", "submitform", SMARTY_VIEW_CACHE_DISABLED );
                $this->_view->setValue( "userName", $this->_userName );
                $this->_view->setValue( "userEmailAddress", $this->_userEmailAddress );
                $this->_view->setValue( "submissionTopic", $this->_topic );
                $this->_view->setValue( "submissionText", $this->_text );
                $this->_view->setValue( "submissionCategories", $this->_categoryIds );
                $this->_view->setValue( "message", $message );
                $this->_view->setValue( "errors", $errors );
                $this->setCommonData();
                
                return false;
            }
            
            return true;
        }
        
        function perform()
        {
			// add the post to the database, with our new status
			$articles = new Articles();
            $postText = Textfilter::xhtmlize($this->_text);
            $article  = new Article( $this->_topic, 
			                         $postText,
			                         $this->_categoryIds,
                                     $this->_blogInfo->getOwner(), 
									 $this->_blogInfo->getId(), 
									 POST_STATUS_EXTERNAL_SUBMISSION, 
									 0 );
            $article->setDateObject( new Timestamp());
            $article->setCommentsEnabled( true );
			
			// add the custom fields with the information about the submitter
			$customFields = new CustomFields();
			$customFieldValues = new CustomFieldsValues();
			$submittedBy = $customFields->getCustomFieldByName( $this->_blogInfo->getId(), "submittedBy" );
			$submittedByValue = new CustomFieldValue( $submittedBy->getId(), $this->_userName, "", -1, "", -1, $this->_blogInfo->getId(), -1 );
			$submitterAddress = $customFields->getCustomFieldByName( $this->_blogInfo->getId(), "submitterAddress" );
			$submitterAddressValue = new CustomFieldValue( $submitterAddress->getId(), $this->_userEmailAddress, "", -1, "", -1, $this->_blogInfo->getId(), -1 );
			$article->setFields( Array( $submittedByValue, $submitterAddressValue ));
			
			// add the article to the db, finally
			if( $articles->addArticle( $article )) {
				$this->_view = new PluginTemplatedView( $this->_blogInfo, "submissions", "accepted" );
			}
			else {
				$this->_view = new ErrorView( $this->_blogInfo );
				$this->_view->setValue( "message", "Error adding article to the database" );
			}
			
			$this->setCommonData();			
			
            return true;
        }
    }
?>