<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/submissions/class/view/adminsubmissionspluginsettingsview.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfields.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfield.class.php" );	

    class AdminSubmissionsPluginUpdateSettingsAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_htmlareaEnabled;

    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminSubmissionsPluginUpdateSettingsAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );

			$this->requirePermission( "manage_plugins" );
        }
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );
            
            $this->_htmlareaEnabled = $this->_request->getValue( "htmlareaEnabled" );
            $this->_htmlareaEnabled = ($this->_htmlareaEnabled != "" );            
			
			return true;
		}
		
		/**
		 * checks if the fields already exist and if not, creates them
		 */
		function _createFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			// check if the checkbox fields exists
			if( !array_key_exists( "submittedBy", $blogFields )) {
				$customFieldSubmittedBy = new CustomField( "submittedBy", 
				                                           "Submissition sent by",
														   CUSTOM_FIELD_TEXTBOX,
														   $this->_blogInfo->getId(),
														   false,
														   true );
				$customFields->addCustomField( $customFieldSubmittedBy );			
			}
			else {
				$protectedField = $blogFields["submittedBy"];
				$protectedField->setHidden( false );
				$customFields->updateCustomField( $protectedField );
			}
			
			// check if the field for the password exists
			if( !array_key_exists( "submitterAddress", $blogFields )) {
				$customFieldSubmitterAddress = new CustomField( "submitterAddress", 
				                                                "Email address of submitter",
												      		    CUSTOM_FIELD_TEXTBOX,
														        $this->_blogInfo->getId(),
																false,
														        true );
				$customFields->addCustomField( $customFieldSubmitterAddress );
			}
			else {
				$submitterAddress = $blogFields["submitterAddress"];
				$submitterAddress->setHidden( false );
				$customFields->updateCustomField( $submitterAddress );			
			}
			
			return true;
		}
		
		/**
		 * checks if the fields already exist and if so, disables them (sets them to be "hidden")
		 */
		function _updateFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			
			// check if the checkbox fields exists
			if( array_key_exists( "submittedBy", $blogFields )) {
				$protectedField = $blogFields["submittedBy"];
				$protectedField->setHidden( false );
				$customFields->updateCustomField( $protectedField );
			}
			
			// check if the field for the password exists
			if( array_key_exists( "submitterAddress", $blogFields )) {
				$submitterAddress = $blogFields["submitterAddress"];
				$submitterAddress->setHidden( false );
				$customFields->updateCustomField( $submitterAddress );			
			}
			
			return true;
		}		

        /**
         * Carries out the specified action
         */
        function perform()
        {
        	// update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
			$blogSettings->setValue( "plugin_submissions_enabled", $this->_pluginEnabled );
			$blogSettings->setValue( "plugin_submissions_htmlarea_enabled", $this->_htmlareaEnabled );
			$this->_blogInfo->setSettings( $blogSettings );
			
			// update the settings in the db, and make sure that everything went fine
			$blogs = new Blogs();
			if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminSubmissionsPluginSettingsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;   
			}
			
			// check if the fields already exist and if not, create them
			if( $this->_pluginEnabled )
				$this->_createFields();
			else
				$this->_updateFields();
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new AdminSubmissionsPluginSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("submissions_settings_saved_ok"));			
			$this->setCommonData();

			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;
        }
    }
?>