<?php
	
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the tag cloud plugin
	 */
	class PluginTagCloudConfigView extends AdminPluginTemplatedView
	{

		function PluginTagCloudConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "tagcloud", "tagcloud" );
		}
		
		function render()
		{
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_tagcloud_enabled" );
			$maxArticles = $blogSettings->getValue( "plugin_tagcloud_max_articles" );
			if ($maxArticles == "") $maxArticles = 20;
			$maxKeywords = $blogSettings->getValue( "plugin_tagcloud_max_keywords" );
			if ($maxKeywords == "") $maxKeywords = 50;
			$minSize = $blogSettings->getValue( "plugin_tagcloud_min_size" );
			if ($minSize == "") $minSize = .4;
			$maxSize = $blogSettings->getValue( "plugin_tagcloud_max_size" );
			if ($maxSize == "") $maxSize = 3;
			$minWeight = $blogSettings->getValue( "plugin_tagcloud_min_weight" );
			if ($minWeight == "") $minWeight = 100;
			$maxWeight = $blogSettings->getValue( "plugin_tagcloud_max_weight" );
			if ($maxWeight == "") $maxWeight = 900;
			$minWordLength = $blogSettings->getValue( "plugin_tagcloud_min_word_length" );
			if ($minWordLength == "") $minWordLength = 3;
			$bannedKeywords = $blogSettings->getValue( "plugin_tagcloud_banned_keywords" );
			if ($bannedKeywords == "") $bannedKeywords =  implode( ",", array( 'a', 'an', 'the', 'and', 'of', 'i', 'its' , 'to', 'is', 'in', 'with', 'for', 'as', 'that', 'on', 'at', 'this', 'my', 'was', 'our', 'it', 'you', 'we', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '10', 'about', 'after', 'all', 'almost', 'along', 'also', 'amp', 'another', 'any', 'are', 'area', 'around', 'available', 'back', 'be', 'because', 'been', 'being', 'best', 'better', 'big', 'bit', 'both', 'but', 'by', 'c', 'came', 'can', 'capable', 'control', 'could', 'course', 'd', 'dan', 'day', 'decided', 'did', 'didn', 'different', 'div', 'do', 'doesn', 'don', 'down', 'drive', 'e', 'each', 'easily', 'easy', 'edition', 'end', 'enough', 'even', 'every', 'example', 'few', 'find', 'first', 'found', 'from', 'get', 'go', 'going', 'good', 'got', 'gt', 'had', 'hard', 'has', 'have', 'he', 'her', 'here', 'how', 'if', 'into', 'isn', 'just', 'know', 'last', 'left', 'li', 'like', 'little', 'll', 'long', 'look', 'lot', 'lt', 'm', 'made', 'make', 'many', 'mb', 'me', 'menu', 'might', 'mm', 'more', 'most', 'much', 'name', 'nbsp', 'need', 'new', 'no', 'not', 'now', 'number', 'off', 'old', 'one', 'only', 'or', 'original', 'other', 'out', 'over', 'part', 'place', 'point', 'pretty', 'probably', 'problem', 'put', 'quite', 'quot', 'r', 're', 'really', 'results', 'right', 's', 'same', 'saw', 'see', 'set', 'several', 'she', 'sherree', 'should', 'since', 'size', 'small', 'so', 'some', 'something', 'special', 'still', 'stuff', 'such', 'sure', 'system', 't', 'take', 'than', 'their', 'them', 'then', 'there', 'these', 'they', 'thing', 'things', 'think', 'those', 'though', 'through', 'time', 'today', 'together', 'too', 'took', 'two', 'up', 'us', 'use', 'used', 'using', 've', 'very', 'want', 'way', 'well', 'went', 'were', 'what', 'when', 'where', 'which', 'while', 'white', 'who', 'will', 'would', 'your'));
;
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "articles", $maxArticles );
			$this->setValue( "keyword", $maxKeywords );		
			$this->setValue( "minFont", $minSize );
			$this->setValue( "maxFont", $maxSize );
			$this->setValue( "minWeight", $minWeight );
			$this->setValue( "maxWeight", $maxWeight );
			$this->setValue( "bannedKeywords", $bannedKeywords );
			$this->setValue( "minWordLength", $minWordLength );

			parent::render();
		}
	}
?>