<?php

	lt_include( PLOG_CLASS_PATH."class/test/helpers/lifetypetestcase.class.php" );
	lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/bloginfo.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/dao/users.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/userinfo.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/dao/articlecategories.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articlecategory.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/userstatus.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/net/xmlrpc/IXR_Library.lib.php" );
	lt_include( PLOG_CLASS_PATH."class/net/url.class.php" );
	lt_include( PLOG_CLASS_PATH."class/locale/locales.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfields.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfield.class.php" );

	/**
	 * Unit test cases for the technorati plugin
	 */
	class PluginTechnorati_Test extends LifeTypeTestCase
	{
		/**
		 * dummy blog we'll be using during the tests
		 */
		var $blog;
		
		/**
		 * dummy blog owner
		 */
		var $owner;
		
		/**
		 * dummy category
		 */
		var $cat;
		
		/**
		 * URL pointing to this server's xmlrpc.php
		 */
		
		function setUp()
		{
			// create the blog owner
			$this->owner = new UserInfo( md5(time()),   // name
			                             "password",   // password
			                             "whatever@whatever.com",  // email address
			             				 "",    // about
			                             "" );
			$users = new Users();
			if( !$users->addUser( $this->owner )) {
				throw( new Exception( "Error adding test user" ));
				die();
			}
			
			// load a UTF-8 locale
			$zhLocale =& Locales::getLocale( "zh_CN" );
		
			// create the test blog
			$blogs = new Blogs();
			$this->blog = null;
			$this->blog = new BlogInfo( "test blog",
			                            $this->owner->getId(),
			                            "",
			                            new BlogSettings());
			$this->blog->setLocale( $zhLocale );
			if( !$blogs->addBlog( $this->blog )) {
				throw( new Exception( "Error adding test blog!" ));
				die();
			}
			
			// add a default category
			$this->cat = new ArticleCategory( "General", 
			                            "Description for category General",
										$this->blog->getId(),
										true );
			$cats = new ArticleCategories();
			if( !$cats->addArticleCategory( $this->cat )) {
				throw(  new Exception( "Error adding test category!" ));
				die();
			}
			
			
			// Add the custom fields.
			 
			// NOTE: This should really just call the perform method on the
			// Update action
			// (How can you create a actionInfo?)
            $customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->blog->getId());
			
			// check if the checkbox fields exists
			if( !array_key_exists( "technoratiTags", $blogFields )) {
				$customTechnoratiTags = new CustomField( "technoratiTags", 
				                                           "technoratiTags_help",
														   CUSTOM_FIELD_TEXTBOX,
														   $this->blog->getId(),
														   false,
														   true );
				$customFields->addCustomField( $customTechnoratiTags );			
			}
        }
		
		function tearDown()
		{
			$users = new Users();
			$users->deleteUser( $this->owner->getId());
			
			$blogs = new Blogs();
			$blogs->deleteBlog( $this->blog->getId());
			
			$cats = new ArticleCategories();
			$cats->deleteCategory( $this->cat->getId(), $this->blog->getId());
		}

		/**
		 * test the generating url array
		 */
		
		function testGenerateTags()
		{
			// create a new post first
			$article = new Article(
				"topic",
				"text",
				Array( $this->cat->getId()),
				$this->owner->getId(),
				$this->blog->getId(),
				POST_STATUS_PUBLISHED,
				0
				);
			$articles = new Articles();
			$this->assertTrue( $articles->addArticle( $article ), "Unable to add a new test article" );
			
			$customFieldValue = new CustomFieldValue( "technoratiTags",
			                                           "tag1,tag2,tag 3",
			                                           $article->getId(),
			                                           $this->blog->getId() );
			                                           
			$article->setFields( Array( "technoratiTags" => $customFieldValue ) );
			$this->assertTrue( $articles->updateArticle( $article ), "Unable to update test article" );
			                
			// Now make sure the tags are returned
            $pm =& PluginManager::getPluginManager(PLOG_CLASS_PATH."plugins/");	
            $pm->setBlogInfo($this->blog);
            $pm->loadPlugins();
            $plugins = $pm->getPlugins();

			$plugin = $plugins["technorati"];
			$tagArray = $plugin->getTags($article);
			
			// see that the call was successful
			$this->assertEquals( "<a href='http://technorati.com/tag/tag1' rel='tag'>tag1</a>", $tagArray["tag1"], "Wrong tag" );
			$this->assertEquals( "<a href='http://technorati.com/tag/tag2' rel='tag'>tag2</a>", $tagArray["tag2"], "Wrong tag" );
			$this->assertEquals( "<a href='http://technorati.com/tag/tag+3' rel='tag'>tag 3</a>", $tagArray["tag 3"], "Wrong tag" );
			
			$this->assertTrue( $articles->deleteArticle( $article->getId(), $this->owner->getId(), $this->blog->getId(), true ),
			                   "Error deleting article" );
			
  		}
		
		function testGenerateNoTags()
		{
			// create a new post first
			$article = new Article(
				"topic",
				"text",
				Array( $this->cat->getId()),
				$this->owner->getId(),
				$this->blog->getId(),
				POST_STATUS_PUBLISHED,
				0
				);
			$articles = new Articles();
			$this->assertTrue( $articles->addArticle( $article ), "Unable to add a new test article" );
			
			// Now make sure the tags are returned
            $pm =& PluginManager::getPluginManager(PLOG_CLASS_PATH."plugins/");	
            $pm->setBlogInfo($this->blog);
            $pm->loadPlugins();
            $plugins = $pm->getPlugins();

			$plugin = $plugins["technorati"];
			$tagArray = $plugin->getTags($article);
			
			// see that the call was successful
			$this->assertTrue( count($tagArray) == 0, "UnUnexpected tag" );

			$this->assertTrue( $articles->deleteArticle( $article->getId(), $this->owner->getId(), $this->blog->getId(), true ),
			                   "Error deleting article" );
			
  		}
			
	}
?>