<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	
	/**
	 * our custom status for posts
	 */
	
	/**
	 * implements host blocking features
	 */
	class PluginTechnorati extends PluginBase
	{
	    var $pluginEnabled;
	
		function PluginTechnorati( $source = "" )
		{
			$this->PluginBase($source);
			
			$this->id = "technorati";
			$this->desc =<<<EOD
Implements technorati tagging with a custom field.
when posting, just type in your tags seperated by commas like <strong>'tag1, tag2, tag with space, tag4'</strong><br/>
<br/>Place this in your <em>post.template</em>:
<pre>{if \$technorati && \$technorati->isEnabled() }
{assign var="tagString" value=\$technorati->getTags(\$post)}
{foreach name=tags from=\$tagString item=tagLink}
&nbsp;&nbsp;&nbsp;{if \$smarty.foreach.tags.first} technorati tags: {/if}
&nbsp;&nbsp;&nbsp;{\$tagLink}			
&nbsp;&nbsp;&nbsp;{if !\$smarty.foreach.tags.last}, {/if}
{/foreach}{/if}</pre>
EOD;
			
			$this->author = "augur (letch @ augurnovo.com)";
			$this->locales = Array("en_UK" );
            $this->version = "20070226";
			
			if( $source == "admin" )
				$this->initAdmin();
		}
		
		/**
		 * registers all the filters and actions that we're going to use
		 */
		function initAdmin()
		{
			$this->registerAdminAction( "technoratiPluginSettings", "AdminTechnoratiPluginSettingsAction" );
			$this->registerAdminAction( "technoratiUpdateSettings", "AdminTechnoratiPluginUpdateSettingsAction" );			
			
			// add a menu entry pluginTechoratiUpdateSettings
			$this->addMenuEntry( "/menu/Manage/managePosts", "technoratiPluginSettings", "admin.php?op=technoratiPluginSettings", "", true, false );
			
		}
		
		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_technorati_enabled" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }

  		function getTags($post){
			$tagString = $post->getField("technoratiTags");
			$tags = explode( ",", $tagString ); 
			$tagString = Array();
			
			foreach ($tags as $tagName){
				$tagName=trim($tagName);
				if ($tagName!="")
						$tagString[$tagName] ="<a href='http://technorati.com/tag/".urlencode($tagName)."' rel='tag'>".$tagName."</a>";
			}
			
			return $tagString;
		
		}
	}  
?>