<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/data/validator/rules/regexprule.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsitetemplateslistview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsitetemplatesubfolderlistview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/view/pluginsitetemplatesetslistview.class.php" );		

	/**
	 * shows a form with the current configuration
	 */
	class PluginSiteTemplatesListAction extends AdminAction
	{
        var $_templateId;
        var $_subFolderId;
        		
		function PluginSiteTemplatesListAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
			$val = new StringValidator();
			$val->addRule( new RegExpRule( "[a-zA-Z0-9]+" ));
			$this->registerFieldValidator( "templateId", $val );
			$view = new PluginSiteTemplateSetsListView( $this->_blogInfo );
			$view->setErrorMessage( "error_loading_template_file" );
			$this->setValidationErrorView( $view );
			
			$this->requireAdminPermission( "edit_global_templates" );			
		}
		
		function perform()
		{
			// fetch and sanitize parameters
            $this->_templateId = $this->_request->getValue( "templateId" );
			$this->_templateId = str_replace( "/", "", $this->_templateId );
			$this->_templateId = str_replace( "..", "", $this->_templateId );

			// sanitize parameter subFolderId
            $this->_subFolderId = $this->_request->getValue( "subFolderId" );
			$this->_subFolderId = str_replace( "/", "", $this->_subFolderId );
			$this->_subFolderId = str_replace( "..", "", $this->_subFolderId );
            
            if ( empty($this->_subFolderId) ) {
                $this->_view = new PluginSiteTemplatesListView( $this->_blogInfo, $this->_templateId );
            } 
			else {
                $this->_view = new PluginSiteTemplateSubFolderListView( $this->_blogInfo, $this->_templateId, $this->_subFolderId );
            }
            
			$this->setCommonData();
			
			return true;
		}
	}
?>