<?php
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	
	define( "MAX_BACKUP_FILES", 5);
	define( "EDITABLE_EXTENSION", "css,inc,template,txt" );

	class PluginTemplateEditor extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginTemplateEditor( $source )
		{
			$this->PluginBase( $source );

			$this->id      = "templateeditor";
			$this->author  = "Mark Wu";
			$this->desc    = "The plugin offer online template editor function for LifeType";
            $this->version = "20070302";

            $config =& Config::getConfig();
            $this->pluginEnabled = $config->getValue( "plugin_templateeditor_enabled" );

			$this->locales = Array( "en_UK" , "zh_TW" , "zh_CN", "es_ES" );

            if( $source == "admin" )
                $this->init();
		}

		function init()
		{
            $this->registerAdminAction( "siteTemplateSetsList", "PluginSiteTemplateSetsListAction" );
            $this->registerAdminAction( "siteDeleteTemplateSet", "PluginSiteDeleteTemplateSetsAction" );
            $this->registerAdminAction( "siteDeleteTemplateSets", "PluginSiteDeleteTemplateSetsAction" );
            $this->registerAdminAction( "siteCopyTemplateSet", "PluginSiteCopyTemplateSetAction" );
            $this->registerAdminAction( "siteArchiveTemplateSet", "PluginSiteArchiveTemplateSetAction" );
            $this->registerAdminAction( "siteTemplatesList", "PluginSiteTemplatesListAction" );
            $this->registerAdminAction( "siteDeleteTemplateFile", "PluginSiteDeleteTemplateFilesAction" );
            $this->registerAdminAction( "siteDeleteTemplateFiles", "PluginSiteDeleteTemplateFilesAction" );
            $this->registerAdminAction( "siteCopyTemplateFile", "PluginSiteCopyTemplateFileAction" );
            $this->registerAdminAction( "siteEditTemplateFile", "PluginSiteEditTemplateFileAction" );
            $this->registerAdminAction( "siteUpdateTemplateFile", "PluginSiteUpdateTemplateFileAction" );
            $this->registerAdminAction( "siteUploadTemplateFile", "PluginSiteUploadTemplateFileAction" );

            $this->registerAdminAction( "blogTemplateSetsList", "PluginBlogTemplateSetsListAction" );
            $this->registerAdminAction( "blogDeleteTemplateSet", "PluginBlogDeleteTemplateSetsAction" );
            $this->registerAdminAction( "blogDeleteTemplateSets", "PluginBlogDeleteTemplateSetsAction" );
            $this->registerAdminAction( "blogCopyTemplateSet", "PluginBlogCopyTemplateSetAction" );
            $this->registerAdminAction( "blogArchiveTemplateSet", "PluginBlogArchiveTemplateSetAction" );
            $this->registerAdminAction( "blogTemplatesList", "PluginBlogTemplatesListAction" );
            $this->registerAdminAction( "blogDeleteTemplateFile", "PluginBlogDeleteTemplateFilesAction" );
            $this->registerAdminAction( "blogDeleteTemplateFiles", "PluginBlogDeleteTemplateFilesAction" );
            $this->registerAdminAction( "blogCopyTemplateFile", "PluginBlogCopyTemplateFileAction" );
            $this->registerAdminAction( "blogEditTemplateFile", "PluginBlogEditTemplateFileAction" );
            $this->registerAdminAction( "blogUpdateTemplateFile", "PluginBlogUpdateTemplateFileAction" );
            $this->registerAdminAction( "blogUploadTemplateFile", "PluginBlogUploadTemplateFileAction" );
            
            $this->registerAdminAction( "templateEditorConfig", "PluginTemplateEditorConfigAction" );
            $this->registerAdminAction( "updateTemplateEditorConfig", "PluginTemplateEditorUpdateConfigAction" );
			
			$this->addMenuEntry( "/menu/adminSettings/Templates", "SiteTemplateEditor", "admin.php?op=siteTemplateSetsList", "", Array( "edit_global_templates" ), Array(), true );
			$this->addMenuEntry( "/menu/adminSettings/Templates", "TemplateEditorConfig", "admin.php?op=templateEditorConfig", "", Array( "edit_global_templates" ), Array(), true );
			
			if ($this->pluginEnabled) {
			    $this->addMenuEntry( "/menu/controlCenter/manageBlogTemplates", "BlogTemplateEditor", "admin.php?op=blogTemplateSetsList", "", Array( "edit_blog_templates" ), Array(), false );
    	    }
		}

		function register()
		{
			// add our new permission if it doesn't exist yet
			lt_include( PLOG_CLASS_PATH."class/dao/permissions.class.php" );
			$perms = new Permissions();
			if( !$perms->getPermissionByName( "edit_blog_templates" )) {
				$perm = new Permission( "edit_blog_templates", "edit_blog_templates_desc" );
				$perms->addPermission( $perm );
			}
			
			// admin-only permisson to edit global templates
			if( !$perms->getPermissionByName( "edit_global_templates" )) {
				$perm = new Permission( "edit_global_templates", "edit_global_templates_desc" );
				$perm->setAdminOnlyPermission( true );
				$perms->addPermission( $perm );
			}

			return( true );
		}
	}
?>