<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/twitter/class/view/plugintwitterconfigview.class.php" ); 

    
    class PluginTwitterUpdateConfigAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_username;
		var $_password;


    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function PluginTwitterUpdateConfigAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{
			global $apiKeyValid;
	   
        	$apiKeyValid = true;

            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
        
            $this->_username = $this->_request->getValue( "username" );
            $this->_password = $this->_request->getValue( "password" );
     
            if( $this->_pluginEnabled == true && $this->_username == "" ) {
                $this->_view = new PluginTwitterConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("twitter_missing_username"));
                $this->setCommonData();

                return false;                
            }
            
            if( $this->_pluginEnabled == true && $this->_password == "" ) {
                $this->_view = new PluginTwitterConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("twitter_missing_password"));
                $this->setCommonData();

                return false;                
            }
            

			return true;
		}
		
        /**
         * Carries out the specified action
         */
        function perform()
        {
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_twitter_enabled", $this->_pluginEnabled );

            $blogSettings->setValue( "plugin_twitter_username", $this->_username );
            $blogSettings->setValue( "plugin_twitter_password", $this->_password );

            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginTwitterConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;                       
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginTwitterConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("twitter_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());					
            
            return true;		
        }
    }
    

?>
