<?php
	
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );

	/**
	 * implements the main view of the validate trackback plugin
	 */
	class PluginTwitterConfigView extends AdminPluginTemplatedView
	{

		function PluginTwitterConfigView( $blogInfo )
		{
			$this->AdminPluginTemplatedView( $blogInfo, "twitter", "twitter" );
		}
		
		function render()
		{
			// load some configuration settings
			$blogSettings = $this->_blogInfo->getSettings();
			$pluginEnabled = $blogSettings->getValue( "plugin_twitter_enabled" );

			$username = $blogSettings->getValue( "plugin_twitter_username" );
			$password = $blogSettings->getValue( "plugin_twitter_password" );
			
			
			// create a view and export the settings to the template
			$this->setValue( "pluginEnabled", $pluginEnabled );
			$this->setValue( "username", $username );
			$this->setValue( "password", $password );
			
			parent::render();
		}
	}
?>