/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/*
 By Rodrigo M.S. de Oliveira
      (rdglinux@yahoo.com.br)

Revisions
0.1   - 01/01/06
0.2   - 03/01/06
0.21 - 06/01/06
0.22 - 02/05/06
 */


#include<qmessagebox.h>
#include<qprocess.h>
#include <qfiledialog.h>

// PDF PROTECTOR SLOTS ---------------------------------------------------

void Form1::pbtn_protect_click(){

  tabWidget2->setEnabled(FALSE);
  system("rm -rf /tmp/kpdftool*");
  txt_status->setText("Creating temporary files... Please wait.");
  
  // first we convert the PDF to PNG images.
  
  QProcess *convert;
  convert = new QProcess ( this ) ;

    convert->addArgument("convert") ;

    convert->addArgument("-density") ;
    convert->addArgument( txt_dpi->text() ) ;

   if( opt_gray_protect->isChecked() ){
    convert->addArgument("-colorspace") ;
    convert->addArgument("gray") ;
   }
    convert->addArgument( txt_source_protect->text() ) ;
    convert->addArgument( "/tmp/kpdftool-temp.png" ) ; //temporary PNG files

// then we wait for the end of the process and convert the temporary PNGs to the output PDF.
  connect( convert, SIGNAL( processExited() ), this, SLOT( png2pdf() ) );

  if ( ! convert->start() )
      QMessageBox::information(this, "Warning", "Could not execute convert!") ;
 
}

void Form1::png2pdf(){

 txt_status->setText("Creating PDF... Please wait.");

 QProcess *convert;
  convert = new QProcess ( this ) ;

    convert->addArgument("convert") ;

    convert->addArgument("-density") ;
    convert->addArgument( txt_dpi->text() ) ;

   if( opt_gray_protect->isChecked() ){
    convert->addArgument("-colorspace") ;
    convert->addArgument("gray") ;
   }
   
    convert->addArgument( "/tmp/kpdftool*.png" ) ;
    convert->addArgument( txt_dest_protect->text() ) ;

  connect( convert, SIGNAL( processExited() ), this, SLOT( rmtmp() ) );

  if ( ! convert->start() )
      QMessageBox::information(this, "Warning", "Could not execute convert!") ;

}

void Form1::rmtmp(){
 system("rm -rf /tmp/kpdftool*.png");
 Form1::done();
}

void Form1::pbtn_source_protect_click(){
  
 QString file =  QFileDialog::getOpenFileName(
            txt_path_src->text(),
	    "Postscrips (*.pdf *.ps *.prn)",
            this,
            "Input file",
            "Please, choose the input file"  );
 
 if( file != NULL ){
     txt_source_protect->setText(file);
      QFileInfo file_info (file);
      txt_path_src->setText( file_info.dirPath() ) ; 
    }
}


void Form1::pbtn_dest_protect_click(){

 QString file = QFileDialog::getSaveFileName(
            txt_path_dest->text(),
	    "PDFs (*.pdf)",
            this,
            "Output file",
            "Please, set the ouput file"  );

 if( file != NULL ){
  txt_dest_protect->setText(file);
      QFileInfo file_info (file);
      txt_path_dest->setText( file_info.dirPath() ) ; 
  }
}

//---------------------------------------------------------------------------------------------
// MERGE SLOTS ----------------------------------------------------------------

void Form1::pbtn_add_merge_click(){
       
    QStringList files = QFileDialog::getOpenFileNames(
                            "Postscripts (*.pdf *.ps *.prn)",
                            txt_path_src->text(),
                            this,
                            "open files dialog",
                            "Please, select one or more files" ); 
     pdf_list_merge->insertStringList(files);
     
     if ( pdf_list_merge->numRows() ) {  
        QFileInfo file_info ( pdf_list_merge->text( pdf_list_merge->numRows() - 1)  );
        txt_path_src->setText( file_info.dirPath() ) ; 
       }
        
}

void Form1::pbtn_clear_merge_click(){
  pdf_list_merge->clear();
}

void Form1::pbtn_remove_merge_click(){
  pdf_list_merge->removeItem( pdf_list_merge->currentItem() );
}

void Form1::pbtn_merge_click(){
    

    
    QString file = QFileDialog::getSaveFileName(
            txt_path_dest->text(),
           "PDFs (*.pdf)",
            this,
            "Output file",
            "Please, set the ouput file"  );

 if( file != NULL ){
   
  tabWidget2->setEnabled(FALSE);

  QProcess *merge;
  merge = new QProcess ( this ) ;
 
   merge->addArgument("gs") ;
   merge->addArgument("-dNOPAUSE") ;
   merge->addArgument("-sDEVICE=pdfwrite") ;
   merge->addArgument("-sOUTPUTFILE="+file) ;
   merge->addArgument("-dBATCH") ;
   for (int i=0 ; i  < pdf_list_merge->numRows() ; i++){
     merge->addArgument( pdf_list_merge->text(i)  ) ;
    }
   
     connect( merge, SIGNAL( processExited() ), this, SLOT( done() ) );

      txt_status->setText("Creating PDF...  Please wait.");
      if ( ! merge->start() )  QMessageBox::information(this, "Warning", "Could not execute gs!") ;
 
      QFileInfo file_info (file);
      txt_path_dest->setText( file_info.dirPath() ) ; 
   }
}

void Form1::pbtn_up_merge_click(){
    int i = pdf_list_merge->currentItem() ;
    
    if ( i ){
      QString item = pdf_list_merge->text( i );
      pdf_list_merge->insertItem( item , i-1);
      pdf_list_merge->removeItem( i+1 );
      pdf_list_merge->setSelected(i-1, TRUE);
      pdf_list_merge->ensureCurrentVisible();
    }
}


void Form1::pbtn_down_merge_click(){
    int i = pdf_list_merge->currentItem() ;
    
    if ( i < pdf_list_merge->numRows() -1 ){
      QString item = pdf_list_merge->text( i );
      pdf_list_merge->insertItem( item , i+2);
      pdf_list_merge->removeItem( i );
      pdf_list_merge->setSelected(i+1, TRUE);
      pdf_list_merge->ensureCurrentVisible();
    }
}

//--------------------------------------------------------------------------------------------

// Extractor (Split) SLOTS ----------------------------------------------

void Form1::pbtn_source_split_click(){
    

 
 QString file = QFileDialog::getOpenFileName(
            txt_path_src->text(),
            "Postscrips (*.pdf *.ps *.prn)",
             this,
            "Input file",
            "Please, choose the input file"  );

 if( file != NULL ){
    txt_source_split->setText(file);
      QFileInfo file_info (file);
      txt_path_src->setText( file_info.dirPath() ) ; 
  }
}


void Form1::pbtn_split_click(){
 
 QString file = QFileDialog::getSaveFileName(
            txt_path_dest->text(),
           "PDFs (*.pdf)",
            this,
            "Output file",
            "Please, set the ouput file"  );

 if( file != NULL ){
 
  tabWidget2->setEnabled(FALSE);
  QProcess *split;
  split = new QProcess ( this ) ;
  
   split->addArgument("gs") ;
   split->addArgument("-sDEVICE=pdfwrite") ;
   split->addArgument("-dNOPAUSE") ;
   split->addArgument("-dQUIET") ;
   split->addArgument("-dBATCH") ;
   split->addArgument("-dFirstPage="+txt_init_page_split->text()   ) ;
   split->addArgument("-dLastPage="+txt_final_page_split->text() ) ;
   split->addArgument("-sOUTPUTFILE="+file) ;
   split->addArgument( txt_source_split->text() ) ;
   
     connect( split, SIGNAL( processExited() ), this, SLOT( done() ) );

      txt_status->setText("Creating PDF...  Please wait.");
      if ( ! split->start() )  QMessageBox::information(this, "Warning", "Could not execute gs!") ;
       QFileInfo file_info (file);
      txt_path_dest->setText( file_info.dirPath() ) ; 
   }
}


//------------------------------------------------------------------------------



// Render images slots

void Form1::pbtn_img_click(){
  

  
  QString file = QFileDialog::getSaveFileName(
            txt_path_dest->text(),
	    "Images (*.png *.jpg *.gif *.tif *.bmp *.ppm)",
            this,
            "Output file",
            "Please, set the ouput file"  );

     if( file != NULL ){
      
      tabWidget2->setEnabled(FALSE);
      txt_status->setText("Creating image files... Please wait.");

      QProcess *convert;
      convert = new QProcess ( this ) ;

      convert->addArgument("convert") ;
      convert->addArgument("-density") ;
      convert->addArgument( txt_dpi_img->text() ) ;

      if( opt_gray_img->isChecked() ){
       convert->addArgument("-colorspace") ;
       convert->addArgument("gray") ;
      }
     convert->addArgument( txt_source_img->text() ) ;
     convert->addArgument( file ) ;
   
     connect( convert, SIGNAL( processExited() ), this, SLOT( done() ) ) ;

     if ( ! convert->start() )
      QMessageBox::information(this, "Warning", "Could not execute convert!") ;
     
      QFileInfo file_info (file);
      txt_path_dest->setText( file_info.dirPath() ) ; 
 }
}


void Form1::pbtn_source_img_click(){

 QString file = QFileDialog::getOpenFileName(
            txt_path_src->text(),
	    "Postscrips (*.pdf *.ps *.prn)",
            this,
            "Input file",
            "Please, choose the input file"  );

 if( file != NULL ){
   txt_source_img->setText(file);
      QFileInfo file_info (file);
      txt_path_src->setText( file_info.dirPath() ) ; 
  }

}

// Contents recovering slots

void Form1::pbtn_source_kword_click(){

 QString file = QFileDialog::getOpenFileName(
            txt_path_src->text(),
	    "Postscrips (*.pdf *.PDF)",
            this,
            "Input file",
            "Please, choose the input file"  );

 if( file != NULL ){
   txt_source_kword->setText(file);
      QFileInfo file_info (file);
      txt_path_src->setText( file_info.dirPath() ) ; 
  }

}

void Form1::pbtn_kword_click(){
 
  QProcess *kword;
  kword = new QProcess ( this ) ;
  
   kword->addArgument("kword") ;
   kword->addArgument( txt_source_kword->text() ) ;
   
   if ( ! kword->start() )  QMessageBox::information(this, "Warning", "Could not execute kword!") ;
   }

//-------------------------------------------------------------

void Form1::init(){
 txt_path_src->setText ( QDir::homeDirPath() );
 txt_path_dest->setText( txt_path_src->text() );
}

void Form1::done(){
  txt_status->setText("Done.");
  tabWidget2->setEnabled(TRUE);
}

void Form1::pbtn_about_click(){
    QMessageBox::information(this,"About KPDFTool", "KPDFTool was written by Rodrigo M.S. de Oliveira (rdglinux@yahoo.com.br).\nThe source code is published under GPL." );
}



