/***************************************************************************
 *   Copyright (C) 2010 by Daniel Nicoletti                                *
 *   dantti85-pk@yahoo.com.br                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; see the file COPYING. If not, write to       *
 *   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,  *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "KpkSearchableTreeView.h"

#include <QSortFilterProxyModel>
#include <KDebug>

KpkSearchableTreeView::KpkSearchableTreeView(QWidget *parent)
 : QTreeView(parent)
{
}

void KpkSearchableTreeView::keyboardSearch(const QString &search)
{
    // this hooks enable Qt::DisplayRole, search, and disable it
    QSortFilterProxyModel *proxy = qobject_cast<QSortFilterProxyModel*>(model());
    proxy->sourceModel()->setProperty("kbd", true);
    QTreeView::keyboardSearch(search);
    proxy->sourceModel()->setProperty("kbd", false);
}

void KpkSearchableTreeView::keyPressEvent(QKeyEvent *event)
{
    // this hooks enable Qt::CheckStateRole, handle the space key disable it
    QSortFilterProxyModel *proxy = qobject_cast<QSortFilterProxyModel*>(model());
    proxy->sourceModel()->setProperty("kbd", true);
    QTreeView::keyPressEvent(event);
    proxy->sourceModel()->setProperty("kbd", false);
}

#include "KpkSearchableTreeView.moc"
