#!/usr/bin/perl --
#
# perl antispam smtp proxy
# (c) John Hanna, John Calvi, Robert Orso, AJ 2004 under the terms of the GPL
# (c) Fritz Borgstedt 2006 under the terms of the GPL
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation;
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.  
# ASSP founded and developed to Version 1.0.12 by John Hanna.
# ASSP web interface by AJ.
# ASSP development since 1.0.12 by John Calvi.
# ASSP development since 1.2.0 by Fritz Borgstedt.
# LDAP implementation by Robert Orso.
# Nigel Barling - SPF & DNSBL.
# Mark Pizzolato - SMTP Session Limits.
# Przemek Czerkas - SRS, Delaying, Maillog Search, HTTP Compression, URIBL,RWL, 1.2.x
#  Contributions - Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Marco Tomasi, 
#				   	Andrew Macpherson, Marco Michelino, Matti Haack, Kevin
#


use Encode;
use File::Copy;
use IO::Select;
use IO::Socket;
use Sys::Hostname;
use Time::Local;
use bytes;    # get rid of annoying 'Malformed UTF-8' messages

#use strict "refs";
use strict "subs";

#use strict "vars";

$version    = '1.3.3.10';
$modversion = '()';              #appended in version display.
$starttime  = localtime(time);
%MakeIPRE   = (
    'ispip'                         => 'ISPRE',
    'allowAdminConnectionsFrom'     => 'ACFRE',
    'acceptAllMail'                 => 'AMRE',
    'noLog'                         => 'NLOGRE',
    'noDelay'                       => 'NDRE',
    'noSRS'                         => 'NSRSRE',
    'noHelo'                        => 'NHRE',
    'noRBL'                         => 'NRBLRE',
    'noRWL'                         => 'NRWLRE',
    'noPB'                          => 'NPBRE',
    'whiteListedIPs'                => 'WLIPRE',
    'noProcessingIPs'               => 'NPIPRE',
    'exportExtremeFile'             => 'EEFRE',
    'denySMTPConnectionsFrom'       => 'DSMTPCFCIDRRE',
    'denySMTPConnectionsFromAlways' => 'DSMTPCFACIDRRE',
);
$mypid = $$;

$CanUseHostname = $localhostname = hostname();
our $localhostip;
if ($localhostname) {
    eval { $localhostip = inet_ntoa( scalar( gethostbyname($localhostname) ) ); };
}
warn $@ if $@;
$CanUseAvClamd         = eval("use File::Scan::ClamAV; 1");     # ClamAV module installed
$CanUseLDAP            = eval("use Net::LDAP; 1");              # Net LDAP module installed
$CanUseAddress         = eval("use Email::Valid; 1");           # Email Valid module installed
$CanUseDNS             = eval("use Net::DNS; 1");               # Net DNS module installed - required for SPF & RBL
$AvailSPF              = eval("use Mail::SPF::Query; 1");       # Mail SPF module installed
$AvailSRS              = eval("use Mail::SRS; 1");              # Mail SRS module installed
$CanUseSRS             = $AvailSRS;
$AvailZlib             = eval("use Compress::Zlib; 1");         # Zlib module installed
$CanUseHTTPCompression = $AvailZlib;
$AvailMD5              = eval("use Digest::MD5; 1");            # Digest MD5 module installed
$CanUseMD5Keys         = $AvailMD5;
$AvailReadBackwards    = eval("use File::ReadBackwards; 1");    # ReadBackwards module installed;
$CanSearchLogs         = $AvailReadBackwards;
$AvailHiRes            = eval("use Time::HiRes; 1");            # Time::HiRes module installed;
$CanStatCPU            = $AvailHiRes;
$AvailIO               = eval("use PerlIO::scalar; 1");         # make it chroot savy;
$CanChroot             = $AvailIO;
$AvailSyslog       = eval("use Sys::Syslog qw( :DEFAULT setlogsock); 1");
$AvailNetSyslog    = eval("use Net::Syslog; 1");
$CanUseSyslog      = $AvailSyslog;
$CanUseNetSyslog   = $AvailNetSyslog;
$AvailWin32Daemon  = eval("use Win32::Daemon; 1");                        # Win32 Daemon module installed
$CanUseWin32Daemon = $AvailWin32Daemon;
$AvailTieRDBM      = eval("use Tie::RDBM; 1");                            # Use external database
$CanUseTieRDBM     = $AvailTieRDBM;
$AvailLWP          = eval('use LWP::Simple; 1');                          # LWP::Simple module installed
$CanUseLWP         = $AvailLWP;
$CanUseSPF         = $AvailSPF && $CanUseDNS;                             # SPF and dependancies installed
$CanUseURIBL       = $CanUseRWL = $CanUseRBL = $CanUseDNS;                # URIBL, RWL, DNSBL and dependancies installed

$wikiinfo = "get?file=images/info.png";

# load from command line if specified
if ( $ARGV[0] ) {
    $base = $ARGV[0];
}
else {

    # the last one is the one used if all else fails
    foreach ( '.', 'assp', '/usr/local/assp', '/home/assp', '/etc/assp', '/usr/assp', '/applications/assp', '/assp',
        '.' )
    {
        $base = $_;
        last if -e "$base/assp.cfg";
    }
}
if ( !-e "$base/images/noIcon.png" ) { die "Abort: folder 'images' not correctly installed"; }

loadConfig();
my $logdir = $1 if $logfile =~ /(.*)\/.*/;
mkdir "$base/$logdir", 0700 if $logdir;
if ( $logfile && open( LOG, ">>$base/$logfile" ) ) {
    my $oldfh = select(LOG);
    $| = 1;
    select($oldfh);
}

sub loadConfig {
 #print "loading config -- base='$base'\n";
 @Config=(
[0,0,0,'heading','Network Setup'],
 # except for the heading lines, all config lines have the following:
 #  $name,$nicename,$size,$func,$default,$valid,$onchange,$description(,CssAdition)
 # name is the variable name that holds the data
 # nicename is a human readable pretty display name (oh how nice!)
 # size is the appropriate input box size
 # func is a function called to render the config item
 # default is the default value
 # valid is a regular expression used to clean and validate the input -- no match is an error and $1 is the desired result
 # onchange is a function to be called when this value is changed -- usually undef; just updating the value is enough
 # group is the heading group belonged to.
 # description is text displayed to help the user figure what to put in the entry
 # CssAdition (optional) adds the string to the CSS-name for nicename Style
['listenPort','SMTP Listen Port',20,\&textinput,'25','(\S+)','ConfigChangeMailPort',
  'The port number on which ASSP will listen for incoming SMTP connections (normally 25). You can specify both an IP address and port number to limit connections to a specific interface.<p><small><i>Example:</i> 25, 127.0.0.1:25 <a href="http://www.asspsmtp.org/wiki/Configuration#Email_Flow" target="help">Network Flow</a></small></p>','Basic'],
['smtpDestination','SMTP Destination',40,\&textinput,'125','(\S*)',undef,
  'The IP address and port number of your primary SMTP <a href="http://en.wikipedia.org/wiki/Mail_transfer_agent">mail transfer agent</a> (MTA). If multiple servers are listed and the first listed MTA does not respond, each additional MTA will be tried in order. If only a port number is entered, or the dynamic keyword <b>__INBOUND__</b> is used (with or without a port number), then the connection will be established to the local IP address on which the connection was received. This is useful when you have several IP addresses with different domains or profiles in your MTA.<p><small><i>Examples:</i> 125,  127.0.0.1:125, 127.0.0.1:125|127.0.0.5:125, __INBOUND__:125</small></p>','Basic'],
['smtpDestinationRT','SMTP Destination Routing Table**',40,\&textinput,'','(\S*)','configChangeRT',
  'If __INBOUND__ is used in the SMTP Destination field, the rules specified here are used to route the inbound IP address to a different outbound IP address. You must specify a port number with the outbound IP address. <p><small><i>Example:</i>141.120.110.1=>141.120.110.129:25|141.120.110.2=>141.120.110.130:125|141.120.110.3=>141.120.110.130:125</small></p>'],
['listenPort2','Second SMTP Listen Port',20,\&textinput,'','(\S*)','ConfigChangeMailPort2',
  'A secondary port number on which ASSP can accept SMTP connections. This is useful as a dedicated port for VPN clients or for those who cannot directly send mail to a mail server outside of their ISP\'s network because the ISP is blocking port 25. You may also specify an IP address to limit connections to a specific interface.<p><small><i>Examples:</i> 2525, 127.0.0.1:2525, 192.168.0.100:25000</small></p>'],
['smtpAuthServer','Second SMTP Destination',20,\&textinput,'','(\S*)',undef, 
  'The IP address and port number to connect to when mail is received on the second SMTP listen port. If the field is blank, the primary SMTP destination will be used. The purpose of this setting is to allow remote users to make authenticated connections and transmit their email without encountering SPF failures.<p><small><i>Examples:</i> 587, 127.0.0.1:587</small></p>'],
['EnforceAuth',"Force SMTP AUTH on Second SMTP Listen Port",0,\&checkbox,0,'([01]?)',undef,
  'Force clients connecting to the second listen port to authenticate before transferring mail. To use this setting, both <a href="./#listenPort2">Second SMTP Listen Port</a> and <a href="./#smtpAuthServer">Second SMTP Destination</a> must be configured above.'],
['smtpReportServer','SMTP Reporting Destination',20,\&textinput,'','(\S*)',undef, 
  'The port number that ASSP will use to send <a onmousedown="toggleDisp(\'19\')" href="./#EmailInterfaceOk">Email Interface</a> notifcations to . If left blank, all notifications go to the primary <a href="./#smtpDestination">SMTP Destination</a>. You can specify <i>&lt;address&gt;</i>:<i>&lt;port&gt;</i> to limit connections. <p><small><i>Example:</i> 1025, 127.0.0.1:1025</small></p>
  <hr />
  <div class="menuLevel1">Notes On Network Setup</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/network.txt\',3);" />'],

[0,0,0,'heading','SMTP Session Limits'],
['MaxErrors','Maximum Errors Per Session',5,\&textinput,'10','(\d+)',undef,
  'The maximum number of <a href="http://www.asspsmtp.org/wiki/SMTP_Error_Codes#Permanent_Negative_Completion_reply_-_5xx" target="ASSPHELP">SMTP session errors</a> encountered before the connection is dropped.'],
['maxSMTPSessions','Maximum Sessions',5,\&textinput,'32','(\d?\d?\d?)',undef,
  'The maximum number of simultaneous SMTP sessions. This can prevent server overloading and DoS attacks. 32 simultaneous sessions are typically enough. No entry or zero means no limit.'],
['maxSMTPipSessions','Maximum Sessions Per IP Address',3,\&textinput,'5','(\d?\d?\d?)',undef,
  'The maximum number of SMTP sessions allowed per IP address. Use this setting to prevent server overloading and DoS attacks. 5 sessions are typically enough. If left blank or set to 0 there is no limit imposed by ASSP. <a onmousedown="toggleDisp(\'6\')" href="./#ispip">ISP/Secondary MX Servers</a> and  <a onmousedown="toggleDisp(\'6\')" href="./#acceptAllMail">Accept All Mail</a> matches are excluded from SMTP session limiting.'],
['maxSMTPipConnects','Maximum SMTP Connections Per IP Address Frequency',3,\&textinput,'5','(\d?\d?\d?)',undef,
  'The maximum number of SMTP connections an IP Address can make during the <a href="./#maxSMTPipDuration">IP Address Frequency Duration</a>. If a server makes more than this many connections to ASSP within the <a href="./#maxSMTPipDuration">IP Address Frequency Duration</a> it will be banned from future connections until the <a href="./#maxSMTPipExpiration">IP Address Frequency Expiration</a> is reached. This can be used to prevent server overloading and DoS attacks. 5 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. <a onmousedown="toggleDisp(\'6\')" href="./#ispip">ISP/Secondary MX Servers</a> and  <a onmousedown="toggleDisp(\'6\')" href="./#acceptAllMail">Accept All Mail</a> matches are excluded from SMTP session limiting.'],
['maxSMTPipDuration','Maximum SMTP Connections Per IP Address Frequency Duration',5,\&textinput,'90','(\d?\d?\d?\d?)',undef,
  'The rolling window (in seconds) during which the <a href="./#maxSMTPipConnects">IP Address Frequency</a> (see above for more details) will be scrutinized for each IP. The default is 90 seconds.'],
['maxSMTPipExpiration','Maximum SMTP Connections Per IP Address Frequency Expiration',5,\&textinput,'3600','(\d?\d?\d?\d?)',undef,
  'The number of seconds that must pass before an IP address blocked by the <a href="./#maxSMTPipConnects">IP Address Frequency</a> setting is allowed to connect again. The default is 3600 seconds.'],
['maxSMTPdomainIP','Limit Subnet IPs  Per Domain ',3,\&textinput,'0','(\d?\d?\d?)',undef,
  'The number of IP(subnet) switches a domain may have during the <a href="./#maxSMTPdomainIPExpiration">Limit Different IPs Per Domain Expiration</a>. If a domain switches more often than this it will be banned from future connections until the Expiration is reached. This can be used to prevent server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. <a onmousedown="toggleDisp(\'6\')" href="./#ispip">ISP/Secondary MX Servers</a> and  <a onmousedown="toggleDisp(\'6\')" href="./#acceptAllMail">Accept All Mail</a> matches are excluded, whitelisted and nonprocessing addresses are honored.'],
['maxSMTPdomainIPExpiration','Limit Different IPs  Per Domain Expiration',5,\&textinput,'7200','(\d?\d?\d?\d?)',undef,
  'The number of seconds that must pass before a domain blocked by the <a href="./#maxSMTPdomainIP">Limit Subnet IPs Per Domain</a> setting (see above for more details) is allowed to connect again. The default is 7200 seconds (120 minutes).'],
['maxSMTPdomainIPWL','Do Not Limit Different IPs For These Domains*',60,\&textinput,'yahoo.com|hotmail.com|gmail.com','(.*)','ConfigMakeRe',
  'This prevents specific domains from limiting. For example:yahoo.com|hotmail.com|gmail.com'],
['smtpIdleTimeout','SMTP Idle Timeout',5,\&textinput,'300','(\d?\d?\d?\d?)',undef,
  'The number of seconds a session is allowed to be idle before being forcibly disconnected. The default is 300 seconds. No limit is imposed by ASSP if the field is left blank or set to 0.'],

[0,0,0,'heading','SPAM Control'],
['RegexModifier','Use Regular Expression Modifier /m',0,\&checkbox,0,'([01]?)',undef,
  'The /s modifier treat a string as single line. If you want the ^ marker and the $ marker to look at the
 start point and end point of *lines*, not at the start point and end point of the *string*, then you need the /m modifier.
 If activated the regular expressions \'blackRe, redRe, SpamGTUBE, contentOnlyRe, slRe, npRe, whiteRe, validFormatHeloRe, invalidFormatHeloRe, invalidPTRRe, noSPFRe, strictSPFRe, NoScanRe, SuspiciousVirus, bombSenderRe, bombHeaderRe, bombSubjectRe, bombCharSets, bombRe, bombSuspiciousRe, bombDataRe, testRe, scriptRe\' which use /si modifiers will change modifiers to /msi, all other will use  /i only. <a href="http://www.asspsmtp.org/wiki/Regular-Expression-Modifiers" target="help">modifier sm</a> 
'],
['blackRe','BlackRe - Regular Expression to Identify Spam* ',80,\&textinput,'http://[\\w\\.]+@|\w<[a-z0-9]+[abcdfghjklmnpqrstuvwxyz0-9]{4}[a-z0-9]*>|subject: [^\\n]*     \S','(.*)',,'ConfigCompileRe',
  'If an incoming email that\'s not local or whitelisted matches this Perl regular expression it will be considered spam .<br />
For example: penis|virgin|X-Priority: 1.<span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/blackre.txt\' .</span>'],
['redRe','Regular Expression to Identify Redlisted Mail*',80,\&textinput,'file:files/redre.txt','(.*)',,'ConfigCompileRe',
 'If an email matches this Perl regular expression it will be considered redlisted. The redlist is a list of addresses that cannot contribute to the whitelist, and who are not considered local, even if their mail is from a local computer. For example, if someone goes on a vacation and turns on their email\'s autoresponder, put them on the redlist until they return. Then as they reply to every spam they receive they  won\'t corrupt your non-spam collection or whitelist: \\[autoreply\\]<br /> Redlisted addresses will not be added to the whitelist. Redlisted messages will not be stored in the SPAM/NOTSPAM-collection. As all fields marked by * this field accepts a list separated by | or a specified file  \'file:files/redre.txt\' .'],
['SpamGTUBE','Generic Test for Unsolicited Bulk Email',80,\&textinput,'XJS\*C4JDBQADN1.NSBN3\*2IDNEN\*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL\*C.34X','(.*)',,'ConfigCompileRe',
  'the <a href="http://spamassassin.apache.org/gtube/" target="ASSPHELP">GTUBE</a> provides a test by which you can verify that ASSP installed correctly and is detecting incoming spam'],
['SpamError','Spam Error',80,\&textinput,'554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@yourdomain.com','(5\d\d .*)',undef,
  'SMTP error message to reject spam. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@yourdomain.com'],
['blackListedDomains','Blacklisted Addresses/Domains*',60,\&textinput,'','(.*)','ConfigMakeRe',
  'Individual Addresses  &amp; Domains from which you always want to reject mail, they only send you spam. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. abc@def.com will match abc@def.com but won\'t match bbc@def.com.For example: @spam.net|.pics.com|seller@bayer.com'],
['contentOnlyRe','Regular Expression to Set Contents Only Checks*',80,\&textinput,'','(.*)',,'ConfigCompileRe',
  "Put anything here to identify messages which should only be checked for content. For example:  mailaddresses of people who are forwarding from other accounts to their mailbox on your server. These addresses will bypass PB, Sender Validation, Griplist, IP Limiting, Delaying, SPF, DNSBL &amp; SRS checks. "],
['noGriplistUpload','Don\'t Upload Griplist Stats',0,\&checkbox,0,'([01]?)',undef,
 'Check this to disable the Griplist upload when rebuildspamdb runs. The Griplist contains IPs and their value between 0 and 1, lower is less spammy, higher is more spammy. This value is called the grip value. '],
['noGriplistDownload','Don\'t auto-download the Griplist file',0,\&checkbox,0,'([01]?)',undef,
 'Set this checkbox if don\'t use the Griplist or want to download it manually. '],
['AddSpamProbHeader','Add Spam Probability Header',0,\&checkbox,0,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Spam-Prob: 0.0123" Probs range from 0 to +1 where > 0.6 = spam.'],
['AddIntendedForHeader','Add Envelope-Recipient Header',0,\&checkbox,0,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Intended-For: user@domain" .'],
['NoExternalSpamProb','Block Outgoing Spam-Prob header',0,\&checkbox,1,'([01]?)',undef,
  'Check this box if you don\'t want your X-Assp-Spam-Prob header on external mail<br />
  Note this means mail from local users to local users will also be missing the header.'], 
['AddSpamHeader','Add Spam Header',0,\&checkbox,1,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Spam: YES" if the message is spam.'],
['AddCustomHeader','Add Custom Header',80,\&textinput,'','(.*)',undef,
  'Adds a line to the email header if the message is spam.'],
['AddLevelHeader','Add Graphical Level Header',0,\&checkbox,1,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Spam-Level:**** " showing the totalscore represented by stars.'],
['CustomizeStars','Customize Graphical Level Header',2,\&textinput,'5','(.*)',undef,
  'Scaling factor:  x points is 1 star.'],
['AddSpamReasonHeader','Add Spam Reason Header',0,\&checkbox,1,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Spam-Reason: " explaining why the message is spam.<br /><hr /><div class="menuLevel1">Notes On Spam Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamcontrol.txt\',3);" />'],

[0,0,0,'heading','CC Mail'],
['sendAllSpam','Copy Spam and Send to this Address',20,\&textinput,'','(.*)',undef,
  'If this is set ASSP will try to deliver a copy of spam emails to this address. For example: spammaster@mydomain.com. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient.
For example: USERNAME@Spam.DOMAIN, USERNAME+Spam@DOMAIN, catchallspamthis@DOMAIN','Basic'],
['ccMaxBytes','Restricts Copy Spam to MaxBytes',0,\&checkbox,1,'([01]?)',undef,
'CCMail will cut off Spam mails, thereby reducing the load considerably (recommended).'],
['ccSpamFilter','Copy Spam Filter*',40,\&textinput,'','(.*)','ConfigMakeRe',
  'Restricts Copy Spam to these recipients. Accepts specific addresses (user@domain.com), user parts (user) or entire local domains (@domain.com).'],
['ccSpamAlways','Copy Spam to these Recipients always*',40,\&textinput,'','(.*)','ConfigMakeRe',
  'Copy Spam to these recipients regardless of collection mode. Mode 6 (discard)  is ignored. Accepts specific addresses (user@domain.com), user parts (user) or entire local domains (@domain.com).'],
['sendAllPostmaster','Catchall Address for Postmaster Mail',20,\&textinput,'','(.*)',undef,
  'ASSP will try to deliver mails addressed to all postmasters of your local domains to this address. For example: postmaster@mydomain.com'],
['sendAllPostmasterNP','Skip Spam Checks for Postmaster Catchall',0,\&checkbox,0,'(.*)',undef,''],
['sendAllAbuse','Catchall Address for Abuse Mail',20,\&textinput,'','(.*)',undef,
  'ASSP will try to deliver mails to all abuse addresses of your local domains to this address. For example: abuse@mydomain.com'],
['sendAllAbuseNP','Skip Spam Checks for Abuse Catchall',0,\&checkbox,1,'(.*)',undef,''],
['sendAllDestination','Copy Spam Mail SMTP Destination',20,\&textinput,'','(\S*)',undef, 
  'Port to connect to when  Spam messages are copied. If blank they go to the main SMTP Destination. eg "10.0.1.3:1025", "1025", etc.'],
['sendAllHamDestination','Copy Ham Mail SMTP Destination',20,\&textinput,'','(\S*)',undef, 
  'Port to connect to when  Ham messages are copied. If blank they go to the Spam SMTP Destination. eg "10.0.1.3:1025", "1025", etc.'],
['spamSubjectCC','Prepend Spam Subject to Copied Spam',0,\&checkbox,0,'([01]?)',undef,
  'If set <a onmousedown="toggleDisp(\'18\')" href="./#spamSubject">Spam Subject</a> gets prepended to the subject of the copied mail.'],
['spamTagCC','Prepend Spam Tag to Copied Spam',0,\&checkbox,1,'([01]?)',undef,'The name of the check which caused the spam detection will be prepended to the subject of the mail. For example: [DNSBL]'],
['sendHamInbound','Copy Incoming Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef,
  'If you put an email address in this box  ASSP will try to forward a copy of notspam emails from outside to this address. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient.
 For example: archiv@mydomain.com, USERNAME@mybackup.domain, catchallforthis@DOMAIN'],
['sendHamOutbound','Copy Outgoing Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef,
  'If you put an email address in this box ASSP will try to forward a copy of outgoing notspam emails to this address.'],
['ccHamFilter','Copy Not-Spam Filter*',40,\&textinput,'','(.*)','ConfigMakeRe',
 'Copy Not-Spam to/from these addresses only. Accepts specific addresses (user@domain.com), user parts (user) or entire local domains (@domain.com).<hr /><div class="menuLevel1">Notes On Copy Mail</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/copymail.txt\',3);" />'],

[0,0,0,'heading','SPAM Lover/No Processing'],
['spamLovers','All Spam-Lover*',60,\&textinput,'postmaster|abuse','(.*)','ConfigMakeRe',
  'All Emails to Spam-Lovers are processed by ASSP, but not blocked. The notable
 exception is emails with multiple recipients, including Spam-Lovers. When a
 Spam-Lover is not the sole recipient of a message, the message is processed
 normally, and if it is found to be spam, it will not be delivered to the
 Spam-Lover. Accepts specific addresses (user@domain.com), addresses at local domains (user), or entire local domains (@domain.com). Separate entries with pipes: |. Default: postmaster|abuse.<br />For example: fribo@thisdomain.com|jhanna|@sillyguys.org '],
['baysSpamLovers','Bayesian Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['blSpamLovers','Blacklisted Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['bombSpamLovers','Bomb Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['hlSpamLovers','HELO Blacklisted Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe','This includes Valid/Invalid Helo'],
['attachSpamLovers','Bad Attachment Spam-Lover*',60,\&textinput,'not included in All Spam-Lover','(.*)','ConfigMakeRe',''],
['spfSpamLovers','SPF Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['rblSpamLovers','DNSBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['uriblSpamLovers','URIBL Failures Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['srsSpamLovers','Not SRS Signed Bounces Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['delaySpamLovers','No Delaying Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['isSpamLovers','Invalid Sender Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['mxaSpamLovers','Missing MX/A Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['ptrSpamLovers','Invalid/Missing PTR Spam-Lover*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['pbSpamLovers','Penalty Box Blocking Spam-Lover *',60,\&textinput,'','(.*)','ConfigMakeRe','Attention: Not included in *all* spamlovers'],
['spamHaters','All Spam-Haters*',60,\&textinput,'','(.*)','ConfigMakeRe',
  'All Emails to Spam-Haters found to be spam are blocked by ASSP rather than processed in testmode/spamlover.  When a Spam-Hater is not the sole recipient of a message, the message will only be blocked if all recipients are Spam-Haters. Overrides Spam-Lover addresses/domains. Accepts specific addresses (user@domain.com), addresses at local domains (user), or entire local domains (@domain.com). Separate entries with pipes: |. <br />For example: jfribo@thisdomain.com|fribo|@sillyguys.org '],
['baysSpamHaters','Bayesian Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeRe','Block spam to this addresses even when bayesian testmode/spamlover is set.'],
['rblSpamHaters','DNSBL Failures Spam-Hater*',60,\&textinput,'','(.*)','ConfigMakeRe',''],
['slRe','Regular Expression to Identify Spam-Lover*',60,\&textinput,'passwor.','(.*)',,'ConfigCompileRe',
 'If an email  matches this Perl regular expression it will be considered a spam-lover mail. It will be tagged, not blocked..'],
['slScoringMode',"Message Scoring",0,\&checkbox,1,'([01]?)',undef,
 'Put the filter automatically in "Message Scoring Mode"  when  <a onmousedown="toggleDisp(\'8\')" href="./#DoPenaltyMessage">Message Mode</a> is set  (instead of stopping spam processing altogether).'],
['spamSubjectSL',"Suppress Spam Subject and Tag to Spam-Lover-mail",0,\&checkbox,0,'([01]?)',undef,
 'If set  <a onmousedown="toggleDisp(\'18\')" href="./#spamSubject">spamSubject</a> and spamTag gets NOT prepended to the subject of the Spam-Lover-email. <br /><hr />'],
['noProcessing','No Processing Addresses*',60,\&textinput,'','(.*)','ConfigMakeRe',
 'Mail solely to or from any of these addresses are proxied without processing.<br />
 Like a more efficient version of spamLovers &amp; redlist combined. 
 Valid entry types are as per spamlovers: full address, username only, or entire @domain.'],
['noProcessingDomains','No Processing Domains*',60,\&textinput,'sourceforge.net','(.*)','ConfigMakeRe',
  'Domains from which you want to receive all mail and  proxy without processing. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. DO NOT put your local domains on this list. For example: sourceforge.net|@google.com|.buy.com'],
['noProcessingIPs','No Processing IPs*',60,\&textinput,'','(.*)','ConfigMakeRe',
 'Mail from any of these IP\'s are ignored by ASSP. <br />For example: 127.0.0.1|10.|169.254.|172.16.|192.168.'],
['npRe','Regular Expression to Identify No Processing Mail*',60,\&textinput,'','(.*)',,'ConfigCompileRe',
'If an email matches this Perl regular expression it will pass 
through unprocessed. For example: 169\.254\.122\.|172\.16\.|\\[autoreply\\].'],
['npSize','No Processing for Messages  larger this SIZE',10,\&textinput,'500000','(.*)',undef,
  'Incoming messages larger than this SIZE (in bytes) are ignored by ASSP. Empty or 0 disables the feature. '],
['processOnlyAddresses','Process Only These Addresses*',80,\&textinput,'','(.*)','ConfigMakeRe',
 'Mail solely to or from any of these addresses will be processed by 
 ASSP.  All others will be proxied without processing. Valid entry types are as per spamlovers: full address, username only, or entire @domain.<br />
 Note that if an address matches both the NoProcessing and the OnlyTheseProcessing lists, the NoProcessing rules take precedence . '],
['poTestMode','Enable Process Only Addresses',0,\&checkbox,0,'([01]?)',undef,'<br /><hr />
  <div class="menuLevel1">Notes On Spam Lover</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamlover.txt\',3);" />',],

[0,0,0,'heading','Whitelisting'],
['whiteRe','Regular Expression to Identify Non-Spam* ',80,\&textinput,'','(.*)',,'ConfigCompileRe',
  'If an incoming email matches this Perl regular expression it will be considered whitelisted.<br />
  For example: Secret Ham Password|307\D{0,3}730\D{0,3}4[12]\d\d<br />
  For help writing regular expressions click <a href="http://www.perlmonks.org/index.pl?node=perlre" rel="external">here</a>.  
  ATTENTION: The body is scanned in a later stage  AFTER all sender related checks are performed. So a white regular expression here might not prevent the message to be blocked by eg. invalid PTR. Set the sender related checks to score only if you want to make sure that the white regular expression will be seen.
  Some things you might include here are your office phone number or street address, spam rarely includes these details. As usual (marked by *) this field accepts a list separated by | or a filename specified this way: \'file:files/whitere.txt\' .'],
['whiteListedIPs','Whitelisted IPs*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'They  contribute to the whitelist and to notspam. For example: 127.0.0.1|10.|169.254.|172.16.|192.168. <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipwl.txt\'.</span>'],
['whiteListedDomains','Whitelisted Domains*',80,\&textinput,'sourceforge.net','(.*)','ConfigMakeRe',
  'Domains from which you want to receive all mail. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. DO NOT put your local domains on this list. For example: sourceforge.net|@google.com|.buy.com'],
['EmailAllowEqualChar','Allow \'=\' in Addresses',0,\&checkbox,0,'([01]?)',undef,
  'Allow \'=\' in addresses to be whitelisted or redlisted.'],
['ValidateRWL','Enable Realtime Whitelist Validation',0,\&checkbox,0,'([01]?)','configUpdateRWL',
  'RWL: Real-time white list. These are lists of IP addresses that have
somehow been verified to be from a known good host. Senders that pass RWL validation will pass IP-based filters. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. <a href="http://www.asspsmtp.org/wiki/FAQ#Common_Problems" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',undef],
['RWLServiceProvider','RWL Service Providers*',80,\&textinput,'query.bondedsender.org|exemptions.ahbl.org|iadb.isipp.com|hul.habeas.com','(.*)','configUpdateRWLSP',
  'Domain Names of RWLs to use separated by "|". Defaults are:<br />
   query.bondedsender.org|exemptions.ahbl.org|iadb.isipp.com|hul.habeas.com',undef],
['RWLmaxreplies','Maximum Replies',5,\&textinput,3,'(\d*)','configUpdateRWLMR',
  'A reply is affirmative or negative reply from a RWL. The RWL module will wait for this number of replies (negative or positive) from the RWLs listed under Service Provider for up to the Maximum Time below. This number should be equal to or less than the number of RWL Service Providers listed to allow for randomly unavailable RWLs',undef],
['RWLminhits','Minimum Hits',5,\&textinput,1,'(\d*)','configUpdateRWLMH',
  'A hit is an affirmative response from a RWL. The RWL module will check all of the RWLs listed under Service Provider, and flag the email with a RWL pass flag if equal to or more than this number of RWLs return a postive whitelisted response. This number should be less than or equal to Maximum Replies above and greater than 0',undef],
['RWLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time to spend on each message performing RWL checks',undef],
['AddRWLHeader','Add X-Assp-Received-RWL Header',0,\&checkbox,1,'([01]?)',undef,
  'Add X-Assp-Received-RWL header to header of all emails processed by RWL.',undef],
['noRWL','Don\'t Validate RWL for these IPs*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Enter IP addresses that you don\'t want to be RWL validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef],
['RWLCacheInterval','RWL Cache Refresh Interval',4,\&textinput,30,'(\d?\d?\d?\d?)','configUpdateRWLCR',
  'IP\'s in cache will be removed after this interval(days). <input type="button" value=" Show PTR Cache" onclick="javascript:popFileEditor(\'pb/pbdb.rwl.db\',5);" />'],
['MaxWhitelistDays','Max Whitelist Days',5,\&textinput,'180','(\d+)',undef,
  'This is the number of days an address will be kept on the whitelist without any email to/from this address.'],
['MaxWhitelistLength','Max Length of Whitelist Addresses',4,\&textinput,'50','(.*)',undef,''],
['WhitelistOnly','Reject All But Whitelisted Mail',0,\&checkbox,0,'([01]?)',undef,
  'Check this if you don\'t want Bayesian filtering and want to reject all mail from anyone not whitelisted.<br />'],
['NoMaillog','Don\'t log mail',0,\&checkbox,0,'([01]?)',undef,
  'Check this if you\'re using Whitelist-Only and don\'t care to save mail to build the Bayesian database.'],
['NoAutoWhite','Only Email-Interface Addition to Whitelist.',0,\&checkbox,0,'([01]?)',undef,
  'Check this box to  allow additions to the whitelist by email interface only.'],
['NotGreedyWhitelist','Only the envelope-sender is added/compared to the whitelist',0,\&checkbox,0,'([01]?)',undef,
  'Normal operation includes addresses in the FROM, SENDER, REPLY-TO, ERRORS-TO, or LIST-* header fields.<br />
  This allows nearly all list email to be whitelisted. Check this option to disable this.'],
['WhitelistLocalOnly','Only local or authenticated users contribute to the whitelist.',0,\&checkbox,0,'([01]?)',undef,
  'Normal operation allows all local, authenticated, or whitelisted users to contribute to the whitelist.<br />
  Check this box to not allow whitelisted users to add to the whitelist.'],
['WhitelistLocalFromOnly','Only users with a local domain in mailfrom contribute to the whitelist.',0,\&checkbox,0,'([01]?)',undef,
  'Check this box to prevent sender with non-local domains from contributing to the whitelist. (eg. redirected messages).'],
['WhitelistAuth','Whitelist authenticated users.',0,\&checkbox,0,'([01]?)',undef,''],
['UpdateWhitelist','Save Whitelist',10,\&textinput,3600,'(\d+)',undef,
  'Save a copy of the white list every this many seconds.<br />
  Note: the current timeout must expire before the new setting is loaded, or you can restart.
  <br /><hr /><div class="menuLevel1">Notes On Whitelist</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/whitelist.txt\',3);" />'],

[0,0,0,'heading','Relaying'],
['acceptAllMail','Accept All Mail* <a href="http://www.asspsmtp.org/wiki/Getting_Started#Error:_.22relaying_not_allowed.22._What_do_I_do.3F" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Relaying is allowed for these IPs. They  contribute also to the whitelist. This can take either a directly entered list of IP\'s separated by pipes or a file \'file:files/acceptall.txt\'.<br />
  For example: 127.0.0.1|10.|169.254.|172.16.|192.168.','Basic'],
['localDomains','Local Domains*',80,\&textinput,'putYourDomains.com|here.org','(.*)','ConfigMakeRe',
  'Check local domains against this addresses. Separate addresses with | or use file \'file:files/localdomains
.txt\'. Include all subdomains.<br />
  For example: put.YourDomains.com|here.org','Basic'],
['nolocalDomains','Skip Local Domain Check',0,\&checkbox,0,'([01]?)',undef,
  'Do not check relaying based on localDomains. Let the mailserver do it.'],
['ldLDAP','Do LDAP lookup for local domains',0,\&checkbox,0,'([01]?)',undef,
  'Check local domains against an LDAP database.<br />
  Note: Checking this requires filling in LDAP DomainFilter in The LDAP section.<br />
  This requires an installed <a href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod" rel="external">NET::LDAP</a> module in PERL.'],
['ispip','ISP/Secondary MX Servers*',80,\&textinput,'','(\S*)','ConfigMakeRe',
  'Enter any addresses that are your ISP or backup MX servers, separated by pipes (|). <br />
  These addresses will (necessarily) bypass Griplist, IP Limiting, Delaying, Penalty Box, SPF, DNSBL &amp; SRS checks. For example: 127.0.0.1|10. ','Basic'],
['ispgreyvalue','ISP/Secondary MX Grey Value',5,\&textinput,'0.5','(\S*)',undef,
  'It is recommended  to set it to 0.5 (Completely GReyIP) for ISP &amp; Secondary MX servers to b. If left blank then the Griplist "" value is used.<br />
  Note: value should be greater than 0 and less than 1, where 0 = never spam &amp; 1 = always spam'],
['BounceSenders','Bounce Senders*',80,\&textinput,'postmaster|mailer-daemon','(.*)','ConfigMakeRe',
  'Envelope sender addresses treated as bounce origins. Null sender (&lt;&gt;) is always included.<br />
  Accepts specific addresses (postmaster@domain.com), usernames (mailer-daemon), or entire domains (@bounces.domain.com)<br />
  Separate entries with pipes: |. For example: postmaster|mailer-daemon'],
['PopB4SMTPFile','Pop Before SMTP DB File',40,\&textinput,'','(.*)',undef,
  'Enter the DB database filename of your POP before SMTP implementation with records stored for
  dotted-quad IP addresses<br />
  For example: /etc/mail/popip.db If it\'s got something else, you\'ll need to edit the PopB4SMTP subroutine.'],
['PopB4SMTPMerak','Pop Before SMTP Merak Style',0,\&checkbox,'','(.*)',undef,
  'If set Merak 7.5.2 is supported.'],
['relayHost','<a href="http://www.andersonit.com/FlowDiagram.htm" target="ASSPHELP">Relay Host</a>',40,\&textinput,'','(\S*)',undef,
  'Your isp\'s mail relayhost (smarthost). For example: mail.isp.com:25<br />
  If you run Exchange/Notes and you want assp to update the nonspam database and the whitelist, then enter your isp\'s smtp relay host here. Blank means no relayhost. Only required if clients don\'t deliver through SMTP.','Basic'],
['relayPort','Relay Port',40,\&textinput,'','(\S*)','ConfigChangeRelayPort',
  'Tell your mail server to connect to this port as its smarthost / relayhost.
  For example: 225<br /> Note that you\'ll want to keep the relayPort protected from external access by your firewall.<br />
  You can supply an interface:port to limit connections.'],
['relayPortNP','Relay Port Noprocessing',0,\&checkbox,'','(.*)',undef,
  'Enables NoProcessing of all mail passing through relay port.  Does NOT disable SRS.'],
['NoRelaying','<a href="http://assp.sourceforge.net/fom/cache/16.html" target="help">No Relaying Error <img src="' . $wikiinfo . '" alt="docu" /></a>',80,\&textinput,'530 Relaying not allowed','(5\d\d .*)',undef,
  'SMTP error message to deny relaying.'],
['defaultLocalHost','Default Local Host',40,\&textinput,'','(\S*)',undef,
  'If you want to be able to send mail to local users without a domain name then put the
  default local domain here.<br /> Blank disables this feature. For example: mydomain.com<br /><hr />
  <div class="menuLevel1">Notes On Relaying</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/relaying.txt\',3);" />'],
['localDomainsFile','Local Domains File',40,\&textinput,'','(.*)',undef,
  'Like Local Domains, but <b>OBSOLETE! Please use -><a href="/#localDomains">localDomains</a>.</b>'],
['relayHostFile','Relay Host File - OBSOLETE',40,\&textinput,'','(.*)',undef,
  'Like &lt;Accept All Mail&gt;, but this is a file with an ABSOLUTE path, not relative to base. For example: /usr/local/assp/relayhosts'], 

[0,0,0,'heading','Validate Local Addresses'],
['DoRFC822','Validate local addresses to conform with RFC 822',0,\&checkbox,1,'([01]?)',undef,
  'If activated, each local address is checked to conform with the email format defined in RFC 822.<br />
  This requires an installed <a href="http://search.cpan.org/search?query=Email::Valid" rel="external">Email::Valid</a> module in PERL.'],
['DoLDAP','Do LDAP lookup for valid local addresses',0,\&checkbox,0,'([01]?)',undef,
  'Check local addresses against an LDAP database before accepting the message.<br />
  Note: Checking this requires filling in the other LDAP parameters below.<br />
  This requires an installed <a
  href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod"
  rel="external">NET::LDAP</a> module in PERL.'],
['LocalAddresses_Flat','Lookup valid Local Addresses from here*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'These email addresses are the list of your local addresses. You can list specific addresses (user@mydomain.com), addresses at any local domain (user), or entire local domains (@mydomain.com). Separate entries with pipes (|).<br />
  For example: fribo@thisdomain.com|jhanna|@sillyguys.org or place them in a plain ASCII file one address per line:file:files/localuser.txt.','Basic'],
['LocalAddressesValid','Accept Remote Sender with  Valid Local Addresses ',0,\&checkbox,0,'([01]?)',undef,
  'Consider Remote Sender with Valid Local Addresses as NOT spoofed. This will not allow relaying, but will skip delaying. Bayesian will not block but mark only.'],
['CatchAll','Send Invalid Recipients To This Address*',40,\&textinput,'','(.*)','configUpdateCA',
  'ASSP will try to send to this address if no valid user exists.<br />
  For example: catchall@mydomain.com|mail@yourdomain.com'],
['InternalAddresses','Accept Mail from Local Domains only*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'These local addresses accept mail only from local domains.'],
['SepChar','Separation Character for Subaddressing',2,\&textinput,'','(.*)',undef,
  'RFC 3598 describes subaddressing with a Separation Character. Everything between Separation Character and @ is ignored (including Separation Character). For example: user@domain.com will allow user+subaddress@domain.com. For Example = \'+\' '],
['NoValidRecipient','No-Valid-Local-User Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','([5|2]\d\d .*)',undef,
  'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\'<br />
  The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g. thisuser@yourcompany.com).<br /><hr />
  <div class="menuLevel1">Notes On Local Addresses</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/localaddresses.txt\',3);" />'],
[0,0,0,'heading','Penalty Box'],
['DoPenalty','Penalty Box <a href="http://www.asspsmtp.org/wiki/Penalty_Box" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',1,\&textinput,2,'(\d*)',undef,
  'The PenaltyBox scores IP\'s based on some events (see . The scores are written to a BlackBox by scoring events like "is PenaltyTrap Address" and into a WhiteBox.
  The scoring values can be set below. If the score per specified time interval surpasses the threshold the mail is rejected (and the IP is marked for blocking). These IP\'s continue to get score values up to the Extreme Threshold. After reaching that the  sending IP is rejected right at the SMTP connection. The White Box stores IP\'s which should not be put into the BlackBox. The WhiteBox is always activated. Is an address in the whitelist or whitedomain, the IP goes into the WhiteBox.<br />Entries in <i>Don\'t do penalties for these IP\'s</i> or <i>ISP/Secondary MX Servers</i> will prevent from penalties. You should run it  with option 2 to fill WhiteBox, BlackBox and exportExtremeFile. Option 2 is also the right choice if you do not want to score IP\'s but rather score a mail in "Message Mode".<br />
  <span class="negative"> 0 = deactivate, 1 = activate, 2 = monitoring/scoring/message-mode</span>'],
['DoExtreme','Do Extreme Denying for Mode 2',0,\&checkbox,1,'([01]?)',undef,
 'PB will deny  connections from IP\'s whose score meet or exceed this level - even if PB is only in mode 2 (monitoring)'],
['DoPenaltyMessage','Message Mode',0,\&checkbox,1,'([01]?)',undef,
  'If this option is selected, the scores for all checks during a message are combined to determine if the email should be considered as Spam.  This allows you to assign different weights to individual checks so that not one check will automatically cause an incoming email to be considered as spam, but rather the combination of any checks. The checks (DNSBL,URIBL,MX/A,PTR...) must be set to mode 3 (score only). If the combined score is greater than the <b>Low Threshold</b> the message will only be tagged. If the combined score is greater than <b>High Threshold Combined Scores per Message</b>, the mail will be blocked. '],
['PenaltyMessageLow','Low Threshold for Combined Scores per Message',3,\&textinput,40,'(\d*)',undef,
  'MessageMode will not block messages whose score exceeds this threshold during the message but will tag them.  For example: 40'],
['PenaltyMessageLimit','High Threshold for Combined Scores per Message',3,\&textinput,50,'(\d*)',undef,
  'MessageMode will block messages whose score exceeds this threshold during the message.  For example: 50'],
['AddScoringHeader','Add PB Scoring Header',0,\&checkbox,1,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-PB-Score: " showing the score.'],
['pbdb','Penalty Box Database',40,\&textinput,'pb/pbdb','(\S*)',undef,'The directory/file with the penaltybox database files.  Use <i>noPB</i> below for removing IP\'s, or <a onmousedown="toggleDisp(\'6\')" href="./#whiteListedIPs">Whitelisted IP\'s for whitelisting</a> or <a href="./#denySMTPConnectionsFrom">Deny SMTP Connections From these IP\'s</a> for blacklisting<br /><input type="button" value=" Show BlackBox" onclick="javascript:popFileEditor(\'pb/pbdb.black.db\',4);" /><input type="button" value="Show White Box" onclick="javascript:popFileEditor(\'pb/pbdb.white.db\',4);" />'],
['noPB','Don\'t do BlackBox for these IP\'s* ',80,\&textinput,'','(.*)','ConfigMakeRe',
'Enter IP\'s that you don\'t want to be penalized. These IP\'s will be automatically removed from BlackBox.'],
['spamtrapaddresses','Penalty Trap Addresses * ',80,\&textinput,'put|your@penaltytrap.com|addresses|@here.org','(.*)','ConfigMakeRe',
  'Mail to any of these users will be stopped, but a "250 OK" is send. Whitelist will be ignored. Nothing will be stored in the Spam Collection.<br />
  @domain.com makes the whole domain a spam domain. A username without domain will register across all local domains.'],
['sendAllTraps','Catchall Address for Trap Addresses',20,\&textinput,'','(.*)',undef,
  'ASSP will try to deliver mails to all Trap Addresses  to this address.<br />
  For example: trap@mydomain.com'],
['PenaltyUseNetblocks','Use IP Netblocks',0,\&checkbox,0,'([01]?)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet  rather than on the specific IP.'],
['PenaltyError','Penalty Reply',80,\&textinput,'','(.*)',undef,
  'If set SMTP reply for Penalty Deny. eg: \'554 5.7.1 Error, send your mail to helpdesk@yourdomain.com to ensure delivery\'.'],
['PenaltyDuration','Scoring Interval',4,\&textinput,60,'(\d?\d?\d?\d?)','updatePenaltyDuration',
  "IP\'s will be rejected if their score exceeds the threshold during this interval (minutes)."],
['PenaltyLimit','Threshold',4,\&textinput,50,'(\d*)',undef,
  'PB will block IP\'s whose score exceeds this threshold during the Penalty Interval. <br /> <br />Successful ASSP checks will increase the internal score per IP. If you set the score higher, the threshold will be reached earlier. For example: 50'],
['PenaltyExpiration','Expiration Time',4,\&textinput,360,'(\d?\d?\d?\d?)','updatePenaltyExpiration',
  "Penalties will expire after this number of minutes. If set to Zero the Penalty DB (black) will be deleted and start from scratch."],
['PenaltyExtreme','Extreme Threshold',4,\&textinput,150,'(\d*)',undef,
  'If set PB will deny connections from IP\'s whose score meet or exceed this level. For example: 150'],
['DoExtremeWL','Penalize Whitelisted',0,\&checkbox,0,'([01]?)',undef,
  'Enable extreme penalties for whitelisted addresses.'],
['DoExtremeNP','Penalize NonProcessing',0,\&checkbox,0,'([01]?)',undef,
  'Enable extreme penalties for addresses on the noProcessing list.'],
['ExtremeExpiration','Expiration Time for Extreme Penalties',4,\&textinput,7,'(\d?\d?\d?\d?)',undef,,
  "Extreme penalties will expire after this number of days. For example: 7"],
['WhiteExpiration','Expiration Time for WhiteBox Entries',4,\&textinput,90,'(\d?\d?\d?\d?)',undef,,
  "The WhiteBox is always activated. The WhiteBox is similar to the  Whitelist  - but it is not a whitelist: Bayesian check will be done. WhiteBox Entries will expire after this specified number of days. For example: 90"],
['exportExtremeBlack','Exported Penalty Black Box Extreme IP\'s *',40,\&textinput,'','(\S*)',undef,
  'IP\'s in Penalty Black Box which surpassed the extreme level will be regularly stored into this file. The Penalty Box must be set to mode \> 0 for this to happen. '],
['denySMTPConnectionsFrom','Deny SMTP Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeRe',
'Manually maintained list of IP\'s which should be denied. IP\'s in noDelay,acceptAllMail,ispip,whiteListedIPs,noProcessingIPs,whitebox will pass. For example: file:files/denysmtp.txt '],
['denySMTPConnectionsFromAlways','Always Deny SMTP Connections from these IP\'s*',40,\&textinput,'','(\S*)','ConfigMakeRe',
'Manually maintained list of IP\'s which should be <b>always</b> denied access.  IP\'s in noDelay,acceptAllMail,ispip,whiteListedIPs,noProcessingIPs,whitebox will have no free pass. For example: file:files/denyalways.txt '],
['DoNotPenalizeRed','Do Not Penalize Redlisted Mails',0,\&checkbox,0,'([01]?)',undef,
  'Mails matching Red Regex or Redlist will not be penalized.'],
['DoNotPenalizeBounces','Do Not Penalize Bounced Mails',0,\&checkbox,1,'([01]?)',undef,
  'Mails matching <a onmousedown="toggleDisp(\'6\')" href="./#BounceSenders" rel="Bookmark" target="_self">Bounce Senders</a> will not be penalized.'],
['baValencePB','Bad Attachment',3,\&textinput,20,'(\d*)',undef, ''],
['satValencePB','Scoring Attachment*',3,\&textinput,20,'(\d*)',undef, '* Does apply to Message Mode only'],
['baysValencePB','Bayesian*',3,\&textinput,45,'(\d*)',undef, '* = Message Mode Only'],
['blackValencePB','BlackRe Expression*',3,\&textinput,20,'(\d*)',undef, '* = Message Mode Only'],
['blValencePB','Blacklisted Domain',3,\&textinput,20,'(\d*)',undef, ''],
['bombValencePB','Bomb Expression',3,\&textinput,25,'(\d*)',undef, ''],
['bombTestValencePB','Bomb Test Expression',3,\&textinput,0,'(\d*)',undef, ''],
['bombSuspiciousValencePB','Bomb Scoring Only Expression*',3,\&textinput,20,'(\d*)',undef, '* = MessageScoring Only'],
['erValencePB','Empty Recipients**',3,\&textinput,5,'(\d*)',undef, '** = Does apply to IP Penalizing only'],
['fhValencePB','Forged HELO',3,\&textinput,150,'(\d*)',undef, ''],
['flValencePB','Invalid Local Sender',3,\&textinput,20,'(\d*)',undef, ''],
['hlValencePB','Blacklisted HELO',3,\&textinput,20,'(\d*)',undef, ''],
['iaValencePB','Internal Only Address',3,\&textinput,25,'(\d*)',undef, ''],
['idValencePB','IP Subnet Changing Per Domain**',3,\&textinput,150,'(\d*)',undef, '** = IP Penalizing only'],
['ifValencePB','Connection per IP Frequency Limit**',3,\&textinput,150,'(\d*)',undef, '** = IP Penalizing only'],
['ihValencePB','Invalid HELO',3,\&textinput,20,'(\d*)',undef, ''],
['ilValencePB','Parallel Sessions per IP Limit**',3,\&textinput,10,'(\d*)',undef, '** = IP Penalizing only'],
['irValencePB','Invalid Recipient',3,\&textinput,5,'(\d*)',undef, ''],
['meValencePB','Max Errors Exceeded**',3,\&textinput,15,'(\d*)',undef, '** = IP Penalizing only'],
['mxValencePB','Missing MX/A Record',3,\&textinput,20,'(\d*)',undef, ''],
['ptValencePB','Missing/Invalid PTR Record',3,\&textinput,20,'(\d*)',undef, ''],
['rblnValencePB','DNSBL Neutral',3,\&textinput,25,'(\d*)',undef,''],
['rblValencePB','DNSBL Failed',3,\&textinput,100,'(\d*)',undef,''],
['rlValencePB','Failed Relay Attempt**',3,\&textinput,15,'(\d*)',undef, '** = IP Penalizing only'],
['saValencePB','Spam Collect Address**',3,\&textinput,25,'(\d*)',undef, '** = IP Penalizing only'],
['scriptValencePB','Script Expression',3,\&textinput,25,'(\d*)',undef, ''],
['spfnValencePB','SPF Neutral',3,\&textinput,5,'(\d*)',undef,''],
['spfsValencePB','SPF Softfailed',3,\&textinput,5,'(\d*)',undef,''],
['spfValencePB','SPF Failed',3,\&textinput,10,'(\d*)',undef,''],
['stValencePB','Penalty Trap Address**',3,\&textinput,50,'(\d*)',undef, '** = IP Penalizing only'],
['uriblnValencePB','URIBL Neutral*',3,\&textinput,20,'(\d*)',undef,''],
['uriblValencePB','URIBL Failed*',3,\&textinput,20,'(\d*)',undef,''],
['urimaxValencePB','Max URIs exceeded*',3,\&textinput,20,'(\d*)',undef,'* = Message Mode Only'],
['uriobfValencePB','URI Obfuscated*',3,\&textinput,20,'(\d*)',undef,'* = Message Mode Only'],
['vsValencePB','Virus suspicious*',3,\&textinput,25,'(\d*)',undef,'* = Message Mode Only'],
['vdValencePB','Virus detected',3,\&textinput,50,'(\d*)',undef, '<br /><hr />
  <div class="menuLevel1">Notes On Penalty Box</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/penaltybox.txt\',3);" />'],

[0,0,0,'heading','Validate Sender'],
['useHeloBlacklist','Use the Helo Blacklist',1,\&textinput,3,'(.*)',undef,
  'Use the list of blacklisted-helo hosts built by rebuildspamdb.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['DoFakedLocalHelo','Block Forged Helos',1,\&textinput,1,'(\d*)',undef,
  'Block remote servers that claim to come from our Local Domain/Local IP\'s/Local Host.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>.'],
['DoFakedWL','Do Not Block Whitelisted',0,\&checkbox,0,'([01]?)',undef,
  'Disable "Block Forged Helo\'s" for whitelisted addresses (not recommended).'],
['DoFakedNP','Do Not Block Noprocessing',0,\&checkbox,0,'([01]?)',undef,
  'Disable "Block Forged Helo\'s" for addresses identified as noprocessing (not recommended).'],
['myServerRe','Local IP\'s and Hostnames*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Local IP\'s and Hostnames are often use to fake (forge) the Helo. Include all IP addresses and hostnames for your server  here, separated with |. localhost is automatically included. For example: 11.22.33.44|mx.YourDomains.com|here.org','Basic'],
['heloBlacklistIgnore','Don\'t block these HELO\'s*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'HELO / EHLO greetings on this list will be excluded from the HELO checks. For example: host123.isp.com|host456.isp.com'],  
['DoValidFormatHelo','Validate Format of HELOs',1,\&textinput,3,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is validated as being ok. Meaning it *wont* be blocked.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['validFormatHeloRe','Regular Expression to Validate Format of HELO*',80,\&textinput,'^(([a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$','(.*)',,'ConfigCompileRe',
  'Validate Format HELO will check incoming HELOs according to rfc1123. <br />For example: ^(([a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$  '],
['DoInvalidFormatHelo','Regular Expression to Invalidate Format of HELOs',1,\&textinput,3,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is invalidated as being bad.  Meaning it *will* be blocked.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['invalidFormatHeloRe','Regular Expression to Invalidate Format of HELO*',80,\&textinput,'^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$','(.*)',,'ConfigCompileRe','Invalidate Format HELO will check incoming HELOs for this. <br />
  For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$,<br /> You may try a sharper one:<br />  \d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$|\d{1,3}(\.|-|x)\d{1,3}(\.|-|x)\d{1,3}|dynamic|ddns|dns\.org$'],
['DoNoValidLocalSender','Validate Remote Sender with Local Domain Address',1,\&textinput,3,'(\d*)',undef,
  'If activated, each remote sender  with a local domain is checked against the <i>Local Addresses File</i> and/or LDAP. <br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['DoNoSpoofing','Block All Remote Sender  with Local Domain Address',0,\&checkbox,0,'([01]?)',undef,
  'If activated, each remote sender address with a local domain is blocked. '],
['DoLocalSender','Do Local Addresses Check for Local Sender ',0,\&checkbox,0,'([01]?)',undef,'If set IP\'s from "Accept all Mail" must be valid local addresses.'],
['DoReversed','Reversed Lookup',1,\&textinput,3,'(.*)',undef,
  'If activated, each sender IP is checked for a PTR record. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['DoInvalidPTR','Reversed Lookup FQDN',1,\&textinput,3,'(.*)',undef,
  'If activated - and Reversed Lookup is activated -, the PTR-FQDN record is checked against the Regex. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['invalidPTRRe','Regular Expression to Invalidate Format of PTR*',80,\&textinput,'file:files/invalidptr.txt','(.*)',,'ConfigCompileRe',
  'Validate Format PTR will check PTR records for this. <br />
  For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$ or file:files/invalidptr.txt'],
['PTRCacheInterval','Reversed Lookup Cache Refresh Interval',4,\&textinput,30,'(\d?\d?\d?\d?)','configUpdatePTRCR',
  'IP\'s in cache will be removed after this interval(days). <input type="button" value=" Show PTR Cache" onclick="javascript:popFileEditor(\'pb/pbdb.ptr.db\',5);" />'],
['DoDomainCheck','Validate Sender Domain MX/A',1,\&textinput,3,'(.*)',undef,
  'If activated, each sender address is checked for a valid MX/A record.
  This requires an installed <a href="http://search.cpan.org/search?query=Email::Valid" rel="external">Email::Valid</a> module in PERL.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['MXACacheInterval','Validate Domain MX/A Cache Refresh Interval',4,\&textinput,30,'(\d?\d?\d?\d?)','configUpdateMXACR',
  'IP\'s in cache will be removed after this interval(days).<input type="button" value=" Show MX/A Cache" onclick="javascript:popFileEditor(\'pb/pbdb.mxa.db\',5);" />'],
['SenderInvalidError','Sender Validation Error',80,\&textinput,'554 5.7.1 REASON .','(.*)',undef,
  'SMTP error message to reject invalid senders. The literal REASON is replaced by (missing MX,missing PTR,invalid Helo,invalid user) depending on the check.<br /><hr />
  <div class="menuLevel1">Notes On Validate Sender</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatesender.txt\',3);" />'],

[0,0,0,'heading','Delaying/Greylisting'],
['EnableDelaying','Enable Delaying/Greylisting',0,\&checkbox,1,'([01]?)',undef,
  'Enable Greylisting as described at <a href="http://projects.puremagic.com/greylisting/whitepaper.html?view=markup" rel="external">Greylisting-whitepaper</a>.<br />
  It\'s a new method of blocking significant amounts of spam at the mailserver level, but without resorting to heavyweight statistical analysis or other heuristical approaches.'],
['DelayWL','Whitelisted Delaying',0,\&checkbox,0,'([01]?)',undef,
  'Enable Delaying for whitelisted users also.'],
['DelaySL','Spamlovers Delaying',0,\&checkbox,0,'([01]?)',undef,
  'Enable Delaying for spamlovers also.'],
['DelayAddHeader','Add X-Assp-Delayed Header',0,\&checkbox,1,'([01]?)',undef,
  'Add X-Assp-Delayed header to header of all delayed or whitelisted emails.'],
['DelayEmbargoTime','Embargo Time',5,\&textinput,5,'(\d+)',undef,
  'Enter the number of minutes for which delivery, related with new \'triplet\' (IP address of the sending<br />
  host + mail from + rcpt to), is refused with a temporary failure. Default is 5 minutes.'],
['DelayWaitTime','Wait Time',5,\&textinput,28,'(\d+)',undef,
  'Enter the number of hours to wait for delivery attempts related with recognised \'triplet\'; delivery is accepted <br />
  immediately and the \'tuplet\' (IP address of the sending host + sender\'s domain) is whitelisted. Default is 28 hours.'],
['DelayExpiryTime','Expiry Time',5,\&textinput,36,'(\d+)',undef,
  'Enter the number of days for which whitelisted \'tuplet\' is considered valid. Default is 36 days.'],
['DelayUseNetblocks','Use IP Netblocks',0,\&checkbox,1,'([01]?)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet it is at rather than the specific IP. <br />
  This feature may be useful for legitimate mail systems that shuffle messages among SMTP clients between retransmissions.'],
['DelayNormalizeVERPs','Normalize VERP Addresses',0,\&checkbox,1,'([01]?)',undef,
  'Some mailing lists (such as Ezmlm) try to track bounces to individual mails, rather than just individual recipients, <br />
  which creates a variation on the VERP method where each email has it\'s own unique envelope sender. Since the automatic <br />
  whitelisting that is built into Delaying depends on the envelope addresses for subsequent emails being the same, <br />
  the delay filter will attempt to normalize the unique sender addresses, when this option is checked.'],
['DelayExpireOnSpam','Expire Spamming Whitelisted Tuplets',0,\&checkbox,1,'([01]?)',undef,
  'If a whitelisted \'tuplet\' is ever associated with spam, viri, failed rbl, spf etc, it is deleted from the whitelist. <br />
  This renews the temporary embargo for subsequent mail involving the tuplet.'],
['CleanDelayDBInterval','Clean Up Delaying Database',10,\&textinput,3600,'(\d+)',undef,
  'Delete outdated entries from triplets and whitelisted tuplets databases every this many seconds.<br />
  Note: the current timeout must expire before the new setting is loaded, or you can restart.
  Defaults to 1 hour.'],
['noDelay','Don\'t Delay these IPs*',80,\&textinput,'file:files/nodelay.txt','(.*)','ConfigMakeRe',
  'Enter IP addresses that you don\'t want to be delayed, separated by pipes (|). There are misbehaving MTAs that will not be able to get a legitimate email through a Greylisting server because they do not try again later. An INCOMPLETE list of such mailers is available at <a href="http://cvs.puremagic.com/viewcvs/greylisting/schema/whitelist_ip.txt" rel="external">cvs.puremagic.com/viewcvs/Greylisting/schema/whitelist_ip.txt</a>. <br />
  When using mentioned list remember to add trailing dots in IP addresses which specify subnets (eg. 192.168 -> 192.168. ).<br />
  For example: 127.0.0.1|192.168.'],
['DelayError','Reply Message to Refuse Delayed E<!--get rid of google autofill-->mail',80,\&textinput,'451 4.7.1 Please try again later','(45\d .*)',undef,
  'SMTP reply message to refuse delayed mail. Default: 451 4.7.1 Please try again later
  <br /><hr />
  <div class="menuLevel1">Notes On Delaying</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/delaying.txt\',3);" />'],

[0,0,0,'heading','SPF'],
['ValidateSPF','Enable SPF Validation',1,\&textinput,0,'(.*)',undef,
  'Enable Sender Policy Framework Validation as described at <a href="http://www.openspf.org/" rel="external">www.openspf.org</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SPF::Query</a> module in PERL.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['SPFWL','Whitelisted SPF Validation',0,\&checkbox,0,'([01]?)',undef,
  'Enable Sender Policy Framework Validation for whitelisted users also.'],
['SPFNP','noProcessing SPF Validation',0,\&checkbox,0,'([01]?)',undef,
  'Enable Sender Policy Framework Validation for nonprocessed messages also.'],
['SPFtrusted','Use Trusted Forwarder List',0,\&checkbox,1,'([01]?)',undef,
'The trusted-forwarder.org domain provides a global whitelist  for users of the SPF system. It provides early adopters of SPF a way of allowing legitimate email that is sent through known, trusted email forwarders from being blocked by SPF checks simply because the forwarders do not use some sort of envelope-from rewriting system.'],
['AddSPFHeader','Add Received-SPF Header',0,\&checkbox,1,'([01]?)',undef,
  'Add Received-SPF header to header of all emails processed by SPF.'],
['SPFError','SPF Failed Reply',80,\&textinput,'554 5.7.1 failed SPF: SPFRESULT','(.*)',undef,
  'SMTP reply for SPF failed messages. Default: \'554 5.7.1 failed SPF: SPFRESULT\'<br />
  The literal SPFRESULT (case sensitive) is replaced by the actual result.'],
['LocalPolicySPF','Local SPF Policy',80,\&textinput,'v=spf1 a/24 mx/24 ptr ~all','(.*)',undef,
 'If the sending domain does not publish its own SPF Records a local policy can be defined.<br />
 The default is v=spf1 a/24 mx/24 ptr ~all'],
['noSPFRe','Skip SPF Processing Regex*',80,\&textinput,'','(.*)',,'ConfigCompileRe',
 'Mail from any of these addresses are ignored by SPF. Put anything here to identify these addresses'],
['strictSPFRe','Strict SPF Processing Regex*',80,\&textinput,'@gmail.com|@hotmail.com|@msn.com|@live.com|@aol.com|@ebay.com|@ebay.nl|@bbt.com|@paypal.com|@einsundeins.de|@microsoft.com|rr.com|veritate.com','(.*)',,'ConfigCompileRe',
 'Softfail/Neutral will be failed for these sending addresses. Put anything here to identify the addresses'],
['SPFsoftfail','Fail SPF Softfail Validations',0,\&checkbox,0,'([01]?)',undef,
  'Intentionally fail SPF softfail status responses'],
['SPFneutral','Fail SPF Neutral Validations',0,\&checkbox,0,'([01]?)',undef,
  'Intentionally fail SPF neutral status responses'],
['SPFtemp','Fail SPF Temperror  Validations',0,\&checkbox,0,'([01]?)',undef,
  'Intentionally fail SPF temperror status responses'],
['SPFperm','Fail SPF Permerror Validations',0,\&checkbox,0,'([01]?)',undef,
  'Intentionally fail SPF permerror status responses'],
['SPFCacheInterval','SPF Cache Refresh Interval',4,\&textinput,7,'(\d?\d?\d?\d?)','configUpdateSPFCR',
  'SPF records in cache will be removed after this interval in days.<input type="button" value=" Show SPF Cache" onclick="javascript:popFileEditor(\'pb/pbdb.spf.db\',6);" />'],
['DebugSPF','Enable SPF Debug output to ASSP Logfile',0,\&checkbox,0,'([01]?)',undef,
 'Enables verbose debugging of SPF queries within the Mail::SPF::Query module.
 <br /><hr />
 <div class="menuLevel1">Notes On SPF</div>
 <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spf.txt\',3);" />
 '],

[0,0,0,'heading','SRS Options'],
['EnableSRS','Enable Sender Rewriting Scheme',0,\&checkbox,0,'([01]?)','updateSRS',
  'Enable Sender Rewriting Scheme as described at <a href="http://www.openspf.org/SRS" rel="external">http://www.openspf.org/SRS</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SRS</a> module in PERL.<br />
  You should use SRS if your message handling system forwards email for domains with published spf records.<br />
  Note that you have to setup the outgoing path (Relay Host &amp; Port) to let ASSP see and rewrite your outgoing traffic.'],
['SRSAliasDomain','Alias Domain',40,\&textinput,'thisdomain.com','(.*)','updateSRSAD',
  'SPF requires the SMTP client IP to match the envelope sender (return-path). When a message is forwarded through<br />
  an intermediate server, that intermediate server may need to rewrite the return-path to remain SPF compliant.<br />
  For example: thisdomain.com'],
['SRSSecretKey','Secret Key',20,\&textinput,'','(.*)','updateSRSSK',
  'A key for the cryptographic algorithms -- Must be at least 5 characters long.'],
['SRSTimestampMaxAge','Maximum Timestamp Age',5,\&textinput,21,'(\d+)',undef,
  'Enter the maximum number of days for which a timestamp is considered valid. Default is 21 days.'],
['SRSHashLength','Hash Length',5,\&textinput,4,'(\d+)',undef,
  'The number of bytes of base64 encoded data to use for the cryptographic hash.<br />
  More is better, but makes for longer addresses which might exceed the 64 character length suggested by RFC2821.<br />
  This defaults to 4, which gives 4 x 6 = 24 bits of cryptographic information, which means that a spammer will have <br />
  to make 2^24 attempts to guarantee forging an SRS address.'],
['SRSValidateBounce','Enable Bounce Recipient Validation',0,\&checkbox,1,'([01]?)',undef,
  'Bounce messages that fail reverse SRS validation (but not a valid SMTP probe)<br />
  will receive a 554 5.7.5 [Bounce address not SRS signed] SMTP error code.'],
['noSRS','Don\'t Validate Bounces From these IPs*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Enter IP addresses that you don\'t want to validate bounces from, separated by pipes (|).
  For example: 127.0.0.1|192.168.<br /><hr />
  <div class="menuLevel1">Notes On SRS</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/srs.txt\',3);" />'],

[0,0,0,'heading','DNSBL'],
['ValidateRBL','Enable DNS Blacklist Validation ',1,\&textinput,1,'(.*)','configUpdateRBL',
  'This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. 
<br /><span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['noRBL','Don\'t do DNSBL for these IPs*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Enter IP addresses that you don\'t want to be DNSBL validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef], 
['RBLWL','Whitelisted DNSBL Validation',0,\&checkbox,1,'([01]?)',undef,
  'Enable DNSBL for whitelisted users also'],
['AddRBLHeader','Add X-Assp-Received-DNSBL Header',0,\&checkbox,1,'([01]?)',undef,
  'Add X-Assp-Received-DNSBL header to header of all emails processed by DNSBL.'],
['RBLError','DNSBL Failed Reply',80,\&textinput,'554 5.7.1 DNS Blacklisted by RBLLISTED','(.*)',undef,
  'SMTP reply for DNSBL failed messages. Default: \'554 5.7.1 DNS Blacklisted by RBLLISTED\'<br />
  The literal RBLLISTED (case sensitive) is replaced by the actual serviceproviders(s).'],
['RBLServiceProvider','RBL Service Providers* <a href="http://www.asspsmtp.org/wiki/DNSBL" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'zen.spamhaus.org|dul.dnsbl.sorbs.net','(\S*)','configUpdateRBLSP',
  'Domain Names of DNSBLs to use separated by "|". Default is <code>zen.spamhaus.org|dul.dnsbl.sorbs.net</code><br />
  You may try a more expanded list: <code>zen.spamhaus.org|bl.spamcop.net|dul.dnsbl.sorbs.net|blackholes.five-ten-sg.com</code><br /> and increase Maxreplies accordingly to 5, Maxhits should then be set to 2. '],
['RBLmaxreplies','Maximum Replies',5,\&textinput,2,'(\d*)','configUpdateRBLMR','A reply is affirmative or negative reply from a DNSBL.<br />
  The DNSBL module will wait for this number of replies (negative or positive) from the DNSBLs listed under Service Provider for up to the Maximum Time below.<br />
  This number should be equal to or less than the number of DNSBL Service Providers listed to allow for randomly unavailable DNSBLs'],
['RBLmaxhits','Maximum Hits',5,\&textinput,1,'(\d*)','configUpdateRBLMH','A hit is an affirmative response from a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider,<br />
  and flag the email with a DNSBL failure flag if at least this number of DNSBLs return a positive blacklisted response.<br />
  This number should be less than or equal to Maximum Replies above and greater than 0.<br />
   If the number of hits is greater or equal Maximum Hits, the email is flagged <b>failed</b>.<br /> If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>neutral</b>'],
['RBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time in seconds to spend on each message performing DNSBL checks.'],
['RBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the DNSBL socket read timeout in seconds.'],
['RBLCacheInterval','DNSBL Cache Refresh Interval',4,\&textinput,7,'(\d?\d?\d?\d?)','configUpdateRBLCR',
  'IP\'s in cache will be removed after this interval(days). Empty or 0 disbales the cache.<input type="button" value=" Show DNSBL Cache" onclick="javascript:popFileEditor(\'pb/pbdb.rbl.db\',5);" />'],
['ForceRBLCache','Enforce Early DNSBL Check ',0,\&checkbox,1,'([01]?)',undef,
  'If set, ASSP will use DNSBL cache hits to block the failed IP\'s as early as possible. No collecting, no CCspam.<br /><hr />
  <div class="menuLevel1">Notes On DNSBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rbl.txt\',3);" />'],  

[0,0,0,'heading','URIBL'],
['ValidateURIBL','Enable URI Blocklist Validation <a href="http://www.uribl.com/about.shtml" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="about" /></a>',1,\&textinput,'1','(.*)','configUpdateURIBL',
  'Enable URI Blocklist. Messages that fail URIBL validation will receive URIBLError SMTP error code. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. <a href="http://www.asspsmtp.org/wiki/FAQ#Common_Problems" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a><br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 =  messagescore .</span>'],
['URIBLBytes','URIBL Bytes',10,\&textinput,50000,'(\d*)',undef,
  'How many bytes of the message will be scanned for URI\'s? For example: 50000'],
['URIBLWL','Do URI Blocklist Validation for Whitelisted',0,\&checkbox,0,'([01]?)',undef,''],
['URIBLNP','Do URI Blocklist Validation for NoProcessing',0,\&checkbox,0,'([01]?)',undef,''],
['URIBLLocal','Do URI Blocklist Validation for Local Mails',0,\&checkbox,0,'([01]?)',undef,''],
['URIBLISP','Do URI Blocklist Validation for ISP/Secondary',0,\&checkbox,1,'([01]?)',undef,''],
['URIBLServiceProvider','URIBL Service Providers*',60,\&textinput,'multi.surbl.org','(.*)','configUpdateURIBLSP',
  'Domain Names of URIBLs to use separated by "|". Default is: multi.surbl.org. You may separate this in multi.uribl.com|sc.surbl.org|ws.surbl.org|ob.surbl.org|ab.surbl.org|ph.surbl.org|jp.surbl.org and set the max hits to 2 for an affirmative response.'],
['URIBLCCTLDS','URIBL Country Code TLDs*',60,\&textinput,'file:files/URIBLCCTLDS.txt','(.*)','ConfigMakeRe',
  'List of <a href="http://spamcheck.freeapp.net/two-level-tlds" rel="external">country code TLDs</a> used to determine the base domain of the uri.'],
['ValidateMaxURI','Enable maximum number of URI domains check' ,1,\&textinput,'2','(.*)',undef,'
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = messagescore .</span>'],
['URIBLmaxuris','Maximum URIs',5,\&textinput,25,'(\d*)',undef,
  'Messages with more than this number of URIs in the body will receive URIBLPolicyError SMTP error code.<br />
   This prevents DOS attacks, enter 0 to disable feature.'],
['URIBLmaxdomains','Maximum Unique Domain URIs',2,\&textinput,15,'(\d*)',undef,
  'Messages with more than this number of unique domain URIs in the body will receive URIBLPolicyError SMTP error code.<br />
   This prevents DOS attacks, enter 0 to disable feature.'],
['URIBLNoObfuscated','Disallow Obfuscated URIs <a href="http://www.pc-help.org/obscure.htm" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="obscure" /></a>',0,\&checkbox,1,'([01]?)',undef,
  'When enabled, messages with obfuscated URIs of types [integer/octal/hex IP,
other things!] in the body will receive URIBLPolicyError SMTP error code.'],
['URIBLmaxreplies','Maximum Replies',5,\&textinput,1,'(\d*)','configUpdateURIBLMR',
  'A reply is affirmative or negative reply from a URIBL.<br />
   The URIBL module will wait for this number of replies (negative or positive) from the URIBLs listed under Service Provider<br />
   for up to the Maximum Time below. This number should be equal to or less than the number of URIBL Service Providers<br />
   listed to allow for randomly unavailable URIBLs.'],
['URIBLmaxhits','Maximum Hits',5,\&textinput,1,'(\d*)','configUpdateURIBLMH',
  'A hit is an affirmative response from a URIBL.<br />
   The URIBL module will check all of the URIBLs listed under Service Provider,<br />
   and flag the email with a URIBL failure flag if more than this number of URIBLs return a postive blacklisted response.<br />
   This number should be less than or equal to Maximum Replies above and greater than 0.
   If the number of hits is greater or equal Maximum Hits, the email is flagged <b>failed</b>.
If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>neutral</b>.'],
['URIBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,
  'This sets the maximum time in seconds to spend on each message performing URIBL checks.'],
['URIBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the URIBL socket read timeout in seconds.'],
['URIBLwhitelist','Whitelisted URIBL Domains*',60,\&textinput,'doubleclick.net','(.*)','ConfigMakeRe',
  'This prevents specific domains from being checked by URIBL module. For example: file:files/URIBLwhitelist.txt'],
['noURIBL','Don\'t Check Messages from these Addresses*',60,\&textinput,'','(.*)','ConfigMakeRe',
  'Don\'t validate URIBL when messages come from these addresses. Valid entry types are as per spamlovers:  specific addresses (user@domain.com), addresses at domains (user), or entire domains (@domain.com). Separate entries with pipes: |. <br />For example: fribo@thisdomain.com|jhanna|@sillyguys.org'],
['URIBLPolicyError','URIBL Policy Abuse Reply',80,\&textinput,'554 5.7.1 Message rejected by domain policy. Contact the postmaster of this domain for resolution. This attempt has been logged.','(55\d .*|)',undef,
  'SMTP reply message to refuse URIBL policy abuse. If this field is empty, client connection is simply dropped.'],
['AddURIBLHeader','Add X-Assp-Received-URIBL Header',0,\&checkbox,1,'([01]?)',undef,
  'Add X-Assp-Received-URIBL header to header of all emails processed by URIBL.'],
['URIBLCacheInterval','URIBL Cache Refresh Interval',4,\&textinput,7,'(\d?\d?\d?\d?)','configUpdateURIBLCR',
  'Domains in cache will be removed after this interval(days). Empty or 0 will disable the cache. <input type="button" value=" Show URIBL Cache" onclick="javascript:popFileEditor(\'pb/pbdb.uribl.db\',5);" />'],
['URIBLError','Reply Message to refuse failed URIBL E<!--get rid of google autofill-->mail',80,\&textinput,'554 5.7.1 Blacklisted by URIBLNAME Contact the postmaster of this domain for resolution. This attempt has been logged.','([45]5\d .*|)',undef,
  'SMTP reply message to refuse failed URIBL mail. The literal URIBLNAME (case sensitive) is replaced by the names of URIBLs with negative response. If this field is empty, client connection is simply dropped.<br /><hr /><div class="menuLevel1">Notes On URIBL</div>
<input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/uribl.txt\',3);" />'],

[0,0,0,'heading','Attachments &amp; Viruses '],
['DoBlockExes','External Attachment Blocking ',2,\&textinput,0,'([\s01234]?)',undef,
  '<span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['BlockExes','External Attachment Blocking Level<a href="http://www.asspsmtp.org/wiki/Dealing_with_Attachments#Common_Attachments" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',2,\&textinput,0,'([\s01234]?)',undef,
  'Enter a number from 0-4 to determine which level of attachment protection to provide for external mail.<br />
  Enter 0 or leave blank for no attachment blocking. '],
['BlockWLExes','Whitelisted &amp; Local Attachment Blocking',2,\&textinput,0,'([\s01234]?)',undef,
  'Enter a number from 0-4 to determine which level of attachment protection for whitelisted &amp; local senders. '],
['BlockNPExes','NoProcessing Attachment Blocking',2,\&textinput,0,'([\s01234]?)',undef,
  'Enter a number from 0-4 to determine which level of attachment protection for no processing senders. '],
['BadAttachL1','Level 1 rejected File Extensions',80,\&textinput,'exe|scr|pif|vb[es]|js|jse|ws[fh]|sh[sb]|lnk|bat|cmd|com|ht[ab]','(.*)','updateBadAttachL1',
  'This regular expression is used to identify Level 1 attachments that should be blocked.<br />
  Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it. For example:<br />  ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]'],
['BadAttachL2','Level 2 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL2',
  'This regular expression is used to identify Level 2 attachments that should be blocked.<br />
  Level 2 already includes all rejected extensions from Level 1. For example:<br /> (ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]).zip'],
['BadAttachL3','Level 3 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL3',
  'This regular expression is used to identify Level 3 attachments that should be blocked.<br />
  Level 3 includes Level 2 and Level 1. For example: zip|url'],
['GoodAttach','Level 4 Allowed File Extensions',80,\&textinput,'','(.*)','updateGoodAttach',
  'This regular expression is used to identify  attachments that should be allowed. All others are blocked.
  Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it. For example: ai|asc|bhx|dat|doc|eps|gif|htm|html|ics|jpg|jpeg|hqx|od|pdf|ppt|rar|rpt|rtf|snp|txt|xls|zip'],
['SuspiciousAttach','Suspicious File Extensions',80,\&textinput,'gif|pdf','(.*)','updateSuspiciousAttach',
  'This regular expression is used for suspicious attachments that should not be blocked but add to the score in MessageScoring.'],
['AttachmentError','Reply Message to Refuse rejected Attachments',80,\&textinput,'550 These attachments are not allowed -- Compress before mailing.','(5\d\d .*)',undef,  ''],
['BlockUuencoded','Refuse Uuencoded Mails',0,\&checkbox,1,'([01]?)',undef,  ''],
['UuencodedError','Reply to Refused Uuencoded Mails',80,\&textinput,'554 5.7.1 This mail is uuencoded and will be blocked.','(5\d\d .*)',undef,
  'For example: 554 5.7.1 This mail is uuencoded and will be blocked'],
['UseAvClamd','Use ClamAV',0,\&checkbox,0,'([01]?)',undef,'If activated, the message is checked by ClamAV, this requires an installed <a href="http://search.cpan.org/search?query=File::Scan::ClamAV" rel="external">File::Scan::ClamAV</a> Perl module and a running <a href="http://www.asspsmtp.org/wiki/ClamAV_Win32/" rel="external" 
  target="ASSPHELP">Clamd (Windows)</a> or <a href="http://www.clamav.net/" rel="external" target="ASSPHELP">Clamd (Unix)</a>.<br />The viruses will be 
  stored in a special folder \'quarantine\' if the <a onmousedown="toggleDisp(\'21\')" href="./#SpamVirusLog" rel="Bookmark" target="_self">viruslog</a> in &#62;Collecting&#60; is set to 5 and the 
  <a onmousedown="toggleDisp(\'20\')" href="./#viruslog" rel="Bookmark" target="_self">Filepath</a> is set properly. '],
['NoScanRe','Skip ClamAV RegEx*',80,\&textinput,'','(.*)',,'ConfigCompileRe',
  "Put anything here to identify messages which should not be checked for viruses."],
['SuspiciousVirus','Suspicious Virus Scoring Regex',80,\&textinput,'','(.*)',,'ConfigCompileRe',
  'If  a  Clamd  result  matches  this expression it will be
  scored with the suspicious virus score and the message will not be blocked.'],
['ScanWL','Scan Whitelisted Senders',0,\&checkbox,0,'([01]?)',undef,''],
['ScanNP','Scan No Processing Senders',0,\&checkbox,0,'([01]?)',undef,''],
['ScanLocal','Scan Local Senders',0,\&checkbox,0,'([01]?)',undef,''],
['AvClamdPort','Port or file socket for ClamAV',20,\&textinput,'/tmp/clamd','(\S+)',undef,
  'A socket specified in the clamav.conf file - LocalSocket. For example /tmp/clamd. If the socket has been setup as a TCP/IP socket (see the TCPSocket option in the clamav.conf file), then specify the TCP socket. For example 3310 '],
['AvError','Reply Message to Refuse Infected E<!--get rid of google autofill-->mail',80,\&textinput,'554 5.7.1 Mail appears infected with \'$infection\'.','(5\d\d .*)',undef,
  'Reply message to refuse infected mail. The string $infection is replaced with the name of the detected virus.<br />
  For example: 554 5.7.1 Mail appears infected with \'$infection\' -- disinfect and resend.'],
['EmailVirusReportsTo','Virus Report Mail Address',40,\&textinput,'','(.*)',undef,
  'If set virus infos  will be sent to this address. For example: admin@domain.com'],
['EmailVirusReportsHeader','Add Full Header To Virus Report To Mail Address Above',0,\&checkbox,0,'([01]?)',undef,''],
['EmailVirusReportsToRCPT','Virus Report To Recipient',0,\&checkbox,0,'([01]?)',undef,''],
['ClamAVBytes','ClamAV Bytes',10,\&textinput,100000,'(\d*)',undef,
  'How many bytes of the message will be Virus scanned? For example: 100000<br />
  <hr /><div class="menuLevel1">Notes On Virus Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/viruscontrol.txt\',3);" />'],

[0,0,0,'heading','Regex Filters / Spambomb'],
['bombReWL','Do Bomb/Script Regular Expressions Checks for Whitelisted',0,\&checkbox,0,'([01]?)',undef,''],
['bombReNP','Do Bomb/Script Regular Expressions Checks for NoProcessing',0,\&checkbox,0,'([01]?)',undef,''],
['bombReLocal','Do Bomb/Script Regular Expressions Checks for Local Mails',0,\&checkbox,0,'([01]?)',undef,''],
['bombReISP','Do Bomb/Script Regular Expressions Checks for ISPIP',0,\&checkbox,0,'([01]?)',undef,''],
['DoBombSenderRe','Use BombSender Regular Expression','1',\&textinput,0,'(\d*)',undef,
  'If activated, each Sender address is checked  against the BombSender Regular Expression.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['bombSenderRe','BombSender Blocking Regular Expression *',80,\&textinput,'\d\d\d\d\d\d@tom.com','(.*)',,'ConfigCompileRe',
  'Expression to identify sender you want to block very early. If an incoming sender matches this Perl regular expression connection will be dropped. Whitelist and Nonprocessing will be honored.<b> No ccSPAM possible</b>.'],
['DoBombHeaderRe','Use BombHeader Regular Expressions on Header Part','1',\&textinput,0,'(\d*)',undef,
  'If activated, each message-header is checked  against bombHeaderRe,bombSubjectRe and bombCharSets Regular Expressions. <b>ccSPAM will copy only the header</b>.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['bombHeaderRe','Regular Expression to Identify Spam in Header Part*',80,\&textinput,'\d\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s+\d\d\d\d\s+\d\d:\d\d(:\d\d)?\s+[+\-]\d\d[6-9]\d','(.*)',,'ConfigCompileRe',
  'Header will be checked against the Regular Expression. For example:<br /> \d\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s+\d\d\d\d\s+\d\d:\d\d(:\d\d)?\s+[+\-]\d\d[6-9]\d'],
['bombSubjectRe','Regular Expression to Identify Spam in Subject*',80,\&textinput,'','(.*)',,'ConfigCompileRe',''],
['bombCharSets','Regular Expression to Identify Spam in Header Part* ',60,\&textinput,'BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251','(.*)',,'ConfigCompileRe','Header will be checked against this Regex. For example:<br /> [\x80-\xFF]|\x0D[^\x0A]|BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251. '],
['DoBombRe','Use Bomb Regular Expressions<a href="http://www.asspsmtp.org/wiki/BombRe_and_ScriptRe"><img src="' . $wikiinfo . '" alt="wiki" /></a>','1',\&textinput,0,'(\d*)',undef,
  'If activated, each message is checked  against BombRaw and BombData Regular Expressions. <br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['bombRe','BombRaw Regular Expression for Header and Data Part*',80,\&textinput,'file:files/bombre.txt','(.*)',,'ConfigCompileRe','Header and Data will be checked against this Regular Expression.  For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;'],
['bombDataRe','BombData Regular Expression for Data Part*',80,\&textinput,'file:files/bombre.txt','(.*)',,'ConfigCompileRe','Data will be checked against the Regular Expression  with  option is. For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;'],
['bombSuspiciousRe','Regular Expression for Message Scoring Only*',80,\&textinput,'unsubscribe','(.*)',,'ConfigCompileRe','Header and Data will be checked for scoring only. For example:<br />unsubscribe'],
['noBombScript','Don\'t Check Messages from these Addresses*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Don\'t detect spam bombs or scripts in messages from these addresses. Valid entry types are as per spamlovers.'],
['DoTestRe','BombTest Regular Expression',0,\&checkbox,0,'([01]?)',undef,
  'If activated, each message is checked  against this BombTest Regular Expression. Matches will be shown in log, no other action. '],
['testRe','BombTest Regular Expression*',80,\&textinput,'','(.*)',,'ConfigCompileRe',''],
['bombError','Spam Bomb Error',80,\&textinput,'554 5.7.1 Delivery not authorized, message refused -- .','(.*)',undef,
  'SMTP error message to reject spam bombs. For example: 554 5.7.1 Delivery not authorized, message refused -- send report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90'],
['bombErrorReason','Add Reason',0,\&checkbox,1,'([01]?)',undef,  'Add matching expression to Spam Bomb Error'],
['DoScriptRe','Use Regular Expression to Identify Mobile Scripts','1',\&textinput,0,'(\d*)',undef,
  'Each message is checked  against the Expression to Identify Mobile Scripts.<br />
  <span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span>'],
['scriptRe','Regular Expression to Identify Mobile Scripts*',80,\&textinput,'','(.*)',,'ConfigCompileRe',
  'Spam emails may contain mobile scripting code, eg activex and java. You can use this feature to block those messages.<br />
  Leave this blank to disable the feature. For example:<br /> \&lt;applet|\&lt;embed|\&lt;iframe|\&lt;object|\&lt;script|onmouseover|javascript:'],
['scriptError','Script Error',80,\&textinput,'554 5.7.1 Your email contains html scripting code -- please resend as plain text.','(.*)',undef,
  'SMTP error message to reject scripts. For example: 554 5.7.1 Your email appears to be spam -- send an error report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90
  <br /><hr /><div class="menuLevel1">Notes On Bomb Regex</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bombre.txt\',3);" />'],

[0,0,0,'heading','Bayesian Options'],
['DoBayesian','Bayesian Check <a href="http://www.asspsmtp.org/wiki/General_ASSP_Questions#Theory_of_Operation"><img src="' . $wikiinfo . '" alt="Theory of Operation" /></a>',1,\&textinput,0,'(.*)',undef,
  'If activated, the message is checked based on Bayesian factors in Spamdb. This needs a fully functional spamdb built by rebuildspamdb.pl. When starting out it is best practice to put this inactivate and build the spamdb collection with the help of DSNBL and URIBL. BlackRE and WhiteRE checks will be performed even if inactive. <br />
<span class="negative"> 0 = inactive, 1 = active, 2 = monitor, 3 = score.</span> $showbaysTestMode'],
['noBayesian','Skip Bayesian Check*',60,\&textinput,'','(.*)','ConfigMakeRe',
  'Mail from any of these addresses are ignored by Bayesian check, mails will not be stored in spam/notspam collection .'],
['baysSpamLoversRed','Do not store Bayesian Spam-Lover in SpamDB',0,\&checkbox,0,'([01]?)',undef,
'Mail to Bayesian SpamLover will not be stored in Spam/Notspam folder.'],
['baysConfidence','Bayesian Confidence Threshold (experimental)',3,\&textinput,'','(.*)',undef,' Spam-Mails having a confidence below this threshold are passed in testmode .
  Spam-Mails having a confidence above this threshold are blocked. Set this only above 0 if you are familiar with the bayesian statistics used in ASSP.
  Messages that are processed by the bayesian check get a spam-probability score and a confidence score. The confidence score in assp is a quality indicator. A confidence near 0 would mean the probability score is like a wild guess. A confidence score near 1 would mean that it\'s pretty sure that the bayesian analysis result is correct. The confidence threshold is an allowance to process a Bayesian spam as-if in Bayesian Test Mode, if the message\'s *confidence* score is lower than the confidence threshold.
  Set this level to a specfic value, let\'s say .001, then:<br />
  - messages with spam-probability higher than 0.6 and a confidence of less than .001 would come through as in test mode<br />
  - messages with spam-probability higher than 0.6 and a confidence of more than .001 would be blocked<br />
  - messages with spam-probability less than 0.6 would pass<br />
  The 0.6 threshold is built-in.
  Setting the confidence threshold to 0.001 will result (in our experience) in 1/3 passing in testmode because there is too much doubt about the correctness of the result of the bayesian check. 
  <br /><span class="negative"> empty = disabled</span>.'],
['baysConfidenceHalfScore','Reduce Scoring for Low Confidence',0,\&checkbox,1,'([01]?)',undef,
'Spam-Messages having a confidence below the threshold and get half of the normal penalty score for bayesian hits.'],
['NoTagInTestmode','No Subject Tag in Testmode',0,\&checkbox,0,'([01]?)',undef,
  'In Bayesian testmode "/Prepend Spam Subject/" is only added if message is spam and confidence is higher than Bayesian Confidence Threshold" .'],
['AddConfidenceHeader','Add Bayes Confidence Header',0,\&checkbox,0,'([01]?)',undef,
  'Adds a line to the email header "X-Assp-Bayes-Confidence: 0.0123".<br /><hr />
  <div class="menuLevel1">Notes On Bayesian</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bayesian.txt\',3);" />'],

[0,0,0,'heading','TestModes'],
['spamSubject','Prepend Spam Subject <a href="http://www.asspsmtp.org/wiki/Getting_Started#Rebuild_your_Bayesian_database."><img src="' . $wikiinfo . '" alt="Testmode" /></a>',20,\&textinput,'','(.*)',undef,'Setting a filter to testmode will tell ASSP not to reject the mail but rather build up the whitelist and spam and notspam collections. This can go on for some time without disturbing normal operation. After this very important phase testmode can be used to tag the message: if TestMode and the message is spam Spam Subject gets prepended to the subject of the email. For example: [SPAM]','Basic'],
['spamTag','Prepend Spam Tag',0,\&checkbox,0,'([01]?)',undef,'ASSP use many methods. The method which caught the spam  will be prepended to the subject of the email. For example; [RBL]','Basic'],
['testScoringMode',"Message Scoring ",0,\&checkbox,1,'([01]?)',undef,
 'Put the filter automatically in "Message Scoring" when <a onmousedown="toggleDisp(\'8\')" href="./#DoPenaltyMessage">Message Scoring</a> is set  (instead of stopping spam processing altogether).'],
['allTestMode','All Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['baysTestMode','Bayesian Test Mode',0,\&checkbox,1,'([01]?)',undef,''],
['blTestMode','BlackDomain Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['hlTestMode','Helo-Blacklist Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['sbTestMode','Spam Address Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['spfTestMode','SPF Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['rblTestMode','DNSBL Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['attachTestMode','Bad Attachment Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['uriblTestMode','URIBL Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['srsTestMode','SRS Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['bombTestMode','Bomb Regex Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['scriptTestMode','Script Regex Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['mxaTestMode','Missing MX/A Record Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['ptrTestMode','Reversed Lookup Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['ihTestMode','Invalid Helo Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['fhTestMode','Forged Local Helo Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['flsTestMode','Forged Local Sender Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['msTestMode','Message Scoring Test Mode',0,\&checkbox,0,'([01]?)',undef,''],
['pbTestMode','Penalty Box Test Mode',0,\&checkbox,0,'([01]?)',undef,'<br /><hr />
  <div class="menuLevel1">Notes On Testmode</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/testmode.txt\',3);" />'],

[0,0,0,'heading','Email Interface'],
['EmailInterfaceOk','Enable Email Interface',0,\&checkbox,1,'([01]?)',undef,
  'Checked means that you want ASSP to intercept and parse mail to the following usernames at any localdomains.<br />
  If you are using RelayHost and RelayPort see <a href="http://assp.sourceforge.net/fom/cache/45.html" rel="external">this note</a>.'],
['EmailSenderOK','Accept Emails (Reports) from these external addresses*',40,\&textinput,'','(.*)','ConfigMakeRe',
  'Allow these external domains/addresses to report to the email 
interface.  By default, ASSP only accepts reports from local or authenticated users.<br />'],  
['EmailAdminReportsTo','Admin Mail Address',40,\&textinput,'','(.+)',undef,
  'If set internal warnings/infos  will be sent to this address. For example: admin@domain.com'],
['EmailHelp','Help Address<a href="http://www.asspsmtp.org/wiki/Getting_Started#Instructions_for_use_for_your_end_users." target="ASSPHELP"><img src="' . $wikiinfo . '" alt="doku" /></a>',20,\&textinput,'assphelp','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request for help. Do not put the full address here, just the user part. For example: assphelp 
  <input type="button" value=" Edit helpreport.txt file" onclick="javascript:popFileEditor(\'reports/helpreport.txt\',2);" />'],
['EmailSpam','Report Spam Address',20,\&textinput,'asspspam','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a spam report. Do not put the full address here, just the user part. For example: asspspam 
  <input type="button" value=" Edit spamreport.txt file" onclick="javascript:popFileEditor(\'reports/spamreport.txt\',2);" />','Basic'],
['EmailHam','Report not-Spam Address',20,\&textinput,'asspnotspam','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a false-positive report. Do not put the full address here, just the user part.<br /> 
  For example: asspnotspam
  <input type="button" value=" Edit notspamreport.txt file" onclick="javascript:popFileEditor(\'reports/notspamreport.txt\',2);" />','Basic'],
['EmailErrorsReply','Reply to Spam/Not-Spam Reports',1,\&textinput,1,'(\d*)',undef,
  '<span class="negative"> 0 = no report, 1 = to SENDER, 2 = to TO address (below), 3 = BOTH</span>'],
['EmailErrorsTo','TO Address for Spam/Ham-Reports',40,\&textinput,'','(.+)',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com<br />'],  
['EmailWhiteRemovalToRed','Add  Whitelist Removals To Redlist ',0,\&checkbox,0,'([01]?)',undef,
  'If set addresses which are removed from Whitelist will  automatically be added to the Redlist. The address can only be added again to the Whitelits after it is removed from the Redlist.'],
['EmailErrorsModifyWhite','Combined Spam/Ham Report &amp; Whitelist Add/Remove',0,\&checkbox,0,'([01]?)',undef,
  'If set Ham Reports will additionally add addresses to the Whitelist, Spam Reports will additionally remove addresses from the Whitelist. ','Basic'],
['EmailWhitelistAdd','Add to Whitelist Address',20,\&textinput,'asspwhite','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the whitelist. Do not put the full address here, just the user part. <br />For example: asspwhite
  <input type="button" value=" Edit whitereport.txt file" onclick="javascript:popFileEditor(\'reports/whitereport.txt\',2);" />','Basic'],
['EmailWhitelistRemove','Remove from Whitelist Address',20,\&textinput,'asspnotwhite','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the whitelist. Do not put the full address here, just the user part. <br />For example: asspnotwhite
  <input type="button" value=" Edit whiteremovereport.txt file" onclick="javascript:popFileEditor(\'reports/whiteremovereport.txt\',2);" />','Basic'],
['EmailWhitelistReply','Reply to Add to/Remove from Whitelist',1,\&textinput,1,'(\d*)',undef,
  '<span class="negative"> 0 = no report, 1 = to SENDER, 2 = to TO address (below), 3 = BOTH</span>'],
['EmailWhitelistTo','To Address for Whitelist-Reports',40,\&textinput,'','(.+)',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com'],
['EmailRedlistAdd','Add to Redlist Address',20,\&textinput,'asspred','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the redlist. Do not put the full address here, just the user part. <br />For example: asspred.
  <input type="button" value=" Edit redreport.txt file" onclick="javascript:popFileEditor(\'reports/redreport.txt\',2);" />'],
['EmailRedlistRemove','Remove from Redlist Address',20,\&textinput,'asspnotred','(.*)',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the redlist.<br />
  Do not put the full address here, just the user part. <br />For example: asspnotred
  <input type="button" value=" Edit redremovereport.txt file" onclick="javascript:popFileEditor(\'reports/redremovereport.txt\',2);" />'],
['EmailRedlistReply','Reply to Add to/Remove from Redlist',1,\&textinput,1,'(\d*)',undef,
  '<span class="negative"> 0 = no report, 1 = to SENDER, 2 = to TO address (below), 3 = BOTH</span>'],
['EmailRedlistTo','To Address for Redlist-Reports',40,\&textinput,'','(.+)',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@domain.com'],
['EmailFrom','From Address for Reports',40,\&textinput,'<spammaster@yourdomain.com>','(.+)',undef,
  'Email sent from ASSP acknowledging your submissions will be sent from this address.'],
['NoHaiku','Legacy: Don\'t reply to messages to the Email Interface',0,\&checkbox,0,'([01]?)',undef,
  'Check this option to suppress email reports for spam and not-spam reports, whitelist and redlist additions/deletions via the email interface.<br /><hr />
  <div class="menuLevel1">Notes On Email Interface</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/emailinterface.txt\',3);" />'],

[0,0,0,'heading','File Paths'],
['base','Directory Base',40,\&textinput,'.','',undef,'All paths are relative to this folder.<br />
  <b>Note: this must be changed as a command line parameter and is displayed here for reference only.</b>'],
['spamlog','Spam Collection',40,\&textinput,'spam','(\S+)',undef,'The folder to save the collection of spam emails. This directory will be used in building the spamdb. For example: spam'],
['notspamlog','Not-spam Collection',40,\&textinput,'notspam','(\S+)',undef,'The folder to save the collection of not-spam emails. This directory will be used in building the spamdb. For example: notspam'],
['incomingOkMail','OK Mail',40,\&textinput,'okmail','(.*)',undef,'The folder to save non-spam (message ok). These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. If you want to keep copies of ok mail then put in a directory name. This directory will not be used in building the spamdb. Default: okmail'],
['viruslog','Attachment/Virus Collection',40,\&textinput,'quarantine','(.*)',undef,
  'The folder to save rejected attachments and virii. Leave this blank to not save these files (default). If you want to keep copies of rejected content then put in a directory name. Note: you must create the directory. This directory will not be used in building the spamdb. For example: quarantine'],
['correctedspam','False-negative Collection',40,\&textinput,'errors/spam','(\S+)',undef,
  'Spam that got through -- counts double. This directory will be used in building the spamdb. For example: errors/spam'],
['correctednotspam','False-positive Collection',40,\&textinput,'errors/notspam','(\S+)',undef,
  'Good mail that was listed as spam, count 4x. This directory will be used in building the spamdb. For example: errors/notspam'],
['maillogExt','Extension for Mail Files',20,\&textinput,'.eml','(\S*)',undef,
  'Enter the file extension (include the period) you want appended to the mail files in the mail collections.<br />
  Leave it blank for no extension. For Example: .eml'],
['spamdb','Spam Bayesian Database File',40,\&textinput,'spamdb','(\S+)',undef,'Filename for the Bayesian database.'],
['whitelistdb','E<!--get rid of google autofill-->mail Whitelist Database File',40,\&textinput,'whitelist','(\S+)',undef,'The file with the whitelist.<br />
  Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['redlistdb','E<!--get rid of google autofill-->mail Redlist Database File',40,\&textinput,'redlist','(\S+)',undef,'The file with the redlist.<br />
  Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['griplist','GReyIPlist Database',40,\&textinput,'griplist','(\S*)',undef,'The file with the current GRey-IP-List  database -- make this blank if you don\'t use it.'],
['delaydb','Delaying Database',40,\&textinput,'delaydb','(\S*)',undef,'The file with the delay database.<br />Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['myhost','MySQL hostname or IP',40,\&textinput,'','(\S*)',undef,
  'You need <a href="http://search.cpan.org/~lds/Tie-DBI-1.02/lib/Tie/RDBM.pm"
  rel="external">Tie::RDBM</a> to use MySQL instead of local files.<br /> This way you can share whitelist, delaydb and redlist between servers'],
['mydb','MySQL database name',40,\&textinput,'','(\S*)',undef,
  'This database must exist before starting ASSP, necessary tables will be created automatically into this database'],
['myuser','MySQL username',40,\&textinput,'','(\S*)',undef,
  'This user must have CREATE privilege on database to create tables automatically'],
['mypassword','MySQL password',40,\&textinput,'','(\S*)',undef,''],
['logfile','ASSP Logfile',40,\&textinput,'logs/maillog.txt','(\S*)','ConfigChangeLogfile',
  'Blank if you don\'t want a log file. Change it to maillog.log if you don\'t want auto rollover.
  NOTE: Changing this field requires restarting ASSP before changes take effect.'],
['pidfile','PID File',40,\&textinput,'pid','(\S*)',undef,'Blank to skip writing a pid file. *nix users need pid files.
  Leave it blank in Windows.<br /> You have to restart the service before you get a pid file in the new location.<br /><hr /><div class="menuLevel1">Notes On File Path</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/filepath.txt\',3);" />'],

[0,0,0,'heading','Collecting'],
['spamaddresses','Spam Collect Addresses* ',80,\&textinput,'put|your@spambucket.com|addresses|@here.org','(.*)','ConfigMakeRe',
  'Mail to any of these users are always spam and will contribute to the spam-collection unless from someone on the whitelist;<br />
  @domain.com makes the whole domain a spam domain. A username without domain will register across all local domains.'],
['sendAllCollect','Catchall Address for Collect Addresses',20,\&textinput,'','(.*)',undef,
  'ASSP will try to deliver mails to all Collect Addresses  to this address.<br />
  For example: collect@mydomain.com'],
['UseSubjectsAsMaillogNames','Use Subject as Maillog Names',0,\&checkbox,0,'([01]?)',undef,
  'You can turn this on to help you manually identify mail in your spam and non-spam collections. This will prevent ASSP from controlling the number of files in your collections(->MAXFILES). If your collections grow  over 1000 items run <b>move2num.pl</b> and turn this off.'],
['DoNotCollectRed','Do Not Collect Redlisted Mails',0,\&checkbox,1,'([01]?)',undef,
  'Mails (Spam/Ham) matching Red Regex or Redlist will not be stored.'],
['DoNotCollectBounces','Do Not Collect Bounced Mails',0,\&checkbox,1,'([01]?)',undef,
  'Mails matching &lt;Bounce Senders&gt; will not be collected.'],
['MaxFiles','Max Files',10,\&textinput,14000,'(\d+)',undef,
  'If you\'re not using subjects as file names, this is the maximum
  number of files to keep in each collection (spam &amp; nonspam)<br />
  It\'s actually less than this -- files get a random number between 1 and $MaxFiles.'],
['FilesDistribution','Files Distribution',4,\&textinput,0.5,'(0\.\d?[1-9]+|1)',undef,
  'This defines how file names are chosen in each collection. If set to 1, names are uniformly distributed. If set between 0.01 and 0.99, names distribution is exponential -- files get lower numbers more frequently. This prevents from corpus being refreshed too quickly, especially when MaxFiles is set to low value (ex. 3000)<br />
Recommended: 1 or 0.05-0.5, Default: 0.5'],
['MaxBytes','Max Bytes',10,\&textinput,4000,'(\d+)',undef,
  'How many bytes of the message will ASSP look at? Mails stored in the collecting folders will be truncated to this size. For example: 4000'],
['ErrorMaxBytes','Error Max Bytes',10,\&textinput,10000,'(\d+)',undef,'How many bytes of an error report message will ASSP look at. For example: 10000.'],
['wlAttachLog','Whitelisted rejected Attachments',1,\&textinput,5,'(\d*)',undef,
  'Where to store Whitelisted rejected mail+attachments. Recommended : 5 <br /><span class="negative">1 = spamfolder, 2 = notspam folder, 3 = spamfolder &amp; ccallspam, 4 = mailok folder, 5 = attachment folder, 6 = discard, 7 = discard &amp; ccallspam.</span><br />'],
['npAttachLog','No Processing rejected Attachments',1,\&textinput,7,'(\d*)',undef,'Where to store external rejected mail+attachments. Recommended: 6'],
['extAttachLog','External rejected Attachments',1,\&textinput,7,'(\d*)',undef,'Where to store external rejected mail+attachments. Recommended: 6'],
['SpamVirusLog','Virus Infected',1,\&textinput,6,'(\d*)',undef,'Where to store virus infected mails. Recommended: 6 '],
['spamBombLog','Spam Bombs',1,\&textinput,6,'(\d*)',undef,'Where to store spam bombs. Recommended: 6 or 7'],
['scriptLog','Scripts',1,\&textinput,3,'(\d*)',undef,'Where to store scripted emails. Recommended: 3'],
['baysNonSpamLog','OK Mail',1,\&textinput,6,'(\d*)',undef,'Where to store non spam (message ok) emails. These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. Put 4 here if you want them to be stored in okmail-folder (outside the spamdb-collection). Put 2 here if you want them to be stored in the HAM folder. '],
['NonSpamLog','Non Spam',1,\&textinput,2,'(\d*)',undef,'Where to store whitelisted/local  non spam emails. Recommended: 2.'],
['blDomainLog','Blacklisted Domains',1,\&textinput,3,'(\d*)',undef,'Where to store blacklisted domain emails. Recommended: 3'],
['spamHeloLog','Spam Helos',1,\&textinput,6,'(\d*)',undef,'Where to store spam helo emails. Recommended: 6 or 7.'],
['forgedHeloLog','Forged Helos',1,\&textinput,6,'(\d*)',undef,'Where to store forged helo emails. Strongly recommended: 6 '],
['spamBucketLog','Spam Collect Addresses',1,\&textinput,1,'(\d*)',undef,'Where to store emails addressed to Spam Collect Addresses. Recommended: 1'],
['baysSpamLog','Bayesian Spams',1,\&textinput,3,'(\d*)',undef,'Where to store Bayesian spam emails. Recommended: 3'],
['SPFFailLog','SPF Failures',1,\&textinput,3,'(\d*)',undef,'Where to store SPF Failure spam emails. Recommended: 3'],
['RBLFailLog','DNSBL Failures',1,\&textinput,3,'(\d*)',undef,'Where to store DNSBL Failure spam emails. Recommended: 3'],
['URIBLFailLog','URIBL Failures',1,\&textinput,3,'(\d*)',undef,'Where to store URIBL Failure spam emails. Recommended: 3'],
['SRSFailLog','SRS Failures',1,\&textinput,3,'(\d*)',undef,'Where to store SRS Failure (not signed bounces) spam emails. Recommended: 3'],
['spamPTRLog','Missing/Invalid Pointer ',1,\&textinput,3,'(\d*)',undef,'Where to store Missing/Invalid Pointer rejected emails. Recommended: 3'],
['spamMXALog','Missing MX/A Record ',1,\&textinput,3,'(\d*)',undef,'Where to store Missing MX/A record rejected emails. Recommended: 3'],
['spamISLog','Invalid Sender Failures',1,\&textinput,6,'(\d*)',undef,'Where to store Invalid Sender rejected emails. Recommended: 6 or 7'],
['spamMSLog','Message Scoring Blocks',1,\&textinput,3,'(\d*)',undef,'Where to store Message Scoring rejected emails. Recommended: 3'],
['spamPBLog','PB Blocks',1,\&textinput,6,'(\d*)',undef,'Where to store PB rejected emails. Recommended: 6 or 7'],
['freqNonSpam','Non Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog2','Store every n\'th non spam message. If you set the value to 10 then every 10th message is logged. These frequency settings are for ASSP users with a mature installation who experience heavy mail or spam volumes. Enter a larger value if the non spam corpus is being refreshed too quickly. Default Value = 1, log every message.'],
['freqSpam','Spam Collection Frequency',5,\&textinput,1,'(\d*)','updateLog3','Store every n\'th spam message. The same as for non spam but helps prevent spam corpuses being skewed by flooding. It is recommended that this be set depending on spam volume. Default value = 1, log every message.<br /><hr /><div class="menuLevel1">Notes On Collecting</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/collecting.txt\',3);" />'],

[0,0,0,'heading','Logging'],
['fileLogging','File name logging',0,\&checkbox,0,'([01]?)',undef,'Show file names in log '],
['subjectLogging','Subject logging',0,\&checkbox,0,'([01]?)',undef,'Show subject of mail in log '],
['regexLogging','Regex Match logging',0,\&checkbox,1,'([01]?)',undef,'Show matching regex in log, note that all lists (like e.g. noprocessing-list) are used as regex. '],
['AddRegexHeader','Add  RegEx Match Header',0,\&checkbox,0,'([01]?)',undef,''],
['uniqeIDLogging','Unique ID logging',0,\&checkbox,0,'([01]?)',undef,'Add unique string to log  '],
['uniqueIDPrefix','Prepend Unique ID logging',10,\&textinput,'','(.*)',undef,'Prepend ID. For example: m1-'],
['tagLogging','Spam Tag Logging',0,\&checkbox,1,'([01]?)',undef,'Add spam tag to log.'],
['sysLog','SYSLOG Centralized Logging',0,\&checkbox,0,'([01]?)',undef,'Enables logging to UNIX Syslog. Needs Sys::Syslog for local (UNIX/LINUX) logging or Net::Syslog for Windows or Network logging.'],
['sysLogPort','Syslog Port (UDP)',5,\&textinput,'514','([\d\.]+)',undef,'Port for Syslog logging with Net::Syslog.'],
['SysLogFac','Syslog Facility',40,\&textinput,'mail','(\S*)',undef,
  'Syslog Facility. Valid are kern, user, mail, daemon, auth, syslog, lpr, news, uucp, cron, authpriv, ftp, local0, local1, local2, local3, local4, local5, local6'],
['sysLogIp','Syslog IP',40,\&textinput,'127.0.0.1','(\S*)',undef,
  'IP Address of your Syslog Daemon for Syslog logging with Net::Syslog.'],
['asspLog','ASSP local logging',0,\&checkbox,'1','(.*)',undef,'ASSP manages local logging. The logs <a href="./#logfile">are stored</a> inside the directory where ASSP is installed.'],
['LogRollDays','Roll the Logfile How Often?',5,\&textinput,'7','([\d\.]+)',undef,
  'ASSP closes and renames the log file after this number of days.'],
['silent','Silent Mode',0,\&checkbox,0,'([01]?)',undef,'Checked means don\'t print log messages to the console. AsADaemon overrides this.'],
['DEBUG','Debug Mode',0,\&checkbox,0,'([01]?)','ConfigDEBUG','Checked sends debugging info to a .dbg file.
  Leave this unchecked unless there is a program error you are trying to track down.'],
['noLog','Don\'t Log these IPs*',80,\&textinput,'','(\S*)','ConfigMakeRe',
  'Enter IP addresses that you don\'t want to be logged, separated by pipes (|).<br />
  This can be IP address of the SMTP service monitoring agent. For example: 127.0.0.1|10.'],
['ConnectionLog','Connections Logging',0,\&checkbox,0,'([01]?)',undef,
  'Log an event each time a new connection is received.'],
['SessionLog','Session Limit Logging',0,\&checkbox,1,'([01]?)',undef,
  'Log an event each time the above session limits are triggered.'],
['denySMTPLog','Enables Logging for \'Deny SMTP Connections From\'',0,\&checkbox,1,'([01]?)',undef,'Enables logging for \'Deny SMTP Connections From\', \'Deny SMTP Connections From Always\', \'Exported Extreme File\'.'],
['LDAPLog','Enable LDAP logging',0,\&checkbox,0,'([01]?)',undef,
  'Enables verbose logging of LDAP actions in the maillog. Default is to log  errors only.'],
['ValidateUserLog','Enable User Validation logging',1,\&textinput,1,'(.*)',undef,
  'Enables logging of local address validation actions in the maillog.<br />
  <span class="negative"> 0 = no log, 1 = failures only, 2 = all </span>'],
['PenaltyLog','Enable PenaltyBox logging',1,\&textinput,1,'(\d*)',undef,
  'Enables logging of all PB actions in the maillog.<br />
  <span class="negative"> 0 = no log, 1 = failures only, 2 = all </span>'],
['MessageLog','Enable Message Scoring logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables logging in the maillog.'],
['ValidateSenderLog','Enable Validate Sender Logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables Sender Validation logging in the maillog'],
['DelayLog','Enable Greylisting/Delaying logging',0,\&checkbox,0,'([01]?)',undef,
  'Enables Greylisting/Delaying events in the maillog.'],
['SPFLog','Enable SPF logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables logging of all SPF checks in the maillog. Default is failures only.'],
['RBLLog','Enable DNSBL logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables logging of DNSBL checks in the maillog. Default is failures only.'],
['RWLLog','Enable RWL logging',0,\&checkbox,0,'([01]?)',undef,
  'Enables logging of all RWL checks in the maillog.'],
['URIBLLog','Enable URIBL logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables logging of all URIBL checks in the maillog. Default log failures only.'],
['ScanLog','Enable ClamAV logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables logging of ClamAV events in the maillog.'],
['BayesianLog','Enable Bayesian Logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables verbose logging of  Bayesian checks in the maillog.'],
['MaintenanceLog','Enable Maintenance logging',0,\&checkbox,1,'([01]?)',undef,
  'Enables verbose logging of all maintenance actions (whitelist saving, delaying databases cleaning) in the maillog.'],
['Showmaxreplies','Show All Possible Hits ',0,\&checkbox,0,'([01]?)',undef,
  'Show hits until maxreplies instead of stopping at maxhits (RBL,URIBL,RWL).'],
['RegExLength','RegEx Length in Log',2,\&textinput,32,'(\d*)',undef,
  'Defines how many bytes of a matching Regular Expression will be shown in the log<br />
  Some matching Regular Expressions are too long for one line. Default: 32'],
['sendNoopInfo','Send NOOP Info',0,\&checkbox,0,'([01]?)',undef,
  'Checked means you want ASSP to send a "NOOP Connection from $ip" message to your SMTP server.
  <br /><hr />
  <div class="menuLevel1">Notes On Logging</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/logging.txt\',3);" />'],

[0,0,0,'heading','LDAP Setup'],
['LDAPHost','LDAP Host(s)',80,\&textinput,'localhost','(\S*)','updateLDAPHost',
  'Enter the DNS-name(s) or IP address(es) of the server(s) that run(s) the LDAP database. Second entry is backup. For example: localhost. Separate entries with pipes: eg. LDAP-1.domain.com|LDAP-2.domain.com' ],
['LDAPLogin','LDAP Login',80,\&textinput,'','(.*)',undef,
  'Most LDAP servers require a login and password before they allow queries.<br />
  Enter the DN specification for a user with sufficient permissions here.<br />
  For example: cn=Administrator,cn=Users,DC=yourcompany,DC=com'],
['LDAPPassword','LDAP Password',20,\&passinput,'','(.*)',undef,
  'Enter the password for the specified LDAP login here.'],
['LDAPRoot','LDAP Root container',80,\&textinput,'','(.*)',undef,
  'The LDAP lookup will use this container and all sub-containers to match the query.<br />
  The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: DC=yourcompany,DC=com.<br />  If you use DOMAIN here, you must check "LDAP failures return false"
  below or non local domains will be treated as local'],
['ldLDAPFilter','LDAP Filter for Local Domains',80,\&textinput,'','(\S*)',undef,
  'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />
  The filter must return an entry if the domain must be relayed.<br />
  The literal DOMAIN is replaced by the domain name during the search.<br />'],
['LDAPFilter','LDAP Filter for Local Addresses',80,\&textinput,'','(\S*)',undef,
  'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />
  The filter must return an entry if the recipient address matches with that of any user.<br />
  The literal EMAILADDRESS is replaced by the fully qualified SMTP recipient (eg. user@domain.com) during the search.<br />The literal USERNAME is replaced by the user part of SMTP recipient
  (eg. user) during the search.<br />
  The literal DOMAIN is replaced by the domain part of SMTP recipient
  (eg. domain.com) during the search.<br />
  For example: (proxyaddresses=smtp:EMAILADDRESS)'],
['LDAPFail','LDAP failures return false',20,\&checkbox,'','(.*)',undef,
  'If checked when an error occurs in LDAP lookups the address being checked is concidered invalid.
  <br /><hr />
  <div class="menuLevel1">Notes On LDAP</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ldap.txt\',3);" />'],

[0,0,0,'heading','Server Setup'],
['AsAService','Run ASSP as a Windows Service**',0,\&checkbox,0,'([01]?)',undef,
  'In Windows NT/2000/XP/2003 ASSP can be installed as a service. This setting tells ASSP that this has been done -- it does not install the Windows service for you. Installing ASSP as a service requires several steps which are detailed in the <a href="http://www.asspsmtp.org/wiki/Quick_Start_for_Win32">Quick Start for Win32</a> wiki page.'],
['AsADaemon','Run ASSP as a Daemon**',0,\&checkbox,0,'([01]?)',undef,
 'In Linux/BSD/Unix/OSX fork and close file handles. Similar to the command "perl assp.pl &amp;", but better.'],
['runAsUser','Run as UID**',20,\&textinput,'','(\S*)',undef,
  'The *nix user name to assume after startup (*nix only).<p><small><i>Examples:</i> assp, nobody</small></p>'],
['runAsGroup','Run as GID**',20,\&textinput,'','(\S*)',undef,
  'The *nix group to assume after startup (*nix only).<p><small><i>Examples:</i> assp, nobody</small></p>'],
['ChangeRoot','Change Root**',40,\&textinput,'','(.*)',undef,
  'The new root directory to which ASSP should chroot (*nix only). If blank, no chroot jail will be used. Note: if you use this feature, be sure to copy or link the etc/protocols file in your chroot jail.'],
['myName','My Name',40,\&textinput,'ASSP.nospam','(\S+)',undef,
  'ASSP will identify itself by this name in the email "Received:" header. Usually the fully qualified domain name of the host.<p><small><i>Examples:</i> mail.mydomain.com, ASSP.nospam</small></p>'],
['proxyserver','Proxy Server',20,\&textinput,'','(\S*)',undef,
  'The Proxy Server to use when uploading global statistics and downloading the greylist.<p><small><i>Examples:</i> 192.168.0.1:8080, 192.168.0.1</small></p>'],
['OutgoingBufSize','Size of TCP/IP Buffer',10,\&textinput,102400,'(\d+)',undef,
 'If ASSP talks to the internet over a modem change this to 4096. The default is 102400.'],
['webAdminPort','Web Admin Port',20,\&textinput,55555,'(\S+)','ConfigChangeAdminPort',
  'The port on which ASSP will listen for http connections to the web administration interface. If you change this, after you click Apply you must change the URL on your browser to reconnect. You may also supply an IP address to limit connections to a specific interface.<p><small><i>Examples:</i> 55555, 192.168.0.5:12345</small></p>'],
# I hate hidden password input, but if you like it, uncomment this line and comment the next one. -- just quit bugging me about it!
['webAdminPassword','Web Admin Password',20,\&passinput,'nospam4me','(.{5,})',undef,
 #[webAdminPassword,'Web Admin Password',20,\&textinput,'nospam4me','(.{5,})',undef,
  'The password for the web administration interface (minimum of 5 characters).'],
['allowAdminConnectionsFrom','Only Allow Admin Connections From*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'An optional list of IP addresses from which you will accept web admin connections. Blank means accept connections from any IP address. <span class="negative">Note: if you make a mistake here, you may disable your web administration interface and be forced to manually edit your configuration file to fix it.</span><p><small><i>Examples:</i></small></p>
  <p><small>127.0.0.1|10. - Accept connections from the localhost and any computer in the 10.0.0.0/8 subnet.</small></p>
  <p><small>192.168.0. - Accept connections from any computer in the 192.168.0.0/24 subnet.</small></p>'],
['HeaderMaxLength','Maximum Header Size',10,\&textinput,100000,'(\d*)',undef,
  'The maximum allowed header length, in bytes. At each mail hop header information is added by the mail server. A large mail header could indicate a mail loop. If the value is blank or 0 the header size will not be checked.'],
['HeaderMaxLocal','Check Header Size for Locals',0,\&checkbox,1,'([01]?)',undef,
  'Check the email header length of outbound mails to verify that it is not over the maximum header size .'],
['SaveStatsEvery','Statistics Save Interval',4,\&textinput,'','(\d+)',undef,
  'This period (in minutes) determines how frequently ASSP statistics are written to a local file.'],
['totalizeSpamStats','Upload Consolidated Spam Statistics',0,\&checkbox,1,'([01]?)',undef,
 'ASSP will upload its statistics to be consolidated with the <a href="http://www.asspsmtp.org/scripts/stats/" rel="external">global ASSP totals</a>. This is a great marketing tool for the ASSP project &mdash; please do not disable it unless you have a good reason to do so. No private information is being disclosed by this upload.'],
['RestartEvery','Restart Timeout**',10,\&textinput,'0','(\d+)',undef,
  'ASSP will automatically terminate and restart after this many seconds. Use this setting to periodically reload configuration data, combat potential memory leaks, or perform shutdown/startup processes. This will only work properly if ASSP runs as a Windows service or in a script that restarts it after it stops.'],
['OrderedTieHashSize','Ordered-Tie Hash Table Size',10,\&textinput,20000,'(\d+)',undef,
 'The number of entries allowed in the hash tables used by ASSP and rebuildspamdb.pl. Larger numbers require more more RAM but result in fewer disk hits. The default value is 20000. Adjust down to use less RAM.'],
['EnableHTTPCompression','Enable HTTP Compression in GUI',0,\&checkbox,1,'([01]?)',undef,
  'Enable HTTP Compression for faster web administration interface loading. The perl module <a href="http://search.cpan.org/dist/Compress-Zlib/" rel="external">Compress::Zlib</a> is required to use this feature.'],
['EnableFloatingMenu','Enable Floating Menu Panel in GUI',0,\&checkbox,0,'([01]?)',undef,
  'Allow the menu panel on the web administration interface to float (floating Div code taken from <a href="http://www.javascript-fx.com" rel="external">www.javascript-fx.com</a>).'],
['EnableInternalNamesInDesc','Show Internal Names Below Descriptions in the GUI **',0,\&checkbox,1,'([01]?)',undef,
  'Show the internal names in the web interface. The internal names are used in the configuration file (assp.cfg), in the application code, and in the menu bar on the left side of the GUI.'],
['MaillogTailJump','Jump to the End of the Maillog',0,\&checkbox,0,'([01]?)',undef,
  'Causes the browser window to jump to the bottom of the maillog instead of sitting at the top of the display.'],
['MaillogTailBytes','Maillog Tail Bytes',10,\&textinput,10000,'(\d+)',undef,
  'The number of bytes that will be shown when the end of the maillog is viewed. The default value is 10000.'],
['MaillogTailWrapColumn','Maillog Tail Wrap Column',5,\&textinput,80,'(\d+)',undef,
  'Force maillog lines to wrap at this column if there are too many characters in a line. The default is 80. Enter 0 to disable wrapping.'],
['UseLocalTime','Use Local Time',0,\&checkbox,1,'([01]?)',undef,
  'Use local time and timezone offset rather than UTC time in the mail headers.<br /><hr />
  <div class="menuLevel1">Notes On My Server</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/myserver.txt\',3);" />'],
 );

 $MakeRE{ispip}=\&setISPRE;
 $MakeRE{allowAdminConnectionsFrom}=\&setACFRE;
 $MakeRE{acceptAllMail}=\&setAMRE;
 $MakeRE{localDomains}=\&setLDRE;
 $MakeRE{myServerRe}=\&setLHNRE;
 $MakeRE{noRWL}=\&setNRWLRE;
 $MakeRE{noRBL}=\&setNRBLRE;
 $MakeRE{whiteListedIPs}=\&setWLIPRE;
 $MakeRE{noProcessingIPs}=\&setNPIPRE;

 $MakeRE{noPB}=\&setNPBRE;
 $MakeRE{spamaddresses}=\&setSARE;
 $MakeRE{spamtrapaddresses}=\&setSTRE;
 $MakeRE{noProcessing}=\&setNPREL;
 $MakeRE{processOnlyAddresses}=\&setPOARE;
 $MakeRE{ccSpamFilter}=\&setCCRE;
 $MakeRE{ccSpamAlways}=\&setCCARE;

 $MakeRE{ccHamFilter}=\&setCCARRE;
 $MakeRE{EmailSenderOK}=\&setESOKRE;
 $MakeRE{whiteListedDomains}=\&setWLDRE;
 $MakeRE{blackListedDomains}=\&setBLDRE;
 $MakeRE{noProcessingDomains}=\&setNPDRE;
 $MakeRE{CatchAll}=\&setCARE;
 $MakeRE{heloBlacklistIgnore}=\&setHBIRE;
 $MakeRE{spamLovers}=\&setSLRE;
 $MakeRE{spamHaters}=\&setSHRE;

 $MakeRE{baysSpamLovers}=\&setBSLRE;
 $MakeRE{baysSpamHaters}=\&setBSHRE;
 $MakeRE{attachSpamLovers}=\&setATSLRE;
 $MakeRE{noBayesian}=\&setNBRE;
 $MakeRE{blSpamLovers}=\&setBLSLRE;
 $MakeRE{bombSpamLovers}=\&setBOSLRE;
 $MakeRE{ptrSpamLovers}=\&setPTRSLRE;
 $MakeRE{mxaSpamLovers}=\&setMXASLRE;
 $MakeRE{hlSpamLovers}=\&setHLSLRE;
 $MakeRE{spfSpamLovers}=\&setSPFSLRE;
 $MakeRE{rblSpamLovers}=\&setRBLSLRE;
 $MakeRE{rblSpamHaters}=\&setRBLSHRE;
 $MakeRE{uriblSpamLovers}=\&setURIBLSLRE;
 $MakeRE{URIBLCCTLDS}=\&setURIBLCCTLDSRE;
 $MakeRE{URIBLwhitelist}=\&setURIBLWLDRE;
 $MakeRE{maxSMTPdomainIPWL}=\&setIPDWLDRE;
 $MakeRE{noURIBL}=\&setNURIBLRE;
 $MakeRE{srsSpamLovers}=\&setSRSSLRE;
 $MakeRE{delaySpamLovers}=\&setDLSLRE;
 $MakeRE{pbSpamLovers}=\&setPBSLRE;
 $MakeRE{isSpamLovers}=\&setISSLRE;
 $MakeRE{LocalAddresses_Flat}=\&setLAFRE;
 $MakeRE{InternalAddresses}=\&setIARE;
 $MakeRE{BounceSenders}=\&setBSRE;
 $MakeRE{noBombScript}=\&setNBSRE;
 $MakeRE{noLog}=\&setNLOGRE;
 $MakeRE{noDelay}=\&setNDRE;
 $MakeRE{noSRS}=\&setNSRSRE;

 $MakeRE{denySMTPConnectionsFrom}=\&setDSMTPCFRE;
 $MakeRE{denySMTPConnectionsFromAlways}=\&setDSMTPCFARE;

 
 # allow override for default web admin port
 if($ARGV[1]=~/^\d+$/) {
  foreach (@Config) {
   if($_->[0] eq 'webAdminPort' ) {
    $_->[4]=$ARGV[1];
    last;
   }
  }
 }
 # load configuration file
 open(F,"<$base/assp.cfg");
 local $/;
 (%Config)=split(/:=|\n/,<F>);
 close F;
 # set nonexistent settings to default values
 foreach $c (@Config) {
  if ($c->[0] && !(exists $Config{$c->[0]})) {
   $Config{$c->[0]}=$c->[4];
  }
 }
 fixConfigSettings();
 PrintConfigSettings();
 $SIG{HUP}=\&reloadConfigFile;
 $SIG{USR1}=\&saveSMTPconnections;
 $SIG{USR2}=\&SaveConfig;
 $SIG{PIPE} = "IGNORE";
}

renderConfigHTML();

sub renderConfigHTML {
  if ($MaillogTailJump) {
    $maillogEnd = '#End';
    $maillogJump = '<a href="#Top">Go to Top</a><a name="End"></a>';
  } else {
    $maillogEnd = q{};
    $maillogJump = q{};
  }

if ($baysTestMode) {
	$showbaysTestMode = '<span class="positive">Testmode activ</span>';
	} else {
	$showbaysTestMode = '<span class="negative">Testmode in activ</span>';
	}
  $plusIcon = "get?file=images/plusIcon.png";   
  $minusIcon = "get?file=images/minusIcon.png";
  $noIcon = "get?file=images/noIcon.png";
  $wikiinfo = "get?file=images/info.png";
  $NavMenu = '
  <a href="lists"><img src="' . $noIcon . '" alt="noicon" /> White/Redlist/Tuplets</a><br />
  <a href="maillog' . $maillogEnd . '"><img src="' . $noIcon . '" alt="noicon" /> Maillog Tail</a><br />
  <a href="analyze"><img src="' . $noIcon . '" alt="noicon" /> Mail Analyzer</a><br />
  <a href="infostats"><img src="' . $noIcon . '" alt="noicon" /> Info and Stats</a><br />
  <a href="shutdown_list" target="_blank"><img src="' . $noIcon . '" alt="noicon" /> SMTP Connections</a><br />
  <a href="shutdown"><img src="' . $noIcon . '" alt="noicon" /> Shutdown/Restart</a><br />
  <a href="donations"><img src="' . $noIcon . '" alt="noicon" /> Donations</a><br />';
 $JavaScript = "
<script type=\"text/javascript\">
<!--
function toggleDisp(nodeid)
{
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
  else
  {
    layer.style.display = 'none';
    img.src = '$plusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'none';
  }
}
function expand(expand, force)
{
  counter = 0;
  while(document.getElementById('treeElement' + counter))
  {
    if(!expand)
    {
      //dont shrink if this element is the one passed in the URL
      arr = document.getElementById('treeElement' + counter).getElementsByTagName('a');
      txt = ''; found = 0;
      loc = new String(document.location);
      for(i=0; i < arr.length; i++)
      {
        txt = txt + arr.item(i).href;
        tmpHref = new String(arr.item(i).href);
        if(tmpHref.substr(tmpHref.indexOf('#')) == loc.substr(loc.indexOf('#')))
        {
          //give this tree node the right icon
          document.getElementById('treeIcon' + counter).src = '$minusIcon';
          found = 1;
        }
      }
      if(!found | force)
      {
        document.getElementById('treeIcon' + counter).src = '$plusIcon';
        document.getElementById('treeElement' + counter).style.display = 'none';
        if(document.getElementById('setupItem' + counter))
          document.getElementById('setupItem' + counter).style.display = 'none';
          
      }
    }
    else
    {
      document.getElementById('treeElement' + counter).style.display = 'block';
      document.getElementById('treeIcon' + counter).src = '$minusIcon';
      if(document.getElementById('setupItem' + counter))
        document.getElementById('setupItem' + counter).style.display = 'block';
        
    }
    counter++;
    
  }
  
}
//make the 'rel's work
function externalLinks()
{
  if (!document.getElementsByTagName)
    return;
  var anchors = document.getElementsByTagName(\"a\");
  for (var i=0; i<anchors.length; i++)
  {
    var anchor = anchors[i];
    if (anchor.getAttribute(\"href\")
      && anchor.getAttribute(\"rel\") == \"external\")
      anchor.target = \"_blank\";
  }
}";
 if ($EnableFloatingMenu) {
  $JavaScript .= "
function docHeight()
{
  if (typeof document.height != 'undefined') {
    return document.height;
  } else if (document.compatMode && document.compatMode != 'BackCompat') {
    return document.documentElement.scrollHeight;
  } else if (document.body && typeof document.body.scrollHeight !='undefined') {
    return document.body.scrollHeight;
  }
}
//********************************************************
//* You may use this code for free on any web page provided that
//* these comment lines and the following credit remain in the code.
//* Floating Div from http://www.javascript-fx.com
//********************************************************
// Modified in May 2005 by Przemek Czerkas:
//  - added calls to docHeight()
//  - added bounding params tlx, tly, brx, bry
var ns = (navigator.appName.indexOf(\"Netscape\") != -1);
var d = document;
var px = document.layers ? \"\" : \"px\";
function JSFX_FloatDiv(id, sx, sy, tlx, tly, brx, bry)
{
  var el=d.getElementById?d.getElementById(id):d.all?d.all[id]:d.layers[id];
  window[id + \"_obj\"] = el;
  if(d.layers)el.style=el;
  el.cx = el.sx = sx;
  el.cy = el.sy = sy;
  el.tlx = tlx;
  el.tly = tly;
  el.brx = brx;
  el.bry = bry;
  el.sP=function(x,y){this.style.left=x+px;this.style.top=y+px;};
  el.flt=function()
  {
    var pX, pY;
    pX = ns ? pageXOffset : document.documentElement && document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
    pY = ns ? pageYOffset : document.documentElement && document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
    if(this.sy<0)
      pY += ns ? innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight;
    this.cx += (pX + Math.max(this.sx-pX, this.tlx) - this.cx)/4;
    this.cy += (pY + Math.max(this.sy-pY, this.tly) - this.cy)/4;
    this.cx = Math.min(this.cx, this.brx);
    this.cy = Math.min(this.cy, this.bry);
    if (ns) {
      this.sP(
        Math.max(Math.min(this.cx+this.clientWidth,document.width)-this.clientWidth,this.sx),
        Math.max(Math.min(this.cy+this.clientHeight,document.height)-this.clientHeight,this.sy)
      );
    } else {
      var oldh, newh;
      oldh = docHeight();
      this.sP(this.cx, this.cy);
      newh = docHeight();
      if (newh>oldh) {
        this.sP(this.cx, this.cy-(newh-oldh));
      }
    }
    setTimeout(this.id + \"_obj.flt()\", 20);
  }
  return el;
}";
 }
 $JavaScript .= '
function popFileEditor(filename,note)
{
  var height = (note == 0) ? 420 : 460;
  newwindow=window.open(
    \'edit?file=\'+filename+\'&note=\'+note,
    \'FileEditor\',
    \'width=720,height=\'+height+\',toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=no,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}
window.onload = externalLinks;
// -->
</script>';

$headerHTTP = 'HTTP/1.1 200 OK
Content-type: text/html
Cache-control: no-cache
';

$headerDTDStrict = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
';

$headerDTDTransitional = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
';

$headers = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">
<head>
  <meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=utf-8\" />
  <title>ASSP ($myName)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/assp.css\" type=\"text/css\" />
  <link rel=\"shortcut icon\" href=\"get?file=images/favicon.ico\" />
$JavaScript
</head>
<body><a name=\"Top\"></a>
<p>
  <a href=\"http://assp.sourceforge.net/\" target=\"_blank\"><img src=\"get?file=images/logo.jpg\" alt=\"ASSP\" /></a>
</p>
<div class=\"navMenu\"";

 $headers .= ' id="navMenu" style="position:absolute"' if $EnableFloatingMenu;
 
 $headers .= "><div><div style=\"text-align: center;\">
  <a href=\"#\" onmousedown=\" expand(1, 1); \">Expand All</a>&nbsp;&nbsp;&nbsp;
  <a href=\"#\" onmousedown=\" expand(0, 1);  \">Collapse All</a></div>

  <hr />
  <div class=\"menuLevel1\"><a href=\"/\"><img src=\"$plusIcon\" alt=\"plusicon\" /> Main</a><br /></div>";
  
 my $counter = 0;
 foreach $c (@Config) {
   if(@{$c} == 5) {
     $headers .= "</div>\n  <div class=\"menuLevel2\">\n  <a style=\"\" onmousedown=\"toggleDisp('$counter')\">" .
       "<img id=\"treeIcon$counter\" src=\"$plusIcon\" alt=\"plusicon\" /> " .
       "$c->[4]</a>\n</div>\n<div id=\"treeElement$counter\" style=\"padding-left: 3px; display: block\">";
     $counter++;
   } else {
     $headers .= "\n    <div class=\"menuLevel3\"><a href=\"./#$c->[0]\">$c->[0]</a></div>";
     }
 }
 
 $headers .= "</div>
 <hr />
  <div class=\"menuLevel2\">$NavMenu</div>
  <hr />
<div class=\"menuLevel2\">
	
	<a href=\"#\" onclick=\"return popFileEditor(\'notes/confighistory.txt\',5); \"><img src=\"$noIcon\" alt=\"#\" /> Config Changes History</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'notes/admininfo.txt\',5); \"><img src=\"$noIcon\" alt=\"#\" /> Admin Info Messages</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'notes/configdefaults.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Non-Default Settings</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'notes/config.txt\',8);\"><img src=\"$noIcon\" alt=\"#\" /> Config Descriptions</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'rebuildrun.txt\',5);\"><img src=\"$noIcon\" alt=\"#\" /> SpamDB Rebuild Log</a>
	<hr />
	<span style=\"font-weight: bold;\">ASSP Version</span>: $version$modversion<br />
	<span style=\"font-weight: bold;\">Current PID</span>: $mypid<br />
	<span style=\"font-weight: bold;\">Started</span>: $starttime<br />
  </div>
 
   <hr />
  </div>
<script type=\"text/javascript\">
  <!--
  ";
  
 $headers .= 'JSFX_FloatDiv("navMenu",2,50,2,-2,2,99999).flt();' if $EnableFloatingMenu;
 $headers .= '
  expand(0,0);
  // -->
  </script>
  ';

 $footers = "
<div class=\"contentFoot\">
<a href=\"http://www.asspsmtp.org/scripts/stats\" rel=\"external\">global stats</a> | 
<a href=\"http://www.asspsmtp.org/wiki/ASSPDOCS\" rel=\"external\">docs</a> | 
<a href=\"http://sourceforge.net/mail/?group_id=69172\" rel=\"external\">email lists</a> | 
<a href=\"http://www.asspsmtp.org/forums/\" rel=\"external\">forums</a> | 
 <a href=\"http://www.asspsmtp.org/wiki/\" rel=\"external\">wiki</a>
</div>";

$kudos = '
<div class="kudos">
 <a href="http://www.magicvillage.de/~Fritz_Borgstedt/assp/" rel="external">
 <img src="get?file=images/village.gif" alt="Development" height="31" width="31" /></a>
 <a href="http://sourceforge.net" rel="external">
 <img src="get?file=images/sourceforge-logo.gif" alt="SourceForge" height="31" width="88" /></a>
 <a href="http://opensource.org" rel="external">
 <img src="get?file=images/opensource-logo.gif" alt="Open Source" height="31" width="88" /></a>
</div>
';
}

$DomainCache||='^(?!)';
$EmailAdrRe="[^()<>@,;:\\\"\\[\\]\000-\040]+";
$EmailDomainRe='(?:\w[\w\.\-]*\.\w+|\[[\d\.]*\.\d+\])';
$HeaderNameRe='\S[^\r\n]*';
$HeaderValueRe='[ \t]*[^\r\n]*(?:\r?\n[ \t]+\S[^\r\n]*)*(?:\r?\n)?';
$HeaderRe='(?:'.$HeaderNameRe.':'.$HeaderValueRe.')';
$UUENCODEDRe='\bbegin\b \d\d\d \b\S{0,72}.*(\S{61}).{0,61}\bend\b';

# IP Address representations
$IPQuadSectRE='(?:0([0-7]+)|0x([0-9a-f]+)|(\d+))'; 
$IPQuadSectDotRE='(?:'.$IPQuadSectRE.'\.)';
$IPQuadRE=$IPQuadSectDotRE.'?'.$IPQuadSectDotRE.'?'.$IPQuadSectDotRE.'?'.$IPQuadSectRE;

# URI components - RFC3986, section 2, 'Characters'
$URIContinuationRe='\=(?:\015?\012|\015)';
$URIEncodedCharRe='[\=\%][a-f0-9]{2}|\&\#\d{1,3}\;?';
$URIUnreservedCharRe='[a-z0-9\-\_\.\~]';
$URIGenDelimsCharRe='[\:\/\?\#\[\]\@]';
$URISubDelimsCharRe='[\!\$\&\'\(\)\*\+\,\;\=\%\^\`\{\}\|]'; # relaxed to a few other characters
$URIReservedCharRe=$URIGenDelimsCharRe.'|'.$URISubDelimsCharRe;

# URI compounds
$URICommonRe=$URIContinuationRe.'|'.$URIEncodedCharRe.'|'.$URIUnreservedCharRe;
$URIHostRe='(?:'.$URICommonRe.'|'.$URISubDelimsCharRe.')+';
$URIRe='(?:'.$URICommonRe.'|'.$URIReservedCharRe.')+';

# Notes on general operation & program structure
# I'm using IO::Select, so don't make any changes that block for long
# as new connections come we create a pair of entries in a hash %Con
# based on the hash of the filehandle, so $Con{$fh} has data for this
# connection. $Con{$fh}->{friend} is the partner socket for the smtp proxy.
# ->{ip} is the ip address of the connecting client
# ->{relayok} tells if we can relay mail for this client
# ->{getline} is a pointer to a function that should be called whan a line of input is received for this filehandle
# ->{mailfrom} is the envelope sender (MAIL FROM: <address>)
# ->{outgoing} is a buffer for outgoing socket traffic (see $writable & &sendque)
# ->{rcpt} are the addresses from RCPT TO: <address> (space separated)
# ->{header} is where the header (and eventually the first 10000 bytes) are stored
# ->{myheader} is where we store our header, we merge it with client's header later
# ->{maillog} if present stream logging is enabled
# ->{maillogbuf} buffer for storing unwritten stream log while waiting for isspam decision
# ->{maillogfh} is the filehandle for logging lines to the maillog
# ->{mailloglength} is the length logged so far (we stop after 10000 bytes)
# ->{spamfound} is a flag used to signal if an email is determined to be spam.
# ->{maillength} is the same as mailloglength but is not reset.
#
# After connection the {getline} field functions like a state machine
# redirecting input to subsequent handlers
#
# whitebody -> getline
#   getbody ->
#     error -> (disconnects)
#     getline -> getheader ->
#       whitebody -> getline
#         error -> (disconnects)
#
# getline looks for MAIL FROM, RCPT TO, RSET
# getheader looks for a blank line then tests for whitelist / spamaddresses
# getbody looks for the . and calls isspam, the Bayesian spam test
# whitebody waits for . and redirects client to server
# error waits for . ignoring data from client (and finishes the maillog)
#
# the server has states like this:
#
# skipok -> reply
#
# skipok traps the 250 ok response from the NOOP Connection from
# reply echos server messages to the client
# reply also looks for a 235 AUTH OK and sets {relayok}=1


sub serviceCheck { }
sub d            { }

if ($DEBUG) {
    open( DEBUG, ">$base/" . time . ".dbg" );
    binmode(DEBUG);
    my $oldfh = select(DEBUG);
    $| = 1;
    select($oldfh);
}

eval(
    q[sub d {
 my $time=gmtime(); $time=~s/... (...) +(\d+) (........) ..(..)/$2 $1 $4 $3/;
 my $debugprint = $_[0];
 $debugprint =~ s/\n//;
 $debugprint =~ s/\r//;
 $debugprint =~ s/\s+$//;
 print DEBUG "$time <$debugprint>\n";
 }]
) if $DEBUG;

if($AsADaemon) {
 fork() && exit;
 close STDOUT;
 close STDERR;
 $silent=1;
}

if($pidfile) {open(F,">$base/$pidfile"); print F $$; close F;}

sub RemovePid {
 if ($pidfile) {
  d('RemovePid');
  unlink("$base/$pidfile");
 }
}



my $logdir = $1 if $logfile =~ /(.*)\/.*/;
-d "$base/$logdir" or mkdir "$base/$logdir", 0770 if $logdir;
if ( $logfile && open( LOG, ">>$base/$logfile" ) ) {
    my $oldfh = select(LOG);
    $| = 1;
    select($oldfh);
  }

if($AsAService) {
 eval(<<"EOT");
 use Win32::Daemon;
 mlog(0,"starting as a service");
 Win32::Daemon::StartService();

 # Wait until the service manager is ready for us to continue...
 while( SERVICE_START_PENDING != Win32::Daemon::State() ) { sleep( 1 ); }
 Win32::Daemon::State( SERVICE_RUNNING );

sub serviceCheck {
 d(50);
 if(Win32::Daemon::State() == SERVICE_STOP_PENDING ) {
  d(51);
  mlog(0,"service stopping");
  &saveWhitelist;
  Win32::Daemon::State( SERVICE_STOPPED );
  Win32::Daemon::StopService();
  exit;
 }
}

EOT
 print STDERR "error: $@\n" if $@;
 print LOG "error: $@\n" if $@;
}

init();
$lastTimeoutCheck = time();
while(1) {
 &MainLoop;
}
if ($@) {
    my $exmsg = "main exception: $@\n";
    print $exmsg;
    print LOG $exmsg;

    open( EX, ">>$base/exception.log" );
    print EX $exmsg;
    close EX;
    exit 1;
}
sub init {
    my $ver;

    my $perlver = $];
    mlog( 0, "ASSP version $version$modversion (Perl $]) initializing " );
    mlog( 0, "Perl 5.8 needed for Webinterface!" ) if $] <= "5.008";

    if   ($CanUseHostname) { mlog( 0, "ASSP running on server: $localhostname " ); }
    else                   { mlog( 0, "ASSP running on server: Hostname not available" ); }

    if ($CanUseHTTPCompression) {
        $ver             = eval('Compress::Zlib->VERSION');
        $VerCompressZlib = $ver;
        $ver             = " version $ver" if $ver;
        mlog( 0, "Compress::Zlib module$ver installed - HTTP compression available" );
    }
    elsif ( !$AvailZlib ) { mlog( 0, "Compress::Zlib module not installed - HTTP compression disabled" ); }
    if ($CanUseMD5Keys) {
        $ver          = eval('Digest::MD5->VERSION');
        $VerDigestMD5 = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Digest::MD5 module$ver installed - delaying will use MD5 keys for hashes" );
    }
    if ($CanUseAddress) {
        $ver           = eval('Email::Valid->VERSION');
        $VerEmailValid = $ver;
        $ver           = " version $ver" if $ver;
        mlog( 0, "Email::Valid module$ver installed and available" );
    }
    else { mlog( 0, "Email::Valid module not installed" ) if $DoRFC822 || $DoDomainCheck; }
    if ($CanSearchLogs) {
        $ver                  = eval('File::ReadBackwards->VERSION');
        $VerFileReadBackwards = $ver;
        $ver                  = " version $ver" if $ver;
        mlog( 0, "File::ReadBackwards module$ver installed - searching of log files enabled" );
    }
    elsif ( !$AvailReadBackwards ) {
        mlog( 0, "File::ReadBackwards module not installed - searching of log files disabled" );
    }

    if ($CanUseAvClamd) {
        AvClamd->init( { port => $AvClamdPort } );
        if ( AvClamd->ping() ) {
            $AvailAvClamd = 1;
            $ver          = AvClamd->version();
            $VerAvClamd   = $ver;
            $ver          = " version $ver" if $ver;
            mlog( 0, "File::Scan::ClamAV module$ver installed and available" );
        }
        else {
            $AvailAvClamd = 0;
            $ver          = AvClamd->version();
            $VerAvClamd   = $ver;
            $ver          = " version $ver" if $ver;
            mlog( 0, "File::Scan::ClamAV module$ver installed but not available, error: " . AvClamd->errstr() );
            $VerAvClamd = AvClamd->errstr();
        }
    }
    else {
        $AvailAvClamd = 0;
        $VerAvClamd   = "ClamAV not installed";
        mlog( 0, "File::Scan::ClamAV module not installed" ) if $UseAvClamd;
    }

    if ($CanUseLWP) {
        $ver    = eval('LWP::Simple->VERSION');
        $VerLWP = $ver;
        $ver    = " version $ver" if $ver;
        mlog( 0, "LWP::Simple module$ver installed - procedural LWP interface available" );
    }
    elsif ( !$AvailLWP ) {
        $VerLWP = "procedural LWP interface not available";
        mlog( 0, "LWP::Simple module not installed - procedural LWP interface not available" );
    }

    if ($CanUseSPF) {
        $ver        = eval('Mail::SPF::Query->VERSION');
        $VerMailSPF = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Mail::SPF::Query module$ver installed and available" );
    }
    elsif ($AvailSPF) {
        $ver = eval('Mail::SPF::Query->VERSION');
        $ver = " version $ver" if $ver;
        mlog( 0, "Mail::SPF::Query module$ver installed but Net::DNS required" );
    }
    else { mlog( 0, "Mail::SPF::Query module not installed" ) if $ValidateSPF; }

    if ($CanUseSRS) {
        $ver        = eval('Mail::SRS->VERSION');
        $VerMailSRS = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Mail::SRS module$ver installed - Sender Rewriting Scheme available" );
    }
    elsif ( !$AvailSRS ) {
        mlog( 0, "Mail::SRS module not installed - Sender Rewriting Scheme disabled" )
            if $EnableSRS;
    }
    if ($CanUseDNS) {
        $ver       = eval('Net::DNS->VERSION');
        $VerNetDNS = $ver;
        $ver       = " version $ver" if $ver;
        mlog( 0, "Net::DNS module$ver installed and available" );
    }
    else { mlog( 0, "Net::DNS module not installed" ); }

    if ($CanUseLDAP) {
        $ver        = eval('Net::LDAP->VERSION');
        $VerNetLDAP = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Net::LDAP module$ver installed and available" );
    }
    else { mlog( 0, "Net::LDAP module not installed" ) if $DoLDAP; }

    if ($CanUseNetSyslog) {
        $ver          = eval('Net::Syslog->VERSION');
        $VerNetSyslog = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Net::Syslog module$ver installed - network Syslog logging enabled" );
    }
    elsif ( !$AvailNetSyslog ) { mlog( 0, "Net::Syslog module not installed." ) if $sysLog && $sysLogPort; }
    if ($CanUseSyslog) {
        $ver          = eval('Sys::Syslog->VERSION');
        $VerSysSyslog = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Sys::Syslog module$ver installed - Unix centralized logging enabled" );
    }
    elsif ( !$AvailSyslog ) { mlog( 0, "Sys::Syslog module not installed." ) if $sysLog && !$sysLogPort; }
    if ($CanChroot) {
        $ver = eval('PerlIO::scalar->VERSION');
        $ver = " version $ver" if $ver;
        mlog( 0, "PerlIO::scalar module$ver installed - chroot savy" ) if $ChangeRoot;
    }

    if ($CanUseTieRDBM) {
        $ver     = eval('Tie::RDBM->VERSION');
        $VerRDBM = $ver;
        $ver     = " version $ver" if $ver;
        mlog( 0, "Tie::RDBM module$ver installed - mysql usage  available" );
    }
    elsif ( !$AvailTieRDBM && $myhost ) {
        $VerRDBM = "mysql not available";
        mlog( 0, "Tie::RDBM module not installed - mysql usage  not available" );
    }

    if ($CanStatCPU) {
        $ver          = eval('Time::HiRes->VERSION');
        $VerTimeHiRes = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Time::HiRes module$ver installed - CPU usage statistics available" );
    }
    elsif ( !$AvailHiRes ) {
        $VerTimeHiRes = "CPU statistics disabled";
        mlog( 0, "Time::HiRes module not installed - CPU usage statistics disabled" );
    }

    if ($CanUseWin32Daemon) {
        $ver            = eval('Win32::Daemon->VERSION');
        $VerWin32Daemon = $ver;
        $ver            = " version $ver" if $ver;
        mlog( 0, "Win32::Daemon module$ver installed - can run as Win32 service" );
    }


    $readable  = new IO::Select();
    $writable  = new IO::Select();

    $lsn       = newListen( $listenPort, \&NewSMTPConnection );
    $WebSocket = newListen( $webAdminPort, \&NewWebConnection );
    mlog( 0, "listening for SMTP connections on $listenPort" );
    mlog( 0, "listening for admin HTTP connections on $webAdminPort" );
    if ($listenPort2) {
        $lsn2 = newListen( $listenPort2, \&NewSMTPConnection );
        mlog( 0, "listening for additional SMTP connections on $listenPort2" );
    }

    # handle the possible relayhost / smarthost option
    if ( $relayHost && $relayPort ) {
        $this->{ noprocessing } = 1 if $relayportNP;
        $Relay = newListen( $relayPort, \&NewSMTPConnection );
        mlog( 0, "listening for SMTP relay connections on $relayPort" );
    }

  $nextNoop=time;
  $endtime=$nextNoop+$RestartEvery;
  $saveWhite=$nextNoop+$UpdateWhitelist;
  $nextCleanDelayDB=$nextNoop+$CleanDelayDBInterval;

  $SIG{INT}=sub {mlog(0,"sig INT"); &SaveWhitelist; kill 6,$$ if $ENV{windir}; RemovePid(); exit;};
  $SIG{TERM}=sub {mlog(0,"sig TERM"); &SaveWhitelist; RemovePid(); exit;};


  my ($uid,$gid)=getUidGid($runAsUser,$runAsGroup) if ($runAsUser || $runAsGroup);
  if($ChangeRoot) {
    my $chroot;
    eval('$chroot=chroot($ChangeRoot)');
    if($@) {
      my $msg="request to change root to '$ChangeRoot' failed: $@";
      mlog('',$msg);
      die ucfirst($msg);
    } elsif(! $chroot) {
      my $msg="request to change root to '$ChangeRoot' did not succeed: $!";
      mlog('',$msg);
      die ucfirst($msg);
    } else {
      $chroot=$ChangeRoot; $chroot=~s/(\W)/\\$1/g;
      $base=~s/^$chroot//i;
      chdir("/");
      mlog('',"successfully changed root to '$ChangeRoot' -- new base is '$base'");
    }
  }
  
  switchUsers($uid,$gid) if ($runAsUser || $runAsGroup);



    # create folders if they're missing
    -d "$base/$spamlog"        or mkdir "$base/$spamlog",        0700;
    -d "$base/$notspamlog"     or mkdir "$base/$notspamlog",     0700;
    -d "$base/$incomingOkMail" or mkdir "$base/$incomingOkMail", 0700;
    -d "$base/$viruslog"       or mkdir "$base/$viruslog",       0700;
    -d "$base/files"           or mkdir "$base/files",           0700;
    -d "$base/logs"            or mkdir "$base/logs",            0700;
    my $dir = $correctedspam;
    $dir =~ s/\/.*?$//;
    -d "$base/$dir"              or mkdir "$base/$dir",              0700;
    -d "$base/$correctedspam"    or mkdir "$base/$correctedspam",    0700;
    -d "$base/$correctednotspam" or mkdir "$base/$correctednotspam", 0700;
    my $pbdir = $1 if $pbdb =~ /(.*)\/.*/;
    mkdir "$base/$pbdir", 0700 if $pbdir;
    -d "$base/notes" or mkdir "$base/notes", 0700;
    -d "$base/docs"  or mkdir "$base/docs",  0700;
 


# put this after chroot so the paths don't change
    $SpamdbObject = tie %Spamdb, 'orderedtie', "$base/$spamdb" if $spamdb;
  mlog(0,"warning: Bayesian spam database is small or empty: '$base/$spamdb'") if $spamdb && -s "$base/$spamdb" < 10000;
  $HeloBlackObject=tie %HeloBlack,'orderedtie',"$base/$spamdb.helo" if $spamdb;
 # $DnsblObject     = tie %Dnsbl,     'orderedtie', "$base/$Dnsbl"       if $dnsbl;
 # mlog(0,"warning: DNS blacklist database is small or empty: '$base/$dnsbl'") if $dnsbl && -s "$base/$dnsbl" < 10000;
  
  if ($CanUseTieRDBM && $whitelistdb =~ /mysql/) {
  eval {
    $WhitelistObject=tie %Whitelist,'Tie::RDBM',"dbi:mysql:database=$mydb;host=$myhost",{user=>"$myuser",password=>"$mypassword",table=>'whitelist',create=>1};};
if($@) {
    mlog(0,"whitelist mysql error: $@");
    $CanUseTieRDBM=0;
    $whitelistdb ="whitelist";
    }
  } else {
        $WhitelistObject = tie %Whitelist, 'orderedtie', "$base/$whitelistdb";
    mlog(0,"warning: whitelist is small or empty: '$base/$whitelistdb' (ignore if this is a new install)") if $whitelistdb && -s "$base/$whitelistdb" < 1000;
  }

  if ($CanUseTieRDBM && $redlistdb =~ /mysql/) {
  eval {
    $RedlistObject=tie %Redlist,'Tie::RDBM',"dbi:mysql:database=$mydb;host=$myhost",{user=>"$myuser",password=>"$mypassword",table=>'redlist',create=>1}; };
if($@) {
    mlog(0,"redlist mysql error: $@");
    $CanUseTieRDBM=0;
    $redlistdb ="redlist";
        }
    }
    else { 
    	$RedlistObject = tie %Redlist, 'orderedtie', "$base/$redlistdb"; 
    }

    $GriplistObject   = tie %Griplist,   'orderedtie', "$base/$griplist" if $griplist;
    $MXACacheObject   = tie %MXACache,   'orderedtie', "$base/$pbdb.mxa.db";
    $PBBlackObject    = tie %PBBlack,    'orderedtie', "$base/$pbdb.black.db";
    $PBWhiteObject    = tie %PBWhite,    'orderedtie', "$base/$pbdb.white.db";
    $PTRCacheObject   = tie %PTRCache,   'orderedtie', "$base/$pbdb.ptr.db";
    $RBLCacheObject   = tie %RBLCache,   'orderedtie', "$base/$pbdb.rbl.db";
    $RWLCacheObject   = tie %RWLCache,   'orderedtie', "$base/$pbdb.rwl.db";
    $SPFCacheObject   = tie %SPFCache,   'orderedtie', "$base/$pbdb.spf.db";
    $URIBLCacheObject = tie %URIBLCache, 'orderedtie', "$base/$pbdb.uribl.db";
  if ($CanUseTieRDBM && $delaydb =~ /mysql/) {
  eval {
   $DelayWhiteObject=tie %DelayWhite,'Tie::RDBM',"dbi:mysql:database=$mydb;host=$myhost",{user=>"$myuser",password=>"$mypassword",table=>'delaywhitedb',create=>1};
    $DelayObject=tie %Delay,'Tie::RDBM',"dbi:mysql:database=$mydb;host=$myhost",{user=>"$myuser",password=>"$mypassword",table=>'delaydb',create=>1};};
if($@) {
    mlog(0,"delaydb mysql error: $@");
    $CanUseTieRDBM=0;
    $delaydb="delaydb";
    }
   
  } else {
        $DelayObject      = tie %Delay,      'orderedtie', "$base/$delaydb";
        $DelayWhiteObject = tie %DelayWhite, 'orderedtie', "$base/$delaydb.white";
  }


  $shuttingDown=$doShutdown=0;
  $smtpConcurrentSessions=0;
  $Stats{starttime}=time;
  $Stats{version}="$version$modversion";
  &ResetStats;
  mlog(0,"starting PID: $$");
}

sub newListen {
  my($port,$handler)=@_;
  my ($interface,$p)=$port=~/(.*):(.*)/;
  my $s;
  if($interface) {
    $s = new IO::Socket::INET(Listen => 10, LocalPort => $p, Reuse=>1, LocalAddr => $interface);
  } else {
    $s = new IO::Socket::INET(Listen => 10, LocalPort => $port, Reuse=>1);
  }
  if(! $s) {
    mlog('',"couldn't create server socket on port '$port' -- maybe another service is running or I'm not root (uid=$>)?");
    return undef;
  }
  $SocketCalls{$s}=$handler;
  $readable->add($s); # add to select list
  $s;
}

sub getUidGid { my ($uname,$gname)=@_;
  return if $AsAService;
    my $rname = "root";
    eval('getgrnam($rname);getpwnam($rname);');
  if($@) {
# windows pukes "unimplemented" for these -- just skip it
    mlog('',"warning: uname and/or gname are set ($uname,$gname) but getgrnam / getpwnam give errors: $@");
    return;
  }
  my $gid;
  if($gname) {
    $gid = getgrnam($gname);
    if(defined $gid) {
    } else {
      my $msg="could not find gid for group '$gname' -- not switching effective gid -- quitting";
      mlog('',$msg);
      die ucfirst($msg);
    }
  }
  my $uid;
  if($uname) {
    $uid = getpwnam($uname);
    if(defined $uid) {
    } else {
      my $msg="could not find uid for user '$uname' -- not switching effective uid -- quitting";
      mlog('',$msg);
      die ucfirst($msg);
    }
  }
  ($uid,$gid);
}

sub switchUsers { my ($uid,$gid)=@_;
  return if $AsAService;
  my($uname,$gname)=($runAsUser,$runAsGroup);
  $>=0;
  if($> != 0) {
    my $msg="requested to switch to user/group '$uname/$gname' but cannot set effective uid to 0 -- quitting; uid is $>";
    mlog('',$msg);
    die ucfirst($msg);
  }
  $<=0;
  if($gid) {
    $)=$gid;
    if($)+0==$gid) {
      mlog('',"switched effective gid to $gid ($gname)");
    } else {
      my $msg="failed to switch effective gid to $gid ($gname) -- effective gid=$) -- quitting";
      mlog('',$msg);
      die ucfirst($msg);
    }
    $(=$gid;
    if($(+0==$gid) {
      mlog('',"switched real gid to $gid ($gname)");
    } else {
      mlog('',"failed to switch real gid to $gid ($gname) -- real uid=$(");
    }
  }
  if($uid) {
# do it both ways so linux and bsd are happy
   $< = $> = $uid;
    if($>==$uid) {
      mlog('',"switched effective uid to $uid ($uname)");
    } else {
      my $msg="failed to switch effective uid to $uid ($uname) -- real uid=$< -- quitting";
      mlog('',$msg);
      die ucfirst($msg);
    }
    if($<==$uid) {
      mlog('',"switched real uid to $uid ($uname)");
    } else {
      mlog('',"failed to switch real uid to $uid ($uname) -- real uid=$<");
    }
  }
}

sub MainLoop {
    my $wait = 5;    # keep it short enough for servicecheck to be called regularly
    my $stime = $CanStatCPU ? ( Time::HiRes::time() ) : time;    # loop cycle start time
    my ( $canread, $canwrite ) = IO::Select->select( $readable, $writable, undef, $wait );
    my $itime = $CanStatCPU ? ( Time::HiRes::time() ) : time;    # loop cycle idle end time
    $webTime   = 0;                                              # loop cycle web time interval, global var
    $nextLoop2 = $itime + 1;                                     # global var
    foreach $fh (@$canwrite) {
        my $l = length( $Con{ $fh }->{ outgoing } );
        d("$fh $Con{$fh} l=$l");
        if ($l) {
            my $written = syswrite( $fh, $Con{ $fh }->{ outgoing }, $OutgoingBufSize );
            if ($DEBUG) {
                if ( $written <= 200 ) {
                    d( "wrote: ($written)<" . substr( $Con{ $fh }->{ outgoing }, 0, $written ) . ">" );
                }
                else {
                    d("wrote: ($written)<long text>");
                }
            }
            $Con{ $fh }->{ outgoing } = substr( $Con{ $fh }->{ outgoing }, $written );
            $l = length( $Con{ $fh }->{ outgoing } );

            # test for highwater mark
            if ( $written > 0 && $l < $OutgoingBufSize && $Con{ $fh }->{ paused } ) {
                $Con{ $fh }->{ paused } = 0;
                $readable->add( $Con{ $fh }->{ friend } );
            }
        }
        if ( length( $Con{ $fh }->{ outgoing } ) == 0 ) {
            $writable->remove($fh);
        }
    } ## end foreach $fh (@$canwrite)
    foreach $fh (@$canread) {
        if ( $fh && $SocketCalls{ $fh } ) {
            if ( $CanStatCPU && ( $SocketCalls{ $fh } == \&WebTraffic || $SocketCalls{ $fh } == \&NewWebConnection ) ) {

                # calculate time spent serving web request
                $webTime -= Time::HiRes::time();
                $SocketCalls{ $fh }->($fh);
                $webTime += Time::HiRes::time();
            }
            else {
                $SocketCalls{ $fh }->($fh);
            }
        }
    }
    if ( $smtpIdleTimeout > 0 ) {
        if ( %Con > 0 ) {
            $tmpNow = time();

            # Check timeouts only every 3 seconds at least
            if ( $tmpNow > ( $lastTimeoutCheck + 3 ) ) {
                foreach my $tmpfh ( keys %Con ) {
                    if (   $Con{ $tmpfh }->{ type } eq 'C'
                        && $Con{ $tmpfh }->{ timelast } > 0
                        && ( ( $tmpNow - $Con{ $tmpfh }->{ timelast } ) > $smtpIdleTimeout ) )
                    {
                        $this->{ prepend } = "";
                        mlog( $tmpfh, "Connection idle for $smtpIdleTimeout secs - timeout" ) if $SessionLog;
                        $Stats{ smtpConnIdleTimeout }++;
                        seterror( $Con{ $tmpfh }->{ client }, "451 Connection timeout, try later\r\n", 1 );
                    }
                }
                $lastTimeoutCheck = $tmpNow;
            }
        }
    }
    d(6);
    serviceCheck();    # for win32 services

    # timer related issues
    # if(abs(($itime - $stime) - $wait) <= 1.0) {

    # noactive connections -- check for maintenance
    d(8);

    if ( $itime >= $saveWhite ) {
        d(9);
        &SaveWhitelist;
        $saveWhite = int($itime) + $UpdateWhitelist;
    }
    if ( $itime >= $nextCleanDelayDB ) {
        &DoCleanDelayDB;
        $nextCleanDelayDB = int($itime) + $CleanDelayDBInterval;
    }

    if ( $RestartEvery && $itime >= $endtime ) {

        # time to quit -- after endtime and we're bored.
        $opencon = ( keys %Con );
        if ( $opencon == 0 ) {
            &SaveWhitelist;
            mlog( 0, "restarting" );
            if ($AsAService) {
                exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
            }
            else {
                exit 1;
            }
        }
    }
    SaveStats()   if ( $SaveStatsEvery    && $itime >= $NextSaveStats );
    uploadStats() if ( $totalizeSpamStats && $itime >= $Stats{ nextUpload } );
    downloadGrip() if ( !$noGriplistDownload && $griplist && $itime >= $NextGriplistDownload );

    #}
    if ($CanStatCPU) {

        #
        # cycleTime = cpuTime + webTime
        # cpuTime = cpuIdleTime + cpuBusyTime
        #
        my $ctime       = Time::HiRes::time();       # loop cycle end time
        my $cycleTime   = $ctime - $stime;
        my $cpuTime     = $cycleTime - $webTime;
        my $cpuIdleTime = $itime - $stime;
        my $cpuBusyTime = $cpuTime - $cpuIdleTime;
        $Stats{ cpuTime }     += $cpuTime;
        $Stats{ cpuBusyTime } += $cpuBusyTime;

        # envelope following filter with instant rise and decay time of 1 second
        my $lusage = $cpuUsage * exp( -( 0.693 / 1 ) * $cycleTime );
        my $usage = ( $cpuTime == 0 ? 0 : $cpuBusyTime / $cpuTime );
        $cpuUsage = $usage > $lusage ? $usage : $lusage;
    }
    if ( $doShutdown && $itime >= $doShutdown ) {
        &SaveWhitelist;
        mlog( 0, "restarting" );
        if ($AsAService) {
            exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
        }
        else {
            exit 1;
        }
    }
} ## end sub MainLoop

d(11);
# Never reached...(we hope)

# called during long operations to keep processing priority data
# alternates (1s/1s) between SMTP connections handling and the calling task
sub MainLoop2 {
    my $time = $AvailHiRes ? ( Time::HiRes::time() ) : time;
    if ( $time >= $nextLoop2 ) {
        $webTime += $time if $CanStatCPU;
        $nextLoop2 = $time + 1;    # 1s for SMTP stuff
        serviceCheck();            # for win32 services
        SaveStats() if ( $SaveStatsEvery && $itime >= $NextSaveStats );
        my ( $canread, $canwrite );
        do {
            ( $canread, $canwrite ) = IO::Select->select( $readable, $writable, undef, 0 );
            foreach $fh (@$canwrite) {
                my $l = length( $Con{ $fh }->{ outgoing } );
                d("$fh $Con{$fh} l=$l");
                if ($l) {
                    my $written = syswrite( $fh, $Con{ $fh }->{ outgoing }, $OutgoingBufSize );
                    if ($DEBUG) {
                        if ( $written <= 200 ) {
                            d( "wrote: ($written)<" . substr( $Con{ $fh }->{ outgoing }, 0, $written ) . ">" );
                        }
                        else {
                            d("wrote: ($written)<long text>");
                        }
                    }
                    $Con{$fh}->{outgoing} = substr( $Con{$fh}->{outgoing}, $written );
                    $l = length( $Con{$fh}->{outgoing} );
                    # test for highwater mark
                    if ( $written > 0 && $l < $OutgoingBufSize && $Con{$fh}->{paused} ) {
                        $Con{$fh}->{paused} = 0;
                        $readable->add( $Con{$fh}->{friend} );
                    }
                }
                if ( length( $Con{$fh}->{outgoing} ) == 0 ) {
                    $writable->remove($fh);
                }
            }
            foreach $fh (@$canread) {
                if ($fh
                    && (   $SocketCalls{$fh} == \&SMTPTraffic
                        || $SocketCalls{$fh} == \&NewSMTPConnection
                        || $SocketCalls{$fh} == \&WebTraffic
                        || $SocketCalls{$fh} == \&NewWebConnection )
                    )
                {
                    $SocketCalls{$fh}->($fh);
                }
            }
            $time = $AvailHiRes ? ( Time::HiRes::time() ) : time;
        } until ( ( @$canread == 0 && @$canwrite == 0 ) || $time >= $nextLoop2 );
        $nextLoop2 = $time + 1;    # 1s for other tasks
        $webTime -= $time if $CanStatCPU;
    }
}

sub SaveWhitelist {
  d(35);

  if ($whitelistdb !~ /mysql/) {
    mlog(0,"saving whitelist") if $MaintenanceLog;
    $WhitelistObject->flush() if $WhitelistObject;
  }
  if ($redlistdb !~ /mysql/) {
    mlog(0,"saving redlist") if $MaintenanceLog;
    $RedlistObject->flush() if $RedlistObject;
  }
  if ($delaydb !~ /mysql/) {
    mlog(0,"saving delaying records") if $MaintenanceLog;
    $DelayObject->flush() if $DelayObject;
    $DelayWhiteObject->flush() if $DelayWhiteObject;
  }

  SavePB();
  SaveStats();
}

sub SavePB {
if ( $pbdb !~ /mysql/ ) {
    # save Penalty Box Databases
    mlog( 0, "saving penalty records" ) if $MaintenanceLog;
    $PBBlackObject->flush() if $DoPenalty && $PBBlackObject;
    MainLoop2();
    $PBWhiteObject->flush() if $PBWhiteObject;
    MainLoop2();
    &exportExtreme;
	MainLoop2();
    mlog( 0, "saving cache records" ) if $MaintenanceLog;
	$MXACacheObject->flush()	if $MXACacheObject;
	MainLoop2();
	$PTRCacheObject->flush()	if $PTRCacheObject;
	MainLoop2();
	$RBLCacheObject->flush()	if $RBLCacheObject;
	MainLoop2();
	$RWLCacheObject->flush()	if $RWLCacheObject;
	MainLoop2();
	$SPFCacheObject->flush()	if $SPFCacheObject;
	MainLoop2();
	$URIBLCacheObject->flush()	if $URIBLCacheObject;
}
    
}

sub CleanPB {

    # clean Penalty Box Databases
    &SavePB;
    MainLoop2();
    mlog( 0, "cleaning penalty records..." ) if $MaintenanceLog;
    &cleanBlackPB if $DoPenalty && $PBBlackObject;
    MainLoop2();
    &cleanWhitePB if $PBWhiteObject;

    mlog( 0, "cleaning cache records..." ) if $MaintenanceLog;
    &cleanCacheRBL if $RBLCacheInterval && $ValidateRBL;
    MainLoop2();
    &cleanCacheURI if $URIBLCacheInterval && $ValidateURIBL;
    MainLoop2();
    &cleanCacheRWL if $RWLCacheInterval && $ValidateRWL;
    MainLoop2();
    &cleanCachePTR if $PTRCacheInterval && $DoReversed;
    MainLoop2();
    &cleanCacheMXA if $DoDomainCheck && $MXACacheInterval;
    MainLoop2();
    &cleanCacheSPF if $ValidateSPF && $SPFCacheInterval;
    MainLoop2();

} ## end sub CleanPB


sub DoCleanDelayDB {
  mlog(0,"cleaning up delaying databases ...") if $MaintenanceLog;
  my $t=time;
  my $keys_before=$keys_deleted=0;
  while (($k,$v)=each(%Delay)) {
    $keys_before++;
    if ($t-$v>=$DelayEmbargoTime*60+$DelayWaitTime*3600) {
      delete $Delay{$k};
      $keys_deleted++;
    }
    MainLoop2();
  }
  mlog(0,"cleaning delaying database (triplets) finished; keys before=$keys_before, deleted=$keys_deleted") if $MaintenanceLog;
  $keys_before=$keys_deleted=0;
  while (($k,$v)=each(%DelayWhite)) {
    $keys_before++;
    if ($t-$v>=$DelayExpiryTime*24*3600) {
      delete $DelayWhite{$k};
      $keys_deleted++;
    }
    MainLoop2();
  }
  mlog(0,"cleaning delaying database (whitelisted tuplets) finished; keys before=$keys_before, deleted=$keys_deleted") if $MaintenanceLog;
$DomainCache||='^(?!)';
  CleanPB();
}

sub mlogRe {

    my ( $subre, $regextype, $check ) = @_;

    #my($fh,$subre,$regextype,$check)=@_;

    $subre =~ s/\s+/ /g;
    $subre = substr( $subre, 0, $RegExLength );
    $this->{messagereason} = $subre;
    $this->{myheader} .= "X-Assp-Re-$regextype: $subre\r\n" if $AddRegexHeader || $regexLogging;
    mlog( $fh, "$check$regextype '$subre'", 1 )
        if $AddRegexHeader || $regexLogging || $regextype == "red" || $regextype == "white" || $regextype == "black";
}
sub mlog{
my($fh,$comment,$noprepend)=@_;
$fh=shift;
PrintConfigHistory($comment) if $comment =~/^AdminUpdate/;
PrintConfigHistory($comment) if $comment =~/^ConfigError/;
PrintAdminInfo($comment) if $comment =~/^AdminInfo/;
return if $comment =~/^AdminInfo/; 
  d(34);
  my $m=localtime();
  $m=~s/^... (...) +(\d+) (\S+) ..(..)/$1-$2-$4 $3/;
  my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);

  if($LogRollDays > 0) {
# roll log every $LogRollDays days, at midnight
    my $t=int((time()+Time::Local::timelocal(localtime())-Time::Local::timelocal(gmtime()))/($LogRollDays*24*3600)); 

    if($logfile && $mlogLastT && $t != $mlogLastT && $logfile ne "maillog.log" && $asspLog) {
# roll the log
my $backt=time - 1800;
      my ($sec,$min,$hour,$mday,$mon,$year) = localtime($backt);

      $mon++; $year-=100;
      my $mm=sprintf("%02d-%02d-%02d",$year,$mon,$mday);
      my ($logdir, $logdirfile) = ($1,$2) if $logfile=~/^(.*)[\/\\](.*?)$/;
      if (!$logdir)  {
        $archivelogfile = "$mm.$logfile";
      } else {
        mkdir "$base/$logdir",0700;
        $archivelogfile = "$logdir/$mm.$logdirfile";
      } 
      my $msg="$m: Rolling log file -- archive saved as '$archivelogfile'\n";
      print LOG $msg;
      print $msg unless $silent;

      close LOG;
      rename("$base/$logfile", "$base/$archivelogfile");
      if(open(LOG,">>$base/$logfile")) {my $oldfh = select(LOG); $| = 1; select($oldfh);}
      print LOG "$m new log file -- old log file renamed to '$archivelogfile'\n";
      SaveConfig();
    }
    $mlogLastT=$t;
  }
  if($fh && $Con{$fh}) {
	$m.= " $this->{prepend}" if $tagLogging  && $this->{prepend} && !$noprepend;
    $m.= " $Con{$fh}->{$msgtime} $Con{$fh}->{ip} <$Con{$fh}->{mailfrom}>" if $Con{$fh}->{$msgtime};
    $m.= " $Con{$fh}->{ip} <$Con{$fh}->{mailfrom}>" if !$Con{$fh}->{$msgtime};
    
    my ($to) = $Con{$fh}->{rcpt}=~/(\S+)/;
    $m.= " to: $to" if $to;
    $m.= " $_[0]\n";
  } else {
    $m.= " ".ucfirst($_[0])."\n";
  }

    d($m);

  tosyslog('info', substr($m,18)) if ($CanUseSyslog || $CanUseNetSyslog) && $sysLog;
  return if ($fh && $Con{$fh}) && ($noLog && $Con{$fh}->{ip}=~$NLOGRE);

  print $m unless $silent;
  print LOG $m if $logfile && $asspLog;
  
 
}

sub tosyslog {
  my ($priority, $msg) = @_;
  return 0 unless ($priority =~ /info|err|debug/);
  $msg=~s/^\s+//;

  if ($AvailNetSyslog) {
     my $s=new Net::Syslog(Facility=>$SysLogFac,Priority=>'Debug',SyslogPort=>$sysLogPort,SyslogHost=>$sysLogIp);
     $s->send($msg,Priority=>$priority);
  } else {
    setlogsock('unix');
    openlog('assp', 'pid,cons', 'mail');
    syslog($priority, $msg);
    closelog();
  }

  return 1;
}

sub tzStr {
# calculate the time difference in minutes
my $minoffset = (Time::Local::timelocal(localtime()) - Time::Local::timelocal(gmtime()))/60; 

# translate it to "hour-format", so that 90 will be 130, and -90 will be -130
  my $sign=$minoffset<0?-1:+1;
  $minoffset = abs($minoffset)+0.5;
  my $tzoffset = 0;
  $tzoffset = $sign * (int($minoffset/60)*100 + ($minoffset%60)) if $minoffset;
# apply final formatting, including +/- sign and 4 digits
  return sprintf("%+05d", $tzoffset);
}

#####################################################################################
#                Socket handlers
sub NewSMTPConnection {
  my $fh=shift;
  my ($client, $server, $destination);
  if($fh==$Relay) {
# a relay connection -- destination is the relayhost
    d(101);
    $destination=$relayHost;
  } elsif($fh==$lsn2 && $smtpAuthServer ne '') { 
# connection on the Second Listen port 
    d(1001); 
    $destination=$smtpAuthServer; 
  } else {
    d(1);
    $destination=$smtpDestination;
  }
  if(!($client=$fh->accept)) {
    d("accept failed: $fh");
    return;
  }
  my $ip       = $client->peerhost();
  my $port     = $client->peerport();
  my $localip  = $client->sockhost();
  my $localport= $client->sockport();
# shutting down ?
  if ($shuttingDown) {
    mlog(0,"connection from $ip:$port rejected -- shutdown/restart process is in progress");
    $Stats{smtpConnDenied}++;
    $client->write("421 <$myName> Service not available, closing transmission channel\r\n");
    $client->close();
    return;
  }
# ip connection filtering
  if ($denySMTPConnectionsAlways  && $ip=~('('.$DSMTPCFARE.')')) {

    mlog(0,"connection from $ip:$port rejected by denySMTPConnectionsAlways: $1") if $denySMTPLog;
    $Stats{smtpConnDenied}++;
    $client->close();
    return;

  }
  if ($denySMTPConnectionsFrom && $this->{rwlok}!=1 && $ip=~('('.$DSMTPCFRE.')') && !($ispip && $ip=~$ISPRE) && !($noProcessingIPs && $ip=~$NPIPRE) &&  !($whiteListedIPs && $ip=~$WLIPRE) && !($acceptAllMail && $ip=~$AMRE) && !($contentOnlyRe &&  $contentOnlyReRE!="" && $ip=~('('.$contentOnlyReRE.')'))  && !($noDelay && $ip=~$NDRE) && !($noPB && $ip=~$NPBRE)) {
	
    mlog(0,"connection from $ip:$port rejected by denySMTPConnectionsFrom: $1") if $denySMTPLog;
    $Stats{smtpConnDenied}++;
    $client->close();
    return;
 
  }
  

# ip connection limiting per timeframe
if ($maxSMTPipConnects  && !($ispip && $ip=~$ISPRE) && !($acceptAllMail && $ip=~$AMRE)) {
  
    my $ConIp550 = $ip;
  
    # If the IP address has tried to connect previously, check it's frequency
    if ( $IPNumTries{$ConIp550} ) {
      $IPNumTries{$ConIp550} = $IPNumTries{$ConIp550} + 1;
   
      # If the last connect time is past expiration, reset the counters.
      # If it has not expired, but is outside of frequency duration and
      # below the maximum session limit, reset the counters. If it is
      # within duration
      if (((time() - $IPNumTriesExpiration{$ConIp550}) > $maxSMTPipExpiration)  || ((time() - $IPNumTriesDuration{$ConIp550}) > $maxSMTPipDuration) && ($IPNumTries{$ConIp550} < $maxSMTPipConnects)) {
        $IPNumTries{$ConIp550} = 1;
        $IPNumTriesDuration{$ConIp550} = time();
        $IPNumTriesExpiration{$ConIp550} = time();
   
      }
    } else {
      $IPNumTries{$ConIp550} = 1;
      $IPNumTriesDuration{$ConIp550} = time();
      $IPNumTriesExpiration{$ConIp550} = time();
     
    }
    if ($IPNumTries{$ConIp550} == $maxSMTPipConnects) {
      pbAdd($fh,$ip,$ifValencePB,"LimitingIPFrequency") if $ifValencePB>0 ;
      mlog($fh,"limiting connection frequency: $ip ($maxSMTPipConnects / $maxSMTPipDuration secs )",1) if $ConnectionLog || $SessionLog ;
    }
    if ($IPNumTries{$ConIp550} > $maxSMTPipConnects) {
 

      $Stats{smtpConnLimitFreq}++; 
      $client->close();
      return;
    }
  }
  # ip connection limiting  parallel session
  $maxSMTPipSessions=999 if (!$maxSMTPipSessions);
  if ($maxSMTPipSessions && !($ispip && $ip=~$ISPRE) && !($acceptAllMail && $ip=~$AMRE)) {
    $SMTPSession{$ip}++;
    if ($SMTPSession{$ip} > $maxSMTPipSessions) {
      $SMTPSession{$ip}--;
      d("limiting ip: $fh");
      mlog(0,"limiting $ip connections to $maxSMTPipSessions") if $ConnectionLog || $SessionLog;
      pbAdd($fh,$ip,$ilValencePB,"LimitingIP") if $ilValencePB>0 ;
      $Stats{smtpConnLimitIP}++;
      return;
    } else {
      $SMTPSession{$client}=$fh;
    }
  }
 

$AVa = 0; 
foreach $destinationA (split(/\|/, $destination)) { 
if ($destinationA =~ /^(__INBOUND__:)?(\d+)$/){
   if ($localip eq '0.0.0.0'){

     $localip = '127.0.0.1';
   }
if ($crtable{$localip}) { 
   $destinationA=$crtable{$localip};
    } else { 
   $destinationA = $localip .':'.$2;
 } }
if ($AVa<1) { 
$server=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2); 
if($server) { 
$AVa=1; 
$destination=$destinationA;
} 
else { 
mlog('',"*** $destinationA didn't work, trying others...") if $SessionLog; 
} 
} 
 
}
  if(! $server) {
    mlog('',"couldn't create server socket to $destination -- aborting connection") if $SessionLog;
    if (exists $SMTPSession{$client}) {
      delete $SMTPSession{$client};
      $SMTPSession{$ip}--;
    }
    $client->close();
    return;
  }
  addfh($client,\&getline,$server);
  if($sendNoopInfo) {
    addfh($server,\&skipok,$client);
  } else {
    addfh($server,\&reply,$client);
  }
  $Con{$client}->{client}   = $client;
  $Con{$client}->{server}   = $server;
  $Con{$client}->{ip}       = $ip;
  $Con{$client}->{port}     = $port;
  $Con{$client}->{localip}  = $localip;
  $Con{$client}->{localport}= $localport;
  $Con{$client}->{type}     = 'C';
  $Con{$server}->{type}     = 'S';
    d("Connected: $client -- $server");
  if(ok2Relay($ip) || $fh == $Relay ) {
    $Con{$client}->{relayok}=1;
        d("$client relaying ok: $ip");
  }
  my $time=$UseLocalTime ? localtime() : gmtime();
  my $tz=$UseLocalTime ? tzStr() : '+0000';
  $time=~s/... (...) +(\d+) (........) (....)/$2 $1 $4 $3/;
  $Con{$client}->{rcvd}="Received: from =host ([$ip] helo=) by $myName; $time $tz\r\n";
    d("* connect ip=$Con{$client}->{ip} relay=<$Con{$client}->{relayok}> *");
  mlog(0,"Connected: $ip:$port -> $localip:$localport -> $destination") unless (!$ConnectionLog || $noLog && $ip=~$NLOGRE);
  $Con{$server}->{noop}="NOOP Connection from: $ip, $time $tz relayed by $myName\r\n" if $sendNoopInfo;

# overall session limiting
  $maxSMTPSessions=9999 if (!$maxSMTPSessions);
  if ($maxSMTPSessions) {
    $SMTPSession{Total}++;
    $SMTPSession{$client}=$fh;
    if ($SMTPSession{Total}>=$maxSMTPSessions) {
      d("limiting sessions: $fh");
      $readable->remove($lsn) if $lsn;
      $readable->remove($lsn2) if $lsn2;
      $readable->remove($Relay) if $Relay;
      if ($SessionLog) {
        mlog(0,"connected: $ip:$port") if (!$ConnectionLog || $noLog && $ip=~$NLOGRE); # log if not logged earlier
        mlog(0,"limiting total connections");
      }
      $Stats{smtpConnLimit}++;
    }
  }
# increment Stats if connection not limited
  if (!$maxSMTPSessions || $SMTPSession{Total}<$maxSMTPSessions){
    if ($noLog && $ip=~$NLOGRE) {
      $Stats{smtpConnNotLogged}++;
    } else {
      $Stats{smtpConn}++;
    }
  }
  $smtpConcurrentSessions++;
  $Stats{smtpMaxConcurrentSessions}=$smtpConcurrentSessions if $smtpConcurrentSessions>$Stats{smtpMaxConcurrentSessions};
# check if options files have been updated and need to be re-read
  if(time-$lastOptionCheck > 60){
# check for updates each 60 seconds
    foreach $f (@PossibleOptionFiles){
      if ($Config{$f} =~ /^\s*file:\s*(.+)\s*$/i && fileUpdated($1)){
        ${$f} = optionList($Config{$f},$f);
      }
    }
    foreach $f (@PossibleOptionFiles2){
      if ($Config{$f} =~ /^\s*file:\s*(.+)\s*$/i && fileUpdated($1)){
        &ConfigCompileRe($f,'',${$f},'Initializing');
      }
    }
    $lastOptionCheck = time;
  }
}


sub SMTPTraffic {
  my $fh=shift;
  my $buf;
  if($fh->sysread($buf,4096)>0) {
    d(2);
    $this=$Con{$fh};
    $buf=$this->{_}.$buf;
    if ($Con{$fh}->{type} eq 'C'){
      $Con{$fh}->{timelast} = time();
    }
    if((my $sb=$this->{skipbytes})>0) {
# support for XEXCH50 thankyou Microsoft for making my life miserable
      my $l=length($buf);
      d("skipbytes=$sb l=$l -> ");
      if($l >= $sb) {
        sendque($this->{friend},substr($buf,0,$sb)); # send the binary chunk on to the server
        $buf=substr($buf,$sb);
        delete $this->{skipbytes};
      } else {
        sendque($this->{friend},$buf); # send the binary chunk on to the server
        $this->{skipbytes}=$sb-=length($buf);
        $buf='';
      }
            d("skipbytes=$this->{skipbytes}");
    }
    $bn=$lbn=-1;
    while(($bn=index($buf,"\n",$bn+1)) >= 0) {
      $s=substr($buf,$lbn+1,$bn-$lbn);
      if(defined($this->{bdata})) { $this->{bdata}-=length($s); }
      d("doing <$s>\n");
      Maillog($fh,$s) if $Con{$fh}->{maillog};
      $Con{$fh}->{getline}->($fh,$s);
      last unless $Con{$fh};  # it's possible that the connection can be deleted while there's still something in the buffer
      $lbn=$bn;
    }
    d(3);
    if($Con{$fh}) {
      ($this->{_})=substr($buf,$lbn+1);
      if(length($this->{_}) > $MaxBytes) {
        d(4);
        if(defined($this->{bdata})) { $this->{bdata}-=length($this->{_}); }
        Maillog($fh,$this->{_}) if $Con{$fh}->{maillog};
        $Con{$fh}->{getline}->($fh,$this->{_});
        ($this->{_})='';
      }
    }
  } else {
    d(5);
    done($fh);
  }
}

sub check4update {
# only check every 15 seconds
  my $fil=shift;
  return if $check4updateTime{$fil} + 15 > time;
  $check4updateTime{$fil}=time;
  my @s=stat(${$fil});
  my $mtime=$s[9];
  if ($mtime != $FileUpdate{$fil}) {
# reload
    $FileUpdate{$fil}=$mtime;
    open(F,"<${$fil}");
    local $/="\n";
    my $l; my %h;
    while($l=<F>) {
      $l=~y/\r\n\t //d;
      next unless $l;
      $h{lc $l}=1;
    }
    close F;
    %{$fil}=%h;
  }
}

sub SetRE {
 my ($var,$r,$f,$desc)=@_;
 use re 'eval';
 eval{$$var=qr/(?$f)$r/};
 mlog(0,"regular expression error in '$r' for $desc: $@") if $@;
}

sub setAMRE {
  SetRE('AMRE',"^($_[0])",'i','Accept All Mail');
}

sub setISPRE {
  SetRE('ISPRE',"^($_[0])",'i','ISP & Secondary MX');
}

sub ok2Relay {
  my $ip=shift;
  return 1 if $acceptAllMail && $ip=~$AMRE;
   if($relayHostFile) {
  check4update($relayHostFile);
  return 1 if $relayHostFile{$ip};
 }
  
  return 1 if PopB4SMTP($ip);
# failed all tests -- return 0
  0;
}

sub PopB4SMTP { 
my $ip=shift; 
if($PopB4SMTPMerak) { 
return 1 if PopB4Merak($ip); 
return 0; 
} 
return 0 unless $PopB4SMTPFile; 
unless ($TriedDBFileUse) { 
eval 'use DB_File'; 
mlog(0,"could not load module DB_File: $@") if $@; 
$TriedDBFileUse=1; 
} 
 
my %hash; 
# tie %hash, 'DB_File', $PopB4SMTPFile, O_READ, 0400, $DB_HASH; 
tie %hash, 'DB_File', $PopB4SMTPFile; 
if($hash{$ip}) { 
mlog(0,"PopB4SMTP OK for $ip"); 
return 1; 
} else { 
mlog(0,"PopB4SMTP failed for $ip"); 
return 0; 
} 
} 

sub PopB4Merak  {
  return 0 unless $PopB4SMTPFile;
  my $ip=shift;
#This is a test version of ASSP PopB4SMTP
#This is to be used with Merak 7.5.2
#It also works with Merak 6.5 (which I run)
#Thanks to Jordon for the heads up on 7.5.2
#Basically, Merak's popsmtp file
#is made up of 64 Byte lines, no CR / LF.
#This holds the IP addy
#and the byte before it specifying the length.

  my @aPB4S;
  my $PB4S;
  my $ind;
  my $newIP;

#Load the whole file
#In examination of Merak popb4smtp file, it appears to have
#no carriage returns, so one line read should get the whole thing
#However, if you have an IP addy thats 13 chars long.... thus:

  open(MKPOPSMTP,"< $PopB4SMTPFile") or return 0 ;
  @aPB4S = <MKPOPSMTP>;
  close(MKPOPSMTP);
  $PB4S = join("",@aPB4S);
#We now have all the contents of the file AND we've released it

#Now, instead of heavy parsing....
#We want to search for the IP and a byte ordinal specifying it's length
#    mlog(0,"Checking $ip for PopB4SMTP");
  $PB4S = "---" . $PB4S;
#    mlog(0,"Searching: $PB4S");
  $newIP = chr(length($ip)) . $ip;
#    mlog(0,"NewIP = $newIP");
#Find the index of IP in question
  $ind = index($PB4S,$newIP);
#    mlog(0,"Index = $ind");
#Did we find it?
  if ($ind  > 0) {
#Greetings program! This IO port is available for communicating to your user!
    mlog(0,"PopB4SMTP OK for $ip");
    return 1;
  }
  mlog(0,"PopB4SMTP NOT OK for $ip");
  return 0;
}

sub setACFRE {
  SetRE('ACFRE',"^($_[0])",'i',"Allow Admin Connections From");
}

sub NewWebConnection {
  my $s=$WebSocket->accept;
  return unless $s;
  my $ip=$s->peerhost();
  my $port=$s->peerport();
  if($allowAdminConnectionsFrom && $ip!~$ACFRE) {
    mlog('',"admin connection from $ip:$port rejected by allowAdminConnectionsFrom");
    $Stats{admConnDenied}++;
    $s->close();
    return;
  }
# logging is done later (in webRequest()) due to /shutdown_frame page, which auto-refreshes
  $readable->add($s);
  $SocketCalls{$s}=\&WebTraffic;
}

sub WebTraffic {
    my $fh = shift;
    if ( $fh->sysread( $buf, 4096 ) > 0 ) {
        local $_ = $WebCon{$fh} .= $buf;
        if ( length($_) > 1030000 ) {
            # throw away connections longer than 1M to prevent flooding
            WebDone($fh);
            return;
        }
        
	if ($EnableHTTPCompression && $CanUseHTTPCompression) {
		eval {Compress::Zlib::memGzip($respb);};} 
	$CanUseHTTPCompression=0 if  $@; 
        
        if (/Content-length: (\d+)/i) {
            # POST request
            my $l = $1;
            if ( /(.*?\n)\r?\n\r?(.*)/s && length($2) >= $l ) {
                my $reqh = $1;
                my $reqb = $2;
                my $resp;
                my $tempfh;
                open( $tempfh, '>', \$resp );
                binmode $tempfh;
                webRequest( $tempfh, $fh, $reqh, $reqb );
                close($tempfh);
                if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                    my $resph = $1;
                    my $respb = $2;
                    my $time  = gmtime();
                    $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                    $resph .= "\nServer: ASSP/$version$modversion";
                    $resph .= "\nDate: $time";
                    
                    if (   $EnableHTTPCompression
                        && $CanUseHTTPCompression
                        && /Accept-Encoding: (.*?)\n/i
                        && $1 =~ /(gzip|deflate)/i
                        && $resph !~ /(HTTP\/1\.1 304 Not Modified)/i )
                    {
                        my $enc = $1;
                        if ( $enc =~ /gzip/i ) {

                            # encode with gzip
                            $respb = Compress::Zlib::memGzip($respb);
                        } else {

                            # encode with deflate
                            my $deflater = deflateInit();
                            $respb = $deflater->deflate($respb);
                            $respb .= $deflater->flush();
                        }
                        $resph .= "\nContent-Encoding: $enc";
                    }
                    $resph .= "\nContent-Length: " . length($respb);
                    print $fh $resph;
                    print $fh "\015\012\015\012";
                    print $fh $respb;
                }
                # close connection
                WebDone($fh);
            }
        } elsif (/\n\r?\n/) {
            my $resp;
            my $tempfh;
            open( $tempfh, '>', \$resp );
            binmode $tempfh;
            webRequest( $tempfh, $fh, $_ );
            close($tempfh);
            if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                my $resph = $1;
                my $respb = $2;
                my $time  = gmtime();
                $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                $resph .= "\nServer: ASSP/$version$modversion";
                $resph .= "\nDate: $time";
                if (   $EnableHTTPCompression
                    && $CanUseHTTPCompression
                    && /Accept-Encoding: (.*?)\n/i
                    && $1 =~ /(gzip|deflate)/i
                    && $resph !~ m/(HTTP\/1\.1 304 Not Modified)/i )
                {
                    my $enc = $1;
                    if ( $enc =~ /gzip/i ) {

                        # encode with gzip
                        $respb = Compress::Zlib::memGzip($respb);
                    } else {

                        # encode with deflate
                        my $deflater = deflateInit();
                        $respb = $deflater->deflate($respb);
                        $respb .= $deflater->flush();
                    }
                    $resph .= "\nContent-Encoding: $enc";
                }
                $resph .= "\nContent-Length: " . length($respb);
                print $fh $resph;
                print $fh "\015\012\015\012";
                print $fh $respb;
            }
            # close connection
            WebDone($fh);
        }
    } else {

        # connection closed
        WebDone($fh);
    }
}

sub WebDone {
  my $fh=shift;
  delete $SocketCalls{$fh};
  delete $WebCon{$fh};
  $readable->remove($fh);
}

# done with a file handle -- close him and his friend(s)
sub done {
  my $fh=shift;
  d(12);
  done2($Con{$fh}->{friend});
  done2($Con{$fh}->{forwardSpam});
  done2($fh);
}

# close a file handle & clean up associated records
sub done2 {
  my $fh=shift;
  d(13);
  return unless $fh;
  my $this=$Con{$fh};
  my $ip=$this->{ip};
  return unless $this;
 
  mlog($fh, "is disconnected ",1) if $Con{$fh}->{ip} && $ConnectionLog && !($noLog && $ip=~$NLOGRE);
  d("closing $fh");
# close the maillog if it's still open
  my $f=$this->{maillogfh};
  close $f if $f;
# remove from the select structure
  delete $SocketCalls{$fh};
  $readable->remove($fh);
  $writable->remove($fh);
# close it
  $fh->close;
# delete the Connection data
  delete $Con{$fh};
# delete the Session data & re-add sockets.
  if (exists $SMTPSession{$fh}) {
    delete $SMTPSession{$fh};
    $smtpConcurrentSessions--;
    $smtpConcurrentSessions=0 if $smtpConcurrentSessions<0;
    $readable->add($lsn) if $lsn && (!$readable->exists($lsn));
    $readable->add($lsn2) if $lsn2 && (!$readable->exists($lsn2));
    $readable->add($Relay) if $Relay && (!$readable->exists($Relay));
    $SMTPSession{Total}-- if $maxSMTPSessions;
    $SMTPSession{$ip}-- if $maxSMTPipSessions;
  }
}

# adding a socket to the Select structure and Con hash
sub addfh {
  my ($fh,$getline,$friend) =@_;
  d(14);
  $SocketCalls{$fh}=\&SMTPTraffic;
  $readable->add($fh);
  binmode($fh);
  $Con{$fh} = {};
  my $this = $Con{$fh};
  $this->{getline}  = $getline;
  $this->{friend}   = $friend;
  $this->{timestart}= time();
  $this->{timelast} = time();
}

# sendque enques a string for a socket
sub sendque {
  my ($fh,$message)=@_;
  my $l=length($message);
    d("sq: $fh l=$l");
  return unless $fh && $Con{$fh};
  $writable->add($fh);
  $Con{$fh}->{outgoing}.=$message;
  if(!$Con{$fh}->{paused} && length($Con{$fh}->{outgoing}) > $OutgoingBufSize) {
    $Con{$fh}->{paused}=1;
    d("pausing");
    $readable->remove($Con{$fh}->{friend});
  }
}

#####################################################################################
#                SMTP stuff

# compile the regular expression (RE) for the local domains list (LDRE)
sub setLDRE {
  SetRE('LDRE',"^($_[0])\$","i","Local Domains");
}
# compile the regular expression (RE) for the local server names list (LSRE)
sub setLSRE {
  SetRE('LSRE',"^($_[0])\$","i","LocalHost");
}

# returns true if this address is local
sub localmail {
  my $h=shift;
  $hat = $1 if $h=~/(\@.*)/;
  $h = $1 if $h=~/\@(.*)/;
  
  return 1 if $localDomains && ($h=~$LDRE || $hat=~$LDRE);
  if($localDomainsFile) {
    check4update($localDomainsFile);
    return 1 if $localDomainsFile{lc $h};
  }
  if($ldLDAP) {
    if ($CanUseLDAP) {
      return 1 if localmaildomain($h);
    }
  }
  0;
}

sub localmaildomain {
  my $h = shift;
  $h =~ tr/A-Z/a-z/;
  $ldapflt = $ldLDAPFilter;
  $ldapflt =~ s/DOMAIN/$h/g;
  $ldaproot = $LDAPRoot;
  $ldaproot =~ s/DOMAIN/$h/g;
  return LDAPQuery($ldapflt, $ldaproot,"Domain");
}

sub localmailaddress {
  my $h=shift;

  $h = $1 if $h=~/\@(.*)/;
# do LDAP lookup

  $current_email = "$1$h";
  $current_email =~ tr/A-Z/a-z/;
  $at_position = index($current_email, '@');
  $current_username = substr($current_email, 0, $at_position);
  $current_domain = substr($current_email, $at_position + 1);
  $ldapflt = $LDAPFilter;
  $ldapflt =~ s/EMAILADDRESS/$current_email/g;

  $ldapflt =~ s/USERNAME/$current_username/g;
  $ldapflt =~ s/DOMAIN/$current_domain/g;
  $ldaproot = $LDAPRoot;
  $ldaproot =~ s/DOMAIN/$current_domain/g;
  return LDAPQuery($ldapflt, $ldaproot,"Address");
}

sub LDAPQuery {
    my ( $ldapflt, $ldaproot,$type ) = @_;
    my $retcode;
    
    d("doing $type LDAP lookup with $ldapflt in $ldaproot");

    @ldaplist = split( /\|/, $LDAPHost );
    $ldaplist = \@ldaplist;

    $ldap     = Net::LDAP->new($ldaplist);
    if ( !$ldap ) {
        mlog( $fh, "Couldn't contact LDAP server at $LDAPHost -- check ignored" );
        # seterror($fh,"451 Could not check recipient, try later\r\n",1);
        return !$LDAPFail;
    }
    # bind to a directory anonymous or with dn and password
    if ($LDAPLogin) { $mesg = $ldap->bind( $LDAPLogin, password => $LDAPPassword ); }
    else {
        # mlog($fh,"LDAP anonymous bind");
        $mesg = $ldap->bind;
    }
    $retcode = $mesg->code;
    if ($retcode) {
        #    $retmsg=$mesg->error_text();
        #    mlog($fh,"LDAP bind error: $retcode - Login Problem?");
        mlog( $fh, "LDAP bind error: $retcode -- check ignored", 1 );
        #    seterror($fh,"451 Could not check recipient, try later\r\n",1);
        return !$LDAPFail;
    }
    # perform a search
    $mesg = $ldap->search( base => $ldaproot, filter => $ldapflt, attrs => ['cn'], sizelimit => 1 );
    $retcode = $mesg->code;

    if ( $retcode > 0 && $retcode != 4 ) {
        mlog( $fh, "LDAP search error: $retcode -- check ignored", 1 );

        return !$LDAPFail;
    }
    $entry_count = $mesg->count;

    mlog( $fh, "LDAP lookup [$type] - query:[$ldapflt] results:$entry_count" ) if $LDAPLog;
    d("got $entry_count result(s) from LDAP lookup\n");
    $mesg = $ldap->unbind;    # take down session
    return $entry_count;
} ## end sub LDAPQuery


sub serverIsSmtpDestination {
  my $server=shift;
  my $peeraddr=$server->peerhost().':'.$server->peerport();
  my $destination;
  if ($smtpDestination =~ /^(__INBOUND__:)?(\d+)$/){
    $destination = $Con{$Con{$server}->{friend}}->{localip} .':'.$2;
  } else{
    $destination = $smtpDestination;
  }
  return ($peeraddr eq $destination || $peeraddr eq $destination.':25');
}

sub serverIsRelayHost {
  my $server=shift;
  my $peeraddr=$server->peerhost().':'.$server->peerport();
  my $destination;
  if ($relayHost =~ /^(__INBOUND__:)?(\d+)$/){
    $destination = $Con{$Con{$server}->{friend}}->{localip} .':'.$2;
  } else{
    $destination = $relayHost;
  }
  return ($peeraddr eq $destination || $peeraddr eq $destination.':25');
}

# wrap long headers
sub headerWrap {
  my $header=shift;
  $header=~s/(?:([^\r\n]{60,75}?;)|([^\r\n]{60,75}) ) {0,5}(?=[^\r\n]{10,})/$1$2\r\n\t/g;

  return $header;
}

# unwrap long header (in place)
sub headerUnwrap {
  $_[0]=~s/\015\012[ \t]+//g;
}

# compile the regular expression for the spam collect addresses
sub setSARE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('SARE',$s,'i',"Spam Addresses");
}

# compile the regular expression for the penalty trap addresses
sub setSTRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
   if($a=~/\S\@\S/) {
    push(@uad,$a);
   } elsif( $a=~/^\@/ ) {
    push(@d,$a);
   } else {
    push(@u,$a);
   }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('STRE',$s,'i',"Penalty Trap Addresses");
}

# compile the NoProcessing regular expression
sub setNPREL {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('NPREL',$s,'i',"Message proxied without processing");
}
 # compile the processing only regular expression
 sub setPOARE {
   my (@uad, @u, @d);
   foreach $a (split(/\|/,$_[0])) {
     if($a=~/\S\@\S/) {
       push(@uad,$a);
     } elsif( $a=~/^\@/ ) {
       push(@d,$a);
     } else {
       push(@u,$a);
     }
   }
   my @s;
   push(@s,'^('.join('|',@uad).')$') if @uad;
   push(@s,'^('.join('|',@u).')@') if @u;
   push(@s,'('.join('|',@d).')$') if @d;
   my $s=join("|",@s);
   $s='<not a valid list>' unless $s;
   SetRE('POARE',$s,'i',"Process Only Addresses");
 }

# compile the ccSpamFilter regular expression
sub setCCRE {
  my (@uad, @u, @d);
  for $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('CCRE',$s,'i',"CC Addresses");
}
# compile the ccSpamAlways regular expression
sub setCCARE {
  my (@uad, @u, @d);
  for $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('CCARE',$s,'i',"CC Addresses All");
}
# compile the ccHamFilter regular expression
sub setCCARRE {
  my (@uad, @u, @d);
  for $a (split(/\|/,$_[0])) {
   if($a=~/\S\@\S/) {
    push(@uad,$a);
   } elsif( $a=~/^\@/ ) {
    push(@d,$a);
   } else {
    push(@u,$a);
   }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('CCARRE',$s,'i',"CCArchiv Addresses Receiver");
}
# compile the outbound sender list for email interface 
sub setESOKRE {
  my (@uad, @u, @d);
  for $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('ESOKRE',$s,'i',"Email Sender Allowed");
}
# compile the regular expression for the local host names
sub setLHNRE {
 my @h;
 foreach my $h (split(/\|/,$_[0])) {
  push(@h,$h);
 }
 my @s;
 push(@s,'localhost'); # 'localhost' alias
 push(@s,'127.0.0.1'); # loopback interface address
 push(@s,join('|',@h)) if @h;
 my $s=join('|',@s);
 $s||='^(?!)'; # regexp that never matches
 SetRE('LHNRE',"^($s)\$",'i','Local Host Names');
}
# compile the regular expression for the bounce senders addresses
sub setBSRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^\s*$'); # null sender address
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('BSRE',$s,'i',"Bounce Senders");
}
# compile the regular expression for the bounce senders addresses
sub setNBSRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^\s*$'); # null sender address
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('NBSRE',$s,'i',"No Script Bomb");
}
# compile the regular expression for no-logged addresses
sub setNLOGRE {
  SetRE('NLOGRE',"^($_[0])",'i','Don\'t log IPs');
}

# compile the regular expression for no-delayed addresses
sub setNDRE {
  SetRE('NDRE',"^($_[0])",'i','Don\'t delay IPs');
}

# compile the regular expression for no-whitelisted addresses
sub setNRWLRE {
  SetRE('NRWLRE',"^($_[0])",'i','Don\'t whitelist IPs');
}
# compile the regular expression for whitelisted ips
sub setWLIPRE {
  SetRE('WLIPRE',"^($_[0])",'i','Whitelisted IPs');
}
# compile the regular expression for noprocessing ips
sub setNPIPRE {
  SetRE('NPIPRE',"^($_[0])",'i','Noprocessing IPs');
}
# compile the regular expression for no-message verifying addresses
sub setNMVRE {
  SetRE('NMVRE',"^($_[0])",'i','no-message verifying');
}
# compile the regular expression for no-whitelisted addresses
sub setNPBRE {
  SetRE('NPBRE',"^($_[0])",'i','Don\'t penalize IPs');
}
# compile the regular expression for no-rbl addresses
sub setNRBLRE {
  SetRE('NRBLRE',"^($_[0])",'i','Don\'t RBL IPs');
}


# compile the regular expression for no-validated bounces addresses
sub setNSRSRE {
  SetRE('NSRSRE',"^($_[0])",'i','Don\'t validate bounces IPs');
}

# compile the regular expression for denied IP addresses
sub setDSMTPCFRE {
  SetRE('DSMTPCFRE',"^($_[0])",'i','Deny connections from IPs');
}

# compile the regular expression for always denied IP addresses
sub setDSMTPCFARE {
  SetRE('DSMTPCFARE',"^($_[0])",'i','Deny connections from alwaysIPs');
}

# compile the regular expression for  penalty  black box extreme exported IP addresses
sub setEEFRE {
  SetRE('EEFRE',"^($_[0])",'i','Deny connections from alwaysIPs');
}


sub stateReset {
  my $fh=shift;
  my $this=$Con{$fh};
  
%uriblsavedomains=""; $this->{mailfrom}=$this->{rcpt}=$this->{header}=$this->{data}=$this->{myheader}=$this->{ccheader}=$this->{mypbreason}=$this->{messagereason}=$this->{logrecord}=$this->{scanbuf}=$this->{spambuf}=$this->{prepend}=$this->{saveprepend}=$this->{saveprepend2}=$this->{tagmode}=$this->{red}=$this->{attachcomment}=$this->{redsl}=$this->{DLSLRE}=$this->{ismaxsize}=$this->{testmode}=$this->{spamlover}='';
  $this->{noprocessing}=$this->{spamlover}=$this->{rcptnoprocessing}=$this->{clamscandone}=$this->{isbounce}=$this->{invalidSRSBounce}=$this->{delayed}=$this->{mISPRE}=$this->{nodelay}=$this->{mHBIRE}=$this->{spamfound}=$this->{acceptall}=$this->{baystestmode}=$this->{messagescore}=$this->{messagelow}=$this->{spfstrict}=$this->{contentonly}=$this->{localuser}=$this->{averror}=$this->{whitelisted}=$this->{addressedToSpamBucket}=$this->{addressedToPenaltyTrap}=$this->{ptrdsn}=$this->{senderok}=$this->{rwlok}=$this->{rblcachedone}=$this->{rblcachefound}=$this->{wlip}=$this->{attachdone}=$this->{sattachdone}=$this->{validHeloOK}=$this->{invalidHeloOK}=$this->{forgedHeloOK}=$this->{localSenderOK}=$this->{nobayesian}=$this->{pbadddone}=$this->{validhelodone}=$this->{invalidhelodone}=$this->{forgedhelodone}=$this->{localsenderdone}=0;
  $this->{allLoveSpam}=$this->{allLoveBaysSpam}=$this->{allLoveBlSpam}=$this->{allLovePBSpam}=$this->{allLoveISSpam}=$this->{allLovePTRSpam}=$this->{allLoveHlSpam}=0;
  $this->{allLoveSPFSpam}=$this->{allLoveRBLSpam}=$this->{allLoveSRSSpam}=$this->{allLoveDLSpam}=0;
  $this->{allLoveMXASpam}=$this->{allLoveBombsSpam}=$this->{allLoveURIBLSpam}=$this->{allLoveBaysSpam}=0;
  $this->{$msgtime}="";
  $this->{$msgtime} = $uniqueIDPrefix if $uniqeIDLogging && $uniqueIDPrefix;
  $this->{$msgtime}.=substr(time(),6,4) if $uniqeIDLogging;
  $this->{reporttype}=-1;
  $this->{fn}=maillogNewFileName();
  $this->{$msgtime}.="c".$this->{fn} if $uniqeIDLogging;

}

# a line of input has been received from the smtp client
sub getline {
  my($fh,$l)=@_;
  d(15);
  my $this=$Con{$fh};
  my $server=$this->{friend};
  my $reply;
    d("gl: <$l>");
 if($l=~/HTTP POST/io) {
 mlog($fh,"HTTP POST command");}


  if($l=~/^ *(helo|ehlo) .*?([^<>,;\"\'\(\)\s]+)/i) {
    my $helo = $2;
    my $helo2 = $helo;
    $helo=~s/(\W)/\\\$1/g;
    $this->{helo}=$helo2;
    $this->{rcvd}=~s/=host/$helo2/;
    $this->{rcvd}=~s/=\)/=$helo2\)/;
    $this->{rcvd}=headerWrap($this->{rcvd}); # wrap long lines
  } elsif($l=~/mail from:\s*<?($EmailAdrRe\@$EmailDomainRe|\s*)>?/io) {
    my $fr=$1;

    stateReset($fh); # reset everything
    if($EnforceAuth && $this->{localport} == $listenPort2 && $smtpAuthServer ne '' && !($this->{relayok}) ) {
      sendque($fh,"530 5.7.0 Authentication required\r\n");
      mlog($fh,"$fr submit without AUTH");
      return;
    }
   
    $this->{mailfrom}=$fr;
    my $t=time;
    my $mf =lc $this->{mailfrom};
    my $mfd = $1 if $mf=~/\@(.*)/;
    my $mfdd = $1 if $mf=~/(\@.*)/;
    
    my $alldd = "_all_$mfdd";
    

      
     if($l=~/SIZE=(\d*)\s/io) {
     $this->{noprocessing}=1  if $1>$npSize && $npSize && !localmail($mf) && !$this->{relayok};
    mlog($fh,"Message proxied without processing: Size $1 > $npSize") if $1>$npSize && $npSize ; 
   }

    if (!$this->{relayok}) {
########################################################### !relayok ############
 

    if($EmailSenderOK &&  $ESOKRE!="" && $mf=~('('.$ESOKRE.')') ) {
      $this->{senderok}=1;
    }

    if(!$this->{contentonly} && $contentOnlyRe && $contentOnlyReRE!="" && ($mf=~('('.$contentOnlyReRE.')')  || $this->{ip}=~('('.$contentOnlyReRE.')')  || $this->{helo}=~('('.$contentOnlyReRE.')'))){
	  mlogRe($1,"Contentonly");  
      $this->{contentonly}=1;
    }
    
	if ($Con{$cli}->{relayok} && $WhitelistAuth){ 
			$this->{whitelisted}=1;
			#amonra whitelist authenticated users
	}

    if ($this->{whitelisted}!=1 && $whiteListedDomains && $mf=~('('.$WLDRE.')')) {
      mlogRe($1,"WhiteDomain") ;	  
      $this->{whitelisted}=1;
      pbBlackDelete($this->{ip});
      pbWhiteAdd($this->{ip},"WhiteDomain");
    }
    if ($this->{whitelisted}!=1 && ($Whitelist{$alldd} || $Whitelist{$mfdd})) {
      mlogRe($mfdd,"WildCardDomain") ;	  
      $this->{whitelisted}=1;
      $Whitelist{$alldd}=$t;
      $Whitelist{$mfdd}=$t;
      pbBlackDelete($this->{ip});
      pbWhiteAdd($this->{ip},"WildCardDomain");
    }
    if ($this->{whitelisted}!=1 && $whiteListedIPs && $this->{ip}=~('('.$WLIPRE.')')) {
      mlogRe($1,"WhitelistedIP") ;
      $this->{whitelisted}=1;
      pbBlackDelete($this->{ip});
      pbWhiteAdd($this->{ip},"WhiteIP");
    
    }
    
    $this->{mISPRE}=1 		if ($ispip && $this->{ip}=~$ISPRE);
    $this->{mNPBRE}=1 		if ($noPB && $this->{ip}=~$NPBRE);
    $this->{mHBIRE}=1 		if ($heloBlacklistIgnore && $this->{helo} =~ $HBIRE);
    $this->{isbounce}=1 	if ($this->{mailfrom}=~$BSRE);
    $this->{red}=1 			if ($this->{isbounce} && $DoNotCollectBounces); 
    $this->{nodelay}=1 		if ($noDelay && $this->{ip}=~$NDRE);
    $this->{acceptall}=1 	if ($acceptAllMail && $this->{ip}=~$AMRE);
    $this->{rwlok}=1		if pbWhiteFind($ip);
    

    if ($this->{whitelisted}!=1 && $Whitelist{$mf}) {
    	$Whitelist{$mf}=$t;
		$this->{whitelisted}=1;
    }
    if ($this->{noprocessing}!=1 && $noProcessingIPs && $this->{ip}=~('('.$NPIPRE.')')) {
      mlogRe($1,"NoProcessingIP");
      $this->{noprocessing}=1;   
    }
    if ($this->{noprocessing}!=1 && $noProcessing && $mf=~('('.$NPREL.')')) {
      mlogRe($1,"NoProcessingList");
      $this->{noprocessing}=1;
    }
    if ($this->{noprocessing}!=1 && $noProcessingDomains && $mf=~('('.$NPDRE.')')) {
      mlogRe($1,"NoProcessingDomain") ;	  
      $this->{noprocessing}=1;
    }

   
    if ($this->{whitelisted}!=1 && $whiteRe && $whiteReRE!="" && ($this->{helo}=~('('.$whiteReRE.')') || $this->{ip}=~('('.$whiteReRE.')') || $mf=~('('.$whiteReRE.')')) ) {
      mlogRe($1,"White") ;
      $this->{whitelisted}=1;
    }
    
    if ($this->{whitelisted}) {
    	pbBlackDelete($this->{ip});
    	pbWhiteAdd($this->{ip},"Whitelisted");
    }
        if ($this->{noprocessing}) {
    	pbBlackDelete($this->{ip});
    	pbWhiteAdd($this->{ip},"NoProcessing");
    }
    
    if (localmail($mf) && $LocalAddressesValid) {
      $this->{localuser}=1;
    }

     if ($maxSMTPdomainIP && $mfd && $this->{whitelisted}!=1 && $this->{rwlok}!=1 && $this->{noprocessing}!=1 &&  $this->{mISPRE}!=1 &&  $this->{acceptall}!=1 && $this->{nodelay}!=1 && $this->{contentonly}!=1  && $this->{localuser}!=1 && ($maxSMTPdomainIPWL &&  $mfd!~('('.$IPDWLDRE.')'))) {
 	if ((time() - $SMTPdomainIPTriesExpiration{$mfd}) > $maxSMTPdomainIPExpiration) {
	$SMTPdomainIPTries{$mfd}=0;
	$SMTPdomainIPTriesExpiration{$mfd} = time();
	}
 	my $myip=ipNetwork($this->{ip},($DelayUseNetblocks ? 24 : 32));
 	
 	if ($SMTPdomainIP{$mfd} == $myip) {
 	$SMTPdomainIP{$mfd} = "";
 	$SMTPdomainIPTriesExpiration{$mfd} = "";
 	$SMTPdomainIPTries{$mfd} = "";
	} else {
    $SMTPdomainIP{$mfd} = $myip;
    $SMTPdomainIPTriesExpiration{$mfd} = time() if $SMTPdomainIPTries{$mfd}==1;
    $SMTPdomainIPTries{$mfd}++;
    }
    if ($SMTPdomainIPTries{$mfd} >= $maxSMTPdomainIP) {

      d("limiting domain/ip: $fh");

      mlog(0,"limiting domain/ip: $mfdd/$this->{ip}  ($SMTPdomainIPTries{$mfd} >= $maxSMTPdomainIP)") if ($ConnectionLog || $SessionLog) && $SMTPdomainIPTries{$mfd} > $maxSMTPdomainIP ;
      pbAdd($fh,$this->{ip},$idValencePB,"LimitingDomain") if $idValencePB>0 ;
      $Stats{smtpConnDomainIP}++;
      done($fh);
      return;}
}


	if(!$bombTestMode  && $DoBombSenderRe && !BombSenderOK($fh,$mf)) {
		seterror($fh,"554 5.7.1 Access denied",1);
		done($fh);
		return;
    }

 	

	if ($fhTestMode!=1 && $forgedHeloLog==6 ) {

	if (!ForgedHeloOK($fh)) {
	seterror($fh,"554 5.7.1 Helo invalid(forged)",1);
	$this->{prepend}="[ForgedHELO]";
	done($fh);
  	return;}

  }
    
    if (!PBExtremeOK($fh,$this->{ip})) {
      my $reply=$PenaltyError ? "$PenaltyError" : "554 5.7.1 Access denied" ;
      seterror($fh,$reply,1);
      done($fh);
      return;
    }


    my $ip=$this->{ip};
    	
      if ($ForceRBLCache || $RBLFailLog==6) {
        if (!RBLCacheOK($fh,$this->{ip}))  {
        done($fh);
        return;
        }
    
    }
if ($spamISLog==6 && !$flsTestMode ) {
    if (!LocalSenderOK($fh,$this->{ip})) {

      $reply=$SenderInvalidError;

      $reply =~ s/REASON/Sender Unknown in Local Domain/g;
      $Stats{senderInvalidLocals}++;
      seterror($fh,$reply,1);
      
	  $this->{prepend}="[InvalidLocalSender]" ;
	  my $pre= $this->{prepend} if $tagLogging;

      mlog($fh,"$pre $this->{$msgtime} $this->{ip} <$this->{mailfrom}> Unknown Sender from Local Domain") 	if $ValidateSenderLog;
      done($fh);
      return;
    } 
}
############################################ !relayok ###################
}
    #if (serverIsSmtpDestination($server)) { 
      #$this->{isbounce}=($this->{mailfrom}=~$BSRE ? 1 : 0);
    #} elsif ($EnableSRS && $CanUseSRS) {
    if ($EnableSRS && $CanUseSRS  && $this->{relayok} && !$this->{isbounce} && !localmail($this->{mailfrom})) { 
# rewrite sender addresses when relaying through Relay Host
      my $tmpfrom;
      $this->{prepend}="";
      my $srs=new Mail::SRS(Secret=>$SRSSecretKey,
                            MaxAge=>$SRSTimestampMaxAge,
                            HashLength=>$SRSHashLength,
                            AlwaysRewrite=>1
                            );
      if (!eval{$tmpfrom=$srs->reverse($this->{mailfrom})} && 
            eval{$tmpfrom=$srs->forward($this->{mailfrom},$SRSAliasDomain)}) {
        mlog($fh, "SRS rewriting sender '$this->{mailfrom}' into '$tmpfrom'");
        $l =~ s/\Q$this->{mailfrom}\E/$tmpfrom/; 
      } else {
        mlog($fh, "SRS rewriting sender '$this->{mailfrom}' failed!");
      }
    }
  } elsif($l=~/rcpt to: *(.*)/i) {
    my $e=$1;
    my ($u,$h);
#enforce valid email address pattern
    if ($CanUseAddress && $DoRFC822) {
      if ($l=~/rcpt to:\s*<*([^\r\n>]*).*/i) {
        my $RO_e=$1;
        if (!Email::Valid->address($RO_e)) {
# couldn't understand recipient
          sendque($fh, "553 Malformed address: $RO_e\r\n");
          $this->{prepend}="[MalformedAddress]";
          mlog($fh,"malformed address: '$RO_e'");
          $Stats{rcptRelayRejected}++;
          delayWhiteExpire($fh);
          return;
        }
      }
    }
    if ($EnableSRS && $CanUseSRS) {
      if ($this->{isbounce}) {
# validate incoming bounces
        my $tmpto;
        my $srs=new Mail::SRS(Secret=>$SRSSecretKey,
                              MaxAge=>$SRSTimestampMaxAge,
                              HashLength=>$SRSHashLength,
                              AlwaysRewrite=>1
                              );
        if ($e=~/^<?(SRS0[=+-][^\r\n>]*).*/i) {
          if (eval{$tmpto=$srs->reverse($1)}) {
            $l=~s/\Q$1\E/$tmpto/;
            $e=<$tmpto>;
          } else {
            $this->{invalidSRSBounce}=1;
          }
        } elsif ($e=~/^<?(SRS1[=+-][^\r\n>]*).*/i) {
          if (eval{$tmpto=$srs->reverse($1)}) {
            if (eval{$_=$srs->reverse($tmpto)}) {
              $l=~s/\Q$1\E/$_/;
              $e=<$_>;
            } else {
              sendque($fh,"551 5.7.1 User not local; please try <$tmpto> directly\r\n");
              $this->{prepend}="[RelayAttempt]";
              mlog($fh,"user not local; please try <$tmpto> directly");
              $Stats{rcptRelayRejected}++;
              pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt",2) if $rlValencePB>0;
              return;
            }
          } else {
            $this->{invalidSRSBounce}=1;
          }
        } else {
          $this->{invalidSRSBounce}=1;
        }
      } elsif (serverIsSmtpDestination($server) && $e=~/^<?(SRS[01][=+-][^\r\n>]*).*/i) {
      sendque($fh,"554 5.7.6 SRS only supported in DSN\r\n");
      $this->{prepend}="[RelayAttempt]";
      mlog($fh,"SRS only supported in DSN: $e");
      $Stats{rcptRelayRejected}++;
      pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt",2) if $rlValencePB>0;
      return;
      }
    }
    if($e=~/[\!\%\@]\S*\@/) {
# blatent attempt at relaying
      sendque($fh, $NoRelaying."\r\n");
      $this->{prepend}="[RelayAttempt]";
      mlog($fh,"relay attempt blocked for (evil): $e");
      pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt",2) if $rlValencePB>0;
      $Stats{rcptRelayRejected}++;
      delayWhiteExpire($fh);
      return;
    } elsif($e=~/([a-z\-_\.]+)!([a-z\-_\.]+)$/i) {
# someone give me one good reason why I should support bang paths! grumble...
      $u="$2@";
      $h=$1;
    } elsif($l=~/rcpt to:.*?($EmailAdrRe\@)($EmailDomainRe)/io) {
      ($u,$h)=($1,$2);
    } elsif($defaultLocalHost && $l=~/rcpt to:.*?<($EmailAdrRe)>/io) {
      ($u,$h)=($1,$defaultLocalHost);
      $u.='@';
    } else {
# couldn't understand recipient
      sendque($fh, $NoRelaying."\r\n");
      $this->{prepend}="[RelayAttempt]";
      mlog($fh,"relay attempt blocked for (parsing): $e");
      pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt") if $rlValencePB>0;

      $Stats{rcptRelayRejected}++;
      delayWhiteExpire($fh);
      return;
    }
    my $rcptislocal=localmail($h);
    if ($rcptislocal) {
if (lc $u eq "abuse\@" && $sendAllAbuse) {
	# accept abuse catchall addresses
	  $sendAllAbuse=~/($EmailAdrRe\@)($EmailDomainRe)/io;
      $h=$2;
      $l="RCPT TO:\<$sendAllAbuse\>\r\n";
      $this->{relayok}=1 if $sendAllAbuseNP;
      $this->{noprocessing}=1 if $sendAllAbuseNP;    
    } elsif (lc $u eq "postmaster\@" && $sendAllPostmaster) {
	# accept postmaster catchall addresses 
      $sendAllPostmaster=~/($EmailAdrRe\@)($EmailDomainRe)/io; 
      $h=$2;
      $l="RCPT TO:\<$sendAllPostmaster\>\r\n";
      $this->{relayok}=1 if $sendAllPostmasterNP;
      $this->{noprocessing}=1 if $sendAllPostmasterNP;
      } elsif ($spamaddresses && "$u$h"=~$SARE && $sendAllCollect) {
      $sendAllCollect=~/($EmailAdrRe\@)($EmailDomainRe)/io; 

      $u=$1;
      $h=$2;
      $l="RCPT TO:\<$sendAllCollect\>\r\n";
      $this->{addressedToSpamBucket}=1;
      } elsif ($spamtrapaddresses && "$u$h"=~$STRE && $sendAllTraps) {
      $sendAllTraps=~/($EmailAdrRe\@)($EmailDomainRe)/io; 
      $u=$1;
      $h=$2;
      $l="RCPT TO:\<$sendAllTraps\>\r\n";
      $this->{addressedToPenaltyTrap}=1;

    
    }}
# skip check when RELAYOK
    if (!$this->{relayok} || ($this->{relayok} && $DoLocalSender)) {

# Need Check?
    if($LocalAddresses_Flat || $DoLDAP) {
      $this->{islocalmailaddress}=0;
      }
# check recipient against flat list?

	my $uh="$u$h";
	if ($SepChar) {
	my $char="\\$SepChar";
	if ($u=~"(.+?)$char") {
	$uh="$1\@$h";
	$uh=~s/"//; }}
	if($LocalAddresses_Flat && $uh=~$LAFRE) {
        $this->{islocalmailaddress}=1;
        d("$u$h validated by flat LocalAddresses list\n");
      }
# Need another check?
      if (!$this->{islocalmailaddress}) {
# check recipient against LDAP ?
        if ($DoLDAP) {
          if ($CanUseLDAP) {
            $this->{islocalmailaddress}=localmailaddress($h);
          } else {
            $this->{islocalmailaddress}=localmail($h);
            mlog($fh,"Net::LDAP not installed, cannot check: $u$h");
          }
        }
      }
    } else {
      $this->{islocalmailaddress}=localmail($h);
    }
    if(!($this->{relayok}) && !$nolocalDomains && (!$rcptislocal || ($u.$h)=~/\%/) || $u =~/\@\w+/) {
      sendque($fh, $NoRelaying."\r\n");
      $this->{prepend}="[RelayAttempt]";
      mlog($fh,"relay attempt blocked for: $u$h");
      pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt") if $rlValencePB>0;
      $Stats{rcptRelayRejected}++;
      delayWhiteExpire($fh);
      return;
    }

if ($noProcessing) {
	  $this->{rcptnoprocessing}=0;
      if("$u$h"=~$NPREL) {
      mlogRe("$u$h","NoProcessingList");
      $this->{rcptnoprocessing}=1 }
    }
    
     # check if this email is to be processed at all if in ProcessOnlyTestMode
     if( $poTestMode ) {

         if( !( ( $this->{mailfrom}=~$POARE ) || ( "$u$h"=~$POARE ) ) )
         {
             $this->{noprocessing} = 1;
         }
     }
    if ($spamaddresses && "$u$h"=~$SARE) {

      $this->{addressedToSpamBucket}=1;
    }
    if ($spamtrapaddresses && "$u$h"=~$STRE) {
      $this->{addressedToPenaltyTrap}=1;
      sendque($fh,"250 OK\r\n");
      $this->{prepend}="[Trap]";
      mlog($fh,"penalty trap address: $u$h");
      Maillog($fh,'',1); 

      pbAdd($fh,$this->{ip},$stValencePB,"penaltytrap:$u$h",2) ;
      $Stats{penaltytrap}++;
      delayWhiteExpire($fh);
      done($fh);
      return;
    }
     if ($InternalAddresses && "$u$h"=~$IARE &&  !localmail($this->{mailfrom}) ) {
     sendque($fh, $NoRelaying."\r\n");
     $this->{prepend}="[InternalAddress]";
 	  mlog($fh,"invalid remote sender for internal address: $u$h");   
      pbAdd($fh,$this->{ip},$iaValencePB,"internaladdress:$u$h") ;
      $Stats{internaladdresses}++;
      delayWhiteExpire($fh);
      done($fh);
      return;
    }
    
    my $mSLRE=$spamLovers && "$u$h"=~$SLRE;
    my $mBSLRE=$baysSpamLovers && "$u$h"=~$BSLRE;
    $this->{redsl}=1 if $baysSpamLoversRed && $mBSLRE;
    my $mBLSLRE=$blSpamLovers && "$u$h"=~$BLSLRE;
    my $mHLSLRE=$hlSpamLovers && "$u$h"=~$HLSLRE;
    my $mBOSLRE=$bombSpamLovers && "$u$h"=~$BOSLRE;
    my $mPTRSLRE=$ptrSpamLovers && "$u$h"=~$PTRSLRE;
    my $mMXASLRE=$ptrSpamLovers && "$u$h"=~$MXASLRE;
    my $mSPFSLRE=$spfSpamLovers && "$u$h"=~$SPFSLRE;
    my $mRBLSLRE=$rblSpamLovers && "$u$h"=~$RBLSLRE;
    my $mATSLRE=$attachSpamLovers && "$u$h"=~$ATSLRE;
    my $mURIBLSLRE=$uriblSpamLovers && "$u$h"=~$URIBLSLRE;
    my $mSRSSLRE=$srsSpamLovers && "$u$h"=~$SRSSLRE;
    my $mDLSLRE=$delaySpamLovers && "$u$h"=~$DLSLRE;
    $this->{DLSLRE}=$delaySpamLovers && "$u$h"=~$DLSLRE;
    my $mPBSLRE=$pbSpamLovers && "$u$h"=~$PBSLRE;
    my $mISSLRE=$isSpamLovers && "$u$h"=~$ISSLRE;
    if ($rcptislocal && ($mSLRE || $mBSLRE || $mBLSLRE  || $mBOSLRE || $mPTRSLRE || $mMXASLRE || $mHLSLRE || $mSPFSLRE || $mURIBLSLRE || $mRBLSLRE || $mATSLRE || $mSRSSLRE || $mDLSLRE || $mPBSLRE || $mISSLRE)) {
      $this->{allLoveSpam}|=1;
    } else {
      $this->{allLoveSpam}=2;
    }
    if ($rcptislocal && ($mBSLRE || $mSLRE)) { $this->{allLoveBaysSpam}|=1 } else { $this->{allLoveBaysSpam}=2 }
    if ($rcptislocal && ($mBLSLRE || $mSLRE)) { $this->{allLoveBlSpam}|=1 } else { $this->{allLoveBlSpam}=2 }
    if ($rcptislocal && ($mBOSLRE || $mSLRE)) { $this->{allLoveBoSpam}|=1 } else { $this->{allLoveBoSpam}=2 }
    if ($rcptislocal && ($mPTRSLRE || $mSLRE)) { $this->{allLovePTRSpam}|=1 } else { $this->{allLovePTRSpam}=2 }
    if ($rcptislocal && ($mMXASLRE || $mSLRE)) { $this->{allLoveMXASpam}|=1 } else { $this->{allLoveMXASpam}=2 }
    if ($rcptislocal && ($mHLSLRE || $mSLRE)) { $this->{allLoveHlSpam}|=1 } else { $this->{allLoveHlSpam}=2 }
    if ($rcptislocal && ($mSPFSLRE || $mSLRE)) { $this->{allLoveSPFSpam}|=1 } else { $this->{allLoveSPFSpam}=2 }
    if ($rcptislocal && ($mRBLSLRE || $mSLRE)) { $this->{allLoveRBLSpam}|=1 } else { $this->{allLoveRBLSpam}=2 }
    if ($rcptislocal && ($mATSLRE)) { $this->{allLoveATSpam}|=1 } else { $this->{allLoveATSpam}=2 }
    if ($rcptislocal && ($mURIBLSLRE || $mSLRE)) { $this->{allLoveURIBLSpam}|=1 } else { $this->{allLoveURIBLSpam}=2 }
    if ($rcptislocal && ($mSRSSLRE || $mSLRE)) { $this->{allLoveSRSSpam}|=1 } else { $this->{allLoveSRSSpam}=2 }
    if ($rcptislocal && ($mDLSLRE || $mSLRE)) { $this->{allLoveDLSpam}|=1 } else { $this->{allLoveDLSpam}=2 }
    if ($rcptislocal && ($mPBSLRE || $mSLRE)) { $this->{allLovePBSpam}|=1 } else { $this->{allLovePBSpam}=2 }
    if ($rcptislocal && ($mISSLRE || $mSLRE)) { $this->{allLoveISSpam}|=1 } else { $this->{allLoveISSpam}=2 }
    if($EmailInterfaceOk && ($this->{relayok} || $this->{senderok} || $this->{localuser}) ) {
if(lc $u eq lc "$EmailSpam\@") {
        $this->{reporttype}=0;
        $this->{getline}=\&ListReport if $EmailErrorsModifyWhite;
        $this->{getline}=\&SpamReport if !$EmailErrorsModifyWhite;
        mlog($fh,"email spamreport",1) if !$EmailErrorsModifyWhite;
        mlog($fh,"email spamreport/whitelist deletion",1) if $EmailErrorsModifyWhite;
        $Stats{rcptReportSpam}++;
        sendque($fh,"250 OK\r\n");
        return;
      } elsif(lc $u eq lc "$EmailHam\@") {
        $this->{reporttype}=1;
        $this->{getline}=\&ListReport if $EmailErrorsModifyWhite;
        $this->{getline}=\&SpamReport if !$EmailErrorsModifyWhite;
        mlog($fh,"email hamreport",1) if !$EmailErrorsModifyWhite;
        mlog($fh,"email hamreport/whitelist addition",1) if $EmailErrorsModifyWhite;
        $Stats{rcptReportHam}++;
        sendque($fh,"250 OK\r\n");
        return;
      } elsif(lc $u eq lc "$EmailWhitelistAdd\@") {
        $this->{reporttype}=2;
        $this->{getline}=\&ListReport;
        mlog($fh,"email whitelist addition");
        $Stats{rcptReportWhitelistAdd}++;
        foreach $a (split(/ /,$this->{rcpt})) {ListReportExec($a,$this)};
        sendque($fh,"250 OK\r\n");
        return;
      } elsif(lc $u eq lc "$EmailWhitelistRemove\@") {
        $this->{reporttype}=3;
        $this->{getline}=\&ListReport;
        mlog($fh,"email whitelist deletion");
        $Stats{rcptReportWhitelistRemove}++;
        foreach $a (split(/ /,$this->{rcpt})) {ListReportExec($a,$this)};
        sendque($fh,"250 OK\r\n");
        return;
      } elsif(lc $u eq lc "$EmailRedlistAdd\@") {
        $this->{reporttype}=4;
        $this->{getline}=\&ListReport;
        mlog($fh,"email redlist addition");
        $Stats{rcptReportRedlistAdd}++;
        foreach $a (split(/ /,$this->{rcpt})) {ListReportExec($a,$this)};
        sendque($fh,"250 OK\r\n");
        return;
      } elsif(lc $u eq lc "$EmailHelp\@") {
        $this->{reporttype}=7;
        $this->{getline}=\&ListReport;
        mlog($fh,"email help");
        $Stats{rcptReportHelp}++;
        sendque($fh,"250 OK\r\n");
        return; 
      } elsif(lc $u eq lc "$EmailRedlistRemove\@") {
        $this->{reporttype}=5;
        $this->{getline}=\&ListReport;
        mlog($fh,"email redlist deletion");
        $Stats{rcptReportRedlistRemove}++;
        foreach $a (split(/ /,$this->{rcpt})) {ListReportExec($a,$this)};
        sendque($fh,"250 OK\r\n");
        return;
      }
    }

    $this->{rcptValidated}=$this->{rcptNonexistent}=0;

	
    if ($this->{addressedToSpamBucket}) {

	# accept SpamBucket addresses in every case
      $this->{rcpt}.="$u$h ";
    } elsif ($LocalAddresses_Flat || $DoLDAP) {
      if (($this->{islocalmailaddress}) || ($this->{relayok}) && ! $rcptislocal) {
        if (serverIsSmtpDestination($server) && !Delayok($fh,"$u$h")) {
          $this->{delayed}=1;
          if (!$this->{isbounce}) {
            if ($DelayError) {
              $reply = $DelayError."\r\n";
            } else {
              $reply = "451 4.7.1 Please try again later\r\n";
            }
            sendque($fh, $reply);
            mlog($fh,"recipient delayed: $u$h") if $DelayLog;
            return;
          }
        }
        $this->{rcpt}.="$u$h ";
        mlog($fh,"recipient accepted: $u$h") if $ValidateUserLog==2;
        $this->{rcptValidated}=1;
        
     } elsif ($calist{$h}) {
     	my $uh=$calist{$h}."@".$h;
		mlog($fh,"invalid address $u$h replaced with $uh") if $ValidateUserLog==2;
		$this->{rcpt}.="$uh ";
		pbAdd($fh,$this->{ip},$irValencePB,"InvalidAddress") if $irValencePB>0;
		$Stats{rcptNonexistent}++;
		$this->{rcptValidated}=1;
		$l="RCPT TO:\<$uh\>\r\n";
		
	} else {
    mlog($fh,"invalid address rejected: $u$h") if $ValidateUserLog;
    pbAdd($fh,$this->{ip},$irValencePB,"InvalidAddress") if $irValencePB>0;
    $Stats{rcptNonexistent}++;
    $this->{rcptNonexistent}=1;



    if ($NoValidRecipient) {
     $reply = $NoValidRecipient."\r\n";
     $reply =~ s/EMAILADDRESS/$u$h/g;
    } else {
     $reply = "550 5.1.1 User unknown\r\n";
    }
    sendque($fh, $reply);
# increment error and drop line if necessary
        if($this->{serverErrors}++ > $MaxErrors) {
          $this->{prepend}="[MaxErrors]";
          mlog($fh,"max errors ($MaxErrors) exceeded -- dropping connection");
          pbAdd($fh,$this->{ip},$meValencePB,"MaxErrors",2) if $meValencePB>0;
          $Stats{msgMaxErrors}++;
          delayWhiteExpire($fh);
          done($fh);
        }
        return;
      }
    } elsif (serverIsSmtpDestination($server) && !Delayok($fh,"$u$h")) {
      $this->{delayed}=1;
      if (!$this->{isbounce}) {
        if ($DelayError) {
          $reply = $DelayError."\r\n";
        } else {
          $reply = "451 4.7.1 Please try again later\r\n";
        }
        sendque($fh, $reply);
        mlog($fh,"recipient delayed: $u$h") if $DelayLog;
        return;
      }
    } else {
      $this->{red}=1 if $Redlist{"$u$h"};
      $this->{rcpt}.="$u$h ";
      mlog($fh,"recipient accepted unchecked: $u$h") if $ValidateUserLog==2;
    }
# update Stats
    if ($this->{rcptnoprocessing}==1) {
      $Stats{rcptUnprocessed}++;
    } elsif ($this->{addressedToSpamBucket}) {
      $Stats{rcptSpamBucket}++;
    } elsif ($this->{allLoveSpam} & 1) {
      $Stats{rcptSpamLover}++;
    } elsif ($this->{rcptValidated}) {
      $Stats{rcptValidated}++;
    } elsif ($this->{rcptNonexistent}) {
      $Stats{rcptNonexistent}++;
    } elsif ($rcptislocal) {
      $Stats{rcptUnchecked}++;
    } elsif ($Whitelist{lc "$u$h"})
      {pbWhiteAdd($this->{ip},"whitelisted:$u$h");
      $Stats{rcptWhitelisted}++;
    } else {
      $Stats{rcptNotWhitelisted}++;
        }
    } ## end elsif ( $l =~ /rcpt to: *(.*)/i)
    elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        $this->{ skipbytes } = $1;
        d("XEXCH50 b=$1\n");
    }
    elsif ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
    if($1) {
      $this->{bdata}=$1;
    } else {
      delete $this->{bdata};
    }
    $this->{rcpt}=~s/\s$//;
# drop line if no recipients left
    if ($this->{rcpt}!~/@/) {
# possible workaround for GroupWise bug
      if ($this->{delayed}) {
        if ($DelayError) {
          $reply = $DelayError."\r\n";
        } else {
          $reply = "451 4.7.1 Please try again later\r\n";
        }
        sendque($fh, $reply);
        mlog($fh,"DATA phase delayed") if $DelayLog;
        $Stats{msgDelayed}++;
        return;
      }
      mlog($fh,"no recipients left -- dropping connection") if $DelayLog || $ValidateUserLog==2;
      $Stats{msgNoRcpt}++;

      delayWhiteExpire($fh);
      pbAdd($fh,$this->{ip},$erValencePB,"NeedRecipient",2) if $erValencePB>0;
      seterror($fh,"503 5.5.2 Need Recipient\r\n",1);
      return;
    }
    if (($noProcessing && allNoProcessing($this->{rcpt}) ) || ($noProcessing && $this->{mailfrom}=~$NPREL) ) {
# all addresses are on NoProcessing list
      $this->{noprocessing}=1;
      $this->{myheader}=''; # reset myheader
      if($BlockNPExes || ($ScanNP && $UseAvClamd) || $bombReNP || ($DoFakedNP && !$this->{forgedhelodone}) ) {
        $this->{getline}=\&whitebodyNoExe;
      } else {
        $this->{getline}=\&whitebody;
        $this->{prepend}="[NoProcessing]";
		mlog($fh,"message proxied without processing - (attachments unchecked)");
        $Stats{noprocessing}++;
      }

    } elsif ($this->{isbounce} && $this->{delayed}) {
      if ($DelayError) {
        $reply = $DelayError."\r\n";
      } else {
        $reply = "451 4.7.1 Please try again later\r\n";
      }
      sendque($fh, $reply);
      $this->{prepend}="";
      mlog($fh,"bounce delayed");
      $Stats{msgDelayed}++;
      return;
    } else {
      MaillogStart($fh); # notify the stream logging to start logging
      $this->{getline}=\&getheader;
    }
  } elsif( $l=~/^ *RSET/i ) {
    stateReset($fh); # reset everything
  }
  sendque($server, $l);
}



# compile the helo-blacklist ignore regular expression
sub setHBIRE {
  SetRE('HBIRE',"^($_[0])\$","i","HELO Blacklisted Ignore");
}

# get the header part of the DATA.
sub getheader {
  my($fh,$l)=@_;
  d(18);
  my $this=$Con{$fh};
  if($this->{inerror}) {
    my $server=$this->{friend};
    $this->{getline}=\&getline;
    sendque($server, $l);
    return;
  }
  
  $this->{header}.=$l;
   my $headerlength=length($this->{header});
   if (!$this->{relayok} || $HeaderMaxLocal && $this->{relayok}) {
   if( $HeaderMaxLength && $headerlength>$HeaderMaxLength) {
   	
    delayWhiteExpire($fh);
    mlog($fh,"Possible Mailloop: Headerlength ($headerlength) > $HeaderMaxLength");
    seterror($fh,"554 5.7.1 possible mailloop - oversized header ($headerlength)",1);
    done($fh);
    return;
    }}

 
  if($l=~/^\.?[\r\n]*$/) {
    $this->{maillength}=length($this->{header});
    $this->{noprocessing}=1 if $this->{ismaxsize};     
    my $slok;
    RWLok($fh,$this->{ip});
# header is done
	
    my($sub)=$this->{header}=~/Subject: (.*)/;
    $sub=decodeMimeWords($sub);
    
    $sub=~y/a-zA-Z0-9/_/cs;
    $sub=substr($sub,0,50);
    $this->{subject}=$sub;
    $this->{subject2}=$sub;

    $this->{subject} ="" if !$subjectLogging;
    if (!$this->{whitelisted} && $whiteRe && $whiteReRE!="" && $this->{header}=~('('.$whiteReRE.')')) {
      mlogRe($1,"White");
      $this->{whitelisted}=1;
    }
      if(!$this->{spamlover} && $slRe && $slReRE!="" && $this->{header}=~('('.$slReRE.')'))
	  {
      mlogRe($1,"Spamlover");

      $this->{spamlover}=1;     

	  }
	if (!$this->{red} && $redRe &&  $redReRE!="" && $this->{header}=~('('.$redReRE.')')) {
  		mlogRe($1,"Red");
  		$this->{red}=1;
  	}
    if(!$this->{noprocessing} && $npRe && $npReRE!="" && $this->{header}=~('('.$npReRE.')'))
	  {
      mlogRe($1,"Noprocessing");
      pbBlackClear($fh,$this->{ip});
      $this->{noprocessing}=1;     
      $this->{myheader}=''; # reset myheader
	  }

if(!$this->{noprocessing} && !$this->{whitelisted} && $WhitelistOnly) {

      $Stats{bspams}++;
      delayWhiteExpire($fh);
      my $slok=$this->{allLoveSpam}==1;
      $this->{prepend}="[WhitelistOnly]";

      thisIsSpam($fh,"Whitelist Only",$baysSpamLog,$SpamError,$baysTestMode,$slok,1);

      return;
    }
	  
   if(!BombHeaderOK($fh,$this->{header})) {
      $bomblt = $bombError;
      
      $bomblt .= " ( reason: '$this->{messagereason}' ) " if $bombErrorReason;
      $Stats{bombs}++;
      delayWhiteExpire($fh);
      my $slok=$this->{allLoveBoSpam}==1;
      $this->{prepend}="[BombHeader]";

      thisIsSpam($fh,"BombHeaderRe:'$this->{messagereason}'",$spamBombLog,$bomblt,$bombTestMode,$slok,1);

     
    }

    
    if($contentOnlyRe && $contentOnlyReRE!="" && $this->{header}=~('('.$contentOnlyReRE.')')) {
		mlogRe($1,"Contentonly");
      $this->{contentonly}=1;
    }
    

    
   
    if ($this->{noprocessing}){
      
      if ($SPFNP && !SPFok($fh)) {
      return;
      }
       $this->{attachcomment}="(attachments unchecked)";
      if($BlockNPExes || ($ScanNP && $UseAvClamd) || $bombReNP || ($DoFakedNP && !$this->{forgedhelodone})) {
        $this->{getline}=\&whitebodyNoExe;
      } else {
        $this->{prepend}="[Noprocessing]";
        mlog($fh,"message proxied without processing - $this->{attachcomment}") ;
        $Stats{noprocessing}++;
        
      	
        isnotspam($fh);
      }
    } elsif(onwhitelist($fh,$this->{header})) {

      if ((!$SPFWL || ($SPFWL && SPFok($fh))) && (!$RBLWL || ($RBLWL && RBLok($fh)))) {
      	if ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;}
        if($BlockWLExes ||  (($ScanWL || $ScanLocal) && $UseAvClamd) || $bombReWL  || $bombReLocal || ($DoFakedWL && !$this->{forgedhelodone}) ) {
          $this->{getline}=\&whitebodyNoExe;
        } else {
        
          my $fn=Maillog($fh,'',$NonSpamLog); # tell maillog this isn't spam
          $fn='-> '.$fn if !$fn=="";
          $fn="" if !$fileLogging;
          $this->{subject} ="" if !$subjectLogging;
          $SpamProb=0; addSpamProb($fh,1);
          $this->{prepend}="[Local/White]";

          isnotspam($fh);
          mlog($fh,"local or whitelisted - $this->{attachcomment} $this->{subject} $fn");
        }
      }
    } elsif($this->{addressedToSpamBucket}) {
      $Stats{spambucket}++ ;
      pbAdd($fh,$this->{ip},$saValencePB,"SpamCollectAddress",2) if $saValencePB>0;
      $this->{prepend}="[Collect]"; 
      thisIsSpam($fh,'Collect Address',$spamBucketLog,"250 OK",$sbTestMode,0,0);
    } elsif($blackListedDomains && ($this->{mailfrom}=~$BLDRE1 || $this->{senders}=~$BLDRE2)) {
      my $slok=$this->{allLoveBlSpam}==1;
      $Stats{blacklisted}++ unless $slok;
      pbAdd($fh,$this->{ip},$blValencePB,"BlacklistedDomain") if $blValencePB>0;
      $this->{prepend}="[BlackDomain]"; 
      thisIsSpam($fh,'BlackDomain',$blDomainLog,$SpamError,$blTestMode,$slok,0);

	} elsif(!ForgedHeloOK($fh)) {      
      $this->{prepend}="[ForgedHELO]"; 
      thisIsSpam($fh,"ForgedHELO:'$this->{helo}'",$forgedHeloLog,$SpamError,$fhTestMode,0,0);

    } elsif (!LocalSenderOK($fh,$this->{ip})) {
      my $slok=$this->{allLoveISSpam}==1;
      $Stats{senderInvalidLocals}++ unless $slok;
      $reply=$SenderInvalidError;
	  $reply =~ s/REASON/Unknown User In Local Domain(Sender)/g;
      $this->{prepend}="[UnknownLocal]";  
	  thisIsSpam($fh,"Unknown User",$spamISLog,$reply,$flsTestMode,$slok,$done);
	} elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;
    } elsif (!validHeloOK($fh,$this->{helo})) {
      my $slok=$this->{allLoveHlSpam}==1;
      $Stats{invalidHelo}++ unless $slok;
      $reply=$SenderInvalidError;
      
      $this->{prepend}="[NotValidHELO]";
      $reply =~ s/REASON/Invalid HELO Format/g; 
      thisIsSpam($fh,"Not Valid HELO: '$this->{helo}'",$spamHeloLog,$reply,$ihTestMode,$slok,0);
    } elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;
    } elsif (!invalidHeloOK($fh,$this->{helo})) {
      my $slok=$this->{allLoveHlSpam}==1;
      $Stats{invalidHelo}++ unless $slok;
      $reply=$SenderInvalidError;
      
      $this->{prepend}="[InvalidHELO]";
      $reply =~ s/REASON/Invalid HELO Format/g; 
      thisIsSpam($fh,"Invalid HELO: '$this->{helo}'",$spamHeloLog,$reply,$ihTestMode,$slok,0);
    } elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;
     } elsif (!MXAOK($fh)) {
      my $slok=$this->{allLoveMXASpam}==1;
      $Stats{mxaMissing}++ unless $slok;
      $reply=$SenderInvalidError;
      
      $this->{prepend}="[MX/A]";
      $reply =~ s/REASON/Missing MX and A record/g;
      thisIsSpam($fh,"missing MX/A",$spamMXALog,$reply,$mxaTestMode,$slok,0);
    } elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
    } elsif (!PTROK($fh)) {
      $reply=$SenderInvalidError;
      my $slok=$this->{allLovePTRSpam}==1;
      
      $this->{prepend}="[PTR]";
      $reply =~ s/REASON/$this->{messagereason}/g;
      thisIsSpam($fh,"Validate Sender: $this->{messagereason}",$spamPTRLog,$reply,$ptrTestMode,$slok,0);
	} elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;
    } elsif(!BlackHeloOK($fh,$this->{helo})) {
      my $slok=$this->{allLoveHlSpam}==1;

      $Stats{helolisted}++ unless $slok;
      $this->{prepend}="[BlackHELO]";
      thisIsSpam($fh,"HELO-Blacklist: '$this->{helo}'",$spamHeloLog,$SpamError,$hlTestMode,$slok,0);
	} elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;
    } elsif($this->{invalidSRSBounce} && $SRSValidateBounce && !($ispip && $this->{ip}=~$ISPRE) && !($noSRS && $this->{ip}=~$NSRSRE)) {
      my $slok=$this->{allLoveSRSSpam}==1;
      $Stats{msgNoSRSBounce}++ unless $slok;
      $this->{prepend}="[SRS]";
      thisIsSpam($fh,'bounce address not SRS signed',$SRSFailLog,'554 5.7.5 Bounce address not SRS signed',$srsTestMode,$slok,0);

    } elsif(SPFok($fh) && RBLok($fh)) {
    if ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh,$done);
	return;}
# cleared all the above rules - off to Bayesian testing if SPF and DNSBL is OK.
# and no testcheck was successful.

      $this->{getline}=\&getbody;
    }
  }
}


# do SPF (sender policy framework) checks
sub SPFok {
  my($fh)=@_;
  my $this=$Con{$fh};
  d('SPFok');
  my $tlit;
  $this->{prepend}="";
  my ($per_result, $smtp_comment, $header_comment, $spf_fail,$received_spf);


return 1 if $this->{addressedToSpamBucket};
return 1 if	$this->{relayok};
return 1 if	!$CanUseSPF; 
return 1 if ($this->{mISPRE}==1);
return 1 if $this->{contentonly}==1;
return 1 if $ValidateSPF==0;
return 1 if $this->{whitelisted}==1 && !$SPFWL;
return 1 if $this->{noprocessing}==1 && !$SPFNP;

$per_result=SPFCacheFind($this->{ip});
   
return 1 if $per_result eq "pass";
   
if ($noSPFRe && $this->{mailfrom}=~('('.$noSPFReRE.')')) {
        mlogRe( $1, "noSPF", "Regex:" );
      return 1;
      }
if ($strictSPFReRE && $this->{mailfrom}=~('('.$strictSPFReRE.')')) {
        mlogRe( $1, "SPFstrict", "Regex:" );
      $this->{spfstrict}=1;
      }
  my $slok=$this->{allLoveSPFSpam}==1;
  my $mValidateSPF=$ValidateSPF;
  $mValidateSPF=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mValidateSPF=3 if $testScoringMode && $DoPenaltyMessage && $spfTestMode;

  $tlit="monitoring" if $mValidateSPF==2;
  $tlit="scoring" if $mValidateSPF==3;
  $this->{prepend}="[SPF]";
  $this->{prepend}.="[$tlit]" if $mValidateSPF>=2;
  

  if ($per_result) {
      	$spf_cache="1";
      	
      	$received_spf = "Received-SPF(cache): $per_result";
  }
  if (!$per_result) {
  my $query = eval {new Mail::SPF::Query (ipv4       => $this->{ip},
                                   sender     => $this->{mailfrom},
                                   helo       => $this->{helo},
                                   trusted    => 1,
                                   guess      => $LocalPolicySPF,
                                   myhostname => $myName,
                                   sanitize   => 1,

                                   debug      => $DebugSPF,
                                   debuglog   => sub { mlog($fh,"debug: @_")
  } );};

# add exception check and log
  if ($@) {
	return 1;
  }

  foreach my $recip (split(' ', $this->{rcpt})) {
    ($per_result, $smtp_comment, $header_comment, $spf_fail) = 
                                                  $query->result2($recip);
# Keep processing SPF records until all recipients are checked 
# otherwise breakout if fail
    if ($per_result eq 'fail' || $per_result eq 'softfail' && $SPFsoftfail || ($per_result eq 'softfail' && $this->{spfstrict} ) || ($per_result eq 'neutral' && $this->{spfstrict}) || $per_result eq 'neutral' && $SPFneutral || $per_result eq 'permerror' && $SPFperm || $per_result eq 'error' && $SPFperm || $per_result eq 'temperror' && $SPFtemp) {
      $spf_fail="true";
      last;
    }
  }
  
  $received_spf = "Received-SPF: $per_result - client-ip=$this->{ip};";
  $received_spf .= " envelope-from=$this->{mailfrom};" if ( defined($this->{mailfrom} ) );
  $received_spf .= " helo=$this->{helo};" if ( defined( $this->{helo}) );
  
  SPFCacheAdd($this->{ip},$per_result);
  } else {
  if ($per_result eq 'fail' || $per_result eq 'softfail' && $SPFsoftfail || ($per_result eq 'softfail' && $this->{spfstrict} ) || ($per_result eq 'neutral' && $this->{spfstrict}) || $per_result eq 'neutral' && $SPFneutral || $per_result eq 'permerror' && $SPFperm || $per_result eq 'error' && $SPFperm || $per_result eq 'temperror' && $SPFtemp) {
      $spf_fail="true";
      }
  }  
  
  mlog($fh,$received_spf) if $SPFLog;
  
  return 1 if $mValidateSPF==2;
  # add to our header; merge later, when client sent own headers
  $this->{myheader}.="X-Assp-$received_spf\r\n" if $AddSPFHeader;
  my $reply=$SPFError;
 
  if ($per_result eq 'neutral') {  
  pbAdd($fh,$this->{ip},$spfnValencePB,"SPFneutral") if $spfnValencePB>0;}
  elsif ($per_result eq 'softfail') {  
  pbAdd($fh,$this->{ip},$spfsValencePB,"SPFsoftfail") if $spfsValencePB>0;}
  elsif ($spf_fail eq 'true') {
  pbAdd($fh,$this->{ip},$spfValencePB,"SPF$per_result") if $spfValencePB>0;}
 
  return 1 if $mValidateSPF==3;

  if ($spf_fail eq 'true') {
    # This email fails SPF rules for the sending domain. Apply SPF failure rules
    if ($SPFNP && $this->{noprocessing}==1) {
      pbWhiteDelete($this->{ip});
    }
    
    $reply =~ s/SPFRESULT/$smtp_comment/g;

    $Stats{spffails}++ unless $slok;
    $this->{prepend}="[SPF]";
    thisIsSpam($fh,"SPF: $per_result ",$SPFFailLog,$reply,$spfTestMode,$slok,0);
    return 0;
  } else {
  
  $this->{prepend}="";
    return 1;
  }
}

# do RWL checks
sub RWLok {
    my ( $fh, $ip ) = @_;
    my $this = $Con{ $fh };

    return 1 if $this->{ contentonly } == 1;
    return 1 if ( $this->{ relayok } );
    return 1 if ( $this->{ whitelisted } );
    return 1 if ( $this->{ mISPRE } == 1 );
    return 1 if !( $CanUseRWL && $ValidateRWL );
    return 1 if RWLCacheFind($ip) == 2;

    return 1 if ( $this->{ noprocessing } == 1 );
    return 1 if ( pbWhiteFind($ip) );

    my ( $rwls_returned, @listed_by, $skip, $rwl, $received_rwl, $time, $err );



    ( $rwls_returned, @listed_by ) = ();
    if ( @{ $this->{ RWLcache } } ) {
        ( $rwls_returned, @listed_by ) = @{ $this->{ RWLcache } };
    }
    else {
        ($skip) = ();

        if ( !( $CanUseRWL && $ValidateRWL ) || $this->{ relayok } || $this->{ mISPRE } ) {
            $skip = 1;
        }
        unless ($skip) {

            $rwl = RBL->new(
                lists       => [@rwllist],
                server      => $nameservers[0],
                max_hits    => $RWLminhits,
                max_replies => $RWLmaxreplies,
                query_txt   => 0,
                max_time    => $RWLmaxtime,
                timeout     => $RBLsocktime
            );
            ($received_rwl) = ();

            $lookup_return = $rwl->lookup($ip,"RWL");

            @listed_by     = $rwl->listed_by();
            $rwls_returned = $#listed_by + 1;
            if ( $rwls_returned >= $RWLminhits ) {
                $received_rwl = "Received-RWL: whitelisted ($myName: local policy) rwl=@listed_by; client-ip=$ip";
                $this->{ rwlok } = 1;
                RWLCacheAdd( $ip, 1 );
                pbWhiteAdd( $ip, "RWL" );
            }
            elsif ( $rwls_returned > 0 ) {
                $received_rwl = "Received-RWL: listed  rwl=@listed_by; client-ip=$ip";
                RWLCacheAdd( $ip, 2 );
            }
            else {
                $received_rwl = "Received-RWL: not listed  rwl=none; client-ip=$ip";
                RWLCacheAdd( $ip, 2 );
            }
            if ($RWLLog) { mlog( $fh, $received_rwl ); }

            $this->{ myheader } .= "X-Assp-$received_rwl\015\012" if $AddRWLHeader;
        } ## end unless ($skip)
        @{ $this->{ RWLcache } } = ( $rwls_returned, @listed_by );
    } ## end else [ if ( @{ $this->{ RWLcache...
    return;
} ## end sub RWLok

# do RBL checks

sub RBLok {
  my($fh)=@_;
  my $this=$Con{$fh};
  d('RBLok');
  
  return 1 if $ValidateRBL==0;
  return 1 unless (!$this->{relayok} && $CanUseRBL  && !($ispip && $this->{ip}=~$ISPRE));
  return 1 if ($noDelay && $ip=~$NDRE);
  return 1 if ($noRBL && $ip=~$NRBLRE);
  return 1 if $this->{contentonly}==1;
  return 1 if $this->{whitelisted}==1 && !$RBLWL;
  my $slok=$this->{allLoveRBLSpam}==1;
  my $mValidateRBL=$ValidateRBL;
  $this->{testmode} = $rblTestMode;
  $this->{testmode} = $slok = 0  if allRBLSpamHaters($this->{rcpt});
  $mValidateRBL=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mValidateRBL=3 if $testScoringMode && $DoPenaltyMessage && $rblTestMode;

    my $tlit;
    $tlit = ""   if $mValidateRBL == 1;
    $tlit = " monitoring " if $mValidateRBL == 2;
    $tlit = " scoring "    if $mValidateRBL == 3;
    $this->{ prepend } = "[DNSBL]";
    $this->{ prepend } .= "[monitoring]" if $mValidateRBL == 2;
    $this->{ prepend } .= "[scoring]"    if $mValidateRBL == 3;

    my $ip = $this->{ ip };
    my @listed_by;

    if ( $RBLFailLog != 6 ) {
        if ( !RBLCacheOK( $fh, $this->{ ip } ) ) {

            @listed_by = $this->{ mypbreason };
            my $reply = $RBLError;
            $reply =~ s/RBLLISTED/@listed_by/g;
            thisIsSpam( $fh, "failed DNSBLcache: @listed_by", $RBLFailLog, "$reply", $rblTestMode, $slok, 1 );
            return 0;

        }
        else {
            return 1 if $this->{ rblcachefound } == 1;
        }

    }
    my $rbl = eval {
        RBL->new(
            lists       => [@rbllist],
            server      => $nameservers[0],
            max_hits    => $RBLmaxhits,
            max_replies => $RBLmaxreplies,
            query_txt   => 0,
            max_time    => $RBLmaxtime,
            timeout     => $RBLsocktime
        );
    };

    # add exception check
    if ($@) { return 1; }
  my ($received_rbl,$rbl_result,$lookup_return);
  $lookup_return = $rbl->lookup($ip,"DNSBL");
  @listed_by  = $rbl->listed_by();
  $rbls_returned = $#listed_by + 1;
  if ($rbls_returned>0) {
   if ($rbls_returned>=$RBLmaxhits) {
   	pbWhiteDelete($this->{ip});
  	pbAdd($fh,$this->{ip},$rblValencePB,"DNSBL-failed",$ValidateRBL) if $rblValencePB>0;
  	$this->{prepend}="[DNSBL]";
     $received_rbl="Received-DNSBL: fail (";
   } else {
   	pbWhiteDelete($this->{ip});
  	pbAdd($fh,$this->{ip},$rblnValencePB,"DNSBLneutral",$ValidateRBL) if $rblnValencePB>0;
	$this->{prepend}="[DNSBL][neutral]";
    $received_rbl="Received-DNSBL: neutral (";
   }
   foreach (@listed_by) {
    $received_rbl.="$_->". $rbl->{results}->{$_} ."; ";
   }
   $received_rbl.=")";
  } else {
   $received_rbl="Received-DNSBL: pass";
   
  }
  $this->{prepend}="[DNSBL][scoring]" if $mValidateRBL==3;
  if ($tlit) { $tlit .= " "; }
  mlog($fh,"$tlit$received_rbl") if ($RBLLog);
  return 1 if $mValidateRBL==2;

  
  # add to our header; merge later, when client sent own headers
  $this->{myheader}.="X-Assp-$received_rbl\r\n" if $AddRBLHeader && $received_rbl ne "Received-DNSBL: pass";
  
  if ($rbls_returned >= $RBLmaxhits ) {
  
   $Stats{rblfails}++;

   if ($RBLCacheInterval>0) {
    RBLCacheAdd($this->{ip},"@listed_by","1") ;
   } 
   
   return 1 if $mValidateRBL==3;
   my $reply=$RBLError;
   
   $reply =~ s/RBLLISTED/@listed_by/g;
   $this->{prepend}="[DNSBL]";
   
   thisIsSpam($fh,"failed DNSBL: @listed_by",$RBLFailLog,"$reply",$rblTestMode,$slok,0);
   return 0;
  }
  return 1;
}

# do URIBL checks
sub URIBLok {
    my ( $fh, $b, $thisip ) = @_;
    my $this = $Con{$fh};
    d('URIBLok');
    
    $this->{prepend} = "";
    my $slok = $this->{allLoveURIBLSpam} == 1;
    my ( %domains, $ucnt, $uri, $mycache, $orig_uri, $i, $ip, $uribl, $received_uribl, $uribl_result );
    my ( $lookup_return, @listed_by, $listed_domain, $uribls_returned, $lcnt, $err );

    return 1 if !$ValidateURIBL;
    return 1 if $this->{whitelisted} == 1 && !$URIBLWL;
    return 1 if $this->{relayok} && !$URIBLLocal;
    return 1 if $this->{noprocessing} == 1 && !$URIBLNP;
    return 1 if $ispip && $this->{ip} =~ $ISPRE && !$URIBLISP;
    return 1 unless $CanUseURIBL && $ValidateURIBL;
    my $mValidateURIBL = $ValidateURIBL;
    $mValidateURIBL = 3 if $slScoringMode && $DoPenaltyMessage && ( $slok || $this->{spamlover} );
    $mValidateURIBL = 3 if $testScoringMode && $DoPenaltyMessage && $uriblTestMode;

    my $tlit;
    $tlit = ""  if $mValidateURIBL == 1;
    $tlit = "monitoring " if $mValidateURIBL == 2;
    $tlit = "scoring "    if $mValidateURIBL == 3;
    $this->{prepend} = "[URIBL]";
    $this->{prepend} .= "[monitoring]" if $mValidateURIBL == 3;
    $this->{prepend} .= "[scoring]"    if $mValidateURIBL == 3;
    if ( $noURIBL && $this->{mailfrom} =~ $NURIBLRE ) {
        mlog( $fh, "URIBL lookup skipped (noURIBL sender)", 1 );
        $this->{myheader} .= "X-Assp-Received-URIBL: lookup skipped (noURIBL sender)\r\n" if $AddURIBLHeader;
        return 1;
    }

    while ( $b =~ /(?:ht|f)tps?[\041-\176]{0,3}\:\/{1,3}($URIRe)|((?:www|ftp)(?:[\=\%]2e|\&\#0?46\;?|\.)$URIRe)/gio ) {
        $uri = $1 || $2;

        # RFC 2821, section 4.5.2, 'Transparency': delete leading '.' character
        $uri =~ s/$URIContinuationRe\.?//go;           # and strip line continuations
        $uri =~ s/\=([a-f0-9]{2})/chr(hex($1))/gie;    # decode quoted-printables
        $uri =~ s/\%40|\&\#0?64\;?/@/g;                # decode '@' character
        if ( $uri =~ /(?:[^\s\/\@]+\@)?($URIHostRe)/io ) {
            $uri = $1;

            # fix HTML
            $uri =~ s/[\=\%]2[ef]|\&\#0?4[67]\;?/./gi;                # decode '.,' characters
            $uri =~ s/\&(?:nbsp|amp|quot|gt|lt|\#0?1[03])\;?.*$//i;
            $uri =~ s/(?:$URISubDelimsCharRe|\.)+$//o;

            $orig_uri = $uri;
            $uri =~ s/\%([a-f0-9]{2})/chr(hex($1))/gie;               # decode percents
            $uri =~ s/\&\#(\d{1,3})\;?/chr($1)/ge;                    # decode &#ddd's
                                                                      # strip redundant dots
            $uri =~ s/\.{2,}/\./g;
            $uri =~ s/^\.//;
            $uri =~ s/$URISubDelimsCharRe//go;                        # more tricks?

            if ( $uri =~ /^$IPQuadRE$/io ) {
                $i = $ip = undef;
                while ( $i < 10 ) { $ip = ( $ip << 8 ) + oct( ${ ++$i } ) + hex( ${ ++$i } ) + ${ ++$i }; }
                $uri = inet_ntoa( pack( 'N', $ip ) );
                if ( $URIBLNoObfuscated && $orig_uri !~ /^\Q$uri\E/i ) {
                    $this->{myheader}
                        .= "X-Assp-Received-URIBL: fail ($myName: local policy) contains obfuscated ip\r\n"
                        if $AddURIBLHeader;
                    mlog( $fh, "$tlit obfuscated ip: " . substr( $orig_uri, 0, 32 ), 1 )
                        if $URIBLLog && ( $mValidateURIBL == 2 || $mValidateURIBL == 3 );
                    $this->{prepend} = "[URI:obfuscated]";

                    pbAdd( $fh, $thisip, $uriobfValencePB, "URIBLobfuscated", 1 )
                        if $uriobfValencePB > 0 && ( $mValidateURIBL == 1 || $mValidateURIBL == 3 );
                    if ( $mValidateURIBL == 1 ) {
                        $this->{prepend} = "[URI:obfuscated]";

                        thisIsSpam( $fh, 'failed URIBL checks  (obfuscated ip: ' . substr( $orig_uri, 0, 32 ) . ')',
                            $URIBLFailLog, $URIBLPolicyError, $uriblTestMode, $slok, 1, $b );
                        return 0;
                    }
                }
            } else {
                if ( $URIBLNoObfuscated && $orig_uri !~ /^\Q$uri\E/i ) {
                    $this->{myheader}
                        .= "X-Assp-Received-URIBL: fail ($myName: local policy) contains obfuscated uri\r\n"
                        if $AddURIBLHeader;
                    mlog( $fh, "$tlit obfuscated uri: " . substr( $orig_uri, 0, 32 ), 1 )
                        if $URIBLLog && ( $mValidateURIBL == 2 || $mValidateURIBL == 3 );
                    $this->{prepend} = "[URI:obfuscated]";

                    pbAdd( $fh, $thisip, $uriobfValencePB, "URIBLobfuscated", 1 )
                        if $uriobfValencePB > 0 && ( $mValidateURIBL == 1 || $mValidateURIBL == 3 );
                    if ( $ValidateURIBL == 1 ) {
                        $this->{prepend} = "[URIBL-obfuscated]";

                        thisIsSpam( $fh, 'failed URIBL checks  (obfuscated uri: ' . substr( $orig_uri, 0, 32 ) . ')',
                            $URIBLFailLog, $URIBLPolicyError, $uriblTestMode, $slok, 0, $b );
                        return 0;
                    }
                }
                if ( $uri =~ $URIBLCCTLDSRE || $uri =~ /([^\.]+\.[^\.]+)$/ ) {
                    $uri = $1;
                } else {
                    next;
                }
            }
            next if $uri =~ $URIBLWLDRE;
            my $tlitmax = "";

            my $mValidateMaxURI = $ValidateMaxURI;
            $mValidateMaxURI = 3 if $slScoringMode && $DoPenaltyMessage && ( $slok || $this->{spamlover} );
            $mValidateMaxURI = 3 if $testScoringMode && $DoPenaltyMessage && $uriblTestMode;
            $tlitmax = "URIBL"      if $ValidateMaxURI == 1;
            $tlitmax = "monitoring" if $mValidateMaxURI == 2;
            $tlitmax = "scoring"    if $mValidateMaxURI == 3;
            $this->{prepend} = "[URI:max-uris]";
            if ( $URIBLmaxuris && ++$ucnt > $URIBLmaxuris ) {
                $this->{myheader} .= "X-Assp-Received-URIBL: fail ($myName: local policy) maximum uris exceeded\r\n"
                    if $AddURIBLHeader;
                mlog( $fh, "$tlitmax maximum uris exceeded", 1 )
                    if $URIBLLog && ( $mValidateMaxURI == 2 || $mValidateMaxURI == 3 );
                pbAdd( $fh, $thisip, $urimaxValencePB, "URIBL-maximum-uris", 1 )
                    if $urimaxValencePB > 0 && ( $mValidateMaxURI == 1 || $mValidateMaxURI == 3 );
                if ( $mValidateMaxURI == 1 ) {
                    $this->{prepend} = "[URIBL:max-uris]";

                    thisIsSpam( $fh, "failed URIBL checks (maximum uris exceeded) count:$ucnt",
                        $URIBLFailLog, $URIBLPolicyError, $uriblTestMode, $slok, 0 );
                    return 0;
                }
                last;
            }

            if ( !$domains{ lc $uri }++ ) {
                if ( $URIBLmaxdomains && keys(%domains) > $URIBLmaxdomains ) {
                my $uniquedomains = keys(%domains);
                    $this->{myheader}
                        .= "X-Assp-Received-URIBL: fail ($myName: local policy) maximum unique domain uris exceeded \r\n"
                        if $AddURIBLHeader;
                    mlog( $fh, "$tlitmax maximum unique uri domains exceeded", 1 )
                        if $URIBLLog && ( $mValidateMaxURI == 2 || $mValidateMaxURI == 3 );
                    pbAdd( $fh, $thisip, $urimaxValencePB, "URIBLmaxiunique", 1 )
                        if $urimaxValencePB > 0 && ( $mValidateMaxURI == 1 || $mValidateMaxURI == 3 );
                    $this->{prepend} = "[URI:max-domains]";
                    if ( $mValidateMaxURI == 1 ) {
                        $this->{prepend} = "[URIBL:max-domains]";

                        thisIsSpam( $fh, "failed URIBL checks (maximum unique uri domains exceeded) count:$uniquedomains",
                            $URIBLFailLog, $URIBLPolicyError, $uriblTestMode, $slok, 0, $b )
                            if $mValidateMaxURI == 1;
                        return 0;
                    }
                    last;
                }
            }
        }
    }
    my $urinew = eval {
        RBL->new(
            lists       => [@uribllist],
            server      => $nameservers[0],
            max_hits    => $URIBLmaxhits,
            max_replies => $URIBLmaxreplies,
            query_txt   => 0,
            max_time    => $URIBLmaxtime,
            timeout     => $URIBLsocktime
        );
    };

    # add exception check
    if ($@) { return 1; }
  $received_uribl=$uribl_result=$lookup_return=@listed_by=$listed_domain=$uribls_returned=undef;
%uriblsavedomains=%domains;
  for $domain (keys %domains) {
  next if !$domain;
  $mycache=0;
  next if (URIBLCacheFind($domain)==2);

	if (URIBLCacheFind($domain)==1) {
	$uribls_returned=$URIBLmaxhits;
	$listed_domain=$domain;
	
	$mycache=1;
	
	last;
	} else {

		$lookup_return=$urinew->lookup($domain,"URIBL");
		@listed_by       = $urinew->listed_by();
   $lcnt=$#listed_by+1;
   $uribls_returned=$lcnt if $lcnt>$uribls_returned;
   
    URIBLCacheAdd($domain,"2") if $lcnt==0;

   }
   if ($uribls_returned>=$URIBLmaxhits) {

    URIBLCacheAdd($domain,"1") ;

    $listed_domain=$domain;
    last;
   }
  }

    if ($mycache) {
        mlog( $fh, $tlit."Received-URIBL: fail (Cache, $listed_domain)",1 ) if $URIBLLog;
    return 1 if $mValidateURIBL==2;
    $received_uribl="Received-URIBL: fail ($listed_domain)";

 
   } else { 
  if ($uribls_returned>0) {
   if ($uribls_returned>=$URIBLmaxhits) {
   	 
     $received_uribl="Received-URIBL: fail (";
     
   } else {
   $this->{prepend}="[URIBL][neutral]" if $ValidateURIBL!=3;
   mlog($fh,"$tlit neutral ($listed_domain)") if ($URIBLLog && $ValidateURIBL==2);
   $this->{prepend}="[URIBL][monitoring]" if $mValidateURIBL==2;
   return 1 if $ValidateURIBL==2;
   	 pbAdd($fh,$thisip,$uriblnValencePB,"URIBLneutral") if $uriblnValencePB>0;
   	 return 1 if $ValidateURIBL==3;
     $received_uribl="Received-URIBL: neutral (";
     
   }
   foreach (@listed_by) {
 
                $received_uribl .= "$_->" . $urinew->{results}->{$_} . "; ";
   }
   $received_uribl.=")";
  } else {
   $received_uribl="Received-URIBL: pass";



  }
  $this->{prepend}="[URIBL][scoring]" if $mValidateURIBL==3;
  if ($tlit) { $tlit .= " "; }
  mlog($fh,"$tlit$received_uribl",1) if $URIBLLog;
  }
  return 1 if $mValidateURIBL==2;
  
  
  $this->{myheader}.="X-Assp-$received_uribl\r\n" if $AddURIBLHeader && $received_uribl ne "Received-URIBL: pass";
  if ($uribls_returned>=$URIBLmaxhits) {
  pbAdd($fh,$thisip,$uriblValencePB,"URIBLfailed") if $uriblValencePB>0;
  return 1 if $mValidateURIBL==3;
   $err=$URIBLError;
   $err=~s/URIBLNAME/@listed_by/g;
   $this->{prepend}="[URIBL]";
  	thisIsSpam($fh,'failed URIBL',$URIBLFailLog,$err,$uriblTestMode,$slok,1,$b);
        return 0;
  }
  return 1;
}
sub ipNetwork {
  my ($ip,$cidr)=@_;
  my $u32 = unpack "N", pack "CCCC", split /\./, $ip;
  my $mask = unpack "N", pack "B*", "1" x $cidr . "0" x (32 - $cidr );
  return join ".", unpack "CCCC", pack "N", $u32 & $mask;
}

sub ipBroadcast {
  my ($ip,$cidr)=@_;
  my $u32 = unpack "N", pack "CCCC", split /\./, $ip;
  my $mask = unpack "N", pack "B*", "1" x $cidr . "0" x (32 - $cidr );
  return join ".", unpack "CCCC", pack "N", $u32 | ~$mask;
}

sub formatTimeInterval {
  my $interval=shift;
  my $res;
  $res.=$_."d " if local $_=int($interval/(24*3600)); $interval%=(24*3600);
  $res.=$_."h " if $_=int($interval/3600); $interval%=3600;
  $res.=$_."m " if $_=int($interval/60); $interval%=60;
  $res.=$interval."s " if ($interval || !defined $res);
  $res=~s/\s$//;
  return $res;
}

# do forged local sender 
sub ForgedHeloOK {
  my($fh,$rcpt)=@_;
  my $this=$Con{$fh};
  d('ForgedHeloOK');
  return 1 if $this->{forgedhelodone};
  $this->{forgedhelodone}=1;
  
  return 1 if (!$DoFakedLocalHelo);
  return 1 if ($this->{relayok});
  return 1 if ($this->{mISPRE}==1);
  return 1 if ($heloBlacklistIgnore && $this->{helo} =~ $HBIRE);  
  return 1 if ($Whitelist{$this->{mailfrom}} && $DoFakedWL);
  return 1 if ($noProcessing && $this->{mailfrom}=~$NPREL && $DoFakedNP);

  my $tlit;
  $tlit="monitoring" if $DoFakedLocalHelo==2;
  $tlit="scoring" if $DoFakedLocalHelo==3;
  $this->{prepend}="[ForgedHelo]" ;
  $this->{prepend}.="[$tlit]" if $DoFakedLocalHelo>=2;

  if (($localDomains && $this->{helo} =~$LDRE) ||  $this->{helo} eq "friend" ||  $this->{helo} eq "localhost" || ($localhostname && $this->{helo} eq $localhostname )  || ($myServerRe && $this->{helo} =~$LHNRE)) {
 
	mlog($fh,"$tlit Forged HELO: '$this->{helo}'") if $ValidateSenderLog;
    delayWhiteExpire($fh);
    return 1 if  $DoFakedLocalHelo==2;	
    pbWhiteDelete($this->{ip});
    pbAdd($fh,$this->{ip},$fhValencePB,"ForgedHELO",$DoFakedLocalHelo) if $fhValencePB>0;
    return 1 if  $DoFakedLocalHelo==3;
    $Stats{forgedHelo}++;
    return 0;
  }
  return 1;
}

# do forged local sender 
sub LocalSenderOK {
  my($fh,$ip)=@_;
  my $this=$Con{$fh};
  d('LocalSenderOK');
  my $tlit;
  return 1 if $this->{localsenderdone};
  $this->{localsenderdone}=1;

  return 1 if ($this->{relayok});
  return 1 if ($this->{mISPRE}==1);
  return 1 if $this->{acceptall}==1;
  return 1 if ($DoNoValidLocalSender==0);
  return 1 if (!localmail($this->{mailfrom}));
  return 0 if (localmail($this->{mailfrom}) && $DoNoSpoofing);

#enforce valid local mailfrom

  my $mf=$this->{mailfrom};

  $tlit="monitoring" if $DoNoValidLocalSender==2;
  $tlit="scoring" if $DoNoValidLocalSender==3;
  $this->{prepend}="[InvalidLocalSender]";
  $this->{prepend}.="[$tlit]" if $DoNoValidLocalSender>=2;

  $this->{islocalmailaddress}=0;

  if($LocalAddresses_Flat && $this->{mailfrom}=~$LAFRE) {
    $this->{islocalmailaddress}=1;
  } else {
# Need another check?

# check sender against LDAP ?
    if ($DoLDAP) {
      if ($CanUseLDAP) {
        $h = $2 if ($mf =~ /^(.*@)(.*)$/);
        $this->{islocalmailaddress}=localmailaddress($h);
      } 
    }
  }
  if (!$this->{islocalmailaddress}) {
    mlog($fh,"$tlit Invalid Local Sender:$this->{mailfrom}") if $ValidateSenderLog && ($DoNoValidLocalSender==3 || $DoNoValidLocalSender==2);
    return 1 if ($DoNoValidLocalSender==2);
    delayWhiteExpire($fh);
    pbWhiteDelete($this->{ip});
    pbAdd($fh,$this->{ip},$flValencePB,"InvalidLocalSender",$DoNoValidLocalSender) if $flValencePB>0;
    return 1 if  $DoNoValidLocalSender==3;
    return 0;
  }
  return 1;
}

#enforce valid A/MX record for sender address
sub MXAOK {
  my($fh)=@_;
  my $this=$Con{$fh};
  d('MXAOK');
  my $tlit;
  return 1 if $this->{mailfrom}=~$BSRE;
  return 1 if !$DoDomainCheck;
  return 1 if (localmail($this->{mailfrom}));
  return 1 if !$CanUseAddress;
  return 1 if $this->{localuser}==1;
  return 1 if ($this->{relayok});
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if MXACacheFind($this->{ip})==2;
  my $slok=$this->{allLoveMXASpam}==1;
  my $mDoDomainCheck=$DoDomainCheck;
  $mDoDomainCheck=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoDomainCheck=3 if $testScoringMode && $DoPenaltyMessage && $mxaTestMode;
  

  $tlit="[monitoring]" if $mDoDomainCheck==2;
  $tlit="[scoring]" if $mDoDomainCheck==3;
  $this->{prepend}="[MissingMXA]";
  $this->{prepend}.="$tlit" if $mDoDomainCheck>=2;
  
  if (MXACacheFind($this->{ip})!=1) {
  
  my $res = Net::DNS::Resolver->new;
  $res->tcp_timeout($RBLmaxtime);
  eval{$mfmx = Email::Valid->mx($this->{mailfrom});};
  #mlog($fh,"MX/A Lookup: $@") if $@;
   return 1 if $@;
   }

  if (!$mfmx || MXACacheFind($this->{ip})==1) {
# couldn't find valid record for sender

    mlog($fh,"$tlit missing MX/A record") if $ValidateSenderLog && ($mDoDomainCheck==3 || $mDoDomainCheck==2);

    pbWhiteDelete($this->{ip});
    MXACacheAdd($this->{ip},1);
    return 1 if $mDoDomainCheck==2;
    pbAdd($fh,$this->{ip},$mxValencePB,"MissingMXA") if $mxValencePB>0;
    delayWhiteExpire($fh);
    return 1 if  $mDoDomainCheck==3;
    return 0; 
  }
  MXACacheAdd($this->{ip},2);
  return 1;
}

sub AttachOK {
  my($fh,$b,$blockexes,)=@_;
  my $this=$Con{$fh};
  d('AttachOK');
  my $decob = decodeMimeWords($b);
  return 1 if $this->{attachdone};
  return 1 if !$DoBlockExes;
  $this->{attachdone}=1;
  return 1 if $blockexes>=1 && $blockexes<=3 && $b!~('('.$badattachRE[$blockexes].')');
  return 1 if $GoodAttach && $blockexes==4 && !($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')'));
  $ext=substr($1,0,300);
  $ext=~/name\s*=\s*(.*\..*)\s/i;
  $ext=~/name\s*=\s*"(.*\..*)"/i;
  
  $this->{prepend}="[Attachment]";
  $this->{prepend}.="[monitoring]" if $DoBlockExes==2;
  $this->{prepend}.="[scoring]" if $DoBlockExes==3;

# if ($GoodAttach && $blockexes==4 && ($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')))  #&& !($1=~$goodattachRE) )))){


      		$Stats{viri}++ if $DoBlockExes==1;
      		delayWhiteExpire($fh) if $DoBlockExes==1;
      		my $slok=$this->{allLoveATSpam}==1;
      		
      		$this->{attachcomment}="bad attachment(noprocessing/$BlockNPExes): $1";

      		mlog($fh,$this->{attachcomment}) ;
      		pbAdd($fh,$this->{ip},$baValencePB,"BadAttachment" ) if $baValencePB>0 && $DoBlockExes!=2;
      		 
      		thisIsSpam($fh,$this->{attachcomment},$npAttachLog,$AttachmentError,$attachTestMode,$slok,$done) if $DoBlockExes==1;
    			
}


sub BombOK {
  my($fh,$b,$l)=@_;
  my $this=$Con{$fh};
  d('BombOK');
  my $subre;
  my $tlit;
  if (!$this->{whitelisted} && $whiteReRE && $whiteReRE!="" && $b=~('('.$whiteReRE.')')) {
		mlogRe($1,"White");
      	$this->{whitelisted}=1;
  }
  if ($LHNRE && $this->{data} =~('('.$LHNRE.')')) {
  		mlogRe($1,"RegularBounce");
      	$this->{noprocessing}=1;
  }
  if($testRe &&  $testReRE!="" && $DoTestRe && $b=~('('.$testReRE.')') ) {
   pbAdd($fh,$this->{ip},$bombTestValencePB,"bombSuspiciousRe") if ($bombTestValencePB>0);
    mlogRe($1,"Test","TestRegex");}
  if($bombSuspiciousRe && $bombSuspiciousReRE!="" &&  $bombSuspiciousReRE!="" && $b=~('('.$bombSuspiciousReRE.')') ) {
  pbAdd($fh,$this->{ip},$bombSuspiciousValencePB,"bombSuspiciousRe",1) if ($bombSuspiciousValencePB>0);
    mlogRe($1,"Suspicious");}
    
  
  return 1 if !$DoBombRe;
  return 1 if $noBombScript && $this->{mailfrom}=~$NBSRE;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{whitelisted}  && !$bombReWL;
  return 1 if $this->{noprocessing}==1 && !$bombReNP;
  return 1 if $this->{relayok} && !$bombReLocal;
  return 1 if $ispip && $this->{ip}=~$ISPRE && !$bombReISP;
  my $slok=$this->{allLoveBoSpam}==1;
  my $mDoBombRe=$DoBombRe;
  $mDoBombRe=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoBombRe=3 if $testScoringMode && $DoPenaltyMessage && $bombTestMode;

  $tlit = "spam found" if $mDoBombRe == 1; 
  $tlit="monitoring" if $mDoBombRe==2;
  $tlit="scoring" if $mDoBombRe==3;
  

  
  if($SpamGTUBE && $b=~$SpamGTUBERE) {
	mlogRe($1,"Bomb","GTUBE");
    return 0;
    }
 if($bombDataRe && $bombDataReRE!="" && $this->{data}=~('('.$bombDataReRE.')')) { 
    ($subre=$1) =~ s/\s+/ /g;
    $subre=substr($subre,0,$RegExLength);
    $this->{messagereason}=$subre;
    $this->{prepend}="[BombData]";
    $this->{prepend}.="[$tlit]" if $mDoBombRe>=2; 
    mlog($fh,"$tlit BombDataRegEx: '$subre'") if $mDoBombRe==3 || $mDoBombRe==2; 
    return 1 if $mDoBombRe==2;
    pbWhiteDelete($this->{ip});
    pbAdd($fh,$this->{ip},$bombValencePB,"BombData") if ($bombValencePB>0);
    
   
    return 1 if $mDoBombRe==3;
    return 0;
 }
 if($bombRe && $bombReRE!="" && $b=~('('.$bombReRE.')') ) { 
   ($subre=$1) =~ s/\s+/ /g;
    $subre=substr($subre,0,$RegExLength);
    $this->{messagereason}=$subre;
    $this->{prepend}="[BombRaw]";
    $this->{prepend}.="[$tlit]" if $mDoBombRe>=2; 
    mlog($fh,"$tlit BombRawRegEx: '$subre'") if $mDoBombRe==3 || $mDoBombRe==2; 
    return 1 if $mDoBombRe==2;
    pbWhiteDelete($this->{ip});
    pbAdd($fh,$this->{ip},$bombValencePB,"BombRaw") if ($bombValencePB>0);

    return 1 if $mDoBombRe==3;
    return 0;
  }
  
  return 1;
}

# 
sub BombHeaderOK {
  my($fh,$b)=@_;
  my $this=$Con{$fh};
  d('BombHeaderOK');
  my $subre;
  my $tlit;
  return 1 if $this->{addressedToSpamBucket};
  return 1 if $noBombScript && $this->{mailfrom}=~$NBSRE;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{whitelisted}  && !$bombReWL;
  return 1 if $this->{noprocessing}==1 && !$bombReNP;
  return 1 if $this->{relayok} && !$bombReLocal;
  return 1 if $ispip && $this->{ip}=~$ISPRE && !$bombReISP;
  return 1 if !$DoBombHeaderRe;
  my $slok=$this->{allLoveBoSpam}==1;
  my $mDoBombHeaderRe=$DoBombHeaderRe;
  $mDoBombHeaderRe=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoBombHeaderRe=3 if $testScoringMode && $DoPenaltyMessage && $bombTestMode;

  $tlit = "spam found" if $mDoBombHeaderRe == 1;
  $tlit="monitoring" if $mDoBombHeaderRe==2;
  $tlit="scoring" if $mDoBombHeaderRe==3;
  
  if(($bombCharSets  && $bombCharSetsRE!=""  && $b=~('('.$bombCharSetsRE.')') ) || ($bombHeaderRe  && $bombHeaderReRE!=""  && $b=~('('.$bombHeaderReRE.')') ) || ($bombSubjectRe  && $bombSubjectReRE!=""  && $b=~('('.$bombSubjectReRE.')') ) ){
   ($subre=$1) =~ s/\s+/ /g;
    $subre=substr($subre,0,$RegExLength);
    $this->{messagereason}=$subre;
    $this->{prepend}="[BombHeader]";
    $this->{prepend}.="[$tlit]" if $mDoBombHeaderRe>=2; 
    mlog($fh,"$tlit BombHeaderRegEx: '$subre'") if $mDoBombHeaderRe==3 || $mDoBombHeaderRe==2; 
    return 1 if $mDoBombHeaderRe==2;
    pbWhiteDelete($this->{ip});
    pbAdd($fh,$this->{ip},$bombValencePB,"BombHeader") if ($bombValencePB>0);
  
   
    return 1 if $mDoBombHeaderRe==3;
    return 0;
  }
  return 1;
}

# 
# 
sub BombSenderOK {
  my($fh,$b)=@_;
  my $this=$Con{$fh};
  d('BombSenderOK');
  my $subre;
  return 1 if !$DoBombSenderRe;

  return 1 if $noBombScript && $this->{mailfrom}=~$NBSRE;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{whitelisted}  && !$bombReWL;
  return 1 if $this->{noprocessing}==1 && !$bombReNP;
  return 1 if $this->{relayok} && !$bombReLocal;
  return 1 if $ispip && $this->{ip}=~$ISPRE && !$bombReISP;
  my $slok=$this->{allLoveBoSpam}==1;
  my $mDoBombSenderRe=$DoBombSenderRe;
  $mDoBombSenderRe=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoBombSenderRe=3 if $testScoringMode && $DoPenaltyMessage && $bombTestMode;

  my $tlit;
  $tlit = "spam found" if $mDoBombSenderRe == 1;
  $tlit="monitoring" if $mDoBombSenderRe==2;
  $tlit="scoring" if $mDoBombSenderRe==3;
  
   

  if($bombSenderRe  && $bombSenderReRE!="" && $b=~('('.$bombSenderReRE.')') ) {
    ($subre=$1) =~ s/\s+/ /g;
    $subre=substr($subre,0,$RegExLength);
        $this->{ messagereason } = "BombSender '$subre'";
        $this->{ prepend }       = "[BombSender]";
        $this->{ prepend } .= "[$tlit]" if $mDoBombSenderRe >= 2;

        if ($tlit) { $tlit .= " "; }

        mlog( $fh, $tlit . $this->{ messagereason } );
        pbWhiteDelete($ip);
        return 1 if $mDoBombSenderRe == 2;

        pbAdd( $fh, $this->{ ip }, $bombValencePB, "BombSenderRe" ) if ( $bombValencePB > 0 );
    return 1 if $mDoBombSenderRe==3;
    $Stats{bombSender}++;
    return 0;
  }
  return 1;
}

# 
sub ScriptOK {
  my($fh,$b)=@_;
  my $this=$Con{$fh};
  d('ScriptOK');
  my $tlit;
	
  return 1 if !$DoScriptRe;
  return 1 if $noBombScript && $this->{mailfrom}=~$NBSRE;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{whitelisted}  && !$bombReWL;
  return 1 if $this->{noprocessing}==1 && !$bombReNP;
  return 1 if $this->{relayok} && !$bombReLocal;
  return 1 if $ispip && $this->{ip}=~$ISPRE && !$bombReISP;
  my $slok=$this->{allLoveBoSpam}==1;
  my $mDoScriptRe=$DoScriptRe;
  $mDoScriptRe=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoScriptRe=3 if $testScoringMode && $DoPenaltyMessage && $scriptTestMode;

  $tlit="monitoring" if $mDoScriptRe==2;
  $tlit="scoring" if $mDoScriptRe==3;
 
  if($scriptRe &&  $scriptReRE!="" && $b=~('('.$scriptReRE.')') ) {
    $this->{prepend}="[Script]";
    $this->{prepend}.="[$tlit]" if $mDoScriptRe>=2;
    ($subre=$1) =~ s/\s+/ /g;
    $subre=substr($subre,0,$RegExLength);
    $this->{mypbreason}=$subre; 
    mlog($fh,"$tlit ScriptRegEx: '$subre'") if ($mDoScriptRe==2 || $mDoScriptRe==3);
    return 1 if $mDoScriptRe==2;
    pbAdd($fh,$this->{ip},$scriptValencePB,"ScriptRe") if ($scriptValencePB>0);
    return 1 if $mDoScriptRe==3;
    return 0;
  }
  return 1;
}

# 
#  
sub validHeloOK {
  my($fh,$helo)=@_;
  my $this=$Con{$fh};
  d('validHeloOK');
  my $tlit;
  return 1 if $this->{validhelodone};

  $this->{validhelodone}=1;
  return 1 if !$DoValidFormatHelo;
  return 1 if ($this->{relayok});
  return 1 if $this->{localuser}==1;
  return 1 if ($heloBlacklistIgnore && $helo =~ $HBIRE); 
  return 1 if $this->{mISPRE}==1;
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if $this->{whitelisted};
  return 1 if $this->{noprocessing}==1;
  return 1 if $helo=~"\[[0-9\.]+\]";
  my $slok=$this->{allLoveHlSpam}==1;
  my $mDoValidFormatHelo=$DoValidFormatHelo;
  $mDoValidFormatHelo=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoValidFormatHelo=3 if $testScoringMode && $DoPenaltyMessage && $ihTestMode;

  if ($DoValidFormatHelo && $validFormatHeloRe   &&  $validFormatHeloReRE!="" && !($helo =~('('.$validFormatHeloReRE.')'))) {

    $tlit="monitoring" if $mDoValidFormatHelo==2;
    $tlit="scoring" if $mDoValidFormatHelo==3;
    $this->{prepend}="[ValidHelo]";
    $this->{prepend}.="[$tlit]" if $mDoValidFormatHelo>=2;   
    mlog($fh,"$tlit Valid HELO check: '$helo'") if $ValidateSenderLog && ($mDoValidFormatHelo==3 || $mDoValidFormatHelo==2);

    return 1 if $mDoValidFormatHelo==2;
    pbAdd($fh,$this->{ip},$ihValencePB,"ValidHelo") if $ihValencePB>0 ;
    return 1 if $mDoValidFormatHelo==3;
    return 0;
  }

  return 1;
}

 # do invalid HELO check
sub invalidHeloOK {
  my($fh,$helo)=@_;
  my $this=$Con{$fh};
  d('invalidHeloOK');
  my $tlit;

  return 1 if $this->{invalidhelodone};
  $this->{invalidhelodone}=1;
  return 1 if !$DoInvalidFormatHelo;
  return 1 if ($this->{relayok}==1);
  return 1 if $this->{localuser}==1;
  return 1 if ($heloBlacklistIgnore && $helo =~ $HBIRE); 
  return 1 if $this->{mISPRE}==1;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{whitelisted}==1;
  return 1 if $this->{noprocessing}==1;
  return 1 if $helo=~"\[[0-9\.]+\]";
  my $slok=$this->{allLoveHlSpam}==1;
  my $mDoInvalidFormatHelo=$DoInvalidFormatHelo;
  $mDoInvalidFormatHelo=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoInvalidFormatHelo=3 if $testScoringMode && $DoPenaltyMessage && $ihTestMode;

  if ($DoInvalidFormatHelo  &&  $invalidFormatHeloReRE!="" && $invalidFormatHeloRe && $helo =~$invalidFormatHeloReRE) {

    $tlit="monitoring" if $mDoInvalidFormatHelo==2;
    $tlit="scoring" if $mDoInvalidFormatHelo==3;
    
    $this->{prepend}="[InvalidHelo]";
    $this->{prepend}.="[$tlit]" if $mDoInvalidFormatHelo>=2; 
    mlog($fh,"$tlit Invalid HELO: '$helo'") if $ValidateSenderLog && ($mDoInvalidFormatHelo==3 || $mDoInvalidFormatHelo==2);
    return 1 if $DoInvalidFormatHelo==2;
    pbAdd($fh,$this->{ip},$ihValencePB,"InvalidHelo") if $ihValencePB>0 ;
    return 1 if $mDoInvalidFormatHelo==3;
    return 0;
  }

  return 1;
}

# do blacklisted HELO check
sub BlackHeloOK {
  my($fh,$helo)=@_;
  my $this=$Con{$fh};
  d('BlackHeloOK');
  my $tlit;
  return 1 if !$useHeloBlacklist;
  return 1 if ($this->{relayok});
  return 1 if $this->{localuser}==1;
  return 1 if ( $this->{whitelisted});
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if ($this->{noprocessing}==1);
  return 1 if ($heloBlacklistIgnore && $this->{helo} =~ $HBIRE);
  my $slok=$this->{allLoveHlSpam}==1;
  my $museHeloBlacklist=$useHeloBlacklist;
  $museHeloBlacklist=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $museHeloBlacklist=3 if $testScoringMode && $DoPenaltyMessage && $hlTestMode;

  $tlit="monitoring" if $museHeloBlacklist==2;
  $tlit="scoring" if $museHeloBlacklist==3;
  $this->{prepend}="[BlackHelo]";
  $this->{prepend}.="[$tlit]" if $museHeloBlacklist>=2;  

  if ($HeloBlackObject && $HeloBlack{$this->{helo}}) { 
    mlog($fh,"$tlit blacklisted HELO: '$helo'") if $ValidateSenderLog && ($museHeloBlacklist==3 || $museHeloBlacklist==2);

    return 1 if $museHeloBlacklist==2;
    pbAdd($fh,$this->{ip},$hlValencePB,"BlacklistedHelo") if $ihValencePB>0 ;
    return 1 if $museHeloBlacklist==3;
     
    return 0;
  }
  return 1;
}

sub PTROK {

  my($fh)=@_;
  my $this=$Con{$fh};
  d('PTROK');
  
  return 1 if !$DoReversed && !$DoInvalidPTR;
  return 1 if !$CanUseDNS;
  return 1 if $this->{mISPRE}==1;
  return 1 if $this->{localuser}==1;
  return 1 if $this->{acceptall}==1;
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if $this->{whitelisted};
  return 1 if $this->{noprocessing}==1;
  return 1 if pbWhiteFind($this->{ip});
  return 1 if PTRCacheFind($this->{ip})==2;
  return 1 if $this->{relayok};
  my $slok=$this->{allLovePTRSpam}==1;
  my $mDoReversed=$DoReversed;
  my $mDoInvalidPTR=$DoInvalidPTR;
  $mDoReversed=3 if ($DoReversed == 0 || $DoReversed == 2) && ($DoInvalidPTR == 1 || $DoInvalidPTR == 3);
  $mDoReversed=$mDoInvalidPTR=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mDoReversed=$mDoInvalidPTR=3 if $testScoringMode && $DoPenaltyMessage && $ptrTestMode;

  my $tlit;
  $tlit="monitoring" if $mDoReversed==2;
  $tlit="scoring" if $mDoReversed==3;
  $this->{prepend}="[PTRinvalid]";
  $this->{prepend}.="[$tlit]" if $mDoInvalidPTR>=2;
  
if (PTRCacheFind($this->{ip})==1) {
  	$this->{messagereason}="PTRmissing";
    mlog($fh,"$tlit $this->{messagereason}") if $ValidateSenderLog && ($mDoInvalidPTR==3 || $mDoInvalidPTR==2);
	return 1 if $mDoInvalidPTR==2;
pbAdd($fh,$this->{ip},$ihValencePB,"PTRinvalid") if $ihValencePB>0 ;
	return 1 if $mDoInvalidPTR==3;
    $Stats{ptrInvalid}++ unless $slok;
    return 0;
}
if (PTRCacheFind($this->{ip})==3) {
  	$this->{messagereason}="PTR invalid: cache";
    mlog($fh,"$tlit $this->{messagereason}") if $ValidateSenderLog && ($mDoInvalidPTR==3 || $mDoInvalidPTR==2);
	return 1 if $mDoInvalidPTR==2;
pbAdd($fh,$this->{ip},$ihValencePB,"PTRinvalid") if $ihValencePB>0 ;
	return 1 if $mDoInvalidPTR==3;
    $Stats{ptrInvalid}++ unless $slok;
    return 0;
}
  my $res = Net::DNS::Resolver->new;
  $res->tcp_timeout(15);


  my $ip_address = $this->{ip};
  if ($ip_address) {
  
    my $query = $res->search("$ip_address");
    if ($query) {
      foreach my $rr ($query->answer) {
        next unless $rr->type eq "PTR";
        $this->{ptrdsn}=$rr->ptrdname;
        return 1 if ($heloBlacklistIgnore && $this->{ptrdsn} =~ $HBIRE);
        

        if ($mDoInvalidPTR && $invalidPTRRe &&  $invalidPTRReRE!=""  && $this->{ptrdsn} =~$invalidPTRReRE) {

          

		$this->{messagereason}="PTR invalid: $this->{ptrdsn}";
         mlog($fh,"$tlit $this->{messagereason}") if $ValidateSenderLog && ($mDoInvalidPTR==3 || $mDoInvalidPTR==2);
		PTRCacheAdd($this->{ip},3);
		return 1 if $mDoInvalidPTR==2;
		pbAdd($fh,$this->{ip},$ihValencePB,"PTRinvalid") if $ihValencePB>0 ;

        return 1 if $mDoInvalidPTR==3;
        $Stats{ptrInvalid}++ unless $slok;
           
          return 0;
        }
      PTRCacheAdd($this->{ip},2);
      return 1;
      }
    } else {
      if ($res->errorstring=="NXDOMAIN") {
        $this->{prepend}="[PTRmissing]";
  		$this->{prepend}.="[$tlit]" if $mDoReversed==3;
  		PTRCacheAdd($this->{ip},1);
        mlog($fh,"$tlit PTR missing for $ip_address ") if $ValidateSenderLog && ($mDoReversed==3 || $mDoReversed==2);

        return 1 if $mDoReversed==2;
        pbAdd($fh,$this->{ip},$ptValencePB,"PTRmissing") if $ptValencePB>0;
 
        return 1 if $mDoReversed==3;
        $Stats{ptrMissing}++ unless $slok;
        $this->{messagereason}="PTR missing"; 

        return 0;
      }
    }
  }
  return 1;
} 

sub PBOK {
  my($fh,$myip,$lvl)=@_;
  my $this=$Con{$fh};
  d('PBOK');
  $this->{prepend}="";
  my $t=time;

  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));

  return 1 if ($this->{relayok});
  return 1 if ( $this->{whitelisted});
  return 1 if ($this->{noprocessing}==1);
  return 1 if ($this->{mISPRE}==1);
  return 1 if ($this->{mNPBRE}==1);
  return 1 if $this->{rwlok}==1;
  return 1 if $this->{contentonly}==1;
  return 1 if(pbWhiteFind($this->{ip}));
  return 1 if (!exists $PBBlack{$ip});
  return 1 if !$DoPenalty;
  my($ct,$ut,$level,$totalscore,$sip,$reason)=split(" ",$PBBlack{$ip});
  $this->{mypbreason}="$totalscore";
  return 1 if $totalscore<$PenaltyLimit;
  $this->{prepend}="[PB]";
  $this->{prepend}="[PB][monitoring]" if $DoPenalty==2 || $DoPenalty==3;
  return 1 if $DoPenalty==2 || $DoPenalty==3;
  return 0;
}

sub PBExtremeOK {
  my($fh,$myip)=@_;
  my $this=$Con{$fh};
  d('PBExtremeOK');
  my $newscore;
  my $data;
  my $t=time;
  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
  $this->{prepend}="";
  return 1 if $PenaltyExtreme==0;
  
  return 1 if $pbTestMode==1;
  return 1 if $this->{spamlover};
  return 1 if !$DoPenalty;
  return 1 if ( $this->{contentonly});
  return 1 if ( $this->{whitelisted} && !$DoExtremeWL);
  return 1 if ($this->{noprocessing}==1 && !$DoExtremeNP);
  return 1 if (exists $PBWhite{$ip});
  return 1 if ($this->{mISPRE}==1);
  return 1 if ($this->{nodelay}==1);
  return 1 if ($this->{mNPBRE}==1);
  return 1 if  $this->{acceptall}==1;  
  return 1 if ($this->{relayok});
  return 1 if $this->{localuser}==1;
  return 1 if (!exists $PBBlack{$ip});


  my $tlit;
  $tlit="PBextreme" if $DoPenalty==1;
  $tlit="PBextreme:monitoring" if $DoPenalty==2;



  my($ct,$ut,$level,$totalscore,$sip,$reason)=split(" ",$PBBlack{$ip});

  if ($totalscore>=$PenaltyExtreme) {
  $this->{prepend}="[PBextreme]";
  $this->{prepend}="[PBextreme][monitoring]" if $DoPenalty==2 || $DoPenalty==3;
    mlog($fh,"$tlit $ip score:$totalscore") if $DoPenalty && $PenaltyLog;
    return 1 if ($DoPenalty==2 || $DoPenalty==3) && !$DoExtreme;
    $Stats{pbdenied}++ ;
    return 0;
  }
  return 1;
}

sub RBLCacheOK {
  my($fh,$myip)=@_;
  my $this=$Con{$fh};
  d('RBLCacheOK');
  my $ip=$myip;
  return 1 if !$ValidateRBL;
  return 1 if $this->{rblcachedone}==1;
  $this->{rblcachedone}=1;
  return 1 if $this->{spamlover} && !$slScoringMode;
  return 1 if $noDelay && $ip=~$NDRE;
  return 1 if $noRBL && $ip=~$NRBLRE;
  return 1 if $this->{contentonly}==1;
  return 1 if $this->{whitelisted}==1 && !$RBLWL;
  return 1 if $this->{noprocessing}==1;
  return 1 if !(exists $RBLCache{$ip});
  return 1 if !$RBLCacheInterval;
  return 1 if $rblSpamLovers && !$slScoringMode;
  return 1 if $rblTestMode==1 && !$testScoringMode;
  return 1 if exists $PBWhite{$ip};
  return 1 if $this->{mISPRE}==1;
  return 1 if $this->{localuser}==1;
  return 1 if $this->{acceptall}==1;  
  return 1 if $this->{relayok};
  return 1 if $this->{rwlok}==1;
  
  $this->{rblcachefound}=1;
  
  my $slok=$this->{allLoveRBLSpam}==1;
  
  my $mValidateRBL=$ValidateRBL;
  
  $mValidateRBL=3 if $slScoringMode && $DoPenaltyMessage && ($slok || $this->{spamlover});
  $mValidateRBL=3 if $testScoringMode && $DoPenaltyMessage && $rblTestMode;
  

  my $tlit;
  $tlit = "spam found" if $mValidateRBL == 1;
  $tlit = "monitoring" if $mValidateRBL==2;
  $tlit = "scoring" if $mValidateRBL==3;
  $this->{prepend}="[DNSBLcache]";
  $this->{prepend}.="[$tlit]" if $mValidateRBL>=2;
  
  my($ct,$mm,$rbllists,$status)=split(" ",$RBLCache{$ip});
  
  $this->{mypbreason}=$rbllists;

  $this->{messagereason} = "$ip listed in DNSBLcache by $rbllists";
  
  mlog($fh,"$tlit - $this->{messagereason} at $mm)") if (($RBLLog || $PenaltyLog));
  return 1 if $mValidateRBL==2;
  
  pbAdd($fh,$ip,$rblValencePB,"DNSBLcache",$ValidateRBL) if $rblValencePB>0;
  return 1 if $mValidateRBL==3;
  
  $Stats{rblfails}++ unless $slok;
  
  my $reply=$RBLError;

    $reply =~ s/RBLLISTED/$rbllists/g;
    if ($ForceRBLCache) {
        thisIsSpam( $fh, "$this->{messagereason}", $RBLFailLog, "$reply", 0, 0, 1 );
      } else {
        thisIsSpam( $fh, "$this->{messagereason}", $RBLFailLog, "$reply", $rblTestMode, $slok,
            ( $slok || $rblTestMode || $this->{spamlover} ) );
      }
  return 0;
}

sub Delayok {
  my($fh,$rcpt)=@_;
  my $this=$Con{$fh};
  $this->{prepend}="";
  d('Delayok');
  return 1 if $this->{rcptnoprocessing};
  return 1 unless (!$this->{relayok} && $EnableDelaying && !($ispip && $this->{ip}=~$ISPRE));
  
  return 1 unless ($this->{noprocessing}!=1 && !($noProcessing && $this->{mailfrom}=~$NPREL));
  return 1 if $this->{localuser};
  my $a=lc $this->{mailfrom};
  my $time=$UseLocalTime ? localtime() : gmtime();
  my $tz=$UseLocalTime ? tzStr() : '+0000';
  $time=~s/... (...) +(\d+) (........) (....)/$2 $1 $4 $3/;
  if (($whiteListedDomains && $a=~$WLDRE) || (!$DelayWL && $Whitelist{$a})) {
# add to our header; merge later, when client sent own headers
    $this->{myheader}.="X-Assp-Delay: not delayed (whitelisted); $time $tz\r\n" if $DelayAddHeader;
    return 1;
  }
  if ($noDelay && $this->{ip}=~$NDRE) {
# add to our header; merge later, when client sent own headers
    $this->{myheader}.="X-Assp-Delay: not delayed (noDelay IP); $time $tz\r\n" if $DelayAddHeader;
    return 1;
  }

if (!$DelaySL && $this->{allLoveDLSpam}==1) {
# add to our header; merge later, when client sent own headers
$this->{myheader}.="X-Assp-Delay: not delayed (spamlover); $time $tz\r\n" if $DelayAddHeader; 
return 1;
}
if ($this->{DLSLRE}) {
# add to our header; merge later, when client sent own headers
$this->{myheader}.="X-Assp-Delay: not delayed (delay-spamlover); $time $tz\r\n" if $DelayAddHeader; 
return 1;
}
  if ($DelayNormalizeVERPs) {
# strip extension
    $a=~s/\+.*(?=@)//;
# replace numbers with '#'
    $a=~s/\b\d+\b(?=.*@)/#/g;
  }
  my $ip=ipNetwork($this->{ip},($DelayUseNetblocks ? 24 : 32));
  my $hash="$ip $a ". lc $rcpt;
# get sender domain
  my $awhite=$a;
  $awhite=~s/.*@//;
  my $hashwhite="$ip $awhite";
  if ($CanUseMD5Keys) {
    $hash=Digest::MD5::md5_hex($hash);
    $hashwhite=Digest::MD5::md5_hex($hashwhite);
  }
  my $t=time;
  my $delay_result;
  if (!exists $DelayWhite{$hashwhite}) {
    if (!exists $Delay{$hash}) {
      mlog($fh,"adding new triplet: ($ip,$a,". lc $rcpt .")") if $DelayLog;
      $Stats{rcptDelayed}++;
      $Delay{$hash}=$t;
      $delay_result=0;
    } else {
      my $interval=$t-$Delay{$hash};
      my $intervalFormatted=formatTimeInterval($interval);
      if ($interval<$DelayEmbargoTime*60) {
        mlog($fh,"embargoing triplet: ($ip,$a,". lc $rcpt .") waited: $intervalFormatted") if $DelayLog;
        $Stats{rcptEmbargoed}++;
        $delay_result=0;
      } elsif ($interval<$DelayEmbargoTime*60+$DelayWaitTime*3600) {
        mlog($fh,"accepting triplet: ($ip,$a,". lc $rcpt .") waited: $intervalFormatted") if $DelayLog;
        delete $Delay{$hash};
        $DelayWhite{$hashwhite}=$t;
        $delay_result=1;
# add to our header; merge later, when client sent own headers
        $this->{myheader}.="X-Assp-Delay: delayed for $intervalFormatted; $time $tz\r\n" if $DelayAddHeader;
      } else {
        mlog($fh,"late triplet encountered, deleting: ($ip,$a,". lc $rcpt .") waited: $intervalFormatted") if $DelayLog;
        $Stats{rcptDelayedLate}++;

        $Delay{$hash}=$t;
        $delay_result=0;
      }
    }
  } else {
    my $interval=$t-$DelayWhite{$hashwhite};
    my $intervalFormatted=formatTimeInterval($interval);
    if ($interval<$DelayExpiryTime*24*3600) {
      mlog($fh,"renewing tuplet: ($ip,$awhite) age: ". $intervalFormatted) if $DelayLog;
      $DelayWhite{$hashwhite}=$t;
# multiple rcpt's
      delete $Delay{$hash};
      $delay_result=1;
# add to our header; merge later, when client sent own headers
      $this->{myheader}.="X-Assp-Delay: not delayed (auto accepted); $time $tz\r\n" if $DelayAddHeader;
    } else {
      mlog($fh,"deleting expired tuplet: ($ip,$awhite) age: ". $intervalFormatted) if $DelayLog;
      $Stats{rcptDelayedExpired}++;

      delete $DelayWhite{$hashwhite};
      $Delay{$hash}=$t;
      $delay_result=0;
    }
  }
  return $delay_result;
}
# compile the noBayesian check regular expression
sub setNBRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'NBRE', $s, 'i', "noBayesian check" );
}

# compile the spam-lovers regular expression
sub setSLRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'SLRE', $s, 'i', "Spam Lovers" );
}
# compile the spam-haters regular expression
sub setSHRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'SHRE', $s, 'i', "Spam Haters" );
}
# compile the Bayesian spam-lovers regular expression
sub setBSLRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'BSLRE', $s, 'i', "Bayesian Spam Lovers" );
}
# compile the Bayesian spam-haters regular expression
sub setBSHRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'BSHRE', $s, 'i', "Bayesian Spam Haters" );
}
# compile the bad attachment spam-lovers regular expression
sub setATSLRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'ATSLRE', $s, 'i', "bad attachment Spam Lovers" );
}
# compile the blacklisted spam-lovers regular expression
sub setBLSLRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
    SetRE( 'BLSLRE', $s, 'i', "Blacklisted Spam Lovers" );
}

# compile the bomb spam-lovers regular expression
sub setBOSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'BOSLRE', $s, 'i', "Bomb Spam Lovers" );
}
# compile the message verifying spam-lovers regular expression
sub setMVSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'MVSLRE', $s, 'i', "malformed mail listed Spam Lovers" );
}
# compile the HELO listed spam-lovers regular expression
sub setHLSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'HLSLRE', $s, 'i', "HELO listed Spam Lovers" );
}

# compile the SPF failures spam-lovers regular expression
sub setSPFSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'SPFSLRE', $s, 'i', "SPF failures Spam Lovers" );
}

# compile the DNSBL failures spam-lovers regular expression
sub setRBLSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'RBLSLRE', $s, 'i', "RBL failures Spam Lovers" );
}
# compile the DNSBL failures spam-lovers regular expression
sub setRBLSHRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'RBLSHRE', $s, 'i', "RBL failures Spam Haters" );
}
# compile the URIBL failures spam-lovers regular expression
sub setURIBLSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'URIBLSLRE', $s, 'i', "URIBL failures Spam Lovers" );
}
# compile the Invalid Senders  failures spam-lovers regular expression
sub setISSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'ISSLRE', $s, 'i', "Invalid Senders failures Spam Lovers" );
}
sub setPTRSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'PTRSLRE', $s, 'i', "Invalid/Missing PTR failures Spam Lovers" );
}
sub setMXASLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'MXASLRE', $s, 'i', "Missing MX/A failures Spam Lovers" );
}
sub setPBSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'PBSLRE', $s, 'i', "Penalty Box failures Spam Lovers" );
}

# compile not SRS signed bounces spam-lovers regular expression
sub setSRSSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'SRSSLRE', $s, 'i', "not SRS signed bounces Spam Lovers" );
}
sub setDLSLRE {
 my (@uad, @u, @d);
 foreach $a (split(/\|/,$_[0])) {
  if($a=~/\S\@\S/) {
   push(@uad,$a);
  } elsif( $a=~/^\@/ ) {
   push(@d,$a);
  } else {
   push(@u,$a);
  }
 }
 my @s;
 push(@s,'^('.join('|',@uad).')$') if @uad;
 push(@s,'^('.join('|',@u).')@') if @u;
 push(@s,'('.join('|',@d).')$') if @d;
 my $s=join("|",@s);
 $s='<not a valid list>' unless $s;
    SetRE( 'DLSLRE', $s, 'i', "not Delay Spam Lovers" );
}


# returns true if all of the addresses in the space separated list are Noprocessing addresses
sub allNoProcessing {
  my $rcpt=shift;
  my $c=0;
  for (split(' ',$rcpt)) {
  return 1 if $_=~$NPREL;
    return 0 unless $_=~$NPREL;
    $c++;
  }
  $c;
}
# returns true if all of the addresses in the space separated list are bayesian spam hater addresses
sub allBayesSpamHaters {
  my $rcpt=shift;
  my $c=0;
  for (split(' ',$rcpt)) {
  return 1 if $_=~$BSHRE;
    return 0 unless $_=~$BSHRE;
    $c++;
  }
  $c;
}

# returns true if all of the addresses in the space separated list are all spam hater addresses
sub allSpamHaters {
  my $rcpt=shift;
  my $c=0;
  for (split(' ',$rcpt)) {
  return 1 if $_=~$SHRE;
    return 0 unless $_=~$SHRE;
    $c++;
  }
  $c;
}
# returns true if all of the addresses in the space separated list are rbl spam hater addresses
sub allRBLSpamHaters {
  my $rcpt=shift;
  my $c=0;
  for (split(' ',$rcpt)) {
  return 1 if $_=~$RBLSHRE;
    return 0 unless $_=~$RBLSHRE;
    $c++;
  }
  $c;
}

# returns true if all of the addresses in the space separated list are CC addresses
sub allccSpamFilter {
  my($rcpt,$from)=@_;
  my $c=0;
  return 1 if $from=~$CCRE;
  for (split(' ',$rcpt)) {
  	return 1 if $_=~$CCRE;
    next;
  }
  return 0;
}


# returns true if one of the addresses in the space separated list is CCArchiv address
sub allccHamFilter {
  my($rcpt,$from)=@_;
  my $c=0;
  return 1 if $from=~$CCARRE;
  for (split(' ',$rcpt)) {  	
  	return 1 if $_=~$CCARRE; 
    next;
  }
  return 0;
}
# returns true if one of the addresses in the space separated list is CCArchiv All addresses
sub allccSpamAlways {
  my($rcpt,$from)=@_;
  my $c=0;
  return 1 if $from=~$CCARE;
  for (split(' ',$rcpt)) {
  	return 1 if $_=~$CCARE;  
    next;
  }
  return 0;
}
# the message is not spam -- route it to the server
sub isnotspam {
  my ($fh,$done)=@_;
  d(23);
  my $this=$Con{$fh};
  my $server=$this->{friend};

# it's time to merge our header with client's one
  $this->{myheader}=headerWrap($this->{myheader}); # wrap long lines
  $this->{header}=~s/^($HeaderRe*)/$1\r\n\n\n\r$this->{myheader}/o;
  $this->{header}=~s/\r?\n?\r\n\n\n\r/\r\n/;

  my $m=$this->{header};
  $this->{ccheader}=$this->{header};
  sendque($server, $m);

  if($done) {
   
    $this->{getline}=\&getline;
  } else {
    $this->{getline}=\&whitebody;
  }
}

# the message is non spam -- just relay it to the server
sub whitebody { my($fh,$l)=@_;
  my $this=$Con{$fh};
  d(25);
  my $server=$this->{friend};
  $this->{maillength}+=length($l);
  $this->{scanbuf}.=$l;
 

  my $done=$l=~/^\.[\r\n]*$/ || defined($this->{bdata}) && $this->{bdata}<=0;
  my $mbytes=$MaxBytes;
  $mbytes=$ClamAVBytes if $ClamAVBytes>$MaxBytes;
  if( $done || $this->{maillength} >=$mbytes) {


   if (!ClamScanOK($fh,$this->{scanbuf})){
    Maillog($fh,'',$SpamVirusLog);
	seterror($fh,$this->{averror},$done);
    return;} 
   }
  if($done) {
  
  	$this->{scanbuf}=$this->{ccheader}.$this->{scanbuf}  ;
  	ccMail($this->{mailfrom},$sendHamInbound,$this->{scanbuf},$this->{rcpt}) ;

    $this->{getline}=\&getline;
  }
  sendque($server, $l);

}

# the message is non spam -- check if it is executable

sub whitebodyNoExe {
  my($fh,$l)=@_;
  my $this=$Con{$fh};
  d(255);
 
  my $b=$this->{header}.=$l;
  $this->{data}.=$l;
  my $decob = decodeMimeWords($b);
  
  $this->{attachcomment}="(no bad attachments)";

  
  
  my $done=$l=~/^\.[\r\n]*$/ || defined($this->{bdata}) && $this->{bdata}<=0;
  #if($done) {
  #mlog($fh,"test:2 $disclaimerlines") if $disclaimerlines;
  #$l=~s/\.[\r\n]/$disclaimerlines\r\n\.\r\n/ if $disclaimerlines;}
  my $mbytes=$MaxBytes;
  $mbytes=$ClamAVBytes if $ClamAVBytes>$MaxBytes && $CanUseAvClamd && $AvailAvClamd;
  $mbytes=$URIBLBytes  if $URIBLBytes>$mbytes && $ValidateURIBL;


  if( $done || length($b) >=$mbytes) {
    $this->{maillength}=length($b);
      	if (!$this->{red} && $redRe &&  $redReRE!="" && $b=~('('.$redReRE.')')) {
  		mlogRe($1,"Red");
  		$this->{red}=1;
  		}
    
      if(!BombOK($fh,$b,$this->{data})) {
      $bomblt = $bombError;

      $bomblt .= " ( reason: '$this->{messagereason}' ) " if $bombErrorReason;
      $Stats{bombs}++;
      delayWhiteExpire($fh);
      my $slok=$this->{allLoveBoSpam}==1;
 
      thisIsSpam($fh,"BombRe: '$this->{messagereason}'",$spamBombLog,$bomblt,$bombTestMode,$slok,1);
      }

    if($BlockUuencoded && $b=~$UUENCODEDRe) {
    $Stats{msgverify}++;
    delayWhiteExpire($fh);
    mlog($fh,"MsgVerify: uuencoded");
    seterror($fh,"$UuencodedError",1);
    done($fh);
    return;
    }
    if(!$this->{sattachdone} && $SuspiciousAttach &&  $suspiciousattachRE && ($decob=~('('.$suspiciousattachRE.')')  || $b=~('('.$suspiciousattachRE.')') )){
		$this->{sattachdone}=1;
	    $ext=substr($1,0,300);
      	$ext=~/name\s*=\s*(.*\..*)\s/i;
      	$ext=~/name\s*=\s*"(.*\..*)"/i;
      	$this->{prepend}="[Attachment][scoring]";
      	
      	mlog($fh,"suspicious attachment (white/local): $1") if ($this->{noprocessing}!=1);
      	mlog($fh,"suspicious attachment (noprocessing): $1") if ($this->{noprocessing}==1);
      	pbAdd($fh,$this->{ip},$satValencePB,"SuspiciousAttachment",1 ) if $satValencePB>0 ;
     }
    if ($this->{noprocessing}!=1) {
      	   
         if (!$this->{attachdone} && $DoBlockExes>1 && ( ($BlockWLExes>=1 && $BlockWLExes<=3 && $b=~('('.$badattachRE[$BlockWLExes].')')) ||
             ($GoodAttach && $BlockWLExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
			$this->{attachdone}=1;
      		$this->{prepend}="[Attachment]";
      		$this->{prepend}.="[monitoring]" if $DoBlockExes==2;
      		$this->{prepend}.="[scoring]" if $DoBlockExes==3;
      		$ext=substr($1,0,300);
      		$ext=~/name\s*=\s*(.*\..*)\s/i;
      		$ext=~/name\s*=\s*"(.*\..*)"/i;
			$Stats{viri}++ if $DoBlockExes==1;
      		delayWhiteExpire($fh) if $DoBlockExes==1;
      		my $slok=$this->{allLoveATSpam}==1 if $DoBlockExes==1;
      		$this->{attachcomment}="bad attachment(white/local/$BlockWLExes): $1";

      		mlog($fh,$this->{attachcomment}) if $DoBlockExes>1;
      		pbAdd($fh,$this->{ip},$baValencePB,"BadAttachment" ) if $baValencePB>0 && $DoBlockExes!=2;
      		thisIsSpam($fh,$this->{attachcomment},$wlAttachLog,$AttachmentError,$attachTestMode,$slok,$done) if $DoBlockExes==1;
   			
    	}
    }
      if ($this->{noprocessing}==1) {    

    
    		 if($DoBlockExes>1 && !$this->{attachdone} && (($BlockNPExes>=1 && $BlockNPExes<=3 && $b=~('('.$badattachRE[$BlockNPExes].')')) ||
         ($GoodAttach && $BlockNPExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
			$this->{attachdone}=1;
         	$this->{prepend}="[Attachment]";
      		$this->{prepend}.="[monitoring]" if $DoBlockExes==2;
      		$this->{prepend}.="[scoring]" if $DoBlockExes==3;
      		$ext=substr($1,0,300);
      		$ext=~/name\s*=\s*(.*\..*)\s/i;
      		$ext=~/name\s*=\s*"(.*\..*)"/i;
			$Stats{viri}++ if $DoBlockExes==1;
      		delayWhiteExpire($fh) if $DoBlockExes==1;
      		my $slok=$this->{allLoveATSpam}==1 if $DoBlockExes==1;
      		
      		$this->{attachcomment}="bad attachment(noprocessing/$BlockNPExes): $1";

      		mlog($fh,$this->{attachcomment}) ;
      		pbAdd($fh,$this->{ip},$baValencePB,"BadAttachment" ) if $baValencePB>0 && $DoBlockExes!=2;
      		thisIsSpam($fh,$this->{attachcomment},$npAttachLog,$AttachmentError,$attachTestMode,$slok,$done) if $DoBlockExes==1;
    			
    	}
    }
    

     if ($this->{noprocessing}==1) {
     
 
      if(!$this->{attachdone} && $DoBlockExes==1 && (($BlockNPExes>=1 && $BlockNPExes<=3 && $b=~('('.$badattachRE[$BlockNPExes].')')) ||
         ($GoodAttach && $BlockNPExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
		$this->{attachdone} =1;
	  	$ext=substr($1,0,300);
      	$ext=~/name\s*=\s*(.*\..*)\s/i;
      	$ext=~/name\s*=\s*"(.*\..*)"/i;
        $this->{prepend}="[Attachment]";
        $Stats{viri}++;
        delayWhiteExpire($fh);
        $this->{attachcomment}="bad attachment(noprocessing/$BlockNPExes): $1";
        pbAdd($fh,$this->{ip},$baValencePB,"BadAttachment",1) if $baValencePB>0;
        my $slok=$this->{allLoveATSpam}==1;
        thisIsSpam($fh,$this->{attachcomment},$npAttachLog,$AttachmentError,$attachTestMode,$slok,$done);
		
      } else {

if (!ClamScanOK($fh,$b)){
    Maillog($fh,'',$SpamVirusLog);
	seterror($fh,$this->{averror},$done);
    return;}
    	$this->{prepend}="[Noprocessing]";
        mlog($fh,"message proxied without processing  - $this->{attachcomment}");
        $Stats{noprocessing}++;
        $b=$this->{header}.$b;
        my $lb=length($b);
        
        ccMail($this->{mailfrom},$sendHamInbound,$b,$this->{rcpt}) if $done;
        

        isnotspam($fh,$done);
        return;
      }
     } elsif (!$this->{attachdone} && $DoBlockExes==1 && ( ($BlockWLExes>=1 && $BlockWLExes<=3 && $b=~('('.$badattachRE[$BlockWLExes].')')) ||
             ($GoodAttach && $BlockWLExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
	  $this->{attachdone} =1; 
	  $ext=substr($1,0,300);
      $ext=~/name\s*=\s*(.*\..*)\s/i;
      $ext=~/name\s*=\s*"(.*\..*)"/i;
      $this->{prepend}="[Attachment]";
      $this->{attachcomment}="bad attachment(white/local/$BlockWLExes): $1";
      $Stats{viri}++;
      delayWhiteExpire($fh);
      my $slok=$this->{allLoveATSpam}==1;
      thisIsSpam($fh,$this->{attachcomment},$wlAttachLog,$AttachmentError,$attachTestMode,$slok,$done);

    } else {

    if (!ClamScanOK($fh,$b)){
    Maillog($fh,'',$SpamVirusLog);
	seterror($fh,$this->{averror},$done);
    return;}
      $SpamProb=0; addSpamProb($fh,1);
      if (!$this->{red} && $redRe &&  $redReRE!="" && $b=~('('.$redReRE.')')) {
  		mlogRe($1,"Red");
  		$this->{red}=1;
  	  }
      my $server=$this->{friend};
      my $fn=Maillog($fh,'',$NonSpamLog); # tell maillog this isn't spam
      $fn='-> '.$fn if !$fn=="";
      $fn="" if !$fileLogging;
      $this->{subject} ="" if !$subjectLogging;
     ccMail($this->{mailfrom},$sendHamInbound,$b,$this->{rcpt}) if $done;
     $this->{prepend}="[Local/White]";
     

     mlog($fh,"local or whitelisted - $this->{attachcomment} $this->{subject} $fn") ;

     isnotspam($fh,$done);

      return;
    }
  }
}


# the message may or may not be spam -- get the body and test it.

sub getbody {
  my($fh,$l)=@_;
  d(27);
  my $this=$Con{$fh};
  my $b=$this->{header}.=$l;
  $this->{data}.=$l;
  my $decodata = decodeMimeWords($this->{data});
  $this->{attachcomment}="(no bad attachments)";
  

  my $subre;
  my $done=$l=~/^\.[\r\n]*$/ || defined($this->{bdata}) && $this->{bdata}<=0;
    d("bd='$this->{bdata}'");

  my $mbytes=$MaxBytes;
  $mbytes=$ClamAVBytes if $ClamAVBytes>$MaxBytes && $CanUseAvClamd && $AvailAvClamd;
  $mbytes=$URIBLBytes  if $URIBLBytes>$mbytes && $ValidateURIBL;
  if( $done || length($b) >=$mbytes) {
  		if (!$this->{red} && $redRe &&  $redReRE!="" && $b=~('('.$redReRE.')')) {
  		mlogRe($1,"Red");
  		$this->{red}=1;
  		}
  		if (!$this->{whitelisted} && $whiteRe && $whiteReRE!="" && $b=~('('.$whiteReRE.')')) {
		mlogRe($1,"White");
      	$this->{whitelisted}=1;
      	}


		$this->{maillength}=length($b);
		my $decob = decodeMimeWords($b);
		
		   if(!$this->{sattachdone} && $SuspiciousAttach &&  $suspiciousattachRE && ($decob=~('('.$suspiciousattachRE.')')  || $b=~('('.$suspiciousattachRE.')') )){
		$this->{sattachdone}=1;
	    $ext=substr($1,0,300);
      	$ext=~/name\s*=\s*(.*\..*)\s/i;
      	$ext=~/name\s*=\s*"(.*\..*)"/i;
      	$this->{prepend}="[Attachment][scoring]";
      	
      	mlog($fh,"suspicious attachment (external): $1") ;
      	
      	pbAdd($fh,$this->{ip},$satValencePB,"SuspiciousAttachment",1 ) if $satValencePB>0 ;
     }
		

      
		if(!$this->{attachdone} && $DoBlockExes>1 && (($BlockExes>=1 && $BlockExes<=3 && $b=~('('.$badattachRE[$BlockExes].')')) ||
         ($GoodAttach && $BlockExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
			$this->{attachdone}=1;
		    $this->{prepend}="[Attachment]";
      		$this->{prepend}="[Attachment][monitoring]" if $DoBlockExes==2;
      		$this->{prepend}="[Attachment][scoring]" if $DoBlockExes==3; 
			
			$ext=substr($1,0,300);
      		$ext=~/name\s*=\s*(.*\..*)\s/i;
      		$ext=~/name\s*=\s*"(.*\..*)"/i;
      		$this->{attachcomment}="bad attachment(external/$BlockExes): $1";
      	
			$Stats{viri}++ if $DoBlockExes==1;
      		delayWhiteExpire($fh) if $DoBlockExes==1;
      		my $slok=$this->{allLoveATSpam}==1 if $DoBlockExes==1;

      		mlog($fh,$this->{attachcomment}) if $DoBlockExes>1;
      		pbAdd($fh,$this->{ip},$baValencePB,"BadAttachment" ) if $baValencePB>0 && $DoBlockExes!=2;
      		thisIsSpam($fh,$this->{attachcomment},$extAttachLog,$AttachmentError,$attachTestMode,$slok,$done) if $DoBlockExes==1;
      		}
      	
      
	
   if(!BombOK($fh,$b,$this->{data})) {
      $bomblt = $bombError;

      $bomblt .= " ( reason: '$this->{messagereason}' ) " if $bombErrorReason;
      $Stats{bombs}++;
      delayWhiteExpire($fh);
      my $slok=$this->{allLoveBoSpam}==1;
       
      thisIsSpam($fh,"BombRe: '$this->{messagereason}'",$spamBombLog,$bomblt,$bombTestMode,$slok,1);
    } elsif(!ScriptOK($fh,$b)) {
      my $slok=$this->{allLoveBoSpam}==1;
      $Stats{scripts}++;
      delayWhiteExpire($fh);
      $bomblt = $scriptError;

      $bomblt .= " ( reason: '$this->{messagereason}' ) " if $bombErrorReason;
      $this->{prepend}="[ScriptRe]"; 
      thisIsSpam($fh,"ScriptRe: '$this->{messagereason}'",$scriptLog,$bomblt,$bombTestMode,$slok,1);


    } elsif(!$this->{attachdone} && $DoBlockExes==1 && (($BlockExes>=1 && $BlockExes<=3 && $b=~('('.$badattachRE[$BlockExes].')')) ||
         ($GoodAttach && $BlockExes==4 && (($decob=~('('.$allattachRE.')') || $b=~('('.$allattachRE.')')) && !($1=~$goodattachRE) )))){
	$this->{attachdone}=1;	
		
      $this->{prepend}="[Attachment]";
      $ext=substr($1,0,300);
      $ext=~/name\s*=\s*(.*\..*)\s/i;
      $ext=~/name\s*=\s*"(.*\..*)"/i;
      $this->{attachcomment}="bad attachment(external/$BlockWLExes): $1"; 
      
      $Stats{viri}++;
      delayWhiteExpire($fh);
      pbAdd($fh,$this->{ip},$baValencePB,"NotGoodAttachment",1 ) if $baValencePB>0;
      my $slok=$this->{allLoveATSpam}==1;
      thisIsSpam($fh,$this->{attachcomment},$extAttachLog,$AttachmentError,$attachTestMode,$slok,$done);
   
    } elsif($this->{spamfound}) {
# Spam is found to be safe, lets pass it on.

      my $fn=Maillog($fh,'',$baysSpamLog);
      $fn='-> '.$fn if !$fn=="";
      $fn="" if !$fileLogging;
      $this->{subject} ="" if !$subjectLogging;
      mlog($fh,"spam determined to be safe, passing on to recipient $this->{subject} $fn");
      delayWhiteExpire($fh);
      isnotspam($fh,$done);    
     } elsif(!URIBLok($fh,$b,$this->{ip})) {
      $Stats{uriblfails}++;
      delayWhiteExpire($fh);
	 } elsif ($DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
	MessageScore($fh);
	 } elsif (!PBOK($fh,$this->{ip})){
      my $slok=$this->{allLovePBSpam}==1;
      $Stats{pbdenied}++ unless $slok;
      $er = $SpamError;      
      $er = $PenaltyError if $PenaltyError;
      
      $this->{prepend}="[Penalty]";
      thisIsSpam($fh,"Penalty - score:$this->{mypbreason} ",$spamPBLog,$er,$pbTestMode,$slok,1,$b);

     } elsif (!ClamScanOK($fh,$b)){
	 $this->{prepend}="[Virus]";	
	 Maillog($fh,'',$SpamVirusLog);
	 seterror($fh,$this->{averror},$done);
	 return;    
    } elsif(isspam($b,$this->{ip})) {
    my $slok=$this->{allLoveBaysSpam}==1;
      $this->{testmode} = ($this->{localuser}==1 || $baysTestMode || ($baysConfidence && $SpamProbConfidence<$baysConfidence));
	  $this->{testmode} = $slok = 0  if allBayesSpamHaters($this->{rcpt});     
    if (($slok || $this->{testmode}) && $DoPenaltyMessage && $PenaltyMessageLimit && $this->{messagescore}>=$PenaltyMessageLimit) {
		MessageScore($fh);
      	return;

   } elsif ($baysTestMode && !PBOK($fh,$this->{ip})){
      my $slok=$this->{allLovePBSpam}==1;
      $Stats{pbdenied}++ unless $slok;
      $er = $SpamError;      
      $er = $PenaltyError if $PenaltyError;

      $this->{myheader}.="X-Assp-Penalty: $this->{mypbreason}\r\n";
      $this->{prepend}="[Penalty]";
      thisIsSpam($fh,"Penalty - score:$this->{mypbreason} ",$spamPBLog,$er,$pbTestMode,$slok,1,$b);
	return;	  
      }

       

      if (!$slok) { $Stats{bspams}++;}
      $this->{myheader}.=sprintf("X-Assp-Bayes-Confidence: %.5f\r\n",$SpamProbConfidence) if $AddSpamProbHeader && $AddConfidenceHeader && $SpamProbConfidence;
		$this->{prepend}="[Bayesian]"; 
      thisIsSpam($fh,'Bayesian Spam',$baysSpamLog,$SpamError,$this->{testmode},$slok,$done);
       
    } else {
        if ($DoPenaltyMessage && $PenaltyMessageLow && $this->{messagescore}>=$PenaltyMessageLow) {
				
		$this->{mypbreason}="Message Limit($PenaltyMessageLimit)" if $this->{messagescore}>=$PenaltyMessageLimit ;

		$this->{messagelow}=1 if $this->{messagescore}>=$PenaltyMessageLow && $this->{messagescore}<$PenaltyMessageLimit;
		$this->{mypbreason}="Message Limit:Low Threshold($PenaltyMessageLow) " if $this->{messagelow};
		my $slok=$this->{allLovePBSpam}==1;
	 	$er = $SpamError;      
      	$er = $PenaltyError if $PenaltyError;
      	
      	$this->{prepend}="[MessageLimit]";
      	delayWhiteExpire($fh);
      	$Stats{msgscoring}++;
      	thisIsSpam($fh,"$this->{mypbreason} ",$spamMSLog,$er,($msTestMode || $this->{messagelow}),$slok,1);
      	return;
   } elsif (!PBOK($fh,$this->{ip})){
      my $slok=$this->{allLovePBSpam}==1;
      $Stats{pbdenied}++ unless $slok;
      $er=$SpamError;
      $er=$PenaltyError if $PenaltyError;

      $this->{myheader}.="X-Assp-Penalty: $this->{mypbreason}\r\n";
      $this->{prepend}="[Penalty]";
      thisIsSpam($fh,"Penalty - score:$this->{mypbreason} ",$spamPBLog,$er,$pbTestMode,$slok,1);
	return;
      }
      my $fn=Maillog($fh,'',$baysNonSpamLog) if $baysNonSpamLog==4 || $baysNonSpamLog==2 ;

      $fn='-> '.$fn if !$fn=="";
      $fn="" if !$fileLogging;
      $this->{subject} ="" if !$subjectLogging;
      $this->{myheader}.=sprintf("X-Assp-Bayes-Confidence: %.5f\r\n",$SpamProbConfidence) if $AddSpamProbHeader && $AddConfidenceHeader && $SpamProbConfidence; 
      addSpamProb($fh,0,1);
      ccMail($this->{mailfrom},$sendHamInbound,$b,$this->{rcpt}) if $done;
      
      $this->{prepend}="[MessageOK]";
      mlog($fh,"message ok $this->{subject} $fn") ;
      $Stats{bhams}++;
      isnotspam($fh,$done);
    }
  }
}
sub checkInfection {
return;
}

# This is spam, lets see if its test mode or spamlover.
sub thisIsSpam {
  my ($fh,$reason,$log,$error,$testmode,$slok,$done)=@_;

  my $this=$Con{$fh};
  d('thisIsSpam');
  addSpamProb($fh,0,1) if $reason =~/bayes/i;
  addSpamProb($fh,0,0) if $reason !~/bayes/i;
  $this->{spamfound}=1; # Set spamfound flag.
  $testmode=1 if $this->{testmode};
  $testmode=$slok=0 if allSpamHaters($this->{rcpt});
  $testmode=1 if $allTestMode;
  


# add to our header; merge later, when client sent own headers
  $this->{myheader}.="X-Assp-Version: $version$modversion\r\n" if $AddSpamHeader;
  $this->{myheader}.="X-Assp-Redlisted: Yes\015\012" if $this->{red};
  $this->{myheader}.="X-Assp-Spam: YES\r\n" if $AddSpamHeader && $testmode!=2;
  $this->{myheader}.="X-Assp-Spam: YES?\r\n" if $AddSpamHeader && $testmode==2;
  $this->{myheader}.="X-Assp-Block: NO (Spamlover)\r\n" if $slok;
  $this->{myheader}.="X-Assp-Block: NO (Testmode)\r\n" if $testmode && !$this->{messagelow};
  $this->{myheader}.="X-Assp-Block: NO (low message threshold:$PenaltyMessageLow)\r\n" if $testmode && $this->{messagelow};
  $this->{myheader}.="$AddCustomHeader\r\n" if $AddCustomHeader;
  $this->{myheader}.="X-Assp-ID: $this->{$msgtime}\r\n";
  $this->{myheader}.="X-Assp-Spam-Reason: ".ucfirst($reason)."\r\n" if $AddSpamReasonHeader;
  $this->{myheader}.="X-Assp-Totalscore: $this->{messagescore}\r\n" if $AddScoringHeader && $this->{messagescore};
 
   if($slok || $testmode || $this->{tagmode} || $this->{spamlover} || $this->{messagelow}) {

    if ($this->{messagelow})  {
      $this->{prepend}.="[low]";
      $this->{saveprepend2}.="[low]";
 mlog($fh,"passing as safe because  messagescore($this->{messagescore}) >= lowthreshold($PenaltyMessageLow)",1);
      
    }elsif($slok || $this->{spamlover}) {
     $this->{prepend}.="[sl]";
     $this->{saveprepend2}.="[sl]";
      mlog($fh,"passing as safe because spamlover(s): $this->{rcpt}, otherwise $reason",1);
     
      $Stats{spamlover}++;
    }elsif($this->{tagmode}) {
     $this->{prepend}.="[tagmode]";
      mlog($fh,"passing as safe because tagmode: $this->{rcpt}, otherwise $reason",1);

    } else {
    $this->{prepend}.="[testmode]";
    $this->{saveprepend2}.="[testmode]";
      mlog($fh,"passing as safe because testmode, otherwise $reason",1);

    }


# pretend it's not spam
    $this->{header}=~s/^($HeaderRe*)/$1From: sender not supplied\r\n/o unless $this->{header}=~/^$HeaderRe*From:/io; # add From: if missing
    $this->{header}=~s/^($HeaderRe*)/$1Subject:\r\n/o unless $this->{header}=~/^$HeaderRe*Subject:/io; # add Subject: if missing
    if ($slok && $spamSubjectSL) {
    } else {
      $this->{header}=~s/^Subject:/Subject: $this->{prepend}/gim if ($spamTag && $this->{prepend} ne "");

      $this->{header}=~s/^Subject:/Subject: $spamSubject/gim if $spamSubject ;
    }
#Lets check if its safe to pass if not already done so.
#Lets check if its safe to pass if not already done so.
    if ($done) {

      my $fn=Maillog($fh,'',$log); # tell maillog what this is.
      $fn='-> '.$fn if !$fn=="";
      $fn="" if !$fileLogging;
      $this->{subject} ="" if !$subjectLogging;
      mlog($fh,"spam determined to be safe, passing on to recipient $this->{subject} $fn");
      delayWhiteExpire($fh);
      isnotspam($fh,$done);
    } else {
      $this->{getline}=\&getbody;
    }
   
  } else {
    my $fn=Maillog($fh,'',$log); # tell maillog what this is.
    $fn='-> '.$fn if !$fn=="";
    $fn="" if !$fileLogging;
    $this->{subject} ="" if !$subjectLogging;	
    mlog($fh,"$reason $this->{subject} $fn");
    delayWhiteExpire($fh);
	$error=$SpamError if $error eq "";
    $error=~s/500/554/i;
    seterror($fh,$error,$done);     
  }
}
# delete whitelisted tuplet
sub delayWhiteExpire {
  return unless ($EnableDelaying && $DelayExpireOnSpam);
  my $fh=shift;
  my $this=$Con{$fh};
  my $a=lc $this->{mailfrom};
# get sender domain
  $a=~s/.*@//;
  my $ip=ipNetwork($this->{ip},($DelayUseNetblocks ? 24 : 32));
  my $hash="$ip $a";
  $hash=Digest::MD5::md5_hex($hash) if $CanUseMD5Keys;
  if ($DelayWhite{$hash}) {
# delete whitelisted (IP+sender domain) tuplet
    mlog($fh,"deleting spamming whitelisted tuplet: ($ip,$a) age: ". formatTimeInterval(time-$DelayWhite{$hash})) if $DelayLog;
    delete $DelayWhite{$hash};
  }
}
# add to penalty box
sub pbAdd {
my($fh,$myip,$score,$reason,$status)=@_;
delayWhiteExpire($fh);
return	if ( $this->{whitelisted});
return	if ($this->{noprocessing}==1);


$this->{myheader}.="X-Assp-Score: $score ($reason)\r\n" if $AddScoringHeader;
mlog($fh,"Message-Score: $this->{messagescore}+$score ($reason) ",1) if $MessageLog && $DoPenaltyMessage==2 && $status!=2;
$this->{messagescore}+=$score if $status!=2;
return	if ($status==1);
return  if ($this->{isbounce} && $DoNotPenalizeBounces);
return  if ($this->{red} && $DoNotPenalizeRed);
return	if ($this->{ispip});
return	if ($this->{nodelay}==1);
return	if !$DoPenalty;
my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
return if (exists $PBWhite{$ip});

pbBlackAdd($myip,$score,$reason) if $status!=1;
}
# find in penalty White list
sub pbWhiteFind {
  return if !$DoPenalty;
  my($myip)=@_;
  return unless ($PBWhiteObject);
  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
  return 1 if (exists $PBWhite{$ip}) ;
}
sub pbBlackAdd {
return if !$DoPenalty ;

my($myip,$score,$reason,$nolog)=@_;
my $t=time;
my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
if (exists $PBBlack{$ip}) {
my($ct,$ut,$freq,$oldscore,$sip,$sreason)=split(" ",$PBBlack{$ip});
$freq++;
my $tdif=$t-$ut;
my $newscore=$oldscore+$score;
my $data="$ct $t $freq $newscore $myip $reason ";
mlog($fh,"PB: $ip score: $oldscore+$score => $newscore reason:$reason ",1) if $PenaltyLog==2;
$PBBlack{$ip}=$data;
$PBBlack{$myip}=$data;
$this->{mypbreason}="$reason";
return;
} else {
my $freq=1;
$this->{mypbreason}="$reason";
my $data="$t $t $freq $score $myip $reason $score";
$PBBlack{$ip}=$data;
$PBBlack{$myip}=$data;
mlog($fh,"PB: $ip score: 0+$score => $score reason:$reason",1) if $PenaltyLog==2;

} 
}
sub pbBlackDelete {
  return if !$DoPenalty;

  my($myip,$score,$reason)=@_;
  return unless ($PBBlackObject);
  my $t=time;
  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
  if (exists $PBBlack{$ip}) {
    delete $PBBlack{$ip};
    delete $PBBlack{$myip};

    mlog($fh,"PB: deleting(black) $myip - $reason") if $PenaltyLog;
  }

}

sub pbBlackClear {
  my($fh,$myip)=@_;
  my $this=$Con{$fh};

  $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));

  delete $PBBlack{$myip};
  delete $PBBlack{$ip};
  return 1;
}

sub pbWhiteAdd {

  my($myip,$reason)=@_;
  my $t=time;
  my $status=2;
  $this->{rwlok}=1;
  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));
  return if ($this->{nodelay});
  return if ($this->{isbounce});
  return if ($this->{mISPRE});

  if (exists $PBWhite{$ip}) {
    my($ct,$ut,$pbstatus)=split(" ",$PBWhite{$ip});

    my $data="$ct $t $status";
    $PBWhite{$ip}=$data;
    $PBWhite{$myip}=$data;

  } else {

   
    my $data="$t $t $status";
    $PBWhite{$ip}=$data;
    $PBWhite{$myip}=$data;
  }
}
 
sub pbWhiteDelete {
$this->{rwlok}=0;
  return if !$DoPenalty;
  my($myip,$score,$reason)=@_;
  my $t=time;
  my $ip=ipNetwork($myip,($PenaltyUseNetblocks ? 24 : 32));

  if (exists $PBWhite{$ip}) {
    delete $PBWhite{$ip};
    delete $PBWhite{$myip};

  } 
}


#
sub RBLCacheAdd {
  my($ip,$rbllists,$status)=@_;
  my $t=time;
  my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);
  $mon++; $year-=100;
  my $mm=sprintf("%02d-%02d-%02d/%02d:%02d",$year,$mon,$mday,$hour,$min);
  my $data="$t $mm $rbllists $status";
  $RBLCache{$ip}=$data;

} 

sub RBLCacheDelete {
  return if !$RBLCacheInterval;
  my($ip)=@_;
  return unless ($RBLCacheObject);
  delete $RBLCache{$ip};

}

sub RBLCacheFind {
  return if !$RBLCacheInterval;
  my($ip)=@_;
  return unless ($RBLCacheObject);
  if (exists $RBLCache{$ip}) {
    return 1;
  }
  return 0;
}

sub URIBLCacheAdd {
return 0 if !$URIBLCacheInterval;
my($mydomain,$status,$mylisted)=@_;

my $t=time;
my $data="$t $status";
$URIBLCache{$mydomain}=$data;
}
sub URIBLCacheFind {
	my($mydomain,$mystatus)=@_;
  	return 0 if !$URIBLCacheInterval;
	return 0 unless ($URIBLCacheObject);
	if (exists $URIBLCache{$mydomain}) {    
	my($ct,$status)=split(" ",$URIBLCache{$mydomain});
	return $status;
	}
 	return 0;
}
sub PTRCacheAdd {
return 0 if !$PTRCacheInterval;
my($myip,$status)=@_;

my $t=time;
my $data="$t $status";
$PTRCache{$myip}=$data;
}
sub PTRCacheFind {
	my($myip,$mystatus)=@_;
  	return 0 if !$PTRCacheInterval;
	return 0 unless ($PTRCacheObject);
	if (exists $PTRCache{$myip}) {    
	my($ct,$status)=split(" ",$PTRCache{$myip});
	return $status;
	}

 	return 0;
}
sub RWLCacheAdd {
return 0 if !$RWLCacheInterval;
my($myip,$status)=@_;

my $t=time;
my $data="$t $status";
$RWLCache{$myip}=$data;
}
sub RWLCacheFind {
	my($myip,$mystatus)=@_;
  	return 0 if !$RWLCacheInterval;
	return 0 unless ($RWLCacheObject);
	if (exists $RWLCache{$myip}) {    
	my($ct,$status)=split(" ",$RWLCache{$myip});
	return $status;
	}

 	return 0;
}
sub MXACacheAdd {
return 0 if !$MXACacheInterval;
my($myip,$status)=@_;

my $t=time;
my $data="$t $status";
$MXACache{$myip}=$data;
}
sub MXACacheFind {
	my($myip,$mystatus)=@_;
  	return 0 if !$MXACacheInterval;
	return 0 unless ($MXACacheObject);
	if (exists $MXACache{$myip}) {    
	my($ct,$status)=split(" ",$MXACache{$myip});
	return $status;
	}

 	return 0;
}
sub SPFCacheAdd {
return 0 if !$SPFCacheInterval;
my($myip,$result)=@_;
my $status=1;
if ($result eq "pass"){
	$status=2;	
	}	

my $t=time;
my $data="$t $status $result";
$SPFCache{$myip}=$data;
return $status;
}
sub SPFCacheFind {
	my($myip,$mystatus)=@_;
  	return 0 if !$SPFCacheInterval;
	return 0 unless ($SPFCacheObject);
	if (exists $SPFCache{$myip}) {    
	my($ct,$status,$result)=split(" ",$SPFCache{$myip});
	return $result;
	}

 	return 0;
}
sub MessageScore  {

	my($fh,$done)=@_;
	my $this=$Con{$fh};

	return if !($DoPenaltyMessage && $PenaltyMessageLimit);
	return if ($this->{messagescore}<$PenaltyMessageLimit);
	
	$this->{mypbreason}="Message Limit" ;
	my $slok=$this->{allLovePBSpam}==1;
	my $er = $SpamError;
	my $isdone=0;      
    $er = $PenaltyError if $PenaltyError;      	
    $this->{prepend}="[MessageLimit]";
    delayWhiteExpire($fh);
    $Stats{msgscoring}++;
    if ($done ||$slok||$msTestMode||$this->{spamlover}||$msTestMode) {
    $isdone=1;
     } 
    thisIsSpam($fh,"$this->{mypbreason} ",$spamMSLog,$er,$msTestMode,$slok,$isdone);
}
# reject the email
sub seterror {
  my($fh,$e,$done)=@_;
  d(28);
  my $this=$Con{$fh};
  $this->{error}=$e;
  if($done) {
    error($fh,".\r\n");
  } else {
    $this->{getline}=\&error;
    $this->{header}=''; # free up some memory
  }
# detatch the friend -- closing connection to server & disregarding message
  done2($this->{friend});
  $this->{friend}=undef;
}

# ignore what's sent & give reason at the end.
sub error {
  my($fh,$l)=@_;
  d(29);
  my $this=$Con{$fh};
  if( $l=~/^\.[\r\n]*$/ || defined($this->{bdata}) && $this->{bdata}<=0) {
    print $fh $this->{error}."\r\n";
    done2($fh);
  }
}

# filter off the 250 OK noop response and go to reply
sub skipok {
  d(291);
  my ($fh,$l)=@_;
  if($l=~/^250/) {
    $Con{$fh}->{getline}=\&reply;
  } else {
    reply(@_);
  }
}

# messages from the server get relayed to the client
sub reply {
  my($fh,$l)=@_;
  d(30);
  my $this=$Con{$fh};
  return unless $this;
  my $cli=$this->{friend};
  return unless $cli;
  $Con{$cli}->{inerror}=$l=~/^5[05][0-9]/;

    if ( $l =~ /250-.*(CHUNKING|PIPELINING|XEXCH50|STARTTLS)/i ) {
        d("$l");
        return;
    }
    elsif ( $l =~ /250 .*(CHUNKING|PIPELINING|XEXCH50|STARTTLS)/i ) {
        d("$l");
        sendque( $cli, "250 NOOP\r\n" );
        return;

        # we'll filter off the chunking directive to avoid BDAT problems.
        # we'll filter off the XEXCH50 service, as it only causes troubles
        # we'll filter off the STARTTLS directive to avoid TLS problems.

    }
    elsif ( $l =~ /^220/ ) {
    sendque($fh,$this->{noop}) if $this->{noop};
    delete $this->{noop};
  } elsif($l=~/^235/) {
# check for authentication response
    $Con{$cli}->{relayok}=1;
        d("$Con{$cli}->{ip}: authenticated");
    mlog($cli,"authenticated") if $ValidateUserLog==2;
  } elsif($l=~/^354/) {
    d(301);
  } elsif($l=~/^50[0-9]/) {
    if($Con{$cli}->{skipbytes}) {
      d("Resetting skipbytes");
      $Con{$cli}->{skipbytes}=0; # if we got a negative response from XEXCH50 then don't skip anything
    }
      if($this->{serverErrors}++ > $MaxErrors) {
      $this->{prepend}="[MaxErrors]";
      mlog($fh,"max errors ($MaxErrors) exceeded -- dropping connection");
      $Stats{msgMaxErrors}++;
      done($fh);
    }
  }
# email report/list interface sends messages itself
  return if (defined($Con{$cli}->{reporttype}) && $Con{$cli}->{reporttype}>=0);
  sendque($cli, $l);
}
#####################################################################################
#                Email Interface

# this mail isn't really a mail -- it's a spam/ham report
sub SpamReport {
 my($fh,$l)=@_;
 my $this=$Con{$fh};
 if( $l=~/^ *DATA/i || $l=~/^ *BDAT (\d+)/i ) {
  if($1) {
   $this->{bdata}=$1;
  } else {
   delete $this->{bdata};
  }
  $this->{getline}=\&SpamReportBody;
  my $report=($this->{reporttype}==0) ? "spam" : "ham";
  sendque($fh,"354 OK Send $report body\r\n");
  return;
 } elsif( $l=~/^ *RSET/i ) {
  stateReset($fh);
  $this->{getline}=\&getline;
  sendque($this->{friend},"RSET\r\n");
  return;
 } elsif( $l=~/^ *QUIT/i ) {
  stateReset($fh);
  $this->{getline}=\&getline;
  sendque($this->{friend},"QUIT\r\n");
  return;
 } elsif( $l=~/^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
  sendque($fh,"504 Need to authenticate first\r\n");
  return;
 }
 sendque($fh,"250 OK\r\n");
}

# we're getting the body of a spam/ham report
sub SpamReportBody {
 my ($fh, $l)=@_;
  $Con{$fh}->{header}.=$l if length($Con{$fh}->{header}) < $ErrorMaxBytes;
  if($l=~/^\.[\r\n]/ || defined($this->{bdata}) && $this->{bdata}<=0) {
  # we're done -- write the file & clean up
  my $this=$Con{$fh};
  my $sub=SpamReportExec($this->{header},($this->{reporttype}==0) ? $correctedspam : $correctednotspam);
  $this->{header}='';
  my $file=($this->{reporttype}==0) ? "reports/spamreport.txt" : "reports/notspamreport.txt";

  ReturnMail($this->{mailfrom},"$base/$file",$sub,"$this->{rcpt}\n\n$this->{report}\n") if ($EmailErrorsReply==1 || $EmailErrorsReply==3);
  ReturnMail($EmailErrorsTo,"$base/$file",$sub,"$this->{rcpt}\n\n$this->{report}\n",$this->{mailfrom}) if ($EmailErrorsTo && ($EmailErrorsReply==2 || $EmailErrorsReply==3));

  stateReset($fh);
  $this->{getline}=\&getline;
  sendque($this->{friend},"RSET\r\n");
 }
}

sub SpamReportExec {
 my ($bod,$path)=@_;
 my $header;
 my ($sub)=$bod=~/Subject: (.*)/i;
 $sub=~s/^.*\]\s//gi;
 $sub=~s/^fwd.\s//gi;
 $sub=~s/^fw.\s//gi;
 $sub=~s/^aw.\s//gi;
 $sub=~s/^re.\s//gi;
 $sub=decodeMimeWords($sub);
  # remove the spam subject header addition if present
 my $spamsub=$spamSubject;
  if($spamsub) {
  $spamsub=~s/(\W)/\\$1/g;
  $sub=~s/$spamsub//gi;
 } 
 $sub=~s/\r//;
 
 $header="Subject: ".$sub."\n" if $sub;
    $sub =~ y/a-zA-Z0-9/_/cs;
 $header.=$1."\n" if $bod=~/(Received: from.*?\(\[[0-9\.]+.*?helo=.*\))/i; 
 
 $header.=$1 if $bod=~/(X-Assp-ID: .*)/i;

 $header.=$1 if $bod=~/(X-Assp-Tag: .*)/i;
 
 $header.=$1 if $bod=~/(X-Assp-Envelope-From: .*)/i;
 
 $header.=$1 if $bod=~/(X-Assp-Intended-For: .*)/i;
 
 $bod=~s/^.*?\n\r?\n\s*//s;

 $bod=~s/X-Assp-Spam-Prob: .*\n//gi;
 if($bod=~/\nReceived: /) {
  $bod=~s/^.*?\nReceived: /Received: /s;
 } else {
  $bod=~s/^.*?\n((\w[^\n]*\n)*Subject:)/$1/si;
  $bod=~s/\n> /\n/g;
 }
  $bod=$header.$bod;
 #$sub=~y/a-zA-Z0-9/_/cs;


 my $f=int(rand()*100);

 open(F,">$base/$path/$sub-$f.rpt"); binmode F;
 print F $bod;
 close F;
 $sub;
}

# we're receiving an email to manipulate addresses in the whitelist/redlist
sub ListReport {
    my ( $fh, $l ) = @_;
    my $this = $Con{ $fh };
    if ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{ bdata } = $1;
        }
        else {
            delete $this->{ bdata };
        }
        sendque( $this->{ friend }, "RSET\r\n" );    # make sure to reset the pending email
        $this->{ getline } = \&ListReportBody;
        my $list;
        $list = ( ( $this->{ reporttype } & 4 ) == 0 ) ? "whitelist" : "redlist" if !$EmailErrorsModifyWhite;
        $list = "spam" if $EmailErrorsModifyWhite && $this->{ reporttype } == 0;
        $list = "ham"  if $EmailErrorsModifyWhite && $this->{ reporttype } == 1;
        sendque( $fh, "354 OK Send $list body\r\n" );
        return;
    }
    elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);
        $this->{ getline } = \&getline;
        sendque( $this->{ friend }, "RSET\r\n" );
        return;
    }
    elsif ( $l =~ /^ *QUIT/i ) {
        stateReset($fh);
        $this->{ getline } = \&getline;
        sendque( $this->{ friend }, "QUIT\r\n" );
        return;
    }
    elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
        sendque( $fh, "504 Need to authenticate first\r\n" );
        return;
    }
    else {

        # more recipients ?
        while ( $l =~ /($EmailAdrRe\@$EmailDomainRe)/og ) {
            next if $1 == $this->{ mailfrom };
            ListReportExec( $1, $this );
            $this->{ rcpt } .= "$1 ";
        }


    }
    sendque( $fh, "250 OK\r\n" );
} ## end sub ListReport

# we're receiving an email to send help instructions
sub HelpReport {
 my($fh,$l)=@_;
 my $this=$Con{$fh};
 if( $l=~/^ *DATA/i || $l=~/^ *BDAT (\d+)/i ) {
  if($1) {
   $this->{bdata}=$1;
  } else {
   delete $this->{bdata};
  }
  sendque($this->{friend},"RSET\r\n"); # make sure to reset the pending email
  $this->{getline}=\&ListReportBody;

  sendque($fh,"354 OK Send help body\r\n");
  return;
 } elsif( $l=~/^ *RSET/i ) {
  stateReset($fh);
  $this->{getline}=\&getline;
  sendque($this->{friend},"RSET\r\n");
  return;
 } elsif( $l=~/^ *QUIT/i ) {
  stateReset($fh);
  $this->{getline}=\&getline;
  sendque($this->{friend},"QUIT\r\n");
  return;
 } elsif( $l=~/^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
  sendque($fh,"504 Need to authenticate first\r\n");
  return;
 } else {
  # more recipients ?
  while ($l=~/($EmailAdrRe\@$EmailDomainRe)/og) {
   ListReportExec($1,$this);
   $this->{rcpt}.="$1 ";
  }
  
   
 }
 sendque($fh,"250 OK\r\n");
}

# we're getting the body of a whitelist/redlist report
sub ListReportBody {
 my($fh,$l)=@_;
 my $sub;

  $Con{$fh}->{header}.=$l if length($Con{$fh}->{header}) < $ErrorMaxBytes;
  my $this=$Con{$fh};
 if($l=~/^\.[\r\n]/ || defined($this->{bdata}) && $this->{bdata}<=0) {
  # we're done -- write the file & clean up

  my $file=($this->{reporttype}==2) ? "reports/whitereport.txt" :

		   ($this->{reporttype}==1) ? "reports/notspamreport.txt" :
		   ($this->{reporttype}==0) ? "reports/spamreport.txt" :
           ($this->{reporttype}==3) ? "reports/whiteremovereport.txt" :
           ($this->{reporttype}==4) ? "reports/redreport.txt" :
           ($this->{reporttype}==7) ? "reports/helpreport.txt" :
                                      "reports/redremovereport.txt";

  $sub=SpamReportExec($this->{header},$correctedspam) if $this->{reporttype}==0 ;
  $sub=SpamReportExec($this->{header},$correctednotspam) if $this->{reporttype}==1 ;

  # mail summary report
          if ( $this->{ reporttype } == 3 || $this->{ reporttype } == 2 ) {
  
              ReturnMail( $this->{ mailfrom }, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n" )
                  if ( $EmailWhitelistReply == 1 || $EmailWhitelistReply == 3 );
  
              ReturnMail(
                  $EmailWhitelistTo, "$base/$file", '',
                  "$this->{rcpt}\n\n$this->{report}\n",
                  $this->{ mailfrom }
              ) if ( $EmailWhitelistTo && ( $EmailWhitelistReply == 2 || $EmailWhitelistReply == 3 ) );
          }
          elsif ( $this->{ reporttype } == 4 || $this->{ reporttype } == 5 ) {
              ReturnMail( $this->{ mailfrom }, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n" )
                  if ( $EmailRedlistReply == 1 || $EmailRedlistReply == 3 );
  
              ReturnMail( $EmailRedlistTo, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n", $this->{ mailfrom } )
                  if ( $EmailRedlistTo && ( $EmailRedlistReply == 2 || $EmailRedlistReply == 3 ) );
          }
          elsif ( $this->{ reporttype } == 0 || $this->{ reporttype } == 1 ) {
              ReturnMail( $this->{ mailfrom }, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n" )
                  if ( $EmailErrorsReply == 1 || $EmailErrorsReply == 3 );
              ReturnMail( $EmailErrorsTo, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n", $this->{ mailfrom } )
                  if ( $EmailErrorsTo && ( $EmailErrorsReply == 2 || $EmailErrorsReply == 3 ) );
          }
          elsif ( $this->{ reporttype } == 7 ) {
              ReturnMail( $this->{ mailfrom }, "$base/$file", 'ASSP-Help', "$this->{rcpt}\n\n$this->{report}\n" );
          }
  
          delete $this->{ report };
          stateReset($fh);
          $this->{ getline } = \&getline;
        sendque( $this->{ friend }, "RSET\r\n" );
 } elsif($l=~/message-id:/i || $l=~/from:.*?$this->{mailfrom}/i) {
  # ignore
 } else {
  while ($l=~/($EmailAdrRe\@$EmailDomainRe)/go) {
   ListReportExec($1,$this);
  }
  
 }
}

sub ListReportExec {
 my ($a,$this)=@_;
    my $ea
        = ( $this->{ reporttype } == 0 ) ? "$EmailSpam\@"
        : ( $this->{ reporttype } == 1 ) ? "$EmailHam\@"
        : ( $this->{ reporttype } == 2 ) ? "$EmailWhitelistAdd\@"
        : ( $this->{ reporttype } == 3 ) ? "$EmailWhitelistRemove\@"
        : ( $this->{ reporttype } == 4 ) ? "$EmailRedlistAdd\@"
        : ( $this->{ reporttype } == 7 ) ? "$EmailHelp\@"
        :                                  "$EmailRedlistRemove\@";
 return unless $a=~/($EmailAdrRe\@)($EmailDomainRe)/;
 return if  $a=~/\=/ && !$EmailAllowEqual;
 $a=~s/^\'//;
 $a=~s/^title.3D//;
 $a=~/^(.*)@/;
 return if !$1;
    return if $a =~ /$EmailRedlistAdd/i;
    return if $a =~ /$EmailRedlistRemove/i;
    return if $a =~ /$EmailWhitelistAdd/i;
    return if $a =~ /$EmailWhitelistRemove/i;
    return if $a =~ /\.(jpg|gif)\@/;
    return if $a =~ /\*\*/;
 return if lc $a eq lc $this->{mailfrom};
 

 return if lc $1 eq lc $ea && localmail($a);
 return if $this->{reporttype}==7;
 return if  $a=~('('.$ESOKRE.')');
 return if  $a=~/$EmailFrom/i;
 my $t=time;
 my $redlist="Redlist";
 my $list=(($this->{reporttype} & 4)==0) ? "Whitelist" : "Redlist";
 if ($this->{reporttype}==3 ||  $this->{reporttype}==0 ||  $this->{reporttype}==5) {
  # deletion

  if($list->{lc $a}) {
   delete $list->{lc $a};
   $this->{report}.="$a: deleted from ".lc $list."\n";
   
   mlog($fh,"email ".lc $list." deletion: $a");
   
   # we're adding to redlist
  if (($this->{reporttype}==2 || $this->{reporttype}==1 || $this->{reporttype}==4)  && $EmailWhiteRemovalToRed) {
if ($redlist->{lc $a}) {
   $redlist->{lc $a}=$t;
   if (eval($this->{report}!~"$a: added to")) {
   $this->{report}.="$a: already on ".lc $redlist."\n";}
   } else {
   $redlist->{lc $a}=$t;
   $this->{report}.="$a: added to ".lc $redlist."\n";
   mlog($fh,"email ".lc $redlist." addition: $a");
   } } 
 # ###################
   
  } else {if (($this->{reporttype}==3 || $this->{reporttype}==0 || $this->{reporttype}==5))  {} else {
   $this->{report}.="$a: not on ".lc $list."\n";
  # mlog($fh,"email ".lc $list." miss on deletion: $a");
  }}
  

   my $mf=$a;
   my $mfd = $1 if $mf=~/\@(.*)/;
   my $mfdd = $1 if $mf=~/(\@.*)/;
   my $alldd = "_all_$mfdd";

   if ($noProcessing) {
    if($mf=~$NPREL) { 
                    $this->{report}.="\n$mf is on No-Processing-list\n\n";
                    PrintAdminInfo("email $mf is in No-Processing-list");
                    } 
    if($mfdd=~$NPREL) { 
                    $this->{report}.="\n$mfdd is on No-Processing-list\n\n";
                    PrintAdminInfo("email $mfdd is in No-Processing-list");
                    }
    }
    if ($npRe) {
   		if($mf=~$npReRE) { 
   		$this->{report}.="\n$mf is in NoProcessing-Regex\n\n"; 
   		PrintAdminInfo("email $mf is in NoProcessing-Regex"); 
   		} 
    }
    if($noProcessingDomains && $mfdd=~$NPDRE){
    	$this->{report}.="\n$mfdd is on NoProcessingDomain-List\n\n";
    	PrintAdminInfo("email $mfdd is on NoProcessingDomain-List");	
	}
	if ($Whitelist{$alldd}) {
		$this->{report}.="\n$alldd is on Whitelist\n\n";
		PrintAdminInfo("email $alldd is on Whitelist");	
		}
	if($whiteListedDomains && $mfdd=~$WLDRE) {
		$this->{report}.="\n$mfdd is on Whitedomain-List\n\n";
		PrintAdminInfo("email $mfdd is on Whitedomain-List");
		}
 } else {
  # addidtion
  if($list->{lc $a} ) {
   $list->{lc $a}=$t;
   if ($this->{report}!~"$a: already on " && $this->{report}!~"$a: added to ") {
   $this->{report}.="$a: already on ".lc $list."\n" ;}
  # mlog($fh,"email ".lc $list." renewal: $a");
  } elsif(localmail($a) && ($this->{reporttype}==2 || $this->{reporttype}==1 || $this->{reporttype}==4)) {} elsif($list eq 'Whitelist' && $Redlist{lc $a}) {
   		if ($this->{report}!~"$a: cannot add redlisted users to whitelist") {
  		$this->{report}.="$a: cannot add redlisted users to whitelist\n" ;
  		mlog($fh,"email whitelist addition denied: $a on redlist") ;
		}
  } else {
   $list->{lc $a}=$t;
   $this->{report}.="$a: added to ".lc $list."\n";
   
   mlog($fh,"email ".lc $list." addition: $a");
  }
 }
}


sub ReturnMail {
return if $NoHaiku;
 my($from,$file,$sub,$bod,$user)=@_;
  my $destination;
 if ($smtpReportServer ne '') {
 $destination = $smtpReportServer;
 }else{
 $destination = $smtpDestination;
 }

$AVa = 0; 
foreach $destinationA (split(/\|/, $destination)) { 
if ($destinationA =~ /^(__INBOUND__:)?(\d+)$/){
$localip = '127.0.0.1';
$destinationA = $localip .':'.$2;
 }
if ($AVa<1) { 
$s=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2); 
if($s) { 
$AVa=1; 
$destination=$destinationA;
} 
else { 
mlog('',"*** $destinationA didn't work, trying others...") if $SessionLog; 
} 
} 
 
}
  if(! $s) {
  mlog('',"couldn't create server socket to $destination -- aborting ReturnMail connection");
  return;
 }
 addfh($s,\&RMhelo);
 my $this=$Con{$s};
 $this->{to}=$from;
 $this->{from}=$EmailFrom;
 open(F,"<$file") || mlog(0,"couldn't open '$file' for mail report");
 local $/="\n";
 my $subject=<F>;
 $subject=~s/\s*(.*)\s*/$1 $sub/;
 $this->{subject}=$subject;
 undef $/;
 $this->{body}="Report from: $user\n" if $user;
$this->{body}.=<F>.$bod;
 close F;
 $this->{body}=~s/\r?\n/\r\n/g;
 $this->{subject}=~s/\r?\n?//g;
my $spamsub=$spamSubject;
 if($spamsub) {
  $spamsub=~s/(\W)/\\$1/g;
  $this->{subject}=~s/$spamsub *//gi;
 }

}

sub AdminReportMail {

 my($sub,$bod,$to)=@_;
 return if !$to;
 my $destination;
 if ($smtpReportServer ne '') {
 $destination = $smtpReportServer;
 }else{
 $destination = $smtpDestination;
 }

$AVa = 0; 
foreach $destinationA (split(/\|/, $destination)) { 
if ($destinationA =~ /^(__INBOUND__:)?(\d+)$/){


     $localip = '127.0.0.1';

   $destinationA = $localip .':'.$2;
 }
if ($AVa<1) { 
$s=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2); 
if($s) { 
$AVa=1; 
$destination=$destinationA;
} 
else { 
mlog('',"*** $destinationA didn't work, trying others...") if $SessionLog; 
} 
} 
 
}
  if(! $s) {
  mlog('',"couldn't create server socket to $destination -- aborting  connection adminreport ");
  return;
 }
 addfh($s,\&RMhelo);
 my $this=$Con{$s};
 $this->{to}=$to;
 $this->{from}=$EmailFrom;

 local $/="\n";
 
 $this->{subject}=$sub;
 $this->{subject}=~s/\r?\n?//g;
 undef $/;
 
 $this->{body}=$bod;
 
}

sub RMhelo { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"helo Expected 220, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})");
 } elsif($l=~/^ *220 /) {
  sendque($fh,"HELO $myName\r\n");
  $Con{$fh}->{getline}=\&RMfrom;
 }
}
sub RMfrom { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"from Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"MAIL FROM: ".($Con{$fh}->{from}=~/(<[^<>]+>)/?$1:$Con{$fh}->{from})."\r\n");
  $Con{$fh}->{getline}=\&RMrcpt;
 }
}
sub RMrcpt { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"rcpt Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"RCPT TO: <$Con{$fh}->{to}>\r\n");
  $Con{$fh}->{getline}=\&RMdata;
 }
}
sub RMdata { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"data Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"DATA\r\n");
  $Con{$fh}->{getline}=\&RMdata2;
 }
}
sub RMdata2 { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"data2 Expected 354, got: $l");
 } elsif($l=~/^ *354 /) {
  my $date=$UseLocalTime ? localtime() : gmtime();
  my $tz=$UseLocalTime ? tzStr() : '+0000';
  $date=~s/(\w+) +(\w+) +(\d+) +(\S+) +(\d+)/$1, $3 $2 $5 $4/;
  my $this=$Con{$fh};
  sendque($fh,<<EOT);
From: $this->{from}\r
To: $this->{to}\r
Subject: $this->{subject}\r
X-Assp-Report: YES\r
Date: $date $tz\r
\r
$this->{body}\r
.\r
EOT
  $Con{$fh}->{getline}=\&RMdone;
 }
}
sub RMdone { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  RMabort($fh,"done Expected 250, got: $l");
 } elsif($l=~/^ *250 /) {
  done2($fh); # close and delete
 }
}
sub RMabort {mlog(0,"RMabort: $_[1]"); done2($_[0]);}

###########################################
#####################################################################################
sub ccMail {
 my($from,$to,$bod,$rcpt)=@_;
 return if !$sendHamInbound && !$sendHamOutbound;
 if ($sendHamOutbound && $this->{relayok} && (!$ccHamFilter || allccHamFilter($rcpt,$from))) {
 $to=$sendHamOutbound;
 } elsif($sendHamInbound && !$this->{relayok} && (!$ccHamFilter || allccHamFilter($rcpt,$from))) {
 $to=$sendHamInbound;
 } else {
 return;
 }
 my $sub=substr($bod,0,50);

 #return if($sub!~/Received/i);
 
 $to =~/($EmailAdrRe)\@($EmailDomainRe)/;
 my ($current_username,$current_domain) = ($1,$2);
 my $cchamlt = $sendHamInbound;
 $cchamlt =~ s/USERNAME/$current_username/g;
 $cchamlt =~ s/DOMAIN/$current_domain/g;
 my $destination;
  if ($sendAllHamDestination ne '') {
 $destination = $sendAllHamDestination;
 } elsif ($sendAllDestination ne '') {
 $destination = $sendAllDestination;
 } else {
 $destination = $smtpDestination;
 }
$AVa = 0; 
foreach $destinationA (split(/\|/, $destination)) { 
if ($destinationA =~ /^(__INBOUND__:)?(\d+)$/){
	$localip = '127.0.0.1';
	$destinationA = $localip .':'.$2;
 }
if ($AVa<1) { 
$s=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2); 
if($s) { 
$AVa=1; 
$destination=$destinationA;
} 
else { 
mlog('',"*** $destinationA didn't work, trying others...") if $SessionLog; 
} 
} 
 
}
  if(! $s) {
  mlog('',"couldn't create server socket to $destination -- aborting  connection ccmail");
  return;
 }
 addfh($s,\&CChelo);
 my $this=$Con{$s};
 $this->{to}=$to;
 $this->{from}=$from;

 local $/="\n";
 
 $this->{subject}=$sub;
 $this->{subject}=~s/\r?\n?//g;
 undef $/;
 
 $this->{body}=$bod;
}

sub CChelo {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "helo Expected 220, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
    }
    elsif ( $l =~ /^ *220 / ) {
        sendque( $fh, "HELO $myName\r\n" );
        $Con{ $fh }->{ getline } = \&CCfrom;
    }
}

sub CCfrom {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "HELO send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
    }
    elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "MAIL FROM: " . ( $Con{ $fh }->{ from } =~ /(<[^<>]+>)/ ? $1 : "<$Con{$fh}->{from}>" ) . "\r\n" );
        $Con{ $fh }->{ getline } = \&CCrcpt;
    }
}

sub CCrcpt {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "MAIL FROM send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
    }
    elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "RCPT TO: <$Con{$fh}->{to}>\r\n" );
        $Con{ $fh }->{ getline } = \&CCdata;
    }
}

sub CCdata {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "RCPT TO send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
    }
    elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "DATA\r\n" );
        $Con{ $fh }->{ getline } = \&CCdata2;
    }
}
sub CCdata2 {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "DATA send, Expected 354, got: $l" );
    }
    elsif ( $l =~ /^ *354 / ) {
        sendque( $fh, $this->{ body } ) if $this->{ body };
        sendque( $fh, "\r\n.\r\n" )     if ( $this->{ body } !~ /[\n\r]\.[\n\r]+$/ );
        $Con{ $fh }->{ getline } = \&CCdone;
    }
}
sub CCdone {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "done Expected 250, got: $l" );
    }
    elsif ( $l =~ /^ *250 / ) {
        done2($fh);    # close and delete
    }
}
sub CCabort { mlog( 0, "CCabort: $_[1]" ); done2( $_[0] ); }

#####################################################################################
#                SPAM Detection

# check if the message is spam, based on Bayesian factors in $Spamdb
#####################################################################################
#                SPAM Detection

# check if the message is spam, based on Bayesian factors in $Spamdb
sub isspam {

my $msg=$_[0];
local $b=clean($_[0]);
my $ip=$_[1];

return $SpamProb=0 if $this->{whitelisted};
return $SpamProb=0 if $this->{noprocessing}==1;
if ($noBayesian &&  $NBRE!=""  && $this->{mailfrom}=~('('.$NBRE.')')) {
 mlogRe($1,"NoBayes");
 return $SpamProb=0;} 

  if(!$this->{spamlover} && $slRe && $slReRE!="" && ($msg=~('('.$slReRE.')') || $b=~('('.$slReRE.')'))) {
 mlogRe($1,"SpamLover");
 $this->{spamlover}=1;
 }
 if($whiteRe  && $whiteReRE!="" && ($msg=~('('.$whiteReRE.')') || $b=~('('.$whiteReRE.')'))) {
 mlogRe($1,"White");
 return $SpamProb=0;
 }
 if($blackRe  && $blackReRE!="" && ($msg=~('('.$blackReRE.')') || $b=~('('.$blackReRE.')'))) {
 mlogRe($1,"Black");
 return $SpamProb=0 if $DoBayesian==2;
 pbAdd($fh,$ip,$blackValencePB,"BlackRe",1 ) if $blackValencePB>0;
 return $SpamProb=0 if $DoBayesian==3;
 return $SpamProb=1;
 }  
 
 # no Bayesian check
 return $SpamProb=0 if !$DoBayesian; 
 
  my $tlit;
  $tlit="monitoring" if $DoBayesian==2;
  $tlit="scoring" if $DoBayesian==3;
  $this->{prepend}="[Bayesian]";
  $this->{prepend}.="[$tlit]" if $DoBayesian>=2;
  
 my $myip=ipNetwork($ip,($PenaltyUseNetblocks ? 24 : 32)); 
 my $ip=$_[1];
 d(31);
 my $ip3=$ip;
 $ip3=~s/(\d+\.\d+\.\d+).*/$1/;
 my ($v,$lt,$t,%seen);
 my @t;
 #if(defined($Dnsbl{$ip}) || defined($Dnsbl{$ip3})) {
 # mlog('',"$ip dnsbl hit");
 # push(@t,0.97);
 # push(@t,0.97);
 #}
 my $myip=ipNetwork($ip,($PenaltyUseNetblocks ? 24 : 32)); 
if (exists $PBBlack{$myip}){

  push(@t,0.97);
  push(@t,0.97);
 }
if ($this->{localuser}==1){

  push(@t,0.03);
  push(@t,0.03);
 }
 if($griplist) {
  if ($ispip && $ip=~$ISPRE) {
   if ($ispgripvalue) {
    $v=$ispgripvalue;
   } else {
    $v=$Griplist{x};
   }
  } else {
   $v=$Griplist{$ip3} || $Griplist{x};
  }
  d("gl=$v <$Griplist{$ip3}>\n");
  push(@t,$v,$v) if $v;
 }
 while($b=~/([-\$A-Za-z0-9\'\.!\240-\377]+)/g) {
  next if length($1) > 20;
 $lt=$t; $t=lc $1;
  $t=~s/[,.']+$//; $t=~s/!!!+/!!/g; $t=~s/--+/-/g;
  my $j="$lt $t";
  next if $seen{$j}++ >1; # first two occurances are significant
  push(@t,$v) if ($v=$Spamdb{$j});
 }
 @t=sort {abs($b-.5)<=>abs($a-.5)} @t;
 @t=@t[0..30];
 my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p);}}
 $SpamProb=$p1/($p1+$p2);
 #$SpamProbConfidence=(1+$p1-$p2)/2;
 $SpamProbConfidence=abs($p1-$p2);
 if ($baysConfidence) {
 mlog($fh, sprintf("Bayesian Check $tlit - Prob: %.5f / Confidence: %.5f => %s.%s", $SpamProb,    $SpamProbConfidence, $SpamProbConfidence<$baysConfidence?"doubtful":"confident", ($SpamProb<.6)?"ham":"spam")) if $BayesianLog || $DoBayesian>=2; 
 } else {
 mlog($fh, sprintf("Bayesian Check $tlit - Prob: %.5f => %s", $SpamProb, ($SpamProb<.6)?"ham":"spam")) if $BayesianLog || $DoBayesian>=2;
 }
 return $SpamProb=0 if $DoBayesian==2;
 if ($SpamProb>=.6)  { pbAdd($fh,$this->{ip},($baysConfidence && $baysConfidenceHalfScore && $SpamProbConfidence<$baysConfidence)?$baysValencePB/2:$baysValencePB,"Bayesian",$DoBayesian) if $baysValencePB>0;}
return 0 if ($NoTagInTestmode && $SpamProb>=.6 && $baysTestMode && $SpamProbConfidence<$baysConfidence);
return $SpamProb=0 if $DoBayesian==3;
return $SpamProb<.6? 0: 1;
}
# attach a header line to the message if the config option is set
sub addSpamProb {

 my ($fh,$wl,$sp)=@_;
 my $this=$Con{$fh};
 my $spamprobheader="";
 return if $NoExternalSpamProb && $this->{relayok};
 $spamprobheader=sprintf("X-Assp-Spam-Prob: %.5f\r\n",$SpamProb) if  $sp && $AddSpamProbHeader;


 $this->{header}=~s/^X-Assp-Spam-Prob:$HeaderValueRe//gimo; # clear out existing X-Assp-Spam-Prob headers
 $this->{header}=~s/^X-Assp-Bayes-Confidence:$HeaderValueRe//gimo; # clear out existing X-Assp-Spam-Prob headers
 if ($wl) {
  $spamprobheader.="X-Assp-Whitelisted: Yes\r\n";
  $this->{header}=~s/^X-Assp-Whitelisted:$HeaderValueRe//gimo; # clear out existing X-Assp-Whitelisted headers
 }
  my $counter=0;
  my $stars="";
  $CustomizeStars=5 if !$CustomizeStars;
if ($this->{messagescore} && $AddLevelHeader) {
while ($counter<int($this->{messagescore}/$CustomizeStars)) {
$counter++;
$stars.= "*";
 } 
   $spamprobheader.="X-Assp-Spam-Level: $stars\r\n" ; 
 }

  my $strippedTag=$this->{prepend};
  $this->{saveprepend}=$this->{prepend};
  $strippedTag=~s/\[//;
  $strippedTag=~s/\]//;
  $spamprobheader.="X-Assp-Tag: $strippedTag\r\n" if $this->{prepend} && $tagLogging;
 if (defined($this->{mailfrom})) {
  $spamprobheader.="X-Assp-Envelope-From: $this->{mailfrom}\r\n";
  $this->{header}=~s/^X-Assp-Envelope-From:$HeaderValueRe//gimo; # clear out existing X-Assp-Envelope-From headers
 }
if ($AddIntendedForHeader) {
  $spamprobheader.="X-Assp-Intended-For: $this->{rcpt}\r\n";
  $this->{header}=~s/^X-Assp-Intended-For:$HeaderValueRe//gimo; # clear out existing X-Assp-Envelope-From headers
 }
 # add to our header; merge later, when client sent own headers
 $this->{myheader}.=$spamprobheader;
}
# compile the nonprocessing domains regular expression
sub setNPDRE {
 my $new=shift;
 $new||='^(?!)'; # regexp that never matches
 SetRE('NPDRE',"($new)\$",'i','NopnProcessing Domains');
}
# compile the whitelisted domains regular expression
sub setWLDRE {
 my $new=shift;
 $new||='^(?!)'; # regexp that never matches
 SetRE('WLDRE',"($new)\$",'i','Whitelisted Domains');
}

# compile the blacklisted domains regular expression
sub setBLDRE {
 my $new=shift;
 $new||='^(?!)'; # regexp that never matches
 SetRE('BLDRE1',"($new)\$",'i','Blacklisted Domains');
 SetRE('BLDRE2',"($new) ",'i','Blacklisted Domains');
}

# compile the regular expression for the list of two-level country code TLDs
sub setURIBLCCTLDSRE {
 my $s=join('|',@_);
 $s||='^(?!)'; # regexp that never matches
 SetRE('URIBLCCTLDSRE',"([^\\.]+\\.($s))\$",'i','Country Code TLDs');
}

# compile the URIBL whitelist regular expression
sub setURIBLWLDRE {
 my $new=shift;
 $new||='^(?!)'; # regexp that never matches
 SetRE('URIBLWLDRE',"^($new)\$",'i','Whitelisted URIBL Domains');
}
# compile the Max IP/Domain whitelist regular expression
sub setIPDWLDRE {
 my $new=shift;
 $new||='^(?!)'; # regexp that never matches
 SetRE('IPDWLDRE',"^($new)\$",'i','Whitelisted IP/Domain Domains');
}
sub setNURIBLRE {

  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
    if($a=~/\S\@\S/) {
      push(@uad,$a);
    } elsif( $a=~/^\@/ ) {
      push(@d,$a);
    } else {
      push(@u,$a);
    }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('NURIBLRE',$s,'i',"No URIBL");
}
sub setLAFRE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
   if($a=~/\S\@\S/) {
    push(@uad,$a);
   } elsif( $a=~/^\@/ ) {
    push(@d,$a);
   } else {
    push(@u,$a);
   }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('LAFRE',$s,'i',"LocalAddresses");
}

sub setIARE {
  my (@uad, @u, @d);
  foreach $a (split(/\|/,$_[0])) {
   if($a=~/\S\@\S/) {
    push(@uad,$a);
   } elsif( $a=~/^\@/ ) {
    push(@d,$a);
   } else {
    push(@u,$a);
   }
  }
  my @s;
  push(@s,'^('.join('|',@uad).')$') if @uad;
  push(@s,'^('.join('|',@u).')@') if @u;
  push(@s,'('.join('|',@d).')$') if @d;
  my $s=join("|",@s);
  $s='<not a valid list>' unless $s;
  SetRE('IARE',$s,'i',"InternalAddresses");
}

# see if the address in the mailfrom is on the whitelist meanwhile update the whitelist if that seems appropriate
sub onwhitelist {
 my($fh,$header,$a)=@_;
 d(32);
 my $this=$Con{$fh};
 $a=lc $this->{mailfrom};
 
 my $whitelisted=$this->{relayok};
 $Stats{locals}++ if $whitelisted;
 return $whitelisted unless $a; # don't add to the whitelist unless there's a valid envelope -- prevent bounced mail from adding to the whitelist
if (!$this->{red} && $redRe &&  $redReRE!="" && $header=~('('.$redReRE.')')) {
 mlogRe($1,"Red");
 $this->{red}=1;}
 mlogRe($a,"Redlist") if !$this->{red} && $Redlist{$a};
 $this->{red}=1 if $Redlist{$a};

 my %senders;
 unless($whitelisted) {
  $senders{$a}=1;
  if(! $NotGreedyWhitelist) {
   while($header=~/\n(from|sender|reply-to|errors-to|list-\w+):.*?($EmailAdrRe\@$EmailDomainRe)/igo) {
    $senders{lc $2}=1;
   }
  }
  foreach $a (keys %senders) {
   return 0 if $a && $Redlist{$a};
   next if localmail($a) || $a eq '';
   if($whiteListedDomains && $a=~('('.$WLDRE.')')) {
    d("wld");
    $whitelisted=1;
     mlog($fh,"Whitelisted Domain: $1");
    last;
   } elsif($Whitelist{$a}) {
    d("on whitelist");
    $whitelisted=1;
    last;
   }
  }
  $this->{senders}=join(' ',keys %senders)." "; # used for finding blacklisted domains
  if ($whitelisted) {
  $Stats{whites}++; 
  }
  
 }
 # don't add to whitelist if sender is redlisted
 return $whitelisted if $this->{red} || $WhitelistLocalOnly && !$this->{relayok} || $WhitelistLocalFromOnly && !localmail($this->{mailfrom});
 if($whitelisted) {
  # keep the whitelist up-to-date
  my %a=%senders;
  my $t=time;
  $a{$a}=1;
  $header=~s/\n\s+/ /g;
  while($header=~/\n(to|cc): (.*)/ig) {
   my $a=$2;
   while($a=~/($EmailAdrRe\@$EmailDomainRe)/go) {
    $a{lc $1}=1;
   }
  }
  foreach $a (split(' ',lc $this->{rcpt})) {
   $a{$a}=1;
  }
  foreach $a (keys %a) {
   next if localmail($a) || ! $a;
   next if $Redlist{$a}; # don't add to whitelist if rcpt is redlisted
   next if $a=~/\=/ && !$EmailAllowEqualChar;
   next if $a=~s/^\'//;
   
   #next if $whiteListedDomains && $a=~$WLDRE;

   mlog($fh,"whitelist addition: $a") unless $Whitelist{$a} || $NoAutoWhite;
   $Whitelist{$a}=$t unless !$Whitelist{$a} && $NoAutoWhite;
  }
  return 1;
 }
 0;
}

# clean up source email
sub clean {
    local $_ = "\n" . shift;
    my ($helo) = /helo=([^)]+)\)/i;
    $helo =~ s/(\w+)/ hlo $1 /g if length($helo) > 19;    # if the helo string is long, break it up
    my $rcpt = "rcpt " . join( " rcpt ", /($EmailAdrRe\@$EmailDomainRe)/g );

    # replace &#ddd encoding
    s/&#(\d{1,3});?/chr($1)/ge;

    # replace base64 encoding
    s/\n([a-zA-Z0-9+\/=]{40,}\r?\n[a-zA-Z0-9+\/=\r\n]+)/base64decode($1)/gse;

    # clean up quoted-printable references
    s/(Subject: .*)=\r?\n/$1\n/;
    s/=\r?\n//g;
    s/=([0-9a-fA-F]{2})/pack("C",hex($1))/gei;
    s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;    # replace url encoding
                                                         # strip out mime continuation
    s/.*---=_NextPart_.*\n//g;

    # mark the subject
    s/\nsubject: (.*)/fixsub($1)/ige;

    # remove received lines
    s/\n(received|Content-Type): .*(\n[\t ].*)*//ig;

    # remove other header lines
    s/(\n[a-zA-Z\-]{2,40}: .*(\n[\t ].*)*){2,}//g;

    # clean up &nbsp; and &amp;
    s/&nbsp;?/ /gi;
    s/&amp;?/and/gi;
    s/(\d),(\d)/$1$2/g;
    s/\r//g;
    s/ *\n/\n/g;
    s/\n\n\n\n\n+/\nblines blines\n/g;

    # clean up html stuff
    s/<script.*?>\s*(<!\S*)?/ jscripttag jscripttag /ig;
    while (s/(\w+)(<[^>]*>)((<[^>]*>)*\w+)/$2$1$3/g) { }    # move html out of words
    s/<([biu]|strong)>/ boldifytext boldifytext /gi;

    # remove some tags that are not informative
    s/<\/?(p|br|div|t[dr])[^>]*>/\n/gi;
    s/<\/([biu]|font|strong)>//gi;
    s/<\/?(html|meta|head|body|span|o)[^>]*>//ig;
    s/(<a\s[^>]*>)(.*?)(<\s*\/a\s*>)/$1.fixlinktext($2).$3/igse;
    s/<\s*\/a\s*>//gi;

    # treat titles like subjects
    s/<title[^>]*>(.*?)<\/title>/fixsub($1)/ige;

    # remove style sheets
    s/<style[^>]*>.*?<\/style>//igs;

    # remove html comments
    s/<!.*?-->//gs;
    s/<![^>]*>//g;

    # look for random words
    s/[ a-z0-9][ghjklmnpqrstvwxz_]{2}[bcdfghjklmnpqrstvwxz_0-9]{3}\S*/ randword randword /gi;

    # remove mime separators
    s/\n--.*randword.*//g;

    # look for linked images
    s/(<a[^>]*>[^<]*<img)/ linkedimage linkedimage $1/gis;
    s/<[^>]*href\s*=\s*("[^"]*"|\S*)/fixhref($1)/isge;
    s/http:\/\/(\S*)/fixhref($1)/isge;
    s/(\S+\@\S*\.\w{2,3})\b/fixhref($1)/ge;
    "helo: $helo\n$rcpt\n$_";
}

sub fixhref { my $t=shift; $t=~s/(\w+)/ href $1 /g; $t;}

sub fixlinktext { my $t=shift; $t=~s/(\w+)/atxt $1/g; $t;}

sub fixurl {
 my $a=shift;
 $a=~s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;
 $a;
}

sub fixsub {
 my $s=shift;
 $s=~s/ {3,}/ lotsaspaces /g;
 $s=~s/(\S+)/ssub $1/g;
 "\n$s ssub";
}

sub base64decode {
 my $str = shift;
 my $res;
 $str =~ tr|A-Za-z0-9+/||cd;
 $str =~ tr|A-Za-z0-9+/| -_|;
 while ($str =~ /(.{1,60})/gs) {
  my $len = chr(32 + length($1)*3/4);
  $res .= unpack("u", $len . $1 );
 }
 $res;
}
sub formatMethod {
 my $res;
 if ($_[2]==0) {
  $res=int($_[0]/$_[1]);
  $_[0]-=$res*$_[1]; # modulus on floats
 } elsif ($_[2]==1) {
  if ($_[0]>=$_[1]) {
   $res=sprintf("%.1f",$_[0]/$_[1]);
   $_[0]=0;
  }
 }
 return $res;
}


sub formatDataSize {
 my ($size,$method)=@_;
 my ($res,$s);
 $res.=$s.'TB ' if $s=formatMethod($size,1099511627776,$method);
 $res.=$s.'GB ' if $s=formatMethod($size,1073741824,$method);
 $res.=$s.'MB ' if $s=formatMethod($size,1048576,$method);
 $res.=$s.'kB ' if $s=formatMethod($size,1024,$method);
 if ($size || !defined $res) {
  if ($method==0) {
   $res.=$size.'B ';
  } elsif ($method==1) {
   $res.=sprintf("%.1fB ",$size);
  }
 }
 $res=~s/\s$//;
 return $res;
}

sub unformatTimeInterval {
 my ($interval,$default)=@_;
 my @a=split(' ',$interval);
 my $res=0;
 foreach my $i (@a) {
  my ($i,$mult)=$i=~/^(.*?) ?([smhd]?)$/;
  $mult||=$default||'s'; # default to seconds
  if ($mult eq 's') {
   $res+=$i;
  } elsif ($mult eq 'm') {
   $res+=$i*60;
  } elsif ($mult eq 'h') {
   $res+=$i*3600;
  } elsif ($mult eq 'd') {
   $res+=$i*86400;
  }
 }
 return $res;
}

sub unformatDataSize {
 my ($size,$default)=@_;
 my @a=split(' ',$size);
 my $res=0;
 foreach my $s (@a) {
  my ($s,$mult)=$s=~/^(.*?) ?(B|kB|MB|GB|TB)?$/;
  $mult||=$default||'B'; # default to bytes
  if ($mult eq 'B') {
   $res+=$s;
  } elsif ($mult eq 'kB') {
   $res+=$s*1024;
  } elsif ($mult eq 'MB') {
   $res+=$s*1048576;
  } elsif ($mult eq 'GB') {
   $res+=$s*1073741824;
  } elsif ($mult eq 'TB') {
   $res+=$s*1099511627776;
  }
 }
 return $res;
}


sub decodeMimeWord {
 my ($charset,$encoding,$text)=@_;
 # ignore charset
 my $s;
 if (lc $encoding eq 'b') {
  $text=base64decode($text);
 } elsif (lc $encoding eq 'q') {
  $text=~s/_/\x20/g; # RFC 1522, Q rule 2
  $text=~s/=([\da-fA-F]{2})/pack('C', hex($1))/ge; # RFC 1522, Q rule 1
 }
 return $text;
}

sub decodeMimeWords {
 my $s=shift;
 headerUnwrap($s);
 $s=~s/=\?([^?]*)\?(b|q)\?([^?]+)\?=/decodeMimeWord($1,$2,$3)/gie;
 return $s;
}

sub downloadGrip {

    d("griplistdownload-start");

    my $longRetry  = time + ( ( int( rand(5) ) + 9 ) * 3600 );    # no sooner than 9 hours and no later than 14 hours
    my $shortRetry = time + ( ( int( rand(2) ) + 1 ) * 3600 );    # no sooner than 1 hour and no later than 3 hours

    my $gripListUrl = "http://scripts.asspsmtp.org/grey/griplist.txt";
    my $gripFile    = "$base/$griplist";

    # let's check if we really need to
    my @s     = stat($gripFile);
    my $mtime = $s[9];
    if ( time - $mtime <= 9 * 3600 ) {

        # file exists and has been downloaded recently, must have restarted
        $NextGriplistDownload = $shortRetry;
        return;
    }

    if ( !$CanUseLWP ) {
        mlog( 0, "ConfigError: Griplist Update failed: LWP::Simple Perl module not available" );
        $NextGriplistDownload = $longRetry;
        return;
    }

    if ( -e $gripFile ) {

        if ( !-r $gripFile ) {
            mlog( 0, "AdminInfo: Griplist Update failed: $gripFile not readable!" );
            $NextGriplistDownload = $longRetry;
            return;
        }
        elsif ( !-w $gripFile ) {
            mlog( 0, "AdminInfo: Griplist Update failed: $gripFile not writable!" );
            $NextGriplistDownload = $longRetry;
            return;
        }

    }
    else {

        if ( open( TEMPFILE, ">", $gripFile ) ) {

            #we can create the file, this is good, now close the file and keep going.
            close TEMPFILE;
            unlink $gripFile;
        }
        else {
            mlog( 0, "AdminInfo: Griplist Update failed: Cannot create $gripFile " );
            $NextGriplistDownload = $longRetry;
            return;
        }

    }

    # Create LWP ogject
    use LWP::Simple qw(mirror is_success status_message $ua);

    # Set useragent to ASSP version
    $ua->agent("ASSP/$version$modversion ($^O; Perl/$]; LWP::Simple/$LWP::VERSION)");
    $ua->timeout(20);

    if ($proxyserver) {
        $ua->proxy( 'http', "http://" . $proxyserver );
        mlog( 0, "Updating Griplist via HTTP proxy: $proxyserver" )
            if $MaintenanceLog;
    }
    else {
        mlog( 0, "Updating Griplist via direct HTTP connection" ) if $MaintenanceLog;
    }

    # call LWP mirror command
    $rc = mirror( $gripListUrl, $gripFile );

    d("LWP-response: $rc");

    if ( $rc == 304 ) {

        # HTTP 304 not modified status returned
        mlog( 0, "Griplist already up to date" ) if $MaintenanceLog;
        $NextGriplistDownload = $longRetry;
        return;
    }
    elsif ( !is_success($rc) ) {

        #download failed-error code output to logfile

        mlog( 0, "AdminInfo: Griplist Update failed: $rc " . status_message($rc) );
        $NextGriplistDownload = $shortRetry;
        return;
    }
    elsif ( is_success($rc) ) {

        # download complete
        $NextGriplistDownload = $longRetry;
        my $filesize = -s $gripFile;
        mlog( 0, "Griplist Update complete $filesize bytes" ) if $MaintenanceLog;

        if ($GriplistObject) {
            $GriplistObject->resetCache();
        }
        else {
            $GriplistObject = tie %Griplist, 'orderedtie', $gripFile
                if $griplist;
        }
    }
} ## end sub downloadGrip


sub uploadStats {

 my ($peeraddress,$connect);
 if ($proxyserver) {
  mlog(0,"uploading stats via proxy:$proxyserver") if $MaintenanceLog;
  $peeraddress = $proxyserver;
        $connect     = "POST http://scripts.asspsmtp.org/stats2/upload.pl HTTP/1.0";
 } else {
  mlog(0,"uploading stats via direct connection") if $MaintenanceLog;
        $peeraddress = "scripts.asspsmtp.org:80";
        $connect     = "POST /stats2/upload.pl HTTP/1.1
User-Agent: rebuildspamdb/$VERSION ($^O; Perl/$];)
Host: scripts.asspsmtp.org";
 }
 my $s=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$peeraddress,Timeout=>2);
 if($s) {
  my %UploadStats;
  my %tots=statsTotals();
  $UploadStats{starttime}=$Stats{starttime};
  $UploadStats{version}=$Stats{version};
  $UploadStats{pid}=$$;
  $UploadStats{timenow}=time;
  $UploadStats{testmode}=unpack "C", pack "B*", "0$baysTestMode$blTestMode$hlTestMode$sbTestMode$spfTestMode$rblTestMode$srsTestMode";
  $UploadStats{messages}=$tots{msgTotal}; # legacy
  $UploadStats{locals}=$Stats{locals};
  $UploadStats{whites}=$Stats{whites};
  $UploadStats{noprocessing}=$Stats{noprocessing};
  # for legacy support, $UploadStats{spams} are effectively non Bayesian spams.
  $UploadStats{spams}=$tots{msgRejectedTotal}-$Stats{bspams}; # legacy
  $UploadStats{blacklisted}=$Stats{blacklisted};
  $UploadStats{helolisted}=$Stats{helolisted};
  $UploadStats{spambucket}=$Stats{spambucket};
  $UploadStats{bhams}=$Stats{bhams};
  $UploadStats{bspams}=$Stats{bspams};
  $UploadStats{viri}=$Stats{viri}+$Stats{viridetected}; # legacy
  $UploadStats{viridetected}=$Stats{viridetected};
  $UploadStats{norelays}=$tots{rcptRelayRejected}; # legacy
  $UploadStats{connects}=$tots{smtpConnTotal}; # legacy
  $UploadStats{spamlover}=$Stats{spamlover};
  $UploadStats{bombs}=$Stats{bombs};
  $UploadStats{scripts}=$Stats{scripts};
  $UploadStats{spffails}=$Stats{spffails};
  $UploadStats{rblfails}=$Stats{rblfails}+$Stats{rblcachehit};
  $UploadStats{nextUpload}=$Stats{nextUpload};
  my $content=join("\001",%UploadStats);
  my $len=length($content);
  $connect.="
Content-Type: application/x-www-form-urlencoded
Content-Length: $len

$content";
  print $s $connect;
  $s->close;
 } else {
  mlog(0,"unable to connect to stats server");
 }
 $Stats{nextUpload}=time+3600*8;
}

sub ResetStats {
 $Stats{nextUpload}=time+3600*8;
 $Stats{cpuTime}=0;
 $Stats{cpuBusyTime}=0;
 $Stats{smtpConn}=0;
 $Stats{smtpConnNotLogged}=0;
 $Stats{smtpConnLimit}=0;
 $Stats{smtpConnLimitIP}=0;
 $Stats{smtpConnDomainIP}=0;
 $Stats{smtpConnLimitFreq}=0;
 $Stats{smtpConnDenied}=0;
 $Stats{smtpConnIdleTimeout}=0;
 $Stats{smtpConcurrentSessions}=0;
 $Stats{smtpMaxConcurrentSessions}=0;
 $Stats{admConn}=0;
 $Stats{admConnDenied}=0;
 $Stats{rcptValidated}=0;
 $Stats{rcptUnchecked}=0;
 $Stats{rcptSpamLover}=0;
 $Stats{rcptWhitelisted}=0;
 $Stats{rcptNotWhitelisted}=0;
 $Stats{rcptUnprocessed}=0;
 $Stats{rcptReportSpam}=0;
 $Stats{rcptReportHam}=0;
 $Stats{rcptReportWhitelistAdd}=0;
 $Stats{rcptReportWhitelistRemove}=0;
 $Stats{rcptReportRedlistAdd}=0;
 $Stats{rcptReportRedlistRemove}=0;
 $Stats{rcptNonexistent}=0;
 $Stats{rcptDelayed}=0;
 $Stats{rcptDelayedLate}=0;
 $Stats{rcptDelayedExpired}=0;
 $Stats{rcptEmbargoed}=0;
 $Stats{rcptSpamBucket}=0;
 $Stats{rcptRelayRejected}=0;
 $Stats{senderInvalidLocals}=0;
 $Stats{bombSender}=0;
 $Stats{pbdenied}=0;
 $Stats{msgscoring}=0;
 $Stats{msgMaxErrors}=0;
 $Stats{msgMaxFreq}=0;
 $Stats{msgDelayed}=0;
 $Stats{msgNoRcpt}=0;
 $Stats{msgNoSRSBounce}=0;
 $Stats{bhams}=0;
 $Stats{whites}=0;
 $Stats{locals}=0;
 $Stats{noprocessing}=0;
 $Stats{spamlover}=0;
 $Stats{bspams}=0;
 $Stats{blacklisted}=0;
 $Stats{invalidHelo}=0;
 $Stats{forgedHelo}=0;
 $Stats{mxaMissing}=0;
 $Stats{ptrMissing}=0;
 $Stats{ptrInvalid}=0;
 $Stats{helolisted}=0;
 $Stats{spambucket}=0;
 $Stats{penaltytrap}=0;
 $Stats{internaladdress}=0;
 $Stats{viri}=0;
 $Stats{viridetected}=0;
 $Stats{bombs}=0;
 $Stats{msgverify}=0;
 $Stats{bombSender}=0;
 $Stats{scripts}=0;
 $Stats{internaladdresses}=0;
 $Stats{spffails}=0;
 $Stats{rblfails}=0;
 $Stats{uriblfails}=0;

 open(F,"<$base/asspstats.sav");
 (%OldStats)=split(/\001/,<F>);
 close F;
 # conversion from previous versions
 if (exists $OldStats{messages}) {
  $OldStats{smtpConn}=$OldStats{connects};
  $OldStats{smtpConnLimit}=$OldStats{maxSMTP};
  $OldStats{smtpConnLimitIP}=$OldStats{maxSMTPip};
  $OldStats{viri}-=$OldStats{viridetected}; # fix double counting
  $OldStats{rcptRelayRejected}=$OldStats{norelays};
  # remove unused entries
  delete $OldStats{connects};
  delete $OldStats{maxSMTP};
  delete $OldStats{maxSMTPip};
  delete $OldStats{messages};
  delete $OldStats{spams};
  delete $OldStats{hams};
  delete $OldStats{norelays};
  delete $OldStats{testmode};
  SaveStats();
 }
}

sub SaveStats {
 $Stats{smtpConcurrentSessions}=$smtpConcurrentSessions;
    if ( !$SaveStatsEvery ) {
        $SaveStatsEvery = 0;
    }
	$NextSaveStats=time + ($SaveStatsEvery*60);
 	%AllStats=%OldStats;
 foreach (keys %Stats) {
  if ($_ eq 'version') {
   # just copy
   $AllStats{$_}=$Stats{$_};
  } elsif ($_ eq 'smtpMaxConcurrentSessions') {
   # pick greater value
   $AllStats{$_}=$Stats{$_} if $Stats{$_}>$AllStats{$_};
  } else {
   $AllStats{$_}+=$Stats{$_};
  }
 }
 $AllStats{starttime}=$OldStats{starttime} || $Stats{starttime};
 open(F,">$base/asspstats.sav");
 print F join("\001",%AllStats);
 close F;
}

#####################################################################################
#                Maillog functions


# find an appropriate name for a maillog file
sub maillogFilename {my $isspam=shift;
 my @dirs=($notspamlog,$spamlog,$incomingOkMail,$viruslog);
 my $maillog=$dirs[$isspam];
 d(19);
  my($sub)=$_[0]=~/Subject: (.*)/;
  $sub=decodeMimeWords($sub);
  $sub=~y/a-zA-Z0-9/_/cs;
  $this->{subject}=substr($sub,0,50);
  
 if($UseSubjectsAsMaillogNames || $isspam==2 || $isspam==3) {

  $sub.="--".(++$Counter);
  return "$base/$maillog/$sub$maillogExt";
 } else {
  my $fn=$this->{fn};
  "$base/$maillog/$fn$maillogExt";
 }
}
sub maillogNewFileName {
my $fn;

 if ($FilesDistribution<1.0) {
  my $p1=1.0-$FilesDistribution;
  my $p2=log($FilesDistribution);
  $fn=int($MaxFiles*log(1.0-rand($p1))/$p2);
 } else {  
  $fn=int($MaxFiles*rand());   
 }
 return $fn;
}
# integrated mail collection subroutine
sub MaillogStart {
 d(361);
 $Con{$_[0]}->{maillog}=1 unless $NoMaillog;
 $Con{$_[0]}->{maillogbuf}=$Con{$_[0]}->{header}=$Con{$_[0]}->{rcvd};
}
sub Maillog {
 my ($fh,$text,$parm)=@_; 
 my $fln;
 my $isnotcc;
if ($parm==1) {
	$parm=3;
	$isnotcc=1;

	}

 # 1 -- is spam, parm = 2 -- not spam, 3 -- is spam && cc to spamaccount, 4 -- mail ok
 # 5 -- virii, 6 -- ignore, 7 -- ignore && cc to spamaccount
return unless ($Con{$fh}->{maillog});


 
$parm=7 if ($parm==6  && $ccSpamAlways && &allccSpamAlways($this->{rcpt},$Con{$fh}->{mailfrom}));
$parm=7 if ($parm==6  && $ccSpamFilter && $sendAllSpam && &allccSpamFilter($this->{rcpt},$Con{$fh}->{mailfrom}));
 my $skipLog=0;

if ($parm == 1 || $parm == 2 || $parm == 3) {
  $logCount[$parm]++;  
  $skipLog=1 if ($logFreq[$parm]>$logCount[$parm] && $parm!=7);
  $fln="nocollect:freq" if ($logFreq[$parm]>$logCount[$parm]);
  $parm=7 if $this->{red} && $DoNotCollectRed && $parm == 3;
  $parm=6 if $this->{red} && $DoNotCollectRed && $parm == 1;
  $fln="nocollect:red" if  $this->{red} && $DoNotCollectRed;
  $parm=7 if $this->{redsl} && $parm == 3;
  $parm=6 if $this->{redsl} && $parm == 1;
  $fln="nocollect:sl" if $this->{redsl} && ($parm == 1 || $parm == 3);
  $parm=7 if $this->{messagelow} && $parm == 3 ;
  $parm=6 if $this->{messagelow} && $parm == 1 ;
  $fln="nocollect:lowscore" if $this->{messagelow} && ($parm == 1 || $parm == 3) ; 
 }
 if ($parm == 3 && $skipLog == 1) {
 $parm = 7;
 $skipLog=0;
 }
 
 if($parm == 4 && !$incomingOkMail || $parm == 5 && !$viruslog || $parm == 6 ||  $parm == 7 && $Con{$Con{$fh}->{forwardSpam}}->{ready} || $skipLog) {
  d(364);
  delete $Con{$fh}->{maillogbuf};
  delete $Con{$fh}->{maillog};
  close $Con{$fh}->{maillogfh} if $Con{$fh}->{maillogfh};
  delete $Con{$fh}->{maillogfh};
  delete $Con{$fh}->{mailloglength};
 } elsif($parm > 1 ) {
   
  d(362);
  $logCount[$parm]=0;
  # we now know if it is spam or not -- open the file
  $text=$Con{$fh}->{maillogbuf}.$text;
if($parm < 7 ) {
  delete $Con{$fh}->{maillogbuf};

  my $fn=maillogFilename($parm-2,$text);
  $fln=$fn;
  $fln="red:nocollect" if ($this->{red} && $DoNotCollectRed);
  $FH='FHaaaaa' unless $FH;
  if(open(++$FH,">$fn")) {
   $Con{$fh}->{maillogfh}=$FH;
   $Con{$fh}->{mailloglength}=0;
   binmode $FH;
  } else {

   mlog($fh,"error opening maillog '$fn': $!");
  }} 
  # start sending the message to sendAllSpam if appropriate

  my $current_email = $this->{rcpt};
  $current_email =~/($EmailAdrRe)\@($EmailDomainRe)/;
  my ($current_username,$current_domain) = ($1,$2);
  
if($sendAllSpam) {
	$ccspamlt = $sendAllSpam;
	$ccspamlt =~ s/USERNAME/$current_username/g;
	$ccspamlt =~ s/DOMAIN/$current_domain/g;

$Con{$fh}->{forwardSpam}=forwardSpam($Con{$fh}->{mailfrom},$ccspamlt,$fh) if ($isnotcc!=1 && ($parm==3 || $parm==7) && (!$ccSpamFilter  || $ccSpamFilter && allccSpamFilter($this->{rcpt},$Con{$fh}->{mailfrom})));
}}

if($ccMaxBytes) {
if(my $h=$Con{$fh}->{maillogfh}) {
  print $h $text;
  if(($Con{$fh}->{mailloglength}+=length($text))>$MaxBytes || $text=~/(^|[\r\n])\.[\r\n]/) {
   d(366);
   close $h;
   delete $Con{$fh}->{maillog} unless $Con{$fh}->{forwardSpam};
   delete $Con{$fh}->{maillogfh};
   delete $Con{$fh}->{mailloglength};
  }
 } elsif(length($Con{$fh}->{maillogbuf})<$MaxBytes) {
  $Con{$fh}->{maillogbuf}.=$text;
 }
 } else {
 if(my $h=$Con{$fh}->{maillogfh}) {

	print $h substr($text,0,$MaxBytes) if length($this->{spambuf})<$MaxBytes;
	$this->{spambuf}.=$text;
  if($text=~/(^|[\r\n])\.[\r\n]/) {
   d(366);
   close $h;
   delete $Con{$fh}->{maillog} unless $Con{$fh}->{forwardSpam};
   delete $Con{$fh}->{maillogfh};
   delete $Con{$fh}->{mailloglength};
  }
 } else {
  $Con{$fh}->{maillogbuf}.=$text;
 }
 }
 if($Con{$fh}->{forwardSpam}) {
  my $t=$Con{$Con{$fh}->{forwardSpam}};
  if($t->{ready}) {
   sendque($Con{$fh}->{forwardSpam},$text);
  } else {
   $t->{body}.=$text;
  }
 }
$isnotcc=0;
return $fln;
}



sub forwardSpam {
 my ($from,$to,$oldfh)=@_;
 
 my $destination;
 if ($sendAllDestination ne '') {
 $destination = $sendAllDestination;
 }else{
 $destination = $smtpDestination;
 }

$AVa = 0; 
foreach $destinationA (split(/\|/, $destination)) { 
if ($destinationA =~ /^(__INBOUND__:)?(\d+)$/){


     $localip = '127.0.0.1';

   $destinationA = $localip .':'.$2;
 }
if ($AVa<1) { 
$s=new IO::Socket::INET(Proto=>'tcp',PeerAddr=>$destinationA,Timeout=>2); 
if($s) { 
$AVa=1; 
$destination=$destinationA;
} 
else { 
mlog('',"*** $destinationA didn't work, trying others...") if $SessionLog; 
} 
} 
 
}
  if(! $s) {

  mlog('',"couldn't create server socket to $destination -- aborting sendAllSpam connection") if $SessionLog;
  return;
 }
 addfh($s,\&FShelo);
 my $this=$Con{$s};
 $this->{ready}=0;
 $this->{to}=$to;
 $this->{from}=$from;
 $this->{rcpt}=$Con{$fh}->{rcpt};
 $this->{myheader}=$Con{$fh}->{myheader};
 $this->{prepend}=$Con{$fh}->{prepend};
 $this->{saveprepend}=$Con{$fh}->{saveprepend};
 $this->{saveprepend2}=$Con{$fh}->{saveprepend2};

 $s;
}
sub FShelo { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  FSabort($fh,"helo Expected 220, got: $l");
 } elsif($l=~/^ *220 /) {
  sendque($fh,"HELO $myName\r\n");
  $Con{$fh}->{getline}=\&FSfrom;
 }
}
sub FSfrom { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  FSabort($fh,"send HELO($myName), expected 250, got: $l");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"MAIL FROM: <$Con{$fh}->{from}>\r\n");
  $Con{$fh}->{getline}=\&FSrcpt;
 }
}
sub FSrcpt { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  FSabort($fh,"send FROM ($Con{$fh}->{from}), expected 250, got: $l");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"RCPT TO: <$Con{$fh}->{to}>\r\n");
  $Con{$fh}->{getline}=\&FSdata;
 }
}
sub FSdata { my ($fh,$l)=@_;
 if($l=~/^ *5/) {
  FSabort($fh,"send RCPT ($Con{$fh}->{to}), expected 250, got: $l");
 } elsif($l=~/^ *250 /) {
  sendque($fh,"DATA\r\n");
  $Con{$fh}->{getline}=\&FSdata2;
 }
}
sub FSdata2 { my ($fh,$l)=@_;
my $parm=$this->{parm};
 if($l=~/^ *5/) {
  FSabort($fh,"data2 Expected 354, got: $l");
 } elsif($l=~/^ *354 /) {
  my $this=$Con{$fh};

$this->{myheader}=~s/^X-Assp-Intended-For:$HeaderValueRe//gimo if $AddIntendedForHeader; # clear out existing X-Assp-Envelope-From headers
  $this->{body}=~s/^($HeaderRe*)/$1From: sender not supplied\r\n/o unless $this->{body}=~/^$HeaderRe*From:/io; # add From: if missing
  $this->{body}=~s/^($HeaderRe*)/$1Subject:\r\n/o unless $this->{body}=~/^$HeaderRe*Subject:/io; # add Subject: if missing

$this->{saveprepend}.=$this->{saveprepend2};
  $this->{body}=~s/^Subject:/Subject: $this->{saveprepend}/gim if ($spamTagCC && $this->{saveprepend} );

  $this->{body}=~s/^Subject:/Subject: $spamSubject/gim if $spamSubjectCC && $spamSubject;
  # merge our header, add X-Intended-For header
  $this->{myheader}=headerWrap($this->{myheader}); # wrap long lines
    $this->{body}=~s/^($HeaderRe*)/$1\r\n\n\n\r$this->{myheader}X-Assp-Intended-For: $this->{rcpt}\r\n/o;
$this->{body}=~s/\r?\n?\r\n\n\n\r/\r\n/;
  
  sendque($fh,$this->{body}) if $this->{body};
  sendque($fh,"\r\n.\r\n") if ($this->{body} !~ /[\n\r]\.[\n\r]+$/);
  $this->{ready}=1;
  $this->{body}='';
  $Con{$fh}->{getline}=\&FSdone;
 }
}
sub FSdone { my ($fh,$l)=@_;

 if($l=~/^ *5/) {
  FSabort($fh,"done Expected 250, got: $l");
 } elsif($l=~/^ *250 /) {

done2($fh); # close and delete
 }
}
sub FSabort {mlog(0,"FSabort: $_[1]"); done2($_[0]);}


sub ClamScanOK {
	return 1 if $this->{clamscandone}==1;
	return 1 if !$UseAvClamd;
	return 1 if !$CanUseAvClamd;
	return 1 if $this->{whitelisted} && $ScanWL!=1;
	return 1 if $this->{noprocessing} && $ScanNP!=1;
	return 1 if $this->{relayok} && $ScanLocal!=1;
	$this->{prepend}="";

  
	my ($fh,$b)=@_;
	if ($NoScanRe && $NoScanReRE!="" && $b=~('('.$NoScanReRE.')')) {
		mlogRe($1,"NoVirusscan");
      	return 1;
      	}
	
	my $av;	
	my $this=$Con{$fh};
	
    $av = new File::Scan::ClamAV(port => $AvClamdPort);
    if($alreadyTestingPing) {
    } else {
    	$alreadyTestingPing = 1;
    	if($av->ping()) {
    		$alreadyTestingPing = 0 ; 
      		$VerAvClamd = AvClamd->version();
      		mlog(0, 'ClamAv Up') if $ScanLog && $AvailAvClamd==0 ;
      		$AvailAvClamd = 1;
    	} else {
    		$alreadyTestingPing = 0 ; 
    		mlog(0, 'ClamAv Down') if $ScanLog && $AvailAvClamd==1 ;
    		$AvailAvClamd = 0;
    		return 1;
    	}
    }
    $this->{clamscandone}=1;
	mlog($fh,"ClamAV: scanning whitelisted ") if $ScanLog && $this->{whitelisted};
	mlog($fh,"ClamAV: scanning noprocessing ") if $ScanLog && $this->{noprocessing};
	mlog($fh,"ClamAV: scanning local") if $ScanLog && ($this->{localuser} || $this->{relayok});
  	$av = new File::Scan::ClamAV(port => $AvClamdPort);
  	my $lb=length($b);
  	my ($code, $virus) = $av->streamscan($b);
  	mlog($fh,"ClamAV: scanning $lb bytes done $code $virus") if $ScanLog;
   	if($code eq 'OK'){
   	return 1;
   	} elsif($SuspiciousVirus && $SuspiciousVirusRE!="" && $code=~('('.$SuspiciousVirusRE.')')){
   	pbAdd($fh,$this->{ip},$vsValencePB,"$virus",1) if $vsValencePB>0;
   	mlogRe($1,"SuspiciousVirus");    	
   	return 1;   	
    } elsif($code eq 'FOUND'){
    $this->{prepend}="[VIRUS]";
    $this->{averror}=$AvError;
 	$this->{averror}=~s/\$infection/$virus/gi; 	
	mlog($fh,"virus detected '$virus'") if $ScanLog;
	my $reportheader="Full Header:\r\n$this->{header}\r\n" if $EmailVirusReportsHeader;
        AdminReportMail(
            "virus detected: '$virus'",
            "Message ID: $this->{$msgtime}\r\nRemote IP: $this->{ip}\r\nSubject: $this->{subject2}\r\nSender:  $this->{mailfrom}\r\nRecipient(s): $this->{rcpt}\r\nVirus Detected: '$virus'\r\n$reportheader\r\n.",
            $EmailVirusReportsTo
        ) if $EmailVirusReportsTo;
        AdminReportMail(
            "virus detected: '$virus'",
            "Message ID: $this->{$msgtime}\r\nRemote IP: $this->{ip}\r\nSubject: $this->{subject2}\r\nSender:  $this->{mailfrom}\r\nRecipient(s): $this->{rcpt}\r\nVirus Detected: '$virus'.",
            $this->{ rcpt }
        ) if $EmailVirusReportsToRCPT;

	$Stats{viridetected}++;
	delayWhiteExpire($fh);
	pbAdd($fh,$this->{ip},$vdValencePB,"$virus") if $vdValencePB>0;
	

			
	return 0;
    }   
    $VerAvClamd = $av->errstr();
    $AvailAvClamd = 0;
	mlog(0, "ClamAv Temporary Off : $VerAvClamd") if $ScanLog;
    return 1;
}
#####################################################################################
#                Web Configuration functions
# add multiple tooltips span tags
sub addShowPath {
 my ($text)=@_;
 my $ret="";

	
   while ($text=~/\G(.*?)\-\> (.*?\.eml)/cgso) { # /c - keep pos() on match fail
    $ret.=<<EOT;
$1<span onclick="popFileEditor($this,4);">$2</span>
EOT
    chomp($ret);

   }
   $ret.=$1 if $text=~/\G(.*)/s; # remainder
   $text=$ret;
   return $text;
 }


sub webRequest {
 my ($tempfh,$fh,$head,$data)=@_;
 %webRequests=(
  '/lists' => \&ConfigLists,
  '/maillog' => \&ConfigMaillog,
  '/analyze' => \&ConfigAnalyze,
  '/infostats' => \&ConfigStats,
  '/edit' => \&ConfigEdit,
  '/shutdown' => \&Shutdown,
  '/shutdown_frame' => \&ShutdownFrame,
  '/shutdown_list' => \&ShutdownList,

  '/donations' => \&Donations,
  '/get' => \&GetFile
 );
 my $i=0;
 # %head -- public hash
 (%head)=map{++$i % 2 ? lc $_ : $_} map/^([^ :]*)[: ]{0,2}(.*)/, split(/\r\n/,$head);
 my ($page,$qs)=($head{get} || $head{head} || $head{post})=~/^([^\? ]+)(?:\?(\S*))?/;
 if(defined $data) { # GET, POST order
  $qs.='&' if ($qs ne '');
  $qs.=$data;
 }
 $qs=~y/+/ /;
 $i=0;
 # parse query string, get rid of google autofill
 # %qs -- public hash
 (%qs)=map{s/(e)_(mail)/$1$2/gi if ++$i % 2; $_} split(/[=&]/,$qs);
 foreach $k (keys %qs) {$qs{$k}=~s/%([0-9a-fA-F][0-9a-fA-F])/pack("C",hex($1))/ge}
 my ($auth)=$head{authorization}=~/Basic (\S+)/i;
 my ($user,$pass)=split(':',base64decode($auth));
 my $ip=$fh->peerhost();
 my $port=$fh->peerport();
 
     if ( substr( $Config{webAdminPassword}, 0, 2 ) eq "45" ) {
        $pass = crypt( $pass, "45" );
      }

 
 if($pass eq $webAdminPassword){
  if ($page!~/shutdown_frame|shutdown_list|favicon.ico|get/i){
   # only count requests for pages without meta refresh tag
   # dont count requests for favicon.ico file
   # dont count requests for 'get' page
   my $args;
   if ($page=~/edit/i) {
    if (defined($qs{contents})) {
                    if ( $qs{ B1 } =~ /delete/i ) {
                        $args = "deleting file:$qs{file}";
                    }
                    else {
                        $args = "writing file:$qs{file}";
                    }
                }
                else {
     $args="reading file:$qs{file}";
    }
   }
   if ($args) {
    mlog('',"admin connection from $ip:$port; page:$page; $args");
   } 
   else {
    mlog('',"admin connection from $ip:$port; page:$page");
   }
   
   $Stats{admConn}++;
  }
  if ($page=~/quit/i){
    ConfigQuit($tempfh);
  }
  if ($page=~/favicon.ico/i){
   print $tempfh "HTTP/1.1 404 Not Found
Content-type: text/html

<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>Not found</h1>
</body></html>\n";
 } else {
   print $tempfh ((defined ($v=$webRequests{$page}))? $v->($head,$qs): webConfig($head,$qs));
  }
 } else {
  if ($pass ne '') {
   mlog('',"admin connection from $ip:$port; page:$page rejected -- authorization failed");
   $Stats{admConnDenied}++;
  }
  print $tempfh "HTTP/1.1 401 Unauthorized
WWW-Authenticate: Basic realm=\"Anti-Spam SMTP Proxy (ASSP) Configuration\"
Content-type: text/html

<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>Unauthorized</h1>
</body></html>\n";
 }
}

sub ConfigQuit {
    mlog( '', "quit requested from admin interface" );
    &SaveWhitelist;
    my $fh = shift;
    print $fh "HTTP/1.1 200 OK
Content-type: text/html


<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>ASSP Terminated.</h1>
</body></html>
";
 exit;
}

# compute various totals
sub statsTotals {
 my %s;
 $s{smtpConnIdleTimeout}=$Stats{smtpConnIdleTimeout};
 $s{smtpConnIdleTimeout2}=$AllStats{smtpConnIdleTimeout};
 $s{smtpConnAcceptedTotal}=$Stats{smtpConn}+$Stats{smtpConnNotLogged};
 $s{smtpConnAcceptedTotal2}=$AllStats{smtpConn}+$AllStats{smtpConnNotLogged};
 $s{smtpConnLimit}=$Stats{smtpConnLimit}+$Stats{smtpConnDomainIP}+$Stats{smtpConnLimitIP}+$Stats{smtpConnLimitFreq};
 $s{smtpConnLimit2}=$AllStats{smtpConnLimit}+$AllStats{smtpConnDomainIP}+$AllStats{smtpConnLimitIP}+$AllStats{smtpConnLimitFreq};
 $s{smtpConnRejectedTotal}=$s{smtpConnLimit}+$Stats{smtpConnDenied};
 $s{smtpConnRejectedTotal2}=$s{smtpConnLimit2}+$AllStats{smtpConnDenied};
 $s{smtpConnTotal}=$s{smtpConnAcceptedTotal}+$s{smtpConnRejectedTotal};
 $s{smtpConnTotal2}=$s{smtpConnAcceptedTotal2}+$s{smtpConnRejectedTotal2};
 $s{admConnTotal}=$Stats{admConn}+$Stats{admConnDenied};
 $s{admConnTotal2}=$AllStats{admConn}+$AllStats{admConnDenied};
 $s{rcptAcceptedLocal}=$Stats{rcptValidated}+$Stats{rcptUnchecked}+$Stats{rcptSpamLover};
 $s{rcptAcceptedLocal2}=$AllStats{rcptValidated}+$AllStats{rcptUnchecked}+$AllStats{rcptSpamLover};
 $s{rcptAcceptedRemote}=$Stats{rcptWhitelisted}+$Stats{rcptNotWhitelisted};
 $s{rcptAcceptedRemote2}=$AllStats{rcptWhitelisted}+$AllStats{rcptNotWhitelisted};
 $s{rcptUnprocessed}=$Stats{rcptUnprocessed};
 $s{rcptUnprocessed2}=$AllStats{rcptUnprocessed};
 $s{rcptReport}=$Stats{rcptReportSpam}+$Stats{rcptReportHam}+$Stats{rcptReportWhitelistAdd}+$Stats{rcptReportWhitelistRemove}+$Stats{rcptReportRedlistAdd}+$Stats{rcptReportRedlistRemove};
 $s{rcptReport2}=$AllStats{rcptReportSpam}+$AllStats{rcptReportHam}+$AllStats{rcptReportWhitelistAdd}+$AllStats{rcptReportWhitelistRemove}+$AllStats{rcptReportRedlistAdd}+$AllStats{rcptReportRedlistRemove};
 $s{rcptAcceptedTotal}=$s{rcptAcceptedLocal}+$s{rcptAcceptedRemote}+$s{rcptUnprocessed}+$s{rcptReport};
 $s{rcptAcceptedTotal2}=$s{rcptAcceptedLocal2}+$s{rcptAcceptedRemote2}+$s{rcptUnprocessed2}+$s{rcptReport2};
 $s{rcptRejectedLocal}=$Stats{rcptNonexistent}+$Stats{rcptDelayed}+$Stats{rcptDelayedLate}+$Stats{rcptDelayedExpired}+
                       $Stats{rcptEmbargoed}+$Stats{rcptSpamBucket};
 $s{rcptRejectedLocal2}=$AllStats{rcptNonexistent}+$AllStats{rcptDelayed}+$AllStats{rcptDelayedLate}+$AllStats{rcptDelayedExpired}+
                        $AllStats{rcptEmbargoed}+$AllStats{rcptSpamBucket};
 $s{rcptRejectedRemote}=$Stats{rcptRelayRejected};
 $s{rcptRejectedRemote2}=$AllStats{rcptRelayRejected};
 $s{rcptRejectedTotal}=$s{rcptRejectedLocal}+$s{rcptRejectedRemote};
 $s{rcptRejectedTotal2}=$s{rcptRejectedLocal2}+$s{rcptRejectedRemote2};
 $s{rcptTotal}=$s{rcptAcceptedTotal}+$s{rcptRejectedTotal};
 $s{rcptTotal2}=$s{rcptAcceptedTotal2}+$s{rcptRejectedTotal2};
 $s{msgAcceptedTotal}=$Stats{bhams}+$Stats{whites}+$Stats{locals}+$Stats{noprocessing}+$Stats{spamlover};
 $s{msgAcceptedTotal2}=$AllStats{bhams}+$AllStats{whites}+$AllStats{locals}+$AllStats{noprocessing}+$AllStats{spamlover};
 $s{msgRejectedTotal}=$Stats{bspams}+$Stats{blacklisted}+$Stats{helolisted}+$Stats{spambucket}+$Stats{penaltytrap}+$Stats{viri}+$Stats{internaladdresses}+$Stats{smtpConnDenied}+$Stats{smtpConnDomainIP}+$Stats{smtpConnLimitFreq}+
                      $Stats{viridetected}+$Stats{bombs}+$Stats{msgverify}+$Stats{bombSender}+$Stats{invalidHelo}+$Stats{ptrMissing}+$Stats{ptrInvalid}+$Stats{mxaMissing}+$Stats{forgedHelo}+$Stats{pbdenied}+$Stats{msgscoring}+$Stats{senderInvalidLocals}+$Stats{scripts}+$Stats{spffails}+$Stats{rblfails}+$Stats{uriblfails}+$Stats{msgMaxErrors}+$Stats{msgDelayed}+$Stats{msgNoRcpt}+$Stats{msgNoSRSBounce};
 $s{msgRejectedTotal2}=$AllStats{bspams}+$AllStats{blacklisted}+$AllStats{helolisted}+$AllStats{spambucket}+$AllStats{viri}+$AllStats{internaladdresses}+$AllStats{smtpConnDenied}+$AllStats{smtpConnDomainIP}+$AllStats{smtpConnLimitFreq}+
                       $AllStats{viridetected}+$AllStats{bombs}+$AllStats{msgverify}+$AllStats{bombSender}+$AllStats{ptrMissing}+$AllStats{ptrInvalid}+$AllStats{mxaMissing}+$AllStats{forgedHelo}+$AllStats{invalidHelo}+$AllStats{pbdenied}+$AllStats{msgscoring}+$AllStats{senderInvalidLocals}+$AllStats{scripts}+$AllStats{spffails}+$AllStats{rblfails}+$AllStats{uriblfails}+
                 $AllStats{msgMaxErrors}+$AllStats{msgDelayed}+$AllStats{msgNoRcpt}+$AllStats{msgNoSRSBounce};
 $s{msgTotal}=$s{msgAcceptedTotal}+$s{msgRejectedTotal};
 $s{msgTotal2}=$s{msgAcceptedTotal2}+$s{msgRejectedTotal2};
 %s;
}

sub ConfigStats {
    SaveStats();
    my %tots    = statsTotals();
    my $upt     = ( time - $Stats{ starttime } ) / ( 24 * 3600 );
    my $upt2    = ( time - $AllStats{ starttime } ) / ( 24 * 3600 );
    my $uptime  = sprintf( "%.3f", $upt );
    my $uptime2 = sprintf( "%.3f", $upt2 );
    my $mpd     = sprintf( "%.1f", $upt == 0 ? 0 : $tots{ msgTotal } / $upt );
    my $mpd2    = sprintf( "%.1f", $upt2 == 0 ? 0 : $tots{ msgTotal2 } / $upt2 );
    my $pct     = sprintf( "%.1f",
        $tots{ msgTotal } - $Stats{ locals } == 0
        ? 0
        : 100 * $tots{ msgRejectedTotal } / ( $tots{ msgTotal } - $Stats{ locals } ) );
    my $pct2 = sprintf( "%.1f",
        $tots{ msgTotal2 } - $AllStats{ locals } == 0
        ? 0
        : 100 * $tots{ msgRejectedTotal2 } / ( $tots{ msgTotal2 } - $AllStats{ locals } ) );
    my $cpu = $CanStatCPU ? sprintf( "%.2f\%", 100 * $cpuUsage ) : 'n/a';
    my $cpuAvg
        = sprintf( " (%.2f\% avg)", $Stats{ cpuTime } == 0 ? 0 : 100 * $Stats{ cpuBusyTime } / $Stats{ cpuTime } )
        if $CanStatCPU;
    my $cpuAvg2
        = $CanStatCPU
        ? sprintf( "%.2f\% avg", $AllStats{ cpuTime } == 0 ? 0 : 100 * $AllStats{ cpuBusyTime } / $AllStats{ cpuTime } )
        : 'n/a';
    <<"EOT";
$headerHTTP
$headerDTDTransitional
$headers
<script type=\"text/javascript\">
<!--
  function toggleTbody(id) {
    if (document.getElementById) {
      var tbod = document.getElementById(id);
      if (tbod && typeof tbod.className == 'string') {
        if (tbod.className == 'off') {
          tbod.className = 'on';
        } else {
          tbod.className = 'off';
        }
      }
    }
    return false;
  }
//-->
</script>
<div class="content"><h2>ASSP Information and Statistics</h2>
<br />
<table class="statBox">

<thead>
<tr><td colspan="5" class="sectionHeader" onmousedown="toggleTbody('StatItem3')">General Runtime Information</td></tr>
</thead>
<tbody id="StatItem3" class="on">
<tr><td class="statsOptionTitle"><b>ASSP Proxy Uptime:</b></td>
<td class="statsOptionValue" >$uptime days</td>
<td class="statsOptionValue" >$uptime2 days</td>
</tr>
<tr><td class="statsOptionTitle"><b>Messages Processed:</b></td>
<td class="statsOptionValue" >$tots{msgTotal} ($mpd per day)</td>
<td class="statsOptionValue" >$tots{msgTotal2} ($mpd2 per day)</td>
</tr>
<tr><td class="statsOptionTitle"><b>Non-Local Mail Blocked:</b></td>
<td class="statsOptionValue" >$pct%</td>
<td class="statsOptionValue" >$pct2%</td>
</tr>
<tr><td class="statsOptionTitle"><b>CPU Usage:</b></td>
<td class="statsOptionValue" >$cpu$cpuAvg</td>
<td class="statsOptionValue" >$cpuAvg2</td>
</tr>
<tr><td class="statsOptionTitle"><b>Concurrent SMTP Sessions:</b></td>
<td class="statsOptionValue" >$smtpConcurrentSessions ($Stats{smtpMaxConcurrentSessions} max)</td>
<td class="statsOptionValue" >$AllStats{smtpMaxConcurrentSessions} max</td>
</tr>
 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since restart</i></font></td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since reset</i></font></td>
 </tr>
</tbody>
<tbody>
<tr><td colspan="5" class="sectionHeader" onmousedown="toggleTbody('StatItem4')">Totaled Statistics</td></tr>
</tbody>
<tbody id="StatItem4" class="off">
<tr><td class="statsOptionTitle"><b>SMTP Connections Received:</b></td>
<td class="statsOptionValue" >$tots{smtpConnTotal}</td>
<td class="statsOptionValue" >$tots{smtpConnTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;SMTP Connections Accepted:</b></td>
<td class="statsOptionValue" >$tots{smtpConnAcceptedTotal}</td>
<td class="statsOptionValue" >$tots{smtpConnAcceptedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;SMTP Connections Rejected:</b></td>
<td class="statsOptionValue" >$tots{smtpConnRejectedTotal}</td>
<td class="statsOptionValue" >$tots{smtpConnRejectedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Envelope Recipients Processed:</b></td>
<td class="statsOptionValue" >$tots{rcptTotal}</td>
<td class="statsOptionValue" >$tots{rcptTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Envelope Recipients Accepted:</b></td>
<td class="statsOptionValue" >$tots{rcptAcceptedTotal}</td>
<td class="statsOptionValue" >$tots{rcptAcceptedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Envelope Recipients Rejected:</b></td>
<td class="statsOptionValue" >$tots{rcptRejectedTotal}</td>
<td class="statsOptionValue" >$tots{rcptRejectedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Messages Processed:</b></td>
<td class="statsOptionValue" >$tots{msgTotal}</td>
<td class="statsOptionValue" >$tots{msgTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Messages Passed:</b></td>
<td class="statsOptionValue" >$tots{msgAcceptedTotal}</td>
<td class="statsOptionValue" >$tots{msgAcceptedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Messages Rejected:</b></td>
<td class="statsOptionValue" >$tots{msgRejectedTotal}</td>
<td class="statsOptionValue" >$tots{msgRejectedTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Admin Connections Received:</b></td>
<td class="statsOptionValue" >$tots{admConnTotal}</td>
<td class="statsOptionValue" >$tots{admConnTotal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Admin Connections Accepted:</b></td>
<td class="statsOptionValue" >$Stats{admConn}</td>
<td class="statsOptionValue" >$AllStats{admConn}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Admin Connections Rejected:</b></td>
<td class="statsOptionValue" >$Stats{admConnDenied}</td>
<td class="statsOptionValue" >$AllStats{admConnDenied}</td>
</tr>
 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since restart</i></font></td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since reset</i></font></td>
 </tr>
</tbody>
<tbody>
<tr><td colspan="5" class="sectionHeader" onmousedown="toggleTbody('StatItem5')">SMTP Connections Statistics</td></tr>
</tbody>
<tbody id="StatItem5" class="off">
<tr><td class="statsOptionTitle"><b>Accepted Logged SMTP Connections:</b></td>
<td class="statsOptionValue positive" >$Stats{smtpConn}</td>
<td class="statsOptionValue positive" >$AllStats{smtpConn}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Not Logged SMTP Connections:</b></td>
<td class="statsOptionValue positive" >$Stats{smtpConnNotLogged}</td>
<td class="statsOptionValue positive" >$AllStats{smtpConnNotLogged}</td>
</tr>
<tr><td class="statsOptionTitle"><b>SMTP Connection Limits:</b></td>
<td class="statsOptionValue negative">$tots{smtpConnLimit}</td>
<td class="statsOptionValue negative">$tots{smtpConnLimit2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Overall Limits:</b></td>
<td class="statsOptionValue negative">$Stats{smtpConnLimit}</td>
<td class="statsOptionValue negative">$AllStats{smtpConnLimit}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;By IP Limits:</b></td>
<td class="statsOptionValue negative">$Stats{smtpConnLimitIP}</td>
<td class="statsOptionValue negative">$AllStats{smtpConnLimitIP}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;By IP Frequency Limits:</b></td>
<td class="statsOptionValue negative">$Stats{smtpConnLimitFreq}</td>
<td class="statsOptionValue negative">$AllStats{smtpConnLimitFreq}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;By Domain IP Limits:</b></td>
<td class="statsOptionValue negative">$Stats{smtpConnDomainIP}</td>
<td class="statsOptionValue negative">$AllStats{smtpConnDomainIP}</td>
</tr>
<tr><td class="statsOptionTitle"><b>SMTP Connections Timeout:</b></td>
<td class="statsOptionValue negative">$tots{smtpConnIdleTimeout}</td>
<td class="statsOptionValue negative">$tots{smtpConnIdleTimeout2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Denied SMTP Connections:</b></td>
<td class="statsOptionValue negative">$Stats{smtpConnDenied}</td>
<td class="statsOptionValue negative">$AllStats{smtpConnDenied}</td>
</tr>

 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since restart</i></font></td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since reset</i></font></td>
 </tr>
</tbody>
<tbody>
<tr><td colspan="5" class="sectionHeader" onmousedown="toggleTbody('StatItem6')">Envelope Recipients Statistics</td></tr>
</tbody>
<tbody id="StatItem6" class="off">
<tr><td class="statsOptionTitle"><b>Local Recipients Accepted:</b></td>
<td class="statsOptionValue positive" >$tots{rcptAcceptedLocal}</td>
<td class="statsOptionValue positive" >$tots{rcptAcceptedLocal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Validated Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptValidated}</td>
<td class="statsOptionValue positive" >$AllStats{rcptValidated}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Unchecked Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptUnchecked}</td>
<td class="statsOptionValue positive" >$AllStats{rcptUnchecked}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Spam-Lover Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptSpamLover}</td>
<td class="statsOptionValue positive" >$AllStats{rcptSpamLover}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Remote Recipients Accepted:</b></td>
<td class="statsOptionValue positive" >$tots{rcptAcceptedRemote}</td>
<td class="statsOptionValue positive" >$tots{rcptAcceptedRemote2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Whitelisted Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptWhitelisted}</td>
<td class="statsOptionValue positive" >$AllStats{rcptWhitelisted}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Not Whitelisted Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptNotWhitelisted}</td>
<td class="statsOptionValue positive" >$AllStats{rcptNotWhitelisted}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Noprocessed Recipients:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptUnprocessed}</td>
<td class="statsOptionValue positive" >$AllStats{rcptUnprocessed}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Email Reports:</b></td>
<td class="statsOptionValue positive" >$tots{rcptReport}</td>
<td class="statsOptionValue positive" >$tots{rcptReport2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Spam Reports:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportSpam}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportSpam}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Ham Reports:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportHam}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportHam}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Whitelist Additions:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportWhitelistAdd}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportWhitelistAdd}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Whitelist Deletions:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportWhitelistRemove}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportWhitelistRemove}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Redlist Additions:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportRedlistAdd}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportRedlistAdd}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Redlist Deletions:</b></td>
<td class="statsOptionValue positive" >$Stats{rcptReportRedlistRemove}</td>
<td class="statsOptionValue positive" >$AllStats{rcptReportRedlistRemove}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Local Recipients Rejected:</b></td>
<td class="statsOptionValue negative">$tots{rcptRejectedLocal}</td>
<td class="statsOptionValue negative">$tots{rcptRejectedLocal2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Nonexistent Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptNonexistent}</td>
<td class="statsOptionValue negative">$AllStats{rcptNonexistent}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Delayed Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptDelayed}</td>
<td class="statsOptionValue negative">$AllStats{rcptDelayed}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Delayed (Late) Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptDelayedLate}</td>
<td class="statsOptionValue negative">$AllStats{rcptDelayedLate}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Delayed (Expired) Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptDelayedExpired}</td>
<td class="statsOptionValue negative">$AllStats{rcptDelayedExpired}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Embargoed Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptEmbargoed}</td>
<td class="statsOptionValue negative">$AllStats{rcptEmbargoed}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Spam Bucketed Recipients:</b></td>
<td class="statsOptionValue negative">$Stats{rcptSpamBucket}</td>
<td class="statsOptionValue negative">$AllStats{rcptSpamBucket}</td>
</tr>

<tr><td class="statsOptionTitle"><b>Remote Recipients Rejected:</b></td>
<td class="statsOptionValue negative">$tots{rcptRejectedRemote}</td>
<td class="statsOptionValue negative">$tots{rcptRejectedRemote2}</td>
</tr>
<tr><td class="statsOptionTitle"><b>&nbsp;&nbsp;&nbsp;&nbsp;Relay Attempts Rejected:</b></td>
<td class="statsOptionValue negative">$Stats{rcptRelayRejected}</td>
<td class="statsOptionValue negative">$AllStats{rcptRelayRejected}</td>
</tr>
 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since restart</i></font></td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since reset</i></font></td>
 </tr>
</tbody>
<tbody>
<tr><td colspan="5" class="sectionHeader" onmousedown="toggleTbody('StatItem7')">Messages Statistics</td></tr>
</tbody>
<tbody id="StatItem7" class="on">
<tr><td class="statsOptionTitle"><b>Bayesian Hams:</b></td>
<td class="statsOptionValue positive" >$Stats{bhams}</td>
<td class="statsOptionValue positive" >$AllStats{bhams}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Whitelisted:</b></td>
<td class="statsOptionValue positive" >$Stats{whites}</td>
<td class="statsOptionValue positive" >$AllStats{whites}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Local:</b></td>
<td class="statsOptionValue positive" >$Stats{locals}</td>
<td class="statsOptionValue positive" >$AllStats{locals}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Noprocessing:</b></td>
<td class="statsOptionValue positive" >$Stats{noprocessing}</td>
<td class="statsOptionValue positive" >$AllStats{noprocessing}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Spamlover Spams Passed:</b></td>
<td class="statsOptionValue positive" >$Stats{spamlover}</td>
<td class="statsOptionValue positive" >$AllStats{spamlover}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Bayesian Spams:</b></td>
<td class="statsOptionValue negative">$Stats{bspams}</td>
<td class="statsOptionValue negative">$AllStats{bspams}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Domains Blacklisted:</b></td>
<td class="statsOptionValue negative">$Stats{blacklisted}</td>
<td class="statsOptionValue negative">$AllStats{blacklisted}</td>
</tr>
<tr><td class="statsOptionTitle"><b>HELO Blacklisted:</b></td>
<td class="statsOptionValue negative">$Stats{helolisted}</td>
<td class="statsOptionValue negative">$AllStats{helolisted}</td>
</tr>
<tr><td class="statsOptionTitle"><b>HELO Invalid:</b></td>
<td class="statsOptionValue negative">$Stats{invalidHelo}</td>
<td class="statsOptionValue negative">$AllStats{invalidHelo}</td>
</tr>
<tr><td class="statsOptionTitle"><b>HELO Forged:</b></td>
<td class="statsOptionValue negative">$Stats{forgedHelo}</td>
<td class="statsOptionValue negative">$AllStats{forgedHelo}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Missing MX/A:</b></td>
<td class="statsOptionValue negative">$Stats{mxaMissing}</td>
<td class="statsOptionValue negative">$AllStats{mxaMissing}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Missing PTR:</b></td>
<td class="statsOptionValue negative">$Stats{ptrMissing}</td>
<td class="statsOptionValue negative">$AllStats{ptrMissing}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Invalid PTR:</b></td>
<td class="statsOptionValue negative">$Stats{ptrInvalid}</td>
<td class="statsOptionValue negative">$AllStats{ptrInvalid}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Spam Collected Messages:</b></td>
<td class="statsOptionValue negative">$Stats{spambucket}</td>
<td class="statsOptionValue negative">$AllStats{spambucket}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Penalty Trap Messages:</b></td>
<td class="statsOptionValue negative">$Stats{penaltytrap}</td>
<td class="statsOptionValue negative">$AllStats{penaltytrap}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Bad Attachments:</b></td>
<td class="statsOptionValue negative">$Stats{viri}</td>
<td class="statsOptionValue negative">$AllStats{viri}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Viruses Detected:</b></td>
<td class="statsOptionValue negative">$Stats{viridetected}</td>
<td class="statsOptionValue negative">$AllStats{viridetected}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Sender Regex:</b></td>
<td class="statsOptionValue negative">$Stats{bombSender}</td>
<td class="statsOptionValue negative">$AllStats{bombSender}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Bomb Regex:</b></td>
<td class="statsOptionValue negative">$Stats{bombs}</td>
<td class="statsOptionValue negative">$AllStats{bombs}</td>
</tr>

<tr><td class="statsOptionTitle"><b>Penalty Box:</b></td>
<td class="statsOptionValue negative">$Stats{pbdenied}</td>
<td class="statsOptionValue negative">$AllStats{pbdenied}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Message Scoring:</b></td>
<td class="statsOptionValue negative">$Stats{msgscoring}</td>
<td class="statsOptionValue negative">$AllStats{msgscoring}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Invalid Local Sender:</b></td>
<td class="statsOptionValue negative">$Stats{senderInvalidLocals}</td>
<td class="statsOptionValue negative">$AllStats{senderInvalidLocals}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Invalid Internal Mail:</b></td>
<td class="statsOptionValue negative">$Stats{internaladdresses}</td>
<td class="statsOptionValue negative">$AllStats{internaladdresses}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Scripts:</b></td>
<td class="statsOptionValue negative">$Stats{scripts}</td>
<td class="statsOptionValue negative">$AllStats{scripts}</td>
</tr>
<tr><td class="statsOptionTitle"><b>SPF Failures:</b></td>
<td class="statsOptionValue negative">$Stats{spffails}</td>
<td class="statsOptionValue negative">$AllStats{spffails}</td>
</tr>
<tr><td class="statsOptionTitle"><b>RBL Failures:</b></td>
<td class="statsOptionValue negative">$Stats{rblfails}</td>
<td class="statsOptionValue negative">$AllStats{rblfails}</td>
</tr>

<tr><td class="statsOptionTitle"><b>URIBL Failures:</b></td>
<td class="statsOptionValue negative">$Stats{uriblfails}</td>
<td class="statsOptionValue negative">$AllStats{uriblfails}</td>
</tr>

<tr><td class="statsOptionTitle"><b>Max Errors Exceeded:</b></td>
<td class="statsOptionValue negative">$Stats{msgMaxErrors}</td>
<td class="statsOptionValue negative">$AllStats{msgMaxErrors}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Delayed:</b></td>
<td class="statsOptionValue negative">$Stats{msgDelayed}</td>
<td class="statsOptionValue negative">$AllStats{msgDelayed}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Empty Recipient:</b></td>
<td class="statsOptionValue negative">$Stats{msgNoRcpt}</td>
<td class="statsOptionValue negative">$AllStats{msgNoRcpt}</td>
</tr>
<tr><td class="statsOptionTitle"><b>Not SRS Signed Bounces:</b></td>
<td class="statsOptionValue negative">$Stats{msgNoSRSBounce}</td>
<td class="statsOptionValue negative">$AllStats{msgNoSRSBounce}</td>
</tr>
 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since restart</i></font></td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>since reset</i></font></td>
 </tr>
</tbody>
        <tbody>
          <tr>
            <td class="sectionHeader" onmousedown="toggleTbody('StatItem0')"
            colspan="5">
              Server Information
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem0" class="off">
          <tr>
            <td class="statsOptionTitle">
              Server Name:
            </td>
            <td class="statsOptionValue" >
              $localhostname
            </td>
            <td class="statsOptionValue" >
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Server OS:
            </td>
            <td class="statsOptionValue" >
              $^O
            </td>
            <td class="statsOptionValue" >
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Server IP:
            </td>
            <td class="statsOptionValue" >
              $localhostip
            </td>
            <td class="statsOptionValue" >
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              DNS Servers:
            </td>
            <td class="statsOptionValue" >
              @nameservers
            </td>
            <td class="statsOptionValue" >
		&nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Perl Version:
            </td>
            <td class="statsOptionValue" >
              $]
            </td>
            <td class="statsOptionValueC" >
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              ASSP Version:
            </td>
            <td class="statsOptionValue" >
              $version$modversion
            </td>
            <td class="statsOptionValueC">

            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValueC" style="background-color: #FFFFFF">
              &nbsp;
            </td>
          </tr>
        </tbody>
<tbody>
 <tr>
  <td class="sectionHeader" onmousedown="toggleTbody('StatItem2')" colspan="5">Perl Modules</td>
 </tr>
</tbody>
<tbody id="StatItem2" class="off">
 <tr>
  <td class="statsOptionTitle"><b>Compress::Zlib</b></td>
  <td class="statsOptionValue" >$VerCompressZlib&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Compress::Zlib" rel="external">
  CPAN</a></td>
 </tr>
  <tr>
   <td class="statsOptionTitle"><b>Digest::MD5</b></td>
   <td class="statsOptionValue" >$VerDigestMD5&nbsp;</td>
   <td class="statsOptionValueC" >
   <a href="http://search.cpan.org/search?query=Digest::MD5" rel="external">
   CPAN</a></td>
 </tr>
  <tr>
   <td class="statsOptionTitle"><b>Email::Valid</b></td>
   <td class="statsOptionValue" >$VerEmailValid&nbsp;</td>
   <td class="statsOptionValueC" >
   <a href="http://search.cpan.org/search?query=Email::Valid" rel="external">
   CPAN</a></td>
 </tr>
  <tr>
   <td class="statsOptionTitle"><b>File::ReadBackwards</b></td>
   <td class="statsOptionValue" >$VerFileReadBackwards&nbsp;</td>
   <td class="statsOptionValueC" >
   <a href="http://search.cpan.org/search?query=File::ReadBackwards" rel="external">
   CPAN</a></td>
 </tr>
<tr>
  <td class="statsOptionTitle"><b>File::Scan::ClamAV</b></td>
  <td class="statsOptionValue" >$VerAvClamd&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=File::Scan::ClamAV" rel="external">
  CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>LWP::Simple</b></td>
  <td class="statsOptionValue" >$VerLWP&nbsp;</td>
  <td class="statsOptionValueC" >
  <a rel="external" href="http://search.cpan.org/search?query=LWP::Simple">CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>Mail::SPF::Query</b></td>
  <td class="statsOptionValue" >$VerMailSPF&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Mail::SPF::Query" rel="external">
  CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>Mail::SRS</b></td>
  <td class="statsOptionValue" >$VerMailSRS&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Mail::SRS" rel="external">CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>Net::DNS</b></td>
  <td class="statsOptionValue" >$VerNetDNS&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>Net::LDAP</b></td>
  <td class="statsOptionValue" >$VerNetLDAP&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Net::LDAP" rel="external">CPAN</a></td>
 </tr>
    <tr>
   <td class="statsOptionTitle"><b>Net::Syslog</b></td>
   <td class="statsOptionValue" >$VerNetSyslog&nbsp;</td>
   <td class="statsOptionValueC" >
   <a href="http://search.cpan.org/search?query=Net::Syslog" rel="external">
   CPAN</a></td>
 </tr>
  <tr>
   <td class="statsOptionTitle"><b>Sys::Syslog</b></td>
   <td class="statsOptionValue" >$VerSysSyslog&nbsp;</td>
   <td class="statsOptionValueC" >
   <a href="http://search.cpan.org/search?query=Sys::Syslog" rel="external">
   CPAN</a></td>
 </tr>
   <tr>
   <td class="statsOptionTitle"><b>Tie::RDBM</b></td>
   <td class="statsOptionValue" >$VerRDBM&nbsp;</td>
   <td class="statsOptionValueC" >
   <a rel="external" href="http://search.cpan.org/search?query=Tie::RDBM">CPAN</a></td>
 </tr>
 <tr>
  <td class="statsOptionTitle"><b>Time::HiRes</b></td>
  <td class="statsOptionValue" >$VerTimeHiRes&nbsp;</td>
  <td class="statsOptionValueC" >
  <a href="http://search.cpan.org/search?query=Time::HiRes" rel="external">
  CPAN</a></td>
 </tr>
  <tr>
   <td class="statsOptionTitle"><b>Win32::Daemon</b></td>
   <td class="statsOptionValue" >$VerWin32Daemon&nbsp;</td>
   <td class="statsOptionValueC" >
   <a rel="external" href="http://www.roth.net/perl/Daemon/">roth.net</a></td>
 </tr>
 <tr>
  <td class="statsOptionValue" style="background-color: #FFFFFF">&nbsp;</td>
  <td class="statsOptionValue" style="background-color: #FFFFFF" >&nbsp;</td>
  <td class="statsOptionValueC" style="background-color: #FFFFFF" >
  <font size="1" color="#C0C0C0"><i>downloads</i></font></td>
 </tr>
</tbody>
</table>
<br />
$kudos
<br />
</div>
$footers
</body></html>
EOT
} ## end sub ConfigStats

sub ConfigLists {
 my $s;
 my $a;
 my $act=$qs{action};
 if($act) {
  if ($qs{list} eq 'tuplets') {
   my $ip;
   my $hash;
   my $t;
   my $interval;
   my $intervalFormatted;
   while ($qs{addresses}=~/(\d+\.\d+\.\d+\.\d+),<?(?:$EmailAdrRe\@)?($EmailDomainRe|)>?/go) {
    $ip=ipNetwork($1,($DelayUseNetblocks ? 24 : 32));
    $a=lc $2;
    if ($DelayNormalizeVERPs) {
     # strip extension
     $a=~s/\+.*(?=@)//;
     # replace numbers with '#'
     $a=~s/\b\d+\b(?=.*@)/#/g;
    }
    # get sender domain
    $a=~s/.*@//;
    $hash="$ip $a";
    $hash=Digest::MD5::md5_hex($hash) if $CanUseMD5Keys;
    $t=time;
    $s.="<div class=\"text\">($ip,$a) ";
    if($act eq 'v') {
     if (!exists $DelayWhite{$hash}) {
      $s.="<span class=\"negative\">tuplet NOT whitelisted</span>";
     } else {
      $interval=$t-$DelayWhite{$hash};
      $intervalFormatted=formatTimeInterval($interval);
      if ($interval<$DelayExpiryTime*24*3600) {
       $s.="tuplet whitelisted, age: $intervalFormatted";
      } else {
       $s.="tuplet expired, age: $intervalFormatted";
      }
     }
    } elsif($act eq 'a') {
     if (!exists $DelayWhite{$hash} || ($t-$DelayWhite{$hash}>=$DelayExpiryTime*24*3600)) {
      if(localmail('@'.$a)) {
       $s.="<span class=\"negative\">local addresses not allowed on whitelisted tuplets</span>";
      } else {
       $s.="tuplet added";
       $DelayWhite{$hash}=$t;
       mlog(0,"whitelisted tuplets addition: ($ip,$a) (admin)");
      }
     } else {
      $s.="<span class=\"positive\">tuplet already whitelisted</span>";
     }
    } elsif($act eq 'r') {
     if (!exists $DelayWhite{$hash}) {
      $s.="<span class=\"negative\">tuplet NOT whitelisted</span>";
     } else {
      $interval=$t-$DelayWhite{$hash};
      $intervalFormatted=formatTimeInterval($interval);
      if ($interval<$DelayExpiryTime*24*3600) {
       $s.="tuplet removed, age: $intervalFormatted";
      } else {
       $s.="expired tuplet removed, age: $intervalFormatted";
      }
      delete $DelayWhite{$hash};
      mlog(0,"whitelisted tuplets deletion: ($ip,$a) (admin)");
     }
    }
    $s.="</div>\n";
   }
  } else {
   my $color=$qs{list} eq 'red'? 'Red' : 'White';
   my $list=$color."list";
   while ($qs{addresses}=~/($EmailAdrRe\@$EmailDomainRe)/go) {
    $a=$1;
    $s.="<div class=\"text\">$a ";
    $a=lc $a;
    if($act eq 'v') {
     if($list->{$a}) {
      $s.="${color}listed";
     } else {
      $s.="<span class=\"negative\">NOT $qs{list}listed</span>";
     }
    } elsif($act eq 'a') {
     if($list->{$a}) {
      $s.="<span class=\"positive\">already $qs{list}listed</span>";
     } else {
	# if($color eq 'White' && localmail($a)) { 
	# $s.="<span class=\"negative\">local addresses not allowed on whitelist</span>"; 
	# } else { 
	$s.="added"; 
	$list->{$a}=time; 
	mlog(0,"$qs{list}list addition: $a (admin)"); 
	# }
     }
    } elsif($act eq 'r') {
     if($list->{$a}) {
      $s.="removed";
      delete $list->{$a};
      mlog(0,"$qs{list}list deletion: $a (admin)");
     } else {
      $s.="not $qs{list}listed";
     }
    }
    $s.="</div>\n";
   }
  }
 }
 if($qs{B1}=~/^Show (.)/i) {
  local $/="\n";
  if($1 eq 'R') {
   $qs{list}="red"; # update radios
   $RedlistObject->flush() if $RedlistObject && $redlistdb !~ /mysql/;
   open(F,"<$base/$redlistdb") if $redlistdb !~ /mysql/;
   $s.='<div class="textbox"><b>Redlist</b></div>';
    if ($redlistdb =~ /mysql/)  {
    $s.='<div class="textbox"><b>mysql</b></div>';
   while (($v)=each(%Redlist)) {
   my ($a,$time)=split("\002",$v);
   $s.="<div class=\"textbox\">$a</div>";
   }}
 } else {
   $qs{list}="white"; # update radios
   $WhitelistObject->flush() if $WhitelistObject && $whitelistdb !~ /mysql/;
   open(F,"<$base/$whitelistdb") if $whitelistdb !~ /mysql/;
   $s.='<div class="textbox"><b>Whitelist</b></div>';
   if ($whitelistdb =~ /mysql/)  {
    $s.='<div class="textbox"><b>mysql</b></div>';
   while (($v)=each(%Whitelist)) {
   my ($a,$time)=split("\002",$v);
   $s.="<div class=\"textbox\">$a</div>";
   
  }} }
  if ($whitelistdb !~ /mysql/)  {
  my $l;
  while($l=<F>) {
   my ($a)=$l=~/([^\002]*)/;
   $s.="<div class=\"textbox\">$a</div>";
  }
  close F ;
 } }
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>Update or Verify the Whitelist/Redlist</h2>
$s
<form method="post" action=\"\">
    <table class="textBox" style="width: 99%;">
        <tr>
            <td class="noBorder">Do you want to work with the:
            </td>
            <td class="noBorder">
            <input type="radio" name="list" value="white"${\((!$qs{list} || $qs{list} eq 'white') ? ' checked="checked" ' : ' ')} /> Whitelist or<br />
            <input type="radio" name="list" value="red"${\($qs{list} eq 'red' ? ' checked="checked" ' : ' ')} /> Redlist or<br />
            <input type="radio" name="list" value="tuplets"${\($qs{list} eq 'tuplets' ? ' checked="checked" ' : ' ')} /> Tuplets
            </td>
        </tr>
        <tr>
            <td class="noBorder">Do you want to: </td>
            <td class="noBorder"><input type="radio" name="action" value="a" />add<br />
            <input type="radio" name="action" value="r" />remove<br />
            <input type="radio" checked="checked" name="action" value="v" />or verify</td>
            <td class="noBorder">
                List the addresses in this box:<br />
                (for tuplets put: ip-address,domain-name)<br />
                <p><textarea name="addresses" rows="5" cols="40" wrap="off">$qs{addresses}</textarea></p>
            </td>
        </tr>
        <tr>
            <td class="noBorder">&nbsp;</td>
            <td class="noBorder"><input type="submit" name="B1" value="  Submit  " /></td>
            <td class="noBorder">&nbsp;</td>
        </tr>
    </table>
</form>
<div class="textBox">
<p>Post less than 1 megabyte of data at a time.</p>
Note: The redlist is not a blacklist. The redlist is a list of addresses that cannot
contribute to the whitelist, and who are not considered local, even if their mail is
from a local computer. For example, if someone goes on a vacation and turns on their
email's autoresponder, put them on the redlist until they return. Then as they reply
to every spam they receive they won't corrupt your non-spam collection or whitelist.

  <form action="" method="post">
  <table style="width: 90%; margin-left: 5%;">
    <tr>
      <td align="center" class="noBorder"><input type="submit" name="B1" value="Show Whitelist" /></td>
      <td align="center" class="noBorder"><input type="submit" name="B1" value="Show Redlist" /></td>
    </tr>
  </table>
  </form>
      <p class="warning">Warning: If your whitelist or redlist is long, pushing these buttons
      is ill-advised. Use these for testing and while your whitelist is short.</p>
</div>
</div>
$footers
</body></html>
EOT
}

sub SearchBomb {
my ($name, $srch)=@_;
my $fil=$Config{"$name"};
if($fil=~/^\s*file:\s*(.+)\s*$/i) {
$fil=$1;
} else {
return 0;
}


    open( BOMBFILE, "<$fil" );
    my $counter = 0;
    while ( $i = <BOMBFILE> ) {
        $counter++;
        $i =~ s/#.*$//g;
        $i =~ s/\s*\n\s*//g;

        eval { $srch =~ m/($i)/i };
        mlog( 0, "ConfigError: regular expression error in line $counter of '$fil' for '$i': $@" ) if $@;
        next if $@;
        next if !$i;
        if ( $srch =~ m/($i)/i ) {

            return $i;
        }
    }
    close(BOMBFILE);

} 
 
sub ConfigAnalyze {
 my ($ba,$st,$fm,%fm,%wl);
 my $mail=$qs{mail};
 if($mail) {
  my $name=$myName; $name=~s/(\W)/\\$1/g;
  my ($ip)=$mail=~/Received: from.*?\(\[([0-9\.]+).*?helo=/is;
  my ($ip3)=$ip=~/(.*)\.\d+$/;
  my ($helo)=$mail=~/helo=(.*?)\)/i;
  $fm.="<div class=\"textBox\"><br />";
  $fm.="<b><font size=\"3\" color=\"#003366\">Feature Matching:</font></b><br /><br />";
  while($mail=~/($EmailAdrRe\@$EmailDomainRe)/go) {
   my $a=lc $1;
   my $mf=$a;
   my $mfd = $1 if $mf=~/\@(.*)/;
   my $mfdd = $1 if $mf=~/(\@.*)/;
   next if $fm{$a}++;
   if ($noProcessing) {
   if($NPREL!="" &&  ($mf=~$NPREL || $mfdd=~('('.$NPREL.')'))) { $fm.="<b><font color='orange'>&bull;</font> <a href='./#noProcessing'>NoProcessing Matching</a></b>: '$1'<br />\n"; }  }
   if ($BLDRE1!="" &&  $blackListedDomains && $mf=~('('.$BLDRE1.')')){$fm.="<b><font color='red'>&bull;</font> <a href='./#blackListedDomains'>Blacklist Matching</a></b>: '$1'<br />\n";}
   if($WLDRE!="" &&  $whiteListedDomains && $mf=~('('.$WLDRE.')')) {$fm.="<b><font color=#66CC66>&bull;</font> <a href='./#whiteListedDomains'>Whitelisted Domains Matching</a></b>: '$1'<br />\n";}
   if( $Redlist{$a} ){
    $fm.="<b><font color='orange'>&bull;</font> <a href='./lists'>Redlist</a></b>: '$a'<br />\n";
    $fm.="<b><font color=#66CC66>&bull;</font> <a href='./lists'>Redlisted Domain/ Wildcard</a></b>: '_all_$mfdd'<br />\n" if $Redlist{"_all_$mfdd"};
   } else {
    $fm.="<b><font color=#66CC66>&bull;</font> <a href='./lists'>Whitelist</a></b>: '$a'<br />\n" if $Whitelist{$a};
    $fm.="<b><font color=#66CC66>&bull;</font> <a href='./lists'>Whitelisted Domain/ Wildcard</a></b>: '_all_$mfdd'<br />\n" if $Whitelist{"_all_$mfdd"};
   }
  }
if ($ValidateSPF) {
 if ($noSPFReRE && $mf=~('('.$noSPFReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#noSPFRe'>No SPF RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("noSPFRe",$1);
$fm.="<font color='red'>&bull;</font> matching noSPFRe($Config{'noSPFRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($strictSPFReRE && $mf=~('('.$strictSPFReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#strictSPFRe'>Strict SPF RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("strictSPFRe",$1);
$fm.="<font color='red'>&bull;</font> matching strictSPFRe($Config{'strictSPFRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
}
if ($ValidateURIBL) {
 if ($noURIBLReRE && $mf=~('('.$noURIBLReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#noURIBLRe'>No URIBL RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("whiteRe",$1);
$fm.="<font color='red'>&bull;</font> matching noURIBLRe($Config{'noURIBLRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
}
$mail=clean(substr($mail,0,$MaxBytes));

 if ($whiteRe &&  $whiteReRE!="" && $mail=~('('.$whiteReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#whiteRe'>White RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("whiteRe",$1);
$fm.="<font color='red'>&bull;</font> matching whiteRe($Config{'whiteRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($redRe &&  $redReRE!="" && $mail=~('('.$redReRE.')')) {
$fm.="<b><font color='yellow'>&bull;</font> <a href='./#redRe'>Red RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("redRe",$1);
$fm.="<font color='yellow'>&bull;</font> matching redRe($Config{'redRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($blackRe &&  $blackReRE!="" && $mail=~('('.$blackReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#blackRe'>Black RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("blackRe",$1);
$fm.="<font color='red'>&bull;</font> matching blackRe($Config{'blackRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($npRe &&  $npReRE!="" && $mail=~('('.$npReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#npRe'>No Processing RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("npRe",$1);
$fm.="<font color='green'>&bull;</font> matching npRe($Config{'npRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($slRe &&  $slReRE!="" && $mail=~('('.$slReRE.')')) {
$fm.="<b><font color='green'>&bull;</font> <a href='./#slRe'>Spamlover RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("slRe",$1);
$fm.="<font color='green'>&bull;</font> matching slRe($Config{'slRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
if ($testRe &&  $testReRE!="" && $mail=~('('.$testReRE.')')) {
$fm.="<b><font color='yellow'>&bull;</font> <a href='./#testRe'>Test RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("testRe",$1);
$fm.="<font color='yellow'>&bull;</font> matching testRe($Config{'testRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
if ($contentOnlyRe &&  $contentOnlyReRE!="" && $mail=~('('.$contentOnlyReRE.')')) {
$fm.="<b><font color='yellow'>&bull;</font> <a href='./#contentOnlyRe'>Restrict to Content Only RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("contentOnlyRe",$1);
$fm.="<font color='yellow'>&bull;</font> matching contentOnlyRe($Config{'contentOnlyRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if (!$DoBombRe) {
      $fm.="<b><font color='orange'>&bull;</font>Bomb Regular Expression not activated</b><br />\n";
    }
 if ($bombRe &&  $bombReRE!="" && $mail=~('('.$bombReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#bombRe'>BombRaw RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("bombRe",$1);
$fm.="<font color='red'>&bull;</font> matching bombRe($Config{'bombRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($bombDataRe &&  $bombDataReRE!="" && $mail=~('('.$bombDataReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#bombDataRe'>BombData RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("bombDataRe",$1);
$fm.="<font color='red'>&bull;</font> matching bombDataRe($Config{'bombDataRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($bombHeaderRe &&  $bombHeaderReRE!="" && $mail=~('('.$bombHeaderReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#bombHeaderRe'>BombHeader RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("bombHeaderRe",$1);
$fm.="<font color='red'>&bull;</font> matching bombHeaderRe($Config{'bombHeaderRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($bombSubjectRe &&  $bombSubjectReRE!="" && $mail=~('('.$bombSubjectReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#bombSubjectRe'>BombSubject RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("bombSubjectRe",$1);
$fm.="<font color='red'>&bull;</font> matching bombSubjectRe($Config{'bombSubjectRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
 if ($bombSuspiciousRe &&  $bombSuspiciousReRE!="" && $mail=~('('.$bombSuspiciousReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#bombSuspiciousRe'>BombSuspiciousRe RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("bombSuspiciousRe",$1);
$fm.="<font color='red'>&bull;</font> matching bombSuspiciousRe($Config{'bombSuspiciousRe'}): '$bombsrch'<br />\n" if $bombsrch;
}

if ($scriptRe &&  $scriptReRE!="" && $mail=~('('.$scriptReRE.')')) {
$fm.="<b><font color='red'>&bull;</font> <a href='./#scriptRe'>Script RE</a></b>: '$1'<br />\n";
my $bombsrch=SearchBomb("scriptRe",$1);
$fm.="<font color='red'>&bull;</font> matching scriptRe($Config{'scriptRe'}): '$bombsrch'<br />\n" if $bombsrch;
}
my $decob = decodeMimeWords($mail);


if ($helo) {
    $fm.="<b><font color='red'>&bull;</font> HELO Blacklist</b>: '$helo'</b><br />\n" if ($HeloBlack{lc $helo});
	$fm.="<b><font color='#66CC66'>&bull;</font> <a href='./#heloBlacklistIgnore'>HELO Blacklist Ignore</a></b>: '$helo'</b><br />\n" if ($heloBlacklistIgnore && $helo=~$HBIRE);
        if (!$DoValidFormatHelo) {
      $fm.="<b><font color='orange'>&bull;</font>Valid Format of HELO not activated</b><br />\n";
    }
if ($validFormatHeloRe)  {
if ($helo=~('('.$validFormatHeloReRE.')') ) {
      $fm.="<b><font color=#66CC66>&bull;</font> <a href='./#DoValidFormatHelo'>Valid Format of HELO</a></b>: '$helo'<br />\n";
    } else {
      $fm.="<b><font color='red'>&bull;</font> <a href='./#DoValidFormatHelo'>Not a Valid Format of HELO</a></b>: '$helo'<br />\n";
    }}
        if (!$DoInvalidFormatHelo) {
      $fm.="<b><font color='orange'>&bull;</font>Invalid Format of HELO not activated</b><br />\n";
    }
    if ($invalidFormatHeloRe && $helo=~('('.$invalidFormatHeloReRE.')')) {
      $fm.="<b><font color='red'>&bull;</font> <a href='./#DoInvalidFormatHelo'>Invalid Format of HELO</a></b>: '$helo'<br />\n";
    }
  }
  

if (exists $PBBlack{$ip}) {
my($ct,$ut,$pbstatus,$value,$sip,$reason)=split(" ",$PBBlack{$ip});
$fm.="<b><font color='red'>&bull;</font> $ip is in <a href='./#pbdb'>PB Black</a></b>: last event - $reason<br />\n" ;}
if (exists $PBWhite{$ip}) {
my($ct,$ut,$pbstatus,$sip,$reason)=split(" ",$PBWhite{$ip});
$fm.="<b><font color=#66CC66>&bull;</font> $ip is in <a href='./#pbdb'>PB White</a></b>: last event - $reason<br />\n" ;}
if ($whiteListedIPs && $ip=~$WLIPRE) {
$fm.="<b><font color=#66CC66>&bull;</font> IP $ip is in <a href='./#whiteListedIPs'>whiteListed IPs</a></b><br />\n" ;}
if ($noProcessingIPs && $ip=~$NPIPRE) {
$fm.="<b><font color=#66CC66>&bull;</font> IP $ip is in <a href='./#noProcessingIPs'>noProcessing IPs</a></b><br />\n" ;}
if (exists $RBLCache{$ip}) {
my($ct,$mm,$rbllists)=split(" ",$RBLCache{$ip});
$fm.="<b><font color='red'>&bull;</font> $ip is in RBLCache</b>: inserted at $mm by $rbllists<br />\n" ;}
if ($denySMTPConnectionsFrom && $ip=~$DSMTPCFCIDRRE) {
$fm.="<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFrom'>denySMTPConnectionsFrom(CIDR)</a></b><br />\n" ;}
if ($denySMTPConnectionsFrom && $ip=~$DSMTPCFRE) {
$fm.="<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFrom'>denySMTPConnectionsFrom</a></b><br />\n" ;}


if ($denySMTPConnectionsFromAlways && $ip=~$DSMTPCFACIDRRE) {
$fm.="<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFromAlways'>denySMTPConnectionsFromAlways(CIDR)</a></b><br />\n" ;}
if ($denySMTPConnectionsFromAlways && $ip=~$DSMTPCFARE) {
$fm.="<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFromAlways'>denySMTPConnectionsFromAlways</a></b><br />\n" ;}
  my @t; my %got;
  if(defined($Dnsbl{$ip}) || defined($Dnsbl{$ip3})) {
   $fm.="<b>* $ip dnsbl hit</b>: (adds 0.97 0.97)<br />\n";
   push(@t,0.97);
   push(@t,0.97);
  }
  if($griplist) {
    my $v;
    if ($ispip && $ip=~$ISPRE) {
       if ($ispgripvalue) {
        $v=$ispgripvalue;
      } else {
        $v=$Griplist{x};
      }
    } else {
      $v=$Griplist{$ip3} || $Griplist{x};
    }

   $fm.="<b><font color='gray'>&bull;</font> $ip3 has a Griplist value of $v</b>: (adds $v $v)<br />\n";
   push(@t,$v,$v) if $v;
  }
  $fm.="<br />Classification Influences: <font color=#66CC66><b>&bull;</b></font> positive, <font color='red'><b>&bull;</b></font> negative, <font color='orange'><b>&bull;</b></font> subjective, <font color='gray'><b>&bull;</b></font> neutral";
  $fm.="<br /><hr><br />";
  my ($v,$lt,$t,%seen);
   while($mail=~/([-\$A-Za-z0-9\'\.!\240-\377]+)/g) {
   next if length($1) > 20;
   $lt=$t; $t=lc $1;
   $t=~s/[,.']+$//; $t=~s/!!!+/!!/g; $t=~s/--+/-/g;
   my $j="$lt $t";
   next if $seen{$j}++>1;
   push(@t,$v) if ($v=$Spamdb{$j}); $got{$j}=$v if $v;
  }
  my $cnt=0;
  $ba.="<b><font size='3' color='#003366'>Bayesian Analysis:</font></b><br /><br /><table cellspacing='0' cellpadding='0'>";
  $ba.="<tr>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:right; font-size:small;\"><b>Bad Words</b></td>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:left; font-size:small; background-color:#F4F4F4\"><b>Bad Prob&nbsp;</b></td>
  <td style=\"padding-left:20px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:right; font-size:small;\"><b>Good Words</b></td>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:left; font-size:small; background-color:#F4F4F4\"><b>Good Prob</b></td>
  </tr>\n";
  foreach (sort {abs($got{$b}-.5)<=>abs($got{$a}-.5)} keys %got) {
   my $g=sprintf("%.4f",$got{$_});
   if($g < 0.5) {
    $ba.="<tr>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"></td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\"></td>
    <td style=\"padding-left:20px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\">$_</td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\">$g</td>
    </tr>\n";
   } else {
    $ba.="<tr>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\">$_</td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\">$g</td>
    <td style=\"padding-left:20px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"></td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\"></td>
    </tr>\n";
   }
   last if $cnt++ > 20;
  }
  $ba.="</td></tr></table>\n";
  @t=sort {abs($b-.5)<=>abs($a-.5)} @t;
  @t=@t[0..30];
  $st="<br />Totals: ";
  foreach (@t) {$st.=sprintf ("%.4f ",$_) if $_;}
  $st.="\n";
  #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p);}}
  #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p)*2;}}
  


 my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p);}}
 $SpamProb=$p1/($p1+$p2);
 $SpamProbConfidence=abs($p1-$p2);
$st.="<br /><hr><br /><b><font size=\"3\" color=\"#003366\">Spam/Ham Probabilities:</font></b><br /><br />\n<table cellspacing=\"0\" cellpadding=\"0\">" if $baysConfidence;
$st.="<br /><hr><br /><b><font size=\"3\" color=\"#003366\">Spam Probability:</font></b><br /><br />\n<table cellspacing=\"0\" cellpadding=\"0\">"  if !$baysConfidence;
$st.=sprintf(" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>spamprobability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",$p1) if $baysConfidence;
$st.=sprintf(" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>hamprobability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",$p2) if $baysConfidence;
$st.=sprintf(" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>combined probability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",$SpamProb) if $$baysConfidence;
$st.=sprintf(" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>probability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.4f</td></tr>\n",$SpamProb) if !$baysConfidence;
$st.=sprintf(" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>bayesian confidence</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",$SpamProbConfidence) if $$baysConfidence;

$st.=" </table><br /></div><br />";
  $mail=~s/([^\n]{70,84}[^\w\n<\@])/$1\n/g; $mail=~s/\s*\n+/\n/g; $mail=~s/<\/textarea>/\/textarea/ig;
 }
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Mail Analyzer</h2>
<div class="note">This page will show you how ASSP analyzes and pre-processes an email to come up with the assigned spam
probability.
</div><br />
$fm$ba$st
<form action="" method="post">
    <table class="textBox">
        <tr>
            <td class="noBorder" align="center">Copy and paste the mail header and
            body here:<br />
            <textarea name="mail" rows="10" cols="60" wrap="off">$mail</textarea>
            </td>
           
  
        </tr>
        <tr>
            <td class="noBorder" align="center"><input type="submit" name="B1" value=" Analyze " /></td>
            
        </tr>
    </table>
</form>
<br />
<p class="note">
  Note: Analysis is performed using the current spam database -- if yours was rebuilt
  since the time the mail was received you'll receive a different result.
</p>
<div class="textbox">
  <p>
	To use this form using <em>Outlook Express</em> do the following. 
	Right-click on the message of interest. Select <em>Properties</em>. 
	Click the <em>Details</em> tab. Click the <em>message source</em> button. 
	Right-click on the message source and click <em>Select All</em>. 
	Right-click again and click <em>Copy</em>. 
	Click on the text box above and paste (Ctrl-V perhaps). 
	Then click the <em>Analyze</em> button.
  </p>
  <p>
	The page will update to show you the following: if any of the email's 
	addresses are in the redlist or whitelist, the most and least spammy 
	phrases together with their spaminess, the resulting probabilities 
	(probabilities may repeat one time), and the final spam probability score.
  </p>
  <p>
	You may put here helo=aaa.bbb.helo or ip=123.123.123.123 to look up 
	the helo/ip information. text=abc will start a lookup in the regular 
	expression files for the "abc" matching regex.
  </p>
</div>
</div>
$footers
</body></html>
EOT
}

sub needEs {
 my ($count,$text,$es)=@_;
 return $count . $text . ($count==1 ? '' : $es);
}

# wrap long log lines
sub logWrap {
 my ($line,$indent)=@_;
 my $wraps=$MaillogTailWrapColumn+11; # has to be >= $indent, or while line loops infinitely
 my $wrape=$wraps+15;
 # wrap anchors are: space;-,.:= (but not &lt; &gt;)
 # matches are greedy to minimize number of line breaks
 # not a danger code as long as $wraps >= $indent
 while ($line=~s/(?:([^\r\n]{$wraps,$wrape}) |([^\r\n]{$wraps,$wrape}(?<![lg]t);)|([^\r\n]{$wraps,$wrape}[-,.:=])) {0,5}(?=[^\r\n]{5,}$)/$1$2$3\r\n$indent/) {};
 return $line;
}

sub encodeHTMLEntities {
 $s=shift;
 $s=~s/&/&amp;/gs;
 $s=~s/</&lt;/gs;
 $s=~s/>/&gt;/gs;
 $s=~s/"/&quot;/gs;
 return $s;
}

sub decodeHTMLEntities {
 $s=shift;
 $s=~s/&quot;?/"/gis;
 $s=~s/&gt;?/>/gis;
 $s=~s/&lt;?/</gis;
 $s=~s/&amp;?/&/gis;
 return $s;
}

sub ConfigMaillog {
 my $pat=$qs{search};
 my $s='';
 my $res='';
 # calculate indent
 my $m=localtime();
 $m=~s/^... (...) +(\d+) (\S+) ..(..)/$1-$2-$4 $3 /;
 my $indent=" " x length($m);
 if(!$pat) {
  open(F,"<$base/$logfile");
  seek(F,-$MaillogTailBytes,2) || seek(F,0,0);
  local $/;
  $s=<F>;
  close F;
  $s=encodeHTMLEntities($s);
  if ($MaillogTailWrapColumn>0) {
   my @sary=map{$_."\n"} split(/\r?\n|\r/,$s);
   foreach (@sary) {
    $_=logWrap($_,$indent);
    s/(\r\n\Q$indent\E)/<span style="background-color:white">$1<\/span>/g;
   }
   $s=join('',@sary);
  }
 } elsif ($CanSearchLogs) {
  my @sary;
  my $matches=0;
  my $lines=0;
  my $files=0;
  my ($logdir, $logdirfile) = $logfile=~/^(.*[\/\\])?(.*?)$/;
  my @logfiles=reverse sort glob("$base/$logdir*$logdirfile");
  my $logf=File::ReadBackwards->new(shift(@logfiles),'(?:\r?\n|\r)',1); # line terminator regex
  if ($logf) {
   $files++;
   my $maxmatches=$qs{limit} eq '1000' ? 1000 : $qs{limit} eq '100' ? 100 : $qs{limit} eq '10' ? 10 : 0;
   my $maxlines=lc $qs{files} eq 'lines' ? 10000 : 0;
   my $maxfiles=lc $qs{files} eq 'last' ? 2 : 0;
   $pat=encodeHTMLEntities($pat);
   # mormalize and strip redundand minuses
   $pat=~s/(?<!(?:-|\w))(-(?:\s+|\z))+/-/g;
   $pat=~s/\s+-$//;
   my $l=$logf->readline();
   # make line terminators uniform
   $l=~s/(.*?)(?:\r?\n|\r)/$1\n/;
   $l=encodeHTMLEntities($l);
   $l=addShowPath($l);
   my @ary;
   push(@ary,$l);
   my $infinity=10000;
   my $precontext=my $postcontext=$qs{nocontext} ? 0 : 6;
   my $notmatched=0;
   my $currentpre=0;
   my $seq=0;
   my $lastoutput=$infinity;
   my $cur=$ary[0];
   my $i=0;
   my @words=map/^\d+\_(.*)/, sort values %{{map{lc $_ => sprintf("%02d",$i++).'_'.$_} split(' ',$pat)}};
   $pat=join(' ', @words);
   my @highlights=('<span style="color:black; background-color:#ffff66">',
                   '<span style="color:black; background-color:#A0FFFF">',
                   '<span style="color:black; background-color:#99ff99">',
                   '<span style="color:black; background-color:#ff9999">',
                   '<span style="color:black; background-color:#ff66ff">',
                   '<span style="color:white; background-color:#880000">',
                   '<span style="color:white; background-color:#00aa00">',
                   '<span style="color:white; background-color:#886800">',
                   '<span style="color:white; background-color:#004699">',
                   '<span style="color:white; background-color:#990099">');
   my $findExpr=join(' && ',((map{'$cur=~/'.quotemeta($_).'/io'} map/^([^-].*)/, split(' ',$pat)),
                             (map{'$cur!~/'.quotemeta($_).'/io'} map/^-(.*)/, split(' ',$pat))));
   my %replace;
   my $j=0;
   my $highlightExpr='=~s/(';
   foreach (map/^([^-].*)/, split(' ',$pat)) {
    $replace{lc $_}=$highlights[$j % @highlights]; # pick highlight style
    $highlightExpr.=quotemeta($_).'|';
    if ($MaillogTailWrapColumn>0) {
     for ($i=1; $i<length($_); $i++) {
      # cover all possible positions of wrapping whitespaces
      my $word=$_;
      $word=~s/^(.{$i})/$1\r\n$indent/;
      $replace{lc $word}=$highlights[$j % @highlights];
      $highlightExpr.=quotemeta($word).'|';
     }
    }
    $j++;
   }
   $highlightExpr=~s/\|$//;
   $highlightExpr.=')/$replace{lc $1}$1<\/span>/gio';
   my $loop=<<'LOOP';
   while ($cur && !($maxmatches && $matches>=$maxmatches && $notmatched>$postcontext) && !($maxlines && $notmatched>=$maxlines)) {
LOOP
    $loop.='if (!($maxmatches && $matches>=$maxmatches) && '.$findExpr.') {'. <<'LOOP';
     $matches++;
     $cur=logWrap($cur,$indent) if $MaillogTailWrapColumn>0;
LOOP
     $loop.='$cur'.$highlightExpr.' unless $qs{nohighlight};'. <<'LOOP';
     if ($lastoutput<=$postcontext) {
      push(@sary,$cur);
     } else {
      push(@sary,"\r\n") if ($seq++ && ($precontext+$postcontext>0));
      for ($i=0; $i<@ary; $i++) {
       $ary[$i]=logWrap($ary[$i],$indent) if $MaillogTailWrapColumn>0;
       if ($i<$precontext && $currentpre==$precontext || $i<$currentpre) {
        $ary[$i]=~s/^(.*?)(\r?\n)$/<span style="color:#999999">$1<\/span>$2/s;
       } else {
LOOP
        $loop.='$ary[$i]'.$highlightExpr.' unless $qs{nohighlight};'. <<'LOOP';
       }
       push(@sary,$ary[$i]);
      }
     }
     $lastoutput=0;
     $notmatched=0;
    } elsif ($logf->eof) {
     for (; $currentpre>=0; $currentpre--) {
      shift(@ary);
     }
     $logf->close if exists $logf->{'handle'};
     if (!($maxfiles && $files>=$maxfiles)) {
      $logf=File::ReadBackwards->new(shift(@logfiles),'(?:\r?\n|\r)',1);
      $files++ if $logf;
     }
     $lastoutput=$infinity;
    } elsif ($lastoutput<=$postcontext) {
     $cur=logWrap($cur,$indent) if $MaillogTailWrapColumn>0;
     $cur=~s/^(.*?)(\r?\n)$/<span style="color:#999999">$1<\/span>$2/s;
     push(@sary,$cur);
    }
    $lastoutput++;
    $notmatched++;
    if ($l) {
     $l=$logf->readline();
     # make line terminators uniform
     $l=~s/(.*?)(?:\r?\n|\r)/$1\n/;
     $l=encodeHTMLEntities($l);
     $lines++;
    }
    push(@ary,$l);
    if ($currentpre<$precontext) {
     $currentpre++;
    } else {
     shift(@ary);
    }
    $cur=$ary[$currentpre];
    MainLoop2();
   }
LOOP
   eval $loop;
   $logf->close if exists $logf->{'handle'};
  }
  if ($matches>0) {
   $res='found '. needEs($matches,' matching line','s') .', searched in '. needEs($files,' log file','s') .' ('. needEs($lines,' line','s'). ')';
   if ($MaillogTailWrapColumn>0) {
   addShowPath(@sary); 
    # wipe out highlighted wrapping whitespaces
    s/(\r\n\Q$indent\E)/<span style="background-color:white">$1<\/span>/g foreach @sary;
   }
   $s=join('',reverse @sary);
  } else {
   $res='no results found, searched in '. needEs($files,' log file','s') .' ('. needEs($lines,' line','s'). ')';
  }
 } else {
  $s='<p class="warning">Please install required module <a href="http://search.cpan.org/~uri/File-ReadBackwards-1.03/" rel="external">File::ReadBackwards</a>.</p>';
 }
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Maillog Tail</h2>
<div class="note">
Press your browser's refresh to update this screen. Newest entries are at the end.
</div>
<form action="" method="get">
  <table class="textBox" style="width: 99%;">
    <tr>
      <td class="noBorder" align="right">
        <input type="text" name="search" value='$pat' size="20"/>
        <input type="submit" name="" value="Search" />
      </td>
      <td class="noBorder" align="center">
        <select size="1" name="files">
          <option selected="selected" value="lines">last 10.000 lines</option>
          <option value="last">last two log files</option>
          <option value="all">all log files</option>
        </select>
        <select size="1" name="limit">
          <option selected="selected" value="10">limit to 10 matches</option>
          <option value="100">limit to 100 matches</option>
          <option value="1000">limit to 1.000 matches</option>
     <!-- <option value="0">display all matches</option> -->
        </select>
      </td>
      <td class="noBorder">
        <input type="checkbox" name="nocontext"${\($qs{nocontext} ? ' checked="checked" ' : ' ')}value='1' />hide&nbsp;context&nbsp;lines<br />
        <input type="checkbox" name="nohighlight"${\($qs{nohighlight} ? ' checked="checked" ' : ' ')}value='1' />disable&nbsp;highlighting
      </td>
    </tr>
  </table>
</form>
<div class="log">
$res
<pre>
$s
</pre>
</div>
$maillogJump
</div>
$footers
</body></html>
EOT
}

sub ConfigEdit {
    my $fil  = $qs{ file };
    my $note = q{};
    my ( $s1, $s2, $editButtons );

    $cidr = $regexp1 = $regexp2 = q{};

    if ( $qs{ note } eq '1' ) {
        $note
            = '<div class="note" id="notebox">File should have one entry per line; anything on a line following a numbersign ( #) is ignored (a comment). Whitespace at the beginning or end of the line is ignored.</div>';
    }
    elsif ( $qs{ note } eq '2' ) {
        $note
            = '<div class="note" id="notebox">First line specifies text that appears in the subject of report message. The remaining lines are the report message body. </div>';
    }
    elsif ( $qs{ note } eq '3' ) {
        $note = '<div class="note" id="notebox">Put here comments to your assp installation.</div>';
    }
    elsif ( $qs{ note } eq '4' ) {
        $note
            = '<div class="note" id="notebox">For removal of entries from BlackBox  use <a onmousedown="toggleDisp(\'8\')" target="main" href="./#noPB">noPB</a>. 
For removal of entries from WhiteBox  use <a onmousedown="toggleDisp(\'8\')" target="main" href="./#noPBwhite">noPBwhite</a>. For  whitelisting IP\'s use <a onmousedown="toggleDisp(\'5\')" target="main" href="./#whiteListedIPs">Whitelisted IP\'s</a> or <a onmousedown="toggleDisp(\'4\')" target="main" href="./#noProcessingIPs">No Processing IP\'s</a>. For blacklisting use <a onmousedown="toggleDisp(\'2\')" target="main" href="./#denySMTPConnectionsFrom">Deny SMTP Connections From these IP\'s</a> and <a onmousedown="toggleDisp(\'2\')" target="main" href="./#denySMTPConnectionsFromAlways">Deny SMTP Connections From these IP\'s Strictly</a>.</div>';
    }
    elsif ( $qs{ note } eq '5' ) {
        $note = '<div class="note" id="notebox"></div>';
    }
    elsif ( $qs{ note } eq '6' ) {
        $note
            = '<div class="note" id="notebox">CacheEntry: IP/Domain \'11\' CacheIntervalStart 1=fail/2=pass Result/Comment</div\>';
    }
    elsif ( $qs{ note } eq '7' ) {
        $note = "<div class='note' id='notebox'>IP ranges are defined as '182.82.10.'</div>";
    }
    elsif ( $qs{ note } eq '8' ) {
        $note = '<div class="note" id="notebox"></div>';
    }

    $s2 = '';
    if ( $fil =~ /\.\./ ) {
        $s2 .= '<div class="text"><span class="negative">File path includes \'..\' -- access denied</span></div>';
        mlog( 0, "file path not allowed while editing file '$fil'" );
    }

    else {
        #$fil="$base/$fil" if $fil!~/^(([a-z]:)?[\/\\]|\Q$base\E)/;
        $fil = "$base/$fil" if $fil !~ /^\Q$base\E/i;
        if ( $qs{ B1 } =~ /delete/i ) {
            unlink($fil);
        }
        else {
            if ( defined( $qs{ contents } ) ) {
                $s1 = $qs{ contents };
                $s1 = decodeHTMLEntities($s1);
                $s1 =~ s/\n$//;    # prevents ASSP from appending a newline to the file each time it is saved.
                $s1 =~ s/\r$//;
                $s1 =~ s/\s+$//;
                open( F, ">", $fil );
                print F $s1;
                close F;
                $s2 = '<span class="positive">File saved successfully</span>';
            }
        }
        if ( open( F, "<$fil" ) ) {
            local $/;
            $s1 = <F>;
            # make line terminators uniform
            $s1 =~ s/(?:\r?\n|\r)/\n/g;
            $s1 = encodeHTMLEntities($s1);
            close F;
        }
        else {
            $s2 = '<span class="negative">' . ucfirst($!) . '</span>';
        }
        if ( -e $fil ) {
            my $fil2 = $fil;
            $fil2 =~ s/\\/\\\\/g; #fix missing \ in javascript alert
            
            $editButtons
                = '<div style="float: left"><input type="submit" name="B1" value="Save changes" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" name="B1" value="Delete file" onclick="return confirmDelete(\''
                . $fil2
                . '\');"/></div>
        <div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>'
                if ( $qs{ note } ne '8' );

            $editButtons
                = '<div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>'
                if ( $qs{ note } eq '8' );
        }
        else {
            $s2 = '<div class="text"><span class="positive">File deleted</span></div>'
                if $qs{ B1 } =~ /delete/i;
            $editButtons
                = '<div style="float: left"><input type="submit" name="B1" value="Save changes" /><input type="submit" name="B1" value="Delete file" disabled="disabled" /></div>
        <div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>';

        }
    } ## end else [ if ( $fil =~ /\.\./ )
    return <<"EOT";
$headerHTTP

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <title>ASSP File Editor ($myName $fil)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/editor.css\" type=\"text/css\" />
    <script type="text/javascript">
//<![CDATA[
    var wHeight=0,wWidth=0,owHeight=0,owWidth=0;function resizeInputs(){var contents=document.getElementById('contents');var notebox=document.getElementById('notebox');if(!isIE()){wHeight=self.innerHeight-(notebox.offsetHeight+60);wWidth=self.innerWidth-16}else{wHeight=document.body.clientHeight-(notebox.offsetHeight+60);wWidth=document.body.clientWidth-16}contents.style.height=Math.abs(wHeight)+'px';contents.style.width=Math.abs(wWidth)+'px'}function isIE(){var check,agent;check=/MSIE/i;agent=navigator.userAgent;if(check.test(agent)){return true}else{return false}}function confirmDelete(FileName){var strmsg="Are you sure you wish to delete: \\n"+FileName+"\\n This action cannot be undone";var agree=confirm(strmsg);if(agree)return true;else return false}
    //]]>
    </script>
</head>
<body onresize="resizeInputs();" onload="resizeInputs();" style=" overflow:hidden;">
    <div class="content">
      <form action="" method="post">
        <span style="float: left;">Contents of $fil file:</span>
        <div id="message" style="float: right">$s2</div>
        <br style="clear: both" />
        <textarea id="contents" name="contents" rows="15" cols="100" style="width: 100%; height: 60%; font-family: 'Courier New',Courier,monospace; " wrap="off">$s1
</textarea>
        $editButtons
	</form><br />
		$note
		</div>
    </div>
  </body>
</html>


EOT

} ## end sub ConfigEdit



sub webConfig{
 my $r = '';
 $ConfigChanged=0;
 # don't post partial data if somebody's browser's busted
 undef %qs unless $qs{theButton};
 my $counter = 0;
 foreach $c (@Config){
  if (@{$c} == 5){
   # Is a header
   @tmp = @{$c};
   push(@tmp, "setupItem$counter");
   $r .= $c->[3]->(@tmp);
   $counter++;
  }
  else{
   # Is a variable
   $r .= $c->[3]->(@{$c});
  }
 }
 if($ConfigChanged){


  SaveConfig();
  renderConfigHTML();
        PrintConfigSettings();
 }
  my $quit='<form action="quit" method="post">
<table class="textBox" style="width: 99%;">
  <tr><td class="noBorder" align="center">Panic button: </td></tr>
  <tr><td class="noBorder" align="center"><input type="submit" value="Terminate Now!" /></td></tr>
</table>
</form>' unless $AsAService;
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Configuration</h2>
<form action="" method="post">
<div>
$r
</div>
<div class="rightButton">
  <input name="theButton" type="submit" value="Apply Changes" />
</div>
<div class="note">
All fields accept a list separated by | or a file designated as follows (path relative to the ASSP directory): 'file:path/to/file/filename.txt'. File should have one entry per line; anything on a line following a numbersign ( #) is ignored (a comment).<br />
<br /><br />**&nbsp;&nbsp;Changes to these settings will not take effect until ASSP is restarted. Alternatively, if you are using the Restart Timeout option, you can wait for the restart timeout and settings will be reloaded at that time.

<br /><br />'kill -HUP $mypid' will load changed settings from disk. 'kill -USR2 $mypid' will save changed settings to disk.
</div>
</form>
$quit
<br />
$kudos
<br />
</div>
$footers
<script type="text/javascript">
<!--
  expand(0, 0);
  string = new String(document.location);
  string = string.substr(string.indexOf('#')+1);
  if(document.forms[0].length) {
    for(i = 0; i < document.forms[0].elements.length; i++) {
      if(string == document.forms[0].elements[i].name) {
        document.forms[0].elements[i].focus();
      }
    }
  }
// -->
</script>
</body></html>
EOT
}

sub Donations {
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Donations</h2>
<div class="note">
ASSP is here thanks to the following people, please feel free to donate to support the ASSP project.
</div>
<br />
<table style="width: 99%;" class="textBox">
<tr>
<td class="underline">John Hanna the founder and developer of ASSP up to version 1.0.12</td>
<td class="underline"><a href="https://www.paypal.com/xclick/business=johnhanna77%40yahoo.com&amp;item_name=Support+ASSP&amp;item_number=assp&amp;no_note=1&amp;tax=0&amp;currency_code=USD" rel="external">Donate</a></td>
</tr>
<tr>
<td class="underline">AJ the designer behind ASSP's web interface &amp; site.</td>
<td class="underline">&nbsp;</td>
</tr>
<tr>
<td class="underline">John Calvi the developer of ASSP from version 1.0.12.</td>
<td class="underline"><a href="https://www.paypal.com/xclick/business=jcalvi%40lewis.com.au&amp;item_name=Support+ASSP&amp;item_number=assp&amp;no_note=1&amp;tax=0&amp;currency_code=USD" rel="external">Donate</a></td>
</tr>
<tr>
<td class="underline">Robert Orso the developer of ASSP's LDAP functions.</td>
<td class="underline"><a href="https://www.paypal.com/xclick/business=ro%40astronomie.at&amp;item_name=Support+ASSP&amp;item_number=assp&amp;no_note=1&amp;tax=0&amp;currency_code=USD" rel="external">Donate</a></td>
</tr>
<tr>
<td class="underline">Przemek Czerkas the developer behind SRS, Greylisting/Delaying, Maillog Search
and ASSP 1.1.2 beta which became the foundation for 1.2.0 .</td>
<td class="underline">&nbsp;</td>
</tr>
<tr>
<td class="underline">Fritz Borgstedt the developer of ASSP since 1.2.0</td>
<td class="underline"><a href="https://www.paypal.com/xclick/business=fb%40iworld.de&amp;item_name=Support+ASSP&amp;item_number=assp&amp;no_note=1&amp;tax=0&amp;currency_code=USD" rel="external">Donate</a></td>
</tr>
<tr>
<td>&nbsp;</td>
<td></td>
</tr>
<tr>
<td colspan="2">
<div class="note">Special thanks go to......<br />
&nbsp;&nbsp;  Nigel Barling for his contributions to SPF &amp; RBL.<br />
&nbsp;&nbsp;  Mark Pizzolato for his contributions to SMTP Session Limits.<br />
&nbsp;&nbsp;  Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Andrew Macpherson, Javier Albinarrate for their contributions since 1.2.x.<br />

</div>
</td>
</tr>
</table>
<br />
$kudos
<br />
</div>
$footers
</body></html>
EOT
}

sub HTTPStrToTime {
 my $str=shift;
 if ($str=~/[SMTWF][a-z][a-z], (\d\d) ([JFMAJSOND][a-z][a-z]) (\d\d\d\d) (\d\d):(\d\d):(\d\d) GMT/) {
  my %MoY=qw(Jan 1 Feb 2 Mar 3 Apr 4 May 5 Jun 6 Jul 7 Aug 8 Sep 9 Oct 10 Nov 11 Dec 12);
  return eval {
   my $t=Time::Local::timegm($6, $5, $4, $1, $MoY{$2}-1, $3-1900);
   $t<0 ? undef : $t;
  };
 } else {
  return undef;
 }
}

sub GetFile{
 my $fil=$qs{file};
 if ($fil=~/\.\./) {
  mlog(0,"file path not allowed while getting file '$fil'");
  return <<EOT;
HTTP/1.1 403 Forbidden
Content-type: text/html

<html><body><h1>Forbidden</h1>
</body></html>
EOT
 }

 if ($fil !~ /^\Q$base\E/i) { 
  $fil="$base/$fil";
 }
 if (-e $fil) {
   my $mtime;
   if (defined ($mtime=$head{'if-modified-since'})) {
    if (defined ($mtime=HTTPStrToTime($mtime))) {
     if ($mtime>=[stat($fil)]->[9]) {
                    return "HTTP/1.1 304 Not Modified\n\r\n\r";
     }
    }
   }
   if(open(F,"<$fil")) {
    binmode F;
    local $/;
    my $s=<F>;
    close F;
    %mimeTypes=(
     'log|txt|pl' => 'text/plain',
     'htm|html' => 'text/html',
     'css' => 'text/css',
     'bmp' => 'image/bmp',
     'gif' => 'image/gif',
     'jpg|jpeg' => 'image/jpeg',
     'png' => 'image/png',
     'zip' => 'application/zip',
     'sh' => 'application/x-sh',
     'gz|gzip' => 'application/x-gzip',
     'exe' => 'application/octet-stream',
     'js' => 'application/x-javascript'
    );
    my $ct='text/plain'; # default content-type
    foreach $key (keys %mimeTypes) {
     $ct=$mimeTypes{$key} if $fil=~/\.($key)$/i;
    }
    $mtime=[stat($fil)]->[9];
    $mtime=gmtime($mtime);
    $mtime=~s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
    return <<EOT;
HTTP/1.1 200 OK
Content-type: $ct
Last-Modified: $mtime

$s
EOT
    }
   }
   return <<EOT;
HTTP/1.1 404 Not Found
Content-type: text/html

<html><body><h1>Not found</h1>
</body></html>
EOT

}

sub Shutdown {
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Shutdown/Restart</h2>
<div class="note">
Note: It's possible to restart, if ASSP runs as a service or in a script that restarts it after it stops,
otherwise this function can only shut ASSP down. In either case, shutdown is clean -- SMTP sessions are not
interrupted.
</div>
<br />
<table style="background-color: white; border-width: 0px; width: 500px">
<tr>
<td style="background-color: white; padding: 0px;">
<iframe src="/shutdown_frame" width="100%" height="300" frameborder="0" marginwidth="0" marginheight="0" scrolling="no"></iframe>
</td>
</tr>
</table>

</div>
$footers
</body></html>
EOT
}


sub ShutdownFrame {
    my $action = $qs{ action };
    my ( $s1, $s2, $editButtons, $query, $refresh );
    my $shutdownDelay = 2;

    my $timerJS = '
<script type="text/javascript">
  var ns=(navigator.appName.indexOf("Netscape")!=-1);
  var timerVal=parseInt(ns ? document.getElementById("myTimer1").childNodes[0].nodeValue : myTimer1.innerText);
  function countDown() {
    if (isNaN(timerVal)==0 && timerVal>=0) {
      if (ns) {
        document.getElementById("myTimer1").childNodes[0].nodeValue=timerVal--;
      } else {
        myTimer1.innerText=timerVal--;
      }
      setTimeout("countDown()",1000);
    }
  }
  countDown();
</script>';
    if ( $action =~ /abort/i ) {
        $shuttingDown = 0;
        $refresh      = 3;
        $s1           = 'Shutdown request aborted';
        $editButtons  = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />';
        $doShutdown = 0;
        $query      = '?nocache';
        mlog( 0, "shutdown/restart process aborted per admin request; SMTP session count:$smtpConcurrentSessions" );
    }
    elsif ( $action =~ /proceed/i || $shuttingDown ) {
        $shuttingDown = 1;
        $refresh = $smtpConcurrentSessions > 0 ? 2 : 60;
        $s1
            = $smtpConcurrentSessions > 0
            ? 'Waiting for ' . needEs( $smtpConcurrentSessions, ' SMTP session', 's' ) . ' to finish ...'
            : "Shutdown in progress, please wait: <span id=\"myTimer1\">$refresh</span>s$timerJS";
        $editButtons = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort "'
            . ( $smtpConcurrentSessions > 0 ? '' : ' disabled="disabled"' ) . ' />
'
            . ( $refresh > 1
            ? ''
            : '&nbsp;<input type="button" name="action" value=" View " onclick="javascript:window.open(\'shutdown_list?\',\'SMTP_Connections\',\'width=600,height=600,toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=yes,status=no,directories=no,resizable=yes\')" />'
            ) . '';

        $doShutdown = $smtpConcurrentSessions > 0 ? 0          : time + $shutdownDelay;
        $query      = $smtpConcurrentSessions > 0 ? '?nocache' : '?action=Success';
        mlog( 0, "shutdown/restart process initiated per admin request; SMTP session count:$smtpConcurrentSessions" )
            if $action =~ /proceed/i;
    }
    elsif ( $action =~ /success/i ) {
        $refresh     = 3;
        $s1          = 'ASSP restarted successfully.';
        $editButtons = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />';
        $doShutdown = 0;
        $query      = '?nocache';
    }
    else {
        $refresh = 1;

        $s1
            = $smtpConcurrentSessions > 0
            ? ( $smtpConcurrentSessions > 1 ? 'There are ' : 'There is ' )
            . needEs( $smtpConcurrentSessions, ' SMTP session', 's' )
            . ' active'
            : 'There are no active SMTP sessions';
        $editButtons = '<input type="submit" name="action" value=" Proceed " />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />&nbsp;
<input type="button" name="action" value=" View " onclick="javascript:window.open(\'shutdown_list?\',\'SMTP_Connections\',\'width=600,height=600,toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=yes,status=no,directories=no,resizable=yes\')" />';
        $doShutdown = 0;
        $query      = '?nocache';
    }
    my $quit = '<form action="quit" method="post">
<table class="textBox" style="width: 99%;">
  <tr><td class="noBorder" align="center">Panic button:</td></tr>
  <tr><td class="noBorder" align="center"><input type="submit" value="Terminate ASSP now!" /></td></tr>
</table>
</form>' unless $AsAService;
    <<"EOT";
$headerHTTP
$headerDTDTransitional
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <meta http-equiv="refresh" content="$refresh;url=/shutdown_frame$query" />
  <title>ASSP ($myName)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/shutdown.css\" type=\"text/css\" />
</head>
<body>
<div class="content">
<form action="" method="get">
  <table class="textBox">
    <tr>
      <td class="noBorder" nowrap>
        $editButtons&nbsp;&nbsp;&nbsp;$s1
      </td>
    </tr>
  </table>
</form>
</div>
<div class="content">

$quit
</div>
</body></html>
EOT
} ## end sub ShutdownFrame

# Micheal Espinola - Add new pop-up window for listing SMTP connection information, allowing
# the main window to be used for other tasks simultaniously. Window is fully resizable and
# scrollable. SMTP Connection list has been slightly reformatted for asthetics and readability.
sub ShutdownList {
    my $action = $qs{ action };
    my ( $s1, $s2, $editButtons, $query, $refresh );
    my $rowclass;
    my $shutdownDelay = 2;

    my $timerJS = '
<script type="text/javascript">
  var ns=(navigator.appName.indexOf("Netscape")!=-1);
  var timerVal=parseInt(ns ? document.getElementById("myTimer1").childNodes[0].nodeValue : myTimer1.innerText);
  function countDown() {
    if (isNaN(timerVal)==0 && timerVal>=0) {
      if (ns) {
        document.getElementById("myTimer1").childNodes[0].nodeValue=timerVal--;
      } else {
        myTimer1.innerText=timerVal--;
      }
      setTimeout("countDown()",1000);
    }
  }
  countDown();
</script>';
    $refresh = 1;
    $query   = '?nocache';
    $s1      = '<div style="float: left;">';
    $s1 .=
        $smtpConcurrentSessions > 0
        ? ( $smtpConcurrentSessions > 1 ? 'There are ' : 'There is ' )
        . needEs( $smtpConcurrentSessions, ' SMTP session', 's' )
        . ' active.</div>'
        : 'There are no active SMTP sessions.' . '</div>';
    $s1 .= '<div style="float: right;">' . localtime() . '</div><br />';

    $s2
        = "<tr><td class=\"conTabletitle\">#</td><td class=\"conTabletitle\">Remote IP</td><td class=\"conTabletitle\">HELO</td><td class=\"conTabletitle\">From</td><td class=\"conTabletitle\">Rcpt</td><td class=\"conTabletitle\">Relaying</td><td class=\"conTabletitle\">SPAM</td><td class=\"conTabletitle\">Bytes</td><td class=\"conTabletitle\">Duration</td><td class=\"conTabletitle\">Inactive</td></tr>";

    $tmpTimeNow = time();

    @tmpConKeys = keys(%Con);
    @tmpConSortedKeys
        = sort { $Con{ $a }->{ timestart } <=> $Con{ $b }->{ timestart } } @tmpConKeys;
    $tmpCount = 0;
    foreach $key (@tmpConSortedKeys) {
        if ( $Con{ $key }->{ ip } ) {
            $tmpCount++;
            $tmpDuration = $tmpTimeNow - $Con{ $key }->{ timestart };
            $tmpInactive = $tmpTimeNow - $Con{ $key }->{ timelast };
            if ( $tmpCount % 2 == 1 ) {
                $rowclass = "\n<tr>";
            }
            else {
                $rowclass = "\n<tr class=\"even\">";
            }
            $s2
                .= $rowclass
                . '<td><b>'
                . ($tmpCount)
                . '</b></td><td>'
                . $Con{ $key }->{ ip }
                . '</td><td>'
                . substr( $Con{ $key }->{ helo }, 0, 25 )
                . '</td><td>'
                . substr( $Con{ $key }->{ mailfrom }, 0, 30 )
                . '</td><td>'
                . substr( $Con{ $key }->{ rcpt }, 0, 30 )
                . '</td><td>'
                . $Con{ $key }->{ relayok }
                . '</td><td>'
                . $Con{ $key }->{ spamfound }
                . '</td><td>'
                . $Con{ $key }->{ maillength }
                . '</td><td>'
                . $tmpDuration
                . '</td><td>'
                . $tmpInactive
                . '</td></tr>';
        } ## end if ( $Con{ $key }->{ ip...
    } ## end foreach $key (@tmpConSortedKeys)

    <<EOT;
$headerHTTP
$headerDTDTransitional
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <meta http-equiv="refresh" content="$refresh;url=/shutdown_list$query" />
  <title>ASSP ($myName)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/assp.css\" type=\"text/css\" />
</head>
<body>
<div >
<div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>
<h2>SMTP Connections List</h2>
$s1
<table cellspacing="0" id="conTable">
$s2
</table>
<br />
</div>
</body></html>
EOT
} ## end sub ShutdownList


sub SaveConfig {
    rename( "$base/assp.cfg.bak", "$base/assp.cfg.bak.bak" );
    rename( "$base/assp.cfg",     "$base/assp.cfg.bak" );
    open( F, ">$base/assp.cfg" );
    foreach ( sort { "\U$a" cmp "\U$b" } keys %Config ) {
        print F "$_:=$Config{$_}\n";
    }
    close F;

    PrintConfigSettings();
}

sub backupFile {
    return unless $BackupCopies > 0;
    my $f  = shift;
    my $bf = $f;
    $bf =~ s/.*[\\\/]|/bak\//;
    my $i = $BackupCopies - 1;
    unlink("$base/$bf.$i");
    for ( ; $i > 0; $i-- ) { rename( "$base/$bf." . ( $i - 1 ), "$base/$bf.$i" ); }
    rename( $f, "$base/$bf.0" );
}


sub textinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error = checkUpdate($name,$valid,$onchange);
 my $value = encodeHTMLEntities($Config{$name});
 my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
 my $edit  = '';

 if ($value=~/^\s*file:\s*(.+)\s*/i){
  # the optionlist is actually saved in a file.
  my $fil = $1;
  # escape query string
  $fil  =~ s/([^\w\-.!~*\'() ])/sprintf("%%%02X",ord($1))/eg;
  $fil  =~ s/ /+/g;
  $edit = "<input type=\"button\" value=\" Edit file \" onclick=\"javascript:popFileEditor(\'$fil\',1);\" />";
 }
 # get rid of google autofill
 #$name=~s/(e)(mail)/$1_$2/gi;
 return "<a name=\"$name\"></a>
 <div class=\"shadow\">
  <div class=\"option\">
   <div class=\"optionTitle$cssoption\">$nicename</div>
   <div class=\"optionValue\">
    <input name=\"$name\" size=\"$size\" value=\"$value\" />
    $edit<br />
    $Error
    $description$cfgname\n
   </div>
  </div>
  &nbsp;
 </div>";
 
}
# everybody wants this, but I hate it -- use it if you care.
sub passinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $value=encodeHTMLEntities($Config{$name});
 my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
"<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">$nicename</div>
  <div class=\"optionValue\"><input type=\"password\" name=\"$name\" size=\"$size\" value=\"$value\" /><br />\n$Error$description$cfgname
  </div>
 </div>
 &nbsp;
 </div>";
}
sub checkbox {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $checked=$Config{$name}?'checked="checked"':'';
 my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
 "<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">
   <input type=\"checkbox\" name=\"$name\" value=\"1\" $checked />$nicename<br /></div>
  <div class=\"optionValue\">\n$Error$description$cfgname
  </div>
 </div>
 &nbsp;
 </div>";
}

sub heading {my ($description,$nodeId)=@_[4,5,6];
 "</div>
<div onmousedown=\"toggleDisp('$nodeId')\" class=\"contentHead\">
 $description
</div>
<div id=\"$nodeId\">\n";
}

sub checkUpdate {
 my ($name,$valid,$onchange)=@_;
 return '' unless %qs;
 if($qs{$name} ne $Config{$name}) {
  if($qs{$name}=~/$valid/i) {
   my $new=$1; my $info;
   my $old=$Config{$name};
   $Config{$name}=$new;
   if($onchange) {
    $info=$onchange->($name,$old,$new);
   } else {
    mlog(0,"AdminUpdate: $name changed from '$old' to '$new'");
    ${$name}=$new;
    # -- this sets the variable name with the same name as the config key to the new value
    # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
   }
   $ConfigChanged=1;
   return "<span class=\"positive\"><b>*** Updated $info</b></span><br />";
  } else {
   return "<span class=\"negative\"><b>*** Invalid: '$qs{$name}'</b></span><br />";
  }
 }
}
sub PrintConfigSettings {
my $header;
    open( F, ">$base/notes/configdefaults.txt" );
    foreach my $c (@Config) {
        $header = $c->[4];
        $header =~ s/\&amp;/&/g;
        print F "########## $header ##########\n" if $c->[0] eq "0";
        next                                      if $c->[0] eq "0";
        $desc = $c->[1];
        $desc =~ s/\<.*\>//g;
        my $c0 = uc $c->[0];

        if ( $c->[4] != $Config{ $c->[0] } ) {
            print F "$c->[0] -- $desc: $Config{$c->[0]} (Default: $c->[4]) \n";
        } else {
            #print F "$c->[0] -- $desc: $Config{$c->[0]}  \n";
        }
    }
    close F;

    open( F, ">$base/notes/config.txt" );
    foreach my $c (@Config) {
        $desc = $c->[7];
        if ( defined $desc ) {
            $desc =~ s/\<b\>//g;
            $desc =~ s/\<i\>//g;
            $desc =~ s/\<p\>//g;
            $desc =~ s/\<small\>//g;
            $desc =~ s/\<br \/\>//g;
            $desc =~ s/\<\/i\>//g;
            $desc =~ s/\<\/b\>//g;
            $desc =~ s/\<\/p\>//g;
            $desc =~ s/\<\/small\>//g;
            $desc =~ s/\<.*\>//g;
            $desc =~ s/\<.*\>//g;
        }

        my $c0  = uc $c->[0];
        my $act = "actual: $Config{$c->[0]}" if $Config{ $c->[0] };
        my $def = "default: $c->[4]" if $c->[4];
        
        print F "$c->[0]: $c->[1] -- $desc $def \n"
            if $Config{ $c->[0] } eq $c->[4] && $c->[0] ne "0";
        
        print F "$c->[0]: $c->[1] -- $desc $def  \n"
            if $Config{ $c->[0] } ne $c->[4] && $c->[0] ne "0";
        
        #headers
        $header = $c->[4];
        $header =~ s/\&amp;/&/g;
        print F "########## $header ##########\n" if $c->[0] eq "0";

    }
    close F;

}
 sub PrintConfigHistory {
 my($text)=@_;
 my $lt=localtime(time);
 $text=~s/^AdminUpdate://i;
 open(F,">>$base/notes/confighistory.txt");
 print F "$lt:  $text\n";
 close F;
}
 sub PrintAdminInfo {
 my($text)=@_;
 my $lt=localtime(time);
 $text=~s/^AdminUpdate://i;
 open(F,">>$base/notes/admininfo.txt");
 print F "$lt:  $text\n";
 close F;
}
# This function is called on startup to clean up some settings
# Primarily these are settings that might be absent from assp.cfg
# or settings that are not needed anymore after an upgrade
sub fixConfigSettings {
 $Config{base}=$base;
 
 if (exists $Config{ExtensionsToBlock}) {
  $Config{BadAttachL1}=$Config{ExtensionsToBlock};
  # ExtensionsToBlock is not used in this version
  delete $Config{ExtensionsToBlock};
 }
 if (exists $Config{EmailWhitelist}) {
  $Config{EmailWhitelistAdd}=$Config{EmailWhitelist};
  # EmailWhitelist is not used in this version
  delete $Config{EmailWhitelist};
 }


 # -- this sets the variable name with the same name as the config key to the new value
 # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
 foreach (keys %Config) {${$_}=$Config{$_};}
 # turn settings into regular expressions
 @PossibleOptionFiles=();
 @PossibleOptionFiles2=();
 foreach (@Config) {
        if ( defined $_->[6] ) {
  if($_->[6] eq 'ConfigMakeRe') {
   $silent=1 if($AsADaemon);
   ${$_->[0]}=optionList(${$_->[0]},$_->[0]);
   push(@PossibleOptionFiles,$_->[0]);
  } elsif($_->[6] eq 'ConfigCompileRe') {
   ConfigCompileRe($_->[0],'',${$_->[0]},'Initializing');
   push(@PossibleOptionFiles2,$_->[0]);
  }
 }
    }

updateBadAttachL1( 'BadAttachL1', '', $Config{ BadAttachL1 }, 'Initializing' );
updateGoodAttach( 'GoodAttach', '', $Config{ GoodAttach }, 'Initializing' );
updateSuspiciousAttach( 'SuspiciousAttach', '', $Config{ SuspiciousAttach }, 'Initializing' );

configChangeRT( 'configChangeRT', '', $Config{ smtpDestinationRT }, 'Initializing' );
configUpdateRBL( 'configUpdateRBL', '', $Config{ ValidateRBL }, 'Initializing' );
configUpdateRWL( 'configUpdateRWL', '', $Config{ ValidateRWL }, 'Initializing' );
configUpdateURIBL( 'configUpdateURIBL', '', $Config{ ValidateURIBL }, 'Initializing' );
configUpdateCA( 'configUpdateCA', '', $Config{ CatchAll }, 'Initializing' );


updateSRS( 'updateSRS', '', $Config{ EnableSRS }, 'Initializing' );
updateLog2( 'updateLog2', '', $Config{ freqNonSpam }, 'Initializing' );
updateLog3( 'updateLog3', '', $Config{ freqSpam }, 'Initializing' );

 
}

sub ConfigMakeRe {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: $name changed from '$old' to '$new'") unless $init || $new eq $old;
 $new=checkOptionList($new,$name,$init);
 $new=~s/([\.\[\]\-\(\)\*\+\\])/\\$1/g;
 $new||='^(?!)'; # regexp that never matches
 $MakeRE{$name}->($new);
 '';
}

# this checks and corrects a | separated list
# and handles the options in a file
sub checkOptionList {
 my ($value,$name,$init)=@_;
 my $fromfile=0;
 if ($value=~/^ *file: *(.+)/i) {
  # the option list is actually saved in a file.
  $fromfile=1;
  my $fil=$1; $fil="$base/$fil" if $fil!~/^\Q$base\E/i;
  local $/;
  my @s=stat($fil);
  my $mtime=$s[9];
  $FileUpdate{$fil}=$mtime;
  if (open(F,'<',$fil)) {
   $value=<F>;
   # clean off comments
   $value=~s/#.*//g;
   # replace newlines (and the whitespace that surrounds them) with a |
   $value=~s/\s*\n\s*/|/g;
   close F;
   mlog(0,"option list file '$fil' reloaded ($name)") unless (($init || !$MaintenanceLog));
  } else {
   mlog(0,"failed to open option list file for reading '$fil' ($name): $!");
   $value='';
  }
 }
 $value=~s/\|\|/\|/g;
 $value=~s/\s*\|/\|/g;
 $value=~s/\|\s*/\|/g;
 $value=~s/\|\|+/\|/g;
 $value=~s/^\s*\|?//;
 $value=~s/\|?\s*$//;
 $value=~s/\|$//;
 # set corrected value back in Config
 ${$name}=$Config{$name}=$value unless $fromfile;
 return $value;
}

sub ConfigCompileRe {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: $name changed from '$old' to '$new'") unless $init || $new eq $old;
 $new=checkOptionList($new,$name,$init);
 $new||='^(?!)'; # regexp that never matches
 # trim long matches to 32 chars including '...' at the end
 SetRE($name.'RE',$new,'msi',$name) if $RegexModifier;
 SetRE($name.'RE',$new,'si',$name) if !$RegexModifier;
 '';
}

sub optionList {
 # this converts a | separated list into a RE
 my ($d,$configname)=@_;
 $d=checkOptionList($d,$configname);
 $d=~s/([\.\[\]\-\(\)\*\+\\])/\\$1/g;
 $MakeRE{$configname}->($d);
 $d;
}

sub fileUpdated {
 my $fil=shift;

 $fil="$base/$fil" if $fil!~/^(([a-z]:)?[\/\\]|\Q$base\E)/;
 #$fil="$base/$fil" if $fil!~/^\Q$base\E/i;
 return 1 unless $FileUpdate{$fil};
 my @s=stat($fil);
 my $mtime=$s[9];
 $FileUpdate{$fil}!=$mtime;
}
sub configChangeRT {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: SMTP Destination Routing Table updated from '$old' to '$new'") unless $init || $new eq $old;
 $smtpDestinationRT=$new;
 $new=checkOptionList($new,'smtpDestinationRT',$init);
my $v;
for $v (split(/\|/,$new)) {
$v=~/(.*)\=\>(.*)/;
$crtable{$1} = $2; 
}

}
sub ConfigChangeMailPort {my ($name, $old, $new)=@_;
 if($> == 0 || $new >= 1024) {
  # change the listenport
  $listenPort=$new;
  if($lsn) {
   $readable->remove($lsn);
   $lsn->close();
  }
  $lsn = newListen($listenPort,\&NewSMTPConnection);
  mlog(0,"AdminUpdate: listening on new mail port $listenPort (changed from $old) ");
  return '';
 } else {
  # don't have permissions to change
  mlog(0,"AdminUpdate: request to listen on new mail port $new (changed from $old) -- restart required; euid=$>");
  return "<br />Restart required; euid=$>";
 }
}

sub ConfigChangeMailPort2 {my ($name, $old, $new)=@_;
 if($> == 0 || $new >= 1024) {
  # change the listenport2
  $listenPort2=$new;
  if($lsn2) {
   $readable->remove($lsn2);
   $lsn2->close();
  }
  $lsn2 = newListen($listenPort2,\&NewSMTPConnection);
  mlog(0,"AdminUpdate: listening on new secondary mail port $listenPort2 (changed from $old)");
  return '';
 } else {
  # don't have permissions to change
  mlog(0,"AdminUpdate: request to listen on new secondary mail port $new (changed from $old) -- restart required; euid=$>");
  return "<br />Restart required; euid=$>";
 }
}

sub ConfigChangeAdminPort {my ($name, $old, $new)=@_;
 if($> == 0 || $new >= 1024) {
  # change the listenport
  $webAdminPort=$new;
  $readable->remove($WebSocket);
  $WebSocket->close();
  $WebSocket = newListen($webAdminPort,\&NewWebConnection);
  if($WebSocket) {
   mlog(0,"AdminUpdate: listening on new admin port $new (changed from $old)");
  } else {
   # couldn't open the port -- switch back
   $webAdminPort=$old;
   $WebSocket = newListen($webAdminPort,\&NewWebConnection);
   mlog(0,"AdminUpdate: couldn't open new port -- still listening on $old");
   $Config{$name}=$old;
   return "<span class=\"negative\">Couldn't open new port $new</span>";
  }
  return '';
 } else {
  # don't have permissions to change
  mlog(0,"AdminUpdate: request to listen on new admin port $new (changed from $old) -- restart required; euid=$>");
  return "<br />Restart required; euid=$>";
 }
}

sub ConfigChangeRelayPort {my ($name, $old, $new)=@_;
 unless ($relayHost && $new) {
  if($Relay) {
   $readable->remove($Relay);
   $Relay->close();
   mlog(0,"AdminUpdate: relay port disabled");
   return '<br />relay port disabled';
  } else {
   return "<br />relayHost ($relayHost) and relayPort ($new) must be defined to enable relaying";
  }
 }
 if($> == 0 || $new >= 1024) {
  # change the listenport
  $relayPort=$new;
  if($Relay) {
   $readable->remove($Relay);
   $Relay->close();
  }
  $Relay=newListen($relayPort,\&NewSMTPConnection);
  mlog(0,"AdminUpdate: listening for relay connections at $relayPort ");
  return '';
 } else {
  # don't have permissions to change
  mlog(0,"AdminUpdate: request to listen on new relay port $new (changed from $old) -- restart required; euid=$>");
  return "<br />Restart required; euid=$>";
 }
}

sub ConfigChangeLogfile {my ($name, $old, $new)=@_;
 close LOG if $logfile;
 $logfile=$new;
 if($logfile && open(LOG,">>$base/$logfile")) {my $oldfh = select(LOG); $| = 1; select($oldfh);}
 mlog(0,"AdminUpdate: log file changed to '$new' from '$old'");
 '';
}
sub ConfigDEBUG {
    my ( $name, $old, $new ) = @_;
    close DEBUG if $DEBUG;
    $DEBUG = $new;
    if ($DEBUG) {
        open( DEBUG, ">$base/" . time . ".dbg" );
        binmode(DEBUG);
        my $oldfh = select(DEBUG);
        $| = 1;
        select($oldfh);
        eval(
            q[sub d {
   my $time=gmtime(); $time=~s/... (...) +(\d+) (........) ..(..)/$2 $1 $4 $3/;
   my $debugprint = $_[0];
           $debugprint =~ s/\n//;
           $debugprint =~ s/\r//;
           $debugprint =~ s/\s+$//;
   
   print DEBUG "$time <$debugprint>\n";
  }
  ]
        );
    }
    else {
        eval(q[sub d{return;}]);
    }
    mlog( 0, "AdminUpdate: debug file changed to '$new' from '$old' " );
    '';
} ## end sub ConfigDEBUG

# Good Attachment Settings, Checks and Update.
sub updateGoodAttach {my ($name, $old, $new, $init)=@_;

  mlog(0,"AdminUpdate: Goodattach Level 4 updated from '$old' to '$new'") unless $init;
  SetRE('goodattachRE',qq[content-\\w+: *\\s+.*name\\s*=\\s*"=\\?\\S+\\?\\S\\?\\S+\\.($new)\\?="?|\.($new)|content-\\w+: .*\\s+.*name\\s*=\\s*".*\\.(?:$new)"?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.($new)\\s],'i',"Good Attachment");

  SetRE('allattachRE',qq[content-\\w+: *\\s+.*name\\s*=\\s*".*\\.(.{0,20})"?|content-\\w+: *\\s+.*name\\s*=\\s*".*\\.(.{0,20})\?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.(.{0,20})\\s|content-\\w+: *\\s+.*filename\\s*=\\s*.*\\.(.{0,20})\\s],'i',"Any Attachment") if $init;
}
# bad attachment Settings, Checks and Update.
sub updateBadAttachL1 {my ($name, $old, $new, $init)=@_;
  mlog(0,"AdminUpdate: Badattach Level 1 updated from '$old' to '$new'") unless $init;
  SetRE('badattachL1RE',qq[content-\\w+: *\\s+.*name\\s*=\\s*"=\\?\\S+\\?\\S\\?\\S+\\.($new)\\?="?|content-\\w+: .*\\s+.*name\\s*=\\s*".*\\.($new)"?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.($new)\\s],'i',"bad attachment L1");
 updateBadAttachL2('BadAttachL2','',$Config{BadAttachL2},$new);
}
sub updateBadAttachL2 {my ($name, $old, $new, $init)=@_;
  mlog(0,"AdminUpdate: Badattach Level 2 updated from '$old' to '$new'") unless $init;
  $new.='|'.$init;
  SetRE('badattachL2RE',qq[content-\\w+: *\\s+.*name\\s*=\\s*"=\\?\\S+\\?\\S\\?\\S+\\.($new)\\?="?|content-\\w+: .*\\s+.*name\\s*=\\s*".*\\.($new)"?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.($new)\\s],'i',"bad attachment L2");
 updateBadAttachL3('BadAttachL3','',$Config{BadAttachL3},$new);
}
sub updateBadAttachL3 {my ($name, $old, $new, $init)=@_;
 mlog(0,"Badattach Level 3 updated from '$old' to '$new'") unless $init;
 $new.='|'.$init;
 SetRE('badattachL3RE',qq[content-\\w+: *\\s+.*name\\s*=\\s*"=\\?\\S+\\?\\S\\?\\S+\\.($new)\\?="?|content-\\w+: .*\\s+.*name\\s*=\\s*".*\\.($new)"?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.($new)\\s],'i',"bad attachment L3");
 $badattachRE[1]=$badattachL1RE;
 $badattachRE[2]=$badattachL2RE;
 $badattachRE[3]=$badattachL3RE;
 '';
}
sub updateSuspiciousAttach {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: Suspicious Attach updated from '$old' to '$new'") unless $init;
 $new.='|'.$init;
 SetRE('suspiciousattachRE',qq[content-\\w+: *\\s+.*name\\s*=\\s*"=\\?\\S+\\?\\S\\?\\S+\\.($new)\\?="?|content-\\w+: .*\\s+.*name\\s*=\\s*".*\\.($new)"?|content-\\w+: *\\s+.*name\\s*=\\s*.*\\.($new)\\s],'i',"suspicious attachment ");
 '';
}

sub updateTestMode{my ($name, $old, $new, $init)=@_;

$DoBayesian=$Config{DoBayesian}=4 if $Config{DoBayesian}==1 && $new==1 ;
$DoBayesian=$Config{DoBayesian}=1 if $Config{DoBayesian}==4 && $new<=1 ;

return '<span class="positive">Testmode activated</span>' if  $new==1;
return '<span class="negative">Testmode deactivated</span>' if  $new!=1;
mlog(0,"AdminUpdate: Bayesian TestMode updated from '$old' to '$new'") unless $init; 


}
sub configUpdateRBLCR {my ($name, $old, $new, $init)=@_;
mlog(0,"AdminUpdate: RBL Cache Refresh updated from '$old' to '$new'") unless $init;
&cleanCacheRBL;
}
sub configUpdatePTRCR {my ($name, $old, $new, $init)=@_;
mlog(0,"AdminUpdate: PTR Cache Refresh updated from '$old' to '$new'") unless $init;
&cleanCachePTR;
}
sub configUpdateRWLCR {my ($name, $old, $new, $init)=@_;
mlog(0,"AdminUpdate: RWL Cache Refresh updated from '$old' to '$new'") unless $init;
&cleanCacheRWL;
}
sub configUpdateMXACR {my ($name, $old, $new, $init)=@_;
mlog(0,"AdminUpdate: MXA Cache Refresh updated from '$old' to '$new'") unless $init;
&cleanCacheMXA;
}
sub configUpdateSPFCR {my ($name, $old, $new, $init)=@_;
    mlog( 0, "AdminUpdate: SPF Cache Refresh updated from '$old' to '$new'" ) unless $init || $new eq $old;
&cleanCacheSPF;
}
sub configUpdateURIBLCR {my ($name, $old, $new, $init)=@_;
mlog(0,"AdminUpdate: URIBL Cache Refresh updated from '$old' to '$new'") unless $init;
&cleanCacheURI;
}
# URIBL Settings Checks, and Update.
sub configUpdateURIBL {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: URIBL-Enable updated from '$old' to '$new'") unless $init;

 $ValidateURIBL=$Config{ValidateURIBL}=$new;
 unless ($CanUseURIBL) {
  mlog(0,"AdminUpdate:error URIBL-Enable updated from '1' to '', Net::DNS not installed") if $Config{ValidateURIBL};
  ($ValidateURIBL,$Config{ValidateURIBL})=();
  return '<span class="negative">*** Net::DNS must be installed before enabling URIBL.</span>';
 } else {
  configUpdateURIBLMH('URIBLmaxhits','',$Config{URIBLmaxhits},'Cascading');
 }
}
# RWL Settings Checks, and Update.
sub configUpdateRWL {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: RWL-Enable updated from '$old' to '$new'") unless $init;
 $ValidateRWL=$Config{ValidateRWL}=$new;
 unless ($CanUseRWL) {
  mlog(0,"AdminUpdate:error RWL-Enable updated from '1' to '', Net::DNS not installed") if $Config{ValidateRWL};
  ($ValidateRWL,$Config{ValidateRWL})=();
  return '<span class="negative">*** Net::DNS must be installed before enabling RWL.</span>';
 } else {
  configUpdateRWLMH('RWLminhits','',$Config{RWLminhits},'Cascading');
 }
}

sub configUpdateRWLMH {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: RWL Minimum Hits updated from '$old' to '$new'") unless $init;
 $RWLminhits=$new;
 if ($new<=0) {
  mlog(0,"AdminUpdate:error RWL-Enable updated from '1' to '', RWLminhits must be defined and positive") if $Config{ValidateRWL};
  ($ValidateRWL,$Config{ValidateRWL})=();
  return '<span class="negative">*** RWLminhits must be defined and positive before enabling RWL.</span>';
 } else {
  configUpdateRWLMR('RWLmaxreplies','',$Config{RWLmaxreplies},'Cascading');
 }
}

sub configUpdateRWLMR {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: RWL Maximum Replies updated from '$old' to '$new'") unless $init;
 $RWLmaxreplies=$new;
 if ($new<$RWLminhits) {
  mlog(0,"AdminUpdate:error RWL-Enable updated from '1' to '', RWLmaxreplies not >= RWLminhits") if $Config{ValidateRWL};
  ($ValidateRWL,$Config{ValidateRWL})=();
  return '<span class="negative">*** RWLmaxreplies must be more than or equal to RWLminhits before enabling RWL.</span>';
 } else {
  configUpdateRWLSP('RWLServiceProvider','',$Config{RWLServiceProvider},'Cascading');
 }
}

sub configUpdateRWLSP {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: RWL Service Providers updated from '$old' to '$new'") unless $init || $new eq $old;
 $RWLServiceProvider=$new;
 $new=checkOptionList($new,'RWLServiceProvider',$init);
 my $domains=($new=~s/\|/|/g)+1;
 if ($domains<$RWLmaxreplies) {
  mlog(0,"AdminUpdate:error RWL-Enable updated from '1' to '',RWLServiceProvider not >= RWLmaxreplies ") if $Config{ValidateRWL};
  ($ValidateRWL,$Config{ValidateRWL})=();
  return '<span class="negative">*** RWLServiceProvider must contain more than or equal to RWLmaxreplies  before enabling RWL.</span>';
 } elsif ($CanUseRWL) {
  my $res=Net::DNS::Resolver->new();
  @nameservers=$res->nameservers;
  @rwllist=split(/\|/,$new);
  if ($init && $ValidateRWL) {
   return ' & RWL activated';
  } else {
   return 'RWL deactivated';
  }
 }
}

# DNSBL Settings Checks, and Update.
sub configUpdateRBL {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: DNSBL-Enable updated from '$old' to '$new'") unless $init;
 $ValidateRBL=$Config{ValidateRBL}=$new;
 unless ($CanUseRBL) {
  mlog(0,"AdminUpdate:error DNSBL-Enable updated from '1' to '', Net::DNS not installed ") if $Config{ValidateRBL};
  ($ValidateRBL,$Config{ValidateRBL})=();
  return '<span class="negative">*** Net::DNS must be installed before enabling DNSBL.</span>';
 } else {
  configUpdateRBLMH('RBLmaxhits','',$Config{RBLmaxhits},'Cascading');
 }
}

sub configUpdateRBLMH {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: DNSBL Maximum Hits updated from '$old' to '$new'") unless $init;
 $RBLmaxhits=$new;
 if ($new<=0) {
  mlog(0,"AdminUpdate:error DNSBL-Enable updated from '1' to '', RBLmaxhits must be defined and positive before enabling DNSBL.</span>';") if $Config{ValidateRBL};
  ($ValidateRBL,$Config{ValidateRBL})=();
  return '<span class="negative">*** RBLmaxhits must be defined and positive before enabling DNSBL.</span>';
 } else {
  configUpdateRBLMR('RBLmaxreplies','',$Config{RBLmaxreplies},'Cascading');
 }
}

sub configUpdateRBLMR {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: DNSBL Maximum Replies updated from '$old' to '$new'") unless $init;
 $RBLmaxreplies=$new;
 if ($new<$RBLmaxhits) {
  mlog(0,"AdminUpdate:error DNSBL-Enable updated from '1' to '',RBLmaxreplies not >= RBLmaxhits") if $Config{ValidateRBL};
  ($ValidateRBL,$Config{ValidateRBL})=();
  return '<span class="negative">*** RBLmaxreplies must be more than or equal to RBLmaxhits before enabling DNSBL.</span>';
 } else {
  configUpdateRBLSP('RBLServiceProvider','',$Config{RBLServiceProvider},'Cascading');
 }
}

sub configUpdateRBLSP {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: DNSBL Service Providers updated from '$old' to '$new'") unless $init || $new eq $old;
 $RBLServiceProvider=$new;
 $new=checkOptionList($new,'DNSBLServiceProvider',$init);
 my $domains=($new=~s/\|/|/g)+1;
 if ($domains<$RBLmaxreplies) {
  mlog(0,"AdminUpdate:error DNSBL-Enable updated from '1' to '', DNSBLServiceProvider not >= maxreplies") if $Config{ValidateRBL};
  ($ValidateRBL,$Config{ValidateRBL})=();
  return '<span class="negative">*** DNSBLServiceProvider must contain more than or equal to maxreplies  before enabling DNSBL.</span>';
 } elsif ($CanUseRBL) {
  my $res=Net::DNS::Resolver->new();
  @nameservers=$res->nameservers;
  @rbllist=split(/\|/,$new);
  if ($init && $ValidateRBL) {
   return ' & DNSBL activated';
  } else {
   return 'DNSBL deactivated';
  }
 }
}

sub configUpdateURIBLMH {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: URIBL Maximum Hits updated from '$old' to '$new'") unless $init;
 $URIBLmaxhits=$new;
 if ($new<=0) {
  mlog(0,"AdminUpdate:error URIBL-Enable updated from '1' to '', URIBLmaxhits not > 0") if $Config{ValidateURIBL};
  ($ValidateURIBL,$Config{ValidateURIBL})=();
  return '<span class="negative">*** URIBLmaxhits must be defined and positive before enabling URIBL.</span>';
 } else {
  configUpdateURIBLMR('URIBLmaxreplies','',$Config{URIBLmaxreplies},'Cascading');
 }
}

sub configUpdateURIBLMR {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: URIBL Maximum Replies updated from '$old' to '$new', URIBLmaxreplies not >= URIBLmaxhits") unless $init;
 $URIBLmaxreplies=$new;
 if ($new<$URIBLmaxhits) {
  mlog(0,"AdminUpdate:error URIBL-Enable updated from '1' to ''") if $Config{ValidateURIBL};
  ($ValidateURIBL,$Config{ValidateURIBL})=();
  return '<span class="negative">*** URIBLmaxreplies must be more than or equal to URIBLmaxhits before enabling URIBL.</span>';
 } else {
  configUpdateURIBLSP('URIBLServiceProvider','',$Config{URIBLServiceProvider},'Cascading');
 }
}

sub configUpdateURIBLSP {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: URIBL Service Providers updated from '$old' to '$new'") unless $init || $new eq $old;
 $URIBLServiceProvider=$new;
 $new=checkOptionList($new,'URIBLServiceProvider',$init);
 my $domains=($new=~s/\|/|/g)+1;
 if ($domains<$URIBLmaxreplies) {
  mlog(0,"AdminUpdate:error URIBL-Enable updated from '1' to '', URIBLServiceProvider not >= URIBLmaxreplies") if $Config{ValidateURIBL};
  ($ValidateURIBL,$Config{ValidateURIBL})=();
  return '<span class="negative">*** URIBLServiceProvider must contain more than or equal to URIBLmaxreplies before enabling URIBL.</span>';
 } elsif ($CanUseURIBL) {
  my $res=Net::DNS::Resolver->new();
  @nameservers=$res->nameservers;
  @uribllist=split(/\|/,$new);
  if ($init && $ValidateURIBL) {
   return ' & URIBL activated';
  } else {
   return 'URIBL deactivated';
  }
 }
}
sub updateLDAPHost {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: LDAP Hosts updated from '$old' to '$new'") unless $init;
 $LDAPHost=$new;
if($CanUseLDAP && $DoLDAP) {
	@ldaplist = split(/\|/,$LDAPHost);
	$ldaplist = \@ldaplist;
	mlog($fh,"checking LDAP server at $LDAPHost -- ");
	$ldap = Net::LDAP->new( $ldaplist);
	
 if(! $ldap) {
  mlog($fh,"AdminUpdate:error couldn't contact LDAP server at $LDAPHost -- ");

    if (!$init) {
   return ' & LDAP not activated';
  } else {
   return '';
  }
 } else {
  mlog($fh,"AdminUpdate: LDAP server at $LDAPHost contacted -- ");
 if (!$init) {
 return ' & LDAP activated';
  } else {
   return '';
  }}
 }
}

sub configUpdateCA {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: Catch All Addresses updated from '$old' to '$new'") unless $init || $new eq $old;
 $CatchAll=$new;
 $new=checkOptionList($new,'CatchAll',$init);
 for $a (split(/\|/,$new)) {

 if($a=~/(\S*)\@(\S*)/) {

 $calist{$2}="$1";
 }
 }
}

sub configTestmode {
my ($name, $old, $new, $init)=@_;
return "";
}
sub updatePenaltyDuration {
my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: $name updated from '$old' to '$new'") unless $init;
&CleanPB unless $init;
return "";
}
sub updatePenaltyExpiration {
my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: $name updated from '$old' to '$new'") unless $init;
&CleanPB unless $init;
return "";
}


sub cleanBlackPB {
    if ( $PenaltyExpiration == 0 ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%PBBlack) ) {
                delete $PBBlack{ $k };
            }
        }
        else {
            $PBBlackObject->flush() if $PBBlackObject;
            unlink "$base/$pbdb.black.db.bak";
            rename( "$base/$pbdb.black.db", "$base/$pbdb.black.db.bak" );
            $PBBlackObject->DESTROY() if $PBBlackObject;
        }
        return;
    }

    my $ips_before = $ips_deleted = 0;
    my $t = time;
    my $tdif;
    my $newscore = 0;
    my ( $ct, $ut, $pbstatus, $score, $sip, $reason );
    my $expmin = $PenaltyExpiration * 60;
    delete $PBBlack{ "0.0.0.0" };
    delete $PBBlack{ "" };
    while ( ( $k, $v ) = each(%PBBlack) ) {
        ( $ct, $ut, $pbstatus, $score, $sip, $reason ) = split( " ", $v );
        $tdif   = $t - $ct;
        $tdifut = $t - $ut;
        $ips_before++;

        if ( $tdif > $PenaltyDuration * 60 && $score < $PenaltyLimit ) {
            delete $PBBlack{ $k };
            $ips_deleted++;
            next;
        }
        if ( $tdif > $PenaltyExpiration * 60 && $score < $PenaltyExtreme ) {
            delete $PBBlack{ $k };
            $ips_deleted++;
            next;
        }

        if (   exists $PBWhite{ $k }
            || ( $ispip   && $k =~ $ISPRE )
            || ( $noDelay && $k =~ $NDRE )
            || ( $noPB    && $k =~ $NPBRE )
            || ( $contentOnlyRe && $contentOnlyReRE != "" && $k =~ ( '(' . $contentOnlyReRE . ')' ) ) )
        {
            delete $PBBlack{ $k };
            $ips_deleted++;
            next;
        }
        if ( $tdifut > $ExtremeExpiration * 60 * 60 * 24 && $score >= $PenaltyExtreme ) {
            delete $PBBlack{ $k };
            $ips_deleted++;
            next;
        }
        MainLoop2();
    } ## end while ( ( $k, $v ) = each...
    if ( $ips_before == 0 ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%PBBlack) ) { delete $PBBlack{ $k }; }
        }
        else {
            $PBBlackObject->flush() if $PBBlackObject;
            unlink "$base/$pbdb.black.db.bak";
            rename( "$base/$pbdb.black.db", "$base/$pbdb.black.db.bak" );
            $PBBlackObject->DESTROY() if $PBBlackObject;
        }
    }
    mlog( 0, "PenaltyBox: cleaning BlackBox finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
        if $MaintenanceLog;
    MainLoop2();
} ## end sub cleanBlackPB

sub cleanWhitePB {
    my $ips_before = $ips_deleted = 0;
    my $t          = time;
    my $newscore   = 0;
    delete $PBWhite{ "0.0.0.0" };
    delete $PBWhite{ "" };

    while ( ( $k, $v ) = each(%PBWhite) ) {
        my ( $ct, $ut, $pbstatus, $score ) = split( " ", $v );
        $ips_before++;
        if ( $t - $ut >= $WhiteExpiration * 24 * 3600 ) {
            delete $PBWhite{ $k };
            $ips_deleted++;
        }
        MainLoop2();
    }
    if ( $ips_before == 0 ) {

    }
    else {
        mlog( 0, "PenaltyBox: cleaning WhiteBox finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
            if $MaintenanceLog;
    }
} ## end sub cleanWhitePB

sub cleanCacheRBL {
    my $ips_before = $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    while ( ( $k, $v ) = each(%RBLCache) ) {
        my ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $RBLCacheInterval * 3600 * 24 ) {
            delete $RBLCache{ $k };
            $ips_deleted++;
        }
    }
    mlog( 0, "DNSBLCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%RBLCache) ) { delete $RBLCache{ $k }; }
        }
        else {
            $RBLCacheObject->flush();
            unlink "$base/$pbdb.rbl.db.bak";
            rename( "$base/$pbdb.rbl.db", "$base/$pbdb.rbl.db.bak" );
            $RBLCacheObject->DESTROY();
            $RBLCache{ "" } = "" if $ips_before == 0;
        }
    }
} ## end sub cleanCacheRBL

sub cleanCachePTR {
    my $ips_before = $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    while ( ( $k, $v ) = each(%PTRCache) ) {
        my ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $PTRCacheInterval * 3600 * 24 ) {
            delete $PTRCache{ $k };
            $ips_deleted++;
        }
    }
    mlog( 0, "PTRCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%PTRCache) ) { delete $PTRCache{ $k }; }
        }
        else {
            $PTRCacheObject->flush();
            unlink "$base/$pbdb.ptr.db.bak";
            rename( "$base/$pbdb.ptr.db", "$base/$pbdb.ptr.db.bak" );
            $PTRCacheObject->DESTROY();
            $PTRCache{ "" } = "" if $ips_before == 0;
        }
    }
} ## end sub cleanCachePTR

sub cleanCacheRWL {
    my $ips_before = $ips_deleted = 0;
    my $t = time;
    while ( ( $k, $v ) = each(%RWLCache) ) {
        my ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $RWLCacheInterval * 3600 * 24 ) {
            delete $RWLCache{ $k };
            $ips_deleted++;
        }
    }
    mlog( 0, "RWLCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
        if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%RWLCache) ) { delete $RWLCache{ $k }; }
        }
        else {
            $RWLCacheObject->flush();
            unlink "$base/$pbdb.rwl.db.bak";
            rename( "$base/$pbdb.rwl.db", "$base/$pbdb.rwl.db.bak" );
            $RWLCacheObject->DESTROY();
            $RWLCache{ "" } = "" if $ips_before == 0;
        }
    }
} ## end sub cleanCacheRWL

sub cleanCacheMXA {
    my $ips_before = $ips_deleted = 0;
    my $ct;
    my $status;
    my $t = time;
    while ( ( $k, $v ) = each(%MXACache) ) {
        ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $MXACacheInterval * 3600 * 24 ) {
            delete $MXACache{ $k };
            $ips_deleted++;
        }
    }
    mlog( 0, "MXACache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
        if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%MXACache) ) { delete $MXACache{ $k }; }
        }
        else {
            $MXACacheObject->flush();
            unlink "$base/$pbdb.mxa.db.bak";
            rename( "$base/$pbdb.mxa.db", "$base/$pbdb.mxa.db.bak" );
            $MXACacheObject->DESTROY();
            $MXACache{ "" } = "" if $ips_before == 0;
        }
    }
} ## end sub cleanCacheMXA

sub cleanCacheSPF {
    my $ips_before = $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $result;
    while ( ( $k, $v ) = each(%SPFCache) ) {
        ( $ct, $status, $result ) = split( " ", $v );

        $ips_before++;
        if ( $result eq "timeout" and $t - $ct >= 0.5 * 3600 * 24 ) {
            delete $SPFCache{ $k };
            $ips_deleted++;
        }
        if ( $t - $ct >= $SPFCacheInterval * 3600 * 24 ) {
            delete $SPFCache{ $k };
            $ips_deleted++;
        }
    }
    mlog( 0, "SPFCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%SPFCache) ) { delete $SPFCache{ $k }; }
        }
        else {
            $SPFCacheObject->flush();
            unlink "$base/$pbdb.spf.db.bak";
            rename( "$base/$pbdb.spf.db", "$base/$pbdb.spf.db.bak" );
            $SPFCacheObject->DESTROY();
            $SPFCache{ "" } = "" if $ips_before == 0;
        }
    }
} ## end sub cleanCacheSPF

sub cleanCacheURI {
    my $domains_before = $domains_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    while ( ( $k, $v ) = each(%URIBLCache) ) {
        ( $ct, $status ) = split( " ", $v );

        $domains_before++;
        if ( $status == 2 && $t - $ct >= $URIBLCacheIntervalMiss * 3600 * 24 ) {
            delete $URIBLCache{ $k };
            $domains_deleted++;
            next;
        }
        if ( $t - $ct >= $URIBLCacheInterval * 3600 * 24 ) {
            delete $URIBLCache{ $k };
            $domains_deleted++;
        }
    }
    mlog( 0, "URIBLCache: cleaning cache finished; Domains before=$domains_before, deleted=$domains_deleted" )
        if $MaintenanceLog;
    if ( $domains_before == 0 || ( $domains_before >= 5000 && $domains_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( ( $k, $v ) = each(%URIBLCache) ) { delete $URIBLCache{ $k }; }
        }
        else {
            $URIBLCacheObject->flush();
            unlink "$base/$pbdb.uribl.db.bak";
            rename( "$base/$pbdb.uribl.db", "$base/$pbdb.uribl.db.bak" );
            $URIBLCacheObject->DESTROY();
            $URIBLCache{ "" } = "" if $domains_before == 0;
        }
    }
} ## end sub cleanCacheURI

sub saveSMTPconnections {
mlog(0,"sig HUP -- saving concurrent session stats");

open (SMTP, ">$base/smtp.txt") ;
print SMTP "$smtpConcurrentSessions\n" ;
close (SMTP);

}

sub exportExtreme {
my $myexport=$Config{"exportExtremeBlack"};
my $fil;
if($myexport=~/^\s*file:\s*(.+)\s*$/i) {
$fil=$1;
} else {
return;
}
$fil="$base/$fil" if $fil!~/^(([a-z]:)?[\/\\]|\Q$base\E)/;


open (EXPORT, ">$fil.tmp");
my $counter=0;
my ($k,$v,$ct,$ut,$pbstatus,$score,$sip,$reason);
while (($k,$v)=each(%PBBlack)) {
($ct,$ut,$pbstatus,$score,$sip,$reason)=split(" ",$v);
next if $k=~/\.0$/;
if ($score>=$PenaltyExtreme) {
my ($sec,$min,$hour,$mday,$mon,$year) = localtime($ct);
$mon++; $year-=100;
my $mm=sprintf("%02d-%02d-%02d",$year,$mon,$mday);
print EXPORT "$k\n" ;
$counter++;
}
}
mlog(0,"PenaltyBox: $fil exported, entries:$counter") if $MaintenanceLog;
close (EXPORT);
unlink "$fil.bak"; 
rename("$fil","$fil.bak");
rename("$fil.tmp","$fil");
}
sub deleteNP {
my ($name,$reason)=shift;
return if ($EmailNoNPRemove==1);
my $mynp=$Config{"noProcessing"};
if($mynp=~/^\s*file:\s*(.+)\s*$/i) {
$fil=$1;
} else {
return;
}
$fil="$base/$fil" if $fil!~/^(([a-z]:)?[\/\\]|\Q$base\E)/;
return if ( !-e "$fil");
my (@lines,$nlines,$kk);
open (NP, $fil);
@lines = <NP>;
close (NP);
unlink "$fil.bak"; 
rename("$fil","$fil.bak");
open (NP, ">$fil");

foreach my $k (@lines) {
        mlog( 0, "$name deleted from NoProcessing-List - $reason" ) if $k =~ /$name/i;
        PrintAdminInfo("email - $name deleted from NoProcessing-List") if $k =~ /$name/i;

next if $k=~/$name/i;
print NP "$k";
}
close (NP);
}
# SRS Settin Checks, and Update.
sub updateSRS {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: SRS-Enable updated from '$old' to '$new'") unless $init;
 $EnableSRS=$Config{EnableSRS}=$new;
 if (!$CanUseSRS) {
  mlog(0,"AdminUpdate: SRS-Enable updated from '1' to '', Mail::SRS not installed") if $Config{EnableSRS};
  $EnableSRS=$Config{EnableSRS}=undef;
  return '<span class="negative">*** Mail::SRS must be installed before enabling SRS.</span>';
 } else {
  updateSRSAD('updateSRSAD','',$Config{SRSAliasDomain},'Cascading');
 }
}
sub updateSRSAD {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: SRS Alias Domain updated from '$old' to '$new'") unless $init;
 $SRSAliasDomain=$new;
 if ($new eq '') {
  mlog(0,"AdminUpdate: SRS-Enable updated from '1' to '', SRSAliasDomain not defined ") if $Config{EnableSRS};
  $EnableSRS=$Config{EnableSRS}=undef;
  return '<span class="negative">*** SRSAliasDomain must be defined before enabling SRS.</span>';
 } else {
  updateSRSSK('updateSRSSK','',$Config{SRSSecretKey},'Cascading');
 }
}
sub updateSRSSK {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: SRS Secret Key updated from '*****' to '*****'") unless $init;
 $SRSSecretKey=$new;
 if (length($new)<5) {
  mlog(0,"AdminUpdate: SRS-Enable updated from '1' to '', SRSSecretKey not at least 5 characters long ") if $Config{EnableSRS};
  $EnableSRS=$Config{EnableSRS}=undef;
  return '<span class="negative">*** SRSSecretKey must be at least 5 characters long before enabling SRS.</span>';
 } elsif($CanUseSRS) {
  if ($init && $EnableSRS) {
   return ' & SRS activated';
  } else {
   return '';
  }
 }
}

# Database File Logging Frequency Setup.
sub updateLog2 {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: Non Spam Logging Frequency updated from '$old' to '$new'") unless $init;
 $logFreq[2]=$new;

}
sub updateLog3 {my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: Spam Logging Frequency updated from '$old' to '$new'") unless $init;
 $logFreq[3]=$new;
 return '';
}

sub reloadConfigFile {
 # called on SIG HUP
 my %newConfig;
 mlog(0,"sig HUP -- reloading config");
open(F,"<$base/assp.cfg"); local $/; (%newConfig)=split(/:=|\n/,<F>); close F;
 foreach $c (@Config) {
  my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description)=@$c;
  if($Config{$name} ne $newConfig{$name}) {
   if($newConfig{$name}=~/$valid/i) {
    my $new=$1; my $info;
    if($onchange) {
     $info=$onchange->($name,$Config{$name},$new);
    } else {
     mlog(0,"AdminUpdate: $name changed from '$Config{$name}' to '$new'");
     ${$name}=$new;
     # -- this sets the variable name with the same name as the config key to the new value
     # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
    }
    $Config{$name}=$new;
   } else {
    mlog(0,"AdminUpdate:error: invalid '$newConfig{$name}' -- not changed");
   }
  }
 }
  foreach $f (@PossibleOptionFiles) {
   ${$f}=optionList($Config{$f},$f) if $Config{$f}=~/^\s*file:\s*(.+)\s*$/i && fileUpdated($1);
  }
  foreach $f (@PossibleOptionFiles2) {
   ConfigCompileRe($f,'',${$f},'Initializing') if $Config{$f}=~/^\s*file:\s*(.+)\s*$/i && fileUpdated($1);
  }
 # reopen log file, just for fun.
  close LOG;
  if(open(LOG,">>$base/$logfile")) {my $oldfh = select(LOG); $| = 1; select($oldfh);}
  print LOG "Logfile reopened on HUP\n";
    renderConfigHTML();
} ## end sub reloadConfigFile

#####################################################################################
#                orderedtie
{
package orderedtie;
# This is a tied value that caches lookups from a sorted file; \n separates records,
# \002 separates the key from the value. After main::OrderedTieHashSize lookups the cache is
# cleared. This give us most of the speed of the hash without the huge memory overhead of storing
# the entire hash and should be totally portable. Picking the best value for n requires some
# tuning. A \n is required to start the file.

# if you're updating entries it behoves you to call flush every so often to make sure that your
# changes are saved. This also frees the memory used to remember updated values.

# for my purposes a value of undef and a nonexistant key are the same

# Obviously if your keys or values contain \n or \002 it will totally goof things up.


sub TIEHASH {
 my ($c,$fn)=@_;
 my $self={
  fn => $fn,
  age => mtime($fn),
  cnt => 0,
  cache => {},
  updated => {},
  ptr => 1,
 };
 bless $self, $c;
 return $self;
}
sub DESTROY { $_[0]->flush(); }

sub mtime { my @s=stat($_[0]); $s[9]; }

sub flush {
 my $this=shift;
 return unless %{$this->{updated}};
 my $f=$this->{fn};
 open(O,">$f.tmp") || return undef;
 binmode(O);
 open(I,"<$f") || print O "\n";
 binmode(I);
 local $/="\n";
 my @l=(sort keys %{$this->{updated}});
 my ($k,$d,$r,$v);
 while($r=<I>) {
  ($k,$d)=split("\002",$r);
  while(@l && $l[0] lt $k) {
   $v=$this->{updated}{$l[0]};
   print O "$l[0]\002$v\n" if $v;
   shift(@l);
  }
  if($l[0] eq $k) {
   $v=$this->{updated}{$l[0]};
   print O "$l[0]\002$v\n" if $v;
   shift(@l);
  } else {
   print O $r;
  }
 }
 while(@l) {
  $v=$this->{updated}{$l[0]};
  print O "$l[0]\002$v\n" if $v;
  shift(@l);
 }
 close I; close O; unlink($f); rename("$f.tmp", $f);
 $this->{updated}={};
}

sub STORE {
 my ($this, $key, $value)=@_;
 $this->{cache}{$key}=$this->{updated}{$key}=$value;
}

sub FETCH { my ($this, $key)=@_;
 return $this->{cache}{$key} if exists $this->{cache}{$key};
 $this->resetCache() if($this->{cnt}++ >$main::OrderedTieHashSize || ($this->{cnt} & 0x1f) == 0 && mtime($this->{fn}) != $this->{age});

 return $this->{cache}{$key}=binsearch($this->{fn},$key);
}

sub resetCache {
 my $this=shift;
 $this->{cnt}=0;
 $this->{age}=mtime($this->{fn});
 $this->{cache}={%{$this->{updated}}};

}

sub binsearch {
 my ($f,$k)=@_;
 open(F,"<$f") || return undef;
 binmode(F);
 my $count=0;
 my $siz=my $h=-s $f;
 $siz-=1024;
 my $l=0;
 my $k0=$k;
 $k=~s/([\[\]\(\)\*\^\!\|\+\.\\\/\?\`\$\@\{\}])/\\$1/g; # make sure there's no re chars unqutoed in the key
 while(1) {
  my $m=(($l+$h)>>1)-1024;
  $m=0 if $m < 0;
  seek(F,$m,0);
  my $d; my $read= read(F,$d,2048);
  if( $d=~/\n$k\002([^\n]*)\n/) {
   close F;
   return $1;
  }
  my ($pre,$first,$last,$post)=$d=~/^(.*?)\n(.*?)\002.*\n(.*?)\002.*?\n(.*?)$/s;
  last unless defined $first;
  if($k0 gt $first && $k0 lt $last) {
   last;
  }
  if($k0 lt $first) {
   last if $m ==0;
   $h=$m-1024+length($pre);
   $h=0 if $h < 0;
  }
  if($k0 gt $last) {
   last if $m >= $siz;
   $l=$m+$read-length($post);
  }
  if($count++ > 100) {
   #main::mlog(0,"Warning: $this->{fn} must be repaired ($k0)");
   last;
  }
 }
 close F;
 return undef;
}

sub FIRSTKEY { $this=shift;
 $this->flush();
 $this->{ptr}=1;
 $this->NEXTKEY();
}
sub NEXTKEY { my ($this, $lastkey)=@_;
 local $/="\n";
 open(F,"<$this->{fn}") || return undef;
 binmode(F);
 seek(F,$this->{ptr},0);
 my $r=<F>;
 return undef unless $r;
 $this->{ptr}=tell F;
 close F;
 my ($k,$v)=$r=~/(.*?)\002(.*?)\n/s;
 if(!exists($this->{cache}{$k}) && $this->{cnt}++ >$main::OrderedTieHashSize) {
  $this->{cnt}=0;
  $this->{cache}={%{$this->{updated}}};
 }
 $this->{cache}{$k}=$v;
 $k;
}

sub EXISTS { my ($this, $key)=@_;
 return FETCH($this, $key);
}

sub DELETE {my ($this, $key)=@_;
 $this->{cache}{$key}=$this->{updated}{$key}=undef;
}

sub CLEAR {my ($this)=@_;
 open(F,">$this->{fn}"); binmode(F); print F "\n"; close F;
 $this->{cache}={};
 $this->{updated}={};
 $this->{cnt}=0;
}
}


{
#################################################################
# this package implements a pure perl virus scanner by ClamAv
# it is based on File::Scan::ClamAV
# use the Clamd anti-virus daemon (see www.clamav.net)
#
# copyright (C) 2006, Max Birintsev, www.b2emotion.com  
# under the terms of the GPL. All rights reserved

package AvClamd;

sub init { 
	my($proto,$args)=@_;
	$port = $args->{port};
	$clamavd = new File::Scan::ClamAV(port => $port);
}

sub version {
	$VerAvClamd=eval('File::Scan::ClamAV->VERSION'); 
	$ver="$VerAvClamd" if $VerAvClamd;
	return $ver;
}

sub ping {
	return $clamavd->ping();
}

sub errstr {
	return $clamavd->errstr();
}

# public function to create a new scan buffer -- see addchar below
sub new {
 	bless({offset=>0, buf=>'', prereq=>{}}, ref($_[0]) || $_[0]);
}

# public function to reset the scan buffer
sub clear {
	my $self=shift; 
	$self->{offset}=0; 
	$self->{buf}=''; 
	$self->{prereq}={};
}

sub scanBuf {
	my $self=shift;
	return $clamavd->streamscan($self->{buf});
}

}


#################################################################
# this package implements realtime blacklisting
# it is based on Net::RBLClient by Asher Blum <asher@wildspark.com>
# CREDITS Martin H. Sluka <martin@sluka.de>
# Copyright (C) 2002 Asher Blum.  All rights reserved.
# This code is free software; you can redistribute it and/or modify it under
# the same terms as Perl itself.
# Modified for integration with ASSP by John Calvi.


package RBL;

use IO::Socket;

sub new {
    # This avoids compile time errors if Net::DNS is not installed.
    # The error will be returned on the lookup function call.
    if ($main::CanUseDNS) {
     require Net::DNS::Packet;
     $CanUseDNS=1;
    }
    my($class, %args) = @_;
    my $self = {
        lists       => [ lists() ],
        query_txt   => 1,
        max_time    => 10,
        timeout     => 1,
        max_hits    => 3,
        max_replies => 6,
        udp_maxlen  => 4000,
        server      => '127.0.0.1',
    };
    bless $self, $class;
    foreach my $key(keys %args) {
        defined($self->{ $key })
            or return "Invalid key: $key";
        $self->{ $key } = $args{ $key };
    }

    $self;
}

sub lookup {
    return "Net::DNS package required" unless $CanUseDNS;
    my($self, $target, $type) = @_;
    my $start_time = time;
    my $qtarget;
    $target =~ s/[^\w\-\.].*$//;
    if ($target=~/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) {
     $qtarget = join ('.', reverse(split /\./, $target))
    } else {
     $qtarget=$target;
    }
    my $deadline = time + $self->{ max_time };

    my $sock = IO::Socket::INET->new(
        Proto     => 'udp',
        PeerPort  => 53,
        PeerAddr  => $self->{ server },
    ) or return "Failed to create UDP client";

    if ( $self->{ query_txt } ) {
      foreach my $list(@{ $self->{ lists } }) {
      return "domain name too long" if length($qtarget.$list) >62;
        my($msg_a, $msg_t) = mk_packet($qtarget, $list);
        foreach ($msg_a, $msg_t) {
          $sock->send($_) or return "send: $!";
        }
      }
    } else {
        foreach my $list(@{ $self->{ lists } }) {
        return "domain name too long" if length($qtarget.$list) >62;
          my $msg = mk_packet($qtarget, $list);
          $sock->send($msg) || return "send: $!";
        }
    }

    $self->{ results } = {};
    $self->{ txt } = {};

    my $needed = 0;
    if ($self->{ max_replies} > @{ $self->{ lists } }) {
      $needed = @{ $self->{ lists } };
    } else {
      $needed = $self->{ max_replies };
    }
    $needed <<= 1 if $self->{ query_txt }; # how many packets needed back
    my $hits = my $replies = 0;

    my $select = new IO::Select;
    $select->add($sock);

    # Keep receiving packets until one of the exit conditions is met:
    main::mlog( 0, "Commencing $type checks on $target" )
      if $main::RBLLog == 1 && $type eq "DNSBL"
          || $main::URIBLLog == 1 && $type eq "URIBL"
          || $main::RWLLog == 1   && $type eq "RWL";
    while($needed && time < $deadline) {
      my $msg = '';
      my $dur = time - $start_time;
      if( my @ready = $select->can_read($self->{ timeout }) ){
        $sock->recv($msg, $self->{ udp_maxlen })  || return "recv: $!";
      } else {
        # waiting for other replies.
      }
      if($msg) {
        my ($domain, $res, $type) = decode_packet($msg);
        if ( defined $type && $type eq 'TXT' ) {
          $self->{ txt }{ $domain } = $res
        }
        elsif ($res) {
          $replies ++;
          $hits ++ if $res;
          $self->{ results }{ $domain } = $res;
          
          return 1 if ((!$Showmaxreplies && $hits >= $self->{ max_hits }) || $replies >= $self->{ max_replies });
                          
                        
        }
        $needed --;
      }
      }
    main::mlog( 0, "Completed $type checks on $target" )
      if $main::RBLLog == 1 && $type eq "DNSBL"
          || $main::URIBLLog == 1 && $type eq "URIBL"
          || $main::RWLLog == 1   && $type eq "RWL";
    close ($sock);
    1;
}

sub listed_by {
    my $self = shift;
    sort keys %{ $self->{ results } };
}

sub listed_hash {
    my $self = shift;
    %{ $self->{ results } };
}

sub txt_hash {
    my $self = shift;
    warn <<_ unless $self->{ query_txt };
Without query_txt turned on, you won't get any results from ->txt_hash().
_
    if (wantarray) { %{ $self->{ txt } } }
    else { $self->{ txt } }
}


# End methods - begin internal functions

sub mk_packet {
    # pass me a REVERSED dotted quad ip (qip) and a blocklist domain
    my($qip, $list) = @_;
    my ( $packet, $txt_packet, $error );
    ( $packet, $error ) = new Net::DNS::Packet( my $fqdn = "$qip.$list", 'A' );
    return "Cannot build DNS query for $fqdn, type A: $error" unless $packet;
    return $packet->data unless wantarray;
    ( $txt_packet, $error ) = new Net::DNS::Packet( $fqdn, 'TXT', 'IN' );
    return "Cannot build DNS query for $fqdn, type TXT: $error"
      unless $txt_packet;
    $packet->data, $txt_packet->data;
}

sub decode_packet {
    # takes a raw DNS response packet
    # returns domain, response
    my $data = shift;
    my $packet = Net::DNS::Packet->new(\$data);
    my @answer = $packet->answer;

    {
        my($res, $domain, $type);
        foreach my $answer (@answer) {
            {
                my $name = lc $answer->name;

                $domain = $answer->name;
            }
            $domain =~ s/^\d+\.\d+\.\d+\.\d+\.//;
            $type = $answer->type;
            $res = $type eq 'A'     ? inet_ntoa($answer->rdata)  :
                   $type eq 'CNAME' ?   cleanup($answer->rdata)  :
                   $type eq 'TXT'   ? (defined $res && "$res; ")
                                      . $answer->txtdata         :
                   '?';
            last if $type =~ m/^(A|CNAME)$/;
        }
        return $domain, $res, $type if defined $res;
    }

    # OK, there were no answers -
    # need to determine which domain
    # sent the packet.

    my @question = $packet->question;
    foreach my $question(@question) {
        my $domain = $question->qname;
        $domain =~ s/^\d+\.\d+\.\d+\.\d+\.//;
        return($domain, undef);
    }
}

sub cleanup {
    # remove control chars and stuff
    $_[ 0 ] =~ tr/a-zA-Z0-9./ /cs;
    $_[ 0 ];
}


sub lists {
    qw(
        bl.spamcop.net
       list.dsbl.org
       zen.spamhaus.org
    );
}
1;

