#!/usr/bin/perl --
# perl antispam smtp proxy
# (c) John Hanna, John Calvi, Robert Orso, AJ 2004 under the terms of the GPL
# (c) Fritz Borgstedt 2006 under the terms of the GPL
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation;

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# ASSP founded and developed to Version 1.0.12 by John Hanna
# ASSP development since 1.0.12 by John Calvi
# ASSP development since 1.2.0 by Fritz Borgstedt

# Feature implementations:
# AJ - Web interface
# Robert Orso - LDAP
# Nigel Barling - SPF & DNSBL
# Mark Pizzolato - SMTP Session Limits
# Thomas Eckardt - DB Support, Backscatter
# Przemek Czerkas - SRS, Delaying, Maillog Search, HTTP Compression, URIBL, RWL,
#					and many ideas and pieces
# Craig Schmitt - SPF2 & code optimizing
# Misc. contributions:
# Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Marco Tomasi,
# Andrew Macpherson, Marco Michelino, Matti Haack, Dave Emory, Kevin

use strict qw(vars subs);
use bytes;    # get rid of annoying 'Malformed UTF-8' messages
use Encode;
use File::Copy;
use IO::Select;
use IO::Socket;
use Sys::Hostname;
use Time::Local;
use vars qw(@ISA @EXPORT);
#
eval{$^M = 'a' x (1 << 16);}; # use 64KB for "out of memory" area
our $version='1.4.3';
our $modversion='.1';    #appended in version display.

BEGIN {
    use vars qw($wikiinfo);
    push @EXPORT, qw($wikiinfo);
    use vars qw($base);
    push @EXPORT, qw($base);
    push @EXPORT, qw($base $wikiinfo);
    $wikiinfo = "get?file=images/info.png";

    # load from command line if specified
    if ( $ARGV[0] ) {
        $base = $ARGV[0];
      } else {

        # the last one is the one used if all else fails
        foreach ( '.', 'assp', '/usr/local/assp', '/home/assp', '/etc/assp', '/usr/assp', '/applications/assp', '/assp',
            '.' ) {
            $base = $_;
            last if -e "$base/assp.cfg";
          }
      }
    if ( !-e "$base/images/noIcon.png" ) {
        die "Abort: folder 'images' not correctly installed";
      }
	our $dftrestartcmd;
	if ( $^O eq "MSWin32" ) {
    	my $perl = $^X;
    	my $assp = $base.'\\'.$0;
    	my $asspbase = $base;
    	$dftrestartcmd = "cmd.exe /C start \"ASSPSMTP restarted\" \"$perl\" -X \"$assp\" \"$asspbase\"";
	} else {
    	$dftrestartcmd = "\"$^X\" \"$0\" \"$base\" \&";
	}
    # vars needed in @Config
    # print "loading config -- base='$base'\n";

    our @Config = (
        [ 0, 0, 0, 'heading', 'Network Setup <a href="http://www.magicvillage.de/~Fritz_Borgstedt/assp/S056449D7?WasRead=1" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Network Setup" /></a>' ],

# except for the heading lines, all config lines have the following:
#  $name,$nicename,$size,$func,$default,$valid,$onchange,$description(,CssAdition)
# name is the variable name that holds the data
# nicename is a human readable pretty display name (oh how nice!)
# size is the appropriate input box size
# func is a function called to render the config item
# default is the default value
# valid is a regular expression used to clean and validate the input -- no match is an error and $1 is the desired result
# onchange is a function to be called when this value is changed -- usually undef; just updating the value is enough
# group is the heading group belonged to.
# description is text displayed to help the user figure what to put in the entry
# CssAdition (optional) adds the string to the CSS-name for nicename Style

['listenPort','SMTP Listen Port',20,\&textinput,'25','(\S+)','ConfigChangeMailPort',
  'The port number on which ASSP will listen for incoming SMTP connections (normally 25). You can specify both an IP address and port number to limit connections to a specific interface.<p><small><i>Examples:</i> 25, 127.0.0.1:25, 127.0.0.1:25|127.0.0.2:25 </small></p><hr /><div class="menuLevel1">Notes On Network Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/network.txt\',3);" />','Basic'],
['smtpDestination','SMTP Destination',40,\&textinput,'125','(\S*)',undef,
  'The IP <b>number!</b> and port number of your primary SMTP. If multiple servers are listed and the first listed MTA does not respond, each additional MTA will be tried. If only a port number is entered, or the dynamic keyword <b>INBOUND</b> is used with a port number, then the connection will be established to the local IP address on which the connection was received. This is useful when you have several IP addresses with different domains or profiles in your MTA. If INBOUND:PORT is used, ReportingReplies (Analyze,Help,etc and CopyMail will go to 127.0.0.1:PORT. If your needs are different, use smtpReportServer (SMTP Reporting Destination) and sendAllDestination (Copy Spam SMTP Destination)<small><i>Examples:</i> 125,  127.0.0.1:125, 127.0.0.1:125|127.0.0.5:125, INBOUND:125</small>','Basic'],

['listenPort2','Second SMTP Listen Port',20,\&textinput,'','(\S*)','ConfigChangeMailPort2',
  'A secondary port number on which ASSP can accept SMTP connections. This is useful as a dedicated port for VPN clients or for those who cannot directly send mail to a mail server outside of their ISP\'s network because the ISP is blocking port 25. You may also specify an IP address to limit connections to a specific interface.<p><small><i>Examples:</i> 2525, 127.0.0.1:2525, 192.168.0.100:25000</small></p>'],
['smtpAuthServer','Second SMTP Destination',20,\&textinput,'','(\S*)',undef,
  'The IP address and port number to connect to when mail is received on the second SMTP listen port. If the field is blank, the primary SMTP destination will be used. The purpose of this setting is to allow remote users to make authenticated connections and transmit their email without encountering SPF failures.<p><small><i>Examples:</i> 587, 127.0.0.1:587</small></p>'],
['EnforceAuth',"Force SMTP AUTH on Second SMTP Listen Port",0,\&checkbox,0,'(.*)',undef,
  'Force clients connecting to the second listen port to authenticate before transferring mail. To use this setting, both listenPort2 (Second SMTP Listen Port) and smtpAuthServer (Second SMTP Destination) must be configured.'],
['smtpDestinationRT','SMTP Destination Routing Table <a href="http://www.magicvillage.de/~Fritz_Borgstedt/assp/S06665A73?WasRead=1" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Advanced Messageflow" /></a>',80,\&textinput,'','(\S*)','configChangeRT',
  'If INBOUND is used in the SMTP Destination field, the rules specified here are used to route the inbound IP address to a different outbound IP address. You must specify a port number with the outbound IP address. This feature works by assigning as many IP\'s to  ASSP as you have different receiving Mailservers. This can be avoided by using the advanced flow we recommend: <a href="http://www.magicvillage.de/~Fritz_Borgstedt/assp/S06663BFC?WasRead=1" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Advanced Messageflow" /></a>
  <p><small><i>Example:</i>141.120.110.1=>141.120.110.129:25|141.120.110.2=>141.120.110.130:125|141.120.110.3=>141.120.110.130:125</small></p><span class="negative"> requires ASSP restart</span>'],
['smtpReportServer','SMTP Reporting Destination',20,\&textinput,'','(\S*)',undef,
  'The port number that ASSP will use to send Email Interface Notifications ( EmailInterfaceOk )through . If left blank, all notifications go to the primary smtpDestination. You can specify <i>&lt;address&gt;</i>:<i>&lt;port&gt;</i> to limit connections. <p><small><i>Example:</i> 1025, 127.0.0.1:1025</small></p>'],

[0,0,0,'heading','SMTP Session Limits </a><a href="http://www.asspsmtp.org/wiki/SMTP_Error_Codes#Permanent_Negative_Completion_reply_-_5xx" target="wiki"><img height=12 width=12 src="' . $wikiinfo . '" alt="SMTP session errors"" /></a>'],
['MaxErrors','Maximum Errors Per Session',5,\&textinput,'5','(\d+)',undef,
'The maximum number of SMTP session errors encountered before the
connection is dropped.'],
['meValencePB','Max Errors Exceeded Score, default=10',3,\&textinput,10,'(\d*)',undef, 'IP scoring in PenaltyBox'],
['maxSMTPSessions','Maximum Sessions',5,\&textinput,'64','(\d?\d?\d?)',undef,
  'The maximum number of simultaneous SMTP sessions. This can prevent server overloading and DoS attacks. 64 simultaneous sessions are typically enough. No entry or zero means no limit.'],
['maxSMTPipSessions','Maximum Sessions Per IP Address',3,\&textinput,'5','(\d?\d?\d?)',undef,
  'The maximum number of SMTP sessions allowed per IP address. Use this setting to prevent server overloading and DoS attacks. 5 sessions are typically enough. If left blank or set to 0 there is no limit imposed by ASSP. ispip (ISP/Secondary MX Servers) and acceptAllMail (Accept All Mail) matches are excluded from SMTP session limiting.'],
['iplValencePB','IP Maximum Parallel Sessions Violation Score, default=5',3,\&textinput,5,'(\d*)',undef, 'For IP scoring in PenaltyBox'],
['npSize','Message Size Limit',10,\&textinput,'256000','(.*)',undef,'This limit ensures that only messages smaller than this limit are processed by ASSP. Most spam
isn\'t bigger than a few k. ASSP will treat incoming messages larger than this SIZE (in bytes) as \'No Processing\' mail. Empty or 0 disables the feature.'],
['npSizeLocal','Message Size Limit Local Messages',0,\&checkbox,1,'(.*)',undef,
  'ASSP will treat outgoing messages larger than npSize as \'No Processing\' mail.'],
['HeaderMaxLength','Maximum Header Size',10,\&textinput,50000,'(\d*)',undef,
  'The maximum allowed header length, in bytes. At each mail hop header information is added by the mail server. A large mail header can indicate a mail loop. If the value is blank or 0 the header size will not be checked.'],
['maxRealSize','Max Real Size of Message',10,\&textinput,'','(\d*)',undef,
 'If the value of (number of [rcpt to] * [message size]) exceeds maxRealSize in bytes the transmission of the message will be canceled. No limit is imposed by ASSP if the field is left blank or set to 0. This option allows admins to limit useless bandwidth wasting based on the total transmit size.'],
['maxRealSizeError','max real message size Error',80,\&textinput,'552 message exceeds MAXREALSIZE byte (size * rcpt)','(552 .*)',undef,'SMTP error message to reject maxRealSize exceeding mails. For example:552 message exceeds MAXREALSIZE byte (size * rcpt)! MAXREALSIZE will be replaced by the value of maxRealSize.'],

['smtpIdleTimeout','SMTP Idle Timeout',5,\&textinput,'180','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle before being forcibly disconnected. The default is 180 seconds. No limit is imposed by ASSP if the field is left blank or set to 0. If you have not defined an IdleTimeout on your MTA, this value should not be set to 0, because then a connection will never be timed out!'],
['smtpNOOPIdleTimeout','SMTP Idle Timeout after NOOP',5,\&textinput,'0','(\d?\d?\d?\d?)',undef,
 'The number of seconds a session is allowed to be idle after a "NOOP" command is received, before being forcibly disconnected. The default is 0 seconds. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This should prevent hackers to hold and block connections by sending "NOOP" commands short before the "smtpIdleTimeout" is reached.'],
['smtpNOOPIdleTimeoutCount','SMTP Idle Timeout after NOOP Count',5,\&textinput,'0','(\d?\d?)',undef,
 'The number of counts a session is allowed send "NOOP" commands following on each other, before being forcibly disconnected. The default is 0. No limit is imposed by ASSP if the field is left blank or set to 0.<br />
  This in cooperation with "smtpNOOPIdleTimeout" should prevent hackers to hold and block connections by sending repeatedly "NOOP" commands short before the "smtpNOOPIdleTimeout" is reached. If "smtpNOOPIdleTimeout" is not defined or 0, this value will be ignored!<hr /><div class="menuLevel1">Notes On SMTP Session Limits</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/sessionlimits.txt\',3);" />'],

[0,0,0,'heading','SPAM Control / Testmode <a href="http://www.asspsmtp.org/wiki/TestModes" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="TestModes" /></a>'],

['SpamError','Spam Error',80,\&textinput,'554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN','([25]\d\d .*)',undef,'SMTP error message to reject spam. The literal LOCALDOMAIN (case sensitive) will be replaced by the recipient domain. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN. '],

['send250OK','Send 250 OK ',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox if you want ASSP to reply with \'250 OK\' instead of SMTP error code \'554 5.7.1\'. This will turn ASSP in some form of tarpit. '],
['noGriplistUpload','Don\'t Upload Griplist Stats',0,\&checkbox,'','(.*)',undef,
 'Check this to disable the Griplist upload when rebuildspamdb runs. The Griplist contains IPs and their value between 0 and 1, lower is less spammy, higher is more spammy. This value is called the grip value. '],
['noGriplistDownload','Don\'t auto-download the Griplist file',0,\&checkbox,'','(.*)',undef,
 'Set this checkbox if don\'t use the Griplist or want to download it manually. '],

['AddIntendedForHeader','Add Envelope-Recipient Header',0,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header "X-Assp-Intended-For: user@domain" .'],
['NoExternalSpamProb','Block Outgoing Spam-Prob header',0,\&checkbox,1,'(.*)',undef,
'Check this box if you don\'t want your X-Assp-Spam-Prob header on external mail<br />
 Note this means mail from local users to local users will also be missing the header.'],
['AddSpamHeader','Add Spam Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam: YES" if the message is spam.'],
['AddCustomHeader','Add Custom Header',80,\&textinput,'X-Spam-Status:yes','(.*)',undef,
 'Adds a line to the email header if the message is spam. For example: <a href="http://exchangepedia.com/blog/2008/01/assigning-scl-to-messages-scanned-by.html">X-Spam-Status:yes<img src="' . $wikiinfo . '" alt="Assigning SCL to messages scanned by 3rd-party antispam filters" /></a>'],
['AddLevelHeader','Add Graphical Level Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Level:**** " showing the totalscore represented by stars.'],
['AddSpamReasonHeader','Add Spam Reason Header',0,\&checkbox,1,'(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Reason: " explaining why the message is spam.<br /><hr /><div class="menuLevel1">Notes On Spam Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamcontrol.txt\',3);" />'],

['spamSubject','Prepend Spam Subject ',20,\&textinput,'','(.*)',undef,'Setting a filter to testmode will tell ASSP not to reject the mail but rather build up the whitelist and spam and notspam collections. This can go on for some time without disturbing normal operation. After this very important phase TestMode can be used to tag the message: if TestMode and the message is spam Spam Subject gets prepended to the subject of the email. For example: [SPAM]','Basic'],
['spamTag','Prepend Spam Tag',0,\&checkbox,'','(.*)',undef,'ASSP uses many methods. The method which caught the spam  will be prepended to the subject of the email. For example; [RBL]','Basic'],
['allTestMode','All Testmode ON',0,\&checkbox,'','(.*)',undef,'Turn all of the individual testmodes on - regardless of the individual testmode settings. Individual testmodes are located in the filter sections:
<br> attachTestMode (Bad Attachment & Virusscan Testmode) 
<br> baysTestMode (Bayesian Testmode) 
<br> blTestMode (BlackDomain Testmode) 
<br> bombTestMode (Bomb Regex Testmode) 
<br> fhTestMode (Forged Helo Testmode) 
<br> flsTestMode (Remote Sender with Local Domain Testmode) 
<br> hlTestMode (Helo Blacklist Testmode) 
<br> ihTestMode (Invalid Helo Testmode) 
<br> msTestMode (Message Scoring Testmode) 
<br> mxaTestMode (Missing MX Record Testmode) 
<br> pbTestMode (PenaltyBox Testmode) 
<br> ptrTestMode (Reversed Lookup Testmode) 
<br> rblTestMode (DNSBL Testmode) 
<br> scriptTestMode (Script Regex Testmode) 
<br> spfTestMode (SPF Testmode) 
<br> srsTestMode (SRS Testmode) 
<br> uriblTestMode (URIBL Testmode) 
'],
['switchTestToScoring',"Switch Testmode to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring" when DoPenaltyMessage is set  (instead of stopping spam processing altogether).<br /><hr /><div class="menuLevel1">Notes On Testmode</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/testmode.txt\',3);" />'],

[0,0,0,'heading','Copy Spam &amp; Ham'],
['sendAllSpam','Copy Spam and Send to this Address',20,\&textinput,'','(.*)',undef,
 'If this is set ASSP will deliver a copy of spam emails to this address. For example: spammaster@example.com. The literal USERNAME (case sensitive) is replaced by the user part of the recipient, the literal DOMAIN (case sensitive) is replaced by the domain part of the recipient.
 For example: USERNAME@Spam.DOMAIN, USERNAME+Spam@DOMAIN, catchallspamthis@DOMAIN','Basic'],
 ['ccSpamInDomain','Copy Spam and Send to this Address per Domain*',60,\&textinput,'','(.*)','configUpdateCCD',
 'ASSP will deliver an additional copy of spam emails of a domain to this address - if matched. For example: catchallspam@example.com|allspam@example.com.'],
['sendAllDestination','Copy Spam SMTP Destination',20,\&textinput,'','(\S*)',undef,
 'Port to connect to when  Spam messages are copied. If blank they go to the main SMTP Destination. eg "10.0.1.3:1025", "1025", etc.'],
['ccSpamFilter','Copy Spam to these Recipients Only*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Restricts Copy Spam to these recipients. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).'],
['ccSpamAlways','Copy Spam to these Recipients always*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Spam to these recipients regardless of collection mode. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).'],
['ccSpamNeverRe','Do Not Copy Spam Regex*',40,\&textinput,'','(.*)','ConfigCompileRe',
 'Never Copy Spam regardless of collection mode. Put anything here to identify messages which should not be copied.'],
['ccMaxScore','Do Not Copy Messages Above This MessageTotal score',3,\&textinput,'','(\d*)',undef,
 'Messages whose score exceeds this threshold will not be copied.  For example: 75'],
['ccMaxBytes','Restrict Copy Spam to MaxBytes ',0,\&checkbox,1,'(.*)',undef,
 'CCMail will cut off Spam mails, thereby reducing the load considerably (recommended).'],
['spamSubjectCC','Prepend Spam Subject to Copied Spam',0,\&checkbox,'','(.*)',undef,
 'If set spamSubject gets prepended to the subject of the copied message.'],
['spamTagCC','Prepend Spam Tag to Copied Spam',0,\&checkbox,1,'(.*)',undef,'The check which caused the spam detection will be prepended to the subject of the message. For example: [DNSBL]'],
['sendAllHamDestination','Copy Not-Spam SMTP Destination',20,\&textinput,'','(\S*)',undef,
 'Port to connect to when  Ham messages are copied. If blank they go to the Spam SMTP Destination. eg "10.0.1.3:1025", "1025", etc.'],
['sendHamInbound','Copy Incoming Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box  ASSP will forward a copy of notspam messages from outside to this address. The literal USERNAME is replaced by the user part of the recipient, the literal DOMAIN is replaced by the domain part of the recipient. For example: archiv@example.com, USERNAME@mybackup.domain, catchallforthis@DOMAIN'],
['sendHamOutbound','Copy Outgoing Not-Spam and Send to this Address',20,\&textinput,'','(.*)',undef, 'If you put an address in this box ASSP will forward a copy of outgoing notspam messages to this address.'],
['ccHamFilter','Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Copy Not-Spam to these addresses only. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).'],
['ccnHamFilter','Do Not Copy Ham Filter*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Do Not Copy Ham to these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).<br />
<hr /><div class="menuLevel1">Notes On CC Messages</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/copymail.txt\',3);" />'],

[0,0,0,'heading','SPAM Lover/Hater'],
['spamSubjectSL',"Suppress SpamSubject to SpamLover-Messages",0,\&checkbox,'','(.*)',undef,
 'If set spamSubject  gets NOT prepended to the subject of the SpamLover-Message.'],
['spamTagSL',"Suppress spamTags to SpamLover-Messages",0,\&checkbox,1,'(.*)',undef,
 'If set, spamTags gets NOT prepended to the subject of the SpamLover-Message.'],

['spamLovers','All SpamLover*',60,\&textinput,'postmaster|abuse','(.*)','ConfigMakeSLRe',
 'spamLovers are lists of criteria that when matched will allow a SMTP session through ASSP\'s filter process, regardless of what blocking functions match and would otherwise cause the message to be rejected. However, there is an exception to this when there are multiple recipients that do not all match the criteria of the spam Lovers match. In this exception the message will be processed normally and will be subjected to all blocking criteria.
 This can be specified per filter or for all messages. Messages to SpamLovers are processed and filtered by ASSP, but get tagged with spamSubject and not blocked ( spamSubjectSL will suppress this. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com). Default: postmaster|abuse.'],
['SpamLoversRe','Regular Expression to Identify  SpamLover*',60,\&textinput,'','(.*)','ConfigCompileRe',
'If a message matches this regular expression it will be considered a SpamLover message.'],
['baysSpamLovers','Bayesian SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['baysSpamLoversRe','Regular Expression to Identify Bayesian SpamLover*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this regular expression it will be considered a Bayesian SpamLover message. For example: passwor|news'],
['baysSpamLoversRed','Do not store Bayesian SpamLover in SpamDB',0,\&checkbox,'','(.*)',undef,
 'Mail to Bayesian SpamLover will not be stored in Spam/Notspam folder.'],
['blSpamLovers','Blacklisted Domains SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['bombSpamLovers','Bomb SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['hlSpamLovers','HELO Blacklisted SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['hiSpamLovers','Valid/Invalid Helo*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['atSpamLovers','Bad Attachment & Virusscan SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['spfSpamLovers','SPF Failures SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['rblSpamLovers','DNSBL Failures SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['uriblSpamLovers','URIBL Failures SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['srsSpamLovers','Not SRS Signed Bounces SpamLover *',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['delaySpamLovers','No Delaying SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['isSpamLovers','Invalid Sender SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['mxaSpamLovers','Missing MX SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['ptrSpamLovers','Invalid/Missing PTR SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['pbSpamLovers','PenaltyBox Blocking SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['sbSpamLovers','Country Blocking SpamLover*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['spamHaters','All SpamHaters*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'SpamHaters are used to override SpamLovers / Testmodes / Tagmodes.
 If a recipient is set as as SpamHater, all spam-messages are blocked, no tagging only will work.
 Example: If you have set your entire domain as a SpamLover(s), but there are still some addresses you still wish to block spam for. If you add those addresses to the SpamHaters field allows messages to only those addresses to be blocked while still allowing the messages to the other SpamLovers pass through. The message will only be blocked if all recipients are SpamHaters. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).<br />For example: *fribo@example.com|jhanna|@example.org '],
['baysSpamHaters','Bayesian SpamHater*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['rblSpamHaters','DNSBL Failures SpamHater*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['hlSpamHaters','HELO Blacklisted SpamHater*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['pbSpamHaters','PenaltyBox Blocking SpamHater*',60,\&textinput,'','(.*)','ConfigMakeSLRe',''],
['switchSpamLoverToScoring',"Switch SpamLover to Message Scoring",0,\&checkbox,'','(.*)',undef,
 'Put the filter automatically in "Message Scoring Mode"  when DoPenaltyMessage is set  (instead of stopping spam processing altogether).<br /><hr /> <div class="menuLevel1">Notes On SpamLover</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spamlover.txt\',3);" />',],



[0,0,0,'heading','No Processing'],
['noProcessingIPs','No Processing IPs*',60,\&textinput,'','(.*)','ConfigMakeIPRe','Mail from any of these IP\'s will pass through without processing. <br />
 For example: <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>127.0.0.1|172.16.<img src="' . $wikiinfo . '" alt="wiki" /></a> ','','7'],

['noProcessing','No Processing Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Mail solely to or from any of these addresses are proxied without processing. Like a more efficient version of SpamLovers &amp; redlist combined. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).'],
['noProcessingDomains','No Processing Domains*',60,\&textinput,'sourceforge.net','(.*)','ConfigMakeRe',
 'Domains from which you want to receive all mail and  proxy without processing. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that buy.com would also match spambuy.com but .buy.com won\'t match buy.com. For example: sourceforge.net|@google.com|.buy.com'],

['npRe','Regular Expression to Identify No Processing Mail*',60,\&textinput,'','(.*)','ConfigCompileRe',
 'If a message matches this Perl regular expression ASSP will treat the message as a \'No Processing\' mail. For example: 169\.254\.122\.|172\.16\.|\\[autoreply\\].'],

['processOnlyAddresses','Process Only These Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','Mail solely to or from any of these addresses will be processed by ASSP. All others will be proxied without processing. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).<br /> Note that if an address matches both the NoProcessing and the OnlyTheseProcessing lists, the NoProcessing rules take precedence.'],
['poTestMode','Enable Process Only Addresses',0,\&checkbox,'','(.*)',undef,'<br /><hr /><div class="menuLevel1">Notes On No Processing</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/noprocessing.txt\',3);" />',],

[0,0,0,'heading','Redlisting/Whitelisting'],
['redRe','Regular Expression to Identify Redlisted Mail*',80,\&textinput,'file:files/redre.txt','(.*)','ConfigCompileRe',
 'If an email matches this Perl regular expression it will be 
considered redlisted.

<br />The Redlist serves two purposes:

<br />1) the Redlist is a list of addresses that cannot contribute to the 
whitelist, and which are not considered local, even if their mail is 
from a local computer. For example, if someone goes on a vacation and 
turns on their autoresponder, put them on the redlist until 
they return. Then as they reply to every spam they receive they won\'t 
corrupt your non-spam collection or whitelist: \[autoreply\]

<br />2) Redlisted addresses will not be added to the Whitelist when your 
local user sends mail to that address, thereby preventing accidental 
pollution of the Whitelist by, say, inadvertent replies by your 
users to e-mails from the spammer.

<br />Redlisted messages will not be stored in the 
SPAM/NOTSPAM-collection if DoNotCollectRedList and/or DoNotCollectRedRe is set.
 
<br />As all fields marked by * this field accepts 
a list separated by | or a specified file \'file:files/redre.txt\'. '],
['EmailWhiteRemovalToRed','Add  Whitelist Removals To Redlist ',0,\&checkbox,'','(.*)',undef,
  'Addresses which are removed from Whitelist via EmailWhitelistRemove will automatically be added to the Redlist. The address can only be added again to the Whitelist after it is removed from the Redlist.'],
['whiteListedIPs','Whitelisted IPs*',80,\&textinput,'','(.*)','ConfigMakeIPRe','They  contribute to the Whitelist and to Notspam. For example: <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>127.0.0.1|172.16.<img src="' . $wikiinfo . '" alt="wiki" /></a> <span class="positive"> All fields marked by \'*\' accept  a filepath/filename : \'file:files/ipwl.txt\'.</span>','','7'],

['whiteRe','Regular Expression to Identify Non-Spam* ',80,\&textinput,'','(.*)','ConfigCompileRe','If an incoming email matches this Perl regular expression it will be considered non-spam.<br />For example: Secret Ham Password|307\D{0,3}730\D{0,3}4[12]\d\d<br />For help writing regular expressions click <a href="http://www.perlmonks.org/index.pl?node=perlre" rel="external">here</a>.<br />IMPORTANT: The body is scanned in a later stage  AFTER all sender related checks are performed. So a white regular expression here might not prevent the message from being blocked by eg. invalid PTR. Set the sender related checks to score only if you want to make sure that the white regular expression will be seen. Some things you might include here are your office phone number or street address, spam rarely includes these details.  .'],

['whiteListedDomains','Whitelisted Domains and Addresses*',80,\&textinput,'sourceforge.net','(.*)','ConfigMakeRe','Domains and addresses from which you want to receive all mail. Your ISP, domain registration, mail list servers, stock broker, or other key business partners might be good candidates. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. Wildcards are supported. For example: sourceforge.net|group*@google.com|.example.com'],
['wildcardUser','Wildcard User for White Domain ',20,\&textinput,'*','(.*)',undef,'If you add this user via email-interface(eg: *@example.com), the whole domain will be whitelisted. For example: \'*\''],
['ValidateRWL','Enable Realtime Whitelist Validation',0,\&checkbox,'','(.*)','configUpdateRWL','RWL: Real-time white list. These are lists of IP addresses that have
 somehow been verified to be from a known good host. Senders that pass RWL validation will pass IP-based filters. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. <a href="http://www.asspsmtp.org/wiki/FAQ#Common_Problems" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',undef],
['RWLwhitelisting','Whitelist all RWL Validated Addresses',0,\&checkbox,'','(.*)',undef,'If set, the message will pass also Bayesian Filter and URIBL.',undef],
['RWLServiceProvider','RWL Service Providers*',80,\&textinput,'list.dnswl.org|cml.anti-spam.org.cn|query.bondedsender.org','(.*)','configUpdateRWLSP','Domain Names of RWLs to use separated by "|".<br />Examples are:<br /><p>
 list.dnswl.org|cml.anti-spam.org.cn|iadb.isipp.com|hul.habeas.com </p>',undef],
['RWLmaxreplies','Maximum Replies',5,\&textinput,3,'(\d*)','configUpdateRWLMR','A reply is affirmative or negative reply from a RWL. The RWL module will wait for this number of replies (negative or positive) from the RWLs listed under Service Provider for up to the Maximum Time below. This number should be equal to or less than the number of RWL Service Providers listed to allow for randomly unavailable RWLs. ',undef],

['RWLminhits','Minimum Hits',5,\&textinput,1,'(\d*)','configUpdateRWLMH','A hit is an affirmative response from a RWL. The RWL module will check all of the RWLs listed under Service Provider, and flag the email with a RWL pass flag if equal to or more than this number of RWLs return a postive whitelisted response.',undef],
['RWLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time to spend on each message performing RWL checks',undef],
['noRWL','Don\'t Validate RWL for these IPs*',80,\&textinput,' 127.0.0.|192.168.|10.','(.*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be RWL validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef,'7'],
['AddRWLHeader','Add X-Assp-Received-RWL Header',0,\&checkbox,1,'(.*)',undef,'Add X-Assp-Received-RWL header to header of all emails processed by RWL.',undef],
['RWLCacheExp','RWL Cache Expiration Time',4,\&textinput,24,'([\d\.]+)','configUpdateRWLCR','IP\'s in cache will be removed after this interval in hours. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.rwl.db\',5);" />'],
['MaxWhitelistDays','Max Whitelist Days',5,\&textinput,'180','(\d+)',undef,'This is the number of days an address will be kept on the whitelist without any email to/from this address.'],
['MaxWhitelistLength','Max Length of Whitelist Addresses',4,\&textinput,'50','(.*)',undef,''],
['WhitelistOnly','Reject All But Whitelisted Mail',0,\&checkbox,'','(.*)',undef,'Check this if you don\'t want Bayesian filtering and want to reject all mail from anyone not whitelisted.<br />'],
['NoAutoWhite','Only Email-Interface Addition to Whitelist.',0,\&checkbox,'','(.*)',undef,'Check this box to  allow additions to the whitelist by EmailWhitelistAdd only.'],
['NotGreedyWhitelist','Only the envelope-sender is added/compared to the whitelist',0,\&checkbox,'','(.*)',undef,'Normal operation includes addresses in the FROM, SENDER, REPLY-TO, ERRORS-TO, or LIST-* header fields.<br />This allows nearly all list email to be whitelisted. Check this option to disable this. Will not do anything if you add/remove whitelist entries via email-interface'],
['WhitelistLocalOnly','Only local or authenticated users contribute to the whitelist.',0,\&checkbox,'','(.*)',undef,'Normal operation allows all local, authenticated, or whitelisted users to contribute to the whitelist.<br />Check this box to not allow whitelisted users to add to the whitelist.'],
['WhitelistLocalFromOnly','Only users with a local domain in mailfrom contribute to the whitelist.',0,\&checkbox,'1','(.*)',undef,'Check this box to prevent sender with non-local domains ( not in localDomains) from contributing to the whitelist. (for example: redirected messages).'],
['WhitelistAuth','Whitelist authenticated users.',0,\&checkbox,'','(.*)',undef,''],
['UpdateWhitelist','Save Whitelist',5,\&textinput,3600,'(.*)',undef,'Save a copy of the white list every this many seconds. Empty or Zero will prevent any saving.<br />Note: the current timeout must expire before the new setting is loaded, or you can restart.<br /><hr /><div class="menuLevel1">Notes On Whitelist</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/whitelist.txt\',3);" />'],

[0,0,0,'heading','Relaying <a href="http://www.asspsmtp.org/wiki/Getting_Started#Error:_.22relaying_not_allowed.22._What_do_I_do.3F" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="relaying not allowed" /></a>'],
['rlValencePB','Failed Relay Attempt Score, default=10',3,\&textinput,10,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],
['acceptAllMail','Accept All Mail*',80,\&textinput,'','(.*)','ConfigMakeIPRe','Relaying is allowed for these IPs. They  contribute also to the whitelist. This can take either a directly entered list of IP\'s separated by pipes or a file \'file:files/acceptall.txt\'.<br />For example: <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>127.0.0.1|172.16.<img src="' . $wikiinfo . '" alt="wiki" /></a>','Basic','7'],
['localDomains','Local Domains*',80,\&textinput,'putYourDomains.com|here.org','(.*)','ConfigMakeRe','Check local domains against these addresses. Add a fake domain like \'assp-nospam.org\' for the email interface if you run MS Exchange. When mailing to eg. \'spam@assp-nospam.org\' MS Exchange forwards it outbound to ASSP who handles the various magic names. As in every field marked by \'*\' separate addresses with | or use file \'file:files/localdomains.txt\'. Wildcards are supported.<br /> For example: *example.com|*.example.com|example.org <br />
 The "Local Domains" are the  domain names that your mail
  system considers local.  Messages to "Local Domains" are also called "Incoming".
  Messages to domains not  in  "Local Domains" are also called "Outgoing".
  Messages from "Local Domains" are called "local" provided they come from IP\'s in  "Accept 		All Mail" ( acceptAllMail ) or are authenticated. 
  ASSP supports also "POP before SMTP" ( PopB4SMTPFile).
  Messages from domains not on in "Local Domains" are called "external". 
 <br />  
  That a mail claims to be from one of your local domains does not
  allow it to be relayed -- this is easily spoofed and not useful as a
  security measure. Spoofing an IP address is more complicated in this
  type of environment, and generally relaying is limited by IP
  address.
 <br />
  If your clients dialup or are dynamically assigned from an untrusted
  pool, then the only reliable way to allow relaying is through
  AUTHENTICATED smtp, and your mail handler must support this type of
  authentication, and you must enable it in your clients. ASSP
  recognizes authenticated connections and allows them to relay.
 <br />
  Not all ISPs will allow their customers to connect to your SMTP
  port. Many block connections to port 25 (except to their own mail
  server) to prevent spam. ASSP therefore provides a "Second SMTP Listen Port" ( listenPort2 ). <br /> <br />
 Use the syntax: *mydomain.com=>smtp.mydomain.com|other.com=>mx.other.com:port to verify the recipient addresses with the SMTP-VRFY  (if VRFY is not supported \'MAIL FROM:\' and \'RCPT TO:\' will be used)  command on other SMTP servers. The entry behind => must be the hostname:port or ip-address:port of the MTA which is used to verify \'RCPT TO\' addresses with a VRFY command! If :port is not defined, port :25 will be used. You have to enable the SMTP \'VRFY\' command on your MTA - the \'EXPN\' command should be enabled! This requires an installed <a href="http://search.cpan.org/search?query=Net::SMTP" rel="external">Net::SMTP</a> module in PERL. <br />
 It is recommended to configure ldaplistdb in the \'File Paths and Database\' section when using this verify extension - so ASSP will store there all verfied recipient addresses to minimize the querys on MTA\'s. There is no need to configure LDAP, but both VRFY and LDAP are using ldaplistdb.', 'Basic'],

 ['DoLocalSenderDomain','Do Local Domain Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender address must have a valid Local Domain.'],
 ['DoLocalSenderAddress','Do Local Address Check for Local Sender',0,\&checkbox,'','(.*)',undef,
  'If activated, each local sender must have a valid Local Address.'],
['nolocalDomains','Skip Local Domain Check',0,\&checkbox,'','(.*)',undef,'Do not check relaying based on localDomains. Let the mailserver do it. <b>NOT RECOMMENDED</b>.'],

['ldLDAP','Do LDAP Lookup for Local Domains',0,\&checkbox,'','(.*)',undef,'Check local domains against an LDAP database.<br />Note: Checking this requires filling in LDAP DomainFilter in The LDAP section.<br />This requires an installed <a href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod" rel="external">NET::LDAP</a> module in Perl.'],
['ispip','ISP/Secondary MX Servers*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter any addresses that are your ISP or backup MX servers, separated by pipes (|). <br />These addresses will (necessarily) bypass Griplist, IP Limiting, Delaying, PenaltyBox, SPF, DNSBL &amp; SRS checks unless the IP can be determined by ispHostnames (ISP Connecting IP). For example: <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.145.145.146<img src="' . $wikiinfo . '" alt="wiki" /></a>.','Basic',7],
['contentOnlyRe', 'Regular Expression to Identify Forwarded Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages which should bypass PB, Sender Validation, Griplist, IP Limiting, Delaying, SPF, DNSBL &amp; SRS checks. For example:  email addresses of people who are forwarding from other accounts to their mailbox on your server."],
['ispHostnames','ISP/Secondary Hostnames*',80,\&textinput, '','(.*)', 'ConfigCompileRe', 'Hostnames to lookup the IP that connected to the ISP/Secondary server.<br />If found, this address is used to perform IP-based checks on forwarded messages. <br />For example: mx1.yourisp.com or mx1.yourisp.net|mx2.yoursecondary.com. <i>This hostnames are found in the \'Received:\' header, like  \'Received: from ...123.123.123.123... by <b>mx1.yourisp.com</b>\'</i>. Leave this blank to disable the feature. '],
['send250OKISP','Send 250 OK To ISP/Secondary MX Servers',0,\&checkbox,'1','(.*)',undef,
 'Set this checkbox if you want ASSP to reply to IP\'s in ISPIP with \'250 OK\' instead of SMTP error code \'554 5.7.1\'.'],

['ispgreyvalue','ISP/Secondary MX Grey Value',5,\&textinput,'0.5','(\S*)',undef,'It is recommended  to set it to 0.5 (Completely GReyIP) for ISP &amp; Secondary MX servers. If left blank the Griplist X value is used (percentage of spam messages in relation to total). <br />Note: value should be greater than 0 and less than 1, where 0 = never spam &amp; 1 = always spam'],

['BounceSenders','Bounce Senders*',80,\&textinput,'postmaster|mailer-daemon','(.*)','ConfigMakeRe','Envelope sender addresses treated as bounce origins. Null sender (&lt;&gt;) is always included.<br />
 Accepts specific addresses (postmaster@example.com), usernames (mailer-daemon), or entire domains (@bounces.domain.com)<br />Separate entries with pipes: |. For example: postmaster|mailer-daemon'],
['PopB4SMTPFile','Pop Before SMTP DB File',40,\&textinput,'','(.*)',undef,'Enter the DB database filename of your POP before SMTP implementation with records stored for dotted-quad IP addresses.<br />For example: /etc/mail/popip.db'],
['PopB4SMTPMerak','Pop Before SMTP Merak Style',0,\&checkbox,'','(.*)',undef,'If set Merak 7.5.2 is supported.'],
['relayHost','Relay Host',40,\&textinput,'','(\S*)',undef,'Your isp\'s mail relayhost (smarthost). For example: mail.isp.com:25<br />f you run Exchange/Notes and you want assp to update the nonspam database and the whitelist, then enter your isp\'s smtp relay host here. Blank means no relayhost. Only required if clients don\'t deliver through SMTP.','Basic'],
['relayPort','Relay Port',40,\&textinput,'','(\S*)','ConfigChangeRelayPort','Tell your mail server to connect to this port as its smarthost / relayhost. For example: 225<br /> Note that you\'ll want to keep the relayPort protected from external access by your firewall.<br />You can supply an interface:port to limit connections.'],
['NoRelaying','No Relaying Error <a href="http://www.asspsmtp.org/wiki/Relaying" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'530 Relaying not allowed','([25]\d\d .*)',undef,'SMTP error message to deny relaying.'],
['defaultLocalHost','Default Local Host',40,\&textinput,'','(\S*)',undef,'If you want to be able to send mail to local users without a domain name then put the default local domain here.<br /> Blank disables this feature. For example: example.com<br /><hr /><div class="menuLevel1">Notes On Relaying</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/relaying.txt\',3);" />'],
['localDomainsFile','Local Domains File',40,\&textinput,'','(.*)',undef,'Like Local Domains, but OBSOLETE! Please use -> localDomains'],
['relayHostFile','Relay Host File - OBSOLETE',40,\&textinput,'','(.*)',undef,'Like acceptAllMail (Accept All Mail), but this is a file with an ABSOLUTE path, not relative to base. For example: /usr/local/assp/relayhosts'],

[0,0,0,'heading','Recipients'],
['irValencePB','Invalid Recipient Score, default=5',3,\&textinput,5,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['erValencePB','Empty Recipients Score, default=5',3,\&textinput,5,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],
['sendAllPostmaster','Catchall Address for Messages to Postmaster',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages addressed to all postmasters of your local domains to this address. For example: postmaster@example.com'],
['sendAllPostmasterNP','Skip Spam Checks for Postmaster Catchall',0,\&checkbox,'','(.*)',undef,''],
['sendAllAbuse','Catchall Address for Messages to Abuse',20,\&textinput,'','(.*)',undef,'ASSP will deliver messages to all abuse addresses of your local domains to this address. For example: abuse@example.com'],
['sendAllAbuseNP','Skip Spam Checks for Abuse Catchall',0,\&checkbox,'','(.*)',undef,''],
['DoRFC822','Validate local addresses to conform with RFC5322 ',0,\&checkbox,1,'(.*)',undef,'If activated, each local address is checked to conform with the email format defined in RFC5322 .<br />This requires an installed <a href="http://search.cpan.org/search?query=Email::Valid" rel="external">Email::Valid</a> module in PERL.'],
['LocalAddresses_Flat','Lookup valid Local Addresses from here*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These email addresses are the list of your local addresses. You can list specific addresses (user@example.com), addresses at any local domain (user), or entire domains (@example.com).  Wildcards are supported (fribo*@example.com). (|).<br />For example: fribo@example.com|jhanna|@example.org or place them in a plain ASCII file one address per line:file:files/localuser.txt.','Basic'],
['LocalAddresses_Flat_Domains','Use Addresses without \'@\' as Domains',0,\&checkbox,0,'([01]?)',undef,'Will handle entries without \'@\' as full domains'],
['RejectTheseLocalAddresses','Bounce These Local Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
'If ANY recipient is on bounce list, message will not be delivered. Used for disabled legitimate accounts, where a user may have left the company. Stops wildcard mailboxes from getting these messages.'],

['VRFYQueryTimeOut','SMTP VRFY-Query Timeout',5,\&textinput,'5','(\d\d?)',undef,
 'The number of seconds ASSP will wait for an answer of the MTA that is queryed with the VRFY command to verify a recipient address. See description of localDomains for the necessary modification to localDomains to run this feature'],
['DoLDAP','Do LDAP lookup for valid local addresses <a href="http://www.asspsmtp.org/wiki/LDAP" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',0,\&checkbox,'','(.*)',undef,'Check local addresses against an LDAP database before accepting the message.<br />Note: Checking this requires filling in the other LDAP parameters like LDAPHost.<br />This requires an installed <a href="http://search.cpan.org/~gbarr/perl-ldap-0.31/lib/Net/LDAP.pod" rel="external">NET::LDAP</a> module in PERL.'],


['CatchAll','Catchall per Domain*',40,\&textinput,'','(.*)','configUpdateCA','ASSP will send to this addresses/domain if no valid user is found in LocalAddresses_Flat or LDAP. <br />For example: catchall@domain1.com|catchall@domain2.com'],
['CatchAllAll','Catchall for All Domains',40,\&textinput,'','(.*)',undef,'ASSP will send to this address if no valid user is found  in LocalAddresses_Flat or LDAP and no match is found in Catchall per Domain. <br />For example: catchall@example.com'],
['InternalAddresses','Accept Mail from Local Domains only*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These local addresses accept mail only from local  domains ( localDomains ). Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (fribo*@example.com).'],
['iaValencePB','Internal Only Address Violation Score, default=25',3,\&textinput,25,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['SepChar','Separation Character for Subaddressing',2,\&textinput,'+','(.*)',undef,'RFC 3598 describes subaddressing with a Separation Character. A star (\'*\') is not allowed as Separation Character. Everything between Separation Character and @ is ignored (including Separation Character). For Example = \'+\' will allow user+subaddress@example.com.'],
['EnableBangPath','Support Bang Path',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will support addresses like domainx!user@domainy and will convert them to user@domainx .'],
['NoValidRecipient','No-Valid-Local-User Reply',80,\&textinput,'550 5.1.1 User unknown: EMAILADDRESS','([5|2]\d\d .*)',undef,'SMTP reply for invalid Users. Default: \'550 5.1.1 User unknown: EMAILADDRESS\' <br /> The literal EMAILADDRESS (case sensitive) is replaced by the fully qualified SMTP recipient (e.g., thisuser@example.com).<br /><hr /><div class="menuLevel1">Notes On Local Addresses</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/localaddresses.txt\',3);" />'],

[0,0,0,'heading','Validate Helo'],
['useHeloBlacklist','Use the Helo Blacklist','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Use the list of blacklisted-helo hosts built by rebuildspamdb.'],
['hlTestMode','Helo Blacklist Testmode',0,\&checkbox,'','(.*)',undef,''],
['hlValencePB','Blacklisted HELO Score, default=20',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['DoIPinHelo','Do Score Suspicious Helos','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score servers with IP number in Helo and check for mismatch with sending IP.'],
['fiphValencePB','Suspicious HELO Score, default=5',3,\&textinput,5,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty ). The score will be applied if one of two conditions are met: HELO contains IP, IP number in Helo. The score will be doubled if both conditions are met.'],
['ForceFakedLocalHelo','Enforce Check of Forged Helos Before Delaying',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  check Forged Helos before DELAYING. Collecting, Testmode, CopySpam, SpamLover is ignored.'],
['DoFakedLocalHelo','Block Forged Helos','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'Block remote servers that claim to come from our Local Domain/Local IP\'s/Local Host.'],
['fhValencePB','Forged HELO Scoring, default=150',3,\&textinput,150,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['fhTestMode','Forged Helo Testmode',0,\&checkbox,'','(.*)',undef,''],
['DoFakedUseLocalDomain','Use Local Domain List for Blocking Forged Helos',0,\&checkbox,1,'(.*)',undef,
  'If set, DoFakedLocalHelo will  use localDomains.'],
['DoFakedWL','Do Not Block Whitelisted Forged Helo\'s',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for whitelisted addresses (not recommended).'],
['DoFakedNP','Do Not Block Noprocessing Forged Helo\'s',0,\&checkbox,'','(.*)',undef,
  'Disable "Block Forged Helo\'s" for addresses identified as noprocessing (not recommended).'],
['myServerRe','Local Domains,IP\'s and Hostnames*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'Local Domains, IP\'s and Hostnames are often use to fake (forge) the Helo. Include all IP addresses and hostnames for your server  here, localhost is already included. Include Local Domains of your choice here, if you deactivated the automatic use of the localDomains list.  For example: 11.22.33.44|mx.example.com|example.org','Basic'],
 ['noHelo','Don\'t Validate HELO for these IP\'s*',60,\&textinput,'','(.*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be HELO validated.<br />
   For example: 127.0.0.1|192.168.',undef,'7'],
['heloBlacklistIgnore','Don\'t block these HELO\'s*',80,\&textinput,'','(.*)','ConfigMakeRe',
  'HELO / EHLO greetings on this list will be excluded from the HELO checks. For example: host123.isp.com|host456.*.com'],
['ForceValidateHelo','Enforce Early Helo Checks',0,\&checkbox,1,'(.*)',undef,
  'If set, ASSP will  Validate/Invalidate the format of HELO before DELAYING. Collecting, Testmode, CopySpam, SpamLover is ignored.'],
['DoValidFormatHelo','Validate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is validated as being ok. '],
['ihTestMode','Valid/Invalid Helo Testmode',0,\&checkbox,'','(.*)',undef,''],
['validFormatHeloRe','Regular Expression to Validate Format of HELO*',80,\&textinput,'^(([a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$','(.*)','ConfigCompileRe',
  'Validate Format HELO will check incoming HELOs according to rfc1123. <br />For example: ^(([a-z\d][a-z\d\-]*)?[a-z\d]\.)+[a-z]{2,6}$  '],
['DoInvalidFormatHelo','Invalidate Format of HELO','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, the HELO is checked against the expression below. If the Regular Expression matches, the HELO is invalidated as being not ok.'],
['invalidFormatHeloRe','Regular Expression to Invalidate Format of HELO*',80,\&textinput,'^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$','(.*)','ConfigCompileRe','Invalidate Format HELO will check incoming HELOs for this. <br />
 For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$'],
['ihValencePB','Invalid HELO Score, default=10',3,\&textinput,10,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['DoHeloWL','Do Valid/Invalid/Black Helo for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for whitelisted addresses.'],
['DoHeloNP','Do Valid/Invalid/Black Helo for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do valid/invalid Helo for noprocessing addresses.<br /><hr />
  <div class="menuLevel1">Notes On Validate Helo</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatehelo.txt\',3);" />'],
  
  
[0,0,0,'heading','Validate Sender'],
['DoBlackDomain','Do Blacklisted Addresses/Domains','0:disabled|1:block|2:monitor|3:score', \&listbox,1,'(\d*)',undef, ''],
['blTestMode','BlackDomain Testmode',0,\&checkbox,'','(.*)',undef,''],
['blValencePB','Blacklisted Domain Score, default=20',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['blackListedDomains','Blacklisted Addresses/Domains*',60,\&textinput,'cc|info|biz','(.*)','ConfigMakeRe','Addresses  &amp; Domains from which you always want to reject mail, they only send you spam. Note this matches the end of the address, so if you don\'t want to match subdomains then include the @. Note that example.com would also match spamexample.com but .example.com won\'t match example.com. abc@example.com will match abc@example.com but won\'t match bbc@example.com. Wildcards are supported. For example: cc|info|biz|seller@bayer.com|sell*@basf.com'],
['DoMsgID','Do Check Message IDs','0:disabled|2:monitor|3:score',\&listbox,3,'(\d*)',undef,
  'Score messages with missing/suspicious/invalid Message-ID.'],
['midmValencePB','Missing Message-ID Score, default=5',3,\&textinput,5,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['midsValencePB','Suspicious Message-ID Score, default=5',3,\&textinput,5,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],
['noMsgID','Don\'t Validate Message-IDs for these IPs*',80,\&textinput,' 127.0.0.|192.168.|10.','(.*)','ConfigMakeIPRe','Enter IP addresses that you don\'t want to be Message-ID validated, separated by pipes (|). For example: 127.0.0.1|192.168.',undef,'7'],
['validMsgIDRe','Regular Expression to Check Format of Message-ID',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Check Message IDs will check incoming messages for not supicious Message-IDs. If the RegEx match, the Message-ID is not suspicious.<br />For example: ^.{1,80}@.{1,64}\..{1,64}$  '],
['DoCountryBlocking','Do Country Blocking','0:disabled|1:block|2:monitor|3:score',\&listbox,2,'(.*)',undef,
   'If activated, each sending IP address has it\'s assigned country
looked up . This requires an installed <a href="http://search.cpan.org/search?query=Net::SenderBase" rel="external">Net::SenderBase</a> module in PERL.'],
['sbTestMode','CountryCode Testmode',0,\&checkbox,'','(.*)',undef,''],
['bccValencePB','Blocked Country Code Score, default=25',3,\&textinput,25,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],

['CountryCodeBlockedRe','Blocked Country Codes*',80,\&textinput,'CN|KR|RU|JP|CN|TR|TH|PL|LT|CL|RO|UA|CA|ES|GR|HU|SA|IN|GB|IE|IT|PT|MD|PE|NL|CZ|TW|BR|CL','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be blocked. For example: CN|KR|RU|JP|CN|TR|TH|PL|LT|CL|RO|UA|CA|ES|GR|HU|SA|IN|GB|IE|IT|PT|MD|PE|NL|CZ|TW|BR|CL. "all" will block all foreign countrycodes which are not in \'Suspicious Country Codes\' or \'Ignore Country Codes\'. See: <a href="http://www.iso.org/iso/country_codes/iso_3166_code_lists/english_country_names_and_code_elements.htm" rel="external">English country names and code elements</a>. '],
['DoSenderBase','Do Country Code Scoring','0:disabled|2:monitor|3:score',\&listbox,3,'(.*)',undef,
   'If activated, each sending IP address has it\'s assigned country
looked up. This requires an installed <a href="http://search.cpan.org/search?query=Net::SenderBase" rel="external">Net::SenderBase</a> module in PERL.'],



['NoCountryCodeRe','Ignore Country Codes*',80,\&textinput,'US','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will be ignored. For example: US'],
['CountryCodeRe','Suspicious Country Codes*',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Messages from IP\'s based in these countries will increase the MessageScore. For example: CN|KR|RU|JP'],
['sbsccValencePB','Suspicious Country Code Score, default=10',3,\&textinput,10,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],
['MyCountryCodeRe','Home Country Codes*',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Put here your own country code(s) (for example: US). Messages from IP\'s based in these countries will decrease the MessageScore. Messages from IP\'s based in other countries will increase the MessageScore.'],
['sbhccValencePB','<span class="positive">Home Country Code Score, default=-10</span>',3,\&textinput,-10,'(-{0,1}\d*)',undef, '<span class="positive"> Bonus for Message & IP Scoring  in PenaltyBox ( DoPenalty )</span>'],
['sbfccValencePB','Foreign Country Code Score, default=10',3,\&textinput,10,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],
['SBCacheInterval','Country Cache Refresh Interval',4,\&textinput,3,'([\d\.]+)','configUpdateSBCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.sb.db\',5);" />'],
['DoNoSpoofing','Block All Remote Sender  with a Local Domain Address',0,\&checkbox,'','(.*)',undef,
  'If activated, each remote sender address with a Local Domain is blocked. '],
['DoNoValidLocalSender','Validate Remote Sender with Local Domain Address','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each remote sender  with a local domain is checked against LocalAddresses_Flat (Local Addresses File) and/or LDAP. '],
['flsTestMode','Remote Sender with Local Domain Testmode',0,\&checkbox,'','(.*)',undef,''],
['flValencePB','Invalid Local Sender Score, default=20',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],

['DoRFC822Sender','Validate sender addresses to conform with RFC5322',0,\&checkbox,"",'(.*)',undef,'Sender must be a valid address to conform with RFC5322.'],
['DoReversed','Reversed Lookup','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each sender IP is checked for a PTR record. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.'],
['ptrTestMode','Reversed Lookup Testmode',0,\&checkbox,'','(.*)',undef,''],
['ptmValencePB','Missing PTR Record Score, default=10',3,\&textinput,10,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['DoReversedWL','Do Reversed Lookup for Whitelisted',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for whitelisted addresses.'],
['DoReversedNP','Do Reversed Lookup for Noprocessing',0,\&checkbox,'1','(.*)',undef,
  'Do reversed lookup for noprocessing addresses.'],
['DoInvalidPTR','Reversed Lookup FQDN Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated - and Reversed Lookup is activated -, the PTR-FQDN record is checked against the Regex. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.'],

['ptiValencePB','Invalid PTR Record Score, default=15',3,\&textinput,15,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['invalidPTRRe','Regular Expression to Invalidate Format of PTR*',80,\&textinput,'file:files/invalidptr.txt','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this. <br />
  For example:  ^\d+\.\d+\.\d+\.\d+$|^[^\.]+\.?$ or file:files/invalidptr.txt'],
['validPTRRe','Regular Expression to Validate Format of PTR*',80,\&textinput,'static','(.*)','ConfigCompileRe',
  'Validate Format PTR will check PTR records for this. If found, the PTR will be considered valid<br />
  For example:  static or file:files/validptr.txt'],
['PTRCacheInterval','Reversed Lookup Cache Refresh Interval',14,\&textinput,3,'([\d\.]+)','configUpdatePTRCR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.ptr.db\',5);" />'],
['DoDomainCheck','Validate MX or A Record','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, each sender address is checked for a valid MX or A record.'],
['mxaTestMode','Validate MX or A Record Testmode',0,\&checkbox,'','(.*)',undef,''],
['mxValencePB','Missing MX Score, default=10 ',3,\&textinput,10,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['mxaValencePB','Missing MX &amp; A Record Score, default=15',3,\&textinput,15,'(\d*)',undef, 'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],

['MXACacheInterval','Validate Domain MX Cache Refresh Interval',14,\&textinput,3,'([\d\.]+)','configUpdateMXACR',
  'IP\'s in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.mxa.db\',5);" />'],

['SenderInvalidError','Sender Validation Error',80,\&textinput,'554 5.7.1 REASON .','(.*)',undef,
  'SMTP error message to reject invalid senders. The literal REASON is replaced by (missing MX, missing PTR, invalid Helo, invalid user) depending on the check.The literal LOCALDOMAIN will be replaced by the recipient domain. For example:554 5.7.1 Mail appears to be unsolicited : REASON -- send error reports to postmaster@LOCALDOMAIN.<br /><hr />
  <div class="menuLevel1">Notes On Validate Sender</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/validatesender.txt\',3);" />'],

[0,0,0,'heading','IP Blocking <a href="http://www.asspsmtp.org/wiki/CIDR-Notation" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="IP Notation" /></a>'],

['DoDenySMTP','Do Deny Connections from these IP\'s','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against denySMTPConnectionsFrom (Deny Connections from these IP&#39;s).'],
['denySMTPConnectionsFrom','Deny Connections from these IP\'s*',40,\&textinput,'','(.*)','ConfigMakeIPRe','Manually maintained list of IP\'s which should be blocked. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, penalty-whitebox will pass. For example: <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>','','7'],
['DoDenySMTPstrict','Do Deny Connections from these IP\'s Strictly','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,
 'If activated, the IP is checked against <a href="./#denySMTPConnectionsFromAlways">Deny Connections from these IP\'s Strictly</a>.'],
['denySMTPConnectionsFromAlways','Deny Connections from these IP\'s Strictly*',40,\&textinput,'file:files/denyalways.txt','(.*)','ConfigMakeIPRe',
 'Manually maintained list of IP\'s which should <b>strictly</b> be blocked after address verification and before body and header is downloaded. Contrary to <i>denySMTPConnectionsFrom</i> IP\'s in noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, penalty-whitebox will <b>not</b> pass.','','7'],
['denySMTPstrictEarly','Do Strictly Deny Connections Early*',0,\&checkbox,'','(.*)',undef,
  'IP\'s in denySMTPConnectionsFromAlways will be denied right away.'],
['DoFrequencyIP','Check Frequency - Maximum Connections Per IP','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,3,'(\d*)',undef,
 ''],
['ifValencePB','IP Frequency Violation Score',3,\&textinput,150,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],
['maxSMTPipConnects','Maximum Frequency of Connections Per IP ',3,\&textinput,'maxSMTPipConnects','(\d?\d?\d?)',undef,
 'The maximum number of SMTP connections an IP Address can make during the maxSMTPipDuration (IP Address Frequency Duration). If a server makes more than this many connections to ASSP within the maxSMTPipDuration (IP Address Frequency Duration) it will be banned from future connections until the maxSMTPipExpiration (IP Address Frequency Expiration) is reached. This can be used to prevent server overloading and DoS attacks. 16 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, PB-whitebox are excluded from SMTP session limiting, whitelisted and noprocessing addresses are honored'],
['maxSMTPipDuration','Maximum Frequency of Connections Per IP Duration',5,\&textinput,'90','(\d?\d?\d?\d?)',undef,
 'The window (in seconds) during which the maxSMTPipConnects (IP Frequency) (see above for more details) will be scrutinized for each IP. The default is 90 seconds.'],
['maxSMTPipExpiration','Expiration of Maximum Frequency',5,\&textinput,'3600','(\d?\d?\d?\d?)',undef,
 'The number of seconds that must pass before an IP address blocked by the maxSMTPipConnects (IP Address Frequency) setting is allowed to connect again. The default is 3600 (seconds) .'],
['DoDomainIP','Check Number of IP\'s Per Domain','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,3,'(\d*)',undef,
 ''],
['idValencePB','Number of IP\'s Per Domain Violation Score, default=150',3,\&textinput,150,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],
['maxSMTPdomainIP','Limit Number of IP\'s  Per Domain',3,\&textinput,'10','(\d?\d?\d?)',undef,
 'The number of IP(subnet) switches a domain may have during the maxSMTPdomainIPExpiration (Limit Different IP\'s Per Domain Expiration). If a domain switches more often than this it will be banned from future connections until the Expiration is reached. <b>This is NOT a spam blocking filter</b>, it is a tool to fight dictionary attacks, server overloading and DoS attacks. 10 connections are typically enough. If left blank or 0, there is no limit imposed by ASSP. IP\'s in noPB, noDelay, acceptAllMail, ispip, whiteListedIPs, noProcessingIPs, PB-whitebox are excluded, whitelisted and noprocessing addresses are honored.'],

['maxSMTPdomainIPExpiration','Expiration of Limit Number',5,\&textinput,'1800','(\d?\d?\d?\d?)',undef,
  'The number of seconds that must pass before a domain blocked by the maxSMTPdomainIP (Limit Subnet IP\'s Per Domain) setting (see above for more details) is allowed to connect again. The default is 1800 (seconds).'],
['maxSMTPdomainIPWL','Do Not Limit Different IP\'s For These Domains*',60,\&textinput,'gmx.de|t-online.de|yahoo.com|hotmail.com|gmail.com','(.*)','ConfigMakeRe',
  'This prevents specific domains from limiting. For example: yahoo.com|hotmail.*.com|gmail.com<br /><hr />
  <div class="menuLevel1">Notes On IP Blocking</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ipblocking.txt\',3);" />'],


[0,0,0,'heading','PenaltyBox <a href="http://www.asspsmtp.org/wiki/Penalty_box" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="PenaltyBox" /></a>'],
['DoPenalty','PenaltyBox - IP Profiles<a href="http://www.asspsmtp.org/wiki/Penalty_Box" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>','0:disabled|1:block|2:monitor/messageScoring',\&listbox,2,'(\d*)',undef,'The PenaltyBox is a  temporary position of low esteem awarded for a perceived misdeed. It scores IP\'s based on some events (<a href="./#baValencePB">see  penalty scores</a> )and writes them into  a BlackBox. If the score per specified time interval surpasses the threshold the message is rejected (and the IP is marked for blocking). They continue to get scored  up to the Extreme Threshold. These top performers can get a special treatment -> PenaltyExtreme when DoPenaltyExtreme is enabled. The WhiteBox stores IP\'s which should not be put into the BlackBox. The WhiteBox is always enabled. If an address is in the whitelist or whitedomain, the IP goes into the WhiteBox too. The WhiteBox is one of the sources  Delaying/Greylisting uses to determine when delaying should not be done. <br />Entries in noPB (Don\'t do penalties for these IP\'s) or ispip (ISP/Secondary MX Servers) will prevent from penalties. Select \'monitor/messageScoring\' to fill WhiteBox and BlackBox. \'monitor/messageScoring\' is also the right choice if you do not want to block IP\'s but rather profile a message in \'Message Scoring Mode\'. '],
['pbTestMode','PenaltyBox Testmode',0,\&checkbox,'','(.*)',undef,''],
['DoPenaltyMessage','Message Scoring/Profiling Mode ','0:disabled|1:block|2:monitor',\&listbox,1,'(\d*)',undef,'If this feature is selected, the total score for all checks during a message is used to determine if the email should be considered  Spam. If the combined score is greater than PenaltyMessageTag (MessageLimit for Tagging) and less than or equal PenaltyMessageBlock (MessageLimit for Blocking) the message will not be blocked but tagged. If the combined score is greater than the PenaltyMessageBlock, the message will be blocked.'],

['msTestMode','Message Scoring Testmode',0,\&checkbox,'','(.*)',undef,''],
['PenaltyMessageTag','Low MessageLimit',3,\&textinput,40,'(\d*)',undef,'MessageMode will not block messages whose score exceeds this threshold during the message but will tag them.  For example: 40'],
['PenaltyMessageBlock','High MessageLimit',3,\&textinput,50,'(\d*)',undef,'MessageMode will block messages whose score exceeds this threshold during the message.  For example: 50'],
['AddScoringHeader','Add IP/Message Scoring Header',0,\&checkbox,1,'(.*)',undef,'Adds a line to the email header "X-Assp-XXX-Score: ", where XXX may be IP, Message or both.'],

['pbdb','PenaltyBox Database',40,\&textinput,'pb/pbdb','(\S*)',undef,'The directory/file with the penaltybox database files. For removal of entries from BlackBox  use <a target="main" href="./#noPB">noPB</a>.
 For removal of entries from WhiteBox  use <a  target="main" href="./#noPBwhite">noPBwhite</a>. For  whitelisting IP\'s use whiteListedIPs or noProcessingIPs. For blacklisting IP\'s use denySMTPConnectionsFrom and denySMTPConnectionsFromAlways. <br /><input type="button" value=" Show BlackBox" onclick="javascript:popFileEditor(\'pb/pbdb.black.db\',4);" /><input type="button" value="Show White Box" onclick="javascript:popFileEditor(\'pb/pbdb.white.db\',4);" />'],
['noPB','Don\'t do BlackBox for these IP\'s* ',80,\&textinput,'','(.*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be profiled. These IP\'s will also be automatically removed from PB-BlackBox. For example:<a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>','','7'],
['noPBwhite','Don\'t do WhiteBox for these IP\'s* ',80,\&textinput,'','(.*)','ConfigMakeIPRe',
 'Enter IP\'s that you don\'t want to be NOT profiled. These IP\'s will also be automatically removed from PB-WhiteBox.','','7'],
['WhiteExpiration','Expiration Time for WhiteBox Entries',4,\&textinput,30,'(\d?\d?\d?\d?)',undef,,
  "The WhiteBox is always activated. The WhiteBox is similar to the  Whitelist  - but it is not a whitelist: content-related checks like Bayesian, URIBL, Bomb  will be done, IP-related checks will be skipped. WhiteBox entries will expire after this specified number of days. For example: 30"],
['spamtrapaddresses','PenaltyBox Trap Addresses* ',80,\&textinput,'put|your@penaltytrap.com|addresses|@example.org','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses will be blocked and the scoring value is added. Whitelist will be ignored. Nothing will be stored in the Spam Collection. These addresses are not checked for validity. Entries are separated by \'|\' where \'*\' can be used as a match anything wildcard. Entries that start with \'@\' indicate that all addresses with that domain should match. Entries without \'@\' indicate the user part of email addresses with any domain. Regexp are supported<br />
Valid entries are:
john.doe@example.tld|jane.doe|@example.tld|*.department@example.tld'],
['stValencePB','Penalty Trap Address Score, default=50',3,\&textinput,50,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],
['DoPenaltyMakeTraps','Do Heavy Used Invalid Addresses as PenaltyBox Trap Addresses','0:disabled|1:make traps|2:record addresses',\&listbox,2,'(.*)',undef,
  'If set to \'record addresses\', the frequency of Invalid Addresses is stored, no other action taken. if set to \'make traps\', addresses in heavy use will act like a PenaltyBox Trap Address, see <b>Invalid Addresses Limit</b> below'],
['PenaltyMakeTraps','Invalid Addresses Limit',3,\&textinput,'10','(.*)',undef,
  'Minimum number of times an address must appear before it will be used as Trap. For example 5.'],

['noPenaltyMakeTraps','Exceptionlist for Traps*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
 'Addresses which should not be used for traps. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).  Wildcards are supported (fribo*@example.com).'],
['PBTrapInterval','Invalid Addresses Refresh Interval',4,\&textinput,3,'([\d\.]+)','configUpdateTrapCR',
  'Addresses will be removed after this interval in days. For example 3. <input type="button" value=" Show Invalid Addresses" onclick="javascript:popFileEditor(\'pb/pbdb.trap.db\',5);" />'],
['PenaltyUseNetblocks','Use IP Netblocks',0,\&checkbox,'1','(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet  rather than on the specific IP.'],
['PenaltyError','Penalty Reply',80,\&textinput,'','(.*)',undef,
  'If set SMTP reply for Penalty Deny. eg: \'554 5.7.1 Error, send your mail to postmaster@LOCALDOMAIN to ensure delivery\'. The literal LOCALDOMAIN will be replaced by the recipient domain. For example:554 5.7.1 Mail appears to be unsolicited -- send error reports to postmaster@LOCALDOMAIN.'],
['PenaltyDuration','Penalty Interval',4,\&textinput,60,'(\d?\d?\d?\d?)','updatePenaltyDuration',
  "IP\'s will be kept in the BlackBox if their score exceeds the Penalty Limit during this interval (minutes)."],
['PenaltyLimit','Penalty Limit',4,\&textinput,50,'(\d*)',undef,
  'PB will block IP\'s whose score exceeds this threshold during the Penalty Interval. <br />Successful ASSP checks will increase the internal score per IP. For example: 50'],
['PenaltyExpiration','Expiration Time',4,\&textinput,360,'(\d?\d?\d?\d?)','updatePenaltyExpiration',
  "Penalties will expire after this number of minutes. If set to Zero the Penalty BlackBox will be deleted and started from scratch."],
['CleanPBInterval','Clean Up PB Databases',10,\&textinput,3,'(\d+)',undef,
  'Delete outdated entries from blackbox and whitebox databases every this many hours.<br />
  Note: the current timeout must expire before the new setting is loaded, or you can restart.
  Defaults to 3 hours.'],

['DoPenaltyExtreme','PenaltyBox Extreme IP Profiling','0:disabled|1:block|2:monitor',\&listbox,0,'(\d*)',undef,'If set PBextreme will block IP\'s whose score meet or exceed Extreme Scoring Threshold. DoPenaltyExtreme blocks after the header is done, based on the IP\'s score from previous and current SMTP session'],


['PenaltyExtreme','Extreme Scoring Threshold',4,\&textinput,150,'(\d*)',undef,
  'PBextreme will use this to determine candidates for special treatment. For example: 150.'],
['ExtremeWL','Penalize Whitelisted',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for whitelisted addresses.'],
['ExtremeNP','Penalize NonProcessing',0,\&checkbox,'','(.*)',undef,
  'Enable extreme penalties for addresses on the noProcessing list.'],
['ExtremeExpiration','Expiration Time for Extreme Penalties',4,\&textinput,7,'(\d?\d?\d?\d?)',undef,,
  "Extreme penalties will expire after this number of days. For example: 7"],
['DoExtremeExport','Do Export Penalty BlackBox Extreme',0,\&checkbox,'','(.*)',undef,  ''],
['DoExtremeExportAppend','Append Export File',0,\&checkbox,'','(.*)',undef,'Do not overwrite the export file but append to it.'],
['exportInterval','Export BlackBox Extreme File Interval',3,\&textinput,6,'(\d+)',undef,
  ' Exported Penalty Black Box Extreme File every this hours.<br />
  Defaults to 6 hours.'],
['exportExtremeBlack','Exported BlackBox Extreme File ',40,\&textinput,'file:files/exportedextreme.txt','(\S*)',undef, 'IP\'s in Penalty BlackBox which surpassed the extreme level will be regularly stored into this file. May be used for setting the firewall or similar applications.'  ],
['DoNotPenalizeRed','Do Not Score IP\'s in Redlisted Messages',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching Red Regex or Redlist will not collect scoring values from PenaltyBox.'],
['DoNotPenalizeNull','Do Not Score IP\'s From Bounce/Null-Senders',0,\&checkbox,'','(.*)',undef,
  'IP\'s matching BounceSenders (Bounce Senders) will not be profiled.'],

['msValencePB','Message Scoring Limit Exceeded, default=10',3,\&textinput,10,'(\d*)',undef, 'For IP scoring  in PenaltyBox ( DoPenalty )'],

['pbeValencePB','Extreme Bad IP History, TotalScore larger than PenaltyExtreme, default=25',3,\&textinput,25,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],
['pbValencePB','Bad IP History, TotalScore larger than PenaltyLimit, default=15',3,\&textinput,15,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],

['gripValencePB','GRIP value (+ if > 0.9,- if < 0.1), default=5',3,\&textinput,5,'(\d*)',undef, 'message scoring  in PenaltyBox ( DoPenaltyMessage )'],
['okValencePB','Message OK, default=-25',3,\&textinput,-25,'(-?\d*)',undef, '<span class="positive">IP Bonus</span><br />

<hr />
More score values are located in the individual filter sections:
<br><br> baValencePB (Bad Attachment Score)
<br> backsctrValencePB (Backscatter detection Score)
<br> baysValencePB (Bayesian Score)
<br> bccValencePB (Blocked Country Code Score)
<br> blValencePB (Blacklisted Domain Score)
<br> blackValencePB (Bomb Black Expression  Score)
<br> bombSuspiciousValencePB (Bomb Suspicious Score)
<br> bombValencePB (Bomb Expression Score)
<br> erValencePB (Empty Recipients Score)
<br> fhValencePB (Forged HELO Score)
<br> fiphValencePB (Suspicious HELO: IP in HELO Score)

<br> flValencePB (Invalid Local Sender Score)
<br> gripValencePB (GRIP value (+ if > 0.9,- if < 0.1) Score)
<br> hlValencePB (Blacklisted HELO Score)
<br> iaValencePB (Internal Only Address Score)
<br> idValencePB (Domain Changing IP Frequency Score)
<br> ifValencePB (IP Frequency Score)
<br> ihValencePB (Invalid HELO Score)
<br> iplValencePB (IP Parallel Sessions Score)
<br> irValencePB (Invalid Recipient Score)
<br> meValencePB (Max Errors Exceeded Score)

<br> midmValencePB (Missing Message-ID Score)
<br> midsValencePB (Suspicious Message-ID Score)

<br> mxValencePB (Missing MX  Score)
<br> mxaValencePB (Missing MX &amp; A Record Score)

<br> ptiValencePB (Invalid PTR Record Score)
<br> ptmValencePB (Missing PTR Record Score)
<br> rblValencePB (DNSBL Failed Score)
<br> rblnValencePB (DNSBL Neutral Score)
<br> rlValencePB (Failed Relay Attempt Score)
<br> saValencePB (Spam Collect Address Score)

<br> sbfccValencePB (Foreign Country Code Score)
<br> sbhccValencePB (Home Country Code Score)
<br> sbsccValencePB (Suspicious Country Code Score)
<br> scriptValencePB (Script Expression Score)
<br> spfValencePB (SPF Failed Score)
<br> spfeValencePB (SPF Error Score)
<br> spfnValencePB (SPF Neutral Score)
<br> spfnonValencePB (SPF None Score)
<br> spfsValencePB (SPF Softfailed Score)
<br> spfuValencePB (SPF Unknown Score)
<br> stValencePB (Penalty Trap Address Score)
<br> uriblValencePB (URIBL Failed Score)
<br> uriblnValencePB (URIBL Neutral Score)
<br> vsValencePB (Virus suspicious Score)
<hr />
  <div class="menuLevel1">Notes On PenaltyBox</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/penaltybox.txt\',3);" />'],


[0,0,0,'heading','Delaying/Greylisting <a href="http://www.asspsmtp.org/wiki/Delaying" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Delaying" /></a>'],
['EnableDelaying','Enable Delaying/Greylisting',0,\&checkbox,1,'(.*)',undef,
  'Enable Greylisting as described at <a href="http://projects.puremagic.com/greylisting/whitepaper.html?view=markup" rel="external">Greylisting-whitepaper</a>.<br />
   Greylisting involves sending a temporary 451 SMTP error code to the sending server when a message is received, along with sending this error code ASSP creates a Triplet and stores this. On the second delivery attempt if the Embargo Time set by the ASSP admin for the Triplet has been surpassed the message will be accepted and a Tuplet will be created and not delayed again for an Expiry Time set by the ASSP admin.'],
['DelayWL','Whitelisted Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for whitelisted users.'],
['DelayNP','NoProcessing Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for noprocessing users.'],
['DelaySL','SpamLovers Greylisting',0,\&checkbox,'','(.*)',undef,
  'Enable Greylisting for SpamLovers.'],
['DelayAddHeader','Add X-Assp-Delayed Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Delayed header to header of all delayed or whitelisted emails.'],
['DelayEmbargoTime','Embargo Time',5,\&textinput,5,'(\d+)',undef,
  'Enter the number of minutes for which delivery, related with new \'triplet\' (IP address of the sending<br />
  host + mail from + rcpt to), is refused with a temporary failure. Default is 5 minutes.'],
['DelayWaitTime','Wait Time',5,\&textinput,28,'(\d+)',undef,
  'Enter the number of hours to wait for delivery attempts related with recognised \'triplet\'; delivery is accepted <br />
  immediately and the \'tuplet\' (IP address of the sending host + sender\'s domain) is safelisted. Default is 28 hours.'],
['DelayExpiryTime','Expiry Time',5,\&textinput,36,'(\d+)',undef,
  'Enter the number of days for which whitelisted \'tuplet\' is considered valid. Default is 36 days.'],
['DelayUseNetblocks','Use IP Netblocks',0,\&checkbox,1,'(.*)',undef,
  'Perform the IP address checks of the sending host based on the /24 subnet it is at rather than the specific IP. <br />
  This feature may be useful for legitimate mail systems that shuffle messages among SMTP clients between retransmissions.'],
['DelayNormalizeVERPs','Normalize VERP Addresses',0,\&checkbox,1,'(.*)',undef,
  'Some mailing lists (such as Ezmlm) try to track bounces to individual mails, rather than just individual recipients, which creates a variation on the VERP method where each email has it\'s own unique envelope sender. Since the automatic whitelisting (called savelisting to make a difference to the standard whitelisting) that is built into Greylisting depends on the envelope addresses for subsequent emails being the same, the greylisting filter will attempt to normalize the unique sender addresses, when this option is checked.'],
['DelayMD5','Use MD5 for DelayDB',0,\&checkbox,'1','(.*)',undef,
  'Message-Digest algorithm 5 is a cryptographic hash function and adds some level of security to the delay database. Must be set to off if you want to list the database with DelayShowDB/DelayShowDBwhite.'],
['DelayShowDB','Show Delay/Greylisting Database',40,\&textinput,'file:delaydb','(\S*)',undef,'The directory/file with the delay database file. If you change the filename in section <a onmousedown="toggleDisp(\'18\')" href="./#delaydb">Filepath</a> you must change it here too.','','8'],
['DelayShowDBwhite','Show Delay/Greylisting Save Database',40,\&textinput,'file:delaydb.white','(\S*)',undef,'The directory/file with the save delay database file. If you change the filename in section <a onmousedown="toggleDisp(\'18\')" href="./#delaydb">Filepath</a> you must change it here too.','','8'],
['DelayExpireOnSpam','Expire Spamming Safelisted Tuplets',0,\&checkbox,1,'(.*)',undef,
  'If a safelisted \'tuplet\' is ever associated with spam, viri, failed rbl, spf etc, it is deleted from the safelist. <br />
  This renews the temporary embargo for subsequent mail involving the tuplet.'],
['CleanDelayDBInterval','Clean Up Delaying Database',10,\&textinput,10800,'(\d+)',undef,
  'Delete outdated entries from triplets and safelisted tuplets databases every this many seconds.<br />
  Note: the current timeout must expire before the new setting is loaded, or you can restart.
  Defaults to 3 hours.'],
['noDelay','Don\'t Delay these IPs*',80,\&textinput,'file:files/nodelay.txt','(.*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be delayed, separated by pipes (|). There are misbehaving MTAs that will not be able to get a legitimate email through a Greylisting server because they do not try again later. An INCOMPLETE list of such mailers is available at <a href="http://cvs.puremagic.com/viewcvs/greylisting/schema/whitelist_ip.txt" rel="external">cvs.puremagic.com/viewcvs/Greylisting/schema/whitelist_ip.txt</a>. <br />
  When using mentioned list remember to add trailing dots in IP addresses which specify subnets (eg. 192.168 -> 192.168. ).<br />
  For example:  <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>.','','7'],
['DelayError','Reply Code to Refuse Delayed Messages',80,\&textinput,'451 4.7.1 Please try again later','(45\d .*)',undef,
  'SMTP reply code to refuse delayed messages. Default: 451 4.7.1 Please try again later
  <br /><hr />
  <div class="menuLevel1">Notes On Delaying</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/delaying.txt\',3);" />'],

[0,0,0,'heading','SPF/SRS <a href="http://www.asspsmtp.org/wiki/SPF" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="SPF" /></a>'],

['ValidateSPF','Enable SPF Validation','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'Enable Sender Policy Framework Validation as described at <a href="http://www.openspf.org/" rel="external">openspf</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SPF::Query</a> module in PERL.'],
['spfTestMode','SPF Testmode',0,\&checkbox,'','(.*)',undef,''],
['SPF2','Do SPF Version 2 Validation',0,\&checkbox,'1','(.*)',undef,
  'Enable Sender Policy Framework Validation Version 2.<br />
  This requires an installed <a href="http://search.cpan.org/dist/Mail-SPF/" rel="external">Mail::SPF</a> object-oriented Perl module. '],
['SPFWL','Whitelisted SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for whitelisted users also.'],
['SPFNP','noProcessing SPF Validation',0,\&checkbox,'','(.*)',undef,
  'Enable Sender Policy Framework Validation for nonprocessed messages also.'],
['SPFtrusted','Use Trusted Forwarder List',0,\&checkbox,'','(.*)',undef,
 'The trusted-forwarder.org domain provides a global whitelist  for users of the SPF system. It provides early adopters of SPF a way of allowing legitimate email that is sent through known, trusted email forwarders from being blocked by SPF checks simply because the forwarders do not use some sort of envelope-from rewriting system.<br />
		<span class="negative">This option applies to Mail::SPF::Query module only.</span>'],
['AddSPFHeader','Add Received-SPF Header',0,\&checkbox,1,'(.*)',undef,
  'Add Received-SPF header to header of all emails processed by SPF.'],
['SPFError','SPF Failed Reply',80,\&textinput,'554 5.7.1 failed SPF: SPFRESULT','(.*)',undef,
  'SMTP reply for SPF failed messages. Default: \'554 5.7.1 failed SPF: SPFRESULT\'<br />
  The literal SPFRESULT (case sensitive) is replaced by the actual result.'],
['noSPFRe','Skip SPF Processing*',80,\&textinput,'','(.*)','ConfigCompileRe',
 'Put anything here to identify these messages in mailfrom or header'],
['SPFoverride','Override Domains*',80,\&textinput,'','(.*)','configUpdateSPFover',
 'Set override to define SPF records for domains that do publish but which you want to override anyway. If you specify only domains the Local SPF Record below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.example.com<br />
		<span class="negative">This option applies to Mail::SPF::Query module only.</span>'],
['SPFfallback','Fallback Domains*',80,\&textinput,'','(.*)','configUpdateSPFfall',
 'Set fallback to define "pretend" SPF records for domains that don\'t publish them yet. If you specify only domains the Local SPF Record below will be used as default. Wildcards are supported. For example: abc.com=>v=spf1 a/24 mx/24 ptr -all|cello.ch=>v=spf1 ip4:213.46.243.0/26  ~all|abc.com|*.example.com<br />
		<span class="negative">This option applies to Mail::SPF::Query module only.</span>'],
['LocalPolicySPF','Local SPF Policy',80,\&textinput,'v=spf1 a/24 mx/24 ptr ~all','(.*)',undef,'If the sending domain does not publish its own SPF Records this will be used.<br />The default is v=spf1 a/24 mx/24 ptr ~all<br />
		<span class="negative">This option applies to Mail::SPF::Query module only.</span>'],
['SPFlocalRecord','Fallback/Override SPF Record',80,\&textinput,'v=spf1 a/24 mx/24 ptr -all','(.*)',undef,'Used in Fallback/Override Domains<br />The default is v=spf1 a/24 mx/24 ptr -all'],
['strictSPFRe','Strict SPF Processing Regex*',80,\&textinput,'@gmail.com|@hotmail.com|@msn.com|@live.com|@aol.com|@ebay.com|@ebay.nl|@bbt.com|@paypal.com|@einsundeins.de|@microsoft.com|rr.com|veritate.com','(.*)','ConfigCompileRe',
 'Softfail/Neutral will be failed for these sending addresses. Put anything here to identify the addresses'],
['blockstrictSPFRe','Block SPF Processing Regex*',80,\&textinput,'@ebay.com|@paypal.com','(.*)','ConfigCompileRe',
 'All failed messages will be blocked for these sending addresses. Put anything here to identify the addresses.'],
['SPFsoftfail','Fail SPF Softfail Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF softfail status responses. The possible results of a query are:
<br />pass:The client IP address is an authorized mailer for the sender. The mail should be accepted subject to local policy regarding the sender.
<br />fail:The client IP address is not an authorized mailer, and the sender wants you to reject the transaction for fear of forgery.
<br />softfail:The client IP address is not an authorized mailer, but the sender prefers that you accept the transaction because it isn\'t absolutely sure all its users are mailing through approved servers. The softfail status is often used during initial deployment of SPF records by a domain.
<br />neutral:The sender makes no assertion about the status of the client IP.
<br />none:There is no SPF record for this domain.
<br />permerror&temperror:The DNS lookup encountered an error during processing.
<br />unknown:The domain has a configuration error in the published data or defines a mechanism that this library does not understand.'],
['SPFneutral','Fail SPF Neutral Validations',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF neutral status responses'],
['SPFqueryerror','Fail SPF Error Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'error\' status responses'],
['SPFnone','Fail SPF None  Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'none\'  status responses'],
['SPFunknown','Fail SPF Unknown  Responses',0,\&checkbox,'','(.*)',undef,
  'Intentionally fail SPF \'unknown\'  status responses'],
['spfnValencePB','SPF Neutral Score, default=5',3,\&textinput,5,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['spfsValencePB','SPF Softfailed Score, default=5',3,\&textinput,5,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['spfnonValencePB','SPF None Score',3,\&textinput,0,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['spfuValencePB','SPF Unknown Score',3,\&textinput,0,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['spfeValencePB','SPF Error Score, default=5',3,\&textinput,5,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['spfValencePB','SPF Failed Score, default=10',3,\&textinput,10,'(\d*)',undef,'For Message & IP scoring  in PenaltyBox ( DoPenalty )'],
['SPFCacheInterval','SPF Cache Refresh Interval',4,\&textinput,3,'([\d\.]+)','configUpdateSPFCR',
  'SPF records in cache will be removed after this interval in days. 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.spf.db\',6);" />'],
['DebugSPF','Enable SPF Debug output to ASSP Logfile',0,\&checkbox,'','(.*)',undef,
 'Enables verbose debugging of SPF queries within the Mail::SPF::Query module.
 <br /><hr />
 <div class="menuLevel1">Notes On SPF</div>
 <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/spf.txt\',3);" /> '],
['EnableSRS','Enable Sender Rewriting Scheme',0,\&checkbox,'','(.*)','updateSRS',
  'Enable Sender Rewriting Scheme as described at <a href="http://www.openspf.org/SRS" rel="external">www.openspf.org/SRS</a>.<br />
  This requires an installed <a href="http://www.openspf.org/Implementations" rel="external">Mail::SRS</a> module in PERL.<br />
  You should use SRS if your message handling system forwards email for domains with published spf records.<br />
  Note that you have to setup the outgoing path (Relay Host &amp; Port) to let ASSP see and rewrite your outgoing traffic.'],
['srsTestMode','SRS Testmode',0,\&checkbox,'','(.*)',undef,''],
['SRSAliasDomain','Alias Domain',40,\&textinput,'example.com','(.*)','updateSRSAD',
  'SPF requires the SMTP client IP to match the envelope sender (return-path). When a message is forwarded through<br />
  an intermediate server, that intermediate server may need to rewrite the return-path to remain SPF compliant.<br />
  For example: example.com'],
['SRSSecretKey','Secret Key',20,\&textinput,'','(.*)','updateSRSSK',
  'A key for the cryptographic algorithms -- Must be at least 5 characters long.'],
['SRSTimestampMaxAge','Maximum Timestamp Age',5,\&textinput,21,'(\d+)',undef,
  'Enter the maximum number of days for which a timestamp is considered valid. Default is 21 days.'],
['SRSHashLength','Hash Length',5,\&textinput,4,'(\d+)',undef,
  'The number of bytes of base64 encoded data to use for the cryptographic hash.<br />
  More is better, but makes for longer addresses which might exceed the 64 character length suggested by RFC5321.<br />
  This defaults to 4, which gives 4 x 6 = 24 bits of cryptographic information, which means that a spammer will have <br />
  to make 2^24 attempts to guarantee forging an SRS address.'],
['SRSValidateBounce','Enable Bounce Recipient Validation',0,\&checkbox,1,'(.*)',undef,
  'Bounce messages that fail reverse SRS validation (but not a valid SMTP probe)<br />
  will receive a 554 5.7.5 [Bounce address not SRS signed] SMTP error code.'],
['SRSno','Don\'t Rewrite These Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t rewrite addresses when messages come from/to these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). <br />For example: fribo@example.com|jhanna|@example.org'],
['noSRS','Don\'t Validate Bounces From these IPs*',80,\&textinput,'','(.*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to validate bounces from, separated by pipes (|).
  For example:  <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>.<br /><hr />
  <div class="menuLevel1">Notes On SRS</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/srs.txt\',3);" />','','7'],

[0,0,0,'heading','DNSBL <a href="http://stats.dnsbl.com/" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="DNSBL Statistics" /></a>'],
['ValidateRBL','Enable DNS Blacklist Validation ','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(.*)','configUpdateRBL',
  'This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL.'],
['rblTestMode','DNSBL Testmode',0,\&checkbox,'','(.*)',undef,''],
['rblValencePB','DNSBL Failed Score, default=45',3,\&textinput,45,'(\d*)',undef,'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['rblnValencePB','DNSBL Neutral Score, default=25',3,\&textinput,25,'(\d*)',undef,'For Message & IP scoring in PenaltyBox ( DoPenalty )'],


['ForceRBLCache','Early DNSBL Cache Blocking',0,\&checkbox,'','(.*)',undef,
  'If set, ASSP will use cached DNSBL hits to block messages before other tests. <b>testmode</b> will override this. <b>spamlover settings</b> will be ignored.'],
['noRBL','Don\'t do DNSBL for these IPs*',80,\&textinput,'','(.*)','ConfigMakeIPRe',
 'Enter IP addresses that you don\'t want to be DNSBL validated, separated by pipes (|). For example:  <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>.',undef,'7'],
['RBLWL','Whitelisted DNSBL Validation',0,\&checkbox,0,'(.*)',undef,
  'Enable DNSBL for whitelisted messages also'],
['AddRBLHeader','Add X-Assp-Received-DNSBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Received-DNSBL header to messages with positive reply from DNSBL.'],
['RBLError','DNSBL Failed Reply',80,\&textinput,'554 5.7.1 DNS Blacklisted by RBLLISTED','(.*)',undef,
  'SMTP reply for DNSBL failed messages. Default: \'554 5.7.1 DNS Blacklisted by RBLLISTED\'<br />
  The literal RBLLISTED (case sensitive) is replaced by the actual serviceproviders(s).'],
['RBLServiceProvider','RBL Service Providers* <a href="http://www.asspsmtp.org/wiki/DNSBL" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a>',80,\&textinput,'zen.spamhaus.org|psbl.surriel.com|ix.dnsbl.manitu.net|bl.spamcop.net|no-more-funn.moensted.dk|combined.njabl.org|safe.dnsbl.sorbs.net','(\S*)','configUpdateRBLSP',
 'Names of DNSBLs to use separated by "|". Defaults are:<br /> zen.spamhaus.org|bl.spamcop.net|psbl.surriel.com|ix.dnsbl.manitu.net|combined.njabl.org|safe.dnsbl.sorbs.net. You may add<br/> dnsbl-1.uceprotect.net|dnsbl-2.uceprotect.net|dnsbl-3.uceprotect.net'],
['RBLmaxreplies','Maximum Replies',3,\&textinput,6,'(\d*)','configUpdateRBLMR','A reply is affirmative or negative reply from a DNSBL.<br />
  The DNSBL module will wait for this number of replies (negative or positive) from the DNSBLs listed under Service Provider for up to the Maximum Time(RBLmaxtime).<br />
  This number should be equal to or less than the number of DNSBL Service Providers listed to allow for randomly unavailable DNSBLs'],
['RBLmaxhits','Maximum Hits',3,\&textinput,2,'(\d*)','configUpdateRBLMH','A hit is an affirmative response from a DNSBL.<br />
  The DNSBL module will check all of the DNSBLs listed under Service Provider. If the number of hits is greater or equal Maximum Hits, the email is flagged <b>Failed</b>.<br /> If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>Neutral</b>'],

['RBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,'This sets the maximum time in seconds to spend on each message performing DNSBL checks. Default is 10.'],
['RBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the DNSBL socket read timeout in seconds.'],
['RBLCacheExp','DNSBL Expiration Time',4,\&textinput,24,'([\d\.]+)','configUpdateRBLCR',
  'IP\'s in cache will be removed after this interval in hours. 0 will disable the cache. <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.rbl.db\',5);" />
  <hr /><div class="menuLevel1">Notes On DNSBL</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/rbl.txt\',3);" />'],

[0,0,0,'heading','URIBL'],
 ['ValidateURIBL','Enable URI Blocklist Validation <a href="http://www.uribl.com/about.shtml" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="about" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,'1','(.*)','configUpdateURIBL',
  'Enable URI Blocklist. Messages that fail URIBL validation will receive URIBLError SMTP error code. This requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in PERL. <a href="http://www.asspsmtp.org/wiki/FAQ#Common_Problems" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="wiki" /></a><br />'],
['uriblTestMode','URIBL Testmode',0,\&checkbox,'','(.*)',undef,''],
['uriblnValencePB','URIBL Neutral Score, default=20',3,\&textinput,20,'(\d*)',undef,'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['uriblValencePB','URIBL Failed Score, default=25',3,\&textinput,25,'(\d*)',undef,'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['URIBLWL','Do URI Blocklist Validation for Whitelisted',0,\&checkbox,'','(.*)',undef,''],
 ['URIBLNP','Do URI Blocklist Validation for NoProcessing',0,\&checkbox,'','(.*)',undef,''],
 ['URIBLLocal','Do URI Blocklist Validation for Local Mails',0,\&checkbox,'','(.*)',undef,''],
 ['URIBLISP','Do URI Blocklist Validation for ISP/Secondary',0,\&checkbox,1,'(.*)',undef,''],
 ['URIBLServiceProvider','URIBL Service Providers*',60,\&textinput,'multi.surbl.org|black.uribl.com','(.*)','configUpdateURIBLSP',
  'Domain Names of URIBLs to use. Default is: multi.surbl.org|black.uribl.com'],
 ['URIBLCCTLDS','URIBL Country Code TLDs*',60,\&textinput,'file:files/URIBLCCTLDS.txt','(.*)','ConfigMakeRe',
  'List of <a href="http://spamcheck.freeapp.net/two-level-tlds" rel="external">country code TLDs</a> used to determine the base domain of the uri.'],
 ['URIBLmaxuris','Maximum URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of URIs in the body will increase spam probability. Enter 0 to disable feature.'],
 ['URIBLmaxdomains','Maximum Unique Domain URIs',5,\&textinput,0,'(\d*)',undef,
  'More than this number of unique domain URIs in the body will increase spam probability. Enter 0 to disable feature.'],
 ['URIBLNoObfuscated','Disallow Obfuscated URIs <a href="http://www.pc-help.org/obscure.htm" target="ASSPHELP"><img src="' . $wikiinfo . '" alt="obscure" /></a>',0,\&checkbox,'1','(.*)',undef,
  'When enabled, messages with obfuscated URIs of types [integer/octal/hex IP,
other things!] in the body will get increased spam probability.'],
['URIBLmaxreplies','Maximum Replies',5,\&textinput,2,'(\d*)','configUpdateURIBLMR',
  'A reply is affirmative or negative reply from a URIBL.<br />
   The URIBL module will wait for this number of replies (negative or positive) from the URIBLs listed under Service Provider<br />
   for up to the Maximum Time below. This number should be equal to or less than the number of URIBL Service Providers<br />
   listed to allow for randomly unavailable URIBLs.'],
 ['URIBLmaxhits','Maximum Hits',5,\&textinput,1,'(\d*)','configUpdateURIBLMH',
  'A hit is an affirmative response from a URIBL.<br />
   The URIBL module will check all of the URIBLs listed under Service Provider.
   If the number of hits is greater or equal Maximum Hits, the email is flagged <b>failed</b>. If the number of hits is greater 0 and less Maximum Hits, the email is flagged <b>neutral</b>.'],
 ['URIBLmaxtime','Maximum Time',5,\&textinput,10,'(\d*)',undef,
  'This sets the maximum time in seconds to spend on each message performing URIBL checks.'],
 ['URIBLsocktime','Socket Timeout',5,\&textinput,1,'(\d*)',undef,'This sets the URIBL socket read timeout in seconds.'],
 ['URIBLwhitelist','Whitelisted URIBL Domains*',60,\&textinput,'doubleclick.net','(.*)','ConfigMakeRe',
  'This prevents specific domains from being checked by URIBL module. For example: doubleclick.net or file:files/URIBLwhitelist.txt. Domains already listed in noProcessingDomains and whitelistedDomains will be honored.'],
 ['noURIBL','Don\'t Check Messages from these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t validate URIBL when messages come from these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). <br />For example: fribo@example.com|jhanna|@example.org'],
 ['AddURIBLHeader','Add X-Assp-Received-URIBL Header',0,\&checkbox,1,'(.*)',undef,
  'Add X-Assp-Received-URIBL header to messages with positive reply from URIBL.'],
 ['URIBLCacheExp','URIBL Cache Expiration Time',3,\&textinput,24,'([\d\.]+)','configUpdateURIBLCR',
  'Domains in cache will be removed after this interval in hours. Empty or 0 will disable the cache.  <input type="button" value=" show cache" onclick="javascript:popFileEditor(\'pb/pbdb.uribl.db\',5);" />'],

 ['URIBLError','Reply Code to Refuse Failed URIBL Message',80,\&textinput,'554 5.7.1 Blacklisted by URIBLNAME Contact the postmaster of this domain for resolution. This attempt has been logged.','([245]5\d .*|)',undef,
  'SMTP reply code to refuse failed URIBL message. The literal URIBLNAME (case sensitive) is replaced by the names of URIBLs with negative response. If this field is empty, client connection is simply dropped.<br /><hr /><div class="menuLevel1">Notes On URIBL</div>
<input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/uribl.txt\',3);" />'],

[0,0,0,'heading','Attachment Blocking <a href="http://www.asspsmtp.org/wiki/Blocking_Attachments" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Blocking_Attachments" /></a>'],
['DoBlockExes','External Attachment Blocking ','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'([\s01234]?)',undef,''],
['baValencePB','Bad Attachment, default=20',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['attachTestMode','Bad Attachment & VirusscanTestmode',0,\&checkbox,'','(.*)',undef,''],
['BlockExes','External Attachment Blocking Level <a href="http://www.asspsmtp.org/wiki/Dealing_with_Attachments#Dangerous_Attachments" target="wiki"><img src="' . $wikiinfo . '" alt="wiki" /></a>','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 1-3 for attachments that should be blocked, set level to 4  for attachments that should be allowed. Choose 0 for no attachment blocking.'],
['BlockWLExes','Whitelisted &amp; Local Attachment Blocking','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for whitelisted &amp; local senders. Choose 0 for no attachment blocking.'],
['BlockNPExes','NoProcessing Attachment Blocking','0:Level 0|1:Level 1|2:Level 2|3:Level 3|4:Level 4',\&listbox,0,'([\s01234]?)',undef,
  'Set the level of Attachment Blocking to 0-4 for no processing senders. Choose 0 for no attachment blocking. '],
['BadAttachL1','Level 1 rejected File Extensions',80,\&textinput,'exe|scr|pif|vb[es]|js|jse|ws[fh]|sh[sb]|lnk|bat|cmd|com|ht[ab]','(.*)','updateBadAttachL1',
  'This regular expression is used to identify Level 1 attachments that should be blocked.<br />
  Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br /> For example:<br /> ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]'],
['BadAttachL2','Level 2 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL2',
  'This regular expression is used to identify Level 2 attachments that should be blocked.<br />
  Level 2 already includes all rejected extensions from Level 1. <br /> For example:<br /> (ad[ep]|asx|ba[st]|chm|cmd|com|cpl|crt|dbx|exe|hlp|ht[ab]|in[fs]|isp|js|jse|lnk|md[abez]|mht|ms[cipt]|nch|pcd|pif|prf|reg|sc[frt]|sh[bs]|vb|vb[es]|wms|ws[cfh]).zip'],
['BadAttachL3','Level 3 rejected File Extensions',80,\&textinput,'','(.*)','updateBadAttachL3',
  'This regular expression is used to identify Level 3 attachments that should be blocked.<br />
  Level 3 includes Level 2 and Level 1.<br /> For example:<br /> zip|url'],
['GoodAttach','Level 4 Allowed File Extensions',80,\&textinput,'','(.*)','updateGoodAttach',
  'This regular expression is used to identify  attachments that should be allowed. All others are blocked. Separate entries with a pipe |. The dot . is assumed to precede these, so don\'t include it.<br /> For example:<br /> ai|asc|bhx|dat|doc|docx|eps|gif|htm|html|ics|jpg|jpeg|hqx|od[tsp]|pdf|ppt|rar|rpt|rtf|snp|txt|xls|zip'],

['AttachmentError','Reply Code to Refuse Rejected Attachments',80,\&textinput,'550 5.7.1 These attachments are not allowed -- Compress before mailing.','([25]\d\d .*)',undef,'The literal FILENAME (case sensitive) will be replaced with the name of the blocked attachment!'],
['BlockUuencoded','Refuse Uuencoded Mails',0,\&checkbox,1,'(.*)',undef,''],
['UuencodedError','Reply to Refuse Uuencoded Mails',80,\&textinput,'554 5.7.1 This message is uuencoded and will be blocked. ','([25]\d\d .*)',undef,
 'For example: 554 5.7.1 This mail is uuencoded and will be blocked<br />
 <hr /><div class="menuLevel1">Notes On Attachment Blocking</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/Attachments.txt\',3);" />'],

[0,0,0,'heading','ClamAV <a href="http://www.asspsmtp.org/wiki/File-Scan-ClamAV" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="ClamAV_Win32" /></a>'],
['UseAvClamd','Use ClamAV',0,\&checkbox,'','(.*)',undef,
   'If activated, the message is checked by ClamAV, this requires an installed
 <a href="http://www.asspsmtp.org/wiki/File-Scan-ClamAV" rel="external">File::Scan::ClamAV</a> Perl module and a running <a
 href="http://www.asspsmtp.org/wiki/ClamAV_Win32" rel="external" target="ASSPHELP">Clamd (Windows)</a>
 or <a href="http://www.clamav.net/"
 rel="external" target="ASSPHELP">Clamd (Unix)</a>. <br />The viruses will
 be stored in a special folder if the SpamVirusLog is set to \'quarantine\' and the
 filepath to the viruslog is set.'],
['vsValencePB','Virus Suspicious Score, default=25',3,\&textinput,25,'(\d*)',undef,'message scoring in PenaltyBox ( DoPenaltyMessage )'],
['vdValencePB','Virus Detected Score, default=50',3,\&textinput,50,'(\d*)',undef, 'Message & IP scoring'],
['noScan','Do Not Scan Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).'],
['NoScanRe','Skip ClamAV RegEx*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages which should not be checked for viruses."],
['SuspiciousVirus','No-Blocking Virus Scoring Regex',80,\&textinput,'','(.*)','ConfigCompileRe',
 'If a ClamAV result matches this expression it will be scored with the suspicious virus score and the message will not be blocked.'],
['ScanWL','Scan Whitelisted Senders',0,\&checkbox,'1','(.*)',undef,''],
['ScanNP','Scan No Processing Senders',0,\&checkbox,'','(.*)',undef,''],
['ScanLocal','Scan Local Senders',0,\&checkbox,'','(.*)',undef,''],
['ScanCC','Scan Copied Spam Mails',0,\&checkbox,'','(.*)',undef,''],
['AvClamdPort','Port or file socket for ClamAV',30,\&textinput,'/tmp/clamd','(\S+)',undef,
 'A socket specified in the clamav.conf file - LocalSocket. For example /tmp/clamd. If the socket has been setup as a TCP/IP socket (see the TCPSocket option in the clamav.conf file), then specify the TCP socket. For example: 3310 '],
['ClamAVBytes','ClamAV Bytes',8,\&textinput,60000,'(\d*)',undef,
  'The number of bytes per message that will be submitted for virus scanning. Values of 100000 or larger are not recommended.'],
['ClamAVtimeout','ClamAV Timeout',3,\&textinput,10,'(\d*)',undef, 'ClamAV will timeout after this many seconds.<br /> default: 10 seconds.'],
['AvError','Reply Code to Refuse Infected Messages',80,\&textinput,'554 5.7.1 Mail appears infected with \'$infection\'.','([25]\d\d .*)',undef,
 'Reply code to refuse infected messages. The string $infection is replaced with the name of the detected virus.<br />
 For example: 554 5.7.1 Mail appears infected with \'$infection\' -- disinfect and resend.'],
['EmailVirusReportsTo','Send Virus Report To This Address',40,\&textinput,'','(.*)',undef,
 'If set an email containing the Message ID, Remote IP, Message Subject, Sender email address, Recipient email address, and the virus detected will be sent to this address. For example: admin@example.com'],
['EmailVirusReportsHeader','Add Full Header To Virus Report To Mail Address Above',0,\&checkbox,'','(.*)',undef,'If set the full message headers will also be added to Virus Reports.'],
['EmailVirusReportsToRCPT','Send Virus Report To Recipient',0,\&checkbox,'','(.*)',undef,'If set the intended recipient of the message will be sent a copy of the Virus Report. <input type="button" value=" Edit virusreport.txt file" onclick="javascript:popFileEditor(\'reports/virusreport.txt\',2);" /><br />
 <hr /><div class="menuLevel1">Notes On Virus Control</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/viruscontrol.txt\',3);" />'],

[0,0,0,'heading','Regex Filters / Spambomb <a href="http://www.asspsmtp.org/wiki/BombRe" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="BombRe" /></a>'],
['bombTestMode','Bomb Regex Testmode',0,\&checkbox,'','(.*)',undef,''],

['bombValencePB','Bomb Expression Matching Score, default=20',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['bombReWL','Do Bomb/Script Regular Expressions Checks for Whitelisted',0,\&checkbox,'','(.*)',undef,''],
['bombReNP','Do Bomb/Script Regular Expressions Checks for NoProcessing',0,\&checkbox,'','(.*)',undef,''],
['bombReLocal','Do Bomb/Script Regular Expressions Checks for Local Messages',0,\&checkbox,'','(.*)',undef,''],
['bombReISPIP','Do Bomb/Script Regular Expressions Checks for ISPIP',0,\&checkbox,'1','(.*)',undef,''],
['DoBombSenderRe','Use BombSender Regular Expression','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each Sender address is checked  against the BombSender Regular Expression.'],
['bombSenderRe','BombSender Blocking Regular Expression *',80,\&textinput,'emailserver3.com|\d\d\d\d\d\d@tom.com','(.*)','ConfigCompileRe',
  'Expression to identify sender you want to stop immediately. If an incoming sender matches this Perl regular expression connection will be dropped. Whitelist and Nonprocessing will be honored.<b> emailserver3.com</b> should be always included in the list.'],
['DoBombHeaderRe','Use BombHeader Regular Expressions on Header Part','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each message-header is checked  against bombHeaderRe, bombSubjectRe and bombCharSets Regular Expressions. If you use sendAllSpam, be aware that only the header will be shown in the spamcopy.'],
['bombHeaderRe','Regular Expression to Identify Spam in Header Part*',80,\&textinput,'file:files/bombheaderre.txt','(.*)','ConfigCompileRe',
  'Header will be checked against this Regex if DoBombHeaderRe is enabled. For example<br /> file:files/bombheaderre.txt'],
['DoBombHeaderByLocalDomain','Do Checks for LocalDomains in Header',0,\&checkbox,1,'(.*)',undef,'If set and DoBombHeaderRe  is enabled, expressions like \'BY yourLOCALDOMAIN\' will be used to identify Spam.'],
['bombSubjectRe','Regular Expression to Identify
 Spam in Subject*',80,\&textinput,'','(.*)','ConfigCompileRe','Part of BombHeader Check: Header will be checked against this Regex if  DoBombHeaderRe  is enabled.'],
['bombCharSets','Regular Expression to Identify Foreign Charsets* ',60,\&textinput,'charset=(BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251)','(.*)','ConfigCompileRe','Part of BombHeader Check: Header will be checked against this Regex if <b>DoBombHeaderRe</b> is enabled. For example:<br /> charset=(BIG5|CHINESEBIG|GB2312|KS_C_5601|KOI8-R|EUC-KR|ISO-2022-JP|ISO-2022-KR|ISO-2022-CN|CP1251). '],
['DoBombRe','Use Bomb Regular Expressions','0:disabled|1:block|2:monitor|3:score',\&listbox,1,'(\d*)',undef,
  'If activated, each message is checked  against BombRaw and BombData Regular Expressions.
  '],
['bombRe','BombRaw Regular Expression for Header and Data Part*',80,\&textinput,'file:files/bombre.txt','(.*)','ConfigCompileRe','Header and Data will be checked against this Regular Expression if DoBombRe is enabled.  For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;'],
['bombDataRe','BombData Regular Expression for Data Part*',80,\&textinput,'file:files/bombre.txt','(.*)','ConfigCompileRe','Data part will be checked against the Regular Expression  if DoBombRe is enabled. For example:<br />IMG [^&gt;]*src=[\'&quot;]cid|&lt;BODY[^&gt;]*&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;IMG[^&gt;]+&gt;(&lt;[^&gt;]+&gt;|\n|\r)*&lt;/BODY&gt;'],
['bombSuspiciousRe','Suspicious Expression for Scoring Only*',80,\&textinput,'','(.*)','ConfigCompileRe','Sender, Header and Data will be checked for scoring only. Put here anything which might be suspicious. bombSuspiciousValencePB will be used to increase the score. For example:<br />unsubscribe'],
['bombSuspiciousValencePB','Matching Suspicious Expression Score, default=10',3,\&textinput,10,'(\d*)',undef, 'message scoring in PenaltyBox ( DoPenaltyMessage )'],
['noBombScript','Don\'t Check Messages from these Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Don\'t detect spam bombs or scripts in messages from these addresses. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).'],
['DoTestRe','Do Test Regular Expression',0,\&checkbox,0,'([01]?)',undef,
  'If activated, each message is checked  against the Test Regular
  Expression below. This provides a way to test regex strings on live mail.'],
['testRe','Test Regular Expression*',80,\&textinput,'','(.*)','ConfigCompileRe',''],
['bombError','Spam Bomb Error',80,\&textinput,'554 5.7.1 Delivery not authorized, message refused -- .','(.*)',undef,
  'SMTP error message to reject spam bombs. For example: 554 5.7.1 Delivery not authorized, message refused -- send report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90'],
['bombErrorReason','Add Reason',0,\&checkbox,1,'(.*)',undef,
  'Add matching expression to Spam Bomb Error'],
['DoBlackRe','Use Black Regular Expression to Identify Spam Strictly','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each incoming message is checked  against the BlackRe to Identify Spams. No Optout. '],
['blackValencePB','Black Expression Match Score, default=20 ',3,\&textinput,20,'(\d*)',undef, 'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['DoBlackReBayesian','Use Black Regular Expression to Identify Spam during Bayesian Check ',0,\&checkbox,'','([01]?)',undef,
  'If activated, each message is checked  against the BlackRe Regular Expression during Bayesian Analysis. Matches will fail Bayesian check. This is a legacy feature. If set, <b>DoBlackRe</b> is disabled.'],
['blackRe','BlackRe - Regular Expression to Identify Spam Strictly* ',80,\&textinput,'\breplica watches\b|\bMegaDik\b|\bcock\b|\bpenis\b|\bpills\b|\bOriginal Viagra\b|\bbetter sex 
life\b|\baverage penis\b|\benlargement\b|\borgasm\b|\berections\b|\bViagra\b|\bbig 
dick\b|\bsperma\b|\bSexual\b|\bErectionsk\b|\bStamina\b|\bsildenafil\b|\bcitrate\b|\bErectile\b','(.*)','ConfigCompileRe',
  'If an incoming email matches this Perl regular expression it will be strictly considered spam . For example: \breplica watches\b|\bMegaDik\b|\bcock\b|\bpenis\b|\bpills\b|\bOriginal Viagra\b|\bbetter sex 
life\b|\baverage penis\b|\benlargement\b|\borgasm\b|\berections\b|\bViagra\b|\bbig 
dick\b|\bsperma\b|\bSexual\b|\bErectionsk\b|\bStamina\b|\bsildenafil\b|\bcitrate\b|\bErectile\b'],
['DoScriptRe','Use Regular Expression to Identify Mobile Scripts','0:disabled|1:block|2:monitor|3:score',\&listbox,0,'(\d*)',undef,
  'Each message is checked  against the Expression to Identify Mobile Scripts.'],
['scriptTestMode','Script Regex Testmode',0,\&checkbox,'','(.*)',undef,''],
['scriptValencePB','Script Expression Match Score, default=25',3,\&textinput,25,'(\d*)',undef, 'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['scriptRe','Regular Expression to Identify Mobile Scripts*',80,\&textinput,'','(.*)','ConfigCompileRe',
  'Spam emails may contain mobile scripting code, eg activex and java. You can use this feature to block those messages.<br />
  Leave this blank to disable the feature. For example:<br /> \&lt;applet|\&lt;embed|\&lt;iframe|\&lt;object|\&lt;script|onmouseover|javascript:'],
['scriptError','Script Error',80,\&textinput,'554 5.7.1 Your email contains html scripting code -- please resend as plain text.','(.*)',undef,
  'SMTP error message to reject scripts. For example: 554 5.7.1 Your email appears to be spam -- send an error report to mailto:postmaster@mydomain.tld or call +12.34.56.78.90
  <br /><hr /><div class="menuLevel1">Notes On Bomb Regex</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bombre.txt\',3);" />'],

[0,0,0,'heading','Bayesian Options <a href="http://www.asspsmtp.org/wiki/Bayesian_Options" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Bayesian Options" /></a>'],
['DoBayesian','Bayesian Check <a href="http://www.asspsmtp.org/wiki/General_ASSP_Questions#Theory_of_Operation"><img src="' . $wikiinfo . '" alt="Theory of Operation" /></a>','0:disabled|1:block|2:monitor|3:score',\&listbox,3,'(.*)',undef,
  'If activated, the message is checked  based on Bayesian factors in Spamdb. This needs a fully functional spamdb built by rebuildspamdb.pl. For starters it is best practice  to put this inactiv and built the spamdb collection with the help of DSNBL and URIBL.<br /> disabled = no action; block = block the message if testmode is not set; monitor = pretend its running (with logging), but don\'t actually block messages; score = don\'t block outright, add  score value for blocking based on overall For Message & IP scoring in PenaltyBox ( DoPenalty ). <hr />
  <div class="menuLevel1">Notes On Bayesian</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bayesian.txt\',3);" />'],
['baysTestMode','Bayesian Testmode',0,\&checkbox,1,'(.*)',undef,''],
['baysValencePB','Bayesian, default=39',3,\&textinput,39,'(\d*)',undef, 'For Message & IP scoring in PenaltyBox ( DoPenalty )'],
['noBayesian','Skip Bayesian Check*',60,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail from/to any of these addresses are ignored by Bayesian check, mails will not be stored in spam/notspam collection. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). Wildcards are supported (@domain.*)'],

['baysTestModeUserAddresses','Bayesian Testmode User Addresses*',80,\&textinput,'','(.*)','ConfigMakeSLRe','These users are in testmode ( mark subject only ) for bayesian spam, even with testmode off','Basic'],
['baysTestModeOverwrite','MessageScore will overwrite testmode if limit is reached ',0,\&checkbox,'1','([01]?)',undef,
  ''],

['baysConf','Bayesian Confidence Threshold (experimental, not recommended)',3,\&textinput,'','(.*)',undef,' Spam-Mails having a confidence below this threshold are passed in TestMode .
 Spam-Mails having a confidence above this threshold are blocked. Set this only above 0 if you are familiar with the bayesian statistics used in ASSP.
 Messages that are processed by the bayesian check get a spam-probability score and a confidence score. The confidence score in assp is a quality indicator. A confidence near 0 would mean the probability score is like a wild guess. A confidence score near 1 would mean that it\'s pretty sure that the bayesian analysis result is correct. The confidence threshold is an allowance to process a Bayesian Spam as-if in Bayesian TestMode, if the message\'s *confidence* score is lower than the confidence threshold.
 Set this level to a specfic value, let\'s say .001, then:<br />
 - messages with spam-probability higher than 0.6 and a confidence of less than .001 would come through as in Testmode<br />
 - messages with spam-probability higher than 0.6 and a confidence of more than .001 would be blocked<br />
 - messages with spam-probability less than 0.6 would pass<br />
 The 0.6 threshold can be set in <b>baysProbability</b>.
 Setting the confidence threshold to 0.001 will result (in our experience) in 1/3 passing in testmode because there is too much doubt about the correctness of the result of the bayesian check.
 <br /><span class="negative"> empty = disabled</span>.'],
['baysConfidenceHalfScore','Reduce Scoring for Low Confidence',0,\&checkbox,1,'(.*)',undef,
 'Spam-Mails having a confidence below the threshold half of the normal penalty score for bayesian hits.'],
['NoTagInTestmode','No Subject Tag in Testmode',0,\&checkbox,'','(.*)',undef,
  'In Bayesian TestMode "/Prepend Spam Subject/" is only added if the message is Spam and confidence is higher than Bayesian Confidence Threshold" .'],
['AddSpamProbHeader','Add Bayes Probability Header',0,\&checkbox,'','(.*)',undef,
 'Adds a line to the email header "X-Assp-Spam-Prob: 0.0123" Probability ranges from 0 to +1 where > 0.6 = spam.'],
['AddConfidenceHeader','Add Bayes Confidence Header',0,\&checkbox,'','(.*)',undef,
  'Adds a line to the email header "X-Assp-Bayes-Confidence: 0.0123".<br /><hr />
  <div class="menuLevel1">Notes On Bayesian</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/bayesian.txt\',3);" />'],
[0,0,0,'heading','Backscatter Detection'],

['DoBackSctr','Do DNS-Backscatter Detection','0:disabled|1:block|2:monitor|3:score|4:testmode',\&listbox,0,'(\d*)',undef,
  'If activated, the IP-address of each message recieved for null sender,bounced or postmaster will be checked against the list below.
   DNS base checks requires an installed <a href="http://search.cpan.org/search?query=Net::DNS" rel="external">Net::DNS</a> module in Perl.<br />
   For more information about backscatter detection please read <a href="http://www.backscatterer.org/?target=usage" rel="external">http://www.backscatterer.org/?target=usage</a>.'],
['backsctrValencePB','Backscatter Detection Score, default=10',3,\&textinput,10,'(\d*)',undef, 'message scoring in PenaltyBox ( DoPenaltyMessage )'],
['BackDNSInterval','Backscatter-DNS Cache Refresh Interval',4,\&textinput,7,'([\d\.]+)','configUpdateBDNSCR','IP\'s in cache will be removed after this interval in days. 0 will disable the cache. <input type="button" value=" Show Backscatter-DNS Cache" onclick="javascript:popFileEditor(\'pb/pbdb.back.db\',5);" />'],
['BackSctrServiceProvider','ServiceProvider for Backscatterer Detection*',60,\&textinput,'ips.backscatterer.org','(.*)','configUpdateBACKSctrSP',
  'ServiceProvider for DNS check on Backscatterer. Possible value is ips.backscatterer.org.'],
['Back250OKISP','Send 250 OK to ISP if Backscatter Detection failes',0,\&checkbox,'0','(.*)',undef,'If Backscatter check failes for a bounced mail that is coming from an ISPIP, ASSP will send "250 OK" to the ISP, but will discard the mail, if the check is configured to block!'],
['BackWL','Do Backscatter Detection checks for Whitelisted mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!'],
['BackNP','Do Backscatter Detection checks for No Processing mail',0,\&checkbox,'','(.*)',undef,'Tagging will be always done, if not excluded by address or domain!'],
['noBackSctrAddresses','Do not any Backscatter detection for these addresses * ',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to and from any of these addresses will not be tagged and checked by any backscatter option. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).'],
['noBackSctrIP','Exclude these IP\'s from any Backscatter detection*',80,\&textinput,'','(\S*)','ConfigMakeIPRe','Enter IP\'s that you want to exclude from Backscatter check, separated by pipes (|). <br />
  <hr /><div class="menuLevel1">Notes On Backscatter Detection</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/backscatter.txt\',3);" />',undef,'7'],



[0,0,0,'heading','Email Interface <a href="http://www.asspsmtp.org/wiki/Email_Interface" target=wiki><img height=12 width=12 src="' . $wikiinfo . '" alt="Email Interface" /></a>'],
['EmailInterfaceOk','Enable Email Interface',0,\&checkbox,1,'(.*)',undef,
  'Checked means that you want ASSP to intercept and parse mail to the following usernames. The interface accepts only mail addressed to addresses at any of your localdomains, and only from "Accept All Mail" hosts, or authenticated SMTP connections.<br />
If you are using RelayHost and RelayPort see <a href="http://www.asspsmtp.org/wiki/Problems_and_Solutions" rel="external">How do I use the email interface with Exchange, Notes, or a RelayHost / RelayPort setup?</a>.<hr />
  <div class="menuLevel1">Notes On Email Interface</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/emailinterface.txt\',3);" />'],
['EmailAdminReportsTo','Admin Mail Address',40,\&textinput,'','(.*@.*)?',undef,
  'If set internal warnings/infos  will be sent to this address. For example: admin@example.com'],
['EmailHelp','Help Address<a href="http://www.asspsmtp.org/wiki/Getting_Started#Instructions_for_use_for_your_end_users." target="ASSPHELP"><img src="' . $wikiinfo . '" alt="doku" /></a>',20,\&textinput,'assphelp','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request for help. Do not put the full address here, just the user part. For example: assphelp
  <input type="button" value=" Edit helpreport.txt file" onclick="javascript:popFileEditor(\'reports/helpreport.txt\',2);" />'],


['EmailSpam','Report Spam Address',20,\&textinput,'asspspam','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a spam report. Multiple attachments get truncated to <b>ErrorMaxBytes</b>. Do not put the full address here, just the user part. For example: asspspam
  <input type="button" value=" Edit spamreport.txt file" onclick="javascript:popFileEditor(\'reports/spamreport.txt\',2);" />','Basic'],
['EmailHam','Report Ham (Not-Spam) Address',20,\&textinput,'asspnotspam','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a false-positive report. Multiple attachments get truncated to <b>MaxBytesReports</b>. Do not put the full address here, just the user part.<br />
  For example: asspnotspam
  <input type="button" value=" Edit notspamreport.txt file" onclick="javascript:popFileEditor(\'reports/notspamreport.txt\',2);" />','Basic'],
['EmailErrorsReply','Reply to Spam/Not-Spam Reports','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailErrorsTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,  ''],
['EmailErrorsTo','Send Copy of Spam/Ham-Reports TO',40,\&textinput,'','(.*@.*)?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@example.com<br />'],

['EmailErrorsModifyWhite','Combined Spam/Ham Report &amp; Whitelist Add/Remove',0,\&checkbox,'','(.*)',undef,
  'If set Ham Reports will additionally add addresses to the Whitelist, Spam Reports will additionally remove addresses from the Whitelist. ','Basic'],
['EmailWhitelistAdd','Add to Whitelist Address',20,\&textinput,'asspwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the whitelist. Do not put the full address here, just the user part. <br />For example: asspwhite
  <input type="button" value=" Edit whitereport.txt file" onclick="javascript:popFileEditor(\'reports/whitereport.txt\',2);" />','Basic'],
['EmailWhitelistRemove','Remove from Whitelist Address',20,\&textinput,'asspnotwhite','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the whitelist. Do not put the full address here, just the user part. <br />For example: asspnotwhite
  <input type="button" value=" Edit whiteremovereport.txt file" onclick="javascript:popFileEditor(\'reports/whiteremovereport.txt\',2);" />','Basic'],
['EmailWhitelistReply','Reply to Add to/Remove from Whitelist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailWhitelistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  ''],
['EmailWhitelistTo','Send Copy of Whitelist-Reports TO',40,\&textinput,'','(.*@.*)?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@example.com'],
['EmailRedlistAdd','Add to Redlist Address',20,\&textinput,'asspred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to add addresses to the redlist. Do not put the full address here, just the user part. <br />For example: asspred.
  <input type="button" value=" Edit redreport.txt file" onclick="javascript:popFileEditor(\'reports/redreport.txt\',2);" />'],
['EmailRedlistRemove','Remove from Redlist Address',20,\&textinput,'asspnotred','(.*)@?',undef,
  'Any mail sent by local/authenticated users to this username will be interpreted as a request to remove addresses from the redlist.<br />
  Do not put the full address here, just the user part. <br />For example: asspnotred
  <input type="button" value=" Edit redremovereport.txt file" onclick="javascript:popFileEditor(\'reports/redremovereport.txt\',2);" />'],
['EmailRedlistReply','Reply to Add to/Remove from Redlist','0:NO REPLY|1:REPLY TO SENDER|2:REPLY TO EmailRedlistTo|3:REPLY TO BOTH',\&listbox,1,'(\d*)',undef,
  ''],
['EmailRedlistTo','Send Copy of Redlist-Reports-Reports TO',40,\&textinput,'','(.*@.*)?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent to this address. For example: admin@example.com'],
['EmailAnalyze','Request Analyze Report',20,\&textinput,'asspanalyze','(.*)@?',undef,
  'Any mail sent or forwarded by local/authenticated users to this username will be interpreted as a request for analyzing the mail. Do not put the full address here, just the user part. For example: asspanalyze <input type="button" value=" Edit analyzereport.txt file" onclick="javascript:popFileEditor(\'reports/analyzereport.txt\',2);" />','Basic'],
['EmailAnalyzeReply','Reply to Analyze Request','0:NO REPLY|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,1,'(\d*)',undef,''],
['EmailAnalyzeTo','Send Copy of Analyze-Reports',40,\&textinput,'','(.*@.*)?',undef,
  'A copy of the Analyze-Report will be sent to this address. For example: admin@example.com'],
['DoAdditionalAnalyze','Spam and Ham Reports will trigger an additional Analyze Report ','0:NO ADDITIONAL REPORT|1:SEND TO SENDER|2:SEND TO EmailAnalyzeTo|3:SEND TO BOTH',\&listbox,0,'(.*)',undef,
  'Additional Analyze Report will be generated for Spam and Ham Reports. Setting the TO Address accordingly and choosing <b>EmailAnalyzeTo</b> will send the Analyze Report to the admin only.'],
['EmailFrom','From Address for Reports',40,\&textinput,'<spammaster@yourdomain.com>','(.*@.*)?',undef,
  'Email sent from ASSP acknowledging your submissions will be sent from this address.'],
['EmailAllowEqual','Allow \'=\' in Addresses',0,\&checkbox,'1','(.*)',undef,
  'Allow \'=\' in addresses to be whitelisted or redlisted.'],
['EmailSenderOK','Accept Emails (Reports) from these external addresses*',40,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Allow these external domains/addresses to report to the email
interface (NOT RECOMMENDED). The reply address for the reports must be set to a local one.  By default, ASSP only accepts reports from local or authenticated users. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com)'],
['NoHaiku','Legacy: Don\'t reply to messages to the Email Interface',0,\&checkbox,'','(.*)',undef,
  'Check this option to suppress all email reports<br /><hr />
  <div class="menuLevel1">Notes On Email Interface</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/emailinterface.txt\',3);" />'],


[0,0,0,'heading','File Paths'],
['base','Directory Base',40,\&textinput,'.','',undef,'All paths are relative to this folder.<br />
  <b>Note: this must be changed as a command line parameter and is displayed here for reference only.</b>'],
['spamlog','Spam Collection',40,\&textinput,'spam','(\S+)',undef,'The folder to save the collection of spam emails. This directory will be used in building the spamdb. For example: spam'],
['notspamlog','Not-spam Collection',40,\&textinput,'notspam','(\S+)',undef,'The folder to save the collection of not-spam emails. This directory will be used in building the spamdb. For example: notspam'],
['incomingOkMail','OK Mail',40,\&textinput,'okmail','(.*)',undef,'The folder to save non-spam (message ok). These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. If you want to keep copies of ok mail then put in a directory name. This directory will not be used in building the spamdb. Default: okmail'],
['viruslog','Attachment/Virus Collection',40,\&textinput,'quarantine','(.*)',undef,
  'The folder to save rejected attachments and virii. Leave this blank to not save these files (default). If you want to keep copies of rejected content then put in a directory name. Note: you must create the directory. This directory will not be used in building the spamdb. For example: quarantine'],
['correctedspam','False-negative Collection',40,\&textinput,'errors/spam','(\S+)',undef,
  'Spam that got through -- counts double. This directory will be used in building the spamdb. For example: errors/spam'],
['correctednotspam','False-positive Collection',40,\&textinput,'errors/notspam','(\S+)',undef,
  'Good mail that was listed as spam, count 4x. This directory will be used in building the spamdb. For example: errors/notspam'],
['maillogExt','Extension for Mail Files',20,\&textinput,'.eml','(\S*)',undef,
  'Enter the file extension (include the period) you want appended to the mail files in the mail collections.<br />
  Leave it blank for no extension. For Example: .eml'],
['spamdb','Spam Bayesian Database File',40,\&textinput,'spamdb','(\S+)',undef,'The output file from rebuildspamdb.pl. <hr /><div class="menuLevel1">Last Run Rebuildspamdb</div><input type="button" value="Last Run Rebuildspamdb" onclick="javascript:popFileEditor(\'rebuildrun.txt\',5);" />'],
['whitelistdb','E<!--get rid of google autofill-->mail Whitelist Database File',40,\&textinput,'whitelist','(\S+)',undef,'The file with the whitelist.<br />
  Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['redlistdb','E<!--get rid of google autofill-->mail Redlist Database File',40,\&textinput,'redlist','(\S+)',undef,'The file with the redlist.<br />
  Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['griplist','GReyIPlist Database',40,\&textinput,'griplist','(\S*)',undef,'The file with the current GRey-IP-List  database -- make this blank if you don\'t use it.'],
['ldaplistdb','LDAP Database',40,\&textinput,'ldaplist','(\S*)',undef,'The file with the LDAP-cache database, see also LDAPcrossCheckInterval.'],
['delaydb','Delaying Database',40,\&textinput,'delaydb','(\S*)',undef,'The file with the delay database.<br />Write "mysql" to use a MySQL table instead of a local file, in this case you need to edit MySQL parameters below.'],
['myhost','MySQL hostname or IP',40,\&textinput,'','(\S*)',undef,
  'You need <a
  href="http://search.cpan.org/~lds/Tie-DBI-1.02/lib/Tie/RDBM.pm"
  rel="external">Tie::RDBM</a> to use MySQL instead of local files.<br />
  This way you can share whitelistdb, delaydb and redlistdb between servers. subject to the condition that "mysql" is written into the file-path.'],
['mydb','MySQL database name',40,\&textinput,'','(\S*)',undef,
  'This database must exist before starting ASSP,
  necessary tables will be created automatically into this database'],

['myuser','MySQL username',40,\&textinput,'','(\S*)',undef,
  'This user must have CREATE privilege on the configured database in order for tables to be created automatically'],
['mypassword','MySQL password',40,\&textinput,'','(\S*)',undef,''],

['logfile','ASSP Logfile',40,\&textinput,'logs/maillog.txt','(\S*)','ConfigChangeLogfile',
  'Blank if you don\'t want a log file. Change it to maillog.log if you don\'t want auto rollover.
  NOTE: Changing this field requires restarting ASSP before changes take effect.'],
['pidfile','PID File',40,\&textinput,'pid','(\S*)',undef,'Blank to skip writing a pid file. *nix users need pid files.
  Leave it blank in Windows.<br /> You have to restart the service before you get a pid file in the new location.<br /><hr /><div class="menuLevel1">Notes On File Path</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/filepath.txt\',3);" />'],
[0,0,0,'heading','Collecting'],


['spamaddresses','Spam Collect Addresses* ',80,\&textinput,'','(.*)','ConfigMakeSLRe',
  'Mail to any of these addresses are always spam and will contribute to the spam-collection unless from someone on the whitelist. Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com). The addresses are not validated, they  are readdressed to sendAllSpam, however you can supersede this by putting a valid address into sendAllCollect below.'],
['saValencePB','Spam Collect Address Score, default=25',3,\&textinput,25,'(\d*)',undef, 'For IP scoring in PenaltyBox ( DoPenalty )'],
['sendAllCollect','Catchall Address for Collect Addresses',20,\&textinput,'','(.*)',undef,
  'ASSP will readdress messages addressed to Collect Addresses to this address.<br />
  For example: collect@example.com'],
['DoNotBlockCollect','Use Collect Addresses for Testing Your Environment',0,\&checkbox,'','(.*)',undef,
  'If set ASSP will block messages from Collect Addresses <b>after</b> other checks are performed. That may help to test and control activated filters.'],
['noCollecting','Do Not Collect Messages from/to these Addresses*',60,\&textinput,'','(.*)','ConfigMakeSLRe','Accepts specific addresses (user@example.com), user parts (user) or entire domains (@example.com).'],
['UseSubjectsAsMaillogNames','Use Subject as Maillog Names',0,\&checkbox,'','(.*)',undef,
  'You can turn this on to help you manually identify mail in your spam and non-spam collections. This will prevent ASSP from controlling the number of files in your collections(->MAXFILES). If your collections grow  over 1000 items run <b>move2num.pl</b> and turn this off. Leaving this setting turned off is HIGHLY recommended. The spam and 
non-spam collections are only intended for use by ASSP to build the 
bayesian database and NOT AS A MAIL ARCHIVE.  See the sendAllSpam and 
other options in the Copy Spam & Ham section for mail archiving options.'],
['DoNotCollectRedRe','Do Not Collect RedRe Matching Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails (Spam/Ham) matching Red Regex will not be stored in the collection folders.'],
['DoNotCollectRedList','Do Not Collect Redlisted Mails',0,\&checkbox,'','(.*)',undef,
  'Mails (Spam/Ham) matching  Redlist will not be stored in the collection folders.'],
['DoNotCollectBounces','Do Not Collect Bounced Mails',0,\&checkbox,1,'(.*)',undef,
  'Mails matching &lt;Bounce Senders&gt; will not be collected.'],
['NoMaillog','Don\'t Collect Mail',0,\&checkbox,'','(.*)',undef,
  'Check this if you\'re using Whitelist-Only and don\'t care to save mail to build the Bayesian database.'],

['MaxFiles','Max Files',10,\&textinput,14000,'(\d+)',undef,
  'If you\'re not using subjects as file names, this is the maximum
  number of files to keep in each collection (spam &amp; nonspam)<br />
  It\'s actually less than this -- files get a random number between 1 and $MaxFiles.'],
['FilesDistribution','Files Distribution',4,\&textinput,1,'(0\.\d?[1-9]+|1)',undef,
  'This defines how file names are chosen in each collection. If set to 1, names are uniformly distributed. If set between 0.01 and 0.99, names distribution is exponential -- files get lower numbers more frequently. This prevents from corpus being refreshed too quickly, especially when MaxFiles is set to low value.<br />
 Recommended: 0.5, Default: 1'],
['MaxBytes','Max Bytes',10,\&textinput,8000,'(\d+)',undef,
  'How many bytes of the message will ASSP look at? Mails stored in the collecting folders will be truncated to this size. The average of Ham messages is 8K, the average of Spam messages is 4K. Usually the spam folder will be filled quicker than the notspam folder, therefore set this value to 8000 to get more wordpairs per Ham Message. When both folders are close to the maxfiles limit, reduce it to 4000.'],
['MaxBytesReports','Error Max Bytes',10,\&textinput,10000,'(\d+)',undef,'How many bytes of an error report message will ASSP look at. For example: 10000.'],

['wlAttachLog','Whitelisted rejected Attachments','0:no collection|5:attachment folder|6:discard|7:discard &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,
  'Where to store whitelisted rejected mail+attachments. Recommended: discard &amp; sendAllSpam <br />'],
['npAttachLog','NoProcessing rejected Attachments','0:no collection|5:attachment folder|6:discard|7:discard &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store noprocessing rejected mail+attachments. Recommended: discard &amp; sendAllSpam'],
['extAttachLog','External rejected Attachments','0:no collection|5:attachment folder|6:discard|7:discard &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store external rejected mail+attachments. Recommended: discard &amp; sendAllSpam'],
['SpamVirusLog','Virus Infected','0=no collection|5:quarantine|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store virus infected messages. Recommended: discard '],
['spamBombLog','Spam Bombs','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store spam bombs. Recommended: discard'],
['DoNotCollectBombs','Discard Spam Bombs detected during scoring modus',0,\&checkbox,'1','(.*)',undef,''],
['scriptLog','Scripts','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store scripted messages. Recommended: spamfolder &amp; sendAllSpam'],
['baysNonSpamLog','OK Mail','0:no collection|2:notspam folder|4:okmail folder|6:discard',\&listbox,6 ,'(\d*)',undef,'Where to store non spam (message ok) messages. These are messages which are considered as HAM, but are not stored in the standard HAM folder because of our policy to use only confirmed HAM messages (whitelisted or local) for SpamDB. Recommended: discard'],
['NonSpamLog','Non Spam','0:no collection|2:notspam folder|6:discard',\&listbox,2,'(\d*)',undef,'Where to store whitelisted/local  non spam messages. Recommended: notspam.'],
['blDomainLog','Blacklisted Domains','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store blacklisted domain messages. Recommended: spamfolder &amp; sendAllSpam'],
['spamHeloLog','Blacklisted Helos','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store spam helo messages. Recommended: discard.'],
['forgedHeloLog','Forged Helos','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store forged helo messages. Recommended: discard '],
['invalidHeloLog','Invalid Helos','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store invalid helo messages. Recommended: discard '],
['spamBucketLog','Spam Collect Addresses','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,1,'(\d*)',undef,'Where to store emails addressed to Spam Collect Addresses. Recommended: spamfolder'],
['baysSpamLog','Bayesian Spams','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Bayesian spam messages. Recommended: spamfolder &amp; sendAllSpam'],
['SPFFailLog','SPF Failures','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SPF Failure spam messages. Recommended: spamfolder &amp; sendAllSpam'],
['RBLFailLog','DNSBL Failures','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store DNSBL Failure spam messages. Recommended: spamfolder &amp; sendAllSpam'],
['URIBLFailLog','URIBL Failures','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store URIBL Failure spam messages. Recommended: spamfolder &amp; sendAllSpam'],
['SRSFailLog','SRS Failures','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store SRS Failure (not signed bounces) spam messages. Recommended: spamfolder &amp; sendAllSpam'],
['spamPTRLog','Missing/Invalid Pointer ','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing/Invalid Pointer rejected messages. Recommended: spamfolder &amp; sendAllSpam'],
['spamMXALog','Missing MX Record ','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Missing MX record rejected messages. Recommended: spamfolder &amp; sendAllSpam'],
['spamISLog','Invalid Local Sender','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store messages from a local domain with an unknown userpart. Recommended: discard'],
['spamSBLog','Blocked Country','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,7,'(\d*)',undef,'Where to store messages from a blocked country. Recommended: discard'],
['spamMSLog','Message Limit Blocks','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,3,'(\d*)',undef,'Where to store Message Scoring Limit rejected messages. Recommended: spamfolder &amp; sendAllSpam'],
['spamPBLog','PenaltyBox Blocks','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store PB rejected messages. Recommended: discard'],
['BackLog','Backscatter check failed','0:no collection|1:spam folder|3:spamfolder &amp; sendAllSpam|6:discard|7:discard &amp; sendAllSpam',\&listbox,6,'(\d*)',undef,'Where to store backscatter rejected messages. Recommended: discard'],
['freqNonSpam','Non Spam Collection Frequency',5,\&textinput,1,'(\d*)',\&updateLog2,'Store every n\'th non spam message. If you set the value to 10 then every 10th message is logged. These frequency settings are for ASSP users with a mature installation who experience heavy mail or spam volumes. Enter a larger value if the non spam corpus is being refreshed too quickly. Default Value = 1, log every message.'],
['freqSpam','Spam Collection Frequency',5,\&textinput,1,'(\d*)',\&updateLog3,'Store every n\'th spam message. The same as for non spam but helps prevent spam corpuses being skewed by flooding. It is recommended that this be set depending on spam volume. Default value = 1, log every message.<br /><hr /><div class="menuLevel1">Notes On Collecting</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/collecting.txt\',3);" />'],

[0,0,0,'heading','Logging'],
['fileLogging','File name logging',0,\&checkbox,'','(.*)',undef,'Show file names of collected spam/notspam in log '],
['subjectLogging','Subject logging',0,\&checkbox,'','(.*)',undef,'Show subject of mail in log '],
['regexLogging','Regex Match logging',0,\&checkbox,1,'(.*)',undef,'Show matching regex in log, note that all lists (like eg. noprocessing-list) are used as regex. '],
['ipmatchLogging','IP Matches Logging',0,\&checkbox,'','(.*)',undef,
  'Enables logging of IP addresses matches in the maillog. Will show a comment instead of the range if there is text after the IP ranges (and before any numbersign)  eg. 182.82.10.0/24 AOL',undef],
['slmatchLogging','Logging Address Matches',0,\&checkbox,'','(.*)',undef,
  'Enables logging of address matches in the maillog.',undef],
['AddRegexHeader','Add  RegEx Match Header',0,\&checkbox,'','(.*)',undef,''],
['uniqeIDLogging','Unique ID logging',0,\&checkbox,'','(.*)',undef,'Add unique string to log  '],
['uniqueIDPrefix','Prepend Unique ID logging',10,\&textinput,'','(.*)',undef,
  'Prepend ID. For example: m1-'],

['tagLogging','Spam Tag Logging',0,\&checkbox,1,'(.*)',undef,'Add spam tag to log.'],
['ExceptionLogging','Module Call Timeout Exception Logging',0,\&checkbox,'','(.*)',undef,''],

['replyLogging','SMTP Status Code Reply Logging',0,\&checkbox,'','(.*)',undef,''],
['expandedLogging','Logging Records include IP & MailFrom',0,\&checkbox,1,'(.*)',undef,''],

['sysLog','SYSLOG Centralized Logging',0,\&checkbox,'','(.*)',undef,'Enables logging to UNIX Syslog. Needs Sys::Syslog for local (UNIX/LINUX) logging or Net::Syslog for Windows or Network logging.'],
['sysLogPort','Syslog Port (UDP)',5,\&textinput,'514','([\d\.]+)',undef,
  'Port for Syslog logging with Net::Syslog.'],
['SysLogFac','Syslog Facility',40,\&textinput,'mail','(\S*)',undef,
  'Syslog Facility. Valid are kern, user, mail, daemon, auth, syslog, lpr, news, uucp, cron, authpriv, ftp, local0, local1, local2, local3, local4, local5, local6'],
['sysLogIp','Syslog IP',40,\&textinput,'127.0.0.1','(\S*)',undef,
  'IP Address of your Syslog Daemon for Syslog logging with Net::Syslog.'],
['asspLog','ASSP local logging',0,\&checkbox,'1','(.*)',undef,'ASSP manages local logging. The logs <a href="./#logfile">are stored</a> inside the directory where ASSP is installed.'],
['LogRollDays','Roll the Logfile How Often?',5,\&textinput,'7','([\d\.]+)',undef,
  'ASSP closes and renames the log file after this number of days.'],
['LogNameMMDD','No Year in LogName',0,\&checkbox,'','(.*)',undef,'The standard name for the logfile is YY-MM-DD.maillog.txt, use this option to set it to MM-DD.maillog.txt'],
['silent','Silent Mode',0,\&checkbox,'','(.*)',undef,
  'Checked means don\'t print log messages to the console. AsADaemon overrides this.'],
['DEBUG','Debug Mode',0,\&checkbox,'','(.*)',\&ConfigDEBUG,
  'Checked sends debugging info to a .dbg file.
  Leave this unchecked unless there is a program error you are trying to track down.'],

['ConTimeOutDebug','Connection Timeout Debug Mode',0,\&checkbox,'','(.*)',undef,'Select to debug SMTP connections that are running in to timeout!'],
['noLog','Don\'t Log these IPs*',40,\&textinput,'','(\S*)','ConfigMakeIPRe',
  'Enter IP addresses that you don\'t want to be logged, separated by pipes (|).<br />
  This can be IP address of the SMTP service monitoring agent. For example:  <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>','','7'],
['noLogRe', 'Regular Expression to Identify NoLog-Messages*',80,\&textinput,'','(.*)','ConfigCompileRe',
 "Put anything here to identify messages that you don\'t want to be logged."],
['ConnectionLog','Connections Logging','0:nolog|1:standard|2:verbose',\&listbox,0,'(.*)',undef,
  ''],
['SessionLog','Session Limit Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['denySMTPLog','Enables Logging for \'Deny SMTP Connections From\'','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,''],
['RWLLog','Enable RWL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['VRFYLog','Enable VRFY logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['LDAPLog','Enable LDAP logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['ValidateUserLog','Enable User Validation logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['PenaltyLog','Enable PenaltyBox logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  ''],
['PenaltyExtremeLog','Enable PenaltyBox Extreme logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(\d*)',undef,
  ''],
['MessageLog','Enable Message Scoring logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],

['BacksctrLog','Enable DNS-Backscatter detection logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['ValidateSenderLog','Enable Validate Sender Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['SenderBaseLog','Enable SenderBase Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['DelayLog','Enable Greylisting/Delaying logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['AttachmentLog','Enable Attachment logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['SPFLog','Enable SPF logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['RBLLog','Enable DNSBL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['URIBLLog','Enable URIBL logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['ScanLog','Enable ClamAV logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['BayesianLog','Enable Bayesian Logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  'Enables verbose logging of  Bayesian checks in the maillog.'],
['MaintenanceLog','Enable Maintenance logging','0:nolog|1:standard|2:verbose',\&listbox,1,'(.*)',undef,
  ''],
['Showmaxreplies','Show All Possible Hits ',0,\&checkbox,'','(.*)',undef,
  'Show all hits instead of stopping at maxhits (RBL,URIBL,RWL).'],
['RegExLength','RegEx Length in Log',2,\&textinput,32,'(\d*)',undef,
  'Defines how many bytes of a matching Regular Expression will be shown in the log<br />
  Some matching Regular Expressions are too long for one line. Default: 32'],
['sendNoopInfo','Send NOOP Info',0,\&checkbox,'','(.*)',undef,
  'Checked means you want ASSP to send a "NOOP Connection from $ip" message to your SMTP server.
  <br /><hr />
  <div class="menuLevel1">Notes On Logging</div>
  <input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/logging.txt\',3);" />'],

[0,0,0,'heading','LDAP Setup <a href="http://www.asspsmtp.org/wiki/LDAP" target="wiki"><img height=12 width=12 src="' . $wikiinfo . '" alt="wiki" /></a>'],
['LDAPHost','LDAP Host(s)',80,\&textinput,'localhost','(\S*)','updateLDAPHost','Enter the DNS-name(s) or IP address(es) of the server(s) that run(s) the <a href="http://ldap.perl.org/FAQ.html">LDAP</a> database. Second entry is backup. For example: localhost. Separate entries with pipes: LDAP-1.domain.com|LDAP-2.domain.com' ],
['LDAPtimeout','LDAP Query Timeout',2,\&textinput,15,'(\d+)',undef,'Timeout when connecting to the remote server. The default is 15 seconds.'],
['LDAPLogin','LDAP Login',80,\&textinput,'','(.*)',undef,'Most LDAP servers require a login and password before they allow queries.<br />Enter the DN specification for a user with sufficient permissions here.<br />For example: cn=Administrator,cn=Users,DC=yourcompany,DC=com'],
['LDAPPassword','LDAP Password',20,\&textinput,'','(.*)',undef,'Enter the password for the specified LDAP login here.'],
['LDAPVersion','LDAP Version',2,\&textinput,3,'[23]',undef,'Enter the version for the specified LDAP here.'],
['LDAPRoot','LDAP Root container',80,\&textinput,'','(.*)',undef,'The LDAP lookup will use this container and all sub-containers to match the query.<br />The literal DOMAIN is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: DC=yourcompany,DC=com.<br />If you use DOMAIN here, you must check "LDAP failures return false" below or non local domains will be treated as local'],
['ldLDAPFilter','LDAP Filter for Local Domains',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />The filter must return an entry if the domain must be relayed.<br />The literal DOMAIN (case sensitive) will be replaced by the domain name during the search.<br />'],
['LDAPFilter','LDAP Filter for Local Addresses',80,\&textinput,'','(\S*)',undef,'This filter is used to query the LDAP database. This strongly depends on the LDAP structure.<br />The filter must return an entry if the recipient address matches with that of any user.<br />The literal EMAILADDRESS is replaced by the fully qualified SMTP recipient (eg. user@example.com) during the search.<br />The literal USERNAME (case sensitive) is replaced by the user part of SMTP recipient (eg. user) during the search.<br />The literal DOMAIN (case sensitive) is replaced by the domain part of SMTP recipient (eg. domain.com) during the search.<br />For example: (proxyaddresses=smtp:EMAILADDRESS)'],
['LDAPcrossCheckInterval','Clean Up local LDAP Database',10,\&textinput,24,'(\d+)',undef,
  'Delete outdated entries from the LDAP cache. Crosscheck LDAP cache to LDAP server and delete not existing entries.<br />
  Note: the current timeout must expire before the new setting is loaded, or you can restart.
  Defaults to 24 hours. Is only used, if ldaplistdb is defined in the filepath section!'],

['MaxLDAPlistDays','Max LDAP cache Days',5,\&textinput,'90','(\d+)',undef,'This is the number of days an address will be kept on the local LDAP cache without any email to this address.'],
['LDAPFail','LDAP failures return false',20,\&checkbox,'','(.*)',undef,'If checked when an error occurs in LDAP lookups the test fails.<hr /><div class="menuLevel1">Notes On LDAP </div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/ldap.txt\',3);" />'],

[0,0,0,'heading','DNS Setup'],
['UseLocalDNS','Use System Default DNS (',0,\&checkbox,1,'(.*)',\&updateUseLocalDNS,'Use system default DNS Name Servers.'],
['DNSResponseLog','Show DNS Name Servers Response Time in Log',0,\&checkbox,'You can use this to arrange DNSServers for better performance. Put the fastest first.','(.*)',undef,''],
['DNSServers','DNS Name Servers',40,\&textinput,'208.67.222.222|208.67.220.220','(.*)',\&updateDNS,
 'DNS Name Servers IP\'s to use for DNSBL, RWL, URIBL, PTR, SPF2 lookups. ASSP will check regularly for timeouts and will move not responding servers to the end of the list - making it inactive. To get the most out of this put here as many mailservers as you want, mixing local, public & open and set UseLocalDNS (Use System Default DNS) to off <br /> For example: 208.67.222.222|208.67.220.220 (<a href="http://www.opendns.com/" rel="external">OpenDNS</a>).'],
['DNStimeout','DNS Query Timeout',2,\&textinput,5,'(\d+)',undef,'Global DNS Query Timeout for DNSBL, RWL, URIBL, PTR, SPF, MX and A record lookups. The default is 5 seconds.'],
['DNSretry','DNS Query Retry',2,\&textinput,1,'(\d+)',undef,'Global DNS Query Retry. Set the number of times to try the query. The default is 1.'],
['DNSretrans','DNS Query Retrans',2,\&textinput,3,'(\d+)',undef,'Global DNS Query Retransmission Interval. Set the retransmission interval. The default is 3.<br /><hr />
  <div class="menuLevel1">Notes On DNS Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/DNSsetup.txt\',3);" />'],

[0,0,0,'heading','Server Setup'],
['AsAService','Run ASSP as a Windows Service',0,\&checkbox,'','(.*)',undef,'In Windows NT/2000/XP/2003 ASSP can be installed as a service. This setting tells ASSP that this has been done -- it does not install the Windows service for you. Installing ASSP as a service requires several steps which are detailed in the <a href="http://www.asspsmtp.org/wiki/Quick_Start_for_Win32">Quick Start for Win32</a> wiki page.<br /> <span class="negative"> requires ASSP restart</span>'],
['AsADaemon','Run ASSP as a Daemon',0,\&checkbox,'','(.*)',undef,'In Linux/BSD/Unix/OSX fork and close file handles. Similar to the command "perl assp.pl &amp;", but better.<br />
  <span class="negative"> requires ASSP restart</span>'],
['runAsUser','Run as UID',20,\&textinput,'','(\S*)',undef,'The *nix user name to assume after startup (*nix only).<p><small><i>Examples:</i> assp, nobody</small></p>
  <span class="negative"> requires ASSP restart</span>'],
['runAsGroup','Run as GID',20,\&textinput,'','(\S*)',undef,'The *nix group to assume after startup (*nix only).<p><small><i>Examples:</i> assp, nobody</small></p>
  <span class="negative"> requires ASSP restart</span>'],
['ChangeRoot','Change Root',40,\&textinput,'','(.*)',undef,'The new root directory to which ASSP should chroot (*nix only). If blank, no chroot jail will be used. Note: if you use this feature, be sure to copy or link the etc/protocols file in your chroot jail.<br />
  <span class="negative"> requires ASSP restart</span>'],
['AutoRestart','Automatic Restart after Exception',0,\&checkbox,'','(.*)',undef,'If ASSP detects a main exception and it runs not as service or daemon, it will try to restart it self automaticly!'],
['AutoRestartCmd','OS-shell command for AutoRestart',100,\&textinput,'','(.*)',undef,'The OS level shell-command that is used to autorestart ASSP, if it runs not as a service or daemon! A possible value for your system is:<br /><font color=blue>'.$dftrestartcmd.'</font><br />Leave this field blank, if ASSP runs inside an external loop (inside the OS like assp.sh or assp.cmd).'],
['RestartEvery','Restart Timeout',10,\&textinput,'0','(\d+)',undef,
  'ASSP will automatically terminate and restart after this many seconds. Use this setting to periodically reload configuration data, combat potential memory leaks, or perform shutdown/startup processes. This will only work properly if ASSP runs as a Windows service or in a script that restarts it after it stops.'],
['myName','My Name',40,\&textinput,'ASSP.nospam','(\S+)',undef,'ASSP will identify itself by this name in the email "Received:" header and in the helo when sending report-replies. Usually the fully qualified domain name of the host.<p><small><i>Examples:</i> assp.example.com, assp.nospam</small></p>'],

['asspCfgVersion','assp.cfg version',40,\&textnoinput,'','(.*)',undef,'ASSP will identify the assp.cfg file.'],
['proxyserver','Proxy Server',20,\&textinput,'','(\S*)',undef,'The Proxy Server to use when uploading global statistics and downloading the greylist.<p><small><i>Examples:</i> 192.168.0.1:8080, 192.168.0.1</small></p>'],
['OutgoingBufSizeNew','Size of TCP/IP Buffer',10,\&textinput,1024000,'(\d+)',undef,
 'If ASSP talks to the internet over a modem change this to 4096. The default is 1024000.'],
['webAdminPort','Web Admin Port',20,\&textinput,55555,'(\S+)','ConfigChangeAdminPort',
  'The port on which ASSP will listen for http connections to the web administration interface. If you change this, after you click Apply you must change the URL on your browser to reconnect. You may also supply an IP address to limit connections to a specific interface.<p><small><i>Examples:</i> 55555, 192.168.0.5:12345</small></p>'],
 # I hate hidden password input
['webAdminPassword','Web Admin Password',20,\&passinput,'nospam4me','(.{5,})','ConfigChangePassword',

  'The password for the web administration interface (minimum of 5 characters, maximum of 8 characters).'],

['allowAdminConnectionsFrom','Only Allow Admin Connections From*',80,\&textinput,'','(.*)','ConfigMakeIPRe',
  'An optional list of IP addresses from which you will accept web admin connections. Blank means accept connections from any IP address.<br /> <span class="negative">Note: if you make a mistake here, you may disable your web administration interface and be forced to manually edit your configuration file to fix it.</span><p><small><i>Examples:</i></small></p>
  <a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>','','7'],
['webStatPort','Raw Statistics Port',20,\&textinput,55553,'(\S+)','ConfigChangeStatPort',
  'The port on which ASSP will listen for http connections to the statistics interface. You may also supply an IP address to limit connections to a specific interface.<p><small><i>Examples:</i> 55553, 192.168.0.5:12345</small></p>'],
['allowStatConnectionsFrom','Only Allow Raw Statistics Connections From*',80,\&textinput,'127.0.0.1','(.*)','ConfigMakeIPRe',
  'An optional list of IP addresses from which you will accept raw statistical connections. Blank means accept connections from any IP address. <p><small><i>Examples:</i></small></p>
<a href="http://www.asspsmtp.org/wiki/Address-Range-Notation#Simple" target=Help>145.145.145.145|145.146.<img src="' . $wikiinfo . '" alt="wiki" /></a>','','7'],

['CleanCacheEvery','Cache Cleaning Interval',4,\&textinput,'2','(\d+)',undef,
  'This period (in hours) determines how frequently ASSP does cache-housekeeping.'],
['SaveStatsEvery','Statistics Save Interval',4,\&textinput,'0','(\d+)',undef,
  'This period (in minutes) determines how frequently ASSP statistics are written to a local file.'],
['totalizeSpamStats','Upload Consolidated Spam Statistics',0,\&checkbox,1,'(.*)',undef,
 'ASSP will upload its statistics to be consolidated with the <a href="http://www.asspsmtp.org/scripts/stats/" rel="external">global ASSP totals</a>. This is a great marketing tool for the ASSP project &mdash; please do not disable it unless you have a good reason to do so. No private information is being disclosed by this upload.'],

['OrderedTieHashTableSize','Ordered-Tie Hash Table Size',10,\&textinput,10000,'(\d+)',undef,
 'The number of entries allowed in the hash tables used by ASSP and rebuildspamdb.pl. Larger numbers require more more RAM but result in fewer disk hits. The default value is 10000. Adjust down to use less RAM.'],
['EnableHTTPCompression','Enable HTTP Compression in GUI',0,\&checkbox,1,'(.*)',undef,
  'Enable HTTP Compression for faster web administration interface loading. The perl module <a href="http://search.cpan.org/dist/Compress-Zlib/" rel="external">Compress::Zlib</a> is required to use this feature.'],
['hideAlphaIndex','Hide the Alpha Index Menu Panel in GUI',0,\&checkbox,1,'(.*)',undef,
  'Removes the alphanumeric index panel on the left side in the GUI, but the index is accessable by clicking on "sorted".'],
['EnableFloatingMenu','Enable Floating Menu Panel in GUI',0,\&checkbox,'','(.*)',undef,
  'Allow the menu panel on the web administration interface to float (floating Div code taken from <a href="http://www.javascript-fx.com" rel="external">www.javascript-fx.com</a>).'],

['EnableInternalNamesInDesc','Show Internal Names in the GUI',0,\&checkbox,1,'(.*)',undef,
  'Show the internal names in the web interface. The internal names are used in the configuration file (assp.cfg), in the application code, and in the menu bar on the left side of the GUI.'],
['MaillogTailJump','Jump to the End of the Maillog',0,\&checkbox,'','(.*)',undef,
  'Causes the browser window to jump to the bottom of the maillog instead of sitting at the top of the display.'],
['MaillogTailBytes','Maillog Tail Bytes',10,\&textinput,10000,'(\d+)',undef,
  'The number of bytes that will be shown when the end of the maillog is viewed. The default value is 10000.'],
['MaillogTailWrapColumn','Maillog Tail Wrap Column',5,\&textinput,80,'(\d+)',undef,
  'Force maillog lines to wrap at this column if there are too many characters in a line. The default is 80. Enter 0 to disable wrapping.'],
['ALARMtimeout','Module Call Timeout',5,\&textinput,10,'(\d+)',undef,'Global Timeout for calling other modules. The default is 10 seconds.'],
['UseLocalTime','Use Local Time',0,\&checkbox,1,'(.*)',undef,
  'Use local time and timezone offset rather than UTC time in the mail headers.<br /><hr />
  <div class="menuLevel1">Notes On Server Setup</div><input type="button" value="Notes" onclick="javascript:popFileEditor(\'notes/myserver.txt\',3);" />']


 );

    # allow override for default web admin port
    if ( $ARGV[1] =~ /^\d+$/ ) {
        foreach (@Config) {
            if ( $_->[0] eq 'webAdminPort' ) {
                $_->[4] = $ARGV[1];
                last;
              }
          }
      }

    # load configuration file
    our %Config;
    open( F, "<$base/assp.cfg" );
    local $/;
    (%Config) = split( /:=|\n/, <F> );
    close F;

    # set nonexistent settings to default values
    foreach my $c (@Config) {
        if ( $c->[0] && !( exists $Config{ $c->[0] } ) ) {
            $Config{ $c->[0] } = $c->[4];
          }
      }
    if (! exists $Config{globalRegisterURL} or $Config{globalRegisterURL} eq '') {
        $Config{globalRegisterURL} = 'gubpxne.qlaqaf.bet/nffc/hcybnq/ertvfgre.cuc';
    }
    if (! exists $Config{globalUploadURL} or $Config{globalUploadURL} eq '') {
        $Config{globalUploadURL} = 'gubpxne.qlaqaf.bet/nffc/hcybnq/hcybnq.cuc';
    }
    while ( my ( $k, $v ) = each %Config ) {
        my $defConfVar = "use vars qw\(\$" . $k . "\); push \@EXPORT,qw(\$" . $k . ");";
        eval($defConfVar);
      }
    use vars qw($hConfig);
    push @EXPORT, qw($hConfig);
    use vars qw($aConfig);
    push @EXPORT, qw($aConfig);
    $hConfig = \%Config;
    $aConfig = \@Config;
    push @EXPORT, qw($mydb $base $wikiinfo);
}    # end BEGIN
our %locals = ( '127', 1, '10', 1, '192.168', 1, '169.254', 1 );    #RFC 1918
    for ( 16 .. 31 ) { $locals{ "172.$_" } = 1 }                    #RFC 1918
our $starttime = localtime(time);
our %MakeIPRE  = (
    'ispip'                         => 'ISPRE',
    'allowAdminConnectionsFrom'     => 'ACFRE',
    'allowStatConnectionsFrom'      => 'SCFRE',
    'acceptAllMail'                 => 'AMRE',
    'noLog'                         => 'NLOGRE',
    'noDelay'                       => 'NDRE',
    'noSRS'                         => 'NSRSRE',
    'noHelo'                        => 'NHRE',
    'noRBL'                         => 'NRBLRE',
    'noRWL'                         => 'NRWLRE',
    'noPB'                          => 'NPBRE',
    'noMsgID'                       => 'NMIDRE',
    'noPBwhite'                     => 'NPBWRE',
    'whiteListedIPs'                => 'WLIPRE',
    'noProcessingIPs'               => 'NPIPRE',
    'exportExtremeBlack'            => 'EEFRE',
    'denySMTPConnectionsFrom'       => 'DSMTPCFRE',
    'denySMTPConnectionsFromAlways' => 'DSMTPCFARE',
    'allowProxyConnectionsFrom'     => 'APCRE',
    'noBackSctrIP'                  => 'NOBSIP'
);

our %MakeSLRE = (
    'EmailSenderOK'        => 'ESOKRE',
    'InternalAddresses'    => 'IARE',
    'LocalAddresses_Flat'  => 'LAFRE',
    'MSGIDsigAddresses'    => 'MSGARE',
    'SRSno'                => 'SRSNRE',
    'baysSpamHaters'       => 'BSHRE',
    'baysSpamLovers'       => 'BSLRE',
    'baysTestModeUserAddresses' => 'BSLTESTUSERRE',
    'blSpamLovers'         => 'BLSLRE',
    'bombSpamLovers'       => 'BOSLRE',
    'RejectTheseLocalAddresses' => 'BOUNCELOCALADDRRE',
    'ccHamFilter'          => 'CCARRE',
    'ccSpamAlways'         => 'CCARE',
    'ccSpamFilter'         => 'CCRE',
    'ccnHamFilter'         => 'CCARNRE',
    'ccnSpamFilter'        => 'CCNRE',
    'delaySpamLovers'      => 'DLSLRE',
    'hiSpamLovers'         => 'HISLRE',
    'hlSpamHaters'         => 'HLSHRE',
    'hlSpamLovers'         => 'HLSLRE',
    'isSpamLovers'         => 'ISSLRE',
    'mxaSpamLovers'        => 'MXASLRE',
    'noBackSctrAddresses'  => 'NBSARE',
    'noBayesian'           => 'NBRE',
    'noBombScript'         => 'NBSRE',
    'noCollecting'         => 'NCAREL',
    'noPenaltyMakeTraps'   => 'NTRRE',
    'noProcessing'         => 'NPREL',
    'noScan'               => 'NSRE',
    'noURIBL'              => 'NURIBLRE',
    'pbSpamLovers'         => 'PBSLRE',
    'processOnlyAddresses' => 'POARE',
    'ptrSpamLovers'        => 'PTRSLRE',
    'rblSpamHaters'        => 'RBLSHRE',
    'rblSpamLovers'        => 'RBLSLRE',
    'sbSpamLovers'         => 'SBSLRE',
    'spamHaters'           => 'SHRE',
    'spamLovers'           => 'SLRE',
    'spamaddresses'        => 'SARE',
    'spamtrapaddresses'    => 'STRE',
    'spfSpamLovers'        => 'SPFSLRE',
    'srsSpamLovers'        => 'SRSSLRE',
    'uriblSpamLovers'      => 'URIBLSLRE'
);

our $mypid         = $$;
our $localhostname = hostname();
our $localhostip;
if ($localhostname) {
    eval { $localhostip = inet_ntoa( scalar( gethostbyname($localhostname) ) ); };
  }
mlog(0,"error : unable to resolve IP-address for local hostname <$localhostname> - $@") if $@;

our $CanUseAvClamd         = eval("use File::Scan::ClamAV; 1");     # ClamAV module installed
our $CanUseLDAP            = eval("use Net::LDAP; 1");              # Net LDAP module installed
our $CanUseAddress         = eval("use Email::Valid; 1");           # Email Valid module installed
our $CanUseDNS             = eval("use Net::DNS; 1");               # Net DNS module installed - required for SPF & RBL
our $AvailSPF              = eval("use Mail::SPF::Query; 1");       # Mail SPF Query module installed
our $CanUseSPF             = $AvailSPF && $CanUseDNS;               # SPF Query and dependancies installed
our $AvailSPF2             = eval("use Mail::SPF; 1");              # Mail SPF module installed
our $CanUseSPF2            = $AvailSPF2 && $CanUseDNS;              # SPF and dependancies installed
our $CanUseURIBL           = $CanUseDNS;                            # URIBL and dependancies installed
our $CanUseRWL             = $CanUseDNS;                            # RWL and dependancies installed
our $CanUseRBL             = $CanUseDNS;                            # DNSBL and dependancies installed
our $AvailSRS              = eval("use Mail::SRS; 1");              # Mail SRS module installed
our $CanUseSRS             = $AvailSRS;
our $AvailZlib             = eval("use Compress::Zlib; 1");         # Zlib module installed
our $CanUseHTTPCompression = $AvailZlib;
our $AvailMD5              = eval("use Digest::MD5; 1");            # Digest MD5 module installed
our $CanUseMD5Keys         = $AvailMD5;
our $AvailSHA1             = eval("use Digest::SHA1 qw(sha1_hex); 1");   # Digest SHA1 module installed
our $CanUseSHA1            = $AvailSHA1;
our $AvailReadBackwards    = eval("use File::ReadBackwards; 1");    # ReadBackwards module installed;
our $CanSearchLogs         = $AvailReadBackwards;
our $AvailHiRes            = eval("use Time::HiRes; 1");            # Time::HiRes module installed;
our $CanStatCPU            = $AvailHiRes;
our $AvailIO               = eval("use PerlIO::scalar; 1");         # make it chroot savy;
our $CanChroot             = $AvailIO;
our $AvailSyslog       = eval("use Sys::Syslog qw( :DEFAULT setlogsock); 1");
our $AvailNetSyslog    = eval("use Net::Syslog; 1");                           # syslog for Windows and *nix
our $CanUseSyslog      = $AvailSyslog;
our $CanUseNetSyslog   = $AvailNetSyslog;
our $AvailWin32Daemon  = eval("use Win32::Daemon; 1");                         # Win32 Daemon module installed
our $AvailWin32Debug   = eval("use Win32::API::OutputDebugString qw(OutputDebugString DStr); 1");         # Win32 OutputDebugString available
our $AvailTieRDBM      = eval("use Tie::RDBM; 1");                             # Use external database
our $CanUseTieRDBM     = $AvailTieRDBM;
our $CanUseWin32Daemon = $AvailWin32Daemon;
our $AvailIPRegexp     = eval('use Net::IP::Match::Regexp; 1');                # Net::IP::Match::Regexp module installed
our $CanMatchCIDR      = $AvailIPRegexp;
our $AvailCIDRlite     = eval('use Net::CIDR::Lite; 1');                       # Net::CIDR::Lite module installed
our $CanUseCIDRlite    = $AvailCIDRlite;
our $AvailSenderBase   = eval('use Net::SenderBase; 1');                       # Net::SenderBase module installed
our $CanUseSenderBase  = $AvailSenderBase;
our $AvailLWP          = eval('use LWP::Simple; 1');                           # LWP::Simple module installed
our $CanUseLWP         = $AvailLWP;
our $AvailEMM          = eval('use Email::MIME::Modifier; 1');  # Email::MIME::Modifier module installed
our $CanUseEMM         = $AvailEMM;
our $AvailSysMemInfo   = eval('use Sys::MemInfo; 1');  # Sys::MemInfo module installed
our $CanUseSysMemInfo  = $AvailSysMemInfo;
our $AvailNetSMTP      = eval('use Net::SMTP; 1');  # Net::SMTP module installed
our $CanUseNetSMTP     = $AvailNetSMTP;


#use URI::_foreign;
if ($CanUseDNS) {

    # preload this modules for chroot
    use Net::DNS::RR;
    use Net::DNS::RR::PTR;
    use Net::DNS::RR::MX;
    use Net::DNS::RR::A;
    use Net::DNS::RR::TXT;
    use Net::DNS::RR::CNAME;
  }

# our global vars
# import ConfigVars from BEGIN section
our %Config      = %$hConfig;
our @ConfigArray = @$aConfig;

# from here sorted by $ % @ alpha
our $AVa;
our $AvailAvClamd;
our $baysProbability = 0.6;
our $BackDNSObject;
our $BLDRE1;
our $BLDRE2;
our $BSRE;
our $ConfigChanged;
our $Counter;
our $CountryCodeReRE;
our $NoCountryCodeReRE;
our $CountryCodeBlockedReRE;
our $DebugLog;
our $DelayObject;
our $DelayWhiteObject;
our $DnsblObject;
our $DoBombDataRe;
our $DomainCache;
our $ESOKRE;
our $EmailAdrRe;
our $EmailDomainRe;
our $EmailNoNPRemove;
our $FH;
our $GriplistObject;
our $HBIRE;
our $HeaderNameRe;
our $HeaderRe;
our $HeaderValueRe;
our $HeloBlackObject;
our $IPDWLDRE;
our $IPQuadRE;
our $IPQuadSectDotRE;
our $IPQuadSectRE;
our $IPprivate;
our $JavaScript;
our $LDAPObject;
our $LDRE;
our $LHNRE;
our $LOG;
our $MXACacheObject;
our $MyCountryCodeReRE;
our $NLOGRE;
our $NPDRE;
our $NavMenu;
our $NextGriplistDownload = time + ( ( int( rand(2) ) + 1 ) * 3600 ); 
our $NextSaveStats;
our $NoScanReRE;
our $PBBlackObject;
our $PBTrapObject;
our $PBWhiteObject;
our $PTRCacheObject;
our $RBLCacheObject;
our $RWLCacheObject;
our $RedlistObject;
our $Relay;
our $SBCacheObject;
our $SPFCacheObject;
our $SpamLoversReRE;
our $SpamProb;
our $SpamProbConfidence;
our $SpamdbObject;
our $StatSocket;
our $SuspiciousVirusRE;
our $TriedDBFileUse;
our $URIBLCCTLDSRE;
our $URIBLCacheObject;
our $URIBLWLDRE;
our $URICommonRe;
our $URIContinuationRe;
our $URIEncodedCharRe;
our $URIGenDelimsCharRe;
our $URIHostRe;
our $URIRe;
our $URIReservedCharRe;
our $URISubDelimsCharRe;
our $URIUnreservedCharRe;
our $UUENCODEDRe;
our $VerAvClamd;
our $VerCheckUser;
our $VerCIDR;
our $VerCIDRlite;
our $VerCompressZlib;
our $VerDigestMD5;
our $VerDigestSHA1;
our $VerEmailValid;
our $VerEMM;
our $VerNetSMTP;
our $VerFileReadBackwards;
our $VerLWP;
our $VerMailSPF2;
our $VerMailSPF;
our $VerMailSRS;
our $VerNetDNS;
our $VerNetLDAP;
our $VerNetSyslog;
our $VerRDBM;
our $VerSenderBase;
our $VerSysSyslog;
our $VerTimeHiRes;
our $VerWin32Daemon;
our $CommentAvClamd;
our $CommentCheckUser;
our $CommentCIDR;
our $CommentCIDRlite;
our $CommentCompressZlib;
our $CommentDigestMD5;
our $CommentDigestSHA1;
our $CommentEmailValid;
our $CommentEMM;
our $CommentNetSMTP;
our $CommentFileReadBackwards;
our $CommentLWP;
our $CommentMailSPF2;
our $CommentMailSPF;
our $CommentMailSRS;
our $CommentNetDNS;
our $CommentNetLDAP;
our $CommentNetSyslog;
our $CommentRDBM;
our $CommentSenderBase;
our $CommentSysSyslog;
our $CommentTimeHiRes;
our $CommentWin32Daemon;
our $WLDRE;
our $WebSocket;
our $WhitelistObject;
our $alreadyTestingPing;
our $archivelogfile;
our $badattachL1RE;
our $badattachL2RE;
our $badattachL3RE;
our $baysSpamLoversReRE;
our $blackReRE;
our $bombCharSetsRE;
our $bombDataReRE;
our $bombHeaderReRE;
our $bombReRE;
our $bombSenderReRE;
our $bombSubjectReRE;
our $bombSuspiciousReRE;
our $ccSpamNeverReRE;
our $ccspamlt;
our $check4cfgtime;
our $cfgtime;
our $contentOnlyReRE;
our $cpuUsage;
our $destinationA;
our $dnsbl;
our $doShutdown;
our $endtime;
our $fallback;
our $footers;
our $goodattachRE;
our $headerDTDStrict;
our $headerDTDTransitional;
our $headerHTTP;
our $headers;
our $invalidFormatHeloReRE;
our $invalidMsgIDReRE;
our $invalidPTRReRE;
our $ispHostnamesRE;
our $isrunLDAPcrossCheck;
our $itime;
our $keys_deleted;
our $kudos;
our $lastOptionCheck;
our $lastTimeoutCheck;
our $lbn;
our $localdomainre;
our $lookup_return;
our $lsn2;
our $lsn;
our $maillogEnd;
our $maillogJump;
our $minusIcon;
our $mlogLastT;
our $nameserversrt;
our $nextCleanCache;
our $nextCleanDelayDB;
our $nextCleanPB;
our $nextConCheck;
our $nextdetectGhostCon;
our $nextExport;
our $nextGlobalUploadBlack;
our $nextGlobalUploadWhite;
our $nextLDAPcrossCheck;
our $nextLoop2;
our $nextNoop;
our $noLogReRE;
our $noIcon;
our $noSPFReRE;
our $noURIBLReRE;
our $npReRE;
our $opencon;
our $override;
our $pbdir;
our $plusIcon;
our $rbllists;
our $rbls_returned;
our $readable;
our $redReRE;
our $saveWhite;
our $scriptReRE;
our $shuttingDown;
our $slScoringMode;
our $smtpConcurrentSessions;
our $spffallback;
our $spfoverride;
our $strictSPFReRE;
our $fromStrictReRE;
our $blockstrictSPFReRE;
our $suspiciousattachRE;
our $testReRE;
our $testScoringMode;
our $validFormatHeloReRE;
our $validMsgIDReRE;
our $validPTRReRE;
our $webTime;
our $whiteReRE;
our $writable;
our %AllStats;
our %BackDNS;
our %Con;
our %Delay;
our %DelayWhite;
our %Dnsbl;
our %DomainVRFYMTA;
our %FileUpdate;
our %Griplist;
our %HeloBlack;
our %IPNumTries;
our %IPNumTriesDuration;
our %IPNumTriesExpiration;
our %LDAPlist;
our %MXACache;
our %OldStats;
our %PBBlack;
our %PBTrap;
our %PBWhite;
our %PTRCache;
our %PrevStats;
our %RBLCache;
our %RWLCache;
our %Redlist;
our %SBCache;
our %SMTPSession;
our %SMTPdomainIP;
our %SMTPdomainIPTries;
our %SMTPdomainIPTriesExpiration;
our %SPFCache;
our %SocketCalls;
our %Spamdb;
our %StatCon;
our %Stats;
our %URIBLCache;
our %WebCon;
our %Whitelist;
our %calist;
our %ccdlist;
our %check4updateTime;
our %crtable;
our %head;
our %localDomainsFile;
our %qs;
our %relayHostFile;
our %statRequests;
our %webRequests;
our @backsctrlist;
our @PossibleOptionFiles2;
our @PossibleOptionFiles;
our @SPFfallbackDomains;
our @SPFoverrideDomains;
our @badattachRE;
our @logCount;
our @logFreq;
our @nameservers;
our @msgid_secrets;
our @rbllist;
our @rwllist;
our @uribllist;

# end our global vars
our %MakeRE;
$MakeRE{localDomains} = \&setLDRE;
$MakeRE{myServerRe}   = \&setLHNRE;

$MakeRE{whiteListedDomains}  = \&setWLDRE;
$MakeRE{blackListedDomains}  = \&setBLDRE;
$MakeRE{noProcessingDomains} = \&setNPDRE;
$MakeRE{heloBlacklistIgnore} = \&setHBIRE;
$MakeRE{URIBLCCTLDS}         = \&setURIBLCCTLDSRE;
$MakeRE{URIBLwhitelist}      = \&setURIBLWLDRE;
$MakeRE{maxSMTPdomainIPWL}   = \&setIPDWLDRE;
$MakeRE{BounceSenders}       = \&setBSRE;
$MakeRE{noBombScript}        = \&setNBSRE;

fixConfigSettings();

sub niceConfig {
 my $counterT = -1;
 my %ConfigPos;
 my %ConfigNice;
 my %ConfigDefault;
 my %ConfigListBox;
 foreach my $c (@ConfigArray) {
   if(@{$c} == 5) {
      $counterT++;
   } else {
      $ConfigPos{$c->[0]} = $counterT;
      $ConfigNice{$c->[0]} = encodeHTMLEntities($c->[1]);
      $ConfigNice{$c->[0]} =~ s/<a\s+href.*<\/a>//i;
      $ConfigNice{$c->[0]} =~ s/'|"|\n//g;
      $ConfigNice{$c->[0]} =~ s/\\/\\\\/g;
      $ConfigNice{$c->[0]} = '&nbsp;' unless $ConfigNice{$c->[0]};
      $ConfigDefault{$c->[0]} = encodeHTMLEntities($c->[4]);
      $ConfigDefault{$c->[0]} =~ s/'|"|\n//g;
      $ConfigDefault{$c->[0]} =~ s/\\/\\\\/g;
      if ($c->[3] == \&listbox) {
          $ConfigDefault{$c->[0]} = 0 unless $ConfigDefault{$c->[0]};
          foreach my $opt ( split( /\|/, $c->[2] ) ) {
		my ( $v, $d ) = split( /:/, $opt, 2 );
                $ConfigDefault{$c->[0]} = $d if ( $ConfigDefault{$c->[0]} eq $v );
                $ConfigListBox{$c->[0]} = $d if ( $Config{$c->[0]} eq $v );
          }
      } elsif ($c->[3] == \&checkbox) {
                $ConfigDefault{$c->[0]} = $ConfigDefault{$c->[0]} ? 'On' : 'Off';
                $ConfigListBox{$c->[0]} = $Config{$c->[0]} ? 'On' : 'Off';;
      } else {
          $ConfigDefault{$c->[0]} = '&nbsp;' unless $ConfigDefault{$c->[0]};
      }
   }
 }
 foreach my $c (@ConfigArray) {
    next if(@{$c} == 5);
    my $line = $c->[7];
    my $newline;
    foreach my $word (split(/ /,$line)) {
        my $orgword = $word;
        $word =~ s/[^a-zA-Z0-9_]//g;
         if (exists $Config{$word}) {
              my $alt = $ConfigNice{$word};
              my $value = $ConfigListBox{$word} ? $ConfigListBox{$word} : encodeHTMLEntities($Config{$word});
              $value =~ s/'|"|\n//g;
              $value =~ s/\\/\\\\/g;
              $value = '&nbsp;' unless $value;
              my $default = $ConfigDefault{$word};
              my $subst = "<a href=\"./#$word\" style=\"color:#684f00\" onmousedown=\"showDisp('$ConfigPos{$word}');gotoAnchor('$word');return false;\" onmouseover=\"window.status='$alt'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\' bgcolor=lightyellow><tr><td>config var:</td><td>$word</td></tr><tr><td>description:</td><td>$alt</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\">$word</a>" ;
              $orgword =~ s/$word/$subst/;
         }
         $newline .= " $orgword";
    }
    $c->[7] = $newline;
 }
}

 &niceConfig();


SaveConfigSettings();
chmod 0666, "$base/assp.cfg";
PrintConfigSettings();
$SIG{HUP}  = \&reloadConfigFile;
$SIG{USR1} = \&saveSMTPconnections;
$SIG{USR2} = \&SaveConfig;
$SIG{PIPE} = "IGNORE";

$DomainCache ||= '^(?!)';
$EmailAdrRe    = "[^()<>@,;:\\\"\\[\\]\000-\040]+";
$EmailDomainRe = '(?:\w[\w\.\-]*\.\w+|\[[\d\.]*\.\d+\])';
$HeaderNameRe  = '\S[^\r\n]*';
$HeaderValueRe = '[ \t]*[^\r\n]*(?:\r?\n[ \t]+\S[^\r\n]*)*(?:\r?\n)?';
$HeaderRe      = '(?:' . $HeaderNameRe . ':' . $HeaderValueRe . ')';
$UUENCODEDRe   = '\bbegin\b \d\d\d \b\S{0,72}.*(\S{61}).{0,61}\bend\b';

# IP Address representations
$IPprivate       ='^(0.0.0.0|127.0.0.|169.254.|10.|192.168.|172.1[6-9].|172.2[0-9].|172.3[01].)';
$IPQuadSectRE    = '(?:0([0-7]+)|0x([0-9a-f]+)|(\d+))';
$IPQuadSectDotRE = '(?:' . $IPQuadSectRE . '\.)';
$IPQuadRE        = $IPQuadSectDotRE . '?' . $IPQuadSectDotRE . '?' . $IPQuadSectDotRE . '?' . $IPQuadSectRE;

# URI components - RFC3986, section 2, 'Characters'
$URIContinuationRe   = '\=(?:\015?\012|\015)';
$URIEncodedCharRe    = '[\=\%][a-f0-9]{2}|\&\#\d{1,3}\;?';
$URIUnreservedCharRe = '[a-z0-9\-\_\.\~]';
$URIGenDelimsCharRe  = '[\:\/\?\#\[\]\@]';
$URISubDelimsCharRe  = '[\!\$\&\'\(\)\*\+\,\;\=\%\^\`\{\}\|]';            # relaxed to a few other characters
$URIReservedCharRe   = $URIGenDelimsCharRe . '|' . $URISubDelimsCharRe;

# URI compounds
$URICommonRe = $URIContinuationRe . '|' . $URIEncodedCharRe . '|' . $URIUnreservedCharRe;
$URIHostRe   = '(?:' . $URICommonRe . '|' . $URISubDelimsCharRe . ')+';
$URIRe       = '(?:' . $URICommonRe . '|' . $URIReservedCharRe . ')+';
#renderConfigHTML(); # moved to line 2008
sub renderConfigHTML {
  my $maillogEnd;
  if ($MaillogTailJump) {
    $maillogEnd = '#End';
    $maillogJump = '<a href="#Top">Go to Top</a><a name="End">';
  } else {
    undef $maillogEnd;
    undef $maillogJump;
  }
  my $IndexPos = $hideAlphaIndex ? '451' : '440';
  my $IndexStart = $hideAlphaIndex ? '452' : '442';
  my $JavaScript;

  $plusIcon = "get?file=images/plusIcon.png";
  $minusIcon = "get?file=images/minusIcon.png";
  $noIcon = "get?file=images/noIcon.png";
  $wikiinfo = "get?file=images/info.png";
 $NavMenu = '
 <hr />
 <div class="menuLevel2">
  <a href="lists"><img src="' . $noIcon . '" alt="noicon" /> White/Redlist/Tuplets</a><br />

  <a href="maillog' . $maillogEnd . '"><img src="' . $noIcon . '" alt="noicon" /> View Maillog Tail</a><br />
  <a href="analyze"><img src="' . $noIcon . '" alt="noicon" /> Mail Analyzer</a><br />
  <a href="infostats"><img src="' . $noIcon . '" alt="noicon" /> Info and Stats</a><br />
  <a href="shutdown_list?nocache" target="_blank"><img src="' . $noIcon . '" alt="this monitor will slow down ASSP dramaticly - use it careful" /> SMTP Connections</a><br />
  <a href="shutdown"><img src="' . $noIcon . '" alt="noicon" /> Shutdown/Restart</a><br />
  <a href="donations"><img src="' . $noIcon . '" alt="noicon" /> Donations</a><br /></div>';
 $JavaScript = "
<script type=\"text/javascript\">
<!--
function toggleDisp(nodeid)
{
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
  else
  {
    layer.style.display = 'none';
    img.src = '$plusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'none';
  }
}
function showDisp(nodeid)
{
  if(nodeid.substr(0,9) == 'setupItem')
    nodeid = nodeid.substr(9);
  layer = document.getElementById('treeElement' + nodeid);
  img = document.getElementById('treeIcon' + nodeid);
  if(layer.style.display == 'none')
  {
    layer.style.display = 'block';
    img.src = '$minusIcon';
    if(document.getElementById('setupItem' + nodeid))
      document.getElementById('setupItem' + nodeid).style.display = 'block';
  }
}
function gotoAnchor(aname)
{
window.location.href = \"#\" + aname;
}
function expand(expand, force)
{
  counter = 0;
  while(document.getElementById('treeElement' + counter))
  {
    if(!expand)
    {
      //dont shrink if this element is the one passed in the URL
      arr = document.getElementById('treeElement' + counter).getElementsByTagName('a');
      txt = ''; found = 0;
      loc = new String(document.location);
      for(i=0; i < arr.length; i++)
      {
        txt = txt + arr.item(i).href;
        tmpHref = new String(arr.item(i).href);
        if(tmpHref.substr(tmpHref.indexOf('#')) == loc.substr(loc.indexOf('#')))
        {
          //give this tree node the right icon
          document.getElementById('treeIcon' + counter).src = '$minusIcon';
          found = 1;
        }
      }
      if(!found | force)
      {
        document.getElementById('treeIcon' + counter).src = '$plusIcon';
        document.getElementById('treeElement' + counter).style.display = 'none';
        if(document.getElementById('setupItem' + counter))
          document.getElementById('setupItem' + counter).style.display = 'none';
      }
    }
    else
    {
      document.getElementById('treeElement' + counter).style.display = 'block';
      document.getElementById('treeIcon' + counter).src = '$minusIcon';
      if(document.getElementById('setupItem' + counter))
        document.getElementById('setupItem' + counter).style.display = 'block';
    }
    counter++;
  }
}
//make the 'rel's work
function externalLinks()
{
  if (!document.getElementsByTagName)
    return;
  var anchors = document.getElementsByTagName(\"a\");
  for (var i=0; i<anchors.length; i++)
  {
    var anchor = anchors[i];
    if (anchor.getAttribute(\"href\")
      && anchor.getAttribute(\"rel\") == \"external\")
      anchor.target = \"_blank\";
  }
}";
 if ($EnableFloatingMenu) {
  $JavaScript .= "
function docHeight()
{
  if (typeof document.height != 'undefined') {
    return document.height;
  } else if (document.compatMode && document.compatMode != 'BackCompat') {
    return document.documentElement.scrollHeight;
  } else if (document.body && typeof document.body.scrollHeight !='undefined') {
    return document.body.scrollHeight;
  }
}
//********************************************************
//* You may use this code for free on any web page provided that
//* these comment lines and the following credit remain in the code.
//* Floating Div from http://www.javascript-fx.com
//********************************************************
// Modified in May 2005 by Przemek Czerkas:
//  - added calls to docHeight()
//  - added bounding params tlx, tly, brx, bry
var ns = (navigator.appName.indexOf(\"Netscape\") != -1);
var d = document;
var px = document.layers ? \"\" : \"px\";
function JSFX_FloatDiv(id, sx, sy, tlx, tly, brx, bry)
{
  var el=d.getElementById?d.getElementById(id):d.all?d.all[id]:d.layers[id];
  window[id + \"_obj\"] = el;
  if(d.layers)el.style=el;
  el.cx = el.sx = sx;
  el.cy = el.sy = sy;
  el.tlx = tlx;
  el.tly = tly;
  el.brx = brx;
  el.bry = bry;
  el.sP=function(x,y){this.style.left=x+px;this.style.top=y+px;};
  el.flt=function()
  {
    var pX, pY;
    pX = ns ? pageXOffset : document.documentElement && document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft;
    pY = ns ? pageYOffset : document.documentElement && document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop;
    if(this.sy<0)
      pY += ns ? innerHeight : document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight : document.body.clientHeight;
    this.cx += (pX + Math.max(this.sx-pX, this.tlx) - this.cx)/4;
    this.cy += (pY + Math.max(this.sy-pY, this.tly) - this.cy)/4;
    this.cx = Math.min(this.cx, this.brx);
    this.cy = Math.min(this.cy, this.bry);
    if (ns) {
      this.sP(
        Math.max(Math.min(this.cx+this.clientWidth,document.width)-this.clientWidth,this.sx),
        Math.max(Math.min(this.cy+this.clientHeight,document.height)-this.clientHeight,this.sy)
      );
    } else {
      var oldh, newh;
      oldh = docHeight();
      this.sP(this.cx, this.cy);
      newh = docHeight();
      if (newh>oldh) {
        this.sP(this.cx, this.cy-(newh-oldh));
      }
    }
    setTimeout(this.id + \"_obj.flt()\", 20);
  }
  return el;
}";
 }
 $JavaScript .= '
function popFileEditor(filename,note)
{
  var height = (note == 0) ? 420 : 460;
  newwindow=window.open(
    \'edit?file=\'+filename+\'&note=\'+note,
    \'FileEditor\',
    \'width=720,height=\'+height+\',toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=no,status=no,directories=no,resizable=yes\'
  );
  	// this puts focus on the popup window if we open a new popup without closing the old one.
  	if (window.focus) {newwindow.focus()}
  	return false;
}
window.onload = externalLinks;
// -->
</script>';

# JavaScript for alphabetic IndexMenu
 $JavaScript .= '
<style type="text/css" >
<!--
#smenu {background-color:#ffffff; text-align:left; font-size: 90%; border:1px solid #000099; z-Index:200; visibility:hidden; position:absolute; top:100px; left:-'.$IndexPos.'px; width:450px; height:700px;}
#sleftTop {width:420px; height:5%; float:left;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow: hidden;}
#sleft {width:420px; height:94%; float:left;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow-x: hidden;overflow-y: scroll;}
#sright {width:10px; height:99%; float:right;font-size: 90%;color:#999999; font-family:arial, helvetica, sans-serif;overflow: hidden;}
#sright a:link{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:visited{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:active{text-decoration:none; color:#684f00; font-family:arial, helvetica, sans-serif;}
#sright a:hover{text-decoration:underline; color:#999999; font-family:arial, helvetica, sans-serif;}
-->
</style>

<script type="text/javascript">
<!--
// Sliding Menu Script
// copyright Stephen Chapman, 6th July 2005
// you may copy this code but please keep the copyright notice as well
// ASSP implementation by Thomas Eckardt
var speed = 1;

function ClientSize(HorW) {
  var myWidth = 0, myHeight = 0;
  if( typeof( window.innerWidth ) == \'number\' ) {
    //Non-IE
    myWidth = window.innerWidth;
    myHeight = window.innerHeight;
  } else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
    //IE 6+ in \'standards compliant mode\'
    myWidth = document.documentElement.clientWidth;
    myHeight = document.documentElement.clientHeight;
  } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
    myHeight = document.body.clientHeight;
  }
  return  HorW == \'w\' ?  myWidth : myHeight;
}

var aDOM = 0, ieDOM = 0, nsDOM = 0; var stdDOM = document.getElementById;
if (stdDOM) aDOM = 1; else {ieDOM = document.all; if (ieDOM) aDOM = 1; else {
var nsDOM = ((navigator.appName.indexOf(\'Netscape\') != -1)
&& (parseInt(navigator.appVersion) ==4)); if (nsDOM) aDOM = 1;}}
function xDOM(objectId, wS) {
if (stdDOM) return wS ? document.getElementById(objectId).style:
document.getElementById(objectId);
if (ieDOM) return wS ? document.all[objectId].style: document.all[objectId];
if (nsDOM) return document.layers[objectId];
}
function objWidth(objectID) {var obj = xDOM(objectID,0); if(obj.offsetWidth) return obj.offsetWidth; if (obj.clip) return obj.clip.width; return 0;}
function objHeight(objectID) {var obj = xDOM(objectID,0); if(obj.offsetHeight) return obj.offsetHeight; if (obj.clip) return obj.clip.height; return 0;}
function setObjVis(objectID,vis) {var objs = xDOM(objectID,1); objs.visibility = vis;}
function moveObjTo(objectID,x,y) {var objs = xDOM(objectID,1); objs.left = x; objs.top = y;}
function pageWidth() {return window.innerWidth != null? window.innerWidth: document.body != null? document.body.clientWidth:null;}
function pageHeight() {return window.innerHeight != null? window.innerHeight: document.body != null? document.body.clientHeight:null;}
function posLeft() {return typeof window.pageXOffset != \'undefined\' ? window.pageXOffset: document.documentElement.scrollLeft?
 document.documentElement.scrollLeft: document.body.scrollLeft? document.body.scrollLeft:0;}

function posTop() {return typeof window.pageYOffset != \'undefined\' ? window.pageYOffset: document.documentElement.scrollTop?
 document.documentElement.scrollTop: document.body.scrollTop? document.body.scrollTop:0;}

var xxx = 0; var yyy = 0; var dist = distX = distY = 0; var stepx = 10; var stepy = 0; var mn = \'smenu\';

function disableSlide() {setObjVis(mn,\'hidden\');}
function enableSlide() {setObjVis(mn,\'visible\');}
function distance(s,e) {return Math.abs(s-e)}
function direction(s,e) {return s>e?-1:1}
function rate(a,b) {return a<b?a/b:1}
function setHeight() {var objs = xDOM(mn,1); var h = ClientSize(\'h\'); objs.height = h*0.95 +\'px\';}
function start() {setHeight(); xxx = -'.$IndexStart.'; yyy = 0; var eX = 0; var eY = 100; dist = distX = distance(xxx,eX); distY = distance(yyy,eY); stepx *=
-direction(xxx,eX) * rate(distX,distY); stepy *= direction(yyy,eY) * rate(distY,distX); moveit(); setObjVis(mn,\'visible\');}

function moveit() {var x = (posLeft()+xxx) + \'px\'; var y = posTop() + \'px\'; moveObjTo(mn,x,y);}
function mover() {if (dist > 0) {xxx += stepx; yyy += stepy; dist -= Math.abs(stepx);} moveit(); setTimeout(\'mover()\',speed);}
function slide() {dist = distX; stepx = -stepx; moveit(); setTimeout(\'mover()\',speed*2);return false;}

onload = start;
window.onscroll = moveit;
// -->
</script>
';
# END JavaScript for alphabetic IndexMenu

#start JavaScript for HintBox
$JavaScript .= '
<style type="text/css">

#hintbox{ /*CSS for pop up hint box */
position:absolute;
top: 0;
background-color: lightyellow;
width: 150px; /*Default width of hint.*/
padding: 3px;
border:1px solid black;
font:normal 11px Verdana;
line-height:18px;
z-index:300;
border-right: 3px solid black;
border-bottom: 3px solid black;
visibility: hidden;
}

</style>

<script type="text/javascript">

/***********************************************
* Show Hint script-  Dynamic Drive (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit http://www.dynamicdrive.com/ for this script and 100s more.
*
* implemented in ASSP by Thomas Eckardt
***********************************************/

var horizontal_offset="0px" //horizontal offset of hint box from anchor link

/////No further editting needed

var vertical_offset="20px" //vertical offset of hint box from anchor link. No need to change.
var ie=document.all
var ns6=document.getElementById&&!document.all

function getposOffset(what, offsettype){
var totaloffset=(offsettype=="left")? what.offsetLeft : what.offsetTop;
var parentEl=what.offsetParent;
while (parentEl!=null){
totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
parentEl=parentEl.offsetParent;
}
return totaloffset;
}

function iecompattest(){
return (document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body
}

function clearbrowseredge(obj, whichedge, where){
var edgeoffset=(whichedge=="rightedge")? (parseInt(horizontal_offset)-obj.offsetWidth*where/2)*-1 : parseInt(vertical_offset)*-1;
if (whichedge=="rightedge"){
var windowedge=ie && !window.opera? iecompattest().scrollLeft+iecompattest().clientWidth-90 : window.pageXOffset+window.innerWidth-100;
dropmenuobj.contentmeasure=dropmenuobj.offsetWidth;
if (windowedge-dropmenuobj.x < dropmenuobj.contentmeasure)
edgeoffset=dropmenuobj.contentmeasure+obj.offsetWidth/(where+1)+parseInt(horizontal_offset);
}
else{
var windowedge=ie && !window.opera? iecompattest().scrollTop+iecompattest().clientHeight-15 : window.pageYOffset+window.innerHeight-18
dropmenuobj.contentmeasure=dropmenuobj.offsetHeight
if (windowedge-dropmenuobj.y < dropmenuobj.contentmeasure)
edgeoffset=dropmenuobj.contentmeasure-obj.offsetHeight+parseInt(vertical_offset)
}
return edgeoffset
}

function showhint(menucontents, obj, e, tipwidth, currLoc){
if ((ie||ns6) && document.getElementById("hintbox")){
dropmenuobj=document.getElementById("hintbox")
dropmenuobj.innerHTML=menucontents
dropmenuobj.style.left=dropmenuobj.style.top=-500
if (tipwidth!=""){
dropmenuobj.widthobj=dropmenuobj.style
dropmenuobj.widthobj.width=tipwidth
}
dropmenuobj.x=getposOffset(obj, "left")
dropmenuobj.y=getposOffset(obj, "top");
if (currLoc != "" && (ie||ns6)) {
var postop = ns6 ? 0 : posTop();
dropmenuobj.style.top=yMousePos+postop+parseInt(vertical_offset)+"px";
} else {
dropmenuobj.style.top=dropmenuobj.y-clearbrowseredge(obj, "bottomedge", 0)+"px";
}
if (currLoc != "") {
dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 0)+obj.offsetWidth+"px";
}
else {
dropmenuobj.style.left=dropmenuobj.x-clearbrowseredge(obj, "rightedge", 1)+obj.offsetWidth+"px";
}
//alert("x="+dropmenuobj.x+" , cb="+clearbrowseredge(obj, \'rightedge\')+" , offset="+obj.offsetWidth);
//dropmenuobj.style.left=xMousePos+"px"
dropmenuobj.style.visibility="visible"
obj.onmouseout=hidetip
}
}

function hidetip(e){
dropmenuobj.style.visibility="hidden"
dropmenuobj.style.left="-500px"
}

function createhintbox(){
var divblock=document.createElement("div")
divblock.setAttribute("id", "hintbox")
document.body.appendChild(divblock)
}

if (window.addEventListener)
window.addEventListener("load", createhintbox, false)
else if (window.attachEvent)
window.attachEvent("onload", createhintbox)
else if (document.getElementById)
window.onload=createhintbox

// Set Netscape up to run the "captureMousePosition" function whenever
// the mouse is moved. For Internet Explorer and Netscape 6, you can capture
// the movement a little easier.
if (document.layers) { // Netscape
    document.captureEvents(Event.MOUSEMOVE);
    document.onmousemove = captureMousePosition;
} else if (document.all) { // Internet Explorer
    document.onmousemove = captureMousePosition;
} else if (document.getElementById) { // Netcsape 6
    document.onmousemove = captureMousePosition;
}

// Global variables
xMousePos = 0; // Horizontal position of the mouse on the screen
yMousePos = 0; // Vertical position of the mouse on the screen
xMousePosMax = 0; // Width of the page
yMousePosMax = 0; // Height of the page

function captureMousePosition(e) {
    if (document.layers) {
        // When the page scrolls in Netscape, the event\'s mouse position
        // reflects the absolute position on the screen. innerHight/Width
        // is the position from the top/left of the screen that the user is
        // looking at. pageX/YOffset is the amount that the user has
        // scrolled into the page. So the values will be in relation to
        // each other as the total offsets into the page, no matter if
        // the user has scrolled or not.
        xMousePos = e.pageX;
        yMousePos = e.pageY;
        xMousePosMax = window.innerWidth+window.pageXOffset;
        yMousePosMax = window.innerHeight+window.pageYOffset;
    } else if (document.all) {
        // When the page scrolls in IE, the event\'s mouse position
        // reflects the position from the top/left of the screen the
        // user is looking at. scrollLeft/Top is the amount the user
        // has scrolled into the page. clientWidth/Height is the height/
        // width of the current page the user is looking at. So, to be
        // consistent with Netscape (above), add the scroll offsets to
        // both so we end up with an absolute value on the page, no
        // matter if the user has scrolled or not.
        xMousePos = window.event.x+document.body.scrollLeft;
        yMousePos = window.event.y+document.body.scrollTop;
        xMousePosMax = document.body.clientWidth+document.body.scrollLeft;
        yMousePosMax = document.body.clientHeight+document.body.scrollTop;
    } else if (document.getElementById) {
        // Netscape 6 behaves the same as Netscape 4 in this regard
        xMousePos = e.pageX;
        yMousePos = e.pageY;
        xMousePosMax = window.innerWidth+window.pageXOffset;
        yMousePosMax = window.innerHeight+window.pageYOffset;
    }
}
</script>
';
#end JavaScript for HintBox

 $headerHTTP = 'HTTP/1.1 200 OK
Content-type: text/html
Cache-control: no-cache
';
 $headerDTDStrict = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
';
 $headerDTDTransitional = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
';
 $headers = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">
<head>
  <meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=utf-8\" />
  <title>ASSP ($myName) Host: $localhostname @ $localhostip</title>
  <link rel=\"stylesheet\" href=\"get?file=images/assp.css\" type=\"text/css\" />
  <link rel=\"shortcut icon\" href=\"get?file=images/favicon.ico\" />
$JavaScript
</head>
<body><a name=\"Top\"></a>
  <div id=\"smenu\"><div id=\"sleftTop\">&nbsp;&nbsp;
";

 for ("A"..."Z") {
 $headers .= "<a href=\"#$_\" onmousedown=\"gotoAnchor('$_');return false;\">$_&nbsp;</a>";
 }
 $headers .= "<br />\n<hr></hr></div><div id=\"sleft\">\n";
 my $counter = -1;
 my %ConfigPos;
 my %ConfigNice;
 my %ConfigDefault;
 my %ConfigListBox;
 foreach my $c (@ConfigArray) {
   if(@{$c} == 5) {
      $counter++;
   } else {
      $ConfigPos{$c->[0]} = $counter;
      $ConfigNice{$c->[0]} = encodeHTMLEntities($c->[1]);
      $ConfigNice{$c->[0]} =~ s/<a\s+href.*<\/a>//i;
      $ConfigNice{$c->[0]} =~ s/'|"|\n//g;
      $ConfigNice{$c->[0]} =~ s/\\/\\\\/g;
      $ConfigNice{$c->[0]} = '&nbsp;' unless $ConfigNice{$c->[0]};
      $ConfigDefault{$c->[0]} = encodeHTMLEntities($c->[4]);
      $ConfigDefault{$c->[0]} =~ s/'|"|\n//g;
      $ConfigDefault{$c->[0]} =~ s/\\/\\\\/g;
      if ($c->[3] == \&listbox) {
          $ConfigDefault{$c->[0]} = 0 unless $ConfigDefault{$c->[0]};
          foreach my $opt ( split( /\|/, $c->[2] ) ) {
		my ( $v, $d ) = split( /:/, $opt, 2 );
                $ConfigDefault{$c->[0]} = $d if ( $ConfigDefault{$c->[0]} eq $v );
                $ConfigListBox{$c->[0]} = $d if ( $Config{$c->[0]} eq $v );
          }
      } elsif ($c->[3] == \&checkbox) {
                $ConfigDefault{$c->[0]} = $ConfigDefault{$c->[0]} ? 'On' : 'Off';
                $ConfigListBox{$c->[0]} = $Config{$c->[0]} ? 'On' : 'Off';;
      } else {
          $ConfigDefault{$c->[0]} = '&nbsp;' unless $ConfigDefault{$c->[0]};
      }
   }
 }
my %Config1;
my $i = 0;
foreach (keys %Config) {
    $Config1{lc($_)} = $_;
}
my $firstChar = '';
foreach (sort keys %Config1) {
    my $k = $Config1{$_};
    my $name = uc($firstChar) ne uc(substr($k,0,1)) ? "name=\"".uc(substr($k,0,1))."\"" : '';
    $firstChar = uc(substr($k,0,1));
    my $value = $ConfigListBox{$k} ? $ConfigListBox{$k} : encodeHTMLEntities($Config{$k});
    $value =~ s/'|"|\n//g;
    $value =~ s/\\/\\\\/g;
    $value = '&nbsp;' unless $value;
    my $default = $ConfigDefault{$k};
    $headers .= "<a $name href=\"./#$k\" onmousedown=\"expand(0, 1);showDisp('$ConfigPos{$k}');gotoAnchor('$k');slide();return false;\" onmouseover=\"window.status='$ConfigNice{$k}'; showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>config var:</td><td>$k</td></tr><tr><td>description:</td><td>$ConfigNice{$k}</td></tr><tr><td>current value:</td><td>$value</td></tr><tr><td>default value:</td><td>$default</td></tr></table>', this, event, '500px', 'index'); return true;\" onmouseout=\"window.status='';return true;\">&nbsp;<img src=\"$noIcon\" alt=\"$ConfigNice{$k}\" />&nbsp;$k</a><br />\n";
    $i++;
}

  $headers .= "<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;</div><div id=\"sright\"><a href=\"#\" onclick=\"return slide();return false;\">";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
# do not use spaces in $boardertext - instead use '#'
  my $boardertext = "sorted#config";
  $boardertext =~ s/([^#])/$1<br \/>/g;
  $boardertext =~ s/#/&nbsp;<br \/>/g;
  $headers .= "$boardertext<br />";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/minusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "<img src=\"get?file=images/plusIcon.png\" alt=\"open and close alphabetical index\" /><br />&nbsp;<br \/>";
  $headers .= "</a></div></div>
<p>
  <a href=\"http://assp.sourceforge.net/\" target=\"_blank\"><img src=\"get?file=images/logo.jpg\" alt=\"ASSP\" /></a>";

#if ($setpro && $globalClientName && $globalClientPass) {
#$headers .= "<b><font color=white size=+3>&nbsp;&nbsp;&nbsp;pro&nbsp;&nbsp;&nbsp;</font></b>";
#}

$headers .= "</p>
<div class=\"navMenu\"";
 $headers .= ' id="navMenu" style="position:absolute"' if $EnableFloatingMenu;
 $headers .= "><div><div style=\"text-align: center;\">
  <a href=\"#\" onmousedown=\"expand(1, 1)\">Expand All</a>&nbsp;
  <a href=\"#\" onmousedown=\"expand(0, 1)\">Collapse All</a>&nbsp;
  <a href=\"#\" onmousedown=\"slide();return false;\">Sorted</a></div>
  <hr />

  <div class=\"rightButton\" style=\"text-align: center;\">
  <input type=\"button\" value=\"Apply Changes\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();return false;\" />
</div>

<hr />
  <div class=\"menuLevel1\"><a href=\"/\"><img src=\"$plusIcon\" alt=\"plusicon\" /> Main</a><br /></div>";
 $counter = 0;
 foreach my $c (@ConfigArray) {
   if(@{$c} == 5) {
     $headers .= "</div>\n  <div class=\"menuLevel2\">\n  <a onmousedown=\"toggleDisp('$counter')\">" .
       "<img id=\"treeIcon$counter\" src=\"$plusIcon\" alt=\"plusicon\" /> " .
       "$c->[4]</a>\n</div>\n<div id=\"treeElement$counter\" style=\"padding-left: 3px; display: block\">";
     $counter++;
   } else {
     $headers .= "\n    <div class=\"menuLevel3\"><a href=\"./#$c->[0]\">$c->[0]</a></div>";
     }
 }
 $headers .= "</div>
<div class=\"menuLevel1\">$NavMenu</div>

<hr />
<div class=\"menuLevel2\">

	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/confighistory.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Config Changes History</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/admininfo.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Admin Info Messages</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/configdefaults.txt\',8); \"><img src=\"$noIcon\" alt=\"#\" /> Non-Default Settings</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'/notes/config.txt\',8);\"><img src=\"$noIcon\" alt=\"#\" /> Config Descriptions</a><br />
	<a href=\"#\" onclick=\"return popFileEditor(\'rebuildrun.txt\',8);\"><img src=\"$noIcon\" alt=\"#\" /> Last SpamDB Rebuild</a>
	<hr />
	<span style=\"font-weight: bold;\">ASSP Version</span>: $version$modversion<br />
	<span style=\"font-weight: bold;\">Current PID</span>: $mypid<br />
	<span style=\"font-weight: bold;\">Started</span>: $starttime<br />
</div>
<hr />


  <div class=\"rightButton\" style=\"text-align: center;\">
  <input type=\"button\" value=\"Apply Changes\" onclick=\"document.forms['ASSPconfig'].theButtonX.value='Apply Changes';document.forms['ASSPconfig'].submit();return false;\" />
</div>
  <hr />
</div>
<script type=\"text/javascript\">
  <!--
  ";
 $headers .= 'JSFX_FloatDiv("navMenu",2,50,2,-2,2,99999).flt();' if $EnableFloatingMenu;
 $headers .= '
  expand(0,0);
  // -->
  </script>
  ';
 $footers = "
<div class=\"contentFoot\">
<a href=\"https://www.paypal.com/xclick/business=fb%40iworld.de&amp;item_name=Support+ASSP&amp;item_number=assp&amp;no_note=1&amp;tax=0&amp;currency_code=USD\" rel=\"external\">donations</a> |
<a href=\"http://www.magicvillage.de/~Fritz_Borgstedt/assp/S064D398D?WasRead=1\" rel=\"external\" target=\"_blank\">development</a> |
<a href=\"http://www.asspsmtp.org/scripts/stats\" rel=\"external\" target=\"_blank\">global stats</a> |
<a href=\"http://www.asspsmtp.org/wiki/ASSPDOCS\" rel=\"external\" target=\"_blank\">docs</a> |
 <a href=\"http://sourceforge.net/mail/?group_id=69172\" rel=\"external\" target=\"_blank\">email lists</a> |

 <a href=\"http://www.asspsmtp.org/forums/\" rel=\"external\" target=\"_blank\">community forums</a> |
 <a href=\"http://sourceforge.net/forum/?group_id=69172\" rel=\"external\" target=\"_blank\">sf forums</a> |
 <a href=\"http://www.asspsmtp.org/wiki/\" rel=\"external\" target=\"_blank\">wiki</a>
</div>";
$kudos = '
<div class="kudos">
 <a href="http://www.magicvillage.de/~Fritz_Borgstedt/assp/" rel="external" target="_blank">
 <img src="get?file=images/village.gif" alt="Development" height="31" width="31" /></a>
 <a href="http://sourceforge.net" rel="external" target="_blank">
 <img src="get?file=images/sourceforge-logo.gif" alt="SourceForge" height="31" width="88" /></a>
 <a href="http://opensource.org" rel="external" target="_blank">
 <img src="get?file=images/opensource-logo.gif" alt="Open Source" height="31" width="88" /></a>
</div>
';
}



# Notes on general operation & program structure
# I'm using IO::Select, so don't make any changes that block for long
# as new connections come we create a pair of entries in a hash %Con
# based on the hash of the filehandle, so $Con{$fh} has data for this
# connection. $Con{$fh}->{friend} is the partner socket for the smtp proxy.
# ->{ip} is the ip address of the connecting client
# ->{relayok} tells if we can relay mail for this client
# ->{getline} is a pointer to a function that should be called whan a line of input is received for this filehandle
# ->{mailfrom} is the envelope sender (MAIL FROM: <address>)
# ->{outgoing} is a buffer for outgoing socket traffic (see $writable & &sendque)
# ->{rcpt} are the addresses from RCPT TO: <address> (space separated)
# ->{header} is where the header (and eventually the first 10000 bytes) are stored
# ->{myheader} is where we store our header, we merge it with client's header later
# ->{maillog} if present stream logging is enabled
# ->{maillogbuf} buffer for storing unwritten stream log while waiting for isspam decision
# ->{maillogfh} is the filehandle for logging lines to the maillog
# ->{mailloglength} is the length logged so far (we stop after 10000 bytes)
# ->{spamfound} is a flag used to signal if an email is determined to be spam.
# ->{maillength} is the same as mailloglength but is not reset.
#
# After connection the {getline} field functions like a state machine
# redirecting input to subsequent handlers
#
# whitebody -> getline
#   getbody ->
#     error -> (disconnects)
#     getline -> getheader ->
#       whitebody -> getline
#         error -> (disconnects)
#
# getline looks for MAIL FROM, RCPT TO, RSET
# getheader looks for a blank line then tests for whitelist / spamaddresses
# getbody looks for the . and calls isspam, the Bayesian spam test
# whitebody waits for . and redirects client to server
# error waits for . ignoring data from client (and finishes the maillog)
#
# the server has states like this:
#
# skipok -> reply
#
# skipok traps the 250 ok response from the NOOP Connection from
# reply echos server messages to the client
# reply also looks for a 235 AUTH OK and sets {relayok}=1

sub serviceCheck { }
sub d            { return; }

if ($DEBUG) {
    open( DEBUG, ">$base/" . time . ".dbg" );
    binmode(DEBUG);
    my $oldfh = select(DEBUG);
    $| = 1;
    select($oldfh);
  }

eval(
    q[sub d {
 my $time=gmtime(); $time=~s/... (...) +(\d+) (........) ..(..)/$2 $1 $4 $3/;
 my $debugprint = $_[0];
 $debugprint =~ s/\n//;
 $debugprint =~ s/\r//;
 $debugprint =~ s/\s+$//;
 print DEBUG "$time <$debugprint>\n";
 }]
) if $DEBUG;

if ($AsADaemon) {
    fork() && exit;
    close STDOUT;
    close STDERR;
    $silent = 1;
  }

if ($pidfile) { open( F, ">$base/$pidfile" ); print F $$; close F; }

sub RemovePid {
    if ($pidfile) {
        d('RemovePid');
        unlink("$base/$pidfile");
      }
  }

#if($DEBUG) {open(DEBUG, ">$base/".time.".dbg"); binmode(DEBUG); my $oldfh = select(DEBUG); $| = 1; select($oldfh);}
my $logdir = $1 if $logfile =~ /(.*)\/.*/;
-d "$base/$logdir" or mkdir "$base/$logdir", 0770 if $logdir;
if ( $logfile && open( LOG, ">>$base/$logfile" ) ) {
    my $oldfh = select(LOG);
    $| = 1;
    select($oldfh);
  }

if ($AsAService) {
    eval(<<'EOT');
 use Win32::Daemon;
 mlog(0,"starting as a service");
 Win32::Daemon::StartService();

 # Wait until the service manager is ready for us to continue...
 while( SERVICE_START_PENDING != Win32::Daemon::State() ) { sleep( 1 ); }
 Win32::Daemon::State( SERVICE_RUNNING );

sub serviceCheck {
 d(50);
 if(Win32::Daemon::State() == SERVICE_STOP_PENDING ) {
  d(51);

  mlog(0,"service stopping");
  &SaveWhitelist;
  Win32::Daemon::State( SERVICE_STOPPED );
  Win32::Daemon::StopService();
  exit;
 }
}

EOT
    print STDERR "error: $@\n" if $@;
    print LOG "error: $@\n"    if $@;
  }

init();
$lastTimeoutCheck = time();
eval {
    while (1) {
        &MainLoop;
      }
};
if ($@) {
 my $exmsg = "main exception: $@\n";
 print $exmsg;
 print $LOG $exmsg;

 open( EX, ">>$base/exception.log" );
 print EX $exmsg;
 close EX;

 &SaveWhitelist;
 &SavePB;
 &SaveStats;
 mlog(0,"try restarting ASSP on exception");
 
 if($AsAService) {
    exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
 } elsif ($AsADaemon) {
    exit 1;
 } else {
    exec($AutoRestartCmd) if $AutoRestart;
    exit 1;
 }
}

sub init {
    my $ver;

    my $perlver = $];

    mlog( 0, "ASSP version $version$modversion (Perl $]) initializing " );
    mlog( 0, "Perl 5.8 needed for Webinterface!" ) if $] <= "5.008";
    if ($CanUseAvClamd) {
        my $clamavd = new File::Scan::ClamAV( port => $AvClamdPort );
        if ( $clamavd->ping() ) {
            $AvailAvClamd = 1;
            $ver          = $clamavd->VERSION;
            $VerAvClamd   = $ver;
            $ver          = " version $ver" if $ver;
            mlog( 0, "File::Scan::ClamAV module$ver installed and available" );
          } else {
            $AvailAvClamd = 0;
            $ver          = $clamavd->VERSION;
            $VerAvClamd   = $ver;
            $ver          = " version $ver" if $ver;
            mlog( 0, "File::Scan::ClamAV module$ver installed but not available, error: " . $clamavd->errstr() );
            $CommentAvClamd = $clamavd->errstr();
          }
      } else {
        $AvailAvClamd = 0;
        $VerAvClamd   = "";
        mlog( 0, "File::Scan::ClamAV module not installed" ) if $UseAvClamd;
      }

    if ($localhostname) {
        mlog( 0, "ASSP running on server: $localhostname ($localhostip)" );
      } else {
        mlog( 0, "ASSP running on server: localhost ($localhostip)" );
      }
    if ($CanUseLDAP) {
        $ver        = eval('Net::LDAP->VERSION');
        $VerNetLDAP = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Net::LDAP module$ver installed and available" );
      } else {
        mlog( 0, "Net::LDAP module not installed" ) if $DoLDAP;
      }
    if ($CanUseDNS) {
        $ver       = eval('Net::DNS->VERSION');
        $VerNetDNS = $ver;
        $ver       = " version $ver" if $ver;
        mlog( 0, "Net::DNS module$ver installed and available" );
      } else {
        mlog( 0, "Net::DNS module not installed" );
      }
    if ($CanUseAddress) {
        $ver           = eval('Email::Valid->VERSION');
        $VerEmailValid = $ver;
        $ver           = " version $ver" if $ver;
        mlog( 0, "email::Valid module$ver installed and available" );
      } else {
        mlog( 0, "email::Valid module not installed" )
          if $DoRFC822 || $DoDomainCheck;
      }
    if ($CanUseSPF) {
        $ver        = eval('Mail::SPF::Query->VERSION');
        $VerMailSPF = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Mail::SPF::Query module$ver installed and available" );
      } elsif ($AvailSPF) {
        $ver = eval('Mail::SPF::Query->VERSION');
        $ver = " version $ver" if $ver;
        mlog( 0, "Mail::SPF::Query module$ver installed but Net::DNS required" );
        $CommentMailSPF = "will not be used, Net::DNS required";
      } else {
        mlog( 0, "Mail::SPF::Query module not installed" ) if $ValidateSPF;
      }
    if ($CanUseSPF2) {
        $ver = eval('Mail::SPF->VERSION');
        $ver =~ s/^v//gi;    # strip leading 'v'
        $VerMailSPF2 = $ver;
        $ver = " version $ver" if $ver;
        if ( $VerMailSPF2 >= 2.001 ) {
            mlog( 0, "Mail::SPF module$ver installed and available" );
          } else {
            mlog( 0, "Mail::SPF module$ver installed but must be >= 2.001" );
            mlog( 0, "Mail::SPF will not be used." );
            $CommentMailSPF2 = "will not be used, must be >= 2.001"; 
            $CanUseSPF2 = 0;
          }
      } elsif ($AvailSPF2) {
        $ver = eval('Mail::SPF->VERSION');
        $ver =~ s/^v//gi;    # strip leading 'v'
        $ver = " version $ver" if $ver;
        mlog( 0, "Mail::SPF module$ver installed but Net::DNS required" );
        $CommentMailSPF2 = "will not be used, Net::DNS required";
      } else {
        mlog( 0, "Mail::SPF module not installed" ) if $ValidateSPF;
      }
    if ($CanUseSRS) {
        $ver        = eval('Mail::SRS->VERSION');
        $VerMailSRS = $ver;
        $ver        = " version $ver" if $ver;
        mlog( 0, "Mail::SRS module$ver installed - Sender Rewriting Scheme available" );
      } elsif ( !$AvailSRS ) {
        mlog( 0, "Mail::SRS module not installed - Sender Rewriting Scheme disabled" ) if $EnableSRS;
      }
    if ($CanUseHTTPCompression) {
        $ver             = eval('Compress::Zlib->VERSION');
        $VerCompressZlib = $ver;
        $ver             = " version $ver" if $ver;
        mlog( 0, "Compress::Zlib module$ver installed - HTTP compression available" );
      } elsif ( !$AvailZlib ) {
        mlog( 0, "Compress::Zlib module not installed - HTTP compression disabled" );
      }
    if ($CanUseMD5Keys) {
        $ver          = eval('Digest::MD5->VERSION');
        $VerDigestMD5 = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Digest::MD5 module$ver installed - delaying can use MD5 keys for hashes" );
        $CommentDigestMD5 = "delaying can use MD5 keys for hashes";
      }
    if ($CanUseSHA1) {
        $ver=eval('Digest::SHA1->VERSION');
        $VerDigestSHA1=$ver;
        $ver=" version $ver" if $ver;
        mlog(0,"Digest::SHA1 module$ver installed ");
      }
    if ($CanSearchLogs) {
        $ver                  = eval('File::ReadBackwards->VERSION');
        $VerFileReadBackwards = $ver;
        $ver                  = " version $ver" if $ver;
        mlog( 0, "File::ReadBackwards module$ver installed - searching of log files enabled" );
        $CommentFileReadBackwards = "searching of log files enabled";
      } elsif ( !$AvailReadBackwards ) {
        mlog( 0, "File::ReadBackwards module not installed - searching of log files disabled" );
        $CommentFileReadBackwards = "searching of log files disabled";
      }
    if ($CanStatCPU) {
        $ver          = eval('Time::HiRes->VERSION');
        $VerTimeHiRes = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Time::HiRes module$ver installed - CPU usage statistics available" );
        $CommentTimeHiRes = "CPU statistics available";
      } elsif ( !$AvailHiRes ) {
        $CommentTimeHiRes = "CPU statistics disabled";
        mlog( 0, "Time::HiRes module not installed - CPU usage statistics disabled" );
      }
    if ($CanChroot) {
        $ver = eval('PerlIO::scalar->VERSION');
        $ver = " version $ver" if $ver;
        mlog( 0, "PerlIO::scalar module$ver installed - chroot savy" )
          if $ChangeRoot;
      }
    if ($CanUseSyslog) {
        $ver          = eval('Sys::Syslog->VERSION');
        $VerSysSyslog = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Sys::Syslog module$ver installed - Unix centralized logging enabled" );
      } elsif ( !$AvailSyslog ) {
        $CommentSysSyslog = "nix centralized logging disabled";
        mlog( 0, "Sys::Syslog module not installed." )
          if $sysLog && !$sysLogPort;
      }

    if ($CanUseNetSyslog) {
        $ver          = eval('Net::Syslog->VERSION');
        $VerNetSyslog = $ver;
        $ver          = " version $ver" if $ver;
        mlog( 0, "Net::Syslog module$ver installed - network Syslog logging enabled" );
      } elsif ( !$AvailNetSyslog ) {
        $CommentNetSyslog = "network Syslog logging disabled";
        mlog( 0, "Net::Syslog module not installed." )
          if $sysLog && $sysLogPort;
      }

    if ($CanUseWin32Daemon) {
        $ver            = eval('Win32::Daemon->VERSION');
        $VerWin32Daemon = $ver;
        $ver            = " version $ver" if $ver;
        mlog( 0, "Win32::Daemon module$ver installed - can run as Win32 service" );
      }
    if ($CanUseTieRDBM) {
        $ver     = eval('Tie::RDBM->VERSION');
        $VerRDBM = $ver;
        $ver     = " version $ver" if $ver;
        $CommentRDBM = "mysql usage available";
        mlog( 0, "Tie::RDBM module$ver installed - mysql usage available" );
      } elsif ( !$AvailTieRDBM ) {
        $CommentRDBM = "mysql usage not available";
        mlog( 0, "Tie::RDBM module not installed - mysql usage not available" );
      }
    if ($CanMatchCIDR) {
        $ver     = eval('Net::IP::Match::Regexp->VERSION');
        $VerCIDR = $ver;
        $ver     = " version $ver" if $ver;
        $CommentCIDR = "CIDR notation available";
        mlog( 0, "Net::IP::Match::Regexp module$ver installed - CIDR notation for IP range available" );
      } elsif ( !$AvailIPRegexp ) {
        $CommentCIDR = "CIDR notation not available";
        mlog( 0, "Net::IP::Match::Regexp module not installed - CIDR notation for IP range not available" );
      }
    if ($CanUseCIDRlite) {
        $ver         = eval('Net::CIDR::Lite->VERSION');
        $VerCIDRlite = $ver;
        $ver         = " version $ver" if $ver;
        $CommentCIDRlite = "hyphenated IP address range available";
        mlog( 0, "Net::CIDR::Lite module$ver installed - hyphenated IP address range available" );
      } elsif ( !$AvailCIDRlite ) {
        $CommentCIDRlite = "hyphenated IP address range not available";
        mlog( 0, "Net::CIDR::Lite module not installed - hyphenated IP address range not available" );
      }
    if ($CanUseSenderBase) {
        $ver           = eval('Net::SenderBase->VERSION');
        $VerSenderBase = $ver;
        $ver           = " version $ver" if $ver;
        mlog( 0, "Net::SenderBase module$ver installed - countrycode checks available" );
        $CommentSenderBase = "countrycode checks available";
      } elsif ( !$AvailSenderBase ) {
        $CommentSenderBase = "countrycode checks not available";
        mlog( 0, "Net::SenderBase module not installed - countrycode checks not available" );
      }
    if ($CanUseLWP) {
        $ver    = eval('LWP::Simple->VERSION');
        $VerLWP = $ver;
        $ver    = " version $ver" if $ver;
        mlog( 0, "LWP::Simple module$ver installed - griplist available" );
      } elsif ( !$AvailLWP ) {
        $CommentLWP = "download griplist not available";
        mlog( 0, "LWP::Simple module not installed - griplist not available" );
      }
    if ($CanUseEMM) {
        $ver=eval('Email::MIME::Modifier->VERSION'); $VerEMM=$ver; $ver=" version $ver" if $ver;
        mlog(0,"Email::MIME::Modifier module$ver installed - attachment detection available");
		$CommentEMM="attachment detection available";
      } elsif (!$AvailEMM) {
        
        mlog(0,"Email::MIME::Modifier module not installed - attachment detection not available");
		$CommentEMM="attachment detection not available";
      }
     if ($CanUseNetSMTP) {
        $ver=eval('Net::SMTP->VERSION'); $VerNetSMTP=$ver; $ver=" version $ver" if $ver;
        mlog(0,"Net::SMTP module$ver installed - Verify Recipients available");
        $CommentNetSMTP="Verify Recipients available";
      } elsif (!$AvailNetSMTP) {
        $CommentNetSMTP="Verify Recipients not available";
        mlog(0,"Net::SMTP module not installed - Verify Recipients not available");
      }




    $readable = new IO::Select();
    $writable = new IO::Select();

    $lsn        = newListen( $listenPort,   \&NewSMTPConnection );
    $WebSocket  = newListen( $webAdminPort, \&NewWebConnection );
    $StatSocket = newListen( $webStatPort,  \&NewStatConnection );
    mlog( 0, "listening for SMTP connections on $listenPort" ) if $lsn;
    mlog( 0, "listening for ADMIN http connections on $webAdminPort" ) if $WebSocket;
    mlog( 0, "listening for STATISTICS  http connections on $webStatPort" ) if $StatSocket;
    mlog( 0, "NOT listening for SMTP connections on $listenPort" ) if !$lsn;
    mlog( 0, "NOT listening for ADMIN http connections on $webAdminPort" ) if !$WebSocket;
    mlog( 0, "NOT listening for STATISTICS http connections on $webStatPort" ) if !$StatSocket;
    if ($listenPort2) {
        $lsn2 = newListen( $listenPort2, \&NewSMTPConnection );
        mlog( 0, "listening for additional SMTP connections on $listenPort2" ) if $lsn2;
        mlog( 0, "NOT listening for additional SMTP connections on $listenPort2" ) if !$lsn2;
      }

    # handle the possible relayhost / smarthost option
    if ( $relayHost && $relayPort ) {

        $Relay = newListen( $relayPort, \&NewSMTPConnection );
        mlog( 0, "listening for SMTP relay connections on $relayPort" ) if $Relay;
        mlog( 0, "NOT listening for SMTP relay connections on $relayPort" ) if !$Relay;
      }

    $nextNoop         	= 	time;
    $endtime          	= 	$nextNoop + $RestartEvery;
    $saveWhite        	= 	$nextNoop + $UpdateWhitelist;
    $nextCleanDelayDB 	= 	$nextNoop + $CleanDelayDBInterval;
    $nextCleanPB      	= 	$nextNoop + $CleanPBInterval * 3600;
    $nextCleanCache   	= 	$nextNoop + $CleanCacheEvery * 3600;
    $nextExport       	= 	$nextNoop + $exportInterval * 3600;
    $nextConCheck     	= 	$nextNoop + 60;
    $nextLDAPcrossCheck	=	$nextNoop + $LDAPcrossCheckInterval * 3600;

    $SIG{INT} = sub {
        mlog( 0, "sig INT" );
        &SaveWhitelist;
        kill 6, $$ if $ENV{windir};
        RemovePid();
        exit;
    };
    $SIG{TERM} = sub { mlog( 0, "sig TERM" ); &SaveWhitelist; RemovePid(); exit; };

    my ( $uid, $gid ) = getUidGid( $runAsUser, $runAsGroup )
      if ( $runAsUser || $runAsGroup );
    if ($ChangeRoot) {
        my $chroot;
        eval('$chroot=chroot($ChangeRoot)');
        if ($@) {
            my $msg = "request to change root to '$ChangeRoot' failed: $@";
            mlog( '', $msg );
            die ucfirst($msg);
          } elsif ( !$chroot ) {
            my $msg = "request to change root to '$ChangeRoot' did not succeed: $!";
            mlog( '', $msg );
            die ucfirst($msg);
          } else {
            $chroot = $ChangeRoot;
            $chroot =~ s/(\W)/\\$1/g;
            $base   =~ s/^$chroot//i;
            chdir("/");
            mlog( '', "successfully changed root to '$ChangeRoot' -- new base is '$base'" );
          }
      }

    switchUsers( $uid, $gid ) if ( $runAsUser || $runAsGroup );
    $mypid = $$;

    chmod 0775, "$base/assp.cfg";
    &renderConfigHTML();
    if ($pidfile) { open( F, ">$base/$pidfile" ); print F $$; close F; }

    # create folders if they're missing
    -d "$base/$spamlog"        or mkdir "$base/$spamlog",        0777;
    -d "$base/$notspamlog"     or mkdir "$base/$notspamlog",     0777;
    -d "$base/$incomingOkMail" or mkdir "$base/$incomingOkMail", 0775;
    -d "$base/$viruslog"       or mkdir "$base/$viruslog",       0700;
    -d "$base/files"           or mkdir "$base/files",           0770;
    -d "$base/logs"            or mkdir "$base/logs",            0777;

    my $dir = $correctedspam;
    $dir =~ s/\/.*?$//;
    -d "$base/$dir"              or mkdir "$base/$dir",              0700;
    -d "$base/$correctedspam"    or mkdir "$base/$correctedspam",    0777;
    -d "$base/$correctednotspam" or mkdir "$base/$correctednotspam", 0777;
    $pbdir = $1 if $pbdb =~ /(.*)\/.*/;
    if ($pbdir) {
       -d  "$base/$pbdir" or mkdir "$base/$pbdir",0700;
       -d  "$base/$pbdir/global" or mkdir "$base/$pbdir/global",0777;
       -d  "$base/$pbdir/global/in" or mkdir "$base/$pbdir/global/in",0777;
       -d  "$base/$pbdir/global/out" or mkdir "$base/$pbdir/global/out",0777;
    }
    -d "$base/notes" or mkdir "$base/notes", 0777;
    -d "$base/docs"  or mkdir "$base/docs",  0777;



    # put this after chroot so the paths don't change
    $SpamdbObject = tie %Spamdb, 'orderedtie', "$base/$spamdb" if $spamdb;
    mlog( 0, "warning: Bayesian spam database is small or empty: '$base/$spamdb'" )
      if $spamdb && -s "$base/$spamdb" < 10000;
    $HeloBlackObject = tie %HeloBlack, 'orderedtie', "$base/$spamdb.helo"
      if $spamdb;
    $DnsblObject = tie %Dnsbl, 'orderedtie', "$base/$dnsbl" if $dnsbl;
    mlog( 0, "warning: DNS blacklist database is small or empty: '$base/$dnsbl'" )
      if $dnsbl && -s "$base/$dnsbl" < 10000;
    if ( $CanUseTieRDBM && $whitelistdb =~ /mysql/ ) {
        eval {
            $WhitelistObject = tie %Whitelist, 'Tie::RDBM', "dbi:mysql:database=$mydb;host=$myhost",
              {
                user     => "$myuser",
                password => "$mypassword",
                table    => 'whitelist',
                create   => 1
              };
        };
        if ($@) {
            mlog( 0, "whitelist mysql error: $@" );
            $CanUseTieRDBM = 0;
            $whitelistdb   = "whitelist";
          }
      } else {
        $WhitelistObject = tie %Whitelist, 'orderedtie', "$base/$whitelistdb";
        mlog( 0, "warning: whitelist is small or empty: '$base/$whitelistdb' (ignore if this is a new install)" )
          if $whitelistdb && -s "$base/$whitelistdb" < 1000;
      }

    if ( $CanUseTieRDBM && $redlistdb =~ /mysql/ ) {
        eval {
            $RedlistObject = tie %Redlist, 'Tie::RDBM', "dbi:mysql:database=$mydb;host=$myhost",
              {
                user     => "$myuser",
                password => "$mypassword",
                table    => 'redlist',
                create   => 1
              };
        };
        if ($@) {
            mlog( 0, "redlist mysql error: $@" );
            $CanUseTieRDBM = 0;
            $redlistdb     = "redlist";
          }
      } else {
        $RedlistObject = tie %Redlist, 'orderedtie', "$base/$redlistdb";
      }
    $GriplistObject = tie %Griplist, 'orderedtie', "$base/$griplist"
      if $griplist;

    $PBWhiteObject    = tie %PBWhite,    'orderedtie', "$base/$pbdb.white.db";
    $PBBlackObject    = tie %PBBlack,    'orderedtie', "$base/$pbdb.black.db";
    $RBLCacheObject   = tie %RBLCache,   'orderedtie', "$base/$pbdb.rbl.db";
    $URIBLCacheObject = tie %URIBLCache, 'orderedtie', "$base/$pbdb.uribl.db";
    $PTRCacheObject   = tie %PTRCache,   'orderedtie', "$base/$pbdb.ptr.db";
    $MXACacheObject   = tie %MXACache,   'orderedtie', "$base/$pbdb.mxa.db";
    $RWLCacheObject   = tie %RWLCache,   'orderedtie', "$base/$pbdb.rwl.db";
    $SPFCacheObject   = tie %SPFCache,   'orderedtie', "$base/$pbdb.spf.db";
    $SBCacheObject    = tie %SBCache,    'orderedtie', "$base/$pbdb.sb.db";
    $PBTrapObject     = tie %PBTrap,     'orderedtie', "$base/$pbdb.trap.db";
    $BackDNSObject    = tie %BackDNS,    'orderedtie', "$base/$pbdb.back.db";
    $LDAPObject    	  = tie %LDAPlist,   'orderedtie', "$base/$ldaplistdb";
    if ( $CanUseTieRDBM && $delaydb =~ /mysql/ ) {
        eval {
            $DelayWhiteObject = tie %DelayWhite, 'Tie::RDBM', "dbi:mysql:database=$mydb;host=$myhost",
              {
                user     => "$myuser",
                password => "$mypassword",
                table    => 'delaywhitedb',
                create   => 1
              };
            $DelayObject = tie %Delay, 'Tie::RDBM', "dbi:mysql:database=$mydb;host=$myhost",
              {
                user     => "$myuser",
                password => "$mypassword",
                table    => 'delaydb',
                create   => 1
              };
        };
        if ($@) {
            mlog( 0, "delaydb mysql error: $@" );
            $CanUseTieRDBM = 0;
            $delaydb       = "delaydb";
          }

      } else {
        $DelayObject      = tie %Delay,      'orderedtie', "$base/$delaydb";
        $DelayWhiteObject = tie %DelayWhite, 'orderedtie', "$base/$delaydb.white";
      }
    $shuttingDown = $doShutdown = 0;
    $smtpConcurrentSessions = 0;
    $Stats{starttime}       = time;
    $Stats{version}         = "$version$modversion";
    &ResetStats;
    mlog( 0, "starting PID: $$" );
  }
  
sub newListen {
    my ( $port, $handler ) = @_;
    my $s;
    if ( $port =~ /|/ ) {
        my ( $interface, $p, $s );
        foreach my $portA ( split( /\|/, $port ) ) {
            ( $interface, $p ) = $portA =~ /(.*):(.*)/;

            if ($interface) {
                $s = new IO::Socket::INET(
                    Listen    => 10,
                    LocalPort => $p,
                    Reuse     => 1,
                    LocalAddr => $interface
                );
              } else {
                $s = new IO::Socket::INET(
                    Listen    => 10,
                    LocalPort => $portA,
                    Reuse     => 1
                );
              }
            if ( !$s ) {
                mlog( '',
"couldn't create server socket on port '$portA' -- maybe another service is running or I'm not root (uid=$>)?"
                );
                return undef;
              }
            $SocketCalls{$s} = $handler;
            $readable->add($s);    # add to select list

          }
        $s;
      } else {
        my ( $interface, $p ) = $port =~ /(.*):(.*)/;
        my $s;
        if ($interface) {
            $s = new IO::Socket::INET(
                Listen    => 10,
                LocalPort => $p,
                Reuse     => 1,
                LocalAddr => $interface
            );
          } else {
            $s = new IO::Socket::INET(
                Listen    => 10,
                LocalPort => $port,
                Reuse     => 1
            );
          }
        if ( !$s ) {
            mlog( '',
"couldn't create server socket on port '$port' -- maybe another service is running or I'm not root (uid=$>)?"
            );
            return undef;
          }
        $SocketCalls{$s} = $handler;
        $readable->add($s);    # add to select list
        $s;
      }
  }

sub getUidGid {
    my ( $uname, $gname ) = @_;
    return if $AsAService;
    my $rname = "root";
    eval('getgrnam($rname);getpwnam($rname);');
    if ($@) {

        # windows pukes "unimplemented" for these -- just skip it
        mlog( '', "warning: uname and/or gname are set ($uname,$gname) but getgrnam / getpwnam give errors: $@" );
        return;
      }
    my $gid;
    if ($gname) {
        $gid = getgrnam($gname);
        if ( defined $gid ) {
          } else {
            my $msg = "could not find gid for group '$gname' -- not switching effective gid -- quitting";
            mlog( '', $msg );
            die ucfirst($msg);
          }
      }
    my $uid;
    if ($uname) {
        $uid = getpwnam($uname);
        if ( defined $uid ) {
          } else {
            my $msg = "could not find uid for user '$uname' -- not switching effective uid -- quitting";
            mlog( '', $msg );
            die ucfirst($msg);
          }
      }
    ( $uid, $gid );
  }

sub switchUsers {
    my ( $uid, $gid ) = @_;
    return if $AsAService;
    my ( $uname, $gname ) = ( $runAsUser, $runAsGroup );
    $> = 0;
    if ( $> != 0 ) {
        my $msg =
          "requested to switch to user/group '$uname/$gname' but cannot set effective uid to 0 -- quitting; uid is $>";
        mlog( '', $msg );
        die ucfirst($msg);
      }
    $< = 0;
    if ($gid) {
        $) = $gid;
        if ( $) + 0 == $gid ) {
            mlog( '', "switched effective gid to $gid ($gname)" );
          } else {
            my $msg = "failed to switch effective gid to $gid ($gname) -- effective gid=$) -- quitting";
            mlog( '', $msg );
            die ucfirst($msg);
          }
        $( = $gid;
        if ( $( + 0 == $gid ) {
            mlog( '', "switched real gid to $gid ($gname)" );
          } else {
            mlog( '', "failed to switch real gid to $gid ($gname) -- real uid=$(" );
          }
      }
    if ($uid) {

        # do it both ways so linux and bsd are happy
        $< = $> = $uid;
        if ( $> == $uid ) {
            mlog( '', "switched effective uid to $uid ($uname)" );
          } else {
            my $msg = "failed to switch effective uid to $uid ($uname) -- real uid=$< -- quitting";
            mlog( '', $msg );
            die ucfirst($msg);
          }
        if ( $< == $uid ) {
            mlog( '', "switched real uid to $uid ($uname)" );
          } else {
            mlog( '', "failed to switch real uid to $uid ($uname) -- real uid=$<" );
          }
      }
  }

sub MainLoop {
    my $wait = 5;    # keep it short enough for servicecheck to be called regularly
    my $stime = $CanStatCPU ? ( Time::HiRes::time() ) : time;    # loop cycle start time
    my ( $canread, $canwrite ) = IO::Select->select( $readable, $writable, undef, $wait );
    my $itime = $CanStatCPU ? ( Time::HiRes::time() ) : time;    # loop cycle idle end time
    $webTime   = 0;                                              # loop cycle web time interval, global var
    $nextLoop2 = $itime + 1;                                     # global var
    foreach my $fh (@$canwrite) {
        my $l = length( $Con{$fh}->{outgoing} );
        d("$fh $Con{$fh} l=$l");
        if ($l) {
            my $written = syswrite( $fh, $Con{$fh}->{outgoing}, $OutgoingBufSizeNew );
            if ($DEBUG) {
                if ( $written <= 200 ) {
                    d( "wrote: ($written)<" . substr( $Con{$fh}->{outgoing}, 0, $written ) . ">" );
                  } else {
                    d("wrote: ($written)<long text>");
                  }
              }
            $Con{$fh}->{outgoing} = substr( $Con{$fh}->{outgoing}, $written );
            $l = length( $Con{$fh}->{outgoing} );

            # test for highwater mark
            if (   $written > 0
                && $l < $OutgoingBufSizeNew
                && $Con{$fh}->{paused} ) {
                $Con{$fh}->{paused} = 0;
                $readable->add( $Con{$fh}->{friend} );
              }
          }
        if ( length( $Con{$fh}->{outgoing} ) == 0 ) {
            $writable->remove($fh);
          }
      }
    foreach my $fh (@$canread) {
        if ( $fh && $SocketCalls{$fh} ) {
            if (
                $CanStatCPU
                && (   $SocketCalls{$fh} == \&WebTraffic
                    || $SocketCalls{$fh} == \&NewWebConnection
                    || $SocketCalls{$fh} == \&NewStatConnection )
              ) {

                # calculate time spent serving web request
                $webTime -= Time::HiRes::time();
                $SocketCalls{$fh}->($fh);
                $webTime += Time::HiRes::time();
              } else {
                $SocketCalls{$fh}->($fh);
              }
          } else { 
        	  	my $ip; 
  				my $port; 
  				eval{ 
    			$ip=$fh->peerhost(); 
    			$port=$fh->peerport(); 
  				} if (fileno($fh)); 

        	eval{ 
          	delete $SocketCalls{$fh} if (exists $SocketCalls{$fh}); 
          	delete $WebCon{$fh} if (exists $WebCon{$fh}); 
         	$readable->remove($fh); 
          	$writable->remove($fh); 
          	eval{$fh->close} if (fileno($fh)); 
        	};
			delete $Con{$fh} if exists $Con{$fh} ; 
    	} 
      }
    if ( $smtpIdleTimeout > 0 ) {
        if ( %Con > 0 ) {
            my $tmpNow = time();

            # Check timeouts only every 5 seconds at least
            if ( $tmpNow > ( $lastTimeoutCheck + 15 ) ) {
                foreach my $tmpfh ( keys %Con ) {
                    if (   $Con{$tmpfh}->{type} eq 'C'
                        && $Con{$tmpfh}->{timelast} > 0
                        && ( ( $tmpNow - $Con{$tmpfh}->{timelast} ) > $smtpIdleTimeout ) ) {
                        $Con{$tmpfh}->{prepend} = "";
                        mlog( $tmpfh, "Connection idle for $smtpIdleTimeout secs - timeout", 1 ) if $SessionLog;
                        $Stats{smtpConnIdleTimeout}++;
                        seterror( $Con{$tmpfh}->{client}, "451 Connection timeout, try later", 1 );
                      }
                  }
                $lastTimeoutCheck = $tmpNow;
              }
          }
      }
    d(6);
    serviceCheck();    # for win32 services

    # timer related issues
    # if(abs(($itime - $stime) - $wait) <= 1.0) {
    # noactive connections -- check for maintenance
    d(8);

    if ( $UpdateWhitelist && $itime >= $saveWhite ) {
        d(9);
        &SaveWhitelistOnly;
        $saveWhite = int($itime) + $UpdateWhitelist;
      }
    if ( $CleanDelayDBInterval && $itime >= $nextCleanDelayDB ) {
        &DoCleanDelayDB;
        $nextCleanDelayDB = int($itime) + $CleanDelayDBInterval;
      }
    if ( $exportInterval && $itime >= $nextExport ) {
        &exportExtreme;
        $nextExport = int($itime) + $exportInterval * 3600;
      }
    if ( $CleanPBInterval && $itime >= $nextCleanPB ) {
        &CleanPB;

        $nextCleanPB = int($itime) + $CleanPBInterval * 3600;
      }
    if ( $CleanCacheEvery && $itime >= $nextCleanCache ) {
        &CleanCache;
        $nextCleanCache = int($itime) + $CleanCacheEvery * 3600;
      }
	if ($CanUseLDAP && $ldaplistdb && $LDAPcrossCheckInterval && $itime >= $nextLDAPcrossCheck) {
        &LDAPcrossCheck;
        $nextLDAPcrossCheck=int($itime)+$LDAPcrossCheckInterval * 3600;
    }
    if ( $RestartEvery && $itime >= $endtime ) {

        # time to quit -- after endtime and we're bored.
        $opencon = ( keys %Con );
        if ( $opencon == 0 ) {
            &SaveWhitelist;
            &SaveStats;
            mlog( 0, "restarting" );
            if($AsAService) {
          		exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
        	} elsif ($AsAService) {
          		exit 1;
        	} else {
          		exec($AutoRestartCmd) if $AutoRestart;
          		exit 1;
        	}
          }
      }
    SaveStats() if ( $SaveStatsEvery && $itime >= $NextSaveStats );
    uploadStats() if ( $totalizeSpamStats && $itime >= $Stats{nextUpload} );
    downloadGrip()
      if (!$noGriplistDownload
        && $griplist
        && $itime >= $NextGriplistDownload );

    #}
    if ($CanStatCPU) {

        #
        # cycleTime = cpuTime + webTime
        # cpuTime = cpuIdleTime + cpuBusyTime
        #
        my $ctime       = Time::HiRes::time();       # loop cycle end time
        my $cycleTime   = $ctime - $stime;
        my $cpuTime     = $cycleTime - $webTime;
        my $cpuIdleTime = $itime - $stime;
        my $cpuBusyTime = $cpuTime - $cpuIdleTime;
        $Stats{cpuTime}     += $cpuTime;
        $Stats{cpuBusyTime} += $cpuBusyTime;

        # envelope following filter with instant rise and decay time of 1 second
        my $lusage = $cpuUsage * exp( -( 0.693 / 1 ) * $cycleTime );
        my $usage = ( $cpuTime == 0 ? 0 : $cpuBusyTime / $cpuTime );
        $cpuUsage = $usage > $lusage ? $usage : $lusage;
      }
  if ( $doShutdown && $itime >= $doShutdown ) {
        &SaveWhitelist;
        &SaveStats;
        mlog( 0, "restarting" );
        if($AsAService) {
          		exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
        	} elsif ($AsAService) {
          		exit 1;
        	} else {
          		exec($AutoRestartCmd) if $AutoRestart;
          		exit 1;
        	}
      }
    if (time > $nextdetectGhostCon) {
        &detectGhostCon();
        updateDNS( 'DNSServers', $Config{DNSServers}, $Config{DNSServers}, '' );
        $nextdetectGhostCon = time + 600;
    }
  }
d(11);
# Never reached...(we hope)

# called during long operations to keep processing priority data
# alternates (1s/1s) between SMTP connections handling and the calling task
sub MainLoop2 {
    my $time = $AvailHiRes ? ( Time::HiRes::time() ) : time;
    if ( $time >= $nextLoop2 ) {
        $webTime += $time if $CanStatCPU;
        $nextLoop2 = $time + 1;    # 1s for SMTP stuff
        serviceCheck();            # for win32 services
        SaveStats() if ( $SaveStatsEvery && $itime >= $NextSaveStats );
        my ( $canread, $canwrite );
        do {
            ( $canread, $canwrite ) = IO::Select->select( $readable, $writable, undef, 0 );
            foreach my $fh (@$canwrite) {
                my $l = length( $Con{$fh}->{outgoing} );
                d("$fh $Con{$fh} l=$l");
                if ($l) {
                    my $written = syswrite( $fh, $Con{$fh}->{outgoing}, $OutgoingBufSizeNew );
                    if ($DEBUG) {
                        if ( $written <= 200 ) {
                            d( "wrote: ($written)<" . substr( $Con{$fh}->{outgoing}, 0, $written ) . ">" );
                          } else {
                            d("wrote: ($written)<long text>");
                          }
                      }
                    $Con{$fh}->{outgoing} = substr( $Con{$fh}->{outgoing}, $written );
                    $l = length( $Con{$fh}->{outgoing} );

                    # test for highwater mark
                    if (   $written > 0
                        && $l < $OutgoingBufSizeNew
                        && $Con{$fh}->{paused} ) {
                        $Con{$fh}->{paused} = 0;
                        $readable->add( $Con{$fh}->{friend} );
                      }
                  }
                if ( length( $Con{$fh}->{outgoing} ) == 0 ) {
                    $writable->remove($fh);
                  }
              }
            foreach my $fh (@$canread) {
                if (
                    $fh
                    && (   $SocketCalls{$fh} == \&SMTPTraffic
                        || $SocketCalls{$fh} == \&NewSMTPConnection
                        || $SocketCalls{$fh} == \&WebTraffic
                        || $SocketCalls{$fh} == \&NewWebConnection
                        || $SocketCalls{$fh} == \&NewStatConnection )
                  ) {
                    $SocketCalls{$fh}->($fh);
                  }
              }
            $time = $AvailHiRes ? ( Time::HiRes::time() ) : time;
        } until ( ( @$canread == 0 && @$canwrite == 0 ) || $time >= $nextLoop2 );
        $nextLoop2 = $time + 1;    # 1s for other tasks
        $webTime -= $time if $CanStatCPU;
         if($RestartEvery && $itime >= $endtime) {
# time to quit -- after endtime and we're bored.
        &SaveWhitelist;
        &SavePB;
        &SaveStats;
        mlog(0,"restarting");
   
        if($AsAService) {
          exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
        } elsif ($AsADaemon) {
          exit 1;
        } else {
          exec($AutoRestartCmd) if $AutoRestart;
          exit 1;
        }
    }

    if ($doShutdown && $itime >= $doShutdown) {
      &SaveWhitelist;
      &SavePB;
      &SaveStats;
      mlog(0,"restarting");
   
      if($AsAService) {
        exec('cmd.exe /C net stop ASSPSMTP & net start ASSPSMTP');
      } elsif ($AsADaemon) {
        exit 1;
      } else {
        exec($AutoRestartCmd) if $AutoRestart;
        exit 1;
      }
    }
      }
  }
  
sub detectGhostCon {
    my $count = 0;
    my $mem = 0;
    foreach my $fh (keys %Con) {
        next if (fileno($fh));
        next if ($Con{$fh}->{timestart} + 3600 > time);
        my $this = $Con{$fh};
        foreach (keys %$this) {
            eval{$mem = $mem + length($this->{$_}) + 8;};
        }
        $mem = int($mem/1024 + 2);
        &printallCon($fh) if ($MaintenanceLog == 2);
        $count++;
        &done2($fh);
    }

}

sub SaveWhitelistOnly {

    if ( $UpdateWhitelist && $whitelistdb !~ /mysql/ ) {
        mlog( 0, "saving whitelist" ) if $MaintenanceLog;
        $WhitelistObject->flush() if $WhitelistObject;
      }
    if ( $UpdateWhitelist && $redlistdb !~ /mysql/ ) {
        mlog( 0, "saving redlist" ) if $MaintenanceLog;
        $RedlistObject->flush() if $RedlistObject;
      }


  }
  
sub SaveLDAPlist {

    mlog(0,"saving ldap records") if $MaintenanceLog;
    $LDAPObject->flush()      if $LDAPObject;

}

  
sub SaveWhitelist {
    d(35);

	&SaveWhitelistOnly;
	
    if ( $delaydb !~ /mysql/ ) {
        mlog( 0, "saving delaying records" ) if $MaintenanceLog;
        $DelayObject->flush()      if $DelayObject;
        $DelayWhiteObject->flush() if $DelayWhiteObject;
      }
      
      &SavePB;

  }

sub SavePB {
		mlog( 0, "saving penalty records" ) if $MaintenanceLog;
		$PBBlackObject->flush() if $PBBlackObject && $pbdb !~ /mysql/;
		MainLoop2();
		$PBWhiteObject->flush() if $PBWhiteObject && $pbdb !~ /mysql/;
    	MainLoop2();
    	$PBTrapObject->flush() if $PBTrapObject;
    	MainLoop2();
    	mlog( 0, "saving cache records" ) if $MaintenanceLog;
        $RBLCacheObject->flush() if $RBLCacheObject;
        MainLoop2();
        $URIBLCacheObject->flush() if $URIBLCacheObject;
        MainLoop2();
        $SPFCacheObject->flush() if $SPFCacheObject;
        MainLoop2();

        $PTRCacheObject->flush() if $PTRCacheObject;
        MainLoop2();
        $MXACacheObject->flush() if $MXACacheObject;
        MainLoop2();
        $SBCacheObject->flush() if $SBCacheObject;
        MainLoop2();
        $RWLCacheObject->flush() if $RWLCacheObject;
        MainLoop2();
        $BackDNSObject->flush() if $BackDNSObject;
   
  }

sub CleanPB {

    # clean PenaltyBox Databases

    mlog( 0, "cleaning up penalty records ..." ) if $MaintenanceLog;
    &cleanBlackPB if $PBBlackObject;
    MainLoop2();
    $PBBlackObject->flush() if $PBBlackObject && $pbdb !~ /mysql/;
    MainLoop2();
    &cleanWhitePB if $PBWhiteObject;
    MainLoop2();
    $PBWhiteObject->flush() if $PBWhiteObject && $pbdb !~ /mysql/;
    MainLoop2();
    &cleanTrapPB if $PBTrapObject;
    MainLoop2();
    $PBTrapObject->flush() if $PBTrapObject;


  }

sub CleanCache {
	mlog( 0, "cleaning up cache records ..." ) if $MaintenanceLog;
    &cleanCacheRBL if $RBLCacheExp;
    MainLoop2();
    $RBLCacheObject->flush() if $RBLCacheObject;
    MainLoop2();
    &cleanCacheURI if $URIBLCacheExp;
    MainLoop2();
    $URIBLCacheObject->flush() if $URIBLCacheObject;
    MainLoop2();
    &cleanCacheRWL if $RWLCacheExp;
    MainLoop2();
    $RWLCacheObject->flush() if $RWLCacheObject;
    MainLoop2();
    &cleanCachePTR if $PTRCacheInterval;
    MainLoop2();
    $PTRCacheObject->flush() if $PTRCacheObject;
    MainLoop2();
    &cleanCacheMXA if $MXACacheInterval;
    MainLoop2();
    $MXACacheObject->flush() if $MXACacheObject;
    MainLoop2();
    &cleanCacheSPF if $SPFCacheInterval;
    MainLoop2();
    $SPFCacheObject->flush() if $SPFCacheObject;
    MainLoop2();
    &cleanCacheSB if $SBCacheInterval;
    MainLoop2();
	$SBCacheObject->flush() if $SBCacheObject;
    MainLoop2();
    &cleanCacheBackDNS if $BackDNSInterval;
    MainLoop2();
    $BackDNSObject->flush() if $BackDNSObject;

  }

sub DoCleanDelayDB {
    mlog( 0, "cleaning up delaying databases ..." ) if $MaintenanceLog;
    my $t = time;
    my $keys_before = $keys_deleted = 0;
    while ( my ( $k, $v ) = each(%Delay) ) {
        $keys_before++;
        if ( $t - $v >= $DelayEmbargoTime * 60 + $DelayWaitTime * 3600 ) {
            delete $Delay{$k};
            $keys_deleted++;
          }
        MainLoop2();
      }
    mlog( 0, "cleaning delaying database (triplets) finished; keys before=$keys_before, deleted=$keys_deleted" )
      if $MaintenanceLog;
    $keys_before = $keys_deleted = 0;
    while ( my ( $k, $v ) = each(%DelayWhite) ) {
        $keys_before++;
        if ( $t - $v >= $DelayExpiryTime * 24 * 3600 ) {
            delete $DelayWhite{$k};
            $keys_deleted++;
          }
        MainLoop2();
      }
    mlog( 0,
        "cleaning delaying database (safelisted tuplets) finished; keys before=$keys_before, deleted=$keys_deleted" )
      if $MaintenanceLog;
    $DomainCache ||= '^(?!)';
  }

sub mlogRe {

    my ( $fh, $subre, $regextype, $check ) = @_;
    my $this = $Con{$fh};
    $subre =~ s/\s+/ /g;
    $subre = substr( $subre, 0, $RegExLength );
    $this->{messagereason} = "Regex:$regextype '$subre'";
    $this->{myheader} .= "X-Assp-Re-$regextype: $subre\r\n" if $AddRegexHeader;
    my $m = "";
    $m = $check . " " if $check;
    $m .= "Regex:$regextype '$subre'";
    mlog( $fh, $m, 1, 1 ) if $regexLogging;
  }

# win32 debug/trace output
sub w32dbg {
  if ($AvailWin32Debug) {
    my ($msg) = @_;
    OutputDebugString("(ASSP): $msg");
  }
}

sub dlog {
    my ($msg) = @_;

    return unless $DebugLog;
    print "$msg\n";
    print LOG "$msg\n";
    w32dbg("(DEBUG): $msg");
  }

sub mlog {
    my ( $fh, $comment, $noprepend, $noipinfo ) = @_;
    my $this = $fh ? $Con{$fh} : 0;
    my $mm;
    my $lccomment = lc $comment;

    PrintConfigHistory($lccomment) if $lccomment =~ /^adminupdate/i;
    PrintConfigHistory($lccomment) if $lccomment =~ /^configerror/i;
    PrintAdminInfo($lccomment)     if $lccomment =~ /^admininfo/i;
    PrintAdminInfo($lccomment)     if $lccomment =~ /^email: /i;

    if (
        $this && $noLogRe
        && (   ( $this->{mailfrom} && $this->{mailfrom} =~ ( '(' . $noLogReRE . ')' ) )
            || ( $this->{header} =~ ( '(' . $noLogReRE . ')' ) ) )
      ) {
        return 1;
      }

    d(34);
    my $m = localtime();
    $m =~ s/^... (...) +(\d+) (\S+) ..(..)/$1-$2-$4 $3/;
    my ( $sec, $min, $hour, $mday, $mon, $year ) = localtime(time);

    if ( $LogRollDays > 0 ) {

        # roll log every $LogRollDays days, at midnight
        my $t =
          int( ( time() + Time::Local::timelocal( localtime() ) - Time::Local::timelocal( gmtime() ) ) /
              ( $LogRollDays * 24 * 3600 ) );

        if (   $logfile
            && $mlogLastT
            && $t != $mlogLastT
            && $logfile ne "maillog.log"
            && $asspLog ) {

            # roll the log
            my $backt = time - 7200;
            my ( $sec, $min, $hour, $mday, $mon, $year ) = localtime($backt);

            $mon++;
            $year -= 100;
            $mm = sprintf( "%02d-%02d-%02d", $year, $mon, $mday )
              if !$LogNameMMDD;
            $mm = sprintf( "%02d-%02d", $mon, $mday ) if $LogNameMMDD;
            my ( $logdir, $logdirfile ) = ( $1, $2 )
              if $logfile =~ /^(.*)[\/\\](.*?)$/;
            if ( !$logdir ) {
                $archivelogfile = "$mm.$logfile";
              } else {
                mkdir "$base/$logdir", 0700;
                $archivelogfile = "$logdir/$mm.$logdirfile";
              }
            my $msg = "$m: Rolling log file -- archive saved as '$archivelogfile'\n";
            print LOG $msg;
            print $msg unless $silent;
            w32dbg("$m: Rolling log file -- archive saved as '$archivelogfile'");

            close LOG;
            rename( "$base/$logfile", "$base/$archivelogfile" );
            if ( open( LOG, ">>$base/$logfile" ) ) {
                my $oldfh = select(LOG);
                $| = 1;
                select($oldfh);
              }
            print LOG "$m new log file -- old log file renamed to '$archivelogfile'\n";
            w32dbg("$m new log file -- old log file renamed to '$archivelogfile'");
          }
        $mlogLastT = $t;
      }

    if ($this) {
        $m .= " $this->{msgtime}" if $this->{msgtime};
        $m .= " $this->{prepend}"
          if $tagLogging && $this->{prepend} && !$noprepend;

        if (   $expandedLogging
            || $noipinfo == 2
            || $m =~ /\[/
            || !$this->{loggedIpFromTo} && !$noipinfo ) {
            $m .= " $this->{ip} <$this->{mailfrom}>";
            my ($to) = $this->{rcpt} =~ /(\S+)/;
            if ($to) {
                $m .= " to: $to";
                $this->{loggedIpFromTo} = 1;
              }
          }

        $m .= " $comment\n";
      } else {
        $m .= " " . ucfirst($comment) . "\n";
      }

    print DEBUG $m if $DEBUG;

    tosyslog( 'info', substr( $m, 18 ) )
      if ( $CanUseSyslog || $CanUseNetSyslog ) && $sysLog;
    return if ( $fh && $Con{$fh} ) && ( $noLog && $Con{$fh}->{ip} =~ $NLOGRE );

    print $m unless $silent;
    print LOG $m if $logfile && $asspLog;
    w32dbg("$m");
  }

sub tosyslog {
    my ( $priority, $msg ) = @_;
    return 0 unless ( $priority =~ /info|err|debug/ );
    $msg =~ s/^\s+//;

    if ($AvailNetSyslog) {
        my $s = new Net::Syslog(
            Facility   => $SysLogFac,
            Priority   => 'Debug',
            SyslogPort => $sysLogPort,
            SyslogHost => $sysLogIp
        );
        $s->send( $msg, Priority => $priority );
      } else {
        setlogsock('unix');
        openlog( 'assp', 'pid,cons', 'mail' );
        syslog( $priority, $msg );
        closelog();
      }

    return 1;
  }

sub tzStr {

    # calculate the time difference in minutes
    my $minoffset = ( Time::Local::timelocal( localtime() ) - Time::Local::timelocal( gmtime() ) ) / 60;

    # translate it to "hour-format", so that 90 will be 130, and -90 will be -130
    my $sign = $minoffset < 0 ? -1 : +1;
    $minoffset = abs($minoffset) + 0.5;
    my $tzoffset = 0;
    $tzoffset = $sign * ( int( $minoffset / 60 ) * 100 + ( $minoffset % 60 ) )
      if $minoffset;

    # apply final formatting, including +/- sign and 4 digits
    return sprintf( "%+05d", $tzoffset );
  }

sub getTimeDiffAsString {

    my ( $tdiff, $seconds ) = @_;

    my $days  = int( $tdiff / 86400 );
    my $hours = int( ( $tdiff - ( $days * 86400 ) ) / 3600 );
    my $mins  = int( ( $tdiff - ( $days * 86400 ) - ( $hours * 3600 ) ) / 60 );
    my $secs  = int( $tdiff - ( $days * 86400 ) - ( $hours * 3600 ) - ( $mins * 60 ) );

    my $ret;
    $ret = $days . " day" . ( $days == 1 ? " " : "s " );
    $ret .= $hours . " hour" . ( $hours == 1 ? " " : "s " );
    $ret .= $mins . " min" .   ( $mins == 1  ? " " : "s " );
    $ret .= $secs . " sec" .   ( $secs == 1  ? " " : "s " ) if $seconds;

    return $ret;
  }

sub getTimeDiff {
	my ($tdiff,$seconds) = @_;
        my $m = getTimeDiffAsString($tdiff,$seconds);
        if ($m =~ s/^0 days //) {
            if ($m =~ s/^0 hours //) {
            }
        }
        return $m;
}

#####################################################################################
#                Socket handlers
sub NewSMTPConnection {
    my $fh   = shift;
    my $this = $Con{$fh};
    my ( $client, $server, $destination, $relayok );
    $this->{destination} = 0;
    if ( $fh == $Relay ) {

        # a relay connection -- destination is the relayhost
        d(101);
        $relayok     = 1;
        $destination = $relayHost;
      } elsif ( $fh == $lsn2 && $smtpAuthServer ne '' ) {

        # connection on the Second Listen port
        d(1001);
        $relayok     = 1;
        $destination = $smtpAuthServer;
      } else {
        d(1);
        $this->{destination} = 1;
        $destination         = $smtpDestination;
        $relayok             = 0;
      }
    if ( !( $client = $fh->accept ) ) {
        d("accept failed: $fh");
        d(106);
        return;
      }
    $Con{$client}->{relayok} = $relayok;
    my $ip        = $client->peerhost();
    my $port      = $client->peerport();
    my $localip   = $client->sockhost();
    my $localport = $client->sockport();
    my $ret;

    # shutting down ?
    if ($shuttingDown) {
        mlog( 0, "connection from $ip:$port rejected -- shutdown/restart process is in progress" );

        $client->write("421 <$myName> Service temparary not available, closing transmission channel\r\n");
        $client->close();
        d(105);
        return;
      }
    $ret = matchIP( $ip, 'denySMTPConnectionsFromAlways', $fh ) if $denySMTPstrictEarly;
  

    if ($denySMTPstrictEarly && $ret && $DoDenySMTPstrict == 1 && !matchIP( $ip, 'noPB', 0, 1 ) ) {
        $this->{prepend} = "[DenyStrict]";
        mlog( $fh, "$ip:$port denied by denySMTPConnections strict: $ret" )
          if $denySMTPLog || $ConnectionLog == 2;
        $Stats{denyConnectionA}++;
        $client->write("554 <$myName> Service denied, closing transmission channel\r\n");
        $client->close();
    
        return;
      }
    if ($denySMTPstrictEarly && $ret && $DoDenySMTPstrict == 2 && !matchIP( $ip, 'noPB', 0, 1 ) ) {
        $this->{prepend} = "[DenyStrict]";
        mlog( $fh, "[monitoring] $ip:$port denied by denySMTPConnections strict: $ret" )
          if $denySMTPLog || $ConnectionLog == 2;
      }

    # ip connection limiting  parallel session
    $maxSMTPipSessions = 999 if ( !$maxSMTPipSessions );
    if (   $maxSMTPipSessions
        && !matchIP( $ip, 'noPB',            0, 1 )
        && !matchIP( $ip, 'noProcessingIPs', 0, 1 )
        && !matchIP( $ip, 'whiteListedIPs',  0, 1 )
        && !matchIP( $ip, 'noDelay',         0, 1 )
        && !matchIP( $ip, 'ispip',           0, 1 )
        && !matchIP( $ip, 'acceptAllMail',   0, 1 ) ) {
        $SMTPSession{$ip}++;
        if ( $SMTPSession{$ip} > $maxSMTPipSessions ) {
            $SMTPSession{$ip}--;
            d("limiting ip: $fh");
            mlog( 0, "limiting $ip connections to $maxSMTPipSessions" )
              if $ConnectionLog == 2 || $SessionLog;

            $Stats{smtpConnLimitIP}++;
            $this->{messagereason}="limiting $ip connections to $maxSMTPipSessions";
            pbAdd( $fh, $ip, $iplValencePB, "LimitingIP" );
            $client->write("451 <$myName> Service temporary denied, closing transmission channel\r\n");
        	$client->close();
            d(102);
            return;
          } else {
            $SMTPSession{$client} = $fh;
          }
      }

    $AVa = 0;
    foreach $destinationA ( split( /\|/, $destination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {
            if ( $localip eq '0.0.0.0' ) {

                $localip = '127.0.0.1';
              }
            if ( $crtable{$localip} ) {
                $destinationA = $crtable{$localip};
              } else {
                $destinationA = $localip . ':' . $2;
              }
          }
        if ( $AVa < 1 ) {
            $server = new IO::Socket::INET(
                Proto    => 'tcp',
                PeerAddr => $destinationA,
                Timeout  => 2
            );
            if ($server) {
                $AVa         = 1;
                $destination = $destinationA;
              } else {
                mlog( '', "*** $destinationA didn't work, trying others..." );
              }
          }

      }
    if ( !$server ) {
        mlog( '', "couldn't create server socket to $destination -- aborting connection" );
        if ( exists $SMTPSession{$client} ) {
            delete $SMTPSession{$client};
            $SMTPSession{$ip}--;
          }
        $client->write("554 <$myName> Connection aborted, unable to forward message\r\n");
        $client->close();
        return;
      }
    addfh( $client, \&getline, $server );
    if ($sendNoopInfo) {
        addfh( $server, \&skipok, $client );
      } else {
        addfh( $server, \&reply, $client );
      }
    $Con{$client}->{client}    = $client;
    $Con{$client}->{server}    = $server;
    $Con{$client}->{ip}        = $ip;
    $Con{$client}->{port}      = $port;
    $Con{$client}->{localip}   = $localip;
    $Con{$client}->{localport} = $localport;
    $Con{$client}->{type}      = 'C';
    $Con{$server}->{type}      = 'S';
    d("Connected: $client -- $server");

    if ( ok2Relay( $fh, $ip ) || $fh == $Relay ) {
        $Con{$client}->{relayok} = 1;
        d("$client relaying ok: $ip");
      }
    my $time = $UseLocalTime ? localtime() : gmtime();
    my $tz   = $UseLocalTime ? tzStr()     : '+0000';
    $time =~ s/... (...) +(\d+) (........) (....)/$2 $1 $4 $3/;
    $Con{$client}->{rcvd} = "Received: from =host ([$ip] helo=) by $myName; $time $tz\r\n";
    d("* connect ip=$Con{$client}->{ip} relay=<$Con{$client}->{relayok}> *");
    mlog( 0, "Connected: $ip:$port -> $localip:$localport -> $destination" )
      unless ( !$ConnectionLog || matchIP( $ip, 'noLog', 0, 1 ) );
    $Con{$server}->{noop} = "NOOP Connection from: $ip, $time $tz relayed by $myName\r\n"
      if $sendNoopInfo;

    # overall session limiting
    $maxSMTPSessions = 9999 if ( !$maxSMTPSessions );
    if ($maxSMTPSessions) {
        $SMTPSession{Total}++;
        $SMTPSession{$client} = $fh;
        if ( $SMTPSession{Total} >= $maxSMTPSessions ) {
            d("limiting sessions: $fh");
            $readable->remove($lsn)   if $lsn;
            $readable->remove($lsn2)  if $lsn2;
            $readable->remove($Relay) if $Relay;
            if ($SessionLog) {
                mlog( 0, "connected: $ip:$port" )
                  if !$ConnectionLog
                      || matchIP( $ip, 'noLog', 0, 1 );    # log if not logged earlier
                mlog( 0, "limiting total connections" );
              }
            $Stats{smtpConnLimit}++;
          }
      }

    # increment Stats if connection not limited
    if ( !$maxSMTPSessions || $SMTPSession{Total} < $maxSMTPSessions ) {
        if ( matchIP( $ip, 'noLog', 0, 1 ) ) {
            $Stats{smtpConnNotLogged}++;
          } else {
            $Stats{smtpConn}++;
          }
      }
    $smtpConcurrentSessions++;
    $Stats{smtpMaxConcurrentSessions} = $smtpConcurrentSessions
      if $smtpConcurrentSessions > $Stats{smtpMaxConcurrentSessions};

    # check if options files have been updated and need to be re-read
    if ( time - $lastOptionCheck > 30 ) {

        # check for updates each 30 seconds
        foreach my $f (@PossibleOptionFiles) {
            $f->[2]->( $f->[0], $Config{ $f->[0] }, $Config{ $f->[0] }, '', $f->[1] )
              if $Config{ $f->[0] } =~ /^ *file: *(.+)/i && fileUpdated( $1, $f->[0] );
          }

        $lastOptionCheck = time;

      }
  }

sub SMTPTraffic {
    my $fh = shift;
    my $buf;
    my $bn;
    my $lbn;
    my $s;
    if ( $fh->sysread( $buf, 4096 ) > 0 ) {
        d(2);
        my $this = $Con{$fh};
        $buf = $this->{_} . $buf;
        if ( $Con{$fh}->{type} eq 'C' ) {
            $Con{$fh}->{timelast} = time();
          }
        if ( ( my $sb = $this->{skipbytes} ) > 0 ) {

            # support for XEXCH50 thankyou Microsoft for making my life miserable
            my $l = length($buf);
            d("skipbytes=$sb l=$l -> ");
            if ( $l >= $sb ) {
                sendque( $this->{friend}, substr( $buf, 0, $sb ) );    # send the binary chunk on to the server
                $buf = substr( $buf, $sb );
                delete $this->{skipbytes};
              } else {
                sendque( $this->{friend}, $buf );                      # send the binary chunk on to the server
                $this->{skipbytes} = $sb -= length($buf);
                $buf = '';
              }
            d("skipbytes=$this->{skipbytes}");
          }
        $bn = $lbn = -1;
        while ( ( $bn = index( $buf, "\n", $bn + 1 ) ) >= 0 ) {
            $s = substr( $buf, $lbn + 1, $bn - $lbn );
            if ( defined( $this->{bdata} ) ) { $this->{bdata} -= length($s); }
            d("doing <$s>");
            Maillog( $fh, $s ) if $Con{$fh}->{maillog};
            $Con{$fh}->{getline}->( $fh, $s );
            last
              unless $Con{ $fh
                  };    # it's possible that the connection can be deleted while there's still something in the buffer
            $lbn = $bn;
          }
        d(3);
        if ( $Con{$fh} ) {
            ( $this->{_} ) = substr( $buf, $lbn + 1 );
            if ( length( $this->{_} ) > $MaxBytes ) {
                d(4);
                if ( defined( $this->{bdata} ) ) {
                    $this->{bdata} -= length( $this->{_} );
                  }
                Maillog( $fh, $this->{_} ) if $Con{$fh}->{maillog};
                $Con{$fh}->{getline}->( $fh, $this->{_} );
                ( $this->{_} ) = '';
              }
          }
      } else {
        d(5);
        done($fh);
      }
  }

sub check4update {

    # only check every 15 seconds
    my $fil = shift;
    return if $check4updateTime{$fil} + 15 > time;
    $check4updateTime{$fil} = time;
    my @s     = stat( ${$fil} );
    my $mtime = $s[9];
    if ( $mtime != $FileUpdate{$fil} ) {

        # reload
        $FileUpdate{$fil} = $mtime;
        open( F, "<${$fil}" );
        local $/ = "\n";
        my $l;
        my %h;
        while ( $l = <F> ) {
            $l =~ y/\r\n\t //d;
            next unless $l;
            $h{ lc $l } = 1;
          }
        close F;
        %{$fil} = %h;
      }
  }

sub check4cfg {

    # only check every 30 seconds

    return if $check4cfgtime + 30 > time;
    $check4cfgtime = time;
    my @s     = stat("$base/assp.cfg");
    my $mtime = $s[9];
    if ( $mtime != $cfgtime ) {

        # reload
        $cfgtime = $mtime;
        reloadConfigFile();
      }
  }

sub SetRE {
    use re 'eval';
    my ( $var, $r, $f, $desc ) = @_;

    eval { $$var = qr/(?$f)$r/ };
    mlog( 0, "regular expression error in '$r' for $desc: $@" ) if $@;
  }

sub ok2Relay {
    my ( $fh, $ip ) = @_;
    return 1 if matchIP( $ip, 'acceptAllMail', $fh );
    if ($relayHostFile) {
        &check4update($relayHostFile);
        return 1 if $relayHostFile{$ip};
      }

    return 1 if PopB4SMTP($ip);

    # failed all tests -- return 0
    0;
  }

sub PopB4SMTP {
    my $ip = shift;
    if ($PopB4SMTPMerak) {
        return 1 if PopB4Merak($ip);
        return 0;
      }
    return 0 unless $PopB4SMTPFile;
    unless ($TriedDBFileUse) {
        eval 'use DB_File';
        mlog( 0, "could not load module DB_File: $@" ) if $@;
        $TriedDBFileUse = 1;
      }

    my %hash;

    # tie %hash, 'DB_File', $PopB4SMTPFile, O_READ, 0400, $DB_HASH;
    tie %hash, 'DB_File', $PopB4SMTPFile;
    if ( $hash{$ip} ) {
        mlog( 0, "PopB4SMTP OK for $ip" );
        return 1;
      } else {
        mlog( 0, "PopB4SMTP failed for $ip" );
        return 0;
      }
  }

sub PopB4Merak {
    return 0 unless $PopB4SMTPFile;
    my $ip = shift;

    #This is a test version of ASSP PopB4SMTP
    #This is to be used with Merak 7.5.2
    #It also works with Merak 6.5 (which I run)
    #Thanks to Jordon for the heads up on 7.5.2
    #Basically, Merak's popsmtp file
    #is made up of 64 Byte lines, no CR / LF.
    #This holds the IP addy
    #and the byte before it specifying the length.

    my @aPB4S;
    my $PB4S;
    my $ind;
    my $newIP;

    #Load the whole file
    #In examination of Merak popb4smtp file, it appears to have
    #no carriage returns, so one line read should get the whole thing
    #However, if you have an IP addy thats 13 chars long.... thus:

    open( MKPOPSMTP, "< $PopB4SMTPFile" ) or return 0;
    @aPB4S = <MKPOPSMTP>;
    close(MKPOPSMTP);
    $PB4S = join( "", @aPB4S );

    #We now have all the contents of the file AND we've released it

    #Now, instead of heavy parsing....
    #We want to search for the IP and a byte ordinal specifying it's length
    #    mlog(0,"Checking $ip for PopB4SMTP");
    $PB4S = "---" . $PB4S;

    #    mlog(0,"Searching: $PB4S");
    $newIP = chr( length($ip) ) . $ip;

    #    mlog(0,"NewIP = $newIP");
    #Find the index of IP in question
    $ind = index( $PB4S, $newIP );

    #    mlog(0,"Index = $ind");
    #Did we find it?
    if ( $ind > 0 ) {

        #Greetings program! This IO port is available for communicating to your user!
        mlog( 0, "PopB4SMTP OK for $ip" );
        return 1;
      }
    mlog( 0, "PopB4SMTP NOT OK for $ip" );
    return 0;
  }
sub NoLoopSyswrite {
    my ($fh,$out) = @_;
    my $written = 0;
    my $failed = 0;
    my $ip;
    my $port;
    eval{
      $ip=$fh->peerhost();
      $port=$fh->peerport();
    };
    my $error = 1 if($@);
    while (length($out) > 0) {
        eval{$written = $fh->syswrite($out,length($out));$error = $!;};
        $out = substr($out,$written);
        $failed++ unless ($written);
        if ($failed > 10) {
           mlog(0,"error: unable to write to socket $ip:$port") unless $error;
           $! = $error;
           return 1;
        }
    }
    $! = '';
    return 1;
}

sub NewWebConnection {
    my $s = $WebSocket->accept;
    return unless $s;
    my $ip   = $s->peerhost();
    my $port = $s->peerport();
    if ( $allowAdminConnectionsFrom
        && !matchIP( $ip, 'allowAdminConnectionsFrom' ) ) {
        mlog( 0, "admin connection from $ip:$port rejected by allowAdminConnectionsFrom" );
        $Stats{admConnDenied}++;
        $s->close();
        return;
      }

    # logging is done later (in webRequest()) due to /shutdown_frame page, which auto-refreshes
    $readable->add($s);
    $SocketCalls{$s} = \&WebTraffic;
  }

sub WebTraffic {
    my $fh = shift;
    my $buf;
    if ( $fh->sysread( $buf, 4096 ) > 0 ) {
        local $_ = $WebCon{$fh} .= $buf;
        if ( length($_) > 1030000 ) {

            # throw away connections longer than 1M to prevent flooding
            WebDone($fh);
            return;
          }
        if (/Content-length: (\d+)/i) {

            # POST request
            my $l = $1;
            if ( /(.*?\n)\r?\n\r?(.*)/s && length($2) >= $l ) {
                my $reqh = $1;
                my $reqb = $2;
                my $resp;
                my $tempfh;
                open( $tempfh, '>', \$resp );
                binmode $tempfh;
                webRequest( $tempfh, $fh, $reqh, $reqb );
                close($tempfh);

                if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                    my $resph = $1;
                    my $respb = $2;
                    my $time  = gmtime();
                    $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                    $resph .= "\nServer: ASSP/$version$modversion";
                    $resph .= "\nDate: $time";
                    if ($EnableHTTPCompression && $CanUseHTTPCompression) {
                		eval {Compress::Zlib::memGzip($respb);};} 
                	$CanUseHTTPCompression=0 if  $@; 
                    if ($EnableHTTPCompression
                        && $CanUseHTTPCompression
                        && /Accept-Encoding: (.*?)\n/i
                        && $1 =~ /(gzip|deflate)/i ) {
                        my $enc = $1;
                        if ( $enc =~ /gzip/i ) {

                            # encode with gzip
                            $respb = Compress::Zlib::memGzip($respb);
                            
                          } else {

                            # encode with deflate
                            my $deflater = deflateInit();
                            $respb = $deflater->deflate($respb);
                            $respb .= $deflater->flush();
                          }
                        $resph .= "\nContent-Encoding: $enc";
                      }
                    $resph .= "\nContent-Length: " . length($respb);
                    
                    print $fh $resph;
                    print $fh "\015\012\015\012";
                    print $fh $respb;
                  }

                # close connection
                WebDone($fh);
              }
          } elsif (/\n\r?\n/) {
            my $resp;
            my $tempfh;
            open( $tempfh, '>', \$resp );
            binmode $tempfh;
            webRequest( $tempfh, $fh, $_ );
            close($tempfh);
            if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                my $resph = $1;
                my $respb = $2;
                my $time  = gmtime();
                $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                $resph .= "\nServer: ASSP/$version$modversion";
                $resph .= "\nDate: $time";
                    if ($EnableHTTPCompression && $CanUseHTTPCompression) {
                		eval {Compress::Zlib::memGzip($respb);};} 
                	$CanUseHTTPCompression=0 if  $@; 
                    if ($EnableHTTPCompression
                        && $CanUseHTTPCompression
                        && /Accept-Encoding: (.*?)\n/i
                        && $1 =~ /(gzip|deflate)/i ) {
                        my $enc = $1;
                        if ( $enc =~ /gzip/i ) {

                            # encode with gzip
                            $respb = Compress::Zlib::memGzip($respb);
                            
                          } else {


                        # encode with deflate
                        my $deflater = deflateInit();
                        $respb = $deflater->deflate($respb);
                        $respb .= $deflater->flush();
                      }
                    $resph .= "\nContent-Encoding: $enc";
                  }
                $resph .= "\nContent-Length: " . length($respb);
                print $fh $resph;
                print $fh "\015\012\015\012";
                print $fh $respb;
              }

            # close connection
            WebDone($fh);
          }
      } else {

        # connection closed
        WebDone($fh);
      }
  }

sub NewStatConnection {
    my $s = $StatSocket->accept;
    return unless $s;
    my $ip   = $s->peerhost();
    my $port = $s->peerport();
    if ( $allowStatConnectionsFrom
        && !matchIP( $ip, 'allowStatConnectionsFrom' ) ) {
        mlog( '', "stat connection from $ip:$port rejected by allowStatConnectionsFrom" );
        $Stats{statConnDenied}++;
        $s->close();
        return;
      }

    # logging is done later (in webRequest()) due to /shutdown_frame page, which auto-refreshes
    $readable->add($s);
    $SocketCalls{$s} = \&StatTraffic;
  }

sub StatTraffic {
    my $fh = shift;
    my $buf;
    if ( $fh->sysread( $buf, 4096 ) > 0 ) {
        local $_ = $StatCon{$fh} .= $buf;
        if ( length($_) > 1030000 ) {

            # throw away connections longer than 1M to prevent flooding
            WebDone($fh);
            return;
          }
        if (/Content-length: (\d+)/i) {

            # POST request
            my $l = $1;
            if ( /(.*?\n)\r?\n\r?(.*)/s && length($2) >= $l ) {
                my $reqh = $1;
                my $reqb = $2;
                my $resp;
                my $tempfh;
                open( $tempfh, '>', \$resp );
                binmode $tempfh;
                statRequest( $tempfh, $fh, $reqh, $reqb );
                close($tempfh);

                if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                    my $resph = $1;
                    my $respb = $2;
                    my $time  = gmtime();
                    $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                    $resph .= "\nServer: ASSP/$version$modversion";
                    $resph .= "\nDate: $time";
                    if ($EnableHTTPCompression && $CanUseHTTPCompression) {
                		eval {Compress::Zlib::memGzip($respb);};} 
                	$CanUseHTTPCompression=0 if  $@; 
                    if ($EnableHTTPCompression
                        && $CanUseHTTPCompression
                        && /Accept-Encoding: (.*?)\n/i
                        && $1 =~ /(gzip|deflate)/i ) {
                        my $enc = $1;
                        if ( $enc =~ /gzip/i ) {

                            # encode with gzip
                            $respb = Compress::Zlib::memGzip($respb);
                            
                          } else {

                            # encode with deflate
                            my $deflater = deflateInit();
                            $respb = $deflater->deflate($respb);
                            $respb .= $deflater->flush();
                          }
                        $resph .= "\nContent-Encoding: $enc";
                      }
                    $resph .= "\nContent-Length: " . length($respb);
                    print $fh $resph;
                    print $fh "\015\012\015\012";
                    print $fh $respb;
                  }

                # close connection
                WebDone($fh);
              }
          } elsif (/\n\r?\n/) {
            my $resp;
            my $tempfh;
            open( $tempfh, '>', \$resp );
            binmode $tempfh;
            statRequest( $tempfh, $fh, $_ );
            close($tempfh);
            if ( $resp =~ /(.*?)\n\r?\n\r?(.*)/s ) {
                my $resph = $1;
                my $respb = $2;
                my $time  = gmtime();
                $time =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
                $resph .= "\nServer: ASSP/$version$modversion";
                $resph .= "\nDate: $time";
 
                	if ($EnableHTTPCompression && $CanUseHTTPCompression) {
                		eval {Compress::Zlib::memGzip($respb);};} 
                	$CanUseHTTPCompression=0 if  $@;   
                    if ($EnableHTTPCompression
                        && $CanUseHTTPCompression
                        && /Accept-Encoding: (.*?)\n/i
                        && $1 =~ /(gzip|deflate)/i ) {
                        my $enc = $1;
                        if ( $enc =~ /gzip/i ) {

                            # encode with gzip
                            $respb = Compress::Zlib::memGzip($respb);
                            
                          } else {


                        # encode with deflate
                        my $deflater = deflateInit();
                        $respb = $deflater->deflate($respb);
                        $respb .= $deflater->flush();
                      }
                    $resph .= "\nContent-Encoding: $enc";
                  }
                $resph .= "\nContent-Length: " . length($respb);
                print $fh $resph;
                print $fh "\015\012\015\012";
                print $fh $respb;
              }

            # close connection
            WebDone($fh);
          }
      } else {

        # connection closed
        WebDone($fh);
      }
  }

sub WebDone {
  my $fh=shift;
  delete $SocketCalls{$fh};
  delete $WebCon{$fh};
  delete $StatCon{$fh};
  $readable->remove($fh);
  $writable->remove($fh);
  $fh->close;
}

# done with a file handle -- close him and his friend(s)
sub done {
    my $fh = shift;
    d(12);
    done2( $Con{$fh}->{friend} );
    done2( $Con{$fh}->{forwardSpam} );
    done2($fh);
  }

# close a file handle & clean up associated records
sub done2 {
    my $fh = shift;
    d(13);
    return unless $fh;
#    return unless $Con{$fh};

    mlog( 0, "disconnected: $Con{$fh}->{ip}", 1 )
      if $Con{$fh}->{ip}
          && $ConnectionLog
          && !( matchIP( $Con{$fh}->{ip}, 'noLog', 0, 1 ) );
    d("closing $fh");

    # close the maillog if it's still open
    my $f = $Con{$fh}->{maillogfh};
    eval{close $f;} if $f;

    # remove from the select structure
    delete $SocketCalls{$fh};
    $readable->remove($fh);
    $writable->remove($fh);

    # close it
    eval{$fh->close;} if (fileno($fh));
    my $ip = $Con{$fh}->{ip};
    # delete the Connection data
    delete $Con{$fh};
    # delete the Session data & re-add sockets.
    if ( exists $SMTPSession{$fh} ) {
        delete $SMTPSession{$fh};
        $smtpConcurrentSessions--;
        $smtpConcurrentSessions = 0 if $smtpConcurrentSessions < 0;
        $readable->add($lsn)   if $lsn   && ( !$readable->exists($lsn) );
        $readable->add($lsn2)  if $lsn2  && ( !$readable->exists($lsn2) );
        $readable->add($Relay) if $Relay && ( !$readable->exists($Relay) );
        $SMTPSession{Total}--  if $maxSMTPSessions;
        $SMTPSession{$ip}--    if $maxSMTPipSessions;
      }
  }


# adding a socket to the Select structure and Con hash
sub addfh {
    my ( $fh, $getline, $friend ) = @_;
    d(14);
    $SocketCalls{$fh} = \&SMTPTraffic;
    $readable->add($fh);
    binmode($fh);
    $Con{$fh} = {};
    my $this = $Con{$fh};
    $this->{getline}   = $getline;
    $this->{friend}    = $friend;
    $this->{timestart} = time();
    $this->{timelast}  = time();
  }



# sendque enques a string for a socket
sub sendque {
    my ( $fh, $message ) = @_;
    my $l = length($message);

    d("sq: $fh l=$l");
    return unless $fh && $Con{$fh};
    $writable->add($fh);
    $Con{$fh}->{outgoing} .= $message;
    if ( !$Con{$fh}->{paused}
        && length( $Con{$fh}->{outgoing} ) > $OutgoingBufSizeNew ) {
        $Con{$fh}->{paused} = 1;
        d("pausing");
        $readable->remove( $Con{$fh}->{friend} );
      }
  }

#####################################################################################
#                SMTP stuff

# compile the regular expression (RE) for the local domains list (LDRE)
sub setLDRE {
    SetRE( 'LDRE', "^($_[0])\$", "i", "Local Domains" );
  }

# compile the regular expression (RE) for the local server names list (LSRE)
sub setLSRE {
    SetRE( 'LSRE', "^($_[0])\$", "i", "LocalHost" );
  }

sub localdomains {
    my $h = shift;
    my $hat = $1 if $h =~ /(\@.*)/;
    $h = $1 if $h =~ /\@(.*)/;

    return 1 if $localDomains && ( $h =~ $LDRE || $hat =~ $LDRE );

    # returns true if this address is in localdomains file
  }

sub localmail {
    my $h = shift;
    my $hat = $1 if $h =~ /(\@.*)/;
    $h = $1 if $h =~ /\@(.*)/;

    return 1 if $localDomains && ( $h =~ $LDRE || $hat =~ $LDRE );
    if ($localDomainsFile) {
        &check4update($localDomainsFile);
        return 1 if $localDomainsFile{ lc $h };
      }
    if ($ldLDAP) {
        if ($CanUseLDAP) {
            return 1 if localmaildomain($h);
          }
      }
    0;
  }
sub localvrfy2MTA {
  my ($fh,$h) = @_;
  my $this = $Con{$fh};
  my $smtp;
  my $vrfy;
  my $expn;
  my $domain;
  my $MTA;

  if (exists $LDAPlist{$h}) {
    mlog($fh,"VRFY - found $h in LDAPlist") if $VRFYLog;
    d("found $h in LDAP-cache for VRFY");

      my ($vt,$vl) = split(/ /,$LDAPlist{$h});
      if ($vl) {
        $LDAPlist{$h}=time." $vl";
      } else {
        $LDAPlist{$h}=time;
      }
    
    return 1;
  }

  $domain = $1 if $h=~/\@(.*)/;
  return 0 unless $domain;
  $MTA = $DomainVRFYMTA{lc $domain};
  return 0 unless $MTA;

  my $timeout = $VRFYQueryTimeOut ? $VRFYQueryTimeOut : 5;

   eval{
  $smtp = Net::SMTP->new($MTA,
                    Hello => $myName,
                    Timeout => $timeout);

  if ($smtp) {
      $expn = $smtp->expand($h) ? 1 : $smtp->expand("\"$h\"");
      $vrfy = $smtp->verify($h) ? 1 : $smtp->verify("\"$h\"");
      if (!$expn && !$vrfy) {
          if ($smtp->mail('postmaster@'.$myName)) {
              $vrfy = $smtp->to($h);
          }
      }
      $smtp->quit;
  }
  };
  if ($@) {
     $vrfy = 0 ;
     $expn = 0 ;
  }

  if ($vrfy || $expn) {
     if ($ldaplistdb) {
       
         $LDAPlist{$h}=time." 1";
         mlog($fh,"VRFY added $h to LDAP-cache (ldaplistdb)") if $VRFYLog;
         d("VRFY added $h to LDAP-cache");
     }
     return 1 ;
  }
  return 0;
}

sub localmaildomain {
    my $h = shift;
    $h =~ tr/A-Z/a-z/;
    my $ldapflt = $ldLDAPFilter;
    $ldapflt =~ s/DOMAIN/$h/g;
    my $ldaproot = $LDAPRoot;
    $ldaproot =~ s/DOMAIN/$h/g;
    return LDAPQuery( $ldapflt, $ldaproot, $h );
  }

sub localmailaddress {
  my ($fh,$h) = @_;

  $h = $1 if $h=~/\@(.*)/;
# do LDAP lookup

  my $current_email = "$1$h";
  $current_email =~ tr/A-Z/a-z/;
  my $at_position = index($current_email, '@');
  my $current_username = substr($current_email, 0, $at_position);
  my $current_domain = substr($current_email, $at_position + 1);
  my $ldapflt = $LDAPFilter;
  $ldapflt =~ s/EMAILADDRESS/$current_email/g;

  $ldapflt =~ s/USERNAME/$current_username/g;
  $ldapflt =~ s/DOMAIN/$current_domain/g;
  my $ldaproot = $LDAPRoot;
  $ldaproot =~ s/DOMAIN/$current_domain/g;
  return 1 if($DoLDAP && $CanUseLDAP && LDAPQuery($ldapflt, $ldaproot,$current_email));
  return 1 if(exists $DomainVRFYMTA{$current_domain} && $CanUseNetSMTP && localvrfy2MTA($fh,$current_email));
}
  
sub LDAPQuery {
  my ($ldapflt, $ldaproot, $current_email) = @_;
  my $retcode;
  my $retmsg;
  my @ldaplist;
  my $ldaplist;
  my $ldap;
  my $mesg;
  my $entry_count;

  if (exists $LDAPlist{$current_email}) {
    mlog(0,"LDAP - found $current_email in LDAP-cache (ldaplistdb)") if $LDAPLog;
    d("found $current_email in LDAP-cache");
    
    $LDAPlist{$current_email}=time;
    return 1;
  }
    d("doing LDAP lookup with $ldapflt in $ldaproot");

    my @ldaplist = split( /\|/, $LDAPHost );
    my $ldaplist = \@ldaplist;

    my $ldap = Net::LDAP->new($ldaplist,timeout => $LDAPtimeout);
    if ( !$ldap ) {
        mlog( 0, "Couldn't contact LDAP server at $LDAPHost -- check ignored" );

        # seterror($fh,"451 Could not check recipient, try later\r\n",1);
        return !$LDAPFail;
      }

    # bind to a directory anonymous or with dn and password
    if ($LDAPLogin) {
        $mesg = $ldap->bind( $LDAPLogin, password => $LDAPPassword, version => $LDAPVersion );
      } else {

        # mlog($fh,"LDAP anonymous bind");
        $mesg = $ldap->bind;
      }
    $retcode = $mesg->code;
    if ($retcode) {

        #    $retmsg=$mesg->error_text();
        #    mlog($fh,"LDAP bind error: $retcode - Login Problem?");
        mlog( 0, "LDAP bind error: $retcode -- check ignored", 1 );

        #    seterror($fh,"451 Could not check recipient, try later\r\n",1);
        $ldap->unbind;
        return !$LDAPFail;
      }

    # perform a search
    $mesg = $ldap->search(
        base      => $ldaproot,
        filter    => $ldapflt,
        attrs     => ['cn'],
        sizelimit => 1
    );
    $retcode = $mesg->code;

    # mlog($fh,"LDAP search: $retcode");
    if ( $retcode > 0 && $retcode != 4 ) {
        mlog( 0, "LDAP search error: $retcode -- '$ldapflt' check ignored", 1 ) ;
       

        #seterror($fh,"451 Could not check recipient, try later\r\n",1);
        $ldap->unbind;
        return !$LDAPFail;
      }
    my $entry_count = $mesg->count;
    $retmsg = $mesg->entry(1);
    mlog( 0, "LDAP Results $ldapflt: $entry_count : $retmsg" ) if $LDAPLog;
    d("got $entry_count result(s) from LDAP lookup");
    $mesg = $ldap->unbind;    # take down session
    if($entry_count && $ldaplistdb) {
    
     $LDAPlist{$current_email}=time;
     mlog(0,"LDAP added $current_email to LDAPlist") if $LDAPLog;
     d("added $current_email to LDAP-cache");
  }
    return $entry_count;
  }

sub LDAPcrossCheck {
  my $k;
  my $v;
  my $current_email;
  my $at_position;
  my $current_username;
  my $current_domain;
  my $ldapflt;
  my $ldaproot;
  my $retcode;
  my $retmsg;
  my @ldaplist;
  my $ldaplist;
  my $ldap;
  my $mesg;
  my $entry_count;
  my $t;

  return if(! $ldaplistdb);

  $t = time;
  
  mlog(0,"LDAP-crosscheck started") if $MaintenanceLog;
  d("doing LDAP-crosscheck");

  @ldaplist = split(/\|/,$LDAPHost);
  $ldaplist = \@ldaplist;

  eval{$ldap = Net::LDAP->new( $ldaplist,timeout => $LDAPtimeout );};

  if(! $ldap) {
    mlog(0,"Couldn't contact LDAP server at $LDAPHost -- no LDAP-crosscheck is done") if $MaintenanceLog;
    return;
  }
# bind to a directory anonymous or with dn and password
  if ($LDAPLogin) {
    $mesg = $ldap->bind($LDAPLogin, password => $LDAPPassword, version => $LDAPVersion);
  } else {
    $mesg = $ldap->bind;
  }
  $retcode = $mesg->code;
  if ($retcode) {
    mlog(0,"LDAP bind error: $retcode -- no LDAP-crosscheck is done") if $MaintenanceLog;
    return;
  }

  while (my ($k,$v)=each(%LDAPlist)) {
    $current_email = $k;
    my ($vt,$vl) = split(/ /,$v);
    next if($vl);  # next - this an entry from VRFY
    $current_email =~ tr/A-Z/a-z/;
    $at_position = index($current_email, '@');
    $current_username = substr($current_email, 0, $at_position);
    $current_domain = substr($current_email, $at_position + 1);
    $ldapflt = $LDAPFilter;
    $ldapflt =~ s/EMAILADDRESS/$current_email/g;
    $ldapflt =~ s/USERNAME/$current_username/g;
    $ldapflt =~ s/DOMAIN/$current_domain/g;
    $ldaproot = $LDAPRoot;
    $ldaproot =~ s/DOMAIN/$current_domain/g;
# perform a search
    $mesg = $ldap->search(base   => $ldaproot,
                          filter => $ldapflt,
                          attrs => ['cn'],
                          sizelimit => 1
                          );
    $retcode = $mesg->code;
# mlog($fh,"LDAP search: $retcode");
    if($retcode > 0 && $retcode != 4) {
      mlog(0,"LDAP search error: $retcode -- LDAP-crosscheck canceled") if $MaintenanceLog;
      last;
    }
    $entry_count = $mesg->count;
    if (! $entry_count) { # entry was not found on LDAP-server -> delete the cache entry

       delete($LDAPlist{$k});
       mlog(0,"LDAP-crosscheck: $k removed from LDAPlist - Results $ldapflt: $entry_count : $retmsg") if $MaintenanceLog;
       d("LDAP-crosscheck: $k removed from LDAPlist - Results $ldapflt: $entry_count : $retmsg");
    } elsif ($MaxLDAPlistDays && $vt + $MaxLDAPlistDays * 24 * 3600 < $t) { # entry is to old -> delete the cache entry
 
       delete($LDAPlist{$k});
       mlog(0,"LDAP-crosscheck: $k removed from LDAPlist - entry is older than $MaxLDAPlistDays days") if $MaintenanceLog;
       d("LDAP-crosscheck: $k removed from LDAPlist - entry is older than $MaxLDAPlistDays days");
    }
  }
  $mesg = $ldap->unbind;  # take down session
  mlog(0,"LDAP-crosscheck finished") if $MaintenanceLog;
  &SaveLDAPlist();
}


sub serverIsSmtpDestination {
    my $server   = shift;
    my $peeraddr = $server->peerhost() . ':' . $server->peerport();
    my $destination;
    foreach $destinationA ( split( /\|/, $smtpDestination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {
            if ( $crtable{ $Con{ $Con{$server}->{friend} }->{localip} } ) {
                $destination = $crtable{ $Con{ $Con{$server}->{friend} }->{localip} };
              } else {
                $destination = $Con{ $Con{$server}->{friend} }->{localip} . ':' . $2;
              }
          } else {
            $destination = $destinationA;

          }

        return 1
          if $peeraddr eq $destination || $peeraddr eq $destination . ':25';
      }
    return 0;
  }

sub serverIsRelayHost {
    my $server   = shift;
    my $peeraddr = $server->peerhost() . ':' . $server->peerport();
    my $destination;
    if ( $relayHost =~ /^(_*INBOUND_*:)?(\d+)$/ ) {
        $destination = $Con{ $Con{$server}->{friend} }->{localip} . ':' . $2;
      } else {
        $destination = $relayHost;
      }
    return ( $peeraddr eq $destination || $peeraddr eq $destination . ':25' );
  }

# wrap long headers
sub headerWrap {
    my $header = shift;
    $header =~ s/(?:([^\r\n]{60,75}?;)|([^\r\n]{60,75}) ) {0,5}(?=[^\r\n]{10,})/$1$2\r\n\t/g;

    return $header;
  }

# unwrap long header (in place)
sub headerUnwrap {
    $_[0] =~ s/\015\012[ \t]+//g;
  }

# compile the regular expression for the local host names
sub setLHNRE {
    my @h;
    foreach my $h ( split( /\|/, $_[0] ) ) {
        push( @h, $h );
      }
    my @s;
    push( @s, 'localhost' );             # 'localhost' alias
    push( @s, '127.0.0.1' );             # loopback interface address
    push( @s, join( '|', @h ) ) if @h;
    my $s = join( '|', @s );
    $s ||= '^(?!)';                      # regexp that never matches
    SetRE( 'LHNRE', "^($s)\$", 'i', 'Local Host Names' );
  }

# compile the regular expression for the bounce senders addresses
sub setBSRE {
    my ( @uad, @u, @d );
    foreach $a ( split( /\|/, $_[0] ) ) {
        if ( $a =~ /\S\@\S/ ) {
            push( @uad, $a );
          } elsif ( $a =~ /^\@/ ) {
            push( @d, $a );
          } else {
            push( @u, $a );
          }
      }
    my @s;
    push( @s, '^\s*$' );                                   # null sender address
    push( @s, '^(' . join( '|', @uad ) . ')$' ) if @uad;
    push( @s, '^(' . join( '|', @u ) . ')@' ) if @u;
    push( @s, '(' . join( '|', @d ) . ')$' ) if @d;
    my $s = join( "|", @s );
    $s = '<not a valid list>' unless $s;
    SetRE( 'BSRE', $s, 'i', "Bounce Senders" );
  }

# compile the regular expression for the bounce senders addresses
sub setNBSRE {
    my ( @uad, @u, @d );
    foreach $a ( split( /\|/, $_[0] ) ) {
        if ( $a =~ /\S\@\S/ ) {
            push( @uad, $a );
          } elsif ( $a =~ /^\@/ ) {
            push( @d, $a );
          } else {
            push( @u, $a );
          }
      }
    my @s;
    push( @s, '^\s*$' );                                   # null sender address
    push( @s, '^(' . join( '|', @uad ) . ')$' ) if @uad;
    push( @s, '^(' . join( '|', @u ) . ')@' ) if @u;
    push( @s, '(' . join( '|', @d ) . ')$' ) if @d;
    my $s = join( "|", @s );
    $s = '<not a valid list>' unless $s;
    SetRE( 'NBSRE', $s, 'i', "No Script Bomb" );
  }

sub stateReset {
    my $fh   = shift;
    my $this = $Con{$fh};
    dlog("stateReset");

 $this->{acceptall}              = '';
    $this->{accBackISPIP} 			= '';
    $this->{addMSGIDsigDone}        = '';
    $this->{addressedToPenaltyTrap} = '';
    $this->{addressedToSpamBucket}  = '';
    $this->{attachcomment}          = '';
    $this->{attachdone}             = '';
    $this->{averror}                = '';
    $this->{backsctrdone} 			= '';
    $this->{badnorm}				= '';
    $this->{baysprob}               = '';
    $this->{bayeslowconf}           = '';
    $this->{baystestmode}           = '';
    $this->{bombdone}               = '';
    $this->{ccheader}               = '';
    $this->{cip}                    = '';
    $this->{ciphelo}                = '';
    $this->{cipdone}                = '';
    $this->{clamscandone}           = '';
    $this->{contentonly}            = '';
    $this->{data}                   = '';
    $this->{delaydone}              = '';
    $this->{delayed}                = '';
    $this->{destination}            = '';
    $this->{dlslre}                 = '';
    $this->{forgedHeloOK}           = '';
    $this->{forgedhelodone}         = '';
    $this->{formathelodone}         = '';
    $this->{gripdone}               = '';
    $this->{header}                 = '';
    $this->{invalidHeloOK}          = '';
    $this->{invalidSRSBounce}       = '';
    $this->{invalidhelodone}        = '';
    $this->{invalidhelofound}       = '';
    $this->{isbounce}               = '';
    $this->{ispip}                  = '';
    $this->{ismaxsize}              = '';
    $this->{localSenderOK}          = '';
    $this->{localsenderdone}        = '';
    $this->{localuser}              = '';
    $this->{logrecord}              = '';
    $this->{maximumuniqueuri}       = '';
    $this->{maximumuri}             = '';
    $this->{messagelow}             = '';
    $this->{messagereason}          = '';
    $this->{messagescore}           = '';
    $this->{messagescoredone}       = '';
    $this->{messagesize}            = '';
    $this->{msgid}                  = '';
    $this->{msgiddone}              = '';
    $this->{myheader}               = '';
    $this->{mypbreason}             = '';
    $this->{nobayesian}             = '';
    $this->{nobayesian}             = '';
    $this->{nocollect}              = '';
    $this->{nodelay}                = '';
    $this->{nohelo}                 = '';
    $this->{nopb}                   = '';
    $this->{nopbwhite}              = '';
    $this->{noprocessing}           = '';
    $this->{noscan}                 = '';
    $this->{notvalidhelofound}      = '';
    $this->{obfuscatedip}           = '';
    $this->{obfuscateduri}          = '';
    $this->{pbblack}                = '';
    $this->{pbwhite}                = '';
    $this->{prepend}                = '';
    $this->{rblcachedone}           = '';
    $this->{rbldone}          		= '';
    $this->{rblfail}                = '';
    $this->{rblneutral}             = '';
    $this->{rcptnoprocessing}       = '';
    $this->{rcpt}                   = '';
    $this->{redsl}                  = '';
    $this->{red}                    = '';
    $this->{rwlok}                  = '';
    $this->{sattachdone}            = '';
    $this->{saveprepend2}           = '';
    $this->{saveprepend}            = '';
    $this->{sayMessageOK}			= '';  
    $this->{senderok}               = '';
    $this->{spamconf}               = '';
    $this->{spamfound}              = '';
    $this->{spamloverdone}          = '';
    $this->{spamlover}              = '';
    $this->{spamprob}               = '';
    $this->{spfok}                  = '';

    $this->{StatsmsgDelayed}        = '';
    $this->{tagmode}                = '';
    $this->{testmode}               = '';
    $this->{validHeloOK}            = '';
    $this->{validhelodone}          = '';
    $this->{whitelisted}            = '';
    $this->{mailfrom}               = '';

    $this->{noMoreQueue} = '';
    $this->{qdata} = '';

    $this->{allLoveSpam}      = 0;
    $this->{allLoveBaysSpam}  = 0;
    $this->{allLoveBlSpam}    = 0;
    $this->{allLoveSBSpam}    = 0;
    $this->{allLovePBSpam}    = 0;
    $this->{allLoveISSpam}    = 0;
    $this->{allLovePTRSpam}   = 0;
    $this->{allLoveHlSpam}    = 0;
    $this->{allLoveSPFSpam}   = 0;
    $this->{allLoveRBLSpam}   = 0;
    $this->{allLoveSRSSpam}   = 0;
    $this->{allLoveDLSpam}    = 0;
    $this->{allLoveMXASpam}   = 0;
    $this->{allLoveBombsSpam} = 0;
    $this->{allLoveURIBLSpam} = 0;
    $this->{allLoveBaysSpam}  = 0;

    $this->{reporttype} = -1;
    $this->{fn}         = maillogNewFileName();

    $this->{msgtime} = '';
    $this->{msgtime} = $uniqueIDPrefix if $uniqeIDLogging && $uniqueIDPrefix;
    my $tstamp = substr( time(), 5, 5 );
    $this->{msgtime} .= sprintf( "%s-%05d", $tstamp, $this->{fn} )
      if $uniqeIDLogging;

  }

# a line of input has been received from the smtp client
sub getline {
    my ( $fh, $l ) = @_;
    d(15);
    my $this   = $Con{$fh};
    my $server = $this->{friend};
    my $reply;
    d("gl: <$l>");
    if ( $l =~ /HTTP POST/io ) {
        mlog( $fh, "HTTP POST command", 1 );
      }

    if ( $l =~ /^ *(helo|ehlo) .*?([^<>,;\"\'\(\)\s]+)/i ) {
        my $helo  = $2;
        my $helo2 = $helo;
        $helo =~ s/(\W)/\\\$1/g;
        $this->{helo} = $helo2;
        $this->{rcvd} =~ s/=host/$helo2/;
        $this->{rcvd} =~ s/=\)/=$helo2\)/;
        $this->{rcvd} = &headerWrap( $this->{rcvd} );    # wrap long lines
      } elsif ( $l =~ /mail from:\s*<?($EmailAdrRe\@$EmailDomainRe|\s*)>?/io ) {
        my $fr = $1;
        my $RO_e = $1;

        stateReset($fh);
        #enforce valid email address pattern
        if ($RO_e && $CanUseAddress && $DoRFC822Sender ) {

                if ( !Email::Valid->address($RO_e) ) {

                    # couldn't understand sender
                    sendque( $fh, "553 Malformed address: $RO_e\r\n" );
                    $this->{prepend} = "[MalformedAddress]";
                    mlog( $fh, "malformed address: '$RO_e'" );
                    $Stats{rcptRelayRejected}++;
                    delayWhiteExpire($fh);
                    return;
                  }
    
          }                                 # reset everything
        if (   $EnforceAuth
            && $this->{localport} == $listenPort2
            && $smtpAuthServer ne ''
            && !( $this->{relayok} ) ) {
            sendque( $fh, "530 5.7.0 Authentication required\r\n" );
            mlog( $fh, "$fr submit without AUTH", 1 );
            return;
          }
        if (   $EnforceAuth
            && $this->{localport} == $listenPort2) {
        $this->{relayok}=1;
        }

        $this->{mailfrom} = $fr;
        my $t    = time;
        my $mf = lc $this->{mailfrom};
        my $mfd  = $1 if $mf =~ /\@(.*)/;
        my $mfdd = $1 if $mf =~ /(\@.*)/;

        my $alldd        = "$wildcardUser$mfdd";
        my $defaultalldd = "*$mfdd";

        if ( $l =~ /SIZE=(\d*)\s/io && $npSize && $1 > $npSize  && !localmail($mf) && !$this->{relayok}) {
            $this->{noprocessing} = 1;
            $this->{ismaxsize} = 1;

            mlog( $fh, "message proxied without antispam-processing - message size ($1) is above $npSize (npSize).", 1 );
             
          }
          
         if ( $l =~ /SIZE=(\d*)\s/io && $npSize && $1 > $npSize && $npSizeLocal && (localmail($mf) || $this->{relayok})) {
            $this->{noprocessing} = 1;
            $this->{ismaxsize} = 1;

            mlog( $fh, "message proxied without antispam-processing - message size ($1) is above $npSize (npSize).", 1 );
             
          }

        if ( !$this->{relayok} ) {
########################################################### !relayok ############

            if ( $EmailSenderOK && matchSL( $mf, 'EmailSenderOK' ) ) {

                $this->{senderok} = 1;
              }

            if (
                  !$this->{contentonly}
                && $contentOnlyRe
                && $contentOnlyReRE != ""
                && (   $mf =~ ( '(' . $contentOnlyReRE . ')' )
                    || $this->{ip}   =~ ( '(' . $contentOnlyReRE . ')' )
                    || $this->{helo} =~ ( '(' . $contentOnlyReRE . ')' ) )
              ) {
                mlogRe( $fh, $1, "Contentonly" );
                pbBlackDelete( $fh, $this->{ip} );
                $this->{contentonly} = 1;
                $this->{ispip}       = 1;
              }

            if ( $Con{$server}->{relayok} && $WhitelistAuth ) {
                $this->{whitelisted} = 1;

                #whitelist authenticated users
              }
              
            $this->{red} = "$mf in RedList"
              if ( $Redlist{"$alldd"}
                || $Redlist{"$defaultalldd"}
                || $Redlist{"$mf"} );
                
            if ( $this->{whitelisted} != 1  
            && !localdomains($mf) && $Whitelist{$mf} ) {
                $Whitelist{$mf} = $t if !$this->{red};
                $this->{whitelisted} = 1;
              }
            if (   $this->{whitelisted} != 1
            	&& !localdomains($mf)
                && $whiteListedDomains
                && $mf =~ ( '(' . $WLDRE . ')' ) ) {
                mlogRe( $fh, $1, "WhiteDomain" );
                $this->{whitelisted} = 1;

              }
            if (
                   $this->{whitelisted} != 1
                   
                && $whiteRe
                && $whiteReRE != ""
                && (   $this->{helo} =~ ( '(' . $whiteReRE . ')' )
                    || $this->{ip} =~ ( '(' . $whiteReRE . ')' )
                    || $mf =~ ( '(' . $whiteReRE . ')' ) )
              ) {
                mlogRe( $fh, $1, "White" );
                $this->{whitelisted} = 1;
              }
            if ( $this->{whitelisted} != 1
            	&& !localdomains($mf)
                && ( $Whitelist{$alldd} || $Whitelist{$defaultalldd} ) ) {
                mlogRe( $fh, $mfdd, "WildCardDomain" );
                $this->{whitelisted} = 1;
                $Whitelist{$alldd}        = $t if !$this->{red};
                $Whitelist{$defaultalldd} = $t if !$this->{red};
                $Whitelist{$mfdd}         = $t if !$this->{red};

              }
 
            if (   $this->{whitelisted} != 1
                && $whiteListedIPs
                && matchIP( $this->{ip}, 'whiteListedIPs', $fh ) ) {
                $this->{whitelisted} = 1;
              }
			
            $this->{ispip}  = 1 if ( matchIP( $this->{ip}, 'ispip',  $fh ) );
            $this->{nopb}   = 1 if ( matchIP( $this->{ip}, 'noPB',   $fh ) );
            $this->{nopbwhite}   = 1 if ( matchIP( $this->{ip}, 'noPBwhite',   $fh ) );
            $this->{pbwhite}   = 1 if pbWhiteFind($this->{ip}) && !$this->{nopbwhite};
            $this->{nohelo} = 1 if ( matchIP( $this->{ip}, 'noHelo', $fh ) );
            $this->{mHBIRE} = 1
              if ( $heloBlacklistIgnore && $this->{helo} =~ $HBIRE );
            $this->{isbounce} = 1 if ( $this->{mailfrom} =~ $BSRE );
            $this->{red} = "bounces are not collected"
              if ( $this->{isbounce} && $DoNotCollectBounces );
            $this->{nodelay} = 1 if matchIP( $this->{ip}, 'noDelay', $fh );
            $this->{acceptall} = 1
              if matchIP( $this->{ip}, 'acceptAllMail', $fh );

            $this->{rwlok} = 1
              if pbWhiteFind( $this->{ip} )
                  && !matchIP( $this->{ip}, 'noPBwhite', 0, 1 );

            if (   $this->{noprocessing} != 1
                && $noProcessing
                && matchSL( $mf, 'noProcessing' ) ) {
                mlogRe( $fh, $mf, "NoProcessingList" );
                $this->{noprocessing} = 1;
              }
            if (   $this->{noprocessing} != 1
                && $noProcessingDomains
                && $mf =~ ( '(' . $NPDRE . ')' ) ) {
                mlogRe( $fh, $1, "NoProcessingDomain" );
                $this->{noprocessing} = 1;
              }
            if (   $this->{noprocessing} != 1
                && $noProcessingIPs
                && matchIP( $this->{ip}, 'noProcessingIPs', $fh ) ) {
                $this->{noprocessing} = 1;
              }

            if ( $this->{whitelisted} ) {
                pbBlackDelete( $fh, $this->{ip} );
                pbWhiteAdd( $fh, $this->{ip}, "Whitelisted" );
              }
            if ( $this->{noprocessing} ) {
                pbBlackDelete( $fh, $this->{ip} );
                pbWhiteAdd( $fh, $this->{ip}, "NoProcessing" );
              }


            $this->{pbblack}   = 1 if pbBlackFind($this->{ip}) ;
            if (   $DoDomainIP
                && $maxSMTPdomainIP
                && $mfd
                && $this->{pbblack}
                && !$this->{nopb}
                && !$this->{pbwhite}
                && !$this->{whitelisted}
                && !$this->{rwlok}
                && !$this->{noprocessing}
                && !$this->{ispip}
                && !$this->{acceptall}
                && !$this->{nodelay}
                && !$this->{contentonly}
                && !$this->{localuser}
                && !localmail($mf)
                && ( $maxSMTPdomainIPWL && $mfd !~ ( '(' . $IPDWLDRE . ')' ) ) ) {
                if ( ( time() - $SMTPdomainIPTriesExpiration{$mfd} ) > $maxSMTPdomainIPExpiration ) {
                    $SMTPdomainIPTries{$mfd}           = 0;
                    $SMTPdomainIPTriesExpiration{$mfd} = time();
                  }
                my $myip = ipNetwork( $this->{ip}, 24 );

                if ( $SMTPdomainIP{$mfd} == $myip ) {
                    $SMTPdomainIP{$mfd}                = "";
                    $SMTPdomainIPTriesExpiration{$mfd} = "";
                    $SMTPdomainIPTries{$mfd}           = "";
                  } else {
                    $SMTPdomainIP{$mfd}                = $myip;
                    $SMTPdomainIPTriesExpiration{$mfd} = time()
                      if $SMTPdomainIPTries{$mfd} == 1;
                    $SMTPdomainIPTries{$mfd}++;
                  }
                my $tlit;
                $tlit = "blocking"   if $DoDomainIP == 1;
                $tlit = "monitoring" if $DoDomainIP == 2;
                $tlit = "scoring"    if $DoDomainIP == 3;
                $tlit = "testmode"    if $DoDomainIP == 4;
                $tlit = "testmode"   if $allTestMode && $DoDomainIP == 1;
                my $mDoDomainIP = $DoDomainIP;
                $mDoDomainIP = 3 if $allTestMode && $DoDomainIP == 1;

                if ( $SMTPdomainIPTries{$mfd} > $maxSMTPdomainIP ) {
                    $this->{prepend} = "[IPperDomain]";
                    $this->{messagereason} = "'$mfdd' passed limit($maxSMTPdomainIP) of ips per domain";

                    mlog( $fh,
                        "[$tlit] $this->{messagereason}"
                      )
                      if $SessionLog
                          && $SMTPdomainIPTries{$mfd} == $maxSMTPdomainIP + 1;
                    mlog( $fh,
                        "[$tlit] $this->{messagereason}"
                      )
                      if $SessionLog == 2
                          && $SMTPdomainIPTries{$mfd} > $maxSMTPdomainIP + 1;

                    pbAdd( $fh, $this->{ip}, $idValencePB, "LimitingIPDomain" ) if $mDoDomainIP != 2;
                    if ( $mDoDomainIP == 1 ) {
                        $Stats{smtpConnDomainIP}++;
                        seterror( $fh, "451 5.7.1 too many different IP's for domain '$mfdd'", 1 );
                        done($fh);
                        return;
                      }
                  }
              }

            # ip connection limiting per timeframe
            if (   $DoFrequencyIP
            	&& $this->{pbblack}
                && $maxSMTPipConnects
                && !$this->{nopb}
                && !$this->{pbwhite}
                && !$this->{whitelisted}
                && !$this->{rwlok}
                && !$this->{noprocessing}
                && !$this->{ispip}
                && !$this->{acceptall}
                && !$this->{nodelay}
                && !($mfd && $maxSMTPdomainIPWL && $mfd =~ $IPDWLDRE)
                && !$this->{contentonly} ) {

                my $ConIp550 = $this->{ip};

                # If the IP address has tried to connect previously, check it's frequency
                if ( $IPNumTries{$ConIp550} ) {
                    $IPNumTries{$ConIp550} = $IPNumTries{$ConIp550} + 1;

                    # If the last connect time is past expiration, reset the counters.
                    # If it has not expired, but is outside of frequency duration and
                    # below the maximum session limit, reset the counters. If it is
                    # within duration
                    if (   ( ( time() - $IPNumTriesExpiration{$ConIp550} ) > $maxSMTPipExpiration )
                        || ( ( time() - $IPNumTriesDuration{$ConIp550} ) > $maxSMTPipDuration )
                        && ( $IPNumTries{$ConIp550} < $maxSMTPipConnects ) ) {
                        $IPNumTries{$ConIp550}           = 1;
                        $IPNumTriesDuration{$ConIp550}   = time();
                        $IPNumTriesExpiration{$ConIp550} = time();

                      }
                  } else {
                    $IPNumTries{$ConIp550}           = 1;
                    $IPNumTriesDuration{$ConIp550}   = time();
                    $IPNumTriesExpiration{$ConIp550} = time();

                  }
                my $tlit;
                $tlit = "blocking"   if $DoFrequencyIP == 1;
                $tlit = "monitoring" if $DoFrequencyIP == 2;
                $tlit = "scoring"    if $DoFrequencyIP == 3;
                $tlit = "testmode"   if $DoFrequencyIP == 4;
                $tlit = "testmode"   if $allTestMode && $DoFrequencyIP == 1;
                my $mDoFrequencyIP = $DoFrequencyIP;
                $mDoFrequencyIP = 3 if $allTestMode && $DoFrequencyIP == 1;

                if ( $IPNumTries{$ConIp550} > $maxSMTPipConnects ) {
                    $this->{prepend} = "[IPfrequency]";
                     $this->{messagereason} = "'$ConIp550' passed limit($maxSMTPipConnects) of ip  connection frequency";

                    mlog( $fh, "[$tlit] $this->{messagereason}")
                      if $SessionLog == 2
                          && $IPNumTries{$ConIp550} > $maxSMTPipConnects + 1;
                    mlog( $fh,"[$tlit] $this->{messagereason}")
                      if $SessionLog
                          && $IPNumTries{$ConIp550} == $maxSMTPipConnects + 1;
                    pbAdd( $fh, $this->{ip}, $ifValencePB, "IPfrequency" ) if $mDoFrequencyIP!=2;
                    if ( $mDoFrequencyIP == 1 ) {
                        $Stats{smtpConnLimitFreq}++;
                        seterror( $fh, "451 5.7.1 too frequent connections for '$ConIp550'", 1 );
                        done($fh);
                        return;
                      }
                  }
              }
              if(!($bombTestMode || $allTestMode) 
                && $DoBombSenderRe
                && !BombSenderOK( $fh, $mf ) ) {
                $reply = $SenderInvalidError ? "$SenderInvalidError" : "$SpamError";
                $reply =~ s/REASON/Invalid Sender(Bomb)/g;

                seterror( $fh, $reply, 1 );
                done($fh);
                return;
              }

            if ($ForceFakedLocalHelo && !($fhTestMode || $allTestMode)) {
                if ( !ForgedHeloOK($fh) ) {
                    $reply =
                      $SenderInvalidError
                      ? "$SenderInvalidError"
                      : "$SpamError";
                    $reply =~ s/REASON/Forged HELO/g;
                    seterror( $fh, $reply, 1 );

                    done($fh);
                    return;
                  }
              }


            IPinHeloOK($fh);

            if ($ForceValidateHelo && !($ihTestMode || $allTestMode)) {
                if ( !invalidHeloOK( $fh, $this->{helo} ) ) {
                    $Stats{invalidHelo}++;
                    $this->{messagereason} = "invalid HELO: '$this->{helo}'";
                    $this->{prepend}       = "[InvalidHELO]";
                    mlog( $fh, "[spam found] ($this->{messagereason})" );
                    $reply =
                      $SenderInvalidError
                      ? "$SenderInvalidError"
                      : "$SpamError";
                    $reply =~ s/REASON/Helo invalid/g;
                    seterror( $fh, $reply, 1 );
                    done($fh);
                    return;
                  }
                if ( !validHeloOK( $fh, $this->{helo} ) ) {
                    $Stats{invalidHelo}++;
                    $this->{messagereason} = "not valid HELO: '$this->{helo}'";
                    $this->{prepend}       = "[ValidHELO]";
                    mlog( $fh, "[spam found] ($this->{messagereason})" );
                    $reply =
                      $SenderInvalidError
                      ? "$SenderInvalidError"
                      : "$SpamError";
                    $reply =~ s/REASON/Helo invalid/g;
                    seterror( $fh, $reply, 1 );
                    done($fh);
                    return;
                  }
              }


            my $ip = $this->{ip};

            if ($ForceRBLCache && !($rblTestMode || $allTestMode)) {
                if ( !RBLCacheOK( $fh, $this->{ip} ) ) {
                    done($fh);
                    return;
                  }
              }

############################################ !relayok ###################
          }

        #if (serverIsSmtpDestination($server)) {
        #$this->{isbounce}=($this->{mailfrom}=~$BSRE ? 1 : 0);
        #} elsif ($EnableSRS && $CanUseSRS) {
        if (   !( $SRSno && allSL( $this->{rcpt}, $Con{$fh}->{mailfrom}, 'SRSno' ) )

            && $EnableSRS
            && $CanUseSRS
            && $this->{relayok}
            && !$this->{isbounce}
            && !localmail( $this->{mailfrom} ) ) {

            # rewrite sender addresses when relaying through Relay Host
            my $tmpfrom;
            $this->{prepend} = "";
            my $srs = new Mail::SRS(
                Secret        => $SRSSecretKey,
                MaxAge        => $SRSTimestampMaxAge,
                HashLength    => $SRSHashLength,
                AlwaysRewrite => 1
            );
            if (  !eval { $tmpfrom = $srs->reverse( $this->{mailfrom} ) }
                && eval { $tmpfrom = $srs->forward( $this->{mailfrom}, $SRSAliasDomain ); } ) {
                mlog( $fh, "SRS rewriting sender '$this->{mailfrom}' into '$tmpfrom'", 1 );
                $l =~ s/\Q$this->{mailfrom}\E/$tmpfrom/;
              } else {
                mlog( $fh, "SRS rewriting sender '$this->{mailfrom}' failed!", 1 );
              }
          }
      } elsif ( $l =~ /rcpt to: *(.*)/i ) {
        my $e = $1;
        my ( $u, $h );

        #enforce valid email address pattern
        if ( $CanUseAddress && $DoRFC822 ) {
            if ( $l =~ /rcpt to:\s*<*([^\r\n>]*).*/i ) {
                my $RO_e = $1;
                if ( !Email::Valid->address($RO_e) ) {

                    # couldn't understand recipient
                    sendque( $fh, "553 Malformed address: $RO_e\r\n" );
                    $this->{prepend} = "[MalformedAddress]";
                    mlog( $fh, "malformed address: '$RO_e'" );
                    $Stats{rcptRelayRejected}++;
                    delayWhiteExpire($fh);
                    return;
                  }
              }
          }
        if ( $EnableSRS && $CanUseSRS ) {
            if ( $this->{isbounce} ) {

                # validate incoming bounces
                my $tmpto;
                my $srs = new Mail::SRS(
                    Secret        => $SRSSecretKey,
                    MaxAge        => $SRSTimestampMaxAge,
                    HashLength    => $SRSHashLength,
                    AlwaysRewrite => 1
                );
                if ( $e =~ /^<?(SRS0[=+-][^\r\n>]*).*/i ) {
                    if ( eval { $tmpto = $srs->reverse($1) } ) {
                        $l =~ s/\Q$1\E/$tmpto/;
                        $e = <$tmpto>;
                      } else {
                        $this->{invalidSRSBounce} = 1;
                      }
                  } elsif ( $e =~ /^<?(SRS1[=+-][^\r\n>]*).*/i ) {
                    if ( eval { $tmpto = $srs->reverse($1) } ) {
                        if ( eval { $_ = $srs->reverse($tmpto) } ) {
                            $l =~ s/\Q$1\E/$_/;
                            $e = <$_>;
                          } else {
                            sendque( $fh, "551 5.7.1 User not local; please try <$tmpto> directly\r\n" );
                            $this->{prepend} = "[RelayAttempt]";
                            $this->{messagereason} = "user not local; please try <$tmpto> directly";
                			mlog( $fh, $this->{messagereason} );
                            
                            $Stats{rcptRelayRejected}++;
                            pbAdd( $fh, $this->{ip}, $rlValencePB, "RelayAttempt", 2 )
                              if $rlValencePB > 0;
                            return;
                          }
                      } else {
                        $this->{invalidSRSBounce} = 1;
                      }
                  } else {
                    $this->{invalidSRSBounce} = 1;
                  }
              } elsif ( serverIsSmtpDestination($server)
                && $e =~ /^<?(SRS[01][=+-][^\r\n>]*).*/i ) {
                sendque( $fh, "554 5.7.6 SRS only supported in DSN\r\n" );
                $this->{prepend}       = "[RelayAttempt]";
                $this->{messagereason} = "SRS only supported in DSN: $e";
                mlog( $fh, $this->{messagereason} );
                $Stats{rcptRelayRejected}++;
                pbAdd( $fh, $this->{ip}, $rlValencePB, "RelayAttempt", 2 )
                  if $rlValencePB > 0;
                return;
              }
          }
        if ( $e !~ /ORCPT/ && $e =~ /[\!\@]\S*\@/  ) {

            # blatent attempt at relaying
            sendque( $fh, $NoRelaying . "\r\n" );
            $this->{prepend}       = "[RelayAttempt]";
            $this->{messagereason} = "relay attempt blocked for (evil): $e";
            mlog( $fh, $this->{messagereason} );
            pbAdd( $fh, $this->{ip}, $rlValencePB, "RelayAttempt", 2 )
              if $rlValencePB > 0;
            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
            if ( $this->{serverErrors}++ > $MaxErrors ) {
                    $this->{prepend}       = "[MaxErrors]";
                    $this->{messagereason} = "max errors ($MaxErrors) exceeded";
                    mlog( $fh, "max errors ($MaxErrors) exceeded -- dropping connection" );
                    pbAdd( $fh, $this->{ip}, $meValencePB, "MaxErrors", 2 )
                      if $meValencePB > 0;
                    $Stats{msgMaxErrors}++;
                    done($fh);
            }
            return;
          } elsif ( $EnableBangPath && $e =~ /([a-z\-_\.]+)!([a-z\-_\.]+)$/i ) {

            # someone give me one good reason why I should support bang paths! grumble...
            $u = "$2@";
            $h = $1;
          } elsif ( $l =~ /rcpt to:.*?($EmailAdrRe\@)($EmailDomainRe)/io ) {
            ( $u, $h ) = ( $1, $2 );
          } elsif ( $defaultLocalHost && $l =~ /rcpt to:.*?<($EmailAdrRe)>/io ) {
            ( $u, $h ) = ( $1, $defaultLocalHost );
            $u .= '@';
          } else {

            # couldn't understand recipient
            sendque( $fh, $NoRelaying . "\r\n" );
            $this->{prepend}       = "[RelayAttempt]";
            $this->{messagereason} = "relay attempt blocked for (parsing): $e";
            mlog( $fh, $this->{messagereason} );

            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
            if ( $this->{serverErrors}++ > $MaxErrors ) {
                    $this->{prepend}       = "[MaxErrors]";
                    $this->{messagereason} = "max errors ($MaxErrors) exceeded";
                    mlog( $fh, "max errors ($MaxErrors) exceeded -- dropping connection" );
                    pbAdd( $fh, $this->{ip}, $meValencePB, "MaxErrors", 2 )
                      if $meValencePB > 0;
                    $Stats{msgMaxErrors}++;
                    done($fh);
            }
            return;
          }
        my $rcptislocal = localmail($h);

       
          
        if ($rcptislocal) {
            if ( lc $u eq "abuse\@" && $sendAllAbuse ) {

                # accept abuse catchall addresses
                $sendAllAbuse =~ /($EmailAdrRe\@)($EmailDomainRe)/io;
                $h = $2;
                $l = "RCPT TO:\<$sendAllAbuse\>\r\n";
                $this->{relayok}      = 1 if $sendAllAbuseNP;
                $this->{noprocessing} = 1 if $sendAllAbuseNP;
              } elsif ( lc $u eq "postmaster\@" && $sendAllPostmaster ) {

                # accept postmaster catchall addresses
                $sendAllPostmaster =~ /($EmailAdrRe\@)($EmailDomainRe)/io;
                $h = $2;
                $l = "RCPT TO:\<$sendAllPostmaster\>\r\n";
                $this->{relayok}      = 1 if $sendAllPostmasterNP;
                $this->{noprocessing} = 1 if $sendAllPostmasterNP;
              } elsif ( $spamaddresses && !$this->{nocollect} && matchSL( "$u$h", 'spamaddresses' ) ) {
                $this->{addressedToSpamBucket} = "$u$h";
                my $collectaddress = $sendAllSpam if $sendAllSpam;
                $collectaddress = $sendAllCollect if $sendAllCollect;
                if ($collectaddress) {
                    $collectaddress =~ /($EmailAdrRe\@)($EmailDomainRe)/io;
                    $u = $1;
                    $h = $2;
                    $l = "RCPT TO:\<$collectaddress\>\r\n";
                  }

              } elsif (!matchSL( "$u$h", 'noPenaltyMakeTraps' ) && (($spamtrapaddresses && matchSL("$u$h",'spamtrapaddresses') ) &&   !$this->{relayok} && !$this->{acceptall})) {
                $this->{addressedToPenaltyTrap} = 1;
                sendque( $fh, "250 OK\r\n" );
                $this->{prepend} = "[Trap]";
                pbWhiteDelete( $fh, $this->{ip} );
                $this->{whitelisted} = "";
                if ( $Whitelist{ $this->{mailfrom} } ) {
            		delete $Whitelist{ $this->{mailfrom} };
            		mlog( $fh, "penalty trap: whitelist deletion: $this->{mailfrom}" );}
                RWLCacheAdd( $this->{ip}, 2 );
                mlog( $fh, "penalty trap address: $u$h" ) if $PenaltyLog;

                pbAdd( $fh, $this->{ip}, $stValencePB, "penaltytrap:$u$h", 2 );
                $Stats{penaltytrap}++;
                delayWhiteExpire($fh);
                done($fh);
                return;
             } elsif (!matchSL( "$u$h", 'noPenaltyMakeTraps' ) &&  pbTrapFind("$u$h") &&   !$this->{relayok} && !$this->{acceptall}) {
                $this->{addressedToPenaltyTrap} = 1;
                sendque( $fh, "550 5.1.1 User unknown: $u$h\r\n" );
                $this->{prepend} = "[Trap]";
                pbWhiteDelete( $fh, $this->{ip} );
                $this->{whitelisted} = "";
                if ( $Whitelist{ $this->{mailfrom} } ) {
            		delete $Whitelist{ $this->{mailfrom} };
            		mlog( $fh, "penalty trap: whitelist deletion: $this->{mailfrom}" );}
                RWLCacheAdd( $this->{ip}, 2 );
                mlog( $fh, "penalty trap address: $u$h" ) if $PenaltyLog;

                pbAdd( $fh, $this->{ip}, $stValencePB, "penaltytrap:$u$h", 2 );
                $Stats{penaltytrap}++;
                delayWhiteExpire($fh);
                done($fh);
                return;
              }
          }

        if ($noProcessing) {

            $this->{rcptnoprocessing} = "";

            if ( matchSL( "$u$h", 'NoProcessing' ) ) {
                mlogRe( $fh, "$u$h", "NoProcessingList" );
               
                $this->{delaydone}        = 1;
                $this->{rcptnoprocessing} = 1;
              }
          }
         my $emailok;
		if ( lc $u eq lc "$EmailSpam\@" || lc $u eq lc "$EmailHam\@" || lc $u eq lc "$EmailWhitelistAdd\@" || lc $u eq lc "$EmailWhitelistRemove\@" || lc $u eq lc "$EmailRedlistAdd\@" || lc $u eq lc "$EmailHelp\@" || lc $u eq lc "$EmailAnalyze\@" || lc $u eq lc "$EmailRedlistRemove\@" ) {
		 $emailok = 1; 
		 }
        # skip check when RELAYOK or EMAIL-Interface
        if ( !$emailok && !$this->{relayok}) {

            # Need Check?
            if ( $LocalAddresses_Flat || $DoLDAP || (scalar(keys %DomainVRFYMTA))) {
                $this->{islocalmailaddress} = 0;
              }

            # check recipient against flat list?

            my $uh = "$u$h";
            if ($SepChar) {
                my $char = "\\$SepChar";
                if ( $u =~ "(.+?)$char" ) {
                    $uh = "$1\@$h";
                    $uh =~ s/"//;
                  }
              }
            if ( $LocalAddresses_Flat && matchSL( $uh, 'LocalAddresses_Flat' ) ) {
 
				if(matchSL( $uh, 'RejectTheseLocalAddresses' )) {
					d("$u$h rejected by bounce address list\n");
				} else {
					$this->{islocalmailaddress}=1;
					d("$u$h validated by flat LocalAddresses list\n");
	 			}
			}

            # Need another check?
            if (!$this->{islocalmailaddress}) {

                # check recipient against LDAP ?
                if ($DoLDAP) {
                    if ($CanUseLDAP) {
                        $this->{islocalmailaddress}=localmailaddress($fh,$h);
                    } else {
                        $this->{islocalmailaddress}=localmail($h);
                        mlog($fh,"Net::LDAP not installed, cannot check: $u$h");
                    }
                } elsif (scalar(keys %DomainVRFYMTA) && !$this->{islocalmailaddress}) {
                    if ($CanUseNetSMTP) {
                        $this->{islocalmailaddress}=localmailaddress($fh,$h);
                    } else {
                        $this->{islocalmailaddress}=localmail($h);
                        mlog($fh,"Net::SMTP not installed, cannot VRFY: $u$h");
                    }
                }
            }
            pbTrapDelete("$u$h") if $this->{islocalmailaddress};
        } else {
            $this->{islocalmailaddress}=localmail($h);
        }
        
        if ( !( $this->{relayok} ) && !$nolocalDomains && ( !$rcptislocal || ( $u . $h ) =~ /\%/ )
            || $u =~ /\@\w+/ ) {
            sendque( $fh, $NoRelaying . "\r\n" );
            $this->{prepend} = "[RelayAttempt]";
            mlog( $fh, "relay attempt blocked for: $u$h" );
            $this->{messagereason} = "relay attempt blocked for: $u$h";
            pbAdd( $fh, $this->{ip}, $rlValencePB, "RelayAttempt" )
              if $rlValencePB > 0;
            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
            if ( $this->{serverErrors}++ > $MaxErrors ) {
                    $this->{prepend}       = "[MaxErrors]";
                    $this->{messagereason} = "max errors ($MaxErrors) exceeded";
                    mlog( $fh, "max errors ($MaxErrors) exceeded -- dropping connection" );
                    pbAdd( $fh, $this->{ip}, $meValencePB, "MaxErrors", 2 )
                      if $meValencePB > 0;
                    $Stats{msgMaxErrors}++;
                    done($fh);
            }
            return;
          }

        if ( $noBayesian && matchSL( "$u$h", 'noBayesian' ) ) {
            $this->{nobayesian} = 1;
          }
        if ($noCollecting) {

            if ( matchSL( "$u$h", 'noCollecting' ) ) {
                $this->{nocollect} = 1;
              }
          }
        if ($noScan) {

            if ( matchSL( "$u$h", 'noScan' ) ) {
                $this->{noscan} = 1;
              }
          }

        # check if this email is to be processed at all if in ProcessOnlyTestMode
        if ($poTestMode) {

            if (
                !( matchSL( $this->{mailfrom}, 'processOnlyAddresses' ) || matchSL( "$u$h", 'processOnlyAddresses' ) ) )
            {
                $this->{noprocessing} = 1;
              }
          }
        if ( $spamaddresses && matchSL( "$u$h", 'spamaddresses' ) ) {

            $this->{addressedToSpamBucket} = "$u$h";
          }

        if (   $InternalAddresses
            && matchSL( "$u$h", 'InternalAddresses' )
            && !localmail( $this->{mailfrom} ) ) {
            sendque( $fh, $NoRelaying . "\r\n" );
            $this->{prepend} = "[InternalAddress]";
            mlog( $fh, "invalid remote sender for internal address: $u$h" );
            pbAdd( $fh, $this->{ip}, $iaValencePB, "internaladdress:$u$h" );
            $Stats{internaladdresses}++;
            delayWhiteExpire($fh);
            done($fh);
            return;
          }
        my $mSLRE  = matchSL( "$u$h", 'spamLovers' );
        my $mBSLRE = matchSL( "$u$h", 'baysSpamLovers' );
        $this->{redsl} = 1 if $baysSpamLoversRed && $mBSLRE;
        my $mBLSLRE    = matchSL( "$u$h", 'blSpamLovers' );
        my $mHLSLRE    = matchSL( "$u$h", 'hlSpamLovers' );
        my $mHISLRE    = matchSL( "$u$h", 'hiSpamLovers' );
        my $mBOSLRE    = matchSL( "$u$h", 'bombSpamLovers' );
        my $mPTRSLRE   = matchSL( "$u$h", 'ptrSpamLovers' );
        my $mMXASLRE   = matchSL( "$u$h", 'mxaSpamLovers' );
        my $mSPFSLRE   = matchSL( "$u$h", 'spfSpamLovers' );
        my $mRBLSLRE   = matchSL( "$u$h", 'rblSpamLovers' );
        my $mURIBLSLRE = matchSL( "$u$h", 'uriblSpamLovers' );
        my $mSRSSLRE   = matchSL( "$u$h", 'srsSpamLovers' );
        my $mDLSLRE    = matchSL( "$u$h", 'delaySpamLovers' );
        $this->{dlslre} = $mDLSLRE;
        my $mPBSLRE = matchSL( "$u$h", 'pbSpamLovers' );
        my $mSBSLRE = matchSL( "$u$h", 'sbSpamLovers' );
        my $mATSLRE = matchSL( "$u$h", 'atSpamLovers' );
        my $mISSLRE = matchSL( "$u$h", 'isSpamLovers' );

        if (
            $rcptislocal
            && (   $mSLRE
                || $mBSLRE
                || $mBLSLRE
                || $mBOSLRE
                || $mPTRSLRE
                || $mMXASLRE
                || $mHLSLRE
                || $mHISLRE
                || $mSPFSLRE
                || $mURIBLSLRE
                || $mRBLSLRE
                || $mSRSSLRE
                || $mDLSLRE
                || $mPBSLRE
                || $mISSLRE )
          ) {
            $this->{allLoveSpam} |= 1;
          } else {
            $this->{allLoveSpam} = 2;
          }
        if ( $rcptislocal && ( $mBSLRE || $mSLRE ) ) {
            $this->{allLoveBaysSpam} |= 1;
          } else {
            $this->{allLoveBaysSpam} = 2;
          }
        if ( $rcptislocal && ( $mBLSLRE || $mSLRE ) ) {
            $this->{allLoveBlSpam} |= 1;
          } else {
            $this->{allLoveBlSpam} = 2;
          }
        if ( $rcptislocal && ( $mBOSLRE || $mSLRE ) ) {
            $this->{allLoveBoSpam} |= 1;
          } else {
            $this->{allLoveBoSpam} = 2;
          }
        if ( $rcptislocal && ( $mPTRSLRE || $mSLRE ) ) {
            $this->{allLovePTRSpam} |= 1;
          } else {
            $this->{allLovePTRSpam} = 2;
          }
        if ( $rcptislocal && ( $mMXASLRE || $mSLRE ) ) {
            $this->{allLoveMXASpam} |= 1;
          } else {
            $this->{allLoveMXASpam} = 2;
          }
        if ( $rcptislocal && ( $mHLSLRE || $mSLRE ) ) {
            $this->{allLoveHlSpam} |= 1;
          } else {
            $this->{allLoveHlSpam} = 2;
          }
        if ( $rcptislocal && ( $mHISLRE || $mSLRE ) ) {
            $this->{allLoveHiSpam} |= 1;
          } else {
            $this->{allLoveHiSpam} = 2;
          }
        if ( $rcptislocal && ( $mSPFSLRE || $mSLRE ) ) {
            $this->{allLoveSPFSpam} |= 1;
          } else {
            $this->{allLoveSPFSpam} = 2;
          }
        if ( $rcptislocal && ( $mRBLSLRE || $mSLRE ) ) {
            $this->{allLoveRBLSpam} |= 1;
          } else {
            $this->{allLoveRBLSpam} = 2;
          }
        if ( $rcptislocal && ($mATSLRE) ) { $this->{allLoveATSpam} |= 1 }
        else                              { $this->{allLoveATSpam} = 2 }
        if ( $rcptislocal && ( $mURIBLSLRE || $mSLRE ) ) {
            $this->{allLoveURIBLSpam} |= 1;
          } else {
            $this->{allLoveURIBLSpam} = 2;
          }
        if ( $rcptislocal && ( $mSRSSLRE || $mSLRE ) ) {
            $this->{allLoveSRSSpam} |= 1;
          } else {
            $this->{allLoveSRSSpam} = 2;
          }
        if ( $rcptislocal && ( $mDLSLRE || $mSLRE ) ) {
            $this->{allLoveDLSpam} |= 1;
          } else {
            $this->{allLoveDLSpam} = 2;
          }
        if ( $rcptislocal && ( $mPBSLRE || $mSLRE ) ) {
            $this->{allLovePBSpam} |= 1;
          } else {
            $this->{allLovePBSpam} = 2;
          }
         if ( $rcptislocal && ( $mSBSLRE || $mSLRE ) ) {
            $this->{allLoveSBSpam} |= 1;
          } else {
            $this->{allLoveSBSpam} = 2;
          }
        if ( $rcptislocal && ( $mISSLRE || $mSLRE ) ) {
            $this->{allLoveISSpam} |= 1;
          } else {
            $this->{allLoveISSpam} = 2;
          }
        if ( $EmailInterfaceOk
            && ( $this->{relayok} || $this->{senderok} || $this->{localuser} ) ) {

            if ( lc $u eq lc "$EmailSpam\@" ) {
                $this->{reporttype} = 0;
                $this->{getline}    = \&ListReport if $EmailErrorsModifyWhite;
                $this->{getline}    = \&SpamReport if !$EmailErrorsModifyWhite;
                mlog( $fh, "email: spamreport", 1 ) if !$EmailErrorsModifyWhite;
                mlog( $fh, "email: combined spam & whitelist deletion report", 1 )
                  if $EmailErrorsModifyWhite;
                $Stats{rcptReportSpam}++;
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailHam\@" ) {
                $this->{reporttype} = 1;
                $this->{getline}    = \&ListReport if $EmailErrorsModifyWhite;
                $this->{getline}    = \&SpamReport if !$EmailErrorsModifyWhite;
                mlog( $fh, "email: hamreport", 1 ) if !$EmailErrorsModifyWhite;
                mlog( $fh, "email: combined ham & whitelist addition report", 1 )
                  if $EmailErrorsModifyWhite;
                $Stats{rcptReportHam}++;
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailWhitelistAdd\@" ) {
                $this->{reporttype} = 2;
                $this->{getline}    = \&ListReport;
                mlog( $fh, "email: whitelist addition report", 1 );
                $Stats{rcptReportWhitelistAdd}++;
                foreach $a ( split( / /, $this->{rcpt} ) ) {
                    ListReportExec( $a, $this );
                  }
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailWhitelistRemove\@" ) {
                $this->{reporttype} = 3;
                $this->{getline}    = \&ListReport;
                mlog( $fh, "email: whitelist deletion report", 1 );
                $Stats{rcptReportWhitelistRemove}++;
                foreach $a ( split( / /, $this->{rcpt} ) ) {
                    ListReportExec( $a, $this );
                  }
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailRedlistAdd\@" ) {
                $this->{reporttype} = 4;
                $this->{getline}    = \&ListReport;
                mlog( $fh, "email: redlist addition report", 1 );
                $Stats{rcptReportRedlistAdd}++;
                foreach $a ( split( / /, $this->{rcpt} ) ) {
                    ListReportExec( $a, $this );
                  }
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailHelp\@" ) {
                $this->{reporttype} = 7;
                $this->{getline}    = \&HelpReport;
                mlog( $fh, "email: help report", 1 );
                $Stats{rcptReportHelp}++;
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailAnalyze\@" ) {
                $this->{reporttype} = 8;
                mlog( $fh, "email: analyze mail report", 1 );
                $this->{getline} = \&AnalyzeReport;
                $Stats{rcptReportAnalyze}++;
                sendque( $fh, "250 OK\r\n" );
                return;
              } elsif ( lc $u eq lc "$EmailRedlistRemove\@" ) {
                $this->{reporttype} = 5;
                $this->{getline}    = \&ListReport;
                mlog( $fh, "email: redlist deletion report", 1 );
                $Stats{rcptReportRedlistRemove}++;
                foreach $a ( split( / /, $this->{rcpt} ) ) {
                    ListReportExec( $a, $this );
                  }
                sendque( $fh, "250 OK\r\n" );
                return;
              }
          }

        $this->{rcptValidated} = $this->{rcptNonexistent} = 0;

        if ( $this->{addressedToSpamBucket} ) {
            $this->{delayed} = "";

            # accept SpamBucket addresses in every case
            $this->{rcpt} .= "$u$h ";
          } elsif ( $LocalAddresses_Flat || $DoLDAP || (scalar(keys %DomainVRFYMTA))) {
            if (   ( $this->{islocalmailaddress} )
                || ( $this->{relayok} ) && !$rcptislocal ) {
                if ( serverIsSmtpDestination($server) ) {
                    if ( !Delayok( $fh, "$u$h" ) ) {
                        $this->{delayqueue} .= "$u$h ";
                        $this->{rcpt}       .= "$u$h ";
                        mlog( $fh, "recipient delaying queued: $u$h", 1 )
                          if $DelayLog == 2;
                        sendque( $server, $l );
                        return;
                      }
                  }
                $this->{donotdelay} = 1;
                $this->{rcpt} .= "$u$h ";
                mlog( $fh, "recipient accepted: $u$h", 1 )
                  if $ValidateUserLog == 2;
                $this->{rcptValidated} = 1;
              } elsif ( $calist{$h} ) {
                my $uh = $calist{$h} . "@" . $h;
                mlog( $fh, "invalid address $u$h replaced with $uh", 1 )
                  if $ValidateUserLog == 2;
                $this->{rcpt} .= "$uh ";
                $this->{messagereason} = "invalid address $u$h";
                pbTrapAdd( $fh, "$u$h" );
                pbAdd( $fh, $this->{ip}, $irValencePB, "InvalidAddress" )
                  if $irValencePB > 0;
                $Stats{rcptNonexistent}++;
                $this->{rcptValidated} = 1;
                $l = "RCPT TO:\<$uh\>\r\n";
              } elsif ($CatchAllAll) {
                my $uh = $CatchAllAll;
                mlog( $fh, "invalid address $u$h replaced with $uh", 1 )
                  if $ValidateUserLog == 2;
                $this->{rcpt} .= "$uh ";
                $this->{messagereason} = "invalid address $u$h";
                pbTrapAdd( $fh, "$u$h" );
                pbAdd( $fh, $this->{ip}, $irValencePB, "InvalidAddress" )
                  if $irValencePB > 0;
                $Stats{rcptNonexistent}++;
                $this->{rcptValidated} = 1;
                $l = "RCPT TO:\<$uh\>\r\n";

              } else {
                $this->{prepend}       = "[InvalidAddress]";
                $this->{messagereason} = "invalid address $u$h";
                mlog( $fh, "invalid address rejected: $u$h" )
                  if $ValidateUserLog;

                pbTrapAdd( $fh, "$u$h" );
                pbAdd( $fh, $this->{ip}, $irValencePB, "InvalidAddress" )
                  if $irValencePB > 0;
                $Stats{rcptNonexistent}++;
                $this->{rcptNonexistent} = 1;
                if ($NoValidRecipient) {
                    $reply = $NoValidRecipient;
                    $reply =~ s/EMAILADDRESS/$u$h/g;
                  } else {
                    $reply = "550 5.1.1 User unknown";
                  }
                
                mlog( $fh, "[SMTP Error] $reply", 1, 1 ) if $replyLogging && $reply !~ /250 OK/;
				$reply .= "\r\n";
                sendque( $fh, $reply );

                # increment error and drop line if necessary
                if ( $this->{serverErrors}++ > $MaxErrors ) {
                    $this->{prepend}       = "[MaxErrors]";
                    $this->{messagereason} = "max errors ($MaxErrors) exceeded";
                    mlog( $fh, "max errors ($MaxErrors) exceeded -- dropping connection" );
                    pbAdd( $fh, $this->{ip}, $meValencePB, "MaxErrors", 2 )
                      if $meValencePB > 0;
                    $Stats{msgMaxErrors}++;
                    delayWhiteExpire($fh);
                    done($fh);
                  }
                return;
              }
          } elsif ( serverIsSmtpDestination($server) ) {
            if ( !Delayok( $fh, "$u$h" ) ) {
                $this->{delayqueue} .= "$u$h ";
                $this->{rcpt}       .= "$u$h ";
                mlog( $fh, "recipient delaying queued: $u$h", 1 )
                  if $ValidateUserLog == 2;
                sendque( $server, $l );
                return;
              }
            $this->{rcpt} .= "$u$h ";
          } else {
            $this->{red} = "$u$h in RedList"
              if ( $Redlist{"$u$h"}
                || $Redlist{"*@$h"}
                || $Redlist{"$wildcardUser@$h"} );
            $this->{rcpt} .= "$u$h ";
            mlog( $fh, "recipient accepted without delaying: $u$h", 1 )
              if $ValidateUserLog == 2;
            $this->{donotdelay}    = 1;
            $this->{rcptValidated} = 1;
          }

        # update Stats
        if ( $this->{rcptnoprocessing} == 1 ) {
            $Stats{rcptUnprocessed}++;
          } elsif ( $this->{addressedToSpamBucket} ) {
            $Stats{rcptSpamBucket}++;
          } elsif ( $this->{allLoveSpam} & 1 ) {
            $Stats{rcptSpamLover}++;
          } elsif ( $this->{rcptValidated} ) {
            $Stats{rcptValidated}++;
          } elsif ( $this->{rcptNonexistent} ) {
            $Stats{rcptNonexistent}++;
          } elsif ($rcptislocal) {
            $Stats{rcptUnchecked}++;
          } elsif ( $Whitelist{ lc "$u$h" } ) {
            pbWhiteAdd( $fh, $this->{ip}, "whitelisted:$u$h" );
            $Stats{rcptWhitelisted}++;
          } else {
            $Stats{rcptNotWhitelisted}++;
          }
        $this->{numrcpt} = 0;    # calculate the total number of rcpt
        foreach ( split( / /, $this->{rcpt} ) ) { $this->{numrcpt}++ }
        $this->{numrcpt} = 1 if ( $this->{numrcpt} == 0 );
      } elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        $this->{skipbytes} = $1;
        d("XEXCH50 b=$1");
      } elsif ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{bdata} = $1;
          } else {
            delete $this->{bdata};
          }
        $this->{rcpt} =~ s/\s$//;

        # drop line if no recipients left
        if ( $this->{rcpt} !~ /@/ ) {

            # possible workaround for GroupWise bug
            if ( $this->{delayed} ) {
                if ($DelayError) {
                    $reply = $DelayError . "\r\n";
                  } else {
                    $reply = "451 4.7.1 Please try again later\r\n";
                  }
                sendque( $fh, $reply );
                mlog( $fh, "DATA phase delayed", 1 ) if $DelayLog;
                $Stats{msgDelayed}++ if ( !$this->{StatsmsgDelayed} );
                $this->{StatsmsgDelayed} = 1;
                return;
              }
            mlog( $fh, "no recipients left -- dropping connection", 1 )
              if $DelayLog || $ValidateUserLog == 2;
            $Stats{msgNoRcpt}++;

            delayWhiteExpire($fh);
            pbAdd( $fh, $this->{ip}, $erValencePB, "NeedRecipient", 2 )
              if $erValencePB > 0;
            seterror( $fh, "503 5.5.2 Need Recipient", 1 );
            return;
          }
        if ( $this->{ismaxsize}  || ( $noProcessing && allNoProcessing( $this->{rcpt} ) )
            || ( $noProcessing && matchSL( $this->{mailfrom}, 'NoProcessing' ) )  ) {
            
            MaillogStart($fh);    # notify the stream logging to start logging

            $this->{noprocessing} = 1;
        
            $this->{myheader}     = '';    # reset myheader
            if ( $BlockNPExes || ( $ScanNP && $UseAvClamd ) ) {
                $this->{getline} = \&whitebodyNoExe;
              } else {
                $this->{getline} = \&whitebody;
                $this->{prepend} = "[NoProcessing]";
                my $logsub = ( $subjectLogging ? " [$this->{originalsubject}]" : "" );
                mlog( $fh, "message proxied without processing - (attachments unchecked)$logsub", 0, 2 );
                $Stats{noprocessing}++;
              }

          } elsif ( $this->{isbounce} && $this->{delayed} ) {
            if ($DelayError) {
                $reply = $DelayError . "\r\n";
              } else {
                $reply = "451 4.7.1 Please try again later\r\n";
              }
            sendque( $fh, $reply );
            mlog( $fh, "Bounce delayed", 1 ) if $DelayLog;
            $Stats{msgDelayed}++ if ( !$this->{StatsmsgDelayed} );
            $this->{StatsmsgDelayed} = 1;
            return;

          } else {
            if ( !$this->{donotdelay} ) {    # if there is a queued delay
                delete $this->{donotdelay};    # and the rcpt to: phase is passed
                if ( $this->{delayqueue} ) {   # and no valid recpt -> delay
                    if ( !$this->{isbounce} ) {
                        if ($DelayError) {
                            $reply = $DelayError . "\r\n";
                          } else {
                            $reply = "451 4.7.1 Please try again later\r\n";
                          }
                        sendque( $fh, $reply );
                        for ( split( ' ', $this->{delayqueue} ) ) {
                            mlog( $fh, "recipient delayed: $_", 1 )
                              if $DelayLog;
                          }
                        delete $this->{delayqueue};
                        $Stats{msgDelayed}++ if ( !$this->{StatsmsgDelayed} );
                        $this->{StatsmsgDelayed} = 1;
                        $this->{delayed}         = 1;
                        return;
                      }
                  }
              } else {
                if ( $this->{delayqueue} ) {
                    for ( split( ' ', $this->{delayqueue} ) ) {
                        mlog( $fh, "queued delay removed for recipient: $_", 1 )
                          if $DelayLog == 2;
                        mlog( $fh, "recipient accepted: $_", 1 )
                          if $ValidateUserLog == 2;
                        $Stats{rcptDelayed}--;
                        $Stats{rcptValidated}++;
                      }
                    delete $this->{delayqueue};
                  }
              }
            MaillogStart($fh);    # notify the stream logging to start logging
            $this->{getline} = \&getheader;
          }
      } elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);          # reset everything
      }
    sendque( $server, $l );
  }

# compile the helo-blacklist ignore regular expression
sub setHBIRE {
    SetRE( 'HBIRE', "^($_[0])\$", "i", "HELO Blacklisted Ignore" );
  }

# get the header part of the DATA.
sub getheader {
    my ( $fh, $l ) = @_;
    d(18);
    my $reply;
    my $done;
    my $this = $Con{$fh};
    if ( $this->{inerror} ) {
        my $server = $this->{friend};
        $this->{getline} = \&getline;
        sendque( $server, $l );
        return;
      }

    $this->{header} .= $l;
    my $headerlength = length( $this->{header} );

    if ($HeaderMaxLength && $headerlength > $HeaderMaxLength ) {
        delayWhiteExpire($fh);
        $this->{prepend} = "[OversizedHeader]";
        mlog( $fh, "Possible Mailloop: Headerlength ($headerlength) > $HeaderMaxLength" );
        seterror( $fh, "554 5.7.1 possible mailloop - oversized header ($headerlength)", 1 );
        done($fh);
        return;
      }

    if ( $l =~ /^\.?[\r\n]*$/ ) {
        $this->{maillength} = length( $this->{header} );
        $this->{noprocessing} = 1 if $this->{ismaxsize};
        my $slok;
        if (  !$this->{contentonly}
            && $contentOnlyRe
            && $contentOnlyReRE != ""
            && $this->{header} =~ ( '(' . $contentOnlyReRE . ')' ) ) {
            mlogRe( $fh, $1, "Contentonly" );
            pbBlackDelete( $fh, $this->{ip} );
            $this->{contentonly} = 1;
            $this->{ispip}       = 1;
          }
        eval {
		if ( $this->{ispip} && $this->{header} =~ /X-Forwarded-For: (\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/i) {
		$this->{cipdone} = 1;
		$this->{cip} = $1;

		while ( $this->{header} =~ /Received: from (.{1,50}) \(\[?$this->{cip}/gis ) {

                $this->{ciphelo} = $1;
                $this->{helo} = $1 if $1;
                $this->{nohelo} = 1 if ( matchIP( $this->{cip}, 'noHelo', $fh ) );

              }
        mlog( $fh, "Found 'X-Forwarded-For' with IP: $this->{cip} and HELO: $this->{ciphelo}", 1, 2 ) if $this->{cip};
		} elsif ( $this->{ispip} && $ispHostnames && !$this->{cipdone} ) {
            $this->{cipdone} = 1;
            while ( $this->{header} =~ /Received: from (.{1,50}) \(\[?(\d+\.\d+\.\d+\.\d+).{1,80}by.{1,20}($ispHostnamesRE)/gis ) {
                next if $2 =~ /$IPprivate/;

                $this->{cip} = $2;

                $this->{ciphelo} = $1;
                $this->{helo} = $1 if $1;
                $this->{nohelo} = 1 if ( matchIP( $this->{cip}, 'noHelo', $fh ) );

              }
        mlog( $fh, "Found Forwarding IP: $this->{cip}, HELO: $this->{ciphelo}", 1, 2 ) if $this->{cip};
          }
        };
        my ($sub) = $this->{header} =~ /Subject: (.{1,80})/;

        $sub = decodeMimeWords($sub);
        $this->{subject3} = $sub;

        $sub =~ y/a-zA-Z0-9/_/cs;
        $this->{originalsubject} = $sub;
        $this->{originalsubject} =~ tr/_/ /;
        $this->{originalsubject} =~ s/\s+$//;
        $this->{originalsubject} =~ s/^\s+//;
        $sub = substr( $sub, 0, 50 );
        $this->{subject}  = $sub;
        $this->{subject2} = $sub;
        
        &IPinHeloOK($fh) if ($this->{cipdone} && $this->{ciphelo} && $this->{cip} && ! $this->{nohelo});

        if ( !ForgedHeloOK($fh) ) {
            $this->{prepend} = "[ForgedHELO]";
            thisIsSpam( $fh, "ForgedHELO:'$this->{helo}'", $forgedHeloLog, $SpamError, $fhTestMode, 0, 0 );
            return;
          }
        if ( !LocalSenderOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLoveISSpam} == 1;
            $Stats{senderInvalidLocals}++ unless $slok;
            $reply = $SenderInvalidError;
            $reply =~ s/REASON/$this->{messagereason}/g;
            $this->{prepend} = "[InvalidLocalSender]";
            thisIsSpam( $fh, "$this->{messagereason}", $spamISLog, $reply, $flsTestMode, $slok, 0 );
            return;
          }
         if (  !$this->{red}
            && $redRe
            && $redReRE != ""
            && $this->{header} =~ ( '(' . $redReRE . ')' ) ) {
            
            mlogRe( $fh, $1, "Red" );
        	$this->{red} = $1;
        }
        # if RELAYOK check localdomains if approprate
        if (   $this->{relayok}
        	&& !$this->{red}
            && $DoLocalSenderDomain
            && !localmail( $this->{mailfrom}) && !localmail( $this->{rcpt}) ) {
            $this->{prepend} = "[RelayAttempt]";
            sendque( $fh, "530 Relaying not allowed - sender domain not local\r\n" );
            $this->{messagereason} = "relay attempt blocked for unknown local sender domain";
            mlog( $fh, $this->{messagereason} );
            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
           
            return;
          }
        # if RELAYOK check localaddresses if approprate
        if (   $this->{relayok}
            && $DoLocalSenderAddress
            && !$this->{red}
            && !LocalAddressOK( $fh) && !localmail( $this->{rcpt}) ) {
            $this->{prepend} = "[RelayAttempt]";
            sendque( $fh, "530 Relaying not allowed - local sender address unknown\r\n" );
            $this->{messagereason} = "relay attempt blocked for unknown local sender address";
            mlog( $fh, $this->{messagereason} );
            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
            
            return;
          }
		
        my ($msgid) = $this->{header} =~ /Message-ID: (.*)/i;
        $this->{msgid} = $msgid;
        $this->{msgid} =~ s/\s+$//;
        RWLok( $fh, $this->{ip} );
        MsgIDOK( $fh, $this->{msgid} );
        GRIPvalue( $fh, $this->{ip} );

        # header is done


        
        if ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;
          }

        onwhitere($fh,$this->{header});
        
        if (   $ccSpamNeverRe
            && $this->{header} =~ ( '(' . $ccSpamNeverReRE . ')' ) ) {
            mlogRe( $fh, $1, "CCnever" );
            $this->{ccnever} = 1;
          }

        if (  !$this->{noprocessing}
            && $npRe
            && $npReRE != ""
            && $this->{header} =~ ( '(' . $npReRE . ')' ) ) {
            mlogRe( $fh, $1, "Noprocessing" );
            pbBlackClear( $fh, $this->{ip} );
            $this->{noprocessing} = 1;
            $this->{myheader}     = '';    # reset myheader
          }

        if ( !$this->{noprocessing} && !$this->{whitelisted} && $WhitelistOnly ) {

            $Stats{bspams}++;
            delayWhiteExpire($fh);
            my $slok = $this->{allLoveSpam} == 1;
            $this->{prepend} = "[WhitelistOnly]";

            thisIsSpam( $fh, "Whitelist Only", $baysSpamLog, $SpamError, $baysTestMode, $slok, 1 );

            return;
          }

        if (  !$this->{spamlover}
            && $SpamLoversRe
            && $SpamLoversReRE != ""
            && $this->{header} =~ ( '(' . $SpamLoversReRE . ')' ) ) {
            mlogRe( $fh, $1, "SpamLover" );
            $this->{spamlover} = 1;
          }
        if (!BombHeaderOK( $fh, $this->{header} ) ) {
            my $bomblt = $bombError;
            $bomblt .= " (reason: $this->{messagereason}) " if $bombErrorReason;
            $Stats{bombs}++;
            delayWhiteExpire($fh);
            my $slok = $this->{allLoveBoSpam} == 1;
            $this->{prepend} = "[BombHeader]";
            thisIsSpam( $fh, "$this->{messagereason}", $spamBombLog, $bomblt, $bombTestMode, $slok, 1 );
			return;
 		}
 		


        if ( $this->{noprocessing} ) {

            if ($SPFNP && !SPFok($fh) ) {
                return;
              }
            $this->{attachcomment} = "attachments unchecked";
            if ($URIBLNP ||  $BlockNPExes || ( $ScanNP && $UseAvClamd ) ) {
                $this->{getline} = \&whitebodyNoExe;
              } else {
                $this->{prepend} = "[NoProcessing]";
                my $logsub = ( $subjectLogging ? " [$this->{originalsubject}]" : "" );
                mlog( $fh, "message proxied without processing ($this->{attachcomment})$logsub", 0, 2 );
                $Stats{noprocessing}++;

                isnotspam($fh);
              }
          } elsif ( onwhitelist( $fh, $this->{header} ) ) {

            if (   ( !$SPFWL || ( $SPFWL && SPFok($fh) ) )
                && ( !$RBLWL || ( $RBLWL && RBLok($fh) ) ) ) {
                if ( TestMessageScore($fh) ) {
                    MessageScore( $fh, $done );
                    return;
                  }
                $this->{attachcomment} = "attachments unchecked";
                if ($URIBLWL || $URIBLLocal || $BlockWLExes || ( ( $ScanWL || $ScanLocal ) && $UseAvClamd ) ) {
                    $this->{getline} = \&whitebodyNoExe;
                  } else {
                    my $fn = Maillog( $fh, '', $NonSpamLog );    # tell maillog this isn't spam
                    $fn = ' -> ' . $fn if $fn;
                    $fn = ""           if !$fileLogging;
                    my $logsub = ( $subjectLogging ? " [$this->{originalsubject}]" : "" );
                    $SpamProb = 0;
                    addSpamProb( $fh, 1 );
                    $this->{prepend} = "[Local]"       if $this->{relayok};
                    $this->{prepend} = "[Whitelisted]" if !$this->{relayok};
                    isnotspam($fh);
                    mlog( $fh, "local ($this->{attachcomment})$logsub$fn", 0, 2 )
                      if $this->{relayok};
                    mlog( $fh, "whitelisted ($this->{attachcomment})$logsub$fn", 0, 2 )
                      if !$this->{relayok};

                  }
              }
          } elsif ( $this->{addressedToSpamBucket} && !$DoNotBlockCollect ) {
            $Stats{spambucket}++;
            pbWhiteDelete( $fh, $this->{ip} );
            $this->{messagereason} = "Collect Address: $this->{addressedToSpamBucket}";
            pbAdd( $fh, $this->{ip}, $saValencePB, "SpamCollectAddress", 2 )
              if $saValencePB > 0;
            RWLCacheAdd( $this->{ip}, 2 );
            $this->{prepend} = "[Collect]";
            delayWhiteExpire($fh);
            thisIsSpam( $fh, "$this->{messagereason}", $spamBucketLog, "250 OK", 0, 0, 0 );
          } elsif (! SenderBaseOK($fh,$this->{ip})) {
            my $slok=$this->{allLoveSBSpam}==1;
            $Stats{sbblocked}++ unless $slok;
            $reply=$SenderInvalidError;

            $reply =~ s/REASON/Country Blocked/g;
            thisIsSpam($fh,$this->{messagereason},$spamSBLog,$reply,$sbTestMode,$slok,0);
          } elsif (!RBLCacheOK( $fh, $this->{ip} ) ) {
          } elsif (!RBLok($fh) ) {
            if ( TestMessageScore($fh) ) {
                MessageScore( $fh, $done );
                return;
              }

          } elsif ( !PBExtremeOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLovePBSpam} == 1;

            my $er = $SpamError;
            $er = $PenaltyError if $PenaltyError;
            thisIsSpam( $fh, $this->{mypbreason}, $spamPBLog, $er, $pbTestMode, $slok, $done );

          
          } elsif ( !BlackDomainOK($fh) ) {
            my $slok = $this->{allLoveBlSpam} == 1;
            $Stats{blacklisted}++ unless $slok;
            thisIsSpam( $fh, $this->{messagereason}, $blDomainLog, $SpamError, $blTestMode, $slok, 0 );

          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;
          } elsif ( !invalidHeloOK( $fh, $this->{helo} ) ) {
            my $slok = $this->{allLoveHiSpam} == 1;
            $Stats{invalidHelo}++ unless $slok;
            $reply = $SenderInvalidError;
            $this->{prepend} = "[InvalidHELO]";
            $reply =~ s/REASON/Invalid HELO Format/g;
            thisIsSpam( $fh, "Invalid HELO: '$this->{helo}'", $spamHeloLog, $reply, $ihTestMode, $slok, 0 );
          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;
          } elsif ( !validHeloOK( $fh, $this->{helo} ) ) {
            my $slok = $this->{allLoveHiSpam} == 1;
            $Stats{invalidHelo}++ unless $slok;
            $reply = $SenderInvalidError;
            $this->{prepend} = "[ValidHELO]";
            $reply =~ s/REASON/Invalid HELO Format/g;
            thisIsSpam( $fh, "Not Valid HELO: '$this->{helo}'", $spamHeloLog, $reply, $ihTestMode, $slok, 0 );
          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;

          } elsif ( !BlackHeloOK( $fh, $this->{helo} ) ) {
            my $slok = $this->{allLoveHlSpam} == 1;
            my $testmode = $hlTestMode;
            $testmode = $slok = 0
              if allSH( $this->{rcpt}, 'hlSpamHaters' );

            $Stats{helolisted}++ unless $slok;
            $this->{prepend} = "[BlackHELO]";
            thisIsSpam( $fh, "HELO-Blacklist: '$this->{helo}'", $spamHeloLog, $SpamError, $testmode, $slok, 0 );
          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;


          } elsif ( !MXAOK($fh) ) {
            my $slok = $this->{allLoveMXASpam} == 1;
            $Stats{mxaMissing}++ unless $slok;
            $reply = $SenderInvalidError;

            $this->{prepend} = "[MissingMXA]";
            $reply =~ s/REASON/Missing MXA record/g;
            thisIsSpam( $fh, "missing MX and A record", $spamMXALog, $reply, $mxaTestMode, $slok, $done );
          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;
          } elsif ( !PTROK($fh) ) {
            $reply = $SenderInvalidError;
            my $slok = $this->{allLovePTRSpam} == 1;

            $reply =~ s/REASON/$this->{messagereason}/g;
            thisIsSpam( $fh, "$this->{messagereason}", $spamPTRLog, $reply, $ptrTestMode, $slok, 0 );
          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;

          } elsif ( $this->{invalidSRSBounce}
            && $SRSValidateBounce
            && !( $this->{ispip} )
            && !( $noSRS && matchIP( $this->{ip}, 'noSRS', 0, 1 ) ) ) {

            my $slok = $this->{allLoveSRSSpam} == 1;
            $Stats{msgNoSRSBounce}++ unless $slok;
            $this->{prepend} = "[SRS]";
            thisIsSpam(
                $fh, 'bounce address not SRS signed',
                $SRSFailLog, '554 5.7.5 Bounce address not SRS signed',
                $srsTestMode, $slok, 0
            );
          } elsif ( !SPFok($fh) ) {
            if ( TestMessageScore($fh) ) {
                MessageScore( $fh, $done );
                return;
              }
          } elsif($this->{isbounce} && ! &BackSctrCheckOK($fh,$this->{ip})) {
            if ( TestMessageScore($fh) ) {
                MessageScore( $fh, $done );
                return;
              }

            # cleared all the above rules - off to Bayesian testing if SPF and DNSBL is OK.
            # and no testcheck was successful.
          } else {
            $this->{getline} = \&getbody;
          }
      }
  }


# Mail::SPF::Query v1.999001
sub SPFok {
    my ($fh) = @_;
    my $this = $Con{$fh};
    my $ip   = $this->{ip};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $helo = $this->{helo};
    my $block;
    my $strict;

    if ( $CanUseSPF2 && $SPF2 ) {
        return &SPF2ok(@_);
      }

    return 1 unless $CanUseSPF && $ValidateSPF;
    return 1 if $this->{relayok};

    #return 1 if $this->{contentonly};
    return 1 if $this->{ispip}        && !$this->{cip};
    return 1 if $this->{whitelisted}  && !$SPFWL;
    return 1 if $this->{noprocessing} && !$SPFNP;

    if (
        $noSPFRe
        && (   ( $this->{mailfrom} && $this->{mailfrom} =~ ( '(' . $noSPFReRE . ')' ) )
            || ( $this->{header} =~ ( '(' . $noSPFReRE . ')' ) ) )
      ) {
        mlogRe( $fh, $1, "noSPF" );
        return 1;
      }

    if (   $strictSPFReRE
        && $this->{mailfrom}
        && $this->{mailfrom} =~ ( '(' . $strictSPFReRE . ')' ) ) {
        mlogRe( $fh, $1, "SPFstrict" );
        $strict = 1;
      }
        if (   $blockstrictSPFReRE
        && $this->{mailfrom}
        && $this->{mailfrom} =~ ( '(' . $blockstrictSPFReRE . ')' ) ) {
        mlogRe( $fh, $1, "blockSPFstrict" );
        $strict = 1;
        $block = 1;
      }
    my $slok = $this->{allLoveSPFSpam} == 1;

    my $mValidateSPF = $ValidateSPF;
    $mValidateSPF = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mValidateSPF = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $spfTestMode || $allTestMode );

    my $tlit = "";
    $tlit = "[monitoring]" if $mValidateSPF == 2;
    $tlit = "[scoring]"    if $mValidateSPF == 3;
    $this->{prepend} = "[SPF]";

    #$this->{prepend} .= $tlit" if $mValidateSPF >= 2;

    my ( $spf_result, $smtp_comment, $header_comment, $spf_record, $detail, $spf_fail, $received_spf );

    my $mf = lc $this->{mailfrom};
    my $mfd = $1 if $mf =~ /\@(.*)/;
    my ( $cachetime, $cresult, $cdomain, $chelo ) = SPFCacheFind( $this->{ip} );

    if ($cachetime) {

        #check for valid cache hit
        #		mlog( $fh, "SPF $tlit: (cache) $cresult $cdomain $chelo", 1, 1 ) if $SPFLog == 2;
        if ( ( $mfd eq $cdomain ) && ( lc $this->{helo} eq $chelo ) ) {
            $spf_result = $cresult;
          }
      }

    if ( !$spf_result ) {
        $cresult = "";
        my $query;
        eval {
            local $SIG{ALRM} = sub { die "spf_query_timeout\n" };    # NB: \n required
            alarm $ALARMtimeout;

            $query = new Mail::SPF::Query(
                sender     => $this->{mailfrom},
                ipv4       => $this->{ip},
                helo       => $this->{helo},
                myhostname => $myName,
                sanitize   => 1,
                trusted    => $SPFtrusted,                                     # non-standard feature
                guess      => $LocalPolicySPF,                                 # non-standard feature
                override   => {"$spfoverride"},                                # non-standard feature
                fallback   => {"$spffallback"},                                # non-standard feature
                debug      => $DebugSPF,
                debuglog   => sub { mlog( $fh, "SPF debuglog: @_", 1, 1 ); }
            );

            alarm 0;
        };

        #exception check
        if ($@) {
            mlog( $fh, "SPFOK: $@", 1, 1 ) if $ExceptionLogging;
            alarm 0;
            return 1;
          }

        ( $spf_result, $smtp_comment, $header_comment, $spf_record, $detail ) = $query->result();

        if ( $SPFCacheInterval > 0 && ( $spf_result !~ /error/ ) ) {
            SPFCacheAdd( $ip, $spf_result, $mfd, $this->{helo} );
          }
      }

    if (
        $spf_result eq 'fail'

        || $spf_result eq 'softfail' && $SPFsoftfail
        || $spf_result eq 'softfail'
        && $strict

        || $spf_result eq 'neutral' && $SPFneutral
        || $spf_result eq 'neutral'
        && $strict

        || $spf_result eq 'none' && $SPFnone

        # error, temperror, permerror, unknown
        || $spf_result =~ /error/ && $SPFqueryerror 
        || $spf_result =~ /^unknown/ && $SPFqueryerror
      ) {
        $spf_fail = 1;
        pbWhiteDelete( $fh, $ip );

      } elsif ( $spf_result eq 'pass' ) {
        $spf_fail = 0;
        $this->{spfok} = 1;

      }

    $received_spf = "SPF: $spf_result";
    $received_spf .= " (cache)" if $cresult;
    $received_spf .= " ip=$ip";
    $received_spf .= " mailfrom=$this->{mailfrom}"
      if ( defined( $this->{mailfrom} ) );
    $received_spf .= " helo=$this->{helo}" if ( defined( $this->{helo} ) );

    mlog( $fh, "$tlit $received_spf", 0, 1 ) if $SPFLog;

    return 1 if $mValidateSPF == 2;

    $this->{myheader} .= "X-Assp-Received-$received_spf\r\n" if $AddSPFHeader;

    if ( $spf_result eq 'neutral' && $spfnValencePB ) {
        $this->{messagereason} = "SPF neutral";
        pbAdd( $fh, $ip, $spfnValencePB, "SPF$spf_result" );

      } elsif ( $spf_result eq 'softfail' && $spfsValencePB ) {
        $this->{messagereason} = "SPF softfail";
        pbAdd( $fh, $ip, $spfsValencePB, "SPF$spf_result" );
      } elsif ( $spf_result eq 'none' && $spfnonValencePB ) {
        $this->{messagereason} = "SPF none";
        pbAdd( $fh, $ip, $spfnonValencePB, "SPF$spf_result" );
      } elsif ( $spf_result =~ /^unknown|error/ && $spfeValencePB ) {
        $this->{messagereason} = "SPF error";
        pbAdd( $fh, $ip, $spfeValencePB, "SPF$spf_result" );

      } elsif ( $spf_fail == 1 && $spfValencePB ) {
        $this->{messagereason} = "SPF $spf_result";
        pbAdd( $fh, $ip, $spfValencePB, "SPF$spf_result" );

      }

    return 1 if $mValidateSPF == 3 && !$block;

    if ( $spf_fail == 1 ) {

        # SPF fail (by our local rules)

        my $reply = $SPFError;
        $reply =~ s/SPFRESULT/$smtp_comment/g;

        $Stats{spffails}++ unless $slok;

        $this->{prepend} = "[SPF]";
        thisIsSpam( $fh, "SPF $spf_result", $SPFFailLog, $reply, $spfTestMode, $slok, 0 );
        return 0;
      }
	pbWhiteAdd( $fh, $ip, "SPFpassed:$mfd" );
    return 1;
  }

# do SPF (sender policy framework) checks
# uses Mail::SPF v2.005
sub SPF2ok {
    my ($fh) = @_;
    my $this = $Con{$fh};
    my $ip   = $this->{ip};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $helo = $this->{helo};
    $helo = "" if $this->{ispip} && $this->{cip};
    my $block;
    my $strict;

    return 1 unless $CanUseSPF2 && $ValidateSPF;
    return 1 if $this->{relayok};
    return 1 if $this->{contentonly};
    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if $this->{whitelisted} && !$SPFWL;
    return 1 if $this->{noprocessing} && !$SPFNP;

    if (
        $noSPFRe
        && (   ( $this->{mailfrom} && $this->{mailfrom} =~ ( '(' . $noSPFReRE . ')' ) )
            || ( $this->{header} =~ ( '(' . $noSPFReRE . ')' ) ) )
      ) {
        mlogRe( $fh, $1, "noSPF" );
        return 1;
      }

    if (   $strictSPFReRE
        && $this->{mailfrom}
        && $this->{mailfrom} =~ ( '(' . $strictSPFReRE . ')' ) ) {
        mlogRe( $fh, $1, "SPFstrict" );
        $strict = 1;
        
      }
    if (   $blockstrictSPFReRE
        && $this->{mailfrom}
        && $this->{mailfrom} =~ ( '(' . $blockstrictSPFReRE . ')' ) ) {
        mlogRe( $fh, $1, "SPFstrict" );
        $strict = 1;
        $block = 1;
      }
    my $slok = $this->{allLoveSPFSpam} == 1;

    my $mValidateSPF = $ValidateSPF;
    $mValidateSPF = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mValidateSPF = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $spfTestMode || $allTestMode );

    my $tlit = "";
    $tlit = "[monitoring]" if $mValidateSPF == 2;
    $tlit = "[scoring]"    if $mValidateSPF == 3;
    $this->{prepend} = "[SPF]";

    #$this->{prepend} .= "[$tlit]" if $mValidateSPF >= 2;

    my ( $spf_result, $local_exp, $authority_exp, $spf_record, $spf_fail, $received_spf );

    my $mf = lc $this->{mailfrom};
    my $mfd = $1 if $mf =~ /\@(.*)/;
    my ( $cachetime, $cresult, $cdomain, $chelo ) = SPFCacheFind($ip);

    if ($cachetime) {

        #check for valid cache hit
        #		mlog( $fh, "SPF $tlit: (cache) $cresult $cdomain $chelo", 1, 1 ) if $SPFLog == 2;
        if ( ( $mfd eq $cdomain ) && ( lc $helo eq $chelo ) ) {
            $spf_result = $cresult;
          }
      }

    if ( !$spf_result ) {
        $cresult = "";
        my $query;
        eval {

            my ( $identity, $scope );
            if ($mfd) {
                $identity = $this->{mailfrom};
                $scope    = 'mfrom';
              } else {
                $identity = $helo;
                $scope    = 'helo';
              }

            my $res = Net::DNS::Resolver->new(
                nameservers => \@nameservers,
                tcp_timeout => $DNStimeout,
                udp_timeout => $DNStimeout,
                retrans     => $DNSretrans,
                retry       => $DNSretry
            );

            my $spf_server = Mail::SPF::Server->new(
                hostname     => $myName,
                dns_resolver => $res
            );

            my $request = Mail::SPF::Request->new(
                versions      => [ 1, 2 ],
                scope         => $scope,
                identity      => $identity,
                ip_address    => $ip,
                helo_identity => $helo
            );

            my $result = $spf_server->process($request);

            $spf_record = $request->record;

            $spf_result    = $result->code;
            $local_exp     = $result->local_explanation;
            $authority_exp = $result->authority_explanation
              if $result->is_code('fail');
            $received_spf = $result->received_spf_header;

            if ($DebugSPF) {

                mlog( $fh, "$tlit spf_result:$spf_result", 1, 1 );
                mlog( $fh, "identity:$identity",           1, 1 );
                mlog( $fh, "scope:$scope",                 1, 1 );
                mlog( $fh, "spf_record:$spf_record",       1, 1 );
                mlog( $fh, "local_exp:$local_exp",         1, 1 );
                mlog( $fh, "authority_exp:$authority_exp", 1, 1 );
                mlog( $fh, "received_spf:$received_spf",   1, 1 );
              }

        };

        #exception check
        if ($@) {

            mlog( $fh, "SPF2OK: $@", 1, 1 ) if $ExceptionLogging;
            return 1;
          }

        if ( $SPFCacheInterval > 0 && ( $spf_result !~ /error/ ) ) {
            SPFCacheAdd( $ip, $spf_result, $mfd, $helo );
          }
      }

    if (
        $spf_result eq 'fail'

        || $spf_result eq 'softfail' && $SPFsoftfail
        || $spf_result eq 'softfail'
        && $strict

        || $spf_result eq 'neutral' && $SPFneutral
        || $spf_result eq 'neutral'
        && $strict

        || $spf_result eq 'none' && $SPFnone

        # error, temperror, permerror, unknown
        || $spf_result =~ /error/ && $SPFqueryerror 
        || $spf_result =~ /^unknown/ && $SPFqueryerror
      ) {
        $spf_fail = 1;
        pbWhiteDelete( $fh, $ip );

      } elsif ( $spf_result eq 'pass' ) {
        $spf_fail = 0;
        $this->{spfok} = 1;

      }

    $received_spf = "SPF: $spf_result";
    $received_spf .= " (cache)" if $cresult;
    $received_spf .= " ip=$ip";
    $received_spf .= " mailfrom=$this->{mailfrom}"
      if ( defined( $this->{mailfrom} ) );
    $received_spf .= " helo=$this->{helo}" if ( defined($helo) );

    mlog( $fh, "$tlit $received_spf", 0, 1 ) if $SPFLog;

    return 1 if $mValidateSPF == 2;

    $this->{myheader} .= "X-Assp-Received-$received_spf\r\n" if $AddSPFHeader;

    if ( $spf_result eq 'neutral' ) {
        $this->{messagereason} = "SPF neutral";
        pbAdd( $fh, $ip, $spfnValencePB, "SPF$spf_result" );

      } elsif ( $spf_result eq 'softfail' ) {
        $this->{messagereason} = "SPF softfail";
        pbAdd( $fh, $ip, $spfsValencePB, "SPF$spf_result" );
      } elsif ( $spf_result eq 'none' ) {
        $this->{messagereason} = "SPF none";
        pbAdd( $fh, $ip, $spfnonValencePB, "SPF$spf_result" );
      } elsif ( $spf_result =~ /^unknown|error/ ) {
        $this->{messagereason} = "SPF error";
        pbAdd( $fh, $ip, $spfeValencePB, "SPF$spf_result" );
      } elsif ( $spf_fail == 1 ) {
        $this->{messagereason} = "SPF $spf_result";
        pbAdd( $fh, $ip, $spfValencePB, "SPF$spf_result" );

      }

    return 1 if $mValidateSPF == 3 && !$block;

    if ( $spf_fail == 1 ) {

        # SPF fail (by our local rules)

        my $reply = $SPFError;
        $reply =~ s/SPFRESULT/$local_exp/g;

        $Stats{spffails}++ unless $slok;

        $this->{prepend} = "[SPF]";
        thisIsSpam( $fh, "SPF $spf_result", $SPFFailLog, $reply, $spfTestMode, $slok, 0 );
        return 0;
      }
	pbWhiteAdd( $fh, $ip, "SPFpassed:$mfd" );
    return 1;
  }
  
# do GRIP value
sub GRIPvalue {
    my ( $fh, $ip ) = @_;
    my $this = $Con{$fh};
    return 1 if $this->{gripdone};
    $this->{gripdone} = 1;
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    return 1 if $this->{addressedToSpamBucket};

    return 1 if $this->{relayok};
    return 1 if $this->{nopb};
    return 1 if $this->{nopbwhite};
    return 1 if $this->{whitelisted};
    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if $this->{noprocessing};
    return 1 if !$gripValencePB;

    my $ip3 = $ip;
    $ip3 =~ s/(\d+\.\d+\.\d+).*/$1/;
    my $v = $Griplist{$ip3};
    return if !$v;
    $this->{messagereason} = "$ip3 in griplist > 0,9" if $v > 0.9;
    $this->{messagereason} = "$ip3 in griplist < 0,1" if $v < 0.1;
    pbAdd( $fh, $ip, $gripValencePB,  "grip>=0.9", 1 ) if $v > 0.9;
    pbAdd( $fh, $ip, -$gripValencePB, "grip<=0.1", 1 ) if $v < 0.1;

    return;
  }

# do Message-ID checks
sub MsgIDOK {

    my ( $fh, $msgid ) = @_;
    my $this = $Con{$fh};
    my $tlit;
    return 1 if $this->{msgiddone};
    $this->{msgiddone} = 1;

    return 1 if !$DoMsgID;
    return 1 if $this->{ip} =~ /$IPprivate/;
    return 1 if $this->{contentonly};
    return 1 if $this->{isbounce};
    return 1 if $this->{rwlok};
    return 1 if $this->{nodelay};
    return 1 if $this->{addressedToSpamBucket};
    return 1 if $this->{relayok};
    return 1 if $this->{whitelisted};
    return 1 if $this->{ispip};
    return 1 if $this->{noprocessing};
    return 1 if $noMsgID && matchIP( $this->{ip}, 'noMsgID', $fh );

    $tlit = "[monitoring]" if $DoMsgID == 2;
    $tlit = "[scoring]"    if $DoMsgID == 3;
    my $userpart;
    ($userpart) = $this->{mailfrom} =~ /(.*)@/;
    my $domainpart;
    ($domainpart) = $msgid =~ /@(.*)/;

    if ( !$msgid ) {
        $this->{prepend}       = "[MsgID]";
        $this->{messagereason} = "Message-ID missing";
        mlog( $fh, "$tlit ($this->{messagereason})" ) if $DoMsgID >= 2 && $midmValencePB > 0;
        return 1 if $DoMsgID == 2;
        pbAdd( $fh, $this->{ip}, $midmValencePB, "Msg-IDmissing" );

        return 1 if $DoMsgID == 3;

      }
    eval {
        if ( $msgid =~ /$userpart/i && $domainpart !~ /\./ ) {
            $this->{prepend}       = "[MsgID]";
            $this->{messagereason} = "Message-ID suspicious: '$this->{msgid}'";
            mlog( $fh, "$tlit ($this->{messagereason})" ) if $DoMsgID >= 2 && $midsValencePB > 0;
            return 1 if $DoMsgID == 2;
            pbAdd( $fh, $this->{ip}, $midsValencePB, "Msg-IDsuspicious",1 );

            return 1 if $DoMsgID == 3;
            return 0;
          }
       
		if ( $validMsgIDRe
            && $msgid !~ $validMsgIDReRE ) {
            $this->{prepend}       = "[MsgID]";
            $this->{messagereason} = "Message-ID not valid: '$this->{msgid}'";
            mlog( $fh, "$tlit ($this->{messagereason})" ) if $DoMsgID >= 2 && $midsValencePB > 0;
            return 1 if $DoMsgID == 2;
            pbAdd( $fh, $this->{ip}, $midsValencePB, "Msg-IDsuspicious" );

            return 1 if $DoMsgID == 3;
            return 0;
          }
    };
  }
sub configUpdateBDNSCR {my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Backscatter-DNS Cache Refresh updated from '$old' to '$new'") unless $init || $new eq $old;
    &cleanCacheBackDNS;
}

sub cleanCacheBackDNS {
    my $ips_before= my $ips_deleted=0;
    my $t=time;
    my $ct;
    my $status;
    while (my ($k,$v)=each(%BackDNS)) {
        ($ct,$status)=split(" ",$v);

        $ips_before++;
        if ($t-$ct>=$BackDNSInterval*3600*24) {
            delete $BackDNS{$k};
            $ips_deleted++;
        }
    }
    mlog(0,"BackDNS: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted") if  $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            %BackDNS=();
          } else {
            $BackDNSObject->flush();
            unlink "$base/$pbdb.back.db.bak";
            rename( "$base/$pbdb.back.db", "$base/$pbdb.back.db.bak" );
            $BackDNSObject->DESTROY();
            $BackDNS{""} = "" if $ips_before == 0;
          }
      }
}
sub BackDNSCacheAdd {
    return 0 if !$BackDNSInterval;
    my($myip,$status)=@_;
    my $t=time;
    my $data="$t $status";
    $BackDNS{$myip}=$data;
}

#
sub BackDNSCacheFind {
    my($myip,$mystatus)=@_;
    return 0 if !$BackDNSInterval;
    return 0 unless ($BackDNSObject);
    if (exists $BackDNS{$myip}) {
        my($ct,$status)=split(" ",$BackDNS{$myip});
        return $status;
    }
    return 0;
}

sub BackSctrCheckOK {
    my ($fh,$ip) = @_;
    my $this = $Con{$fh};
    my $chip;
    my $reason;
    my $lvl;

    return 1 if $this->{backsctrdone};
    $this->{backsctrdone} = 1;
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};

    return 1 unless $CanUseDNS;
    return 1 unless $BackSctrServiceProvider;
    return 1 if !$DoBackSctr;
    return 1 if $this->{contentonly};
    return 1 if !$this->{isbounce};
    return 1 if $this->{addressedToSpamBucket};
    return 1 if $this->{relayok};
    return 1 if ($this->{whitelisted} && !$BackWL);
    return 1 if ($this->{noprocessing} && !$BackNP);
    return 1 if &matchIP($this->{ip},'noBackSctrIP',$fh);
    
#    return 1 if ($MSGIDsigAddresses && !matchSL($this->{rcpt},'MSGIDsigAddresses'));
    return 1 if ($noBackSctrAddresses && &matchSL($this->{rcpt},'noBackSctrAddresses'));
    return 1 if ($noBackSctrAddresses && &matchSL($this->{mailfrom},'noBackSctrAddresses'));

    my $tlit="monitoring" if $DoBackSctr==2;
    $tlit="scoring" if $DoBackSctr==3;
    $tlit="testmode" if $DoBackSctr==4;
    $this->{prepend}="[Backscatter]";

    my $backcache = &BackDNSCacheFind($ip);
    $reason = &BackSctrDNS($fh,$ip,@backsctrlist) if (! $backcache);

    if (! $reason || $backcache == 2) {
        my $txt = $backcache ? ' [cache]' : '';
        mlog($fh,"[$tlit] Backscatter detection OK$txt") if $BacksctrLog == 2;
        &BackDNSCacheAdd($ip,2);
        return 1;
    }

    &BackDNSCacheAdd($ip,1) if (! $backcache);

    $this->{messagereason}=$reason;

    mlog($fh,"[$tlit] $this->{messagereason}") if $BacksctrLog;
    return 1 if ($DoBackSctr == 2 or $DoBackSctr == 4);
    pbWhiteDelete($fh,$this->{ip});
    pbAdd($fh,$this->{ip},$backsctrValencePB,"Backscatter-failed") if $backsctrValencePB>0;
    $Stats{msgBackscatterErrors}++;
    return 1 if $DoBackSctr==3;
    if ($Back250OKISP && ($this->{ispip} || $this->{cip})) {
        $this->{accBackISPIP} = 1;
        mlog($fh,"info: force sending 250 OK to ISP for failed bounced message") if $BacksctrLog;;
        return 1;
    } else {
        thisIsSpam($fh,$this->{messagereason},$BackLog,"554 5.7.9 $reason",$DoBackSctr==4,0,1);
        return 0;
    }
}

sub configUpdateBDNSCR {my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Backscatter-DNS Cache Refresh updated from '$old' to '$new'") unless $init || $new eq $old;
    &cleanCacheBackDNS;
}

sub cleanCacheBackDNS {
    my $ips_before= my $ips_deleted=0;
    my $t=time;
    my $ct;
    my $status;
    while (my ($k,$v)=each(%BackDNS)) {
        ($ct,$status)=split(" ",$v);

        $ips_before++;
        if ($t-$ct>=$BackDNSInterval*3600*24) {
            delete $BackDNS{$k};
            $ips_deleted++;
        }
    }
    mlog(0,"BackDNS: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted") if  $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            %BackDNS=();
          } else {
            $BackDNSObject->flush();
            unlink "$base/$pbdb.back.db.bak";
            rename( "$base/$pbdb.back.db", "$base/$pbdb.back.db.bak" );
            $BackDNSObject->DESTROY();
            $BackDNS{""} = "" if $ips_before == 0;
          }
      }
}
# returns undef on success
# returns DNS-result if listed
sub BackSctrDNS {
    my ($fh,$ip,@url) = @_;

    my $backsctr = eval {
        RBL->new(
            lists       => [@url],
            server      => $nameservers[0],
            max_hits    => 1,
            max_replies => 1,
            query_txt   => 1,
            max_time    => 30,
            timeout     => $DNStimeout
        );
    };

    # add exception check
    if ($@) {return undef; }
    my $lookup_return = $backsctr->lookup($ip,"BACKSCATTER");
    
    if ($lookup_return ne 1) {
        mlog($fh,"error: Backscatterer-DNS check failed : $lookup_return");
        return undef;
    }
    my @listed_by = $backsctr->listed_by();
    return $backsctr->{results}->{$listed_by[0]} if ( @listed_by > 0 );
    return undef;
}


# do RWL checks
sub RWLok {
    my ( $fh, $ip ) = @_;
    my $this = $Con{$fh};

    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    return 1 if $this->{addressedToSpamBucket};

    #return 1 if $this->{contentonly};
    return 1 if $ip =~ /$IPprivate/;
    return 1 if $noRWL && matchIP( $this->{ip}, 'noRWL', $fh );
    return 1 if $this->{relayok};
    return 1 if $this->{whitelisted};
    return 1 if $this->{ispip}   && !$this->{cip};
    return 1 if !$CanUseRWL;
    return 1 if !$ValidateRWL;
    return 1 if RWLCacheFind($ip) == 2;
    return 1 if $this->{noprocessing};
    return 1 if pbWhiteFind($ip) && !$RWLwhitelisting;
    my $trust;
    my ( $rwls_returned, @listed_by, $skip, $rwl, $received_rwl, $time, $err );

    if ( $noRWL && matchIP( $ip, 'noRWL', $fh ) ) {
        $this->{myheader} .= "X-Assp-Received-RWL: lookup skipped (noRWL sender)\r\n"
          if $AddRWLHeader;
        return 1;
      }

    ( $rwls_returned, @listed_by ) = ();
    if ( @{ $this->{RWLcache} } ) {
        ( $rwls_returned, @listed_by, $trust ) = @{ $this->{RWLcache} };
      } else {
        ($skip) = ();
        if (   !( $CanUseRWL && $ValidateRWL )
            || $this->{relayok}
            || $this->{ispip} ) {
            $skip = 1;
          }
        unless ($skip) {
            $rwl = RBL->new(
                lists       => [@rwllist],
                server      => $nameservers[0],
                max_hits    => $RWLminhits,
                max_replies => $RWLmaxreplies,
                query_txt   => 0,
                max_time    => $RWLmaxtime,
                timeout     => 1
            );
            ($received_rwl) = ();
            $lookup_return = $rwl->lookup( $ip, "RWL" );
            @listed_by     = $rwl->listed_by();
            $rwls_returned = $#listed_by + 1;
            if ( $rwls_returned >= $RWLminhits ) {
                $trust        = 2;
                $received_rwl = "Received-RWL: whitelisted from (";

                foreach (@listed_by) {

                    $trust = $1
                      if $_ =~ /list.dnswl.org/i
                          && $rwl->{results}->{$_} =~ /127.\d+.\d+.(\d)/;
                    $received_rwl .= "$_->" . $rwl->{results}->{$_} . ",trust=$trust; ";
                  }
                $received_rwl .= ") client-ip=$ip";
                mlog( $fh, $received_rwl, 1 );
                $this->{rwlok} = $trust if $trust > 0;
                pbBlackDelete( $fh, $ip );
                RBLCacheDelete($ip);
                $this->{myheader} .= "X-Assp-$received_rwl\015\012"
                  if $AddRWLHeader;
                $this->{whitelisted} = 1 if $trust > 2 && $RWLwhitelisting;
                RWLCacheAdd( $ip, 1, $trust );
                pbWhiteAdd( $fh, $ip, "RWL" ) if $trust > 1;

              } elsif ( $rwls_returned > 0 ) {
                $received_rwl = "Received-RWL: listed from @listed_by; client-ip=$ip";
                mlog( $fh, $received_rwl, 1 ) if $RWLLog;

                RWLCacheAdd( $ip, 2 );
              } else {
                $received_rwl = "Received-RWL: listed from none; client-ip=$ip";
                mlog( $fh, $received_rwl, 1 ) if $RWLLog == 2;

                RWLCacheAdd( $ip, 2 );
              }
          }
        @{ $this->{RWLcache} } = ( $rwls_returned, @listed_by, $trust );
      }
    return;
  }

# do RBL checks

sub RBLok {
    my ($fh) = @_;
    my $this = $Con{$fh};
    my $reason;
    my $ip = $this->{ip};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};

    return 1 if $this->{rbldone};
    $this->{rbldone} = 1;
    d('RBLok');
    return 1 if !$ValidateRBL;
    return 1 if !$CanUseRBL;
    return 1 if $this->{rwlok};
    return 1 if $this->{relayok};
    return 1 if $this->{nodelay} && !$this->{cip};
    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if $noRBL && matchIP( $ip, 'noRBL', 0, 1 );
    ##return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted} && !$RBLWL;
    my $slok         = $this->{allLoveRBLSpam} == 1;
    my $mValidateRBL = $ValidateRBL;
    $this->{testmode} = $rblTestMode || $allTestMode;
    $this->{spamlover} = $slok = 0 if allSH( $this->{rcpt}, 'rblSpamHaters' );
    $mValidateRBL = 3
      if $ValidateRBL==1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mValidateRBL = 3
      if $ValidateRBL==1 && $switchTestToScoring && $DoPenaltyMessage && $this->{testmode};
    my $tlit;
    $tlit = ""             if $mValidateRBL == 1;
    $tlit = "[monitoring]" if $mValidateRBL == 2;
    $tlit = "[scoring]"    if $mValidateRBL == 3;
    $this->{prepend} = "[DNSBL]";

    #$this->{prepend} .= "[monitoring]" if $mValidateRBL == 2;
    #$this->{prepend} .= "[scoring]"    if $mValidateRBL == 3;

    my $rbl = eval {
        RBL->new(
            lists       => [@rbllist],
            server      => $nameservers[0],
            max_hits    => $RBLmaxhits,
            max_replies => $RBLmaxreplies,
            query_txt   => 1,
            max_time    => $RBLmaxtime,
            timeout     => $RBLsocktime
        );
    };

    # add exception check
    if ($@) { return 1; }

    my ( $received_rbl, $rbl_result, $lookup_return );
    $lookup_return = $rbl->lookup( $ip, "RBL" );
    my @listed_by = $rbl->listed_by();
    my $rbls_returned = $#listed_by + 1;
    if ( $rbls_returned > 0 ) {
        $reason = $this->{messagereason} = "";
        if ( $rbls_returned >= $RBLmaxhits ) {
            pbWhiteDelete( $fh, $ip );
            $this->{messagereason} = "DNSBL failed, $ip listed by @listed_by";
            pbAdd( $fh, $ip, $rblValencePB, "DNSBLfailed" )
              if $mValidateRBL != 2;
            $received_rbl = "DNSBL: failed, $ip listed by(";
          } else {
            pbWhiteDelete( $fh, $ip );
            $this->{messagereason} = "DNSBL neutral, $ip listed by @listed_by";
            $this->{prepend}       = "[DNSBL]";
            mlog( $fh, "[scoring] DNSBL neutral, $ip listed by @listed_by" )
              if ( $RBLLog && $mValidateRBL == 1 && $rblnValencePB );
            pbAdd( $fh, $ip, $rblnValencePB, "DNSBLneutral" )
              if $mValidateRBL != 2;
            $this->{rblneutral} = 1;
            $received_rbl = "DNSBL: neutral, $ip listed by (";
          }
        foreach (@listed_by) {
            $received_rbl .= "$_->" . $rbl->{results}->{$_} . "; ";
          }
        $received_rbl .= ")";
      } else {
        $received_rbl = "DNSBL: pass";
        RBLCacheAdd( $ip,  "2");
      }
    mlog( $fh, "$tlit ($received_rbl)" ) if ( $RBLLog && $mValidateRBL >= 2 );
    
    return 1 if $mValidateRBL == 2;

    # add to our header; merge later, when client sent own headers
    $this->{myheader} .= "X-Assp-$received_rbl\r\n"
      if $AddRBLHeader && $received_rbl ne "DNSBL: pass";

    if ( $rbls_returned >= $RBLmaxhits ) {
        my $slok = $this->{allLoveRBLSpam} == 1;
        $Stats{rblfails}++;
        if ( $RBLCacheExp > 0 ) {
            RBLCacheAdd( $ip,  "1", "@listed_by" );
          }
        return 1 if $mValidateRBL == 3;
        my $reply = $RBLError;
        $reply =~ s/RBLLISTED/@listed_by/g;
        $this->{prepend} = "[DNSBL]";
        thisIsSpam( $fh, "DNSBL, $ip listed by @listed_by",
            $RBLFailLog, "$reply", $rblTestMode, $slok, ( $slok || $rblTestMode || $this->{spamlover} ) );
        return 0;
      }
    return 1;
  }

# do URIBL checks

sub URIBLok {
    my ( $fh, $b, $thisip ) = @_;
    my $this = $Con{$fh};
    d('URIBLok');
    $thisip = $this->{cip} if $this->{ispip} && $this->{cip};

    my $slok = $this->{allLoveURIBLSpam} == 1;
    my ( %domains, $ucnt, $uri, $mycache, $orig_uri, $i, $ip, $tlit, $uribl, $received_uribl, $uribl_result );
    my ( $lookup_return, @listed_by, $listed_domain, $uribls_returned, $lcnt, $err );

    return 1 if !$ValidateURIBL;
    return 1 if $this->{whitelisted} && !$URIBLWL;
    return 1 if $this->{relayok} && !$URIBLLocal;
    return 1 if $this->{noprocessing} && !$URIBLNP;
    return 1 if $this->{ispip} && !$URIBLISP && !$this->{cip};
    return 1 unless $CanUseURIBL && $ValidateURIBL;
    my $mValidateURIBL = $ValidateURIBL;
    $mValidateURIBL = 3
      if $ValidateURIBL == 1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mValidateURIBL = 3
      if $ValidateURIBL == 1 && $switchTestToScoring
          && $DoPenaltyMessage
          && ( $uriblTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mValidateURIBL == 2;
    $tlit = "[scoring]"    if $mValidateURIBL == 3;
    $this->{prepend} = "[URIBL]";

    #$this->{prepend} .= "[$tlit]" if $mValidateURIBL >= 2;

    if (   $noURIBL
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noURIBL' ) ) {
        mlog( $fh, "URIBL lookup skipped (noURIBL sender)", 1 )
          if $URIBLLog == 2;
        $this->{myheader} .= "X-Assp-Received-URIBL: lookup skipped (noURIBL sender)\r\n"
          if $AddURIBLHeader;
        return 1;
      }

    while ( $b =~ /(?:ht|f)tps?[\041-\176]{0,3}\:\/{1,3}($URIRe)|((?:www|ftp)(?:[\=\%]2e|\&\#0?46\;?|\.)$URIRe)/gio ) {
        $uri = $1 || $2;

        # RFC 2821, section 4.5.2, 'Transparency': delete leading '.' character
        $uri =~ s/$URIContinuationRe\.?//go;           # and strip line continuations
        $uri =~ s/\=([a-f0-9]{2})/chr(hex($1))/gie;    # decode quoted-printables
        $uri =~ s/\%40|\&\#0?64\;?/@/g;                # decode '@' character
        if ( $uri =~ /(?:[^\s\/\@]+\@)?($URIHostRe)/io ) {
            $uri = $1;

            # fix HTML
            $uri =~ s/[\=\%]2[ef]|\&\#0?4[67]\;?/./gi;                # decode '.,' characters
            $uri =~ s/\&(?:nbsp|amp|quot|gt|lt|\#0?1[03])\;?.*$//i;
            $uri =~ s/(?:$URISubDelimsCharRe|\.)+$//o;

            $orig_uri = $uri;
            $uri =~ s/\%([a-f0-9]{2})/chr(hex($1))/gie;               # decode percents
            $uri =~ s/\&\#(\d{1,3})\;?/chr($1)/ge;                    # decode &#ddd's
                                                                      # strip redundant dots
            $uri =~ s/\.{2,}/\./g;
            $uri =~ s/^\.//;
            $uri =~ s/$URISubDelimsCharRe//go;                        # more tricks?

            if ( $uri =~ /^$IPQuadRE$/io ) {
                $i = $ip = undef;
                while ( $i < 10 ) {
                    $ip = ( $ip << 8 ) + oct( ${ ++$i } ) + hex( ${ ++$i } ) + ${ ++$i };
                  }
                $uri = inet_ntoa( pack( 'N', $ip ) );
                if ( $URIBLNoObfuscated && $orig_uri !~ /^\Q$uri\E/i ) {
                    $this->{obfuscatedip} = 1;
                  }
              } else {
                if ( $URIBLNoObfuscated && $orig_uri !~ /^\Q$uri\E/i ) {

                    $this->{obfuscateduri} = 1;
                  }
                if ( $uri =~ $URIBLCCTLDSRE || $uri =~ /([^\.]+\.[^\.]+)$/ ) {
                    $uri = $1;
                  } else {
                    next;
                  }
              }
            next if $uri =~ $URIBLWLDRE || $uri =~ $NPDRE || $uri =~ $WLDRE;
            next
              if "@$uri" =~ $URIBLWLDRE
                  || "@$uri" =~ $NPDRE
                  || "@$uri" =~ $WLDRE;
            if ( $URIBLmaxuris && ++$ucnt > $URIBLmaxuris ) {
                $this->{maximumuri} = 1;
                last;
              }

            if ( !$domains{ lc $uri }++ ) {
                if ( $URIBLmaxdomains && keys(%domains) > $URIBLmaxdomains ) {
                    $this->{maximumuniqueuri} = 1;
                    last;
                  }
              }
          }
      }
    my $urinew = eval {
        RBL->new(
            lists       => [@uribllist],
            server      => $nameservers[0],
            max_hits    => $URIBLmaxhits,
            max_replies => $URIBLmaxreplies,
            query_txt   => 1,
            max_time    => $URIBLmaxtime,
            timeout     => $URIBLsocktime
        );
    };

    # add exception check
    if ($@) { return 1; }

    $received_uribl = $uribl_result = $lookup_return = @listed_by = $listed_domain = $uribls_returned = undef;

    for my $domain ( keys %domains ) {
        next if !$domain;
        $mycache = 0;
        next if ( URIBLCacheFind($domain) == 2  );

        if ( URIBLCacheFind($domain) == 1 ) {
            $uribls_returned = $URIBLmaxhits;
            $listed_domain   = $domain;
            my ( $ct, $status, $listed ) = split( " ", $URIBLCache{$domain} );

            @listed_by = $listed;
            $mycache   = 1;

            last;
          } else {

            $lookup_return   = $urinew->lookup( $domain, "URIBL" );
            @listed_by       = $urinew->listed_by();
            $lcnt            = $#listed_by + 1;
            $uribls_returned = $lcnt if $lcnt > $uribls_returned;

            URIBLCacheAdd( $domain, "2" ) if $lcnt == 0;

          }
        if ( $uribls_returned >= $URIBLmaxhits ) {

            URIBLCacheAdd( $domain, "1", @listed_by );

            $listed_domain = $domain;

            last;
          }
      }

    if ($mycache) {
        $this->{prepend} = "[URIBL][scoring]"    if $mValidateURIBL == 3;
        $this->{prepend} = "[URIBL][monitoring]" if $mValidateURIBL == 2;
        mlog( $fh, "$tlit (URIBLcache fail, $listed_domain listed in @listed_by)" )
          if ( $URIBLLog && $mValidateURIBL >= 2 );
        return 1 if $mValidateURIBL == 2;
        $received_uribl = "Received-URIBL: fail (cache @listed_by)";

      } else {
        if ( $uribls_returned > 0 ) {
            if ( $uribls_returned >= $URIBLmaxhits ) {

                $received_uribl = "Received-URIBL: fail (";

              } else {
                $this->{prepend} = "[URIBL][neutral]" if $mValidateURIBL != 3;
                $this->{prepend} = "[URIBL][monitoring]"
                  if $mValidateURIBL == 2;
                $this->{messagereason} = "URIBL neutral, '$listed_domain' listed in @listed_by";
                mlog( $fh, "$tlit ($this->{messagereason}" )
                  if ( $URIBLLog && $mValidateURIBL >= 2 );
                pbWhiteDelete( $fh, $thisip );
                return 1 if $mValidateURIBL == 2;

                pbAdd( $fh, $thisip, $uriblnValencePB, "URIBLneutral" )
                  if $uriblnValencePB > 0;
                return 1 if $mValidateURIBL == 3;
                $received_uribl = "Received-URIBL: neutral (";

              }
            foreach (@listed_by) {

                $received_uribl .= "$_->" . $urinew->{results}->{$_} . "; ";
              }
            $received_uribl .= ")";
          } else {
            $received_uribl = "Received-URIBL: pass";
            $this->{messagereason} = "$received_uribl";
            mlog( $fh, "$tlit ($this->{messagereason})", 1 )
              if $mValidateURIBL >= 2 && $URIBLLog == 2;

            return 1;
          }

        $this->{prepend} = "[URIBL][scoring]" if $mValidateURIBL == 3;
        $this->{messagereason} = "$received_uribl";
        mlog( $fh, "$tlit ($this->{messagereason})", 1 )
          if $mValidateURIBL >= 2 && $URIBLLog;

      }

    return 1 if $mValidateURIBL == 2;
    $this->{myheader} .= "X-Assp-$received_uribl\r\n"
      if $AddURIBLHeader && $received_uribl ne "Received-URIBL: pass";
    if ( $uribls_returned >= $URIBLmaxhits ) {
        $this->{messagereason} = "$received_uribl";
        pbWhiteDelete( $fh, $this->{ip} );
        pbAdd( $fh, $thisip, $uriblValencePB, "URIBLfailed" )
          if $uriblValencePB > 0;
        return 1 if $mValidateURIBL == 3;
        $err = $URIBLError;
        $err =~ s/URIBLNAME/@listed_by/g;
        $this->{prepend} = "[URIBL]";
        $Stats{uriblfails}++ unless $slok;
        thisIsSpam( $fh, $this->{messagereason}, $URIBLFailLog, $err, $uriblTestMode, $slok, 1 );
        return 0;
      }
    return 1;
  }


sub ipNetwork {
    my ( $ip, $cidr ) = @_;
    my $u32 = unpack "N", pack "CCCC", split /\./, $ip;
    my $mask = unpack "N", pack "B*", "1" x $cidr . "0" x ( 32 - $cidr );
    return join ".", unpack "CCCC", pack "N", $u32 & $mask;
  }

sub ipBroadcast {
    my ( $ip, $cidr ) = @_;
    my $u32 = unpack "N", pack "CCCC", split /\./, $ip;
    my $mask = unpack "N", pack "B*", "1" x $cidr . "0" x ( 32 - $cidr );
    return join ".", unpack "CCCC", pack "N", $u32 | ~$mask;
  }

sub formatTimeInterval {
    my $interval = shift;
    my $res;
    $res .= $_ . "d " if local $_ = int( $interval / ( 24 * 3600 ) );
    $interval %= ( 24 * 3600 );
    $res .= $_ . "h " if $_ = int( $interval / 3600 );
    $interval %= 3600;
    $res .= $_ . "m " if $_ = int( $interval / 60 );
    $interval %= 60;
    $res .= $interval . "s " if ( $interval || !defined $res );
    $res =~ s/\s$//;
    return $res;
  }

sub IPinHeloOK {
    my ( $fh, $rcpt ) = @_;
    my $this = $Con{$fh};
    d('IPinHeloOK');
    my $tlit;

    return 1 if !$DoIPinHelo;
    return 1 if $this->{relayok};
    return 1 if $this->{acceptall};
    return 1 if $this->{ispip};
    return 1 if $this->{nohelo};

    return 1 if $this->{ip} =~ /$IPprivate/;
    return 1 if $heloBlacklistIgnore && $this->{helo} =~ $HBIRE;
    return 1 if $Whitelist{ $this->{mailfrom} } && $DoFakedWL;
    return 1 if $this->{helo} eq $this->{ip};
    return 1 if $noProcessing && matchSL( $this->{mailfrom}, 'noProcessing' ) && $DoFakedNP;

    $tlit = "[spam found]";
    $tlit = "[monitoring]" if $DoIPinHelo == 2;
    $tlit = "[scoring]" if $DoIPinHelo == 3;
    my $literal;

    if ( $this->{helo} =~ /\[?((?:\d{1,3}(\.|\-)){3}\d{1,3})\]?/ ) {
        $literal = $1;

        # replace any - characters with a dot
        $literal =~ s/-/\./g;

        # remove leading zeros and put it into an array
        my @octets = map {
            if ( !m/^0$/i ) { s/^0*//; $_ }
            else            { 0 }    # properly handle a 0 in the IP
        } split( /\./, $literal );

        #put the ip back together
        $literal = join '.', @octets;
        my $reverse_ip = join '.', reverse(@octets);

        $this->{messagereason} = "Suspicious HELO - contains IP: '$this->{helo}'";
        $this->{prepend}       = "[SuspiciousHelo]";

        pbAdd( $fh, $this->{ip}, $fiphValencePB, "IPinHELO" )
          if $fiphValencePB > 0 && $literal && $DoIPinHelo != 2;

        if (   $fiphValencePB > 0
            && $literal
            && $literal    ne $this->{ip}
            && $reverse_ip ne $this->{ip}
            && $DoIPinHelo != 2 ) {
            $this->{messagereason} = "IP in HELO does not match connection: '$this->{helo}'";
            pbAdd( $fh, $this->{ip}, $fiphValencePB, "IPinHELOmismatch" );
          }

        mlog( $fh, "$tlit ($this->{messagereason})", 1 )
          if $ValidateSenderLog == 2 && $fiphValencePB > 0 && $literal;

        return 0;
      }

    #the if didn't hit
    return 1;
  }

sub ForgedHeloOK {
    my ( $fh, $rcpt ) = @_;
    my $this = $Con{$fh};
    d('ForgedHeloOK');
    my $tlit;
    return 1 if $this->{forgedhelodone};
    $this->{forgedhelodone} = 1;
    return 1 if $this->{ip} =~ /$IPprivate/;

    return 1 if !$DoFakedLocalHelo;
    return 1 if $this->{relayok};
    return 1 if $this->{acceptall};
    return 1 if $this->{ispip};
    return 1 if $this->{nohelo};

    return 1 if $heloBlacklistIgnore && $this->{helo} =~ $HBIRE;
    return 1 if $Whitelist{ $this->{mailfrom} } && $DoFakedWL;
    return 1
      if $noProcessing
          && matchSL( $this->{mailfrom}, 'NoProcessing' )
          && $DoFakedNP;

    $tlit = "[spam found]";
    $tlit = "[monitoring]" if $DoFakedLocalHelo == 2;
    $tlit = "[scoring]" if $DoFakedLocalHelo == 3;

    ( my $literal ) = $this->{helo} =~ /\[?((?:\d{1,3}\.){3}\d{1,3})\]?/;    # domain literal

    if (   $DoFakedUseLocalDomain && $localDomains && $this->{helo} =~ $LDRE
        || $this->{helo} eq "friend"
        || $this->{helo} eq "localhost"
        
        || $myServerRe && $this->{helo} =~ $LHNRE
        || $literal && $literal =~ $LHNRE
        || $literal && $literal eq $localhostip ) {

        $this->{prepend} = "[ForgedHELO]";

        #$this->{prepend} .= "[$tlit]" if $DoFakedLocalHelo >= 2;
        $this->{messagereason} = "forged Helo: '$this->{helo}'";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $ForceFakedLocalHelo && $ValidateSenderLog
              || $DoFakedLocalHelo >= 2 && $ValidateSenderLog;
        delayWhiteExpire($fh);
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $DoFakedLocalHelo == 2;
        pbWhiteDelete( $fh, $this->{ip} );

        pbAdd( $fh, $this->{ip}, $fhValencePB, "ForgedHELO" )
          if $fhValencePB > 0;
        return 1 if $DoFakedLocalHelo == 3;
        $Stats{forgedHelo}++;
        return 0;
      }
    return 1;
  }

# do forged local sender
sub LocalSenderOK {
    my ( $fh, $ip ) = @_;

    my $this = $Con{$fh};
    d('LocalSenderOK');
    my $tlit;
    return 1 if $this->{localsenderdone};
    $this->{localsenderdone} = 1;
	return 1 if $this->{noprocessing};
    return 1 if $this->{relayok};
    return 1 if $this->{ispip};
    return 1 if $this->{acceptall};    
    
    return 1 if !localmail( $this->{mailfrom} );
    
    if ($DoNoSpoofing)  {
    	$this->{messagereason} = "No Spoofing Allowed '$this->{mailfrom}'";
        delayWhiteExpire($fh);
        pbWhiteDelete( $fh, $this->{ip} );
        pbAdd( $fh, $this->{ip}, $flValencePB, "NoSpoofing" );
        return 0;
     	}

    return 1 if !$DoNoValidLocalSender;
    return 1 if !$LocalAddresses_Flat && !$DoLDAP && !(scalar(keys %DomainVRFYMTA));

    #enforce valid local mailfrom

    my $mf = $this->{mailfrom};
    $tlit = "[spam found]"   if $DoNoValidLocalSender == 1;
    $tlit = "[monitoring]" if $DoNoValidLocalSender == 2;
    $tlit = "[scoring]"    if $DoNoValidLocalSender == 3;
    $this->{prepend} = "[UnknownLocalSender]";

    #$this->{prepend} .= "[$tlit]" if $DoNoValidLocalSender >= 2;

    $this->{islocalmailaddress} = 0;

    if ( $LocalAddresses_Flat
        && matchSL( $this->{mailfrom}, 'LocalAddresses_Flat' ) ) {
        $this->{islocalmailaddress} = 1;
      } else {

        # Need another check?

# check sender against LDAP ?
    	if ($DoLDAP) {
      		if ($CanUseLDAP) {
        		my $h = $2 if ($mf =~ /^(.*@)(.*)$/);
        		$this->{islocalmailaddress}=localmailaddress($fh,$h);
      		}
    	} elsif (scalar(keys %DomainVRFYMTA) && !$this->{islocalmailaddress}) {
      		if ($CanUseNetSMTP) {
        	my $h = $2 if ($mf =~ /^(.*@)(.*)$/);
        	$this->{islocalmailaddress}=localmailaddress($fh,$h);
      		}
      	}
  	}
    if ( !$this->{islocalmailaddress} ) {
        $this->{messagereason} = "Invalid Local Sender '$this->{mailfrom}'";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $ValidateSenderLog && $DoNoValidLocalSender >= 2;
        return 1 if $DoNoValidLocalSender == 2;
        delayWhiteExpire($fh);
        pbWhiteDelete( $fh, $this->{ip} );
        pbAdd( $fh, $this->{ip}, $flValencePB, "InvalidLocalSender", $DoNoValidLocalSender )
          if $flValencePB > 0;
        return 1 if $DoNoValidLocalSender == 3;
        return 0;
      }
    return 1;
  }
  
sub LocalAddressOK {
    my ( $fh) = @_;

    my $this = $Con{$fh};
    my $islocalmailaddress = 0;
    d('LocalAddressOK');    
    my $mf = $this->{mailfrom};
    $this->{islocalmailaddress} = 0;

    if ( $LocalAddresses_Flat
        && matchSL( $this->{mailfrom}, 'LocalAddresses_Flat' ) ) {
        $islocalmailaddress = 1;
      } else {

        # Need another check?
        


        # check sender against LDAP ?
    if ($DoLDAP) {
      if ($CanUseLDAP) {
        my $h = $2 if ($mf =~ /^(.*@)(.*)$/);
        $this->{islocalmailaddress}=localmailaddress($fh,$h);
      }
    } elsif (scalar(keys %DomainVRFYMTA) && !$this->{islocalmailaddress}) {
      if ($CanUseNetSMTP) {
        my $h = $2 if ($mf =~ /^(.*@)(.*)$/);
        $this->{islocalmailaddress}=localmailaddress($fh,$h);
      }
    }
  }
    if ( !$islocalmailaddress ) {
        return 0;
      }
    return 1;
  }
#queries the SenderBase service
sub SenderBaseMyIP {
    my ( $fh, $ip ) = @_;
    my $this = $Con{$fh};
    my $query;
    my $results;

    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    return if !$CanUseSenderBase;
    eval {
        $query = Net::SenderBase::Query->new(
            Transport => 'dns',
            Address   => $ip,
            Host      => 'test.senderbase.org',
            Timeout   => 10,
        );
        $results = $query->results;
    };
    return if $@;
    return $results->ip_country;
  }

#queries the SenderBase service
sub SenderBaseOK {
    my ( $fh, $ip, $domain ) = @_;
    my $this = $Con{$fh};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $this = $Con{$fh};
    d('SenderBaseOK');

    my $results;
    my $query;
    my $cache;
    my $skip;
    my $tlit;

    return 1 if !$CanUseSenderBase;

    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if $this->{acceptall};
    return 1 if $this->{whitelisted};
    return 1 if $this->{noprocessing};
    
    return 1 if ( exists $PBWhite{$ip} );
    return 1 if ( localmail( $this->{mailfrom} ) );
    return 1 if $this->{ip} =~ /$IPprivate/;
    return 1 if $this->{localuser};
    return 1 if $this->{relayok};
    

    #return 1 if $this->{contentonly};
    my ( $ipcountry, $orgname ) = split( "-", SBCacheFind($ip) );
    

    

    if ( !SBCacheFind($ip) ) {
        eval {
            $query = Net::SenderBase::Query->new(
                Transport => 'dns',
                Address   => $ip,
                Host      => 'test.senderbase.org',
                Timeout   => 10,
            );
            $results = $query->results;
        };
        return 1 if $@;
        my $bondedsender   = $results->ip_in_bonded_sender;
        my $blacklistscore = $results->ip_blacklist_score;
        $orgname = $results->org_name;
        my $resultip     = $results->ip;
        my $fortune1000  = $results->org_fortune_1000;
        my $domainname   = $results->domain_name;
        my $domainrating = $results->domain_rating;
        $ipcountry = $results->ip_country;
      } else {
        $cache = 1;
      }
	return 1 if $ipcountry =~ $NoCountryCodeReRE;
    $this->{mycountry} = 0;
    
    if ( $ipcountry && $DoCountryBlocking
        && ($ipcountry =~ $CountryCodeBlockedReRE || ($CountryCodeBlockedReRE =~ /all|\*/i && $ipcountry !~ $MyCountryCodeReRE && $ipcountry !~ $CountryCodeReRE))){
        $this->{messagereason} = "Blocked Country $ipcountry - $orgname";

        $this->{prepend} = "[CountryCode]";
        $tlit = "[monitoring]" if $DoCountryBlocking == 2;
    	$tlit = "[scoring]" if $DoCountryBlocking == 3;
 
        pbAdd( $fh, $ip, $bccValencePB, "BlockedCountry-$ipcountry") if $DoCountryBlocking != 2;
   
        mlog( $fh, "$tlit $this->{messagereason}", 1 ) if $DoCountryBlocking == 2 || $DoCountryBlocking == 3;
        SBCacheAdd( $ip, 1, "$ipcountry-$orgname" );
 
        return 0 if $DoCountryBlocking == 1 || $DoCountryBlocking == 4;
        return 1;
     }
     
	return 1 if !$DoSenderBase;
	return 1 if !$CountryCodeRe && !$MyCountryCodeReRE;
	$tlit = "[monitoring]" if $DoSenderBase == 2;
    $tlit = "[scoring]" if $DoSenderBase == 3;
    $sbhccValencePB = 0 - $sbhccValencePB if $sbhccValencePB;

    if (   $sbhccValencePB < 0
        && $ipcountry
        && $MyCountryCodeReRE
        && $ipcountry =~ $MyCountryCodeReRE ) {
        $this->{prepend}       = "[CountryCode]";
        $this->{mycountry}     = 1;
        $this->{messagereason} = "Home Country Bonus $ipcountry - $orgname";
        mlog( $fh, "$tlit $this->{messagereason}", 1 ) if $SenderBaseLog == 2;
        pbAdd( $fh, $ip, $sbhccValencePB, "HomeCountry-$ipcountry" )
          if $DoSenderBase != 2;
        return 1;

      }
    if (   $sbfccValencePB
        && $ipcountry
        && $MyCountryCodeReRE
        && $ipcountry !~ $MyCountryCodeReRE
        && !( $CountryCodeReRE && $ipcountry =~ $CountryCodeReRE ) ) {
        $this->{messagereason} = "Foreign Country $ipcountry - $orgname";
        pbAdd( $fh, $ip, $sbfccValencePB, "CountryCode-$ipcountry", 1 )
          if $DoSenderBase != 2;
        $this->{prepend} = "[CountryCode]";
        mlog( $fh, "$tlit $this->{messagereason}", 1 ) if $SenderBaseLog == 2;
        SBCacheAdd( $ip, 1, "$ipcountry-$orgname" );
        return 1;
      }
    if (   $sbfccValencePB
        && $ipcountry
        && $MyCountryCodeReRE
        && $ipcountry !~ $MyCountryCodeReRE
        && ( $CountryCodeReRE && $ipcountry =~ $CountryCodeReRE ) ) {
        $this->{messagereason} = "Foreign & Suspicious Country $ipcountry - $orgname";
        pbAdd( $fh, $ip, $sbfccValencePB + $sbsccValencePB, "CountryCode-$ipcountry", 1 )
          if $DoSenderBase != 2;
        $this->{prepend} = "[CountryCode]";
        mlog( $fh, "$tlit $this->{messagereason}", 1 ) if $SenderBaseLog;
        SBCacheAdd( $ip, 1, "$ipcountry-$orgname" );
        return 1;
      }
    if (   $sbsccValencePB
        && $ipcountry
  
        && $CountryCodeReRE
        && $ipcountry =~ $CountryCodeReRE ) {
        $this->{messagereason} = "Suspicious Country $ipcountry - $orgname";
        pbAdd( $fh, $ip, $sbsccValencePB, "CountryCode-$ipcountry", 1 )
          if $DoSenderBase != 2;
        $this->{prepend} = "[CountryCode]";
        mlog( $fh, "$tlit $this->{messagereason}", 1 ) if $SenderBaseLog;
        SBCacheAdd( $ip, 1, "$ipcountry-$orgname" );
        return 1;
      }


    SBCacheAdd( $ip, 2, "$ipcountry-$orgname" ) if !$cache && $ipcountry;
    mlog( $fh, "SenderBase showing:  $ipcountry - $orgname", 1 )
      if $SenderBaseLog == 2 && $ipcountry;

    return 1;
  }


#enforce valid A/MX record for sender address
sub MXAOK {
	my ($fh) = @_;
	my $this = $Con{$fh};

	return 1 unless $CanUseDNS && $DoDomainCheck;

	my $ip = $this->{ip};
	$ip = $this->{cip} if $this->{ispip} && $this->{cip};

	return 1 if $this->{mailfrom} =~ $BSRE;
	return 1 if ( localmail( $this->{mailfrom} ) );
	return 1 if $this->{localuser};
	return 1 if $this->{relayok};
	return 1 if $this->{rwlok};
	return 1 if $this->{contentonly};
	return 1 if $this->{mailfrom} =~ /www|web|news|mail|noreply/i;
	return 1 if $ip =~ /$IPprivate/;
	

	my $slok = $this->{allLoveMXASpam} == 1;

	my $mf   = lc $this->{mailfrom};
	my $mfd = $1 if $mf =~ /\@(.*)/;
	
	my $mDoDomainCheck = $DoDomainCheck;
	$mDoDomainCheck    = 3 if $switchSpamLoverToScoring && $DoPenaltyMessage && ( $slok || $this->{spamlover} );
	$mDoDomainCheck    = 3 if $switchTestToScoring && $DoPenaltyMessage &&  ( $mxaTestMode || $allTestMode );

	my $tlit;
	$tlit = "[monitoring]" if $mDoDomainCheck == 2;
	$tlit = "[scoring]"    if $mDoDomainCheck == 3;
	$this->{prepend} = "[MissingMX]";


	my ( $cachetime, $mxexchange, $arecord ) = MXACacheFind($mfd);
	if ( !$cachetime ) {
		my ( $queryMX, $queryA, $errorstringMX, $errorstringA ) = undef;
		
		

			my $res = Net::DNS::Resolver->new(
				nameservers => \@nameservers,
            	tcp_timeout => $DNStimeout,
            	udp_timeout => $DNStimeout,
            	retrans     => $DNSretrans,
            	retry       => $DNSretry
			);
			
			$queryMX       = $res->query( $mfd, 'MX' );
					
		$mxexchange = undef;
		if ($queryMX) {
			foreach my $rr ( $queryMX->answer ) {
				if ( $rr->type eq "MX" ) {
					$mxexchange = $rr->exchange;
					last;
				}
			}
						
		}
		
		if ($mxexchange) {

		#MX found
		my $msg = "MX found";
		$msg .= " (cache)" if $cachetime;
		$msg .= ": $mfd -> $mxexchange";
		mlog( $fh, $msg, 1, 1 )
			if $ValidateSenderLog == 2 ;
		if ( $MXACacheInterval > 0 && !$cachetime) {
			MXACacheAdd( $mfd, $mxexchange, "" );
		}

		return 1;

	} else {

		#MX not found
		$this->{messagereason} = "MX missing";
		$this->{messagereason} .= " (cache)" if $cachetime;
		$this->{messagereason} .= ": $mfd";

		mlog( $fh,"[scoring] $this->{messagereason}", 0)
			if $ValidateSenderLog && $mxValencePB;

		pbWhiteDelete( $fh, $ip );
		pbAdd( $fh, $ip, $mxValencePB, "MissingMX" ) if $mDoDomainCheck != 2;
		$arecord = undef;
		my ($name, $aliases, $addrtype, $length, @addrs) =
gethostbyname($mfd);
		foreach my $i (@addrs) {
			my ($a, $b, $c, $d) = unpack('C4', $i);
			$arecord ="$a.$b.$c.$d";

			if ($arecord eq "208.69.34.132") {
				$arecord = undef;
				last;
			}
								
		}
			
		if ( $MXACacheInterval > 0 ) {
			MXACacheAdd( $mfd, $mxexchange, $arecord );
		}
	}

		if ($arecord) {

			#A  found
			my $msg = "A found";
			$msg .= " (cache)" if $cachetime;
			$msg .= ": $mfd -> $arecord";
			mlog( $fh, $msg, 1, 1 )	if $ValidateSenderLog == 2 ;
			return 1;

		} else {

			#A not found
			$this->{prepend} = "[MissingMXA]";

			$this->{messagereason} = "MX and A missing: $mfd";

			mlog( $fh,"$tlit $this->{messagereason}")
				if $ValidateSenderLog && $mDoDomainCheck >= 2;

			delayWhiteExpire($fh);
			pbAdd( $fh, $ip, $mxaValencePB, "MissingMXA" ) if  $mDoDomainCheck != 2;
						
			return 1 if $mDoDomainCheck >= 2;
			$Stats{mxaMissing}++ unless $slok;
			return 0;
		}

	}
	return 1;
}


sub BombOK {
    my ( $fh) = @_;
    my $this = $Con{$fh};
    return 1 if $this->{bombdone};
    my $ip = $this->{ip};

    $this->{bombdone} = 1;
    d('BombOK');
    my $subre;
    my $tlit;

    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;

    
    return 1 if $this->{spamfound};
    
    onwhitere($fh,substr( $this->{header}, 0, $maxbytes ));


    if (  !$this->{spamlover}
        && $SpamLoversRe
        && substr( $this->{data}, 0, $maxbytes ) =~ ( '(' . $SpamLoversReRE . ')' ) ) {
        mlogRe( $fh, $1, "SpamLover" );
        $this->{spamlover} = 1;
      }
    if (   $testRe
        && $testReRE != ""
        && $DoTestRe
        && substr( $this->{header}, 0, $maxbytes ) =~ ( '(' . $testReRE . ')' ) ) {
        mlogRe( $fh, $1, "TestRe", "TestRegex" );
      }
    if (   $noBombScript
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noBombScript' ) ) {
        return 1;
      }
    if (
           $bombSuspiciousRe
        && $bombSuspiciousReRE != ""
        && ( substr( $this->{header}, 0, $maxbytes ) =~ ( '(' . $bombSuspiciousReRE . ')' )
            || $this->{mailfrom} =~ ( '(' . $bombSuspiciousReRE . ')' ) )
      ) {
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombSuspicious:  '$subre'";
        pbAdd( $fh, $ip, $bombSuspiciousValencePB, "bombSuspiciousRe", 1 );
        mlogRe( $fh, $1, "Suspicious" );
      }
   if ( $LHNRE && substr( $this->{data}, 0, $maxbytes ) =~ ( '(' . $LHNRE . ')' ) ) {
        mlogRe( $fh, $1, "RegularBounce" );
        $this->{noprocessing} = 1;
    }
    return 1 if !$DoBombRe;
    return 1 if $this->{acceptall};
    return 1 if $this->{whitelisted} && !$bombReWL;
    return 1 if $this->{noprocessing} && !$bombReNP;
    return 1 if $this->{relayok} && !$bombReLocal;
    return 1 if $this->{ispip} && !$bombReISPIP;
    my $slok      = $this->{allLoveBoSpam} == 1;
    

    my $mDoBombRe = $DoBombRe;
    $mDoBombRe = 3
      if $DoBombRe ==1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoBombRe = 3
      if $DoBombRe ==1 && $switchTestToScoring
          && $DoPenaltyMessage
          && ( $bombTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mDoBombRe == 2;
    $tlit = "[scoring]"    if $mDoBombRe == 3;
    my $mf   = lc $this->{mailfrom};
        if (   $bombRe
        && $bombReRE != ""
        && $mf =~ ( '(' . $bombReRE . ')' ) ) {
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombRaw: '$subre'";
        $this->{prepend}       = "[BombRaw]";

        #$this->{prepend} .= "[$tlit]" if $mDoBombRe >= 2;
        mlog( $fh, "$tlit (BombRaw '$subre')" ) if $mDoBombRe >= 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $mDoBombRe == 2;
        pbWhiteDelete( $fh, $ip );
        pbAdd( $fh, $ip, $bombValencePB, "BombRaw" ) if ( $bombValencePB > 0 );
        $this->{donotcollectbombs} = 1;

        return 1 if $mDoBombRe == 3;
        return 0;
      }

    if (   $bombDataRe
        && $bombDataReRE != ""
        && substr( $this->{data}, 0, $maxbytes ) =~ ( '(' . $bombDataReRE . ')' ) ) {
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombData: '$subre'";
        $this->{prepend}       = "[BombData]";

        #$this->{prepend} .= "[$tlit]" if $mDoBombRe >= 2;
        mlog( $fh, "$tlit (BombData  '$subre')" ) if $mDoBombRe >= 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $mDoBombRe == 2;
        pbWhiteDelete( $fh, $ip );
        $this->{donotcollectbombs} = 1;
        pbAdd( $fh, $this->{ip}, $bombValencePB, "BombData" )
          if ( $bombValencePB > 0 );
        return 1 if $mDoBombRe == 3;
        return 0;
      }
    if (   $bombRe
        && $bombReRE != ""
        && "substr( $this->{header}, 0, $maxbytes )substr( $this->{data}" =~ ( '(' . $bombReRE . ')' ) ) {
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombRaw: '$subre'";
        $this->{prepend}       = "[BombRaw]";

        #$this->{prepend} .= "[$tlit]" if $mDoBombRe >= 2;
        mlog( $fh, "$tlit (BombRaw '$subre')" ) if $mDoBombRe >= 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $mDoBombRe == 2;
        pbWhiteDelete( $fh, $ip );
        pbAdd( $fh, $ip, $bombValencePB, "BombRaw" ) if ( $bombValencePB > 0 );
        $this->{donotcollectbombs} = 1;

        return 1 if $mDoBombRe == 3;
        return 0;
      }
    return 1;
  }

#
sub BombHeaderOK {
    my ( $fh, $b ) = @_;
    my $this = $Con{$fh};
    d('BombHeaderOK');
    my $ip = $this->{ip};

    my $subre;
    my $isheaderbomb;
    my $tlit;
    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    my $mf   = lc $this->{mailfrom};
    
    if (   $noBombScript
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noBombScript' ) ) {
        return 1;
      }
    return 1 if $this->{acceptall}    && !$this->{cip};
    return 1 if $this->{whitelisted}  && !$bombReWL;
    return 1 if $this->{noprocessing} && !$bombReNP;
    return 1 if $this->{relayok}      && !$bombReLocal;
    return 1 if $this->{ispip}        && !$bombReISPIP;
    return 1 if !$DoBombHeaderRe;
    my $slok            = $this->{allLoveBoSpam} == 1;
    my $mDoBombHeaderRe = $DoBombHeaderRe;
    $mDoBombHeaderRe = 3
      if $DoBombHeaderRe ==1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoBombHeaderRe = 3
      if $DoBombHeaderRe ==1 && $switchTestToScoring
          && $DoPenaltyMessage
          && ( $bombTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mDoBombHeaderRe == 2;
    $tlit = "[scoring]"    if $mDoBombHeaderRe == 3;
    if
         	(   $bombHeaderRe
            && $bombHeaderReRE != ""
            && $mf =~ ( '(' . $bombHeaderReRE . ')' ) )
        {
        $this->{messagereason} = "BombHeader '$1'";
        $isheaderbomb =1;

    	} elsif ( $bombCharSets && $bombCharSetsRE != "" && $b =~ ( '(' . $bombCharSetsRE . ')' ) )
        {
        $this->{messagereason} = "BombCharset '$1'";
        $isheaderbomb =1;
        } elsif
         	(   $bombHeaderRe
            && $bombHeaderReRE != ""
            && substr( $b, 0, $maxbytes ) =~ ( '(' . $bombHeaderReRE . ')' ) )
        {
        $this->{messagereason} = "BombHeader '$1'";
        $isheaderbomb =1;
        } elsif
        	(   $DoBombHeaderByLocalDomain
            && $localdomainre
            && $localdomainre != ""
            && substr( $b, 0, $maxbytes ) =~ ( '(' . $localdomainre . ')' ) )
            
        {
        $this->{messagereason} = "BombDomain '$1'";
        $isheaderbomb =1;
        } elsif
         	(   $bombSubjectRe
            && $bombSubjectReRE != ""
            && $this->{subject3} =~ ( '(' . $bombSubjectReRE . ')' ) )
        {

        $this->{messagereason} = "BombHeader Subject '$1'";
        $isheaderbomb =1;
        }
    if ( $isheaderbomb) {
        $this->{prepend}       = "[BombHeader]";

        #$this->{prepend} .= "[$tlit]" if $mDoBombHeaderRe >= 2;
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $mDoBombHeaderRe == 3 || $mDoBombHeaderRe == 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $mDoBombHeaderRe == 2;
        $this->{donotcollectbombs} = 1;
        pbWhiteDelete( $fh, $this->{ip} );
        pbAdd( $fh, $this->{ip}, $bombValencePB, "BombHeader" )
          if ( $bombValencePB > 0 );
        return 1 if $mDoBombHeaderRe == 3;
        return 0;
      }
    return 1;
  }

#
sub BombSenderOK {
    my ( $fh, $b ) = @_;
    my $this = $Con{$fh};
    d('BombSenderOK');
    my $subre;
    my $tlit;
    my $ip = $this->{ip};
    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    

    return 1 if !$DoBombSenderRe;
    if (   $noBombScript
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noBombScript' ) ) {
        return 1;
      }
    return 1 if $this->{acceptall};
    return 1 if $this->{whitelisted} && !$bombReWL;
    return 1 if $this->{noprocessing} && !$bombReNP;
    return 1 if $this->{relayok} && !$bombReLocal;
    return 1 if $this->{ispip} && !$bombReISPIP;
    my $slok            = $this->{allLoveBoSpam} == 1;
    my $mDoBombSenderRe = $DoBombSenderRe;
    $mDoBombSenderRe = 3
      if $DoBombSenderRe == 1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoBombSenderRe = 3
      if $DoBombSenderRe == 1 && $switchTestToScoring
          && $DoPenaltyMessage
          && ( $bombTestMode || $allTestMode );
    $tlit = "[spam found]"   	if $mDoBombSenderRe == 1;
    $tlit = "[monitoring]" 		if $mDoBombSenderRe == 2;
    $tlit = "[scoring]"    		if $mDoBombSenderRe == 3;

    if (   $bombSenderRe
        && $bombSenderReRE != ""
        && substr( $b, 0, $maxbytes ) =~ ( '(' . $bombSenderReRE . ')' ) ) {
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombSender '$subre'";
        $this->{prepend}       = "[BombSender]";

        #$this->{prepend} .= "[$tlit]" if $mDoBombSenderRe >= 2;
        mlog( $fh, "$tlit ($this->{messagereason})" );
        pbWhiteDelete( $fh, $ip );
        return 1 if $mDoBombSenderRe == 2;

        pbAdd( $fh, $ip, $bombValencePB, "BombSender" )
          if ( $bombValencePB > 0 );
        $this->{donotcollectbombs} = 1;
        return 1 if $mDoBombSenderRe == 3;
        $Stats{bombSender}++;
        return 0;
      }
    return 1;
  }

sub BombBlackOK {
    my ( $fh, $b ) = @_;
    my $this = $Con{$fh};
    d('BombBlackOK');
    my $subre;
    my $tlit;
    my $ip = $this->{ip};
    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;


    return 1 if $DoBlackReBayesian;
    return 1 if !$DoBlackRe;
    if (   $noBombScript
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noBombScript' ) ) {
        return 1;
      }
    return 1 if $this->{acceptall};
    return 1 if $this->{relayok};
    my $subdata = substr( $this->{data}, 0, $MaxBytes );

    my $slok       = $this->{allLoveBoSpam} == 1;
    my $mDoBlackRe = $DoBlackRe;
    $mDoBlackRe = 3
      if $DoBlackRe == 1 && $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoBlackRe = 3
      if $DoBlackRe == 1 && $switchTestToScoring
          && $DoPenaltyMessage
          && ( $bombTestMode || $allTestMode );
    $tlit = "[spam found]"   if $mDoBlackRe == 1;
    $tlit = "[monitoring]" if $mDoBlackRe == 2;
    $tlit = "[scoring]"    if $mDoBlackRe == 3;

    if (   $blackRe
        && $blackReRE != ""
        && "$this->{header}$subdata" =~ ( '(' . $blackReRE . ')' ) ) {
        $this->{blackredone} = 1;
        ( $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{messagereason} = "BombBlack '$subre'";
        $this->{prepend}       = "[BombBlack]";

        #$this->{prepend} .= "[$tlit]" if $mDoBlackRe >= 2;
        mlog( $fh, "$tlit ($this->{messagereason})" ) if $mDoBlackRe >= 2;
        pbWhiteDelete( $fh, $ip );
        return 1 if $mDoBlackRe == 2;

        $this->{donotcollectbombs} = 1;
        pbAdd( $fh, $ip, $blackValencePB, "BombBlack" )
          if ( $blackValencePB > 0 );
        return 1 if $mDoBlackRe == 3;
        $Stats{bombBlack}++;
        return 0;
      }
    return 1;
  }

#
sub ScriptOK {
    my ( $fh, $b ) = @_;
    my $this = $Con{$fh};
    d('ScriptOK');
    my $tlit;
    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    
    return 1 if !$DoScriptRe;
    if (   $noBombScript
        && $this->{mailfrom}
        && matchSL( $this->{mailfrom}, 'noBombScript' ) ) {
        return 1;
      }
    return 1 if $this->{acceptall} == 1;
    return 1 if $this->{whitelisted} && !$bombReWL;
    return 1 if $this->{noprocessing} == 1 && !$bombReNP;
    return 1 if $this->{relayok} && !$bombReLocal;
    return 1 if $this->{ispip} && !$bombReISPIP;
    my $slok        = $this->{allLoveBoSpam} == 1;
    my $mDoScriptRe = $DoScriptRe;
    $mDoScriptRe = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoScriptRe = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $scriptTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mDoScriptRe == 2;
    $tlit = "[scoring]"    if $mDoScriptRe == 3;

    if ( $scriptRe && $scriptReRE != "" && substr( $b, 0, $maxbytes ) =~ ( '(' . $scriptReRE . ')' ) ) {
        $this->{prepend} = "[BombScript]";

        #$this->{prepend} .= "[$tlit]" if $mDoScriptRe >= 2;
        ( my $subre = $1 ) =~ s/\s+/ /g;
        $subre = substr( $subre, 0, $RegExLength );
        $this->{mypbreason}    = $subre;
        $this->{messagereason} = "BombScript '$subre'";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if ( $mDoScriptRe == 2 || $mDoScriptRe == 3 );
        return 1 if $mDoScriptRe == 2;
        $this->{donotcollectbombs} = 1;
        pbAdd( $fh, $this->{ip}, $scriptValencePB, "BombScript" )
          if ( $scriptValencePB > 0 );
        return 1 if $mDoScriptRe == 3;
        return 0;
      }
    return 1;
  }

#
sub validHeloOK {
    my ( $fh, $helo ) = @_;
    my $this = $Con{$fh};
    d('validHeloOK');
    my $tlit;
    return 1 if $this->{validhelodone};
    $this->{validhelodone} = 1;
    return 1 if $this->{formathelodone};
    return 1 if !$DoValidFormatHelo;
    return 1 if ( $this->{relayok} );
    return 1 if $validPTRRe && $helo =~ $validPTRReRE;
    return 1 if $heloBlacklistIgnore && $helo =~ $HBIRE;
    return 1 if $this->{ispip};
    return 1 if $this->{rwlok};
    return 1 if $this->{nohelo};
    return 1 if $this->{acceptall};

    #return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted}  && !$DoHeloWL;
    return 1 if $this->{noprocessing} && !$DoHeloNP;
    return 1 if $helo =~ "\[[0-9\.]+\]";
    my $slok               = $this->{allLoveHiSpam} == 1;
    my $mDoValidFormatHelo = $DoValidFormatHelo;
    $mDoValidFormatHelo = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoValidFormatHelo = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $ihTestMode || $allTestMode );

    if (   $mDoValidFormatHelo
        && $validFormatHeloRe
        && !( $helo =~ ( '(' . $validFormatHeloReRE . ')' ) ) ) {

        $tlit = "[monitoring]" if $mDoValidFormatHelo == 2;
        $tlit = "[scoring]"    if $mDoValidFormatHelo == 3;
        $this->{prepend} = "[ValidHELO]";

        #$this->{prepend} .= "[$tlit]" if $mDoValidFormatHelo >= 2;
        $this->{messagereason} = "HELO not valid: '$helo'";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $ValidateSenderLog && $mDoValidFormatHelo == 3
              || $mDoValidFormatHelo == 2;
        pbWhiteDelete( $this->{ip} );
        return 1 if $mDoValidFormatHelo == 2;
        $this->{formathelodone} = 1;
        pbAdd( $fh, $this->{ip}, $ihValencePB, "NotValidHELO" )
          if $ihValencePB > 0;
        $this->{notvalidhelofound} = 1;
        return 1 if $mDoValidFormatHelo == 3;
        return 0;
      }
    return 1;
  }

# do invalid HELO check
sub invalidHeloOK {
    my ( $fh, $helo ) = @_;
    my $this = $Con{$fh};
    d('invalidHeloOK');
    my $tlit;
    return 1 if $this->{invalidhelodone};
    $this->{invalidhelodone} = 1;

    return 1 if $this->{formathelodone};
    return 1 if $validPTRRe && $helo =~ $validPTRReRE;
    return 1 if !$DoInvalidFormatHelo;
    return 1 if $this->{relayok};
    return 1 if $heloBlacklistIgnore && $helo =~ $HBIRE;
    return 1 if $this->{ispip};
    return 1 if $this->{nohelo};
    return 1 if $this->{acceptall};
    return 1 if $this->{rwlok};

    #return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted}  && !$DoHeloWL;
    return 1 if $this->{noprocessing} && !$DoHeloNP;
    return 1 if $helo =~ "\[[0-9\.]+\]";
    my $slok                 = $this->{allLoveHiSpam} == 1;
    my $mDoInvalidFormatHelo = $DoInvalidFormatHelo;
    $mDoInvalidFormatHelo = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoInvalidFormatHelo = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $ihTestMode || $allTestMode );

    if (   $DoInvalidFormatHelo
        && $invalidFormatHeloRe
        && $helo =~ $invalidFormatHeloReRE ) {

        $tlit = "[monitoring]" if $mDoInvalidFormatHelo == 2;
        $tlit = "[scoring]"    if $mDoInvalidFormatHelo == 3;
        $this->{prepend} = "[InvalidHELO]";

        #$this->{prepend} .= "[$tlit]" if $mDoInvalidFormatHelo >= 2;
        $this->{messagereason} = "invalid HELO: '$helo'";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $ValidateSenderLog && $mDoInvalidFormatHelo == 3
              || $mDoInvalidFormatHelo == 2;
        pbWhiteDelete( $this->{ip} );
        return 1 if $mDoInvalidFormatHelo == 2;
        $this->{formathelodone} = 1;
        pbAdd( $fh, $this->{ip}, $ihValencePB, "InvalidHELO" )
          if $ihValencePB > 0;
        $this->{invalidhelofound} = 1;
        return 1 if $mDoInvalidFormatHelo == 3;
        return 0;
      }

    return 1;
  }

# do blacklisted HELO check
sub BlackHeloOK {
    my ( $fh, $helo ) = @_;
    my $this = $Con{$fh};
    d('BlackHeloOK');
    my $tlit;
    return 1 if !$useHeloBlacklist;
    return 1 if $this->{relayok};

    return 1 if $this->{whitelisted}  && !$DoHeloWL;
    return 1 if $this->{noprocessing} && !$DoHeloNP;
    return 1 if $this->{nohelo};
    return 1 if $this->{ispip};
    return 1 if $this->{rwlok};

    #return 1 if $this->{contentonly};

    return 1 if $heloBlacklistIgnore && $this->{helo} =~ $HBIRE;
    my $slok = $this->{allLoveHlSpam} == 1;
    my $testmode =  $hlTestMode || $allTestMode;
    $testmode = $slok = 0 if allSH( $this->{rcpt}, 'hlSpamHaters' );
    my $museHeloBlacklist = $useHeloBlacklist;
    $museHeloBlacklist = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $museHeloBlacklist = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && $testmode;

    $tlit = "[monitoring]" if $museHeloBlacklist == 2;
    $tlit = "[scoring]"    if $museHeloBlacklist == 3;
    $this->{prepend} = "[BlackHELO]";

    #$this->{prepend} .= "[$tlit]" if $museHeloBlacklist >= 2;
    $this->{messagereason} = "blacklisted HELO '$helo'";
    if ( $HeloBlackObject && $HeloBlack{ $this->{helo} } ) {
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $ValidateSenderLog && $museHeloBlacklist == 3
              || $museHeloBlacklist == 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $museHeloBlacklist == 2;
        $this->{formathelodone} = 1;
        pbAdd( $fh, $this->{ip}, $hlValencePB, "BlacklistedHelo" )
          if $hlValencePB > 0;
        return 1 if $museHeloBlacklist == 3;

        return 0;
      }
    return 1;
  }

# do blacklisted domains check
sub BlackDomainOK {

    my ($fh) = @_;
    my $this = $Con{$fh};

    d('BlackDomainOK');
    my $tlit;

    return 1 if !$DoBlackDomain;
    return 1 if $this->{relayok};


    my $slok           = $this->{allLoveBlSpam} == 1;
    my $mDoBlackDomain = $DoBlackDomain;
    $mDoBlackDomain = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoBlackDomain = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $blTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mDoBlackDomain == 2;
    $tlit = "[scoring]"    if $mDoBlackDomain == 3;
    $this->{prepend} = "[BlackDomain]";

    #$this->{prepend} .= "[$tlit]" if $mDoBlackDomain >= 2;
    $this->{messagereason} = "blacklisted domain '$this->{mailfrom}'";
    if ( $blackListedDomains
        && ( $this->{mailfrom} =~ $BLDRE1 || $this->{senders} =~ $BLDRE2 ) ) {
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $mDoBlackDomain == 3 || $mDoBlackDomain == 2;
        pbWhiteDelete( $fh, $this->{ip} );
        return 1 if $mDoBlackDomain == 2;
        pbAdd( $fh, $this->{ip}, $blValencePB, "BlacklistedDomain" );
        return 1 if $mDoBlackDomain == 3;

        return 0;
      }
    return 1;
  }

sub PTROK {

    my ($fh) = @_;
    my $this = $Con{$fh};
    d('PTROK');
    my $ip = $this->{ip};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $tlit;
    return 1 if !$DoReversed;
    return 1 if !$CanUseDNS;
    return 1 if $this->{spfok};
    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if $this->{acceptall};
    return 1 if $this->{rwlok};

    #return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted}  && !$DoReversedWL;
    return 1 if $this->{noprocessing} && !$DoReversedNP;
    return 1 if pbWhiteFind( $this->{ip} );
    return 1 if PTRCacheFind( $this->{ip} ) == 2;
    return 1 if $this->{relayok};
    my $slok          = $this->{allLovePTRSpam} == 1;
    my $mDoReversed   = $DoReversed;
    my $mDoInvalidPTR = $DoInvalidPTR;
    $mDoReversed = 3
      if ( $DoReversed == 0 || $DoReversed == 2 )
      && ( $DoInvalidPTR == 1 || $DoInvalidPTR == 3 );
    $mDoReversed = $mDoInvalidPTR = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mDoReversed = $mDoInvalidPTR = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $ptrTestMode || $allTestMode );

    $tlit = "[monitoring]" if $mDoReversed == 2;
    $tlit = "[scoring]"    if $mDoReversed == 3;
    $this->{prepend} = "[PTRmissing]";

    #$this->{prepend} .= "[$tlit]" if $mDoReversed >= 2;

    if ( PTRCacheFind($ip) == 1 ) {
        $this->{messagereason} = "PTR missing";
        mlog( $fh, "$tlit ($this->{messagereason})" )
          if $mDoReversed == 3 || $mDoReversed == 2;
        return 1 if $mDoReversed == 2;
        pbAdd( $fh, $ip, $ptmValencePB, "PTRmissing" );
        return 1 if $mDoReversed == 3;
        $Stats{ptrMissing}++ unless $slok;
        return 0;
      }
    if ( $mDoInvalidPTR && PTRCacheFind($ip) == 3 ) {
        if (   $this->{ptrdsn}
            && $mDoInvalidPTR
            && $invalidPTRRe
            && $invalidPTRReRE != ""
            && $this->{ptrdsn} =~ $invalidPTRReRE
            && $this->{ptrdsn} !~ $validPTRReRE ) {
            $this->{messagereason} = "PTR invalid '$this->{ptrdsn}'";
            $this->{prepend}       = "[PTRinvalid]";
            mlog( $fh, "$tlit ($this->{messagereason})" )
              if $mDoInvalidPTR == 3 || $mDoInvalidPTR == 2;
            return 1 if $mDoInvalidPTR == 2;
            pbAdd( $fh, $ip, $ptiValencePB, "PTRinvalid" );
            return 1 if $mDoInvalidPTR == 3;
            $Stats{ptrInvalid}++ unless $slok;
            return 0;
          }
      }
    my $res = Net::DNS::Resolver->new(
        nameservers => \@nameservers,
        tcp_timeout => $DNStimeout,
        udp_timeout => $DNStimeout,
        retrans     => $DNSretrans,
        retry       => $DNSretry
    );
    my $ip_address = $ip;

    if ($ip_address) {

        my $query = eval { $res->search( $ip_address, 'PTR' ); };
        if ($@) { return 1; }
        if ($query) {
            foreach my $rr ( $query->answer ) {
                next unless $rr->type eq "PTR";
                $this->{ptrdsn} = $rr->ptrdname;
                return 1
                  if ( $heloBlacklistIgnore && $this->{ptrdsn} =~ $HBIRE );
                if (   $mDoInvalidPTR
                    && $invalidPTRRe
                    && $invalidPTRReRE != ""
                    && $this->{ptrdsn} =~ $invalidPTRReRE
                    && $this->{ptrdsn} !~ $validPTRReRE ) {
                    $this->{prepend} = "[PTRinvalid]";

                    #$this->{prepend} .= "[$tlit]" if $mDoReversed >= 2;
                    $this->{messagereason} = "PTR invalid '$this->{ptrdsn}'";
                    mlog( $fh, "$tlit ($this->{messagereason})" )
                      if ( $mDoInvalidPTR == 3 || $mDoInvalidPTR == 2 );
                    PTRCacheAdd( $ip, 3, $this->{ptrdsn} );
                    return 1 if $mDoInvalidPTR == 2;
                    pbAdd( $fh, $ip, $ptiValencePB, "PTRinvalid" );
                    return 1 if $mDoInvalidPTR == 3;
                    $Stats{ptrInvalid}++ unless $slok;
                    return 0;
                  }
                PTRCacheAdd( $ip, 2, $this->{ptrdsn} );
                return 1;
              }
          } else {
            if ( $res->errorstring == "NXDOMAIN" ) {
                $this->{prepend} = "[PTRmissing]";

                #$this->{prepend} .= "[$tlit]" if $mDoReversed == 3;
                $this->{messagereason} = "PTR missing";
                PTRCacheAdd( $ip, 1 );
                mlog( $fh, "$tlit ($this->{messagereason})" )
                  if ( $mDoReversed == 3 || $mDoReversed == 2 );
                return 1 if $mDoReversed == 2;
                pbAdd( $fh, $ip, $ptmValencePB, "PTRmissing" );
                return 1 if $mDoReversed == 3;
                $Stats{ptrMissing}++ unless $slok;
                return 0;
              }
          }
      }
    return 1;
  }

sub PBOK {
    my ( $fh, $myip, $lvl ) = @_;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    d('PBOK');
    my $t = time;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    return 1 if ( $this->{relayok} );
    return 1 if ( $this->{whitelisted} );
    return 1 if ( $this->{noprocessing} == 1 );
    return 1 if $this->{ispip} && !$this->{cip};
    return 1 if ( $this->{nopb} );
    return 1 if $this->{rwlok};

    return 1 if ( pbWhiteFind( $this->{ip} ) );
    return 1 if ( !exists $PBBlack{$ip} );
    return 1 if !$DoPenalty;
    my ( $ct, $ut, $level, $totalscore, $sip, $reason ) =
      split( " ", $PBBlack{$ip} );
    $this->{mypbreason} = "totalscore for $this->{ip} is $totalscore, last penalty was '$reason'";
    return 1 if $totalscore < $PenaltyLimit;
    $this->{prepend} = "[PenaltyBox]";

    mlog( $fh, "[monitoring] $this->{mypbreason}" ) if $DoPenalty == 2 || $DoPenalty == 3;
    return 1 if $DoPenalty == 2 || $DoPenalty == 3;
    return 0;
  }

sub PBExtremeOK {
    my ( $fh, $myip ) = @_;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    d('PBExtremeOK');
    my $newscore;
    my $data;
    my $t    = time;
    my $ip   = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    my $slok = $this->{allLovePBSpam} == 1;
    
    if (!$denySMTPstrictEarly) {
    
    my $ret = matchIP( $myip, 'denySMTPConnectionsFromAlways', $fh ) ;
    my $tlit;
    if (!$denySMTPstrictEarly && $ret && $DoDenySMTPstrict == 1 && !matchIP( $myip, 'noPB', 0, 1 ) ) {
        $this->{prepend} = "[DenyStrict]";
        mlog( $fh, "blocked by denySMTPConnections strict: $ret" )
          if $denySMTPLog || $ConnectionLog == 2;
        $Stats{denyConnection}++;
        $this->{mypbreason} = "blocked by denySMTPConnections strict '$ret'";
        return 0;
      }
    if (!$denySMTPstrictEarly && $ret && $DoDenySMTPstrict == 2 && !matchIP( $myip, 'noPB', 0, 1 ) ) {
        $this->{prepend} = "[DenyStrict]";
        mlog( $fh, "[monitoring] blocked by denySMTPConnections strict: $ret" )
          if $denySMTPLog || $ConnectionLog == 2;
      }
	}

    #return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted}  && !$ExtremeWL;
    return 1 if $this->{noprocessing} && !$ExtremeNP;
    my $mf   = lc $this->{mailfrom};
    my $mfd  = $1 if $mf =~ /\@(.*)/;
	return 1 if  ($mfd && $maxSMTPdomainIPWL && $mfd =~ $IPDWLDRE);

    if (exists $PBWhite{$ip}) {
    pbBlackDelete( $fh, $ip );

    return 1;
    }

    return 1 if $this->{ispip}        && !$this->{cip};
    return 1 if $this->{nodelay}      && !$this->{cip};
    return 1 if $this->{nopb}         && !$this->{cip};
    return 1 if $this->{acceptall};
    return 1 if $this->{relayok};
    return 1 if $this->{localuser};
    my $ret = matchIP( $myip, 'denySMTPConnectionsFrom', $fh );

 
    if ( $ret && $DoDenySMTP == 1 ) {
        $this->{prepend} = "[DenyIP]";

        $Stats{denyConnection}++;
        $this->{mypbreason} = "blocked by denySMTPConnections '$ret'";
        return 0;
      }
    if ( $ret && $DoDenySMTP == 2 ) {
        $this->{prepend} = "[DenyIP]";
        mlog( $fh, "[monitoring] blocked by denySMTPConnections '$ret'" )
          if $PenaltyExtremeLog;
      }

    return 1 if !$PenaltyExtreme;
    return 1 if ( !exists $PBBlack{$myip} );

    my $tlit = "";

    $tlit = "[monitoring]" if $DoPenaltyExtreme == 2;
    $tlit = "[scoring]"    if $DoPenaltyExtreme == 3;

    my ( $ct, $ut, $level, $totalscore, $sip, $reason, $counter ) =
      split( " ", $PBBlack{$ip} );
    if ( $totalscore >= $PenaltyLimit && $totalscore < $PenaltyExtreme ) {
        $this->{messagereason} = "Bad IP History";
        pbAdd( $fh, $myip, $pbValencePB, "BadHistory", 1 );

      }
    if ( $PenaltyExtreme && $totalscore >= $PenaltyExtreme ) {
        $this->{messagereason} = "Extreme Bad History";
        pbAdd( $fh, $myip, $pbeValencePB, "ExtremeHistory", 1 );
      }
    return 1 if !$DoPenaltyExtreme;
    if ( $PenaltyExtreme && $totalscore >= $PenaltyExtreme ) {
        $this->{prepend}    = "[Extreme]";
        $this->{mypbreason} = "score for $myip is $totalscore, surpassing extreme level of $PenaltyExtreme";

        #$this->{prepend} .= "[$tlit]" if $DoPenaltyExtreme >= 2;
        mlog( $fh,
"$tlit (totalscore for '$myip' is $totalscore, surpassing extreme level of $PenaltyExtreme, last penalty was '$reason')"
        ) if $PenaltyExtremeLog == 2 && $DoPenaltyExtreme >= 2;
        return 1 if $DoPenaltyExtreme >= 2;
        $Stats{pbextreme}++;
        return 0;
      }

    return 1;
  }

sub RBLCacheOK {
    my ( $fh, $myip ) = @_;
    my $this = $Con{$fh};
    d('RBLCacheOK');
    my $ip = $myip;
    $ip = $this->{cip} if $this->{cip};
    return 1 if $this->{rblcachedone} && !$this->{cip};
    $this->{rblcachedone} = 1;

    return 1 if !$ValidateRBL;
    return 1 if $this->{nodelay} && !$this->{cip};
    return 1 if $noRBL && matchIP( $ip, 'noRBL', 0, 1 );

    #return 1 if $this->{contentonly};
    return 1 if $this->{whitelisted} && !$RBLWL;
    return 1 if $this->{noprocessing};
    return 1 if !( exists $RBLCache{$ip} );
    return 1 if !$RBLCacheExp;
    return 1 if exists $PBWhite{$ip};
    return 1 if $this->{ispip}       && !$this->{cip};
    return 1 if $this->{localuser};
    return 1 if $this->{acceptall};
    return 1 if $this->{relayok};
    return 1 if $this->{rwlok};

    my $slok         = $this->{allLoveRBLSpam} == 1;
    my $mValidateRBL = $ValidateRBL;
    $mValidateRBL = 3
      if $switchSpamLoverToScoring
          && $DoPenaltyMessage
          && ( $slok || $this->{spamlover} );
    $mValidateRBL = 3
      if $switchTestToScoring
          && $DoPenaltyMessage
          && ( $rblTestMode || $allTestMode );
 	$this->{rbldone} = 1;
    my $tlit;
    $tlit = "[spam found]"   if $mValidateRBL == 1;
    $tlit = "[monitoring]" if $mValidateRBL == 2;
    $tlit = "[scoring]"    if $mValidateRBL == 3;
    $this->{prepend} = "[DNSBL]";

    #$this->{prepend} .= "[$tlit]" if $mValidateRBL >= 2;

    my ( $ct, $mm, $status, $rbl1, $rbl2 ) = split( " ", $RBLCache{$ip} );
    my $rbllists = "$rbl1, $rbl2";
    return 1 if $status=2;

    $this->{mypbreason} = $rbllists;

    $this->{messagereason} = "$ip listed in DNSBLcache by $rbllists";
    mlog( $fh, "$tlit ($this->{messagereason} at $mm)" )
      if $RBLLog && $mValidateRBL >= 2;
    
    return 1 if $mValidateRBL == 2;
    pbAdd( $fh, $ip, $rblValencePB, "DNSBLcache" ) if $rblValencePB > 0;
    return 1 if $mValidateRBL == 3;
    $Stats{rblfails}++ unless $slok;
    my $reply = $RBLError;

    $reply =~ s/RBLLISTED/$rbllists/g;
    if ($ForceRBLCache) {
        thisIsSpam( $fh, "$this->{messagereason}", $RBLFailLog, "$reply", 0, 0, 1 );
      } else {
        thisIsSpam( $fh, "$this->{messagereason}", $RBLFailLog, "$reply", $rblTestMode, $slok,
            ( $slok || $rblTestMode || $this->{spamlover} ) );
      }
    return 0;
  }
  
sub Delayok {
    my ( $fh, $rcpt ) = @_;
    my $this   = $Con{$fh};
    my $client = $this->{friend};
    $this->{prepend} = "";
    d('Delayok');

    if ( $this->{delaydone} ) {
        $this->{delaydone} = '';
        return 1;
      }
    return 1 if !$EnableDelaying;
    return 1 if $this->{relayok};
    return 1 if $Con{$client}->{relayok};
    return 1 if $this->{ispip};
    return 1 if $this->{contentonly};
    return 1 if $this->{acceptall};
    return 1 if $this->{ip} =~ /$IPprivate/;
    my ( $cachetime, $cresult, $cdomain, $chelo ) = SPFCacheFind($this->{ip});
    return 1 if $cresult eq "pass";
    

    my $a    = lc $this->{mailfrom};
    my $time = $UseLocalTime ? localtime() : gmtime();
    my $tz   = $UseLocalTime ? tzStr() : '+0000';
    $time =~ s/... (...) +(\d+) (........) (....)/$2 $1 $4 $3/;
    if ( !$DelayWL && $this->{whitelisted} ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: not delayed (whitelisted); $time $tz\r\n"
          if ( $DelayAddHeader
            && $this->{myheader} !~ /not delayed \(whitelisted\)/ );
        return 1;
      }
    if ( !$DelayNP && $this->{noprocessing} ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (noprocessing); $time $tz\r\n"
          if ( $DelayAddHeader
            && $this->{myheader} !~ /not delayed \(noprocessing\)/ );
        return 1;
      }
    if ( $this->{nodelay} ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (noDelay IP); $time $tz\r\n"
          if ( $DelayAddHeader
            && $this->{myheader} !~ /not delayed \(noDelay IP\)/ );
        return 1;
      }
    if ( !$DelayWL && pbWhiteFind( $this->{ip} ) ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (whitebox $this->{ip}); $time $tz\r\n"
          if ( $DelayAddHeader
            && $this->{myheader} !~ /not delayed \(whitebox/ );
        return 1;
      }

    if ( !$DelayWL && $this->{rwlok} ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (white $this->{ip}); $time $tz\r\n"
          if ( $DelayAddHeader && $this->{myheader} !~ /not delayed \(white / );
        return 1;
      }
    if ( !$DelaySL && $this->{allLoveDLSpam} == 1 ) {

        # add to our header; merge later, when client sent own headers  (per msg)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (spamlover); $time $tz\r\n"
          if ( $DelayAddHeader
            && $this->{myheader} !~ /not delayed \(spamlover\)/ );
        return 1;
      }
    if ( $this->{dlslre} ) {

        # add to our header; merge later, when client sent own headers  (per rcpt)
        $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (delay-spamlover); $time $tz\r\n"
          if ( $DelayAddHeader
           && $this->{myheader} !~ /not delayed \(delay-spamlover\)/ );
        return 1;
      }
    if ($DelayNormalizeVERPs) {

        # strip extension
        $a =~ s/\+.*(?=@)//;

        # replace numbers with '#'
        $a =~ s/\b\d+\b(?=.*@)/#/g;
      }
    my $ip = ipNetwork( $this->{ip}, ( $DelayUseNetblocks ? 24 : 32 ) );
    my $hash = "$ip $a " . lc $rcpt;

    # get sender domain
    my $awhite = $a;
    $awhite =~ s/.*@//;
    my $hashwhite = "$ip $awhite";
    if ( $CanUseMD5Keys && $DelayMD5 ) {
        $hash      = Digest::MD5::md5_hex($hash);
        $hashwhite = Digest::MD5::md5_hex($hashwhite);
      }
    my $t = time;
    my $delay_result;
    if ( !exists $DelayWhite{$hashwhite} ) {
        if ( !exists $Delay{$hash} ) {
            mlog( $fh, "adding new triplet: ($ip,$a," . lc $rcpt . ")", 1 )
              if $DelayLog == 2;
            $Stats{rcptDelayed}++;
            $Delay{$hash} = $t;
            $delay_result = 0;
          } else {
            my $interval          = $t - $Delay{$hash};
            my $intervalFormatted = formatTimeInterval($interval);
            if ( $interval < $DelayEmbargoTime * 60 ) {
                mlog( $fh, "embargoing triplet: ($ip,$a," . lc $rcpt . ") waited: $intervalFormatted", 1 )
                  if $DelayLog == 2;
                $Stats{rcptEmbargoed}++;
                $delay_result = 0;
              } elsif ( $interval < $DelayEmbargoTime * 60 + $DelayWaitTime * 3600 ) {
                mlog( $fh, "accepting triplet: ($ip,$a," . lc $rcpt . ") waited: $intervalFormatted", 1 )
                  if $DelayLog == 2;
                delete $Delay{$hash};
                $DelayWhite{$hashwhite} = $t;
                $delay_result = 1;

                # add to our header; merge later, when client sent own headers
                $this->{myheader} .= "X-Assp-Delay: $rcpt was delayed before $intervalFormatted; $time $tz\r\n"
                  if $DelayAddHeader;
              } else {
                mlog( $fh, "late triplet encountered, deleting: ($ip,$a," . lc $rcpt . ") waited: $intervalFormatted",
                    1 )
                  if $DelayLog == 2;
                $Stats{rcptDelayedLate}++;

                $Delay{$hash} = $t;
                $delay_result = 0;
              }
          }
      } else {
        my $interval          = $t - $DelayWhite{$hashwhite};
        my $intervalFormatted = formatTimeInterval($interval);
        if ( $interval < $DelayExpiryTime * 24 * 3600 ) {
            mlog( $fh, "renewing tuplet: ($ip,$awhite) age: " . $intervalFormatted, 1 )
              if $DelayLog == 2;
            $DelayWhite{$hashwhite} = $t;

            # multiple rcpt's
            delete $Delay{$hash};
            $delay_result = 1;

            # add to our header; merge later, when client sent own headers
            $this->{myheader} .= "X-Assp-Delay: $rcpt not delayed (auto accepted); $time $tz\r\n"
              if $DelayAddHeader;
          } else {
            mlog( $fh, "deleting expired tuplet: ($ip,$awhite) age: " . $intervalFormatted, 1 ) if $DelayLog == 2;
            $Stats{rcptDelayedExpired}++;

            delete $DelayWhite{$hashwhite};
            $Delay{$hash} = $t;
            $delay_result = 0;
          }
      }
    return $delay_result;
  }


# returns true if all of the addresses in the space separated list are Noprocessing addresses
sub allNoProcessing {
    my $rcpt = shift;
    my $c    = 0;
    for ( split( ' ', $rcpt ) ) {

        return 0 unless matchSL( $_, 'noProcessing' );
        $c++;
      }
    $c;
  }
sub allRot {
    my $a = shift;
    $a =~ tr/A-Za-z/N-ZA-Mn-za-m/;
    return ($a);
}
sub allSL {
    my ( $rcpt, $from, $re ) = @_;
    my $c = 0;
    return 1 if matchSL( $from, $re, 1 );
    for ( split( ' ', $rcpt ) ) {
        return 1 if matchSL( $_, $re, 1 );
        next;
      }
    return 0;
  }

sub allSH {
    my ( $rcpt, $re ) = @_;
    my $c = 0;
    for ( split( ' ', $rcpt ) ) {
        return 1 if matchSL( $_, $re, 1 );
        return 0 unless matchSL( $_, $re, 1 );
        $c++;
      }
    $c;
  }

# the message is not spam -- route it to the server
sub isnotspam {
    my ( $fh, $done ) = @_;
    d(23);
    my $this   = $Con{$fh};
    my $server = $this->{friend};

    # it's time to merge our header with client's one
    $this->{myheader} = &headerWrap( $this->{myheader} );    # wrap long lines
    $this->{header} =~ s/^($HeaderRe*)/$1\r\n\n\n\r$this->{myheader}/o;
    $this->{header} =~ s/\r?\n?\r\n\n\n\r/\r\n/;

    my $m = $this->{header};
    $this->{ccheader} = $this->{header};

    sendque( $server, $m );

    if ($done) {

        $this->{getline} = \&getline;
      } else {
        $this->{getline} = \&whitebody;
      }
  }

# the message is non spam -- just relay it to the server
sub whitebody {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    d(25);
    my $server = $this->{friend};
    $this->{maillength} += length($l);
    $this->{scanbuf} .= $l;
    if ( $maxRealSize
        && ( $this->{maillength} * $this->{numrcpt} > $maxRealSize ) ) {
        my $err = "552 message exceeds MAXREALSIZE byte (size \* rcpt)";
        mlog( $fh, "error: message exceeds maxRealSize $maxRealSize bytes (size \* rcpt)!" );
        $err = $maxRealSizeError if ($maxRealSizeError);
        $err =~ s/MAXREALSIZE/$maxRealSize/g;
        seterror( $fh, $err, 1 );
        done($fh);
        return;
      }
    my $done = $l =~ /^\.[\r\n]*$/
      || defined( $this->{bdata} ) && $this->{bdata} <= 0;
    my $mbytes = $MaxBytes;
    $mbytes = $ClamAVBytes if $ClamAVBytes > $MaxBytes;
    if ( ( $done || $this->{maillength} >= $mbytes ) && haveToScan($fh) ) {

        if ( !ClamScanOK( $fh, $this->{scanbuf} ) ) {


            thisIsSpam( $fh, $this->{messagereason}, $SpamVirusLog, $this->{averror}, $attachTestMode, $this->{allLoveATSpam} == 1, 1 );
            return;
          }
      }
    if ($done) {

        $this->{scanbuf} = $this->{ccheader} . $this->{scanbuf};
        ccMail( $fh, $this->{mailfrom}, $sendHamInbound, $this->{scanbuf}, $this->{rcpt} );

        $this->{getline} = \&getline;
      }

    	sendque( $server, $l);


  }

# the message is non spam -- check if it is executable
sub whitebodyNoExe {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    d(255);
    my $b = $this->{header} .= $l;
    $this->{data} .= $l;
    my $decob = decodeMimeWords($b);
    my $tlit  = "";
    my $logsub;
    $tlit = "[monitoring]" if $DoBlockExes == 2;
    $tlit = "[scoring]"    if $DoBlockExes == 3;
    $this->{attachcomment} = "no bad attachments" if $BlockWLExes || $BlockNPExes;

    if ( $maxRealSize
        && ( $this->{maillength} * $this->{numrcpt} > $maxRealSize ) ) {
        my $err = "552 message exceeds MAXREALSIZE byte (size \* rcpt)";
        mlog( $fh, "error: message exceeds maxRealSize $maxRealSize bytes (size \* rcpt)!" );
        $err = $maxRealSizeError if ($maxRealSizeError);
        $err =~ s/MAXREALSIZE/$maxRealSize/g;
        seterror( $fh, $err, 1 );
        done($fh);
        return;
      }

    my $done = $l =~ /^\.[\r\n]*$/
      || defined( $this->{bdata} ) && $this->{bdata} <= 0;

    #if($done) {
    #mlog($fh,"test:2 $disclaimerlines") if $disclaimerlines;
    #$l=~s/\.[\r\n]/$disclaimerlines\r\n\.\r\n/ if $disclaimerlines;}

    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    my $mbytes = $MaxBytes ? $MaxBytes : 10000;
    $mbytes = $ClamAVBytes
      if $ClamAVBytes > $MaxBytes && $CanUseAvClamd && $AvailAvClamd;
  

    if ( $done || length($b) >= $mbytes ) {
        $this->{maillength} = length($b);
        if (  !$this->{red}
            && $redRe
            && $redReRE != ""
            && substr( $b, 0, $maxbytes ) =~ ( '(' . $redReRE . ')' ) ) {
            
            mlogRe( $fh, $1, "Red" );
        	$this->{red} = $1;
          }

        if ( $BlockUuencoded && substr( $b, 0, $maxbytes ) =~ $UUENCODEDRe ) {
            $Stats{msgverify}++;
            delayWhiteExpire($fh);
            mlog( $fh, "MsgVerify: uuencoded" );
            seterror( $fh, "$UuencodedError", 1 );
            done($fh);
            return;
          }
       
        if ( $this->{noprocessing}  || $this->{ismaxsize}) {

            # noprocessing
            if ($BlockNPExes && !CheckAttachments( $fh, $BlockNPExes, substr( $b, 0, $maxbytes ), $npAttachLog, 1 ) ) {
                return;
              }

            if ( haveToScan($fh) && !ClamScanOK( $fh, substr( $b, 0, $mbytes ) ) ) {
                thisIsSpam( $fh, $this->{messagereason}, $SpamVirusLog, $this->{averror}, 0, 0, 1 );
                return;
              }

            $this->{prepend} = "[NoProcessing]";
            $logsub = ( $subjectLogging && $this->{originalsubject} ? " [$this->{originalsubject}]" : "" );
			$this->{attachcomment} = "attachments not checked" if !$BlockNPExes;
            mlog( $fh, "message proxied without processing ($this->{attachcomment})$logsub", 0, 2 );
            $Stats{noprocessing}++;

            ccMail( $fh, $this->{mailfrom}, $sendHamInbound, $b, $this->{rcpt} )
              if $done;

            isnotspam( $fh, $done );

          } else {

            # whitelisted
            if ($BlockWLExes && !CheckAttachments( $fh, $BlockWLExes, substr( $b, 0, $maxbytes ), $wlAttachLog, 1 ) ) {
                return;
              }

            if ( haveToScan($fh) && !ClamScanOK( $fh, substr( $b, 0, $mbytes ) ) ) {
                thisIsSpam( $fh, $this->{messagereason}, $SpamVirusLog, $this->{averror}, $attachTestMode, $this->{allLoveATSpam} == 1, 1 );
                return;
              }
            
            if (!URIBLok( $fh, substr( $b, 0, $maxbytes ), $this->{ip} ) ) {
            	delayWhiteExpire($fh);
             	return;
            }
			$this->{attachcomment} = "attachments not checked" if !$BlockWLExes;
            $this->{prepend} = "[Local]"       if $this->{relayok};
            $this->{prepend} = "[Whitelisted]" if !$this->{relayok};
            


            addSpamProb( $fh, 1, 0 );

            if (  !$this->{red}
                && $redRe
                && $redReRE != ""
                && substr( $b, 0, $maxbytes ) =~ ( '(' . $redReRE . ')' ) ) {
            	
            	mlogRe( $fh, $1, "Red" );
        		$this->{red} = $1;
              }

            # tell maillog this isn't spam
            my $server = $this->{friend};
            my $fn = Maillog( $fh, '', $NonSpamLog );    # tell maillog this isn't spam
            $fn = ' -> ' . $fn if $fn;
            $fn = ""           if !$fileLogging;
            $logsub = ( ($subjectLogging && $this->{originalsubject}) ? " [$this->{originalsubject}]" : "" );

            ccMail( $fh, $this->{mailfrom}, $sendHamInbound, $b, $this->{rcpt} )
              if $done;

            mlog( $fh, "local ($this->{attachcomment})$logsub$fn", 0, 2 )
              if $this->{relayok};
            mlog( $fh, "whitelisted ($this->{attachcomment})$logsub$fn", 0, 2 )
              if !$this->{relayok};

            isnotspam( $fh, $done );
          }
      }
  }

# the message may or may not be spam -- get the body and test it.

sub getbody {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    my $dataref;
	my $data;
    my $b = $this->{header} .= $l;
    $this->{maillength}=length($this->{header});
    $this->{data} .= $l;

    my ( $bomblt, $er );

    my $done = $l =~ /^\.[\r\n]*$/
      || defined( $this->{bdata} ) && $this->{bdata} <= 0;

    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    my $mbytes = $MaxBytes ? $MaxBytes : 10000;
    $mbytes = $ClamAVBytes
      if $ClamAVBytes > $MaxBytes && $CanUseAvClamd && $AvailAvClamd;
    

    if ( $done || $this->{maillength} >= $mbytes ) {

        $this->{attachcomment} = "no bad attachments" if $BlockExes;
        $data = substr( $b, 0, $maxbytes );
        $dataref = \$data;

        dlog("getbody - done:$done maillength:$this->{maillength}");

        if (  !$this->{red}
            && $redRe
            && $redReRE != ""
            && $data =~ ( '(' . $redReRE . ')' ) ) {
            
            
            mlogRe( $fh, $1, "Red" );
        	$this->{red} = $1;
          }

        if (  !$this->{whitelisted}
            && $whiteRe
            && $whiteReRE != ""
            && $data =~ ( '(' . $whiteReRE . ')' ) ) {
            mlogRe( $fh, $1, "White" );
            $this->{whitelisted} = 1;
          }
      

        if ($BlockExes && !CheckAttachments( $fh, $BlockExes, $data, $extAttachLog, 1 ) ) {

          } elsif ( TestMessageScore($fh) ) {
            MessageScore( $fh, $done );
            return;

          } elsif (!BombOK( $fh ) ) {
            $bomblt = $bombError;

            $bomblt .= " (reason: $this->{messagereason}) " if $bombErrorReason;
            $Stats{bombs}++;
            delayWhiteExpire($fh);
            my $slok = $this->{allLoveBoSpam} == 1;

            thisIsSpam( $fh, $this->{messagereason}, $spamBombLog, $bomblt, $bombTestMode, $slok, 1 );

          } elsif ( $DoPenaltyMessage
            && $PenaltyMessageBlock
            && $this->{messagescore} >= $PenaltyMessageBlock ) {
            MessageScore( $fh, $done );
            return;

          } elsif (!ScriptOK( $fh, $data ) ) {
            my $slok = $this->{allLoveBoSpam} == 1;
            $Stats{scripts}++;
            delayWhiteExpire($fh);
            $bomblt = $scriptError;

            $bomblt .= " (reason: $this->{messagereason}) " if $bombErrorReason;
            $this->{prepend} = "[BombScript]";
            thisIsSpam( $fh, $this->{messagereason}, $scriptLog, $bomblt, $bombTestMode, $slok, 1 );

          } elsif ( $this->{spamfound} ) {

            # Spam is found to be safe, lets pass it on.

            my $fn = Maillog( $fh, '', $baysSpamLog );
            $fn = ' -> ' . $fn if $fn;
            $fn = ""           if !$fileLogging;
            my $logsub = ( $subjectLogging ? " [$this->{originalsubject}]" : "" );
            mlog( $fh, "[spam found] and passing ($this->{messagereason})$logsub $fn", 1 );
            delayWhiteExpire($fh);
            isnotspam( $fh, $done );
          } elsif (!$this->{ismaxsize} && !BombBlackOK( $fh, substr( $b, 0, $maxbytes ) ) ) {
            $bomblt = $bombError;
            $bomblt .= " (reason: $this->{messagereason}) " if $bombErrorReason;
            delayWhiteExpire($fh);
            my $slok = $this->{allLoveBoSpam} == 1;
            thisIsSpam( $fh, $this->{messagereason}, $spamBombLog, $bomblt, $bombTestMode, $slok, 1 );

          } elsif ( $DoPenaltyMessage
            && $PenaltyMessageBlock
            && $this->{messagescore} >= $PenaltyMessageBlock ) {
            MessageScore( $fh, $done );
            return;
          } elsif ( haveToScan($fh) && !ClamScanOK( $fh, substr( $b, 0, $mbytes ) ) ) {
            $this->{prepend} = "[VIRUS]";
            thisIsSpam( $fh, $this->{messagereason}, $SpamVirusLog, $this->{averror}, $attachTestMode, $this->{allLoveATSpam} == 1, 1 );
            return;
          } elsif (!URIBLok( $fh, substr( $b, 0, $maxbytes ), $this->{ip} ) ) {
            delayWhiteExpire($fh);

          } elsif ( $this->{addressedToSpamBucket} ) {
            $Stats{spambucket}++;
            $this->{messagereason} = "Collect Address: $this->{addressedToSpamBucket}";
            pbAdd( $fh, $this->{ip}, $saValencePB, "SpamCollectAddress", 2 )
              if $saValencePB > 0;
            $this->{prepend} = "[Collect]";
            thisIsSpam( $fh, "Collect Address: $this->{addressedToSpamBucket}", $spamBucketLog, "250 OK", 0, 0, 0 );

          } elsif ( $DoPenaltyMessage
            && $PenaltyMessageBlock
            && $this->{messagescore} >= $PenaltyMessageBlock ) {
            MessageScore( $fh, $done );

          } elsif (BayesOK( $fh, substr( $b, 0, $maxbytes ), $this->{ip} ) ) {
            my $slok = $this->{allLoveBaysSpam} == 1;
            my $mybaystestmode; 
            $mybaystestmode = "1" if $this->{bayeslowconf} || $baysTestMode;            
            $mybaystestmode = $slok = 0 if allSH($this->{rcpt},'baysSpamHaters');

            
            if ( !$slok  ) { $Stats{bspams}++; }

            $this->{prepend} = "[Bayesian]";
            thisIsSpam( $fh, 'Bayesian', $baysSpamLog, $SpamError, $mybaystestmode, $slok, $done );
          } else {
            if (   $DoPenaltyMessage
                && $PenaltyMessageBlock
                && $this->{messagescore} >= $PenaltyMessageBlock ) {
                MessageScore( $fh, $done );
                return;
              }
            if (   $DoPenaltyMessage
                && $PenaltyMessageTag
                && $this->{messagescore} >= $PenaltyMessageTag ) {
                $this->{messagelow} = 1;
                $this->{mypbreason} = "MessageScore surpassed low limit";
                my $slok = $this->{allLovePBSpam} == 1;
                $er              = $SpamError;
                $er              = $PenaltyError if $PenaltyError;
                $this->{prepend} = "[MessageLimit]";
                delayWhiteExpire($fh);
                $Stats{msgscoring}++;
                thisIsSpam( $fh, $this->{mypbreason}, $spamMSLog, $er, ( $msTestMode || $this->{messagelow} ),
                    $slok, 1 );
                return;
              } elsif ( !PBOK( $fh, $this->{ip} ) ) {
                my $slok = $this->{allLovePBSpam} == 1;
                $Stats{pbdenied}++ unless $slok;
                $er = $SpamError;
                $er = $PenaltyError if $PenaltyError;
                

                $this->{myheader} .= "X-Assp-Penalty: $this->{mypbreason}\r\n";
                $this->{prepend} = "[Penalty]";
                thisIsSpam( $fh, $this->{mypbreason}, $spamPBLog, $er, $pbTestMode || $DoPenalty == 4, $slok, 1 );
                return;
              }
            my $fn=Maillog($fh,'',$baysNonSpamLog) if $baysNonSpamLog==4 || $baysNonSpamLog==2 ;

            $fn=' -> '.$fn if !$fn=="";
            $fn="" if !$fileLogging;
            my $logsub = ( $subjectLogging ? " [$this->{originalsubject}]" : "" );
            $this->{myheader}.=sprintf("X-Assp-Bayes-Confidence: %.5f\r\n",$this->{SpamProbConfidence}) if $AddSpamProbHeader && $AddConfidenceHeader && $this->{SpamProbConfidence}>0;
             addSpamProb( $fh, 0, 0 );
            ccMail( $fh, $this->{mailfrom}, $sendHamInbound, $b, $this->{rcpt} )
              if $done;
            $this->{messagereason} = "Bonus: Message OK";

            pbAdd( $fh, $this->{ip}, $okValencePB, "MessageOK", 2, 1 );
            $this->{prepend} = "[MessageOK]";
            mlog( $fh, "MESSAGE OK$logsub$fn", 0, 2 );
            $Stats{bhams}++;
            isnotspam( $fh, $done );
          }
      }
  }


# checks for blocked attachments
sub CheckAttachments
{
    my ( $fh, $block, $b, $attachlog, $done ) = @_;
    my $this = $Con{$fh};
    my @name;

    return 1 unless $CanUseEMM;
    return 1 unless $DoBlockExes;
    return 1 if $this->{attachdone};
    $this->{prepend} = '';

    eval {
        $Email::MIME::ContentType::STRICT_PARAMS=0;      # no output about invalid CT
        my $email=Email::MIME->new($b);
        foreach my $part ( $email->parts ) {
            my $dis = $part->header("Content-Type") || '';        # get the charset of the email part
            my $attrs = $dis =~ s/^.*?;// ? Email::MIME::ContentType::_parse_attributes($dis) : {};
            my $name = $attrs->{name} || $part->{ct}{attributes}{name};
            $name =~ tr/\x80-\xFF/_/;
            if ($name && $part->header("Content-Disposition")=~ /attachment|inline/i ) {
                mlog($fh,"info: attachment '$name' found for Level-$block") if ($AttachmentLog == 2);
                push(@name,$name);
            }
        }
    };
    mlog($fh,"error: unable to parse message for attachments - $@") if $@;
    my $numatt = @name;
    my $s = 's' if ($numatt >1);
    mlog($fh,"info: $numatt attachment$s found for Level-$block") if ($AttachmentLog == 1 && $numatt);

    foreach my $name (@name) {
        if ( ( $block >= 1 && $block <= 3 && $name =~ $badattachRE[$block] ) ||
             ( $GoodAttach && $block == 4 && $name !~ $goodattachRE  ) )
        {
            $this->{attachdone} = 1;

            $this->{prepend} = "[Attachment]";

            my $tlit="SPAM FOUND";
            $tlit = "[monitoring]" if $DoBlockExes == 2;
            $tlit = "[scoring]"    if $DoBlockExes == 3;

            $Stats{viri}++ if $DoBlockExes == 1;
            delayWhiteExpire($fh) if $DoBlockExes == 1;

            $this->{messagereason} = "bad attachment '$name'";
            $this->{attachcomment} = $this->{messagereason};
            mlog( $fh, "$tlit $this->{messagereason}" ) if $DoBlockExes > 1 && $AttachmentLog;
            return 1 if $DoBlockExes == 2;

            pbAdd( $fh, $baValencePB, "BadAttachment" ) if $DoBlockExes != 2;
            return 1 if $DoBlockExes == 3;

            my $reply = $AttachmentError;
            $reply =~ s/FILENAME/$name/g;
            my $slok = $this->{allLoveATSpam} == 1;
            thisIsSpam( $fh, $this->{messagereason}, $attachlog, $reply, $attachTestMode, $slok, $done );

            return 0;
        }
    }
    return 1;
}


sub checkInfection {
    return;
  }

# This is spam, lets see if its Testmode or spamlover.
sub thisIsSpam {
    my ( $fh, $reason, $log, $error, $testmode, $slok, $done ) = @_;
    my $this = $Con{$fh};
    my $logsub;

    $this->{messagereason} = $reason;
    d( 'thisIsSpam: ' . $reason );
    my ($to) = $this->{rcpt} =~ /(\S+)/;
    my $mfd          = $1 if $to =~ /\@(.*)/;
    $error =~ s/LOCALDOMAIN/$mfd/g;
    
 if ($reason =~ /Bayesian/) {
 	if (allSH( $this->{rcpt}, 'baysTestModeUserAddresses' )) {
 	$testmode = "bayesian Testmode user";
 	$slok=0; # make sure it's not flagged as a spam lover
 	}
 }



    addSpamProb( $fh, 0, 1 );
    $this->{spamfound} = 1;   # Set spamfound flag.

    $testmode = "testmode" if $testmode==1;
    $testmode  = "all in testmode" if $allTestMode;
    $testmode = $slok = $this->{tagmode} = 0 if allSH( $this->{rcpt}, 'spamHaters' );
    
     if ((($baysTestModeOverwrite && $testmode && $reason =~ /Bayesian/) && !($msTestMode || $DoPenaltyMessage == 4 || $this->{allLovePBSpam} == 1))  && $DoPenaltyMessage == 1 && $PenaltyMessageBlock
                && $this->{messagescore} >= $PenaltyMessageBlock ) {
                $this->{prepend} .= "[MessageScore]";
                $error     	= $SpamError;
                $error  	= $PenaltyError if $PenaltyError;
                $reason .= " & MessageScore";
				$slok   = $this->{allLovePBSpam} == 1;
				$log = $spamMSLog;
				$Stats{bspams}--;
				$Stats{msgscoring}++;
				
                }

    # add to our header; merge later, when client sent own headers
    $this->{myheader} .= "X-Assp-Version: $version$modversion\r\n";
    $this->{myheader} .= "X-Assp-Redlisted: Yes ($this->{red})\015\012"
      if $this->{red};
    $this->{myheader} .= "X-Assp-Spam: YES\r\n"
      if $AddSpamHeader && !$this->{bayeslowconf};
    $this->{myheader} .= "X-Assp-Spam: YES (Probably)\r\n"
      if $AddSpamHeader && $this->{bayeslowconf};
    $this->{myheader} .= "X-Assp-Block: NO (Spamlover)\r\n" if $slok;

    $this->{myheader} .= "X-Assp-Original-Subject: $this->{originalsubject}\r\n";
    $this->{myheader} .= "X-Assp-Block: NO ($testmode)\r\n"
      if $testmode && !$this->{messagelow};
    $this->{myheader} .= "X-Assp-Block: NO (low message threshold:$PenaltyMessageTag)\r\n"
      if $testmode && $this->{messagelow};
    $this->{myheader} .= "$AddCustomHeader\r\n" if $AddCustomHeader;

    $this->{myheader} .= "X-Assp-Spam-Reason: " . ucfirst($reason) . "\r\n"
      if $AddSpamReasonHeader;
    $this->{myheader} .= "X-Assp-Message-Totalscore: $this->{messagescore}\r\n"
      if $AddScoringHeader && $this->{messagescore} > 0;
    my $passtext;

    if (   $slok
        || $testmode
        || $this->{tagmode}
        || $this->{spamlover}
        || $this->{messagelow}
        || $this->{bayeslowconf} ) {
        $done = 1;
        if ( $this->{messagelow} ) {
            $this->{prepend}      .= "[lowlimit]";
            $this->{saveprepend2} .= "[lowlimit]";
            $passtext = "passing because  messagescore($this->{messagescore}) low";

            #mlog($fh,$passtext,0,1);
          } elsif ( $slok || $this->{spamlover} ) {
            $this->{prepend}      .= "[sl]";
            $this->{saveprepend2} .= "[sl]";
            $passtext = "passing because spamlover, otherwise blocked ($reason)";

            #mlog($fh,$passtext,0,1);
            $Stats{spamlover}++;
          } elsif ( $this->{tagmode} ) {
            $this->{prepend} .= "[tagmode]";
            $passtext = "passing because tagmode: $this->{rcpt}, otherwise blocked ($reason)";

            #mlog($fh,$passtext,0,1);
          } elsif ( $this->{bayeslowconf} ) {
            $this->{prepend}      .= "[lowconfidence]";
            $this->{saveprepend2} .= "[lowconfidence]";
            $passtext = "passing because of low confidence, otherwise blocked ($reason)";

            #mlog($fh,$passtext,0,1);
		  } elsif ( $testmode ) {
		 		$this->{prepend}.="[testmode]";
				$this->{saveprepend2}.="[testmode]";
				$passtext = "passing because $testmode, otherwise blocked ($reason)";
		  }

        # pretend it's not spam
        $this->{header} =~ s/^($HeaderRe*)/$1From: sender not supplied\r\n/o
          unless $this->{header} =~ /^$HeaderRe*From:/io;    # add From: if missing
        $this->{header} =~ s/^($HeaderRe*)/$1Subject:\r\n/o
          unless $this->{header} =~ /^$HeaderRe*Subject:/io;    # add Subject: if missing


          
        if ($slok && $spamTagSL ) {
          } else {
            $this->{header} =~ s/^Subject:/Subject: $this->{prepend}/gim
              if ( $spamTag && $this->{prepend} ne "" );
          }
        
        if ( $slok && $spamSubjectSL ) {
          } else {

            $this->{header} =~ s/^Subject:/Subject: $spamSubject/gim
              if $spamSubject;
          }

 

        #Lets check if its safe to pass if not already done so.

        if ($done) {

            my $fn = Maillog( $fh, '', $log );    # tell maillog what this is.
            $fn = ' -> ' . $fn if $fn;
            $fn = ""           if !$fileLogging;
            $logsub = ( $subjectLogging && $this->{originalsubject} ? " [$this->{originalsubject}]" : "" );
            
            mlog( $fh, "[spam found] and $passtext$logsub$fn", 0, 2 );
            delayWhiteExpire($fh);
            isnotspam( $fh, $done );
          } else {
            $this->{getline} = \&getbody;
          }

      } else {

        my $fn = Maillog( $fh, '', $log );    # tell maillog what this is.
        $fn = ' -> ' . $fn if $fn;
        $fn = ""           if !$fileLogging;

        $logsub = ( $subjectLogging && $this->{originalsubject} ? " [$this->{originalsubject}]" : "" );

        mlog( $fh, "[spam found] ($reason)$logsub$fn", 0, 2 );
        delayWhiteExpire($fh);
        $error = $SpamError if $error eq "";
        $error =~ s/500/554/i;

        seterror( $fh, $error, $done );
      }
  }

# delete safelisted tuplet
sub delayWhiteExpire {
    my $fh   = shift;
    my $this = $Con{$fh};

    my $ip = $this->{ip};
    $ip = $this->{cip} if $this->{ispip} && $this->{cip};

    pbWhiteDelete( $fh, $ip );
    return unless ( $EnableDelaying && $DelayExpireOnSpam );
    my $a = lc $this->{mailfrom};

    # get sender domain
    $a =~ s/.*@//;
    my $ipn = ipNetwork( $ip, ( $DelayUseNetblocks ? 24 : 32 ) );
    my $hash = "$ipn $a";
    $hash = Digest::MD5::md5_hex($hash) if $CanUseMD5Keys && $DelayMD5;
    if ( $DelayWhite{$hash} ) {

        # delete whitelisted (IP+sender domain) tuplet
        mlog( $fh,
            "deleting spamming safelisted tuplet: ($ipn,$a) age: " . formatTimeInterval( time - $DelayWhite{$hash} ),
            1 )
          if $DelayLog == 2;
        delete $DelayWhite{$hash};
      }
  }

# add to PenaltyBox
sub pbAdd {

    # status:
    # 0-message score and pbblackadd
    # 1-message score but don't pbblackadd
    # 2-pbblackadd but don't message score
    # noheader:
    # 0-write X-Assp header info
    # 1-skip X-Assp header info
    my ( $fh, $myip, $score, $reason, $status, $noheader ) = @_;
    return if $score == 0;
    my $this = $Con{$fh};
    return if $this->{relayok};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $reason2 = $reason;
    $reason2 = $this->{messagereason} if $this->{messagereason};
    if ( $noheader != 1 ) {
        $this->{myheader} .= "X-Assp-Message-Score: $score ($reason2)\r\n"
          if $AddScoringHeader && $status == 1;
        $this->{myheader} .= "X-Assp-IP-Score: $score ($reason2)\r\n"
          if $AddScoringHeader && $status == 2;
        $this->{myheader} .= "X-Assp-Message&IP-Score: $score ($reason2)\r\n"
          if $AddScoringHeader && !$status;
      }
    $this->{messagescore} += $score if $status != 2;

    mlog( $fh, "PB-Message-Score is $this->{messagescore}, added $score ($reason2)", 1 )
      if ( $MessageLog || $PenaltyLog == 2 ) && $status != 2;

    return if ( $status == 1 );
    return if ( $this->{isbounce} && $DoNotPenalizeNull );
    return if ( $this->{red} && $DoNotPenalizeRed );
    return if $this->{ispip} && !$this->{cip};
    return if $this->{nodelay} && !$this->{cip};
    return if !$DoPenalty;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    return if ( exists $PBWhite{$ip} ) && !matchIP( $myip, 'noPBwhite', 0, 1 );
    return if ( matchIP( $myip, 'noPB', 0, 1 ) );
    pbBlackAdd( $fh, $myip, $score, $reason ) if $status != 1;
  }

# find in penalty White list
sub pbWhiteFind {
    return if !$DoPenalty;
    my $myip = shift;
    return unless ($PBWhiteObject);
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    return 0 if matchIP( $myip, 'noPBwhite', 0, 1 );
    return 1 if ( exists $PBWhite{$ip} );
  }

#
sub pbBlackAdd {
    return if !$DoPenalty;
    my ( $fh, $myip, $score, $reason ) = @_;
    return if $score==0;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $t = time;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    if ( exists $PBBlack{$ip} ) {
        my ( $ct, $ut, $freq, $oldscore, $sip, $sreason ) =
          split( " ", $PBBlack{$ip} );
        $freq++;
        my $tdif     = $t - $ut;
        my $newscore = $oldscore + $score;
        $ip = ipNetwork( $myip, 24 );
        if ( $newscore <= 0 ) {
            delete $PBBlack{$ip};
            delete $PBBlack{$myip};
            return;
          }

        my $data = "$ct $t $freq $newscore $myip $reason";
        mlog( $fh, "PB-IP-Score for '$ip' is $newscore, added $score for $reason", 1 )
          if $PenaltyLog == 2 && $newscore > 0;

        $PBBlack{$ip} = $data if $PenaltyUseNetblocks;
        $PBBlack{$myip} = $data;

        #$this->{mypbreason}="$reason";
        return;
      } else {
        return if $score <= 0;
        my $freq = 1;

        #$this->{mypbreason}="$reason";
        my $data = "$t $t $freq $score $myip $reason";
        $ip = ipNetwork( $myip, 24 );
        $PBBlack{$ip} = $data if $PenaltyUseNetblocks;
        $PBBlack{$myip} = $data;
        mlog( $fh, "PB-IP-Score for '$ip' is $score, added $score for $reason", 1 )
          if $PenaltyLog == 2 && $score > 0 ;
      }
  }

#
sub pbBlackDelete {
    return if !$DoPenalty;
    my ( $fh, $myip, $score, $reason ) = @_;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    return unless ($PBBlackObject);
    my $t = time;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    if ( exists $PBBlack{$ip} ) {
        delete $PBBlack{$ip};
        delete $PBBlack{$myip};
        mlog( 0, "PB: deleting(black) $myip - $reason", 1 ) if $PenaltyLog == 2;
      }
  }

#
sub pbBlackFind {
    return if !$DoPenalty;
    my $myip = shift;
    return unless ($PBBlackObject);
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    return 0 if matchIP( $myip, 'noPB', 0, 1 );
    return 1 if ( exists $PBBlack{$ip} );
  }
sub pbBlackClear {
    my ( $fh, $myip ) = @_;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    delete $PBBlack{$myip};
    delete $PBBlack{$ip};
    return 1;
  }

sub pbTrapAdd {
    return if !$DoPenaltyMakeTraps;
    my ( $fh, $address ) = @_;
    my $this = $Con{$fh};
    return if ( $noProcessingIPs && matchIP( $this->{ip}, 'noProcessingIPs' ) );
    return if matchSL( $address, 'noPenaltyMakeTraps' );
    return if $spamtrapaddresses && matchSL( $address, 'spamtrapaddresses' );
    return if $this->{ispip};
    return if matchIP( $this->{ip}, 'noPB', 0, 1 );
    my $t = time;

    if ( exists $PBTrap{$address} ) {
        my ( $ct, $ut, $counter ) = split( " ", $PBTrap{$address} );
        $counter++;
        my $data = "$ct $t $counter";
        $PBTrap{$address} = $data;
      } else {
        my $data = "$t $t 1";
        $PBTrap{$address} = $data;
      }
  }

#
#
sub pbTrapDelete {

    my $address = shift;
    delete $PBTrap{$address};
  }

sub pbTrapFind {
    my $address = shift;
    return unless ($PBTrapObject);
    return if $DoPenaltyMakeTraps != 1;
    if ( exists $PBTrap{$address} ) {
        my ( $ct, $ut, $counter ) = split( " ", $PBTrap{$address} );
        mlog( 0, "PB: trap address $address found", 1 )
          if $counter >= $PenaltyMakeTraps && $PenaltyLog == 2;

        return 1 if $counter >= $PenaltyMakeTraps;

      }
    return 0;
  }

sub pbWhiteAdd {
    my ( $fh, $myip, $reason ) = @_;
    my $this = $Con{$fh};
    $myip = $this->{cip} if $this->{ispip} && $this->{cip};
    my $t      = time;
    my $status = 2;
    $this->{rwlok} = 1;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    return if $this->{nodelay} && !$this->{cip};
    return if $this->{isbounce};
    return if $this->{ispip}   && !$this->{cip};

    if ( exists $PBWhite{$ip} ) {
        my ( $ct, $ut, $pbstatus ) = split( " ", $PBWhite{$ip} );
        my $data = "$ct $t $status";
        $ip = ipNetwork( $myip, 24 );
        $PBWhite{$ip} = $data if $PenaltyUseNetblocks;
        $PBWhite{$myip} = $data;
      } else {
        my $data = "$t $t $status";
        $ip = ipNetwork( $myip, 24 );
        $PBWhite{$ip} = $data if $PenaltyUseNetblocks;
        $PBWhite{$myip} = $data;
      }
  }

#
sub pbWhiteDelete {
    my ( $fh, $myip, $score, $reason ) = @_;
    my $this = $Con{$fh};
    $this->{rwlok} = 0;
    return if !$DoPenalty;

    my $t = time;
    my $ip = ipNetwork( $myip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    if ( exists $PBWhite{$ip} ) {
        delete $PBWhite{$ip};
        delete $PBWhite{$myip};
      }
  }

#
sub RBLCacheAdd {
    my ( $ip, $status, $rbllists) = @_;
    my $t = time;
    my ( $sec, $min, $hour, $mday, $mon, $year ) = localtime(time);
    $mon++;
    $year -= 100;
    my $mm = sprintf( "%02d-%02d-%02d/%02d:%02d", $year, $mon, $mday, $hour, $min );
    my $data = "$t $mm $status $rbllists";
    $RBLCache{$ip} = $data;
  }

#
sub RBLCacheDelete {
    return if !$RBLCacheExp;
    my $ip = shift;
    return unless ($RBLCacheObject);
    delete $RBLCache{$ip};
  }

#
sub RBLCacheFind {
    my $ip = shift;
	my $t = time;
	my $ct;
    my $datetime;
    my $status;
    my $sp1;
    my $sp2;
    return if !$RBLCacheExp;

    return unless ($RBLCacheObject);
    if ( exists $RBLCache{$ip} ) {
    		( $ct, $datetime, $status, $sp1, $sp2 ) = split( " ", $RBLCache{$ip} );
    		
            if (($status != 1 && $status != 2) || $t - $ct >= $RBLCacheExp * 3600 ) {
            delete $RBLCache{$ip};
            return 0;
          }
        return $status;
      }
    return 0;
  }

#
sub URIBLCacheAdd {
    my ( $mydomain, $status, $mylisted ) = @_;
    return 0 if !$URIBLCacheExp;

    my $t    = time;
    my $data = "$t $status $mylisted";
    $URIBLCache{$mydomain} = $data;
  }

#
sub URIBLCacheFind {
    my ( $mydomain, $mystatus ) = @_;
    my $t = time;
    return 0 if !$URIBLCacheExp;
    return 0 unless ($URIBLCacheObject);
    if ( exists $URIBLCache{$mydomain} ) {
        my ( $ct, $status ) = split( " ", $URIBLCache{$mydomain} );
        if ( $t - $ct >= $URIBLCacheExp * 3600) {
            delete $URIBLCache{$mydomain};
            return 0;
          }
        return $status;
      }
    return 0;
  }

#
sub PTRCacheAdd {
    return 0 if !$PTRCacheInterval;
    my ( $myip, $status ) = @_;
    my $t    = time;
    my $data = "$t $status";
    $PTRCache{$myip} = $data;
  }

#
sub PTRCacheFind {
    my ( $myip, $mystatus ) = @_;
    return 0 if !$PTRCacheInterval;
    return 0 unless ($PTRCacheObject);
    if ( exists $PTRCache{$myip} ) {
        my ( $ct, $status ) = split( " ", $PTRCache{$myip} );
        return $status;
      }
    return 0;
  }

#
sub RWLCacheAdd {
    return 0 if !$RWLCacheExp;
    my ( $myip, $status ) = @_;
    my $t    = time;
    my $data = "$t $status";
    $RWLCache{$myip} = $data;
  }

#
sub RWLCacheFind {
    my ( $myip, $mystatus ) = @_;
    return 0 if !$RWLCacheExp;
    my $t = time;
    return 0 unless ($RWLCacheObject);
    if ( exists $RWLCache{$myip} ) {
        my ( $ct, $status ) = split( " ", $RWLCache{$myip} );
        if ( $t - $ct >= $RWLCacheExp * 3600) {
            delete $RWLCache{$myip};
            return 0;
          }
        return $status;
      }
    return 0;
  }

#

sub MXACacheAdd {
	return 0 if !$MXACacheInterval;
	return 0 unless ($MXACacheObject);

	my ( $myip, $mxrecord, $arecord ) = @_;
	my $t    = time;
	my $data = "$t $mxrecord $arecord";
	$MXACache{$myip} = $data;
}

sub MXACacheFind {
	return 0 if !$MXACacheInterval;
	return 0 unless ($MXACacheObject);

	my ($myip) = @_;
	if ( exists $MXACache{$myip} ) {
		return split( " ", $MXACache{$myip}, 3 );
	}
	return 0;
}

#
sub SPFCacheAdd {
    return 0 if !$SPFCacheInterval;
    return 0 unless ($SPFCacheObject);

    my ( $myip, $result, $domain, $helo ) = @_;
    my $t    = time;
    my $data = lc "$t $result $domain $helo";
    $SPFCache{$myip} = $data;
  }

sub SPFCacheFind {
    return 0 if !$SPFCacheInterval;
    return 0 unless ($SPFCacheObject);

    my $myip = shift;
    if ( exists $SPFCache{$myip} ) {
        return split( " ", lc $SPFCache{$myip} );
      }
    return 0;
  }

#
sub SBCacheAdd {
    return 0 if !$SBCacheInterval;
    my ( $myip, $status, $country ) = @_;
    my $t    = time;
    my $data = "$t $status $country";
    $SBCache{$myip} = $data;
    return $status;
  }

#
sub SBCacheFind {
    my ( $myip, $mystatus ) = @_;
    return 0 if !$SBCacheInterval;
    return 0 unless ($SBCacheObject);
    if ( exists $SBCache{$myip} ) {
        my ( $ct, $status, $country ) = split( " ", $SBCache{$myip} );
        if ($mystatus) {
            return $status;
          }
        return $country;
      }
    return 0;
  }

sub TestMessageScore {

    my $fh   = shift;
    my $this = $Con{$fh};

    return 1
      if ( $DoPenaltyMessage
        && $PenaltyMessageBlock
        && $this->{messagescore} >= $PenaltyMessageBlock );

    return 0;
  }

sub TestLowMessageScore {

    my $fh   = shift;
    my $this = $Con{$fh};

    return 1
      if ( $DoPenaltyMessage
        && $PenaltyMessageTag
        && $PenaltyMessageBlock
        && $this->{messagescore} >= $PenaltyMessageTag
        && $this->{messagescore} < $PenaltyMessageBlock );

    return 0;
  }

#
sub MessageScore {
    my ( $fh, $done ) = @_;
    my $this = $Con{$fh};
    return 1 if $this->{relayok};
    return 1 if $this->{whitelisted};
    return 1 if $this->{noprocessing};
    return 1 if $this->{spamfound};
    return 1 if $this->{messagescoredone};
    $this->{messagescoredone} = 1;
    return if !$DoPenaltyMessage;
    return if !$PenaltyMessageBlock;
    $this->{messagereason} = "MessageScore $this->{messagescore}, limit $PenaltyMessageBlock";
    my $slok   = $this->{allLovePBSpam} == 1;
    
    my $testmode =  $msTestMode || $allTestMode;
    $testmode = $slok = 0 if allSH( $this->{rcpt}, 'pbSpamHaters' );
    my $er     = $SpamError;
    my $isdone = 0;
    $er = $PenaltyError if $PenaltyError;
    $this->{prepend} = "[MessageLimit]";
    $this->{prepend} = "[MessageLimit]"."[monitoring]" if $DoPenaltyMessage == 2;

    delayWhiteExpire($fh);
    mlog( $fh, "monitoring ($this->{messagereason})" )
      if $DoPenaltyMessage == 2;
    $Stats{msgscoring}++ if $DoPenaltyMessage == 1 || $DoPenaltyMessage == 4;
    thisIsSpam( $fh, $this->{messagereason}, $spamMSLog, $er, $msTestMode || $DoPenaltyMessage == 4, $slok, ( $slok || $done ) )
      if $DoPenaltyMessage == 1;
  }

# reject the email
sub seterror {
    my ( $fh, $e, $done ) = @_;
    d(28);
    
    my $this = $Con{$fh};
    $done = 1 if $this->{relayok} || $this->{ispip};
    $this->{error} = $e;
    if ($done) {
        error( $fh, ".\r\n" );
      } else {
        $this->{getline} = \&error;
        $this->{header}  = '';        # free up some memory
      }

    # detatch the friend -- closing connection to server & disregarding message
    done2( $this->{friend} );
    $this->{friend} = undef;
  }

# ignore what's sent & give reason at the end.
sub error {
    my ( $fh, $l ) = @_;
    d(29);
    my $this = $Con{$fh};
    if ( $l =~ /^\.[\r\n]*$/
        || defined( $this->{bdata} ) && $this->{bdata} <= 0 ) {

        $this->{error} = "250 OK"
          if $this->{error} =~ /^5[0-9][0-9]/
              && ( $send250OK || ( $this->{ispip} && $send250OKISP ) );

        mlog( $fh, "[SMTP Error] $this->{error}", 1, 1 )
          if $replyLogging
              && $this->{error} !~ /250 OK/;
        print $fh $this->{error} . "\r\n";
        done2($fh);
      }
  }

# filter off the 250 OK noop response and go to reply
sub skipok {
    d(291);
    my ( $fh, $l ) = @_;
    if ( $l =~ /^250/ ) {
        $Con{$fh}->{getline} = \&reply;
      } else {
        reply(@_);
      }
  }

# messages from the server get relayed to the client
sub reply {
    my ( $fh, $l ) = @_;
    d(30);
    my $this = $Con{$fh};
    return unless $this;
    my $cli = $this->{friend};
    return unless $cli;
    $Con{$cli}->{inerror} = $l =~ /^5[05][0-9]/;

    if ( $l =~ /250-.*(CHUNKING|PIPELINING|XEXCH50|STARTTLS)/i ) {
        return;
      } elsif ( $l =~ /250 .*(CHUNKING|PIPELINING|XEXCH50|STARTTLS)/i ) {
        sendque( $cli, "250 NOOP\r\n" );
        return;

        # we'll filter off the chunking directive to avoid BDAT problems.
        # we'll filter off the XEXCH50 service, as it only causes troubles
        # we'll filter off the STARTTLS directive to avoid TLS problems.
        d("$l");

      } elsif ( $l =~ /^220/ ) {
        sendque( $fh, $this->{noop} ) if $this->{noop};
        delete $this->{noop};
      } elsif ( $l =~ /^235/ ) {

        # check for authentication response
        $Con{$cli}->{relayok} = 1;
        d("$Con{$cli}->{ip}: authenticated");
        mlog( $cli, "authenticated" ) if $ValidateUserLog == 2;
      } elsif ( $l =~ /^354/ ) {
        d(301);
      } elsif ( $l =~ /^50[0-9]/ ) {
        if ( $Con{$cli}->{skipbytes} ) {
            d("Resetting skipbytes");
            $Con{$cli}->{skipbytes} = 0;    # if we got a negative response from XEXCH50 then don't skip anything
          }
        if ( $this->{serverErrors}++ > $MaxErrors ) {
            $this->{prepend} = "[MaxErrors]";
            mlog( $fh, "max errors ($MaxErrors) exceeded -- dropping connection" );
            $Stats{msgMaxErrors}++;
            done($fh);
            return;
          }
      }

    # email report/list interface sends messages itself
    return
      if ( defined( $Con{$cli}->{reporttype} )
        && $Con{$cli}->{reporttype} >= 0 );
    sendque( $cli, $l );
  }
#####################################################################################
#                Email Interface
# this mail isn't really a mail -- it's a spam/ham report
#####################################################################################
sub SpamReport {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    if ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{bdata} = $1;
          } else {
            delete $this->{bdata};
          }
        $this->{getline} = \&SpamReportBody;
        my $report = ( $this->{reporttype} == 0 ) ? "spam" : "ham";
        sendque( $fh, "354 OK Send $report body\r\n" );
        return;
      } elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
        return;
      } elsif ( $l =~ /^ *QUIT/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "QUIT\r\n" );
        return;
      } elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
        sendque( $fh, "504 Need to authenticate first\r\n" );
        return;
      }
    sendque( $fh, "250 OK\r\n" );
  }

# we're getting the body of a spam/ham report
sub SpamReportBody {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    $Con{$fh}->{header} .= $l
      if length( $Con{$fh}->{header} ) < $MaxBytesReports;
    if ( $l =~ /^\.[\r\n]/ || defined( $this->{bdata} ) && $this->{bdata} <= 0 ) {

        # we're done -- write the file & clean up
        my $this = $Con{$fh};
        my $sub = SpamReportExec( $this->{header}, ( $this->{reporttype} == 0 ) ? $correctedspam : $correctednotspam );
        $this->{header} = '';
        my $file =
          ( $this->{reporttype} == 0 )
          ? "reports/spamreport.txt"
          : "reports/notspamreport.txt";

        ReturnMail( $this->{mailfrom}, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n" )
          if ( $EmailErrorsReply == 1 || $EmailErrorsReply == 3 );
        ReturnMail( $EmailErrorsTo, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n", $this->{mailfrom} )
          if ( $EmailErrorsTo
            && ( $EmailErrorsReply == 2 || $EmailErrorsReply == 3 ) );

        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
      }
  }

sub SpamReportSubject {
    my $bod = shift;

    my ($sub) = $bod =~ /Subject: (.*)/i;
    $sub =~ s/^.*\]\s//gi;
    $sub =~ s/^fwd.\s//gi;
    $sub =~ s/^fw.\s//gi;
    $sub =~ s/^aw.\s//gi;
    $sub =~ s/^re.\s//gi;
    $sub = decodeMimeWords($sub);

    # remove the spam subject header addition if present
    my $spamsub = $spamSubject;
    if ($spamsub) {
        $spamsub =~ s/(\W)/\\$1/g;
        $sub     =~ s/$spamsub//gi;
      }
    $sub =~ s/\r//;
    return $sub;
  }

sub SpamReportExec {
    my ( $bod, $path ) = @_;
    my $header;
    my ($sub) = $bod =~ /Subject: (.*)/i;
    $sub =~ s/^.*\]\s//gi;
    $sub =~ s/^fwd.\s//gi;
    $sub =~ s/^fw.\s//gi;
    $sub =~ s/^aw.\s//gi;
    $sub =~ s/^re.\s//gi;
    $sub = decodeMimeWords($sub);

    # remove the spam subject header addition if present
    my $spamsub = $spamSubject;
    if ($spamsub) {
        $spamsub =~ s/(\W)/\\$1/g;
        $sub     =~ s/$spamsub//gi;
      }
    $sub =~ s/\r//;

    $header = "Subject: " . $sub . "\n" if $sub;
    $sub =~ y/a-zA-Z0-9/_/cs;
    $header .= $1 . "\n"
      if $bod =~ /(Received: from.*?\(\[[0-9\.]+.*?helo=.*\))/i;

    $header .= $1 if $bod =~ /(X-Assp-ID: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Tag: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Envelope-From: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Intended-For: .*)/i;

    $bod =~ s/^.*?\n\r?\n\s*//s;

    $bod =~ s/X-Assp-Spam-Prob: .*\n//gi;
    if ( $bod =~ /\nReceived: / ) {
        $bod =~ s/^.*?\nReceived: /Received: /s;
      } else {
        $bod =~ s/^.*?\n((\w[^\n]*\n)*Subject:)/$1/si;
        $bod =~ s/\n> /\n/g;
      }
    $bod = $header . $bod;

    #$sub=~y/a-zA-Z0-9/_/cs;

    my $f = int( rand() * 3 );

    open( F, ">$base/$path/$sub - $f.rpt" );
    binmode F;
    print F $bod;
    close F;
    $sub;
  }

# we're receiving an email to manipulate addresses in the whitelist/redlist
sub ListReport {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    if ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{bdata} = $1;
          } else {
            delete $this->{bdata};
          }
        sendque( $this->{friend}, "RSET\r\n" );    # make sure to reset the pending email
        $this->{getline} = \&ListReportBody;
        my $list;
        $list = ( ( $this->{reporttype} & 4 ) == 0 ) ? "whitelist" : "redlist"
          if !$EmailErrorsModifyWhite;
        $list = "spam" if $EmailErrorsModifyWhite && $this->{reporttype} == 0;
        $list = "ham"  if $EmailErrorsModifyWhite && $this->{reporttype} == 1;
        sendque( $fh, "354 OK Send $list body\r\n" );
        return;
      } elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
        return;
      } elsif ( $l =~ /^ *QUIT/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "QUIT\r\n" );
        return;
      } elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
        sendque( $fh, "504 Need to authenticate first\r\n" );
        return;
      } else {

        # more recipients ?
        while ( $l =~ /($EmailAdrRe\@$EmailDomainRe)/og ) {
            next if $1 == $this->{mailfrom};
            ListReportExec( $1, $this );
            $this->{rcpt} .= "$1 ";
          }

      }
    sendque( $fh, "250 OK\r\n" );
  }

# we're receiving an email to send help instructions
sub HelpReport {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    if ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{bdata} = $1;
          } else {
            delete $this->{bdata};
          }
        sendque( $this->{friend}, "RSET\r\n" );    # make sure to reset the pending email
        $this->{getline} = \&ListReportBody;

        sendque( $fh, "354 OK Send help body\r\n" );
        return;
      } elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
        return;
      } elsif ( $l =~ /^ *QUIT/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "QUIT\r\n" );
        return;
      } elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
        sendque( $fh, "504 Need to authenticate first\r\n" );
        return;
      } else {

        # more recipients ?
      }
    sendque( $fh, "250 OK\r\n" );
  }

# we're receiving an email to analyze the email
sub AnalyzeReport {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    if ( $l =~ /^ *DATA/i || $l =~ /^ *BDAT (\d+)/i ) {
        if ($1) {
            $this->{bdata} = $1;
          } else {
            delete $this->{bdata};
          }
        sendque( $this->{friend}, "RSET\r\n" );    # make sure to reset the pending email
        $this->{getline} = \&AnalyzeReportBody;

        sendque( $fh, "354 OK Send analyze body\r\n" );
        return;
      } elsif ( $l =~ /^ *RSET/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
        return;
      } elsif ( $l =~ /^ *QUIT/i ) {
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "QUIT\r\n" );
        return;
      } elsif ( $l =~ /^ *XEXCH50 +(\d+)/i ) {
        d("XEXCH50 b=$1");
        sendque( $fh, "504 Need to authenticate first\r\n" );
        return;
      } else {

      }
    sendque( $fh, "250 OK\r\n" );
  }

# we're getting the body of an analyze report
sub AnalyzeReportBody {
    my ( $fh, $l ) = @_;

    $Con{$fh}->{header} .= $l
      if length( $Con{$fh}->{header} ) < $MaxBytesReports;
    my $this = $Con{$fh};
    if ( $l =~ /^\.[\r\n]/ || defined( $this->{bdata} ) && $this->{bdata} <= 0 ) {

        # we're done -- write the file & clean up
        my $sub = AnalyzeText( $fh, $this->{header} );

        # mail analyze report
        ReturnMail( $this->{mailfrom}, "$base/reports/analyzereport.txt", $sub, "$this->{rcpt}\n\n$this->{report}\n" )
          if ( $EmailAnalyzeReply == 1 || $EmailAnalyzeReply == 3 );

        ReturnMail(
            $EmailAnalyzeTo, "$base/reports/analyzereport.txt",
            $sub, "$this->{rcpt}\n\n$this->{report}\n",
            $this->{mailfrom}
          )
          if ( $EmailAnalyzeTo
            && ( $EmailAnalyzeReply == 2 || $EmailAnalyzeReply == 3 ) );

        delete $this->{report};
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );

      }
  }

# we're getting the body of a whitelist/redlist report
sub ListReportBody {
    my ( $fh, $l ) = @_;
    my $sub;

    $Con{$fh}->{header} .= $l
      if length( $Con{$fh}->{header} ) < $MaxBytesReports;
    my $this = $Con{$fh};
    if ( $l =~ /^\.[\r\n]/ || defined( $this->{bdata} ) && $this->{bdata} <= 0 ) {

        # we're done -- write the file & clean up

        my $file = ( $this->{reporttype} == 2 ) ? "reports/whitereport.txt" :

            ( $this->{reporttype} == 1 ) ? "reports/notspamreport.txt"
          : ( $this->{reporttype} == 0 ) ? "reports/spamreport.txt"
          : ( $this->{reporttype} == 3 ) ? "reports/whiteremovereport.txt"
          : ( $this->{reporttype} == 4 ) ? "reports/redreport.txt"
          :

          ( $this->{reporttype} == 7 )
          ? "reports/helpreport.txt"
          : "reports/redremovereport.txt";

        if ( $DoAdditionalAnalyze
            && ( $this->{reporttype} == 0 || $this->{reporttype} == 1 ) ) {
            $sub = AnalyzeText( $fh, $this->{header} );

            # mail analyze report
            ReturnMail( $this->{mailfrom}, "$base/reports/analyzereport.txt", $sub, "\n$this->{report}\n" )
              if ( $DoAdditionalAnalyze == 1 || $DoAdditionalAnalyze == 3 );

            ReturnMail( $EmailAnalyzeTo, "$base/reports/analyzereport.txt",
                $sub, "\n$this->{report}\n", $this->{mailfrom} )
              if ( $EmailAnalyzeTo
                && ( $DoAdditionalAnalyze == 2 || $DoAdditionalAnalyze == 3 ) );
          }

        $sub = SpamReportExec( $this->{header}, $correctedspam )
          if $this->{reporttype} == 0;
        $sub = SpamReportExec( $this->{header}, $correctednotspam )
          if $this->{reporttype} == 1;

        # mail summary report
        if ( $this->{reporttype} == 3 || $this->{reporttype} == 2 ) {

            ReturnMail( $this->{mailfrom}, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n" )
              if ( $EmailWhitelistReply == 1 || $EmailWhitelistReply == 3 );

            ReturnMail( $EmailWhitelistTo, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n", $this->{mailfrom} )
              if ( $EmailWhitelistTo
                && ( $EmailWhitelistReply == 2 || $EmailWhitelistReply == 3 ) );
          } elsif ( $this->{reporttype} == 7 ) {
            ReturnMail( $this->{mailfrom}, "$base/$file", 'ASSP-Help', "$this->{rcpt}\n\n$this->{report}\n" );
          } elsif ( $this->{reporttype} == 4 || $this->{reporttype} == 5 ) {
            ReturnMail( $this->{mailfrom}, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n" )
              if ( $EmailRedlistReply == 1 || $EmailRedlistReply == 3 );

            ReturnMail( $EmailRedlistTo, "$base/$file", '', "$this->{rcpt}\n\n$this->{report}\n", $this->{mailfrom} )
              if ( $EmailRedlistTo
                && ( $EmailRedlistReply == 2 || $EmailRedlistReply == 3 ) );
          } elsif ( $this->{reporttype} == 0 || $this->{reporttype} == 1 ) {
            ReturnMail( $this->{mailfrom}, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n" )
              if ( $EmailErrorsReply == 1 || $EmailErrorsReply == 3 );
            ReturnMail( $EmailErrorsTo, "$base/$file", $sub, "$this->{rcpt}\n\n$this->{report}\n", $this->{mailfrom} )
              if ( $EmailErrorsTo
                && ( $EmailErrorsReply == 2 || $EmailErrorsReply == 3 ) );
          }
        delete $this->{report};
        stateReset($fh);
        $this->{getline} = \&getline;
        sendque( $this->{friend}, "RSET\r\n" );
      } elsif ( $l =~ /message-id:/i || $l =~ /from:.*?$this->{mailfrom}/i ) {

        # ignore
      } else {
        while ( $l =~ /($EmailAdrRe\@$EmailDomainRe)/go ) {
            ListReportExec( $1, $this );
          }

      }
  }

sub ListReportExec {
    my ( $a, $this ) = @_;
    my $ea =
        ( $this->{reporttype} == 0 ) ? "$EmailSpam\@"
      : ( $this->{reporttype} == 1 ) ? "$EmailHam\@"
      : ( $this->{reporttype} == 2 ) ? "$EmailWhitelistAdd\@"
      : ( $this->{reporttype} == 3 ) ? "$EmailWhitelistRemove\@"
      : ( $this->{reporttype} == 4 ) ? "$EmailRedlistAdd\@"
      : ( $this->{reporttype} == 7 ) ? "$EmailHelp\@"
      :                                "$EmailRedlistRemove\@";
    return unless $a =~ /($EmailAdrRe\@)($EmailDomainRe)/;
    return if $a =~ /\=/ && !$EmailAllowEqual;
    $a =~ s/^\'//;
    $a =~ s/^title.3D//;
    $a =~ /^(.*)@/;
    return if !$1;
    return if $a =~ /$EmailRedlistAdd/i;
    return if $a =~ /$EmailRedlistRemove/i;
    return if $a =~ /$EmailWhitelistAdd/i;
    return if $a =~ /$EmailWhitelistRemove/i;
    return if $a =~ /\.(jpg|gif)\@/;
    return if $a =~ /\*\*/;
    return if lc $a eq lc $this->{mailfrom};
    return if lc $1 eq lc $ea && localmail($a);
    return if $this->{reporttype} == 7;
    return if $a =~ ( '(' . $ESOKRE . ')' );
    return if $a =~ /$EmailFrom/i;

    my $t       = time;
    my $redlist = "Redlist";
    my $list    = ( ( $this->{reporttype} & 4 ) == 0 ) ? "Whitelist" : "Redlist";
    if (   $this->{reporttype} == 3
        || $this->{reporttype} == 0
        || $this->{reporttype} == 5 ) {

        # deletion

        if ( $list->{ lc $a } ) {
            delete $list->{ lc $a };
            $this->{report} .= "$a: deleted from " . lc $list . "\n";

            mlog( 0, "email: " . lc $list . " deletion: $a" );

            # we're adding to redlist
            if ( ( $this->{reporttype} == 2 || $this->{reporttype} == 1 || $this->{reporttype} == 4 )
                && $EmailWhiteRemovalToRed ) {
                if ( $redlist->{ lc $a } ) {
                    $redlist->{ lc $a } = $t;
                    if ( eval( $this->{report} !~ "$a: added to|$a: already on" ) ) {
                        $this->{report} .= "$a: already on " . lc $redlist . "\n";
                      }
                  } else {
                    $redlist->{ lc $a } = $t;
                    $this->{report} .= "$a: added to " . lc $redlist . "\n";
                    mlog( 0, "email: " . lc $redlist . " addition: $a" );
                  }
              }

            # ###################

          } else {
            if ( ( $this->{reporttype} == 3 || $this->{reporttype} == 0 || $this->{reporttype} == 5 ) ) {
              } else {
                $this->{report} .= "$a: not on " . lc $list . "\n";

                # mlog($fh,"email ".lc $list." miss on deletion: $a");
              }
          }

        my $mf           = $a;
        my $mfd          = $1 if $mf =~ /\@(.*)/;
        my $mfdd         = $1 if $mf =~ /(\@.*)/;
        my $alldd        = "$wildcardUser$mfdd";
        my $defaultalldd = "*$mfdd";

        if ( $noProcessing && matchSL( $mf, 'noProcessing' ) ) {
            if ( $this->{report} !~ "$mf is on NoProcessing-List" ) {
                $this->{report} .= "\n$mf is on NoProcessing-List\n\n";
                PrintAdminInfo("email $mf is on NoProcessing-List");
                deleteNP( $1, "email from $this->{mailfrom}" );
              }
          }

        if ($npRe) {
            if ( $mf =~ $npReRE ) {
                $this->{report} .= "\n$mf is in NoProcessing-Regex\n\n";

              }
          }
        
        if ( $noProcessingDomains && $mf =~ ( '(' . $NPDRE . ')' ) ) {
        	eval {
            if ( $this->{report} !~ "$1 is on NoProcessingDomain-List" ) {
                $this->{report} .= "\n$1 is on NoProcessingDomain-List\n\n";

              }};
          }
        if ( $Whitelist{$alldd} ) {
            $this->{report} .= "\n$alldd is on Whitelist\n\n";

          }
        if ( $Whitelist{$defaultalldd} ) {
            $this->{report} .= "\n$defaultalldd is on Whitelist\n\n";

          }
        if ( $whiteListedDomains && $mf =~ ( '(' . $WLDRE . ')' ) ) {
			eval {
            if ( $this->{report} !~ "$1 is on Whitedomain-List" ) {
                $this->{report} .= "\n$1 is on Whitedomain-List\n\n";

            }};
          }
      } else {

        # addition
        my $aa=$a;
        $aa =~ s/([\.\[\]\-\(\)\+\\])/\\$1/g;
        if ( $list->{ lc $a } ) {
            $list->{ lc $a } = $t;
			eval {
            if ( $this->{report} !~ "$aa: already on|$aa: added to" ) {
                $this->{report} .= "$a: already on " . lc $list . "\n";
              }
            };

            # mlog($fh,"email ".lc $list." renewal: $a");
          } elsif (
            localmail($a)
            && (   $this->{reporttype} == 2
                || $this->{reporttype} == 1
                || $this->{reporttype} == 4 )
          ) {
          } elsif ( $list eq 'Whitelist' && $Redlist{ lc $a } ) {
          	eval {
            if ( $this->{report} !~ "$aa: cannot add redlisted users to whitelist" ) {
                $this->{report} .= "$a: cannot add redlisted users to whitelist\n";
                mlog( 0, "email whitelist addition denied: $a on redlist", 1 );
              }
            };
          } else {
            $list->{ lc $a } = $t;
            eval {
            if ( $this->{report} !~ "$aa: already on|$aa: added to" ) {
                $this->{report} .= "$a: added to " . lc $list . "\n";
              }
            };


            mlog( 0, "email: " . lc $list . " addition: $a", 1 );
          }
      }
  }

sub ReturnMail {
    return if $NoHaiku;
    my ( $from, $file, $sub, $bod, $user ) = @_;
    my $destination;
    my $localip;
    my $s;
    if ( $smtpReportServer ne '' ) {
        $destination = $smtpReportServer;
      } else {
        $destination = $smtpDestination;
      }

    $AVa = 0;
    foreach $destinationA ( split( /\|/, $destination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {
            $localip      = '127.0.0.1';
            $destinationA = $localip . ':' . $2;
          }
        if ( $AVa < 1 ) {
            $s = new IO::Socket::INET(
                Proto    => 'tcp',
                PeerAddr => $destinationA,
                Timeout  => 2
            );
            if ($s) {
                $AVa         = 1;
                $destination = $destinationA;
              } else {
                mlog( '', "*** $destinationA didn't work, trying others..." )
                  if $SessionLog;
              }
          }
      }
    if ( !$s ) {
        mlog( '', "couldn't create server socket to $destination -- aborting ReturnMail connection" );
        return;
      }
    addfh( $s, \&RMhelo );
    my $this = $Con{$s};
    $this->{to}   = $from;
    $this->{from} = $EmailFrom;
    open( F, "<$file" ) || mlog( 0, "couldn't open '$file' for mail report" );
    local $/ = "\n";
    my $subject = <F>;
    $subject =~ s/\s*(.*)\s*/$1 $sub/;
    $this->{subject} = $subject;
    undef $/;
    $this->{body} = "Report from: $user\n" if $user;
    $this->{body} .= <F> . $bod;
    close F;
    $this->{body}    =~ s/\r?\n/\r\n/g;
    $this->{subject} =~ s/\r?\n?//g;
    my $spamsub = $spamSubject;

    if ($spamsub) {
        $spamsub =~ s/(\W)/\\$1/g;
        $this->{subject} =~ s/$spamsub *//gi;
      }

  }

sub AdminReportMail {

    my ( $sub, $bod, $to ) = @_;
    return if !$to;
    my $destination;
    my $localip;
    my $s;
    if ( $smtpReportServer ne '' ) {
        $destination = $smtpReportServer;
      } else {
        $destination = $smtpDestination;
      }

    $AVa = 0;
    foreach $destinationA ( split( /\|/, $destination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {

            $localip = '127.0.0.1';

            $destinationA = $localip . ':' . $2;
          }
        if ( $AVa < 1 ) {
            $s = new IO::Socket::INET(
                Proto    => 'tcp',
                PeerAddr => $destinationA,
                Timeout  => 2
            );
            if ($s) {
                $AVa         = 1;
                $destination = $destinationA;
              } else {
                mlog( '', "*** $destinationA didn't work, trying others..." )
                  if $SessionLog;
              }
          }

      }
    if ( !$s ) {
        mlog( '', "couldn't create server socket to $destination -- aborting  connection adminreport " );
        return;
      }
    addfh( $s, \&RMhelo );
    my $this = $Con{$s};
    $this->{to}   = $to;
    $this->{from} = $EmailFrom;

    local $/ = "\n";

    $this->{subject} = $sub;
    $this->{subject} =~ s/\r?\n?//g;
    undef $/;

    $this->{body} = $bod;

  }

sub RMhelo {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "helo Expected 220, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *220 / ) {
        sendque( $fh, "HELO $myName\r\n" );
        $Con{$fh}->{getline} = \&RMfrom;
      }
  }

sub RMfrom {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "from Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "MAIL FROM: " . ( $Con{$fh}->{from} =~ /(<[^<>]+>)/ ? $1 : $Con{$fh}->{from} ) . "\r\n" );
        $Con{$fh}->{getline} = \&RMrcpt;
      }
  }

sub RMrcpt {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "rcpt Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "RCPT TO: <$Con{$fh}->{to}>\r\n" );
        $Con{$fh}->{getline} = \&RMdata;
      }
  }

sub RMdata {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "data Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "DATA\r\n" );
        $Con{$fh}->{getline} = \&RMdata2;
      }
  }

sub RMdata2 {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "data2 Expected 354, got: $l" );
      } elsif ( $l =~ /^ *354 / ) {
        my $date = $UseLocalTime ? localtime() : gmtime();
        my $tz   = $UseLocalTime ? tzStr()     : '+0000';
        $date =~ s/(\w+) +(\w+) +(\d+) +(\S+) +(\d+)/$1, $3 $2 $5 $4/;
        my $this = $Con{$fh};
        sendque( $fh, <<EOT);
From: $this->{from}\r
To: $this->{to}\r
Subject: $this->{subject}\r
X-Assp-Report: YES\r
Date: $date $tz\r
\r
$this->{body}\r
.\r
EOT
        $Con{$fh}->{getline} = \&RMdone;
      }
  }

sub RMdone {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        RMabort( $fh, "done Expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {
        done2($fh);    # close and delete
      }
  }
sub RMabort { mlog( 0, "RMabort: $_[1]" ); done2( $_[0] ); }

#####################################################################################
#####################################################################################
sub ccMail {
    my ( $fh, $from, $to, $bod, $rcpt ) = @_;
    return if !$sendHamInbound && !$sendHamOutbound;
    my $this = $Con{$fh};
    my $localip;
    my $s;
    if (   $sendHamOutbound
        && $this->{relayok}
        && ( !$ccHamFilter || allSL( $rcpt, $from, 'ccHamFilter' ) )
        && !allSL( $rcpt, $from, 'ccnHamFilter' ) ) {
        $to = $sendHamOutbound;
      } elsif ( $sendHamInbound
        && !$this->{relayok}
        && ( !$ccHamFilter || allSL( $rcpt, $from, 'ccHamFilter' ) )
        && !allSL( $rcpt, $from, 'ccnHamFilter' ) ) {
        $to = $sendHamInbound;

      } else {
        return;
      }
    my $sub = substr( $bod, 0, 50 );

    #return if($sub!~/Received/i);

    $to =~ /($EmailAdrRe)\@($EmailDomainRe)/;
    my ( $current_username, $current_domain ) = ( $1, $2 );
    my $cchamlt = $sendHamInbound;
    $cchamlt =~ s/USERNAME/$current_username/g;
    $cchamlt =~ s/DOMAIN/$current_domain/g;
    my $destination;
    if ( $sendAllHamDestination ne '' ) {
        $destination = $sendAllHamDestination;
      } elsif ( $sendAllDestination ne '' ) {
        $destination = $sendAllDestination;
      } else {
        $destination = $smtpDestination;
      }
    $AVa = 0;
    foreach $destinationA ( split( /\|/, $destination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {
            $localip      = '127.0.0.1';
            $destinationA = $localip . ':' . $2;
          }
        if ( $AVa < 1 ) {
            $s = new IO::Socket::INET(
                Proto    => 'tcp',
                PeerAddr => $destinationA,
                Timeout  => 2
            );
            if ($s) {
                $AVa         = 1;
                $destination = $destinationA;
              } else {
                mlog( '', "*** $destinationA didn't work, trying others..." )
                  if $SessionLog;
              }
          }

      }
    if ( !$s ) {
        mlog( '', "couldn't create server socket to $destination -- aborting  connection ccmail" );
        return;
      }
    addfh( $s, \&CChelo );
    my $this = $Con{$s};
    $this->{to}   = $to;
    $this->{from} = $from;

    local $/ = "\n";

    $this->{subject} = $sub;
    $this->{subject} =~ s/\r?\n?//g;
    undef $/;

    $this->{body} = $bod;
  }

sub CChelo {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "helo Expected 220, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *220 / ) {
        sendque( $fh, "HELO $myName\r\n" );
        $Con{$fh}->{getline} = \&CCfrom;
      }
  }

sub CCfrom {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "HELO send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "MAIL FROM: " . ( $Con{$fh}->{from} =~ /(<[^<>]+>)/ ? $1 : "<$Con{$fh}->{from}>" ) . "\r\n" );
        $Con{$fh}->{getline} = \&CCrcpt;
      }
  }

sub CCrcpt {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "MAIL FROM send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "RCPT TO: <$Con{$fh}->{to}>\r\n" );
        $Con{$fh}->{getline} = \&CCdata;
      }
  }

sub CCdata {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "RCPT TO send, Expected 250, got: $l (from:$Con{$fh}->{from} to:$Con{$fh}->{to})" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "DATA\r\n" );
        $Con{$fh}->{getline} = \&CCdata2;
      }
  }

sub CCdata2 {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "DATA send, Expected 354, got: $l" );
      } elsif ( $l =~ /^ *354 / ) {
        sendque( $fh, $this->{body} ) if $this->{body};
        sendque( $fh, "\r\n.\r\n" )   if ( $this->{body} !~ /[\n\r]\.[\n\r]+$/ );
        $Con{$fh}->{getline} = \&CCdone;
      }
  }

sub CCdone {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        CCabort( $fh, "\r\n.\r\n send, Expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {
        done2($fh);    # close and delete
      }
  }
sub CCabort { mlog( 0, "CCabort: $_[1]" ); done2( $_[0] ); }

#####################################################################################
#                SPAM Detection

# check if the message is spam, based on Bayesian factors in $Spamdb
#####################################################################################

sub BayesOK {
    my ( $fh, $msg, $ip ) = @_;
    my $this = $Con{$fh};
    local $b = clean($msg);

    $ip = $this->{cip} if $this->{ispip} && $this->{cip};

    
    return 0 if $this->{whitelisted};
    return 0 if $this->{noprocessing};
    return 0 if onwhitere($fh,$msg);
    return 0 if onwhitere($fh,$b);
    return 0 if !$DoBayesian;
  	

    if (
          !$this->{blackredone}
        && $DoBlackReBayesian
        && $blackRe
        && $blackReRE != ""
        && (   $msg =~ ( '(' . $blackReRE . ')' )
            || $b =~ ( '(' . $blackReRE . ')' ) )
      ) {
        mlogRe( $fh, $1, "Bayesian-Black" );
        return $SpamProb = 0 if $DoBayesian == 2;
        pbAdd( $fh, $ip, $baysValencePB, "BlackRe", 1 ) if $baysValencePB > 0;
        return $SpamProb = 0 if $DoBayesian == 3;
        return $SpamProb = 1;
      }

    if (   $this->{nobayesian}
        || $noBayesian && matchSL( $this->{mailfrom}, 'noBayesian' ) ) {
        mlog( $fh, "Bayesian Check skipped for $this->{mailfrom} " ) if $BayesianLog == 2;
        return $SpamProb = 0;
      }
    if (
          !$this->{spamlover}
        && $baysSpamLoversRe
        && $baysSpamLoversReRE != ""
        && (   $msg =~ ( '(' . $baysSpamLoversReRE . ')' )
            || $b =~ ( '(' . $baysSpamLoversReRE . ')' ) )
      ) {
        mlogRe( $fh, $1, "Bayesian-SpamLover" );
        $this->{spamlover} = 1;
      }

    my $tlit = "";
    $tlit = "[monitoring]" if $DoBayesian == 2;
    $tlit = "[scoring]"    if $DoBayesian == 3;
    $this->{prepend} = "[Bayesian]";

    #$this->{prepend} .= "[$tlit]" if $DoBayesian >= 2;

    my $myip = ipNetwork( $ip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    $ip = $_[1];
    d(31);
    my $ip3 = $ip;
    $ip3 =~ s/(\d+\.\d+\.\d+).*/$1/;
    my ( $v, $lt, $t, %seen );
    my @t;
    if ( defined( $Dnsbl{$ip} ) || defined( $Dnsbl{$ip3} ) ) {
        mlog( '', "$ip dnsbl hit" );
        push( @t, 0.97 );
        push( @t, 0.97 );
      }
    $myip = ipNetwork( $ip, ( $PenaltyUseNetblocks ? 24 : 32 ) );
    if ( exists $PBBlack{$myip} ) {
        push( @t, 0.97 );
      }
    if ( $this->{messagescore} > 0 ) {
        push( @t, 0.97 );
      }
    if ( $this->{messagescore} >= 25 ) {
        push( @t, 0.97 );
      }
    if ( $this->{rwlok} ) {
        push( @t, 0.03 );

      }
    if ( $this->{rwlok} == 2 ) {
        push( @t, 0.03 );
      }
    if ( $this->{rwlok} == 3 ) {
        push( @t, 0.03 );
        push( @t, 0.03 );
      }
    push( @t, 0.97 ) if $this->{obfuscatedip};
    push( @t, 0.97 ) if $this->{obfuscateduri};
    push( @t, 0.97 ) if $this->{maximumuniqueuri};
    push( @t, 0.97 ) if $this->{maximumuri};
    if ( $this->{spfok} ) {
        push( @t, 0.03 );
      }
    if ( $this->{rblneutral} ) {
        push( @t, 0.97 );
      }
    if ( $this->{mycountry} == 1 ) {
        push( @t, 0.03 );
      }

    if ($griplist) {
        if ( $ispip && !$this->{cip} && matchIP( $ip, 'ispip', 0, 1 ) ) {
            if ($ispgreyvalue) {
                $v = $ispgreyvalue;
              } else {
                $v = $Griplist{x};
              }
          } else {
            $v = $Griplist{$ip3} || $Griplist{x};
          }
        d("gl=$v <$Griplist{$ip3}>");
        push( @t, $v, $v ) if $v;
      }
    while ( $b =~ /([-\$A-Za-z0-9\'\.!\240-\377]+)/g ) {
        next if length($1) > 20;
        $lt = $t;
        $t  = lc $1;
        $t =~ s/[,.']+$//;
        $t =~ s/!!!+/!!/g;
        $t =~ s/--+/-/g;
        my $j = "$lt $t";
        next if $seen{$j}++ > 1;    # first two occurances are significant
        push( @t, $v ) if ( $v = $Spamdb{$j} );
      }
    @t = sort { abs( $b - .5 ) <=> abs( $a - .5 ) } @t;
    @t = @t[ 0 .. 30 ];
    my $p1 = 1;
    my $p2 = 1;
    foreach my $p (@t) {
        if ($p) { $p1 *= $p; $p2 *= ( 1 - $p ); }
      }
    $this->{spamprob} = $p1 / ( $p1 + $p2 );

    #$this->{spamconf}=(1+$p1-$p2)/2;
    $this->{spamconf} = abs( $p1 - $p2 );
    if ( $baysConf > 0 ) {
        mlog(
            $fh,
            sprintf(
                "$tlit Bayesian Check - Prob: %.5f / Confidence: %.5f => %s.%s",
                $this->{spamprob},
                $this->{spamconf},
                $this->{spamconf} < $baysConf            ? "doubtful" : "confident",
                ( $this->{spamprob} < $baysProbability ) ? "ham"      : "spam"
            ),
            1
        ) if $BayesianLog || $DoBayesian >= 2;
        $this->{bayeslowconf} = 1
          if ( $this->{spamprob} >= $baysProbability
            && $DoBayesian == 1
            && $this->{spamconf} < $baysConf );
      } else {
        mlog(
            $fh,
            sprintf(
                "$tlit Bayesian Check - Prob: %.5f => %s",
                $this->{spamprob}, ( $this->{spamprob} < $baysProbability ) ? "ham" : "spam"
            ),
            1
        ) if $BayesianLog || $DoBayesian >= 2;
      }
    return $this->{spamprob} = 0 if $DoBayesian == 2;
    $this->{messagereason} = sprintf( "Bayesian Probability: %.4f", $this->{spamprob} );
    if ( $this->{spamprob} >= $baysProbability ) {
    		pbWhiteDelete( $fh, $this->{ip} );
        pbAdd(
            $fh,
            $this->{ip},
            ( $baysConf && $baysConfidenceHalfScore && $this->{spamconf} < $baysConf )
            ? $baysValencePB / 2
            : $baysValencePB,
            "Bayesian"
        ) if $baysValencePB > 0;
      }
    return 0
      if ( $NoTagInTestmode
        && $this->{spamprob} >= $baysProbability
        && $baysTestMode
        && $this->{spamconf} < $baysConf );
    return $this->{spamprob} = 0 if $DoBayesian == 3;
    return $this->{spamprob} < $baysProbability ? 0 : 1;
  }

# attach a header line to the message if the config option is set
sub addSpamProb {

    my ( $fh, $wl, $sp ) = @_;
    my $this           = $Con{$fh};
    my $spamprobheader = "";
    my $mscore;
    return if $NoExternalSpamProb && $this->{relayok};
    $spamprobheader = sprintf( "X-Assp-Spam-Prob: %.5f\r\n", $this->{spamprob} )
      if $this->{spamprob} > 0.00001 
      	  && $AddSpamProbHeader;
    $spamprobheader .= sprintf( "X-Assp-Bayes-Confidence: %.5f\r\n", $this->{spamconf} )
      if $AddSpamProbHeader
          && $AddConfidenceHeader
          && $baysConf
          && $this->{spamconf} > 0.00001;
    $this->{header} =~ s/^X-Assp-Spam-Prob:$HeaderValueRe//gimo;           # clear out existing X-Assp-Spam-Prob headers
    $this->{header} =~ s/^X-Assp-Bayes-Confidence:$HeaderValueRe//gimo;    # clear out existing X-Assp-Spam-Prob headers
    if ($wl) {
        $spamprobheader .= "X-Assp-Whitelisted: Yes\r\n";
        $this->{header} =~ s/^X-Assp-Whitelisted:$HeaderValueRe//gimo;   # clear out existing X-Assp-Whitelisted headers
      }
    $this->{header} =~ s/^X-Assp-Spam-Level:$HeaderValueRe//gimo;        # clear out existing X-Assp-Spam-Level headers
    my $strippedTag = $this->{prepend};
    $this->{saveprepend} = $this->{prepend};
    $strippedTag =~ s/\[//;
    $strippedTag =~ s/\]//;
    my $counter = 0;
    my $stars   = "";
    $mscore = $this->{messagescore};
    $mscore = $PenaltyMessageBlock
      if $this->{messagescore} < $PenaltyMessageBlock
          && $strippedTag
          && $strippedTag ne "[MessageLimit]";

    if ( $mscore && $AddLevelHeader ) {
        while ( $counter < int( $mscore / 5 ) ) {
            $counter++;
            $stars .= "*";
          }
        $spamprobheader .= "X-Assp-Spam-Level: $stars\r\n"
          if $sp && $this->{messagescore};
      }

    $spamprobheader .= "X-Assp-Tag: $strippedTag\r\n"
      if $sp && $this->{prepend} && $tagLogging;
    if ( defined( $this->{mailfrom} ) ) {
        $spamprobheader .= "X-Assp-Envelope-From: $this->{mailfrom}\r\n";
        $this->{header} =~
          s/^X-Assp-Envelope-From:$HeaderValueRe//gimo;    # clear out existing X-Assp-Envelope-From headers
      }
    if ($AddIntendedForHeader) {
    	my ($to) = $this->{rcpt} =~ /(\S+)/;
        $spamprobheader .= "X-Assp-Intended-For: $to\r\n";
        $this->{header} =~
          s/^X-Assp-Intended-For:$HeaderValueRe//gimo;     # clear out existing X-Assp-Envelope-From headers
      }

    # add to our header; merge later, when client sent own headers
    $this->{myheader} .= $spamprobheader;
  }

# compile the nonprocessing domains regular expression
sub setNPDRE {
    my $new = shift;
    $new ||= '^(?!)';                                      # regexp that never matches
    $new =~ s/\*/\.\*/g;
    SetRE( 'NPDRE', "($new)\$", 'i', 'NopnProcessing Domains' );
  }

# compile the whitelisted domains regular expression
sub setWLDRE {
    my $new = shift;
    $new ||= '^(?!)';                                      # regexp that never matches
    $new =~ s/\*/\.\*/g;
    SetRE( 'WLDRE', "($new)\$", 'i', 'Whitelisted Domains' );
  }

# compile the blacklisted domains regular expression
sub setBLDRE {
    my $new = shift;
    $new ||= '^(?!)';                                      # regexp that never matches
    $new =~ s/\*/\.\*/g;
    SetRE( 'BLDRE1', "($new)\$", 'i', 'Blacklisted Domains' );
    SetRE( 'BLDRE2', "($new) ",  'i', 'Blacklisted Domains' );
  }

# compile the regular expression for the list of two-level country code TLDs
sub setURIBLCCTLDSRE {
    my $s = join( '|', @_ );
    $s ||= '^(?!)';                                        # regexp that never matches
    SetRE( 'URIBLCCTLDSRE', "([^\\.]+\\.($s))\$", 'i', 'Country Code TLDs' );
  }

# compile the URIBL whitelist regular expression
sub setURIBLWLDRE {
    my $new = shift;
    $new ||= '^(?!)';                                      # regexp that never matches
    $new =~ s/\*/\.\*/g;
    SetRE( 'URIBLWLDRE', "^($new)\$", 'i', 'Whitelisted URIBL Domains' );
  }

# compile the Max IP/Domain whitelist regular expression
sub setIPDWLDRE {
    my $new = shift;
    $new ||= '^(?!)';                                      # regexp that never matches
    $new =~ s/\*/\.\*/g;
    SetRE( 'IPDWLDRE', "^($new)", 'i', 'Whitelisted IP/Domain Domains' );
  }
sub onwhitere {
    my ( $fh, $b) = @_;
    my $this = $Con{$fh};
    my $t = time;
    return if $this->{relayok};
    return if $this->{acceptall};    
    return if $this->{whitelisted};
    return if localdomains($this->{mailfrom});
    return if !$whiteRe;
    return if $b !~ ( '(' . $whiteReRE . ')' );
	$this->{whitelisted} = 1;
    
    mlogRe( $fh, $1, "Bayesian-White" );
    return if $this->{red};
    return if $NoAutoWhite;
    return if $Whitelist{$this->{mailfrom}};
    mlog( $fh, "AdminInfo: whitelist addition (whitere:'$1'): $this->{mailfrom}", 1 ) ;
    $Whitelist{ $this->{mailfrom} } = $t;
    return 1;
   }
# see if the address in the mailfrom is on the whitelist meanwhile update the whitelist if that seems appropriate
sub onwhitelist {
    my ( $fh, $header, $a ) = @_;
    d(32);
    my $this = $Con{$fh};
    $a = lc $this->{mailfrom};

    my $whitelisted = $this->{relayok};
    $Stats{locals}++ if $whitelisted;
    return $whitelisted
      unless $a
    ;  # don't add to the whitelist unless there's a valid envelope -- prevent bounced mail from adding to the whitelist
    if (  !$this->{red}
        && $redRe
        && $redReRE != ""
        && $header =~ ( '(' . $redReRE . ')' ) ) {
        mlogRe( $fh, $1, "Red" );
        
        $this->{red} = $1;
      }
    mlogRe( $fh, $a, "Redlist" ) if !$this->{red} && $Redlist{$a};
    $this->{red} = "$a in Redlist" if $Redlist{$a};

    my %senders;
    unless ($whitelisted) {
        $senders{$a} = 1;
        if ( !$NotGreedyWhitelist ) {
            while ( $header =~ /\n(from|sender|reply-to|errors-to|list-\w+):.*?($EmailAdrRe\@$EmailDomainRe)/igo ) {
                $senders{ lc $2 } = 1;
              }
          }
        foreach $a ( keys %senders ) {
            return 0 if $a && $Redlist{$a};
            next if localmail($a) || $a eq '';
            if ( $whiteListedDomains && $a =~ ( '(' . $WLDRE . ')' ) ) {
                d("wld");
                $whitelisted = 1;
                mlog( $fh, "Whitelisted Domain: $1" );
                last;
              } elsif ( $Whitelist{$a} ) {
                d("on whitelist");
                $whitelisted = 1;
                last;
              }
          }
        $this->{senders} = join( ' ', keys %senders ) . " ";    # used for finding blacklisted domains
        if ($whitelisted) {
            $Stats{whites}++;
          }

      }

    # don't add to whitelist if sender is redlisted
    return $whitelisted
      if $this->{red}
          || $WhitelistLocalOnly && !$this->{relayok}
          || $WhitelistLocalFromOnly && !localmail( $this->{mailfrom} );
    if ($whitelisted) {

        # keep the whitelist up-to-date
        my %a = %senders;
        my $t = time;
        $a{$a} = 1;
        $header =~ s/\n\s+/ /g;
        while ( $header =~ /\n(to|cc): (.*)/ig ) {
            my $a = $2;
            while ( $a =~ /($EmailAdrRe\@$EmailDomainRe)/go ) {
                $a{ lc $1 } = 1;
              }
          }
        foreach $a ( split( ' ', lc $this->{rcpt} ) ) {
            $a{$a} = 1;
          }
        foreach $a ( keys %a ) {
            next if localmail($a) || !$a;
            next if $Redlist{$a};                      # don't add to whitelist if rcpt is redlisted
            next if $a =~ /\=/ && !$EmailAllowEqual;
            next if $a =~ s/^\'//;

            #next if $whiteListedDomains && $a=~$WLDRE;

            mlog( $fh, "whitelist addition: $a", 1 )
              unless $Whitelist{$a} || $NoAutoWhite;
            $Whitelist{$a} = $t unless !$Whitelist{$a} && $NoAutoWhite;
          }
        return 1;
      }
    0;
  }

# clean up source email
sub clean {
    local $_ = "\n" . shift;
    my ($helo) = /helo=([^)]+)\)/i;
    $helo =~ s/(\w+)/ hlo $1 /g
      if length($helo) > 19;    # if the helo string is long, break it up
    my $rcpt = "rcpt " . join( " rcpt ", /($EmailAdrRe\@$EmailDomainRe)/g );

    # replace &#ddd encoding
    s/&#(\d{1,3});?/chr($1)/ge;

    # replace base64 encoding
    s/\n([a-zA-Z0-9+\/=]{40,}\r?\n[a-zA-Z0-9+\/=\r\n]+)/base64decode($1)/gse;

    # clean up quoted-printable references
    s/(Subject: .*)=\r?\n/$1\n/;
    s/=\r?\n//g;
    s/=([0-9a-fA-F]{2})/pack("C",hex($1))/gei;
    s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;    # replace url encoding
                                                         # strip out mime continuation
    s/.*---=_NextPart_.*\n//g;

    # mark the subject
    s/\nsubject: (.*)/fixsub($1)/ige;

    # remove received lines
    s/\n(received|Content-Type): .*(\n[\t ].*)*//ig;

    # remove other header lines
    s/(\n[a-zA-Z\-]{2,40}: .*(\n[\t ].*)*){2,}//g;

    # clean up &nbsp; and &amp;
    s/&nbsp;?/ /gi;
    s/&amp;?/and/gi;
    s/(\d),(\d)/$1$2/g;
    s/\r//g;
    s/ *\n/\n/g;
    s/\n\n\n\n\n+/\nblines blines\n/g;

    # clean up html stuff
    s/<script.*?>\s*(<!\S*)?/ jscripttag jscripttag /ig;
    while (s/(\w+)(<[^>]*>)((<[^>]*>)*\w+)/$2$1$3/g) { }    # move html out of words
    s/<([biu]|strong)>/ boldifytext boldifytext /gi;

    # remove some tags that are not informative
    s/<\/?(p|br|div|t[dr])[^>]*>/\n/gi;
    s/<\/([biu]|font|strong)>//gi;
    s/<\/?(html|meta|head|body|span|o)[^>]*>//ig;
    s/(<a\s[^>]*>)(.*?)(<\s*\/a\s*>)/$1.fixlinktext($2).$3/igse;
    s/<\s*\/a\s*>//gi;

    # treat titles like subjects
    s/<title[^>]*>(.*?)<\/title>/fixsub($1)/ige;

    # remove style sheets
    s/<style[^>]*>.*?<\/style>//igs;

    # remove html comments
    s/<!.*?-->//gs;
    s/<![^>]*>//g;

    # look for random words
    s/[ a-z0-9][ghjklmnpqrstvwxz_]{2}[bcdfghjklmnpqrstvwxz_0-9]{3}\S*/ randword randword /gi;

    # remove mime separators
    s/\n--.*randword.*//g;

    # look for linked images
    s/(<a[^>]*>[^<]*<img)/ linkedimage linkedimage $1/gis;
    s/<[^>]*href\s*=\s*("[^"]*"|\S*)/fixhref($1)/isge;
    s/http:\/\/(\S*)/fixhref($1)/isge;
    s/(\S+\@\S*\.\w{2,3})\b/fixhref($1)/ge;
    "helo: $helo\n$rcpt\n$_";
  }

sub fixhref { my $t = shift; $t =~ s/(\w+)/ href $1 /g; $t; }

sub fixlinktext { my $t = shift; $t =~ s/(\w+)/atxt $1/g; $t; }

sub fixurl {
    my $a = shift;
    $a =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;
    $a;
  }

sub fixsub {
    my $s = shift;
    $s =~ s/ {3,}/ lotsaspaces /g;
    $s =~ s/(\S+)/ssub $1/g;
    "\n$s ssub";
  }

sub base64decode {
    my $str = shift;
    my $res;
    $str =~ tr|A-Za-z0-9+/||cd;
    $str =~ tr|A-Za-z0-9+/| -_|;
    while ( $str =~ /(.{1,60})/gs ) {
        my $len = chr( 32 + length($1) * 3 / 4 );
        $res .= unpack( "u", $len . $1 );
      }
    $res;
  }

sub formatMethod {
    my $res;
    if ( $_[2] == 0 ) {
        $res = int( $_[0] / $_[1] );
        $_[0] -= $res * $_[1];    # modulus on floats
      } elsif ( $_[2] == 1 ) {
        if ( $_[0] >= $_[1] ) {
            $res = sprintf( "%.1f", $_[0] / $_[1] );
            $_[0] = 0;
          }
      }
    return $res;
  }

sub formatDataSize {
    my ( $size, $method ) = @_;
    my ( $res, $s );
    $res .= $s . 'TB ' if $s = formatMethod( $size, 1099511627776, $method );
    $res .= $s . 'GB ' if $s = formatMethod( $size, 1073741824,    $method );
    $res .= $s . 'MB ' if $s = formatMethod( $size, 1048576,       $method );
    $res .= $s . 'kB ' if $s = formatMethod( $size, 1024,          $method );
    if ( $size || !defined $res ) {

        if ( $method == 0 ) {
            $res .= $size . 'B ';
          } elsif ( $method == 1 ) {
            $res .= sprintf( "%.1fB ", $size );
          }
      }
    $res =~ s/\s$//;
    return $res;
  }

sub unformatTimeInterval {
    my ( $interval, $default ) = @_;
    my @a = split( ' ', $interval );
    my $res = 0;
    foreach my $i (@a) {
        my ( $i, $mult ) = $i =~ /^(.*?) ?([smhd]?)$/;
        $mult ||= $default || 's';    # default to seconds
        if ( $mult eq 's' ) {
            $res += $i;
          } elsif ( $mult eq 'm' ) {
            $res += $i * 60;
          } elsif ( $mult eq 'h' ) {
            $res += $i * 3600;
          } elsif ( $mult eq 'd' ) {
            $res += $i * 86400;
          }
      }
    return $res;
  }

sub unformatDataSize {
    my ( $size, $default ) = @_;
    my @a = split( ' ', $size );
    my $res = 0;
    foreach my $s (@a) {
        my ( $s, $mult ) = $s =~ /^(.*?) ?(B|kB|MB|GB|TB)?$/;
        $mult ||= $default || 'B';    # default to bytes
        if ( $mult eq 'B' ) {
            $res += $s;
          } elsif ( $mult eq 'kB' ) {
            $res += $s * 1024;
          } elsif ( $mult eq 'MB' ) {
            $res += $s * 1048576;
          } elsif ( $mult eq 'GB' ) {
            $res += $s * 1073741824;
          } elsif ( $mult eq 'TB' ) {
            $res += $s * 1099511627776;
          }
      }
    return $res;
  }

sub decodeMimeWord {
    my ( $charset, $encoding, $text ) = @_;

    # ignore charset
    my $s;
    if ( lc $encoding eq 'b' ) {
        $text = base64decode($text);
      } elsif ( lc $encoding eq 'q' ) {
        $text =~ s/_/\x20/g;                                  # RFC 1522, Q rule 2
        $text =~ s/=([\da-fA-F]{2})/pack('C', hex($1))/ge;    # RFC 1522, Q rule 1
      }
    return $text;
  }

sub decodeMimeWords {
    my $s = shift;
    headerUnwrap($s);
    $s =~ s/=\?([^?]*)\?(b|q)\?([^?]+)\?=/decodeMimeWord($1,$2,$3)/gie;
    return $s;
  }

sub downloadGrip {

    d("griplistdownload-start");
    my $rc;

    my $longRetry  = time + ( ( int( rand(5) ) + 9 ) * 3600 );    # no sooner than 9 hours and no later than 14 hours
    my $shortRetry = time + ( ( int( rand(2) ) + 1 ) * 3600 );    # no sooner than 1 hour and no later than 3 hours

    my $gripListUrl = "http://scripts.asspsmtp.org/grey/griplist.txt";
    my $gripFile    = "$base/$griplist";

    # let's check if we really need to
    my @s     = stat($gripFile);
    my $mtime = $s[9];
    if ( time - $mtime <= 6 * 3600 ) {

        # file exists and has been downloaded recently, must have restarted
        $NextGriplistDownload = $shortRetry;
        return;
      }

    if ( !$CanUseLWP ) {
        mlog( 0, "ConfigError: Griplist Update failed: LWP::Simple Perl module not available" );
        $NextGriplistDownload = $longRetry;
        return;
      }

    if ( -e $gripFile ) {

        if ( !-r $gripFile ) {
            mlog( 0, "AdminInfo: Griplist Update failed: $gripFile not readable!" );
            $NextGriplistDownload = $longRetry;
            return;
          } elsif ( !-w $gripFile ) {
            mlog( 0, "AdminInfo: Griplist Update failed: $gripFile not writable!" );
            $NextGriplistDownload = $longRetry;
            return;
          }

      } else {

        if ( open( TEMPFILE, ">", $gripFile ) ) {

            #we can create the file, this is good, now close the file and keep going.
            close TEMPFILE;
            unlink $gripFile;
          } else {
            mlog( 0, "AdminInfo: Griplist Update failed: Cannot create $gripFile " );
            $NextGriplistDownload = $longRetry;
            return;
          }

      }

    # Create LWP ogject
    use LWP::Simple qw(mirror is_success status_message $ua);

    # Set useragent to ASSP version
    $ua->agent("ASSP/$version$modversion ($^O; Perl/$]; LWP::Simple/$LWP::VERSION)");
    $ua->timeout(20);
    if ($proxyserver) {
        $ua->proxy( 'http', "http://" . $proxyserver );
        mlog( 0, "Updating Griplist via HTTP proxy: $proxyserver" )
          if $MaintenanceLog;
      } else {
        mlog( 0, "Updating Griplist via direct HTTP connection" ) if $MaintenanceLog;
      }

    # call LWP mirror command
    $rc = mirror( $gripListUrl, $gripFile );

    d("LWP-response: $rc");

    if ( $rc == 304 ) {

        # HTTP 304 not modified status returned
        mlog( 0, "Griplist already up to date" ) if $MaintenanceLog;
        $NextGriplistDownload = $longRetry;
        return;
      } elsif ( !is_success($rc) ) {

        #download failed-error code output to logfile

        mlog( 0, "AdminInfo: Griplist Update failed: $rc " . status_message($rc) );
        $NextGriplistDownload = $shortRetry;
        return;
      } elsif ( is_success($rc) ) {

        # download complete
        $NextGriplistDownload = $longRetry;
        mlog( 0, "Griplist Update complete" ) if $MaintenanceLog;

        if ($GriplistObject) {
            $GriplistObject->resetCache();
          } else {
            $GriplistObject = tie %Griplist, 'orderedtie', $gripFile
              if $griplist;
          }
      }
  }

sub uploadStats {

    my ( $peeraddress, $connect );
    if ($proxyserver) {
        mlog( 0, "uploading stats via proxy:$proxyserver" ) if $MaintenanceLog;
        $peeraddress = $proxyserver;
        $connect     = "POST http://www.asspsmtp.org/scripts/stats/upload.pl HTTP/1.0";
      } else {
        mlog( 0, "uploading stats via direct connection" ) if $MaintenanceLog;
        $peeraddress = "www.asspsmtp.org:80";
        $connect     = "POST /scripts/stats/upload.pl HTTP/1.1
Host: www.asspsmtp.org";
      }
    my $s = new IO::Socket::INET(
        Proto    => 'tcp',
        PeerAddr => $peeraddress,
        Timeout  => 2
    );
    if ($s) {
        my %UploadStats;
        my %tots = statsTotals();
        $UploadStats{starttime} = $Stats{starttime};
        $UploadStats{version}   = $Stats{version};
        $UploadStats{pid}       = $$;
        $UploadStats{timenow}   = time;
        $UploadStats{testmode}  = unpack "C", pack "B*",
          "0$baysTestMode$blTestMode$hlTestMode$spfTestMode$rblTestMode$srsTestMode";
        $UploadStats{messages}     = $tots{msgTotal};        # legacy
        $UploadStats{locals}       = $Stats{locals};
        $UploadStats{whites}       = $Stats{whites};
        $UploadStats{noprocessing} = $Stats{noprocessing};

        # for legacy support, $UploadStats{spams} are effectively non Bayesian spams.
        $UploadStats{spams}        = $tots{msgRejectedTotal} - $Stats{bspams};    # legacy
        $UploadStats{blacklisted}  = $Stats{blacklisted};
        $UploadStats{helolisted}   = $Stats{helolisted};
        $UploadStats{spambucket}   = $Stats{spambucket};
        $UploadStats{bhams}        = $Stats{bhams};
        $UploadStats{bspams}       = $Stats{bspams};
        $UploadStats{viri}         = $Stats{viri} + $Stats{viridetected};         # legacy
        $UploadStats{viridetected} = $Stats{viridetected};
        $UploadStats{norelays}     = $tots{rcptRelayRejected};                    # legacy
        $UploadStats{connects}     = $tots{smtpConnTotal};                        # legacy
        $UploadStats{spamlover}    = $Stats{spamlover};
        $UploadStats{bombs}        = $Stats{bombs};
        $UploadStats{scripts}      = $Stats{scripts};
        $UploadStats{spffails}     = $Stats{spffails};
        $UploadStats{rblfails}     = $Stats{rblfails} + $Stats{rblcachehit};
        $UploadStats{nextUpload}   = $Stats{nextUpload};
        my $content = join( "\001", %UploadStats );
        my $len = length($content);
        $connect .= "
Content-Type: application/x-www-form-urlencoded
Content-Length: $len

$content";
        print $s $connect;
        $s->close;
      } else {
        mlog( 0, "unable to connect to stats server" );
      }
    $Stats{nextUpload} = time + 3600 * 8;
  }

sub ResetStats {
    $Stats{nextUpload}                = time + 3600 * 8;
    $Stats{cpuTime}                   = 0;
    $Stats{cpuBusyTime}               = 0;
    $Stats{sbblocked}				  = 0;
    $Stats{smtpConn}                  = 0;
    $Stats{smtpConnNotLogged}         = 0;
    $Stats{smtpConnLimit}             = 0;
    $Stats{smtpConnLimitIP}           = 0;
    $Stats{smtpConnDomainIP}          = 0;
    $Stats{smtpConnLimitFreq}         = 0;
    $Stats{smtpConnDenied}            = 0;
    $Stats{smtpConnIdleTimeout}       = 0;
    $Stats{smtpConcurrentSessions}    = 0;
    $Stats{smtpMaxConcurrentSessions} = 0;
    $Stats{admConn}                   = 0;
    $Stats{admConnDenied}             = 0;
    $Stats{statConn}                  = 0;
    $Stats{statConnDenied}            = 0;
    $Stats{rcptValidated}             = 0;
    $Stats{rcptUnchecked}             = 0;
    $Stats{rcptSpamLover}             = 0;
    $Stats{rcptWhitelisted}           = 0;
    $Stats{rcptNotWhitelisted}        = 0;
    $Stats{rcptUnprocessed}           = 0;
    $Stats{rcptReportSpam}            = 0;
    $Stats{rcptReportHam}             = 0;
    $Stats{rcptReportWhitelistAdd}    = 0;
    $Stats{rcptReportWhitelistRemove} = 0;
    $Stats{rcptReportRedlistAdd}      = 0;
    $Stats{rcptReportRedlistRemove}   = 0;
    $Stats{rcptReportAnalyze}         = 0;
    $Stats{rcptReportHelp}            = 0;
    $Stats{rcptNonexistent}           = 0;
    $Stats{rcptDelayed}               = 0;
    $Stats{rcptDelayedLate}           = 0;
    $Stats{rcptDelayedExpired}        = 0;
    $Stats{rcptEmbargoed}             = 0;
    $Stats{rcptSpamBucket}            = 0;
    $Stats{rcptRelayRejected}         = 0;
    $Stats{senderInvalidLocals}       = 0;
    $Stats{bombSender}                = 0;
    $Stats{bombBlack}                 = 0;
    $Stats{pbdenied}                  = 0;
    $Stats{pbextreme}                 = 0;
    $Stats{denyConnection}            = 0;
    $Stats{denyConnectionA}           = 0;
    $Stats{msgscoring}                = 0;
    $Stats{msgMaxErrors}              = 0;
    $Stats{msgMaxFreq}                = 0;
    $Stats{msgDelayed}                = 0;
    $Stats{msgNoRcpt}                 = 0;
    $Stats{msgNoSRSBounce}            = 0;
    $Stats{bhams}                     = 0;
    $Stats{whites}                    = 0;
    $Stats{locals}                    = 0;
    $Stats{noprocessing}              = 0;
    $Stats{spamlover}                 = 0;
    $Stats{bspams}                    = 0;
    $Stats{blacklisted}               = 0;
    $Stats{invalidHelo}               = 0;
    $Stats{forgedHelo}                = 0;
    $Stats{mxaMissing}                = 0;
    $Stats{ptrMissing}                = 0;
    $Stats{ptrInvalid}                = 0;
    $Stats{helolisted}                = 0;
    $Stats{spambucket}                = 0;
    $Stats{penaltytrap}               = 0;
    $Stats{internaladdress}           = 0;
    $Stats{viri}                      = 0;
    $Stats{viridetected}              = 0;
    $Stats{bombs}                     = 0;
    $Stats{froms}                     = 0;
    $Stats{dkim}                      = 0;
    $Stats{msgverify}                 = 0;
    $Stats{bombSender}                = 0;
    $Stats{scripts}                   = 0;
    $Stats{internaladdresses}         = 0;
    $Stats{spffails}                  = 0;
    $Stats{rblfails}                  = 0;
    $Stats{uriblfails}                = 0;
    $Stats{msgBackscatterErrors}	  = 0;
	$Stats{msgMSGIDtrErrors}		  = 0;

    open( F, "<$base/asspstats.sav" );
    (%OldStats) = split( /\001/, <F> );
    close F;

    # conversion from previous versions
    if ( exists $OldStats{messages} ) {
        $OldStats{smtpConn}        = $OldStats{connects};
        $OldStats{smtpConnLimit}   = $OldStats{maxSMTP};
        $OldStats{smtpConnLimitIP} = $OldStats{maxSMTPip};
        $OldStats{viri} -= $OldStats{viridetected};    # fix double counting
        $OldStats{rcptRelayRejected} = $OldStats{norelays};

        # remove unused entries
        delete $OldStats{connects};
        delete $OldStats{maxSMTP};
        delete $OldStats{maxSMTPip};
        delete $OldStats{messages};
        delete $OldStats{spams};
        delete $OldStats{hams};
        delete $OldStats{norelays};
        delete $OldStats{testmode};
        SaveStats();
      }
  }

sub SaveStats {
    $Stats{smtpConcurrentSessions} = $smtpConcurrentSessions;
    $NextSaveStats = time + ( $SaveStatsEvery * 60 );
    %AllStats = %OldStats;
    foreach ( keys %Stats ) {
        if ( $_ eq 'version' ) {

            # just copy
            $AllStats{$_} = $Stats{$_};
          } elsif ( $_ eq 'smtpMaxConcurrentSessions' ) {

            # pick greater value
            $AllStats{$_} = $Stats{$_} if $Stats{$_} > $AllStats{$_};
          } else {
            $AllStats{$_} += $Stats{$_};
          }
      }
    $AllStats{starttime} = $OldStats{starttime} || $Stats{starttime};
    open( F, ">$base/asspstats.sav" );
    print F join( "\001", %AllStats );
    close F;
  }

#####################################################################################
#                Maillog functions
# find an appropriate name for a maillog file
sub maillogFilename {
    my ( $fh, $isspam, $sub ) = @_;
    my $this    = $Con{$fh};
    my @dirs    = ( $notspamlog, $spamlog, $incomingOkMail, $viruslog );
    my $maillog = $dirs[$isspam];
    d(19);
    $sub =~ /Subject: (.*)/;
    $sub = $1;
    $sub = decodeMimeWords($sub);
    $sub =~ y/a-zA-Z0-9/_/cs;
    $this->{subject} = substr( $sub, 0, 50 );

    if ( $UseSubjectsAsMaillogNames || $isspam == 2 || $isspam == 3 ) {

        $sub .= "--" . ( ++$Counter );
        return "$base/$maillog/$sub$maillogExt";
      } else {
        my $fn = $this->{fn};
        "$base/$maillog/$fn$maillogExt";
      }
  }

sub maillogNewFileName {
    my $fn;

    if ( $FilesDistribution < 1.0 ) {
        my $p1 = 1.0 - $FilesDistribution;
        my $p2 = log($FilesDistribution);
        $fn = int( $MaxFiles * log( 1.0 - rand($p1) ) / $p2 );
      } else {
        $fn = int( $MaxFiles * rand() );
      }
    return $fn;
  }

# integrated mail collection subroutine
sub MaillogStart {
    d(361);
    $Con{ $_[0] }->{maillog} = 1 unless $NoMaillog;
    $Con{ $_[0] }->{maillogbuf} = $Con{ $_[0] }->{header} = $Con{ $_[0] }->{rcvd};
  }

sub Maillog {
    my ( $fh, $text, $parm ) = @_;
    my $this = $Con{$fh};
    my $fln;
    my $isnotcc;
    if ( $parm == 1 ) {
        $parm    = 3;
        $isnotcc = 1;

      }

    # 1 -- is spam, parm = 2 -- not spam, 3 -- is spam && cc to spamaccount, 4 -- mail ok
    # 5 -- virii, 6 -- ignore, 7 -- ignore && cc to spamaccount

    return
      if ( $parm == 2 || $parm == 4 ) && $this->{red} && $DoNotCollectRedRe;
    return unless ( $Con{$fh}->{maillog} );
    return if ( $this->{nocollect} );
    return if $this->{noprocessing} && ( $parm == 2 || $parm == 4 );
    if ( $noCollecting && matchSL( $this->{mailfrom}, 'noCollecting' ) ) {
        $this->{nocollect} = 1;
        return;
      }
    $parm = 1
      if $ccMaxScore && ( $parm == 3 && $this->{messagescore} > $ccMaxScore );
    return
      if $ccMaxScore && ( $parm == 7 && $this->{messagescore} > $ccMaxScore );
    $parm = 7 if $parm == 3 && $this->{donotcollectbombs} && $DoNotCollectBombs;
    return if $parm == 1 && $this->{donotcollectbombs} && $DoNotCollectBombs;
    
    $parm = 7 
      if ( $parm == 6
        && $ccSpamAlways
        && allSL( $this->{rcpt}, $Con{$fh}->{mailfrom}, 'ccSpamAlways' ) );
    $parm = 7
      if ( $parm == 6
        && $ccSpamFilter
        && $sendAllSpam
        && allSL( $this->{rcpt}, $Con{$fh}->{mailfrom}, 'ccSpamFilter' ) );
    return if $this->{ccnever};
    my $skipLog = 0;

    if ( $parm == 1 || $parm == 2 || $parm == 3 ) {
        $logCount[$parm]++;
        $skipLog = 1                if ( $logFreq[$parm] > $logCount[$parm] && $parm != 7 );
        $fln     = "nocollect:freq" if ( $logFreq[$parm] > $logCount[$parm] );
        $parm    = 7                if $this->{red} && $DoNotCollectRedRe && $parm == 3;
        $parm    = 6                if $this->{red} && $DoNotCollectRedRe && $parm == 1;
        $fln     = "nocollect:red"  if $this->{red} && $DoNotCollectRedRe;
        $parm    = 7                if $this->{redsl} && $parm == 3;
        $parm    = 6                if $this->{redsl} && $parm == 1;
        $fln     = "nocollect:sl"   if $this->{redsl} && ( $parm == 1 || $parm == 3 );
        $parm    = 7                if $this->{messagelow} && $parm == 3;
        $parm    = 6                if $this->{messagelow} && $parm == 1;
        $fln = "nocollect:lowscore"
          if $this->{messagelow} && ( $parm == 1 || $parm == 3 );
      }
    if ( $parm == 3 && $skipLog == 1 ) {
        $parm    = 7;
        $skipLog = 0;
      }

    if (   $parm == 4 && !$incomingOkMail
        || $parm == 5 && !$viruslog
        || $parm == 6
        || $parm == 7 && $Con{ $Con{$fh}->{forwardSpam} }->{ready}
        || $skipLog ) {
        d(364);
        delete $Con{$fh}->{maillogbuf};
        delete $Con{$fh}->{maillog};
        close $Con{$fh}->{maillogfh} if $Con{$fh}->{maillogfh};
        delete $Con{$fh}->{maillogfh};
        delete $Con{$fh}->{mailloglength};
      } elsif ( $parm > 1 ) {

        d(362);
        $logCount[$parm] = 0;

        # we now know if it is spam or not -- open the file
        $text = $Con{$fh}->{maillogbuf} . $text;
        if ( $parm < 7 ) {
            delete $Con{$fh}->{maillogbuf};

            my $fn = maillogFilename( $fh, $parm - 2, $text );
            $fln = $fn;
            $Con{$fh}->{maillogfilename} = $fn;
            if ( $this->{red} && $DoNotCollectRedRe ) {
                $fln = "";
              } else {
                $FH = 'FHaaaaa' unless $FH;
                if ( open( ++$FH, ">$fn" ) ) {
                    $Con{$fh}->{maillogfh}     = $FH;
                    $Con{$fh}->{mailloglength} = 0;
                    binmode $FH;
                  } else {

                    mlog( $fh, "error opening maillog '$fn': $!" );
                  }
              }
          }

        # start sending the message to sendAllSpam if appropriate

        my $current_email = $this->{rcpt};
        $current_email =~ /($EmailAdrRe)\@($EmailDomainRe)/;
        my ( $current_username, $current_domain ) = ( $1, $2 );


        if ($sendAllSpam) {
            $ccspamlt = $sendAllSpam;
            $ccspamlt =~ s/USERNAME/$current_username/g;
            $ccspamlt =~ s/DOMAIN/$current_domain/g;
        if ( $ccdlist{$current_domain} ) {
            $ccspamlt .= " " . $ccdlist{$current_domain} . "@" . $current_domain;
            
            }
#                       mlog( $fh, "test: current_domain=$current_domain ccdlist=$ccdlist{$current_domain} ccspamlt=$ccspamlt");    
                
            $Con{$fh}->{forwardSpam} = forwardSpam( $Con{$fh}->{mailfrom}, $ccspamlt, $fh )
              if (
                   $isnotcc != 1
                && ( $parm == 3 || $parm == 7 )
                && (  !$ccSpamFilter
                    || $ccSpamFilter && allSL( $this->{rcpt}, $Con{$fh}->{mailfrom}, 'ccSpamFilter' ) )
              );
          }
      }

    if ($ccMaxBytes) {
        if ( my $h = $Con{$fh}->{maillogfh} ) {
            print $h $text;
            if ( ( $Con{$fh}->{mailloglength} += length($text) ) > $MaxBytes
                || $text =~ /(^|[\r\n])\.[\r\n]/ ) {
                d(366);
                close $h;
                delete $Con{$fh}->{maillog} unless $Con{$fh}->{forwardSpam};
                delete $Con{$fh}->{maillogfh};
                delete $Con{$fh}->{mailloglength};
              }
          } elsif ( length( $Con{$fh}->{maillogbuf} ) < $MaxBytes ) {
            $Con{$fh}->{maillogbuf} .= $text;
          }
      } else {
        if ( my $h = $Con{$fh}->{maillogfh} ) {

            print $h substr( $text, 0, $MaxBytes )
              if length( $this->{spambuf} ) < $MaxBytes;
            $this->{spambuf} .= $text;
            if ( $text =~ /(^|[\r\n])\.[\r\n]/ ) {
                d(366);
                close $h;
                delete $Con{$fh}->{maillog} unless $Con{$fh}->{forwardSpam};
                delete $Con{$fh}->{maillogfh};
                delete $Con{$fh}->{mailloglength};
              }
          } else {
            $Con{$fh}->{maillogbuf} .= $text;
          }
      }
    if ( $Con{$fh}->{forwardSpam} ) {
        my $t = $Con{ $Con{$fh}->{forwardSpam} };
        if ( $t->{ready} ) {

            sendque( $Con{$fh}->{forwardSpam}, $text );
          } else {
            $t->{body} .= $text;
          }
      }
    $isnotcc = 0;
    return $fln;
  }

sub forwardSpam {
    my ( $from, $to, $oldfh ) = @_;
    my $localip;
    my $s;

    my $destination;
    if ( $sendAllDestination ne '' ) {
        $destination = $sendAllDestination;
      } else {
        $destination = $smtpDestination;
      }

    $AVa = 0;
    foreach $destinationA ( split( /\|/, $destination ) ) {
        if ( $destinationA =~ /^(_*INBOUND_*:)?(\d+)$/ ) {

            $localip = '127.0.0.1';

            $destinationA = $localip . ':' . $2;
          }
        if ( $AVa < 1 ) {
            $s = new IO::Socket::INET(
                Proto    => 'tcp',
                PeerAddr => $destinationA,
                Timeout  => 2
            );
            if ($s) {
                $AVa         = 1;
                $destination = $destinationA;
              } else {
                mlog( '', "*** $destinationA didn't work, trying others..." )
                  if $SessionLog;
              }
          }
      }
    if ( !$s ) {

        mlog( '', "couldn't create server socket to $destination -- aborting sendAllSpam connection" ) if $SessionLog;
        return;
      }
    addfh( $s, \&FShelo );
    my $this = $Con{$s};

    $this->{ready}        = 0;
    $this->{to}           = $to;
    $this->{from}         = $from;
    $this->{clamscandone} = $Con{$oldfh}->{clamscandone};
    $this->{rcpt}         = $Con{$oldfh}->{rcpt};
    $this->{myheader}     = $Con{$oldfh}->{myheader};
    $this->{prepend}      = $Con{$oldfh}->{prepend};
    $this->{saveprepend}  = $Con{$oldfh}->{saveprepend};
    $this->{saveprepend2} = $Con{$oldfh}->{saveprepend2};

    $s;
  }

sub FShelo {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "helo Expected 220, got: $l" );
      } elsif ( $l =~ /^ *220 / ) {
        sendque( $fh, "HELO $myName\r\n" );
        $Con{$fh}->{getline} = \&FSfrom;
      }
  }

sub FSfrom {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "send HELO($myName), expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "MAIL FROM: <$Con{$fh}->{from}>\r\n" );
    
        $Con{$fh}->{getline} = \&FSrcpt;
      }
  }

sub FSrcpt {
    my ( $fh, $l ) = @_; my $ccd;
    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "send FROM ($Con{$fh}->{from}), expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {
      	($Con{$fh}->{to},$ccd) = split / /, $Con{$fh}->{to};
        sendque( $fh, "RCPT TO: <$Con{$fh}->{to}>\r\n" );
        sendque( $fh, "RCPT TO: <$ccd>\r\n" ) if $ccd;
        $Con{$fh}->{getline} = \&FSdata;
      }
  }

sub FSdata {
    my ( $fh, $l ) = @_;
    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "send RCPT ($Con{$fh}->{to}), expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {
        sendque( $fh, "DATA\r\n" );
        $Con{$fh}->{getline} = \&FSdata2;
      }
  }

sub FSdata2 {
    my ( $fh, $l ) = @_;
    my $this = $Con{$fh};
    my $parm = $this->{parm};
    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "data2 Expected 354, got: $l" );
      } elsif ( $l =~ /^ *354 / ) {
        my $this = $Con{$fh};

        $this->{myheader} =~ s/^X-Assp-Intended-For:$HeaderValueRe//gimo
          if $AddIntendedForHeader;    # clear out existing X-Assp-Intended-For headers
        $this->{body} =~ s/^($HeaderRe*)/$1From: sender not supplied\r\n/o
          unless $this->{body} =~ /^$HeaderRe*From:/io;    # add From: if missing
        $this->{body} =~ s/^($HeaderRe*)/$1Subject:\r\n/o
          unless $this->{body} =~ /^$HeaderRe*Subject:/io;    # add Subject: if missing

        $this->{saveprepend} .= $this->{saveprepend2};
        my ($sub) = $this->{body} =~ /Subject: (.*)/;
        $this->{body} =~ s/^Subject:/Subject: $this->{saveprepend}/gim
          if ( $spamTagCC && $this->{saveprepend} );

        $this->{body} =~ s/^Subject:/Subject: $spamSubject/gim
          if $spamSubjectCC && $spamSubject;

        # merge our header, add X-Intended-For header
        $this->{myheader} = headerWrap( $this->{myheader} );    # wrap long lines
		my ($to) = $this->{rcpt} =~ /(\S+)/;
        $this->{body} =~
s/^($HeaderRe*)/$1\r\n\n\n\r$this->{myheader}X-Assp-Intended-For: $to\r\nX-Assp-Copy-Spam: Yes\r\n/o;
        $this->{body} =~ s/\r?\n?\r\n\n\n\r/\r\n/;
        if (   $ScanCC
            && $this->{body}
            && haveToScan($fh)
            && !ClamScanOK( $fh, $this->{body} ) ) {
            return;
          }
        sendque( $fh, $this->{body} ) if $this->{body};
        sendque( $fh, "\r\n.\r\n" )   if ( $this->{body} !~ /[\n\r]\.[\n\r]+$/ );
        $this->{ready}       = 1;
        $this->{body}        = '';
        $Con{$fh}->{getline} = \&FSdone;
      }
  }

sub FSdone {
    my ( $fh, $l ) = @_;

    if ( $l =~ /^ *5/ ) {
        FSabort( $fh, "done Expected 250, got: $l" );
      } elsif ( $l =~ /^ *250 / ) {

        done2($fh);    # close and delete
      }
  }
sub FSabort { mlog( 0, "FSabort: $_[1]" ); done2( $_[0] ); }

sub haveToScan {
    my $fh   = shift;
    my $this = $Con{$fh};

    return 0
      if ( $this->{noscan}
        || $noScan && matchSL( $this->{mailfrom}, 'noScan' ) );
    return 0 if $this->{clamscandone} == 1;
    return 0 if !$UseAvClamd;
    return 0 if !$CanUseAvClamd;
    return 0 if $this->{whitelisted} && $ScanWL != 1;
    return 0 if $this->{noprocessing} && $ScanNP != 1;
    return 0 if $this->{relayok} && $ScanLocal != 1;
    $this->{prepend} = "";

    if ( $NoScanRe && $NoScanReRE != "" && $b =~ ( '(' . $NoScanReRE . ')' ) ) {
        mlogRe( $1, "NoVirusscan" );
        return 0;
      }
    return 1;
  }

sub ClamScanOK {
    my ( $fh, $b, $s ) = @_;
    my $av;
    my $errstr;
    my $this = $Con{$fh};
    return 1 if ( !haveToScan($fh) );
    my $maxbytes = $MaxBytes ? $MaxBytes : 10000;
    $maxbytes = $ClamAVBytes if $ClamAVBytes > $maxbytes;


    $av = new File::Scan::ClamAV( port => $AvClamdPort );
    if ($alreadyTestingPing) {
      } else {
        $alreadyTestingPing = 1;
        if ( $av->ping() ) {
            $alreadyTestingPing = 0;
            $VerAvClamd         = $av->VERSION;
            mlog( 0, 'ClamAv Up' ) if $ScanLog && $AvailAvClamd == 0;
            $AvailAvClamd = 1;
          } else {
            $alreadyTestingPing = 0;
            mlog( 0, 'ClamAV Down' ) if $ScanLog && $AvailAvClamd == 1;
            $AvailAvClamd = 0;
            $CommentAvClamd = 'ClamAV Down';
            undef $av;
            return 1;
          }
      }
    $this->{clamscandone} = 1 if !$s;

    my $mtype = "";
    $mtype = "headerpart of" if $s;
    $mtype = "whitelisted"   if $this->{whitelisted};
    $mtype = "noprocessing"  if $this->{noprocessing};
    $mtype = "local"         if ( $this->{localuser} || $this->{relayok} );

    my $lb = length(substr( $b, 0, $maxbytes ));
    my $timeout = $ClamAVtimeout || 10;
    my ( $code, $virus );

    eval {
        local $SIG{ALRM} = sub { die "__alarm__\n" };
        alarm($timeout);
        ( $code, $virus ) = $av->streamscan(substr( $b, 0, $maxbytes ));
        alarm(0);
    };
    alarm 0;
    if ($@) {
        if ( $@ =~ /^__alarm__$/ ) {
            mlog( $fh, "ClamAV: streamscan timed out after $timeout secs.", 1 );
            $CommentAvClamd = "timed out after $timeout secs";
          } else {
            mlog( $fh, "ClamAV: streamscan failed: $@", 1 );
            $CommentAvClamd = "streamscan failed: $@";
          }
        undef $av;
        return 1;
      }
    eval{$errstr   = $av->errstr();};
    undef $av;
    mlog( $fh, "ClamAV: scanned $lb bytes in $mtype message - $code $virus", 1 ) if $ScanLog;
    $CommentAvClamd = "";
    if ( $code eq 'OK' ) {
        return 1;
      } elsif ( $SuspiciousVirus && $SuspiciousVirusRE != "" && $code =~ ( '(' . $SuspiciousVirusRE . ')' ) ) {
        $this->{messagereason} = "SuspiciousVirus: $virus '$1'";
        pbAdd( $fh, $this->{ip}, $vsValencePB, "$virus", 1 ) if $vsValencePB > 0;
        $this->{prepend} = "[VIRUS][scoring]";
        mlog( $fh, "'$virus' passing because of '$1'" );
        return 1;
      } elsif ( $code eq 'FOUND' ) {
        $this->{prepend} = "[VIRUS]";
        $this->{averror} = $AvError;
        $this->{averror} =~ s/\$infection/$virus/gi;

        #mlog($fh,"virus detected '$virus'");
        my $reportheader = "Full Header:\r\n$this->{header}\r\n" if $EmailVirusReportsHeader;
        my $sub = "virus detected: '$virus'";

        my $bod = "Message ID: $this->{msgtime}\r\n";
        $bod .= "Remote IP: $this->{ip}\r\n";
        $bod .= "Subject: $this->{subject2}\r\n";
        $bod .= "Sender: $this->{mailfrom}\r\n";
        $bod .= "Recipients(s): $this->{rcpt}\r\n";
        $bod .= "Virus Detected: '$virus'\r\n";

        my $file = "reports/virusreport.txt";

        # Send virus report to administrator if set
        AdminReportMail( $sub, "$bod$reportheader.", $EmailVirusReportsTo ) if $EmailVirusReportsTo;

        # Send virus report to recipient if set
        ReturnMail( $this->{rcpt}, "$base/$file", $sub, "$bod.", '' ) if $EmailVirusReportsToRCPT;

        $Stats{viridetected}++;
        delayWhiteExpire($fh);
        $this->{messagereason} = "virus detected: '$virus'";
        pbAdd( $fh, $this->{ip}, $vdValencePB, "$virus" ) if $vdValencePB > 0;

        return 0;
      }
    $CommentAvClamd   = $errstr;
    $AvailAvClamd = 0;
    mlog( 0, "ClamAv Temporary Off : $errstr" ) if $ScanLog;
    return 1;
  }
#####################################################################################
#                Web Configuration functions
# add multiple tooltips span tags
sub addShowPath {
    my ($text) = @_;
    my $ret;

    while ( $text =~ /\-\> (.*\.eml)/cgso ) {    # /c - keep pos() on match fail

        $ret .= <<EOT;
$1<span onclick="popFileEditor($text,4);">$2</span>
EOT
        chomp($ret);

      }
    $ret .= $1 if $text =~ /\G(.*)/s;            # remainder
    $text = $ret;
    return $text;
  }

sub statRequest {
    my ( $tempfh, $fh, $head, $data ) = @_;
    my $v;
    %statRequests = (
        '/'    => \&ConfigStatsRaw,
        '/raw' => \&ConfigStatsRaw,
        '/xml' => \&ConfigStatsXml
    );
    my $i = 0;

    # %head -- public hash
    (%head) = map { ++$i % 2 ? lc $_ : $_ } map /^([^ :]*)[: ]{0,2}(.*)/, split( /\r\n/, $head );
    my ( $page, $qs ) = ( $head{get} || $head{head} || $head{post} ) =~ /^([^\? ]+)(?:\?(\S*))?/;
    if ( defined $data ) {    # GET, POST order
        $qs .= '&' if ( $qs ne '' );
        $qs .= $data;
      }
    $qs =~ y/+/ /;
    $i = 0;

    # parse query string, get rid of google autofill
    # %qs -- public hash
    (%qs) = map { s/(e)_(mail)/$1$2/gi if ++$i % 2; $_ } split( /[=&]/, $qs );
    foreach my $k ( keys %qs ) {
        $qs{$k} =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;
      }
    my $ip   = $fh->peerhost();
    my $port = $fh->peerport();
    mlog( '', "stat connection from $ip:$port;" );

    $Stats{statConn}++;

    if ( defined( $v = $statRequests{$page} ) ) {
        print $tempfh $v->( $head, $qs );
      }
  }

sub webRequest {
    my ( $tempfh, $fh, $head, $data ) = @_;
    my $v;
    %webRequests=(
  	'/lists' => \&ConfigLists,

  	'/maillog' => \&ConfigMaillog,
  	'/analyze' => \&ConfigAnalyze,
  	'/infostats' => \&ConfigStats,
  	'/edit' => \&ConfigEdit,
  	'/shutdown' => \&Shutdown,
  	'/shutdown_frame' => \&ShutdownFrame,
  	'/shutdown_list' => \&ShutdownList,

  	'/donations' => \&Donations,
  	'/get' => \&GetFile
 	);
    my $i = 0;

    # %head -- public hash
    (%head) = map { ++$i % 2 ? lc $_ : $_ } map /^([^ :]*)[: ]{0,2}(.*)/, split( /\r\n/, $head );
    my ( $page, $qs ) = ( $head{get} || $head{head} || $head{post} ) =~ /^([^\? ]+)(?:\?(\S*))?/;
    if ( defined $data ) {    # GET, POST order
        $qs .= '&' if ( $qs ne '' );
        $qs .= $data;
      }
    $qs =~ y/+/ /;
    $i = 0;

    # parse query string, get rid of google autofill
    # %qs -- public hash
    (%qs) = map { s/(e)_(mail)/$1$2/gi if ++$i % 2; $_ } split( /[=&]/, $qs );
    foreach my $k ( keys %qs ) {
        $qs{$k} =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack('C',hex($1))/ge;
      }
    my ($auth) = $head{authorization} =~ /Basic (\S+)/i;
    my ( $user, $pass ) = split( ':', base64decode($auth) );
    my $ip   = $fh->peerhost();
    my $port = $fh->peerport();

    if ( substr( $Config{webAdminPassword}, 0, 2 ) eq "45" ) {
        $pass = crypt( $pass, "45" );
      }

    if ( $pass eq $webAdminPassword ) {
        if ( $page !~ /shutdown_frame|shutdown_list|favicon.ico|get/i ) {

            # only count requests for pages without meta refresh tag
            # dont count requests for favicon.ico file
            # dont count requests for 'get' page
            my $args;
            if ( $page =~ /edit/i ) {
                if ( defined( $qs{contents} ) ) {
                    if ( $qs{B1} =~ /delete/i ) {
                        $args = "deleting file:$qs{file}";
                      } else {
                        $args = "writing file:$qs{file}";
                      }
                  } else {
                    $args = "reading file:$qs{file}";
                  }
              }
            if ($args) {
                mlog( '', "admin connection from $ip:$port; page:$page; $args" );
              } else {
                mlog( '', "admin connection from $ip:$port; page:$page" );
              }

            $Stats{admConn}++;
          }
        if ( $page =~ /quit/i ) {
            ConfigQuit($tempfh);
          }
        if ( $page =~ /reload/i ) {
            reloadConfigFile();
          }
        if ( $page =~ /save/i ) {
            mlog( 0, "saving config", 1 );
            SaveConfig();
          }
        if ( $page =~ /favicon.ico/i ) {
            print $tempfh "HTTP/1.1 404 Not Found
Content-type: text/html

<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>Not found</h1>
</body></html>\n";
          } else {
            print $tempfh (
                ( defined( $v = $webRequests{$page} ) )
                ? $v->( $head, $qs )
                : webConfig( $head, $qs )
            );
          }
      } else {

        #  if ($pass ne '') {
        #   mlog('',"admin connection from $ip:$port; page:$page rejected -- authorization failed");
        #  $Stats{admConnDenied}++;
        #  }
        print $tempfh "HTTP/1.1 401 Unauthorized
WWW-Authenticate: Basic realm=\"Anti-Spam SMTP Proxy (ASSP) Configuration\"
Content-type: text/html

<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>Unauthorized</h1>
</body></html>\n";
      }
  }

sub ConfigQuit {
    mlog( '', "quit requested from admin interface" );
    &SaveWhitelist;
    my $fh = shift;
    print $fh "HTTP/1.1 200 OK
Content-type: text/html


<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><body><h1>ASSP Terminated.</h1>
</body></html>
";
    exit;
  }

# total current and previous stats
sub ComputeStatTotals {

    my %totStats = %PrevStats;
    foreach my $k ( keys %Stats ) {
        if ( $k eq 'version' ) {

            # just copy
            $totStats{$k} = $Stats{$k};
          } elsif ( $k eq 'smtpMaxConcurrentSessions' ) {

            # pick greater value
            $totStats{$k} = $Stats{$k} if $Stats{$k} > $PrevStats{$k};
          } elsif ( $k eq 'starttime' ) {

            # initialize if needed
            $totStats{$k} = $Stats{$k} unless $PrevStats{$k};
          } else {

            #sum
            $totStats{$k} += $Stats{$k};
          }
      }

    return %totStats;
  }

# compute various totals
sub statsTotals {
    my %s;
    $s{smtpConnIdleTimeout}    = $Stats{smtpConnIdleTimeout};
    $s{smtpConnIdleTimeout2}   = $AllStats{smtpConnIdleTimeout};
    $s{smtpConnAcceptedTotal}  = $Stats{smtpConn} + $Stats{smtpConnNotLogged};
    $s{smtpConnAcceptedTotal2} = $AllStats{smtpConn} + $AllStats{smtpConnNotLogged};
    $s{smtpConnLimit} =
      $Stats{smtpConnLimit} + $Stats{smtpConnDomainIP} + $Stats{smtpConnLimitIP} + $Stats{smtpConnLimitFreq};
    $s{smtpConnLimit2} =
      $AllStats{smtpConnLimit} +
      $AllStats{smtpConnDomainIP} +
      $AllStats{smtpConnLimitIP} +
      $AllStats{smtpConnLimitFreq};
    $s{smtpConnRejectedTotal}  = $s{smtpConnLimit} + $Stats{smtpConnDenied} + $Stats{denyConnectionA};
    $s{smtpConnRejectedTotal2} = $s{smtpConnLimit2} + $AllStats{smtpConnDenied} + $AllStats{denyConnectionA};
    $s{smtpConnTotal}          = $s{smtpConnAcceptedTotal} + $s{smtpConnRejectedTotal};
    $s{smtpConnTotal2}         = $s{smtpConnAcceptedTotal2} + $s{smtpConnRejectedTotal2};
    $s{admConnTotal}           = $Stats{admConn} + $Stats{admConnDenied};
    $s{admConnTotal2}          = $AllStats{admConn} + $AllStats{admConnDenied};
    $s{statConnTotal}          = $Stats{statConn} + $Stats{statConnDenied};
    $s{statConnTotal2}         = $AllStats{statConn} + $AllStats{statConnDenied};
    $s{rcptAcceptedLocal}      = $Stats{rcptValidated} + $Stats{rcptUnchecked} + $Stats{rcptSpamLover};
    $s{rcptAcceptedLocal2}     = $AllStats{rcptValidated} + $AllStats{rcptUnchecked} + $AllStats{rcptSpamLover};
    $s{rcptAcceptedRemote}     = $Stats{rcptWhitelisted} + $Stats{rcptNotWhitelisted};
    $s{rcptAcceptedRemote2}    = $AllStats{rcptWhitelisted} + $AllStats{rcptNotWhitelisted};
    $s{rcptUnprocessed}        = $Stats{rcptUnprocessed};
    $s{rcptUnprocessed2}       = $AllStats{rcptUnprocessed};
    $s{rcptReport} =
      $Stats{rcptReportSpam} +
      $Stats{rcptReportHam} +
      $Stats{rcptReportWhitelistAdd} +
      $Stats{rcptReportWhitelistRemove} +
      $Stats{rcptReportRedlistAdd} +
      $Stats{rcptReportRedlistRemove};
    $s{rcptReport2} =
      $AllStats{rcptReportSpam} +
      $AllStats{rcptReportHam} +
      $AllStats{rcptReportWhitelistAdd} +
      $AllStats{rcptReportWhitelistRemove} +
      $AllStats{rcptReportRedlistAdd} +
      $AllStats{rcptReportRedlistRemove};
    $s{rcptAcceptedTotal}  = $s{rcptAcceptedLocal} + $s{rcptAcceptedRemote} + $s{rcptUnprocessed} + $s{rcptReport};
    $s{rcptAcceptedTotal2} = $s{rcptAcceptedLocal2} + $s{rcptAcceptedRemote2} + $s{rcptUnprocessed2} + $s{rcptReport2};
    $s{rcptRejectedLocal} =
      $Stats{rcptNonexistent} +
      $Stats{rcptDelayed} +
      $Stats{rcptDelayedLate} +
      $Stats{rcptDelayedExpired} +
      $Stats{rcptEmbargoed} +
      $Stats{rcptSpamBucket};
    $s{rcptRejectedLocal2} =
      $AllStats{rcptNonexistent} +
      $AllStats{rcptDelayed} +
      $AllStats{rcptDelayedLate} +
      $AllStats{rcptDelayedExpired} +
      $AllStats{rcptEmbargoed} +
      $AllStats{rcptSpamBucket};
    $s{rcptRejectedRemote}  = $Stats{rcptRelayRejected};
    $s{rcptRejectedRemote2} = $AllStats{rcptRelayRejected};
    $s{rcptRejectedTotal}   = $s{rcptRejectedLocal} + $s{rcptRejectedRemote};
    $s{rcptRejectedTotal2}  = $s{rcptRejectedLocal2} + $s{rcptRejectedRemote2};
    $s{rcptTotal}           = $s{rcptAcceptedTotal} + $s{rcptRejectedTotal};
    $s{rcptTotal2}          = $s{rcptAcceptedTotal2} + $s{rcptRejectedTotal2};
    $s{msgAcceptedTotal} = $Stats{bhams} + $Stats{whites} + $Stats{locals} + $Stats{noprocessing} + $Stats{spamlover};
    $s{msgAcceptedTotal2} =
      $AllStats{bhams} + $AllStats{whites} + $AllStats{locals} + $AllStats{noprocessing} + $AllStats{spamlover};
    $s{msgRejectedTotal} =
      $Stats{bspams} +
      $Stats{blacklisted} +
      $Stats{helolisted} +
      $Stats{spambucket} +
      $Stats{penaltytrap} +
      $Stats{viri} +
      $Stats{internaladdresses} +
      $Stats{smtpConnDenied} +
      $Stats{smtpConnDomainIP} +
      $Stats{smtpConnLimitFreq} +
      $Stats{viridetected} +
      $Stats{bombs} +
      $Stats{froms} +
      $Stats{dkim} +
      $Stats{msgverify} +
      $Stats{bombSender} +
      $Stats{bombBlack} +
      $Stats{invalidHelo} +
      $Stats{ptrMissing} +
      $Stats{ptrInvalid} +
      $Stats{mxaMissing} +
      $Stats{forgedHelo} +
      $Stats{pbdenied} +
      $Stats{pbextreme} +
      $Stats{denyConnection} +
      $Stats{sbblocked} +
      $Stats{msgscoring} +
      $Stats{senderInvalidLocals} +
      $Stats{scripts} +
      $Stats{spffails} +
      $Stats{rblfails} +
      $Stats{uriblfails} +
      $Stats{msgMSGIDtrErrors} +
      $Stats{msgBackscatterErrors} +
      $Stats{msgMaxErrors} +
      $Stats{msgDelayed} +
      $Stats{msgNoRcpt} +
      $Stats{msgNoSRSBounce};
    $s{msgRejectedTotal2} =
      $AllStats{bspams} +
      $AllStats{blacklisted} +
      $AllStats{helolisted} +
      $AllStats{spambucket} +
      $AllStats{penaltytrap} +
      $AllStats{viri} +
      $AllStats{internaladdresses} +
      $AllStats{smtpConnDenied} +
      $AllStats{smtpConnDomainIP} +
      $AllStats{smtpConnLimitFreq} +
      $AllStats{viridetected} +
      $AllStats{bombs} +
      $AllStats{froms} +
      $AllStats{dkim} +
      $AllStats{msgverify} +
      $AllStats{bombSender} +
      $AllStats{bombBlack} +
      $AllStats{ptrMissing} +
      $AllStats{ptrInvalid} +
      $AllStats{mxaMissing} +
      $AllStats{forgedHelo} +
      $AllStats{invalidHelo} +
      $AllStats{pbdenied} +
      $AllStats{pbextreme} +
      $AllStats{denyConnection} +
      $AllStats{msgscoring} +
      $AllStats{senderInvalidLocals} +
      $AllStats{scripts} +
      $AllStats{spffails} +
      $AllStats{rblfails} +
      $AllStats{uriblfails} +
      $AllStats{msgMSGIDtrErrors} +
      $AllStats{msgBackscatterErrors} +
      $AllStats{msgMaxErrors} +
      $AllStats{msgDelayed} +
      $AllStats{msgNoRcpt} +
      $AllStats{msgNoSRSBounce};
    $s{msgTotal}  = $s{msgAcceptedTotal} + $s{msgRejectedTotal};
    $s{msgTotal2} = $s{msgAcceptedTotal2} + $s{msgRejectedTotal2};
    %s;
  }

sub ConfigStats {
    SaveStats();
    my %tots = statsTotals();
    my $upt  = ( time - $Stats{starttime} ) / ( 24 * 3600 );
    my $upt2 = ( time - $AllStats{starttime} ) / ( 24 * 3600 );

    my $uptime    = getTimeDiffAsString( time - $Stats{starttime}, 1 );
    my $resettime = localtime( $AllStats{starttime} );
    my $uptime2   = getTimeDiffAsString( time - $AllStats{starttime} );
    my $mpd       = sprintf( "%.1f", $upt == 0 ? 0 : $tots{msgTotal} / $upt );
    my $mpd2      = sprintf( "%.1f", $upt2 == 0 ? 0 : $tots{msgTotal2} / $upt2 );
    my $pct       = sprintf( "%.1f",
        $tots{msgTotal} - $Stats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal} / ( $tots{msgTotal} - $Stats{locals} ) );
    my $pct2 = sprintf( "%.1f",
        $tots{msgTotal2} - $AllStats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal2} / ( $tots{msgTotal2} - $AllStats{locals} ) );
    my $cpu = $CanStatCPU ? sprintf( "%.2f\%", 100 * $cpuUsage ) : 'n/a';
    my $cpuAvg = sprintf( " (%.2f\% avg)", $Stats{cpuTime} == 0 ? 0 : 100 * $Stats{cpuBusyTime} / $Stats{cpuTime} )
      if $CanStatCPU;
    my $cpuAvg2 =
      $CanStatCPU
      ? sprintf(
        "%.2f\% avg", $AllStats{cpuTime} == 0
        ? 0
        : 100 * $AllStats{cpuBusyTime} / $AllStats{cpuTime}
      )
      : 'n/a';

    my $LocalDNSStatus;

    if ($UseLocalDNS) {

        $LocalDNSStatus = "Local DNS Servers in use";
      } else {

        $LocalDNSStatus = "Custom DNS Servers in use";
      }

    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<script type=\"text/javascript\">
<!--
  function toggleTbody(id) {
    if (document.getElementById) {
      var tbod = document.getElementById(id);
      if (tbod && typeof tbod.className == 'string') {
        if (tbod.className == 'off') {
          tbod.className = 'on';
        } else {
          tbod.className = 'off';
        }
      }
    }
    return false;
  }
//-->
</script>
   <div class="content">
      <h2>
        ASSP Information and Statistics
      </h2><br />
      <table class="statBox">
      <thead>
          <tr>
            <td colspan="5" class="sectionHeader" onmousedown=
            "toggleTbody('StatItem0')">
              Server Information
            </td>
          </tr>
        </thead>
 
        <tbody id="StatItem0" class="off">
          <tr>
            <td class="statsOptionTitle">
              Server Name:
            </td>
            <td class="statsOptionValue" colspan="2">
              $localhostname
            </td>
            <td class="statsOptionValue" colspan="2">
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Server OS:
            </td>
            <td class="statsOptionValue" colspan="2">
              $^O
            </td>
            <td class="statsOptionValue" colspan="2">
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Server IP:
            </td>
            <td class="statsOptionValue" colspan="2">
              $localhostip
            </td>
            <td class="statsOptionValue" colspan="2">
              &nbsp;
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              DNS Servers:
            </td>
            <td class="statsOptionValue" colspan="2">
              $nameserversrt
            </td>
            <td class="statsOptionValue" colspan="2">
				$LocalDNSStatus
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Perl Version:
            </td>
            <td class="statsOptionValue" colspan="2">
              $]
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://www.perl.org/get.html" rel=
              "external">Perl.org</a>
            </td>
          </tr>
          <tr>
            <td  class="statsOptionTitle">
              ASSP Version:
            </td>
            <td class="statsOptionValue" colspan="2">
              $version$modversion
            </td>
            <td class="statsOptionValueC">
              <a href=
              "http://sourceforge.net/project/showfiles.php?group_id=69172"
              rel="external">release</a>
            </td>
            <td class="statsOptionValueC">
              <a href="http://www.iworld.de/homes/fb/ASSP/" rel=
              "external">beta</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              &nbsp;
            </td>
            <td class="statsOptionValueC" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>downloads</em></font>
            </td>
          </tr>
        </tbody>
        <tbody>
          <tr>
            <td class="sectionHeader" onmousedown="toggleTbody('StatItem2')"
            colspan="5">
              Perl Modules
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem2" class="off">
          <tr>
            <td class="statsOptionTitle">
              Compress::Zlib
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerCompressZlib
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Compress::Zlib" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Digest::MD5
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerDigestMD5
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Digest::MD5" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Email::Valid
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerEmailValid
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Email::Valid" rel=
              "external">CPAN</a>
            </td>
          </tr>
           <tr>
            <td class="statsOptionTitle">
              Email::MIME::Modifier
            </td>
            <td class="statsOptionValue" >
              $VerEMM
            </td>
            <td class="statsOptionValue" >
              $CommentEMM
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Email::MIME::Modifier" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              File::ReadBackwards
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerFileReadBackwards
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=File::ReadBackwards"
              rel="external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              File::Scan::ClamAV
            </td>
            <td class="statsOptionValue" >
              $VerAvClamd
            </td>
             <td class="statsOptionValue">
              $CommentAvClamd
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=File::Scan::ClamAV"
              rel="external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              LWP::Simple
            </td>
            <td class="statsOptionValue">
              $VerLWP
            </td>
            <td class="statsOptionValue">
              $CommentLWP
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://search.cpan.org/search?query=LWP::Simple">CPAN</a>
            </td>
          </tr>
          
          <tr>
            <td class="statsOptionTitle">
              Mail::SPF::Query
            </td>
            <td class="statsOptionValue" >
              $VerMailSPF
            </td>
            <td class="statsOptionValue" >
              $CommentMailSPF
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Mail::SPF::Query"
              rel="external">CPAN</a>
            </td>
          </tr>
           <tr>
            <td class="statsOptionTitle">
              Mail::SPF
            </td>
            <td class="statsOptionValue">
              $VerMailSPF2
            </td>
            <td class="statsOptionValue">
              $CommentMailSPF2
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Mail::SPF"
              rel="external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Mail::SRS
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerMailSRS
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Mail::SRS" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::CIDR::Lite
            </td>
            <td class="statsOptionValue" >
              $VerCIDRlite
            </td>
            <td class="statsOptionValue" >
              $CommentCIDRlite
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://search.cpan.org/search?query=Net::CIDR::Lite">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::DNS
            </td>
            <td class="statsOptionValue" >
              $VerNetDNS
            </td>
            <td class="statsOptionTitle">
              $CommentNetDNS
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Net::DNS" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::SMTP
            </td>
            <td class="statsOptionValue" >
              $VerNetSMTP
            </td>
            <td class="statsOptionValue" >
              $CommentNetSMTP
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Net::SMTP" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::IP::Match::Regexp
            </td>
            <td class="statsOptionValue" >
              $VerCIDR
            </td>
            <td class="statsOptionValue" >
              $CommentCIDR
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://search.cpan.org/search?query=Net::IP::Match::Regexp">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::LDAP
            </td>
            <td class="statsOptionValue" >
              $VerNetLDAP
            </td>
            <td class="statsOptionValue" >
              $CommentNetLDAP
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Net::LDAP" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::SenderBase
            </td>
            <td class="statsOptionValue" >
              $VerSenderBase
            </td>
            <td class="statsOptionValue" >
              $CommentSenderBase
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://search.cpan.org/search?query=Net::SenderBase">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Sys::Syslog
            </td>
            <td class="statsOptionValue" >
              $VerSysSyslog
            </td>
            <td class="statsOptionValue" >
              $CommentSysSyslog
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Sys::Syslog" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Net::Syslog
            </td>
            <td class="statsOptionValue" >
              $VerNetSyslog
            </td>
            <td class="statsOptionValue" >
              $CommentNetSyslog
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Net::Syslog" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Tie::RDBM
            </td>
            <td class="statsOptionValue" >
              $VerRDBM
            </td>
             <td class="statsOptionValue" >
              $CommentRDBM
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://search.cpan.org/search?query=Tie::RDBM">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Time::HiRes
            </td>
            <td class="statsOptionValue" >
              $VerTimeHiRes
            </td>
             <td class="statsOptionValue" >
              $CommentTimeHiRes
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a href="http://search.cpan.org/search?query=Time::HiRes" rel=
              "external">CPAN</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Win32::Daemon
            </td>
            <td class="statsOptionValue" colspan="2">
              $VerWin32Daemon
            </td>
            <td class="statsOptionValueC" colspan="2">
              <a rel="external" href=
              "http://www.roth.net/perl/Daemon/">roth.net</a>
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              &nbsp;
            </td>
            <td class="statsOptionValueC" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>downloads</em></font>
            </td>
          </tr>
        </tbody>
    
        <tbody>
          <tr>
            <td class="sectionHeader" onmousedown="toggleTbody('StatItem3')"
            colspan="5">
              General Runtime Information
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem3" class="on">
          <tr>
            <td class="statsOptionTitle">
              ASSP Proxy Uptime:
            </td>
            <td class="statsOptionValue" colspan="2">
              $uptime 
            </td>
            <td class="statsOptionValue" colspan="2">
              $uptime2
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Messages Processed:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgTotal} ($mpd per day)
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgTotal2} ($mpd2 per day)
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Non-Local Mail Blocked:
            </td>
            <td class="statsOptionValue" colspan="2">
              $pct%
            </td>
            <td class="statsOptionValue" colspan="2">
              $pct2%
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              CPU Usage:
            </td>
            <td class="statsOptionValue" colspan="2">
              $cpu$cpuAvg
            </td>
            <td class="statsOptionValue" colspan="2">
              $cpuAvg2
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Concurrent SMTP Sessions:
            </td>
            <td class="statsOptionValue" colspan="2">
              $smtpConcurrentSessions ($Stats{smtpMaxConcurrentSessions} max)
            </td>
            <td class="statsOptionValue" colspan="2">
              $AllStats{smtpMaxConcurrentSessions} max
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since restart at $starttime</em></font>
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since reset at $resettime</em></font>
            </td>
          </tr>
        </tbody>
        <tbody>
          <tr>
            <td colspan="5" class="sectionHeader" onmousedown=
            "toggleTbody('StatItem4')">
              Totaled Statistics
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem4" class="off">
          <tr>
            <td class="statsOptionTitle">
              SMTP Connections Received:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;SMTP Connections Accepted:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnAcceptedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnAcceptedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;SMTP Connections Rejected:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnRejectedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{smtpConnRejectedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Envelope Recipients Processed:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Envelope Recipients Accepted:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptAcceptedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptAcceptedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Envelope Recipients Rejected:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptRejectedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{rcptRejectedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Messages Processed:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Messages Passed:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgAcceptedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgAcceptedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Messages Rejected:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgRejectedTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{msgRejectedTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Admin Connections Received:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{admConnTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{admConnTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Admin Connections Accepted:
            </td>
            <td class="statsOptionValue" colspan="2">
              $Stats{admConn}
            </td>
            <td class="statsOptionValue" colspan="2">
              $AllStats{admConn}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Admin Connections Rejected:
            </td>
            <td class="statsOptionValue" colspan="2">
              $Stats{admConnDenied}
            </td>
            <td class="statsOptionValue" colspan="2">
              $AllStats{admConnDenied}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Stat Connections Received:
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{statConnTotal}
            </td>
            <td class="statsOptionValue" colspan="2">
              $tots{statConnTotal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Stat Connections Accepted:
            </td>
            <td class="statsOptionValue" colspan="2">
              $Stats{statConn}
            </td>
            <td class="statsOptionValue" colspan="2">
              $AllStats{statConn}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Stat Connections Rejected:
            </td>
            <td class="statsOptionValue" colspan="2">
              $Stats{statConnDenied}
            </td>
            <td class="statsOptionValue" colspan="2">
              $AllStats{statConnDenied}
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since restart at $starttime</em></font>
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since reset at $resettime</em></font>
            </td>
          </tr>
        </tbody>
        <tbody>
          <tr>
            <td colspan="5" class="sectionHeader" onmousedown=
            "toggleTbody('StatItem5')">
              SMTP Connection Statistics
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem5" class="off">
          <tr>
            <td class="statsOptionTitle">
              Accepted Logged SMTP Connections:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{smtpConn}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{smtpConn}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Not Logged SMTP Connections:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{smtpConnNotLogged}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{smtpConnNotLogged}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              SMTP Connection Limits:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{smtpConnLimit}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{smtpConnLimit2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Overall Limits:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{smtpConnLimit}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{smtpConnLimit}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;By IP Limits:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{smtpConnLimitIP}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{smtpConnLimitIP}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;By IP Frequency Limits:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{smtpConnLimitFreq}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{smtpConnLimitFreq}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;By Domain IP Limits:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{smtpConnDomainIP}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{smtpConnDomainIP}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              SMTP Connections Timeout:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{smtpConnIdleTimeout}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{smtpConnIdleTimeout2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Denied SMTP Connections (enforced Extreme):
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{smtpConnDenied}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{smtpConnDenied}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Denied SMTP Connections (strict):
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{denyConnectionA}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{denyConnectionA}
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since restart at $starttime</em></font>
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since reset at $resettime</em></font>
            </td>
          </tr>
        </tbody>
        <tbody>
          <tr>
            <td colspan="5" class="sectionHeader" onmousedown=
            "toggleTbody('StatItem6')">
              Envelope Recipient Statistics
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem6" class="off">
          <tr>
            <td class="statsOptionTitle">
              Local Recipients Accepted:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptAcceptedLocal}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptAcceptedLocal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Validated Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptValidated}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptValidated}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Unchecked Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptUnchecked}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptUnchecked}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;SpamLover Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptSpamLover}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptSpamLover}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Remote Recipients Accepted:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptAcceptedRemote}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptAcceptedRemote2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Whitelisted Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptWhitelisted}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptWhitelisted}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Not Whitelisted Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptNotWhitelisted}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptNotWhitelisted}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Noprocessed Recipients:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptUnprocessed}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptUnprocessed}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Email Reports:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptReport}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $tots{rcptReport2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Spam Reports:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportSpam}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportSpam}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Ham Reports:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportHam}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportHam}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Whitelist Additions:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportWhitelistAdd}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportWhitelistAdd}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Whitelist Deletions:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportWhitelistRemove}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportWhitelistRemove}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Redlist Additions:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportRedlistAdd}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportRedlistAdd}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Redlist Deletions:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportRedlistRemove}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportRedlistRemove}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Analyze Reports:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportAnalyze}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportAnalyze}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Help Reports:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{rcptReportHelp}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{rcptReportHelp}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Local Recipients Rejected:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{rcptRejectedLocal}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{rcptRejectedLocal2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Nonexistent Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptNonexistent}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptNonexistent}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Delayed Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptDelayed}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptDelayed}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Delayed (Late) Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptDelayedLate}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptDelayedLate}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Delayed (Expired) Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptDelayedExpired}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptDelayedExpired}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Embargoed Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptEmbargoed}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptEmbargoed}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Spam Bucketed Recipients:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptSpamBucket}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptSpamBucket}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Remote Recipients Rejected:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{rcptRejectedRemote}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $tots{rcptRejectedRemote2}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              &nbsp;&nbsp;&nbsp;&nbsp;Relay Attempts Rejected:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rcptRelayRejected}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rcptRelayRejected}
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since restart at $starttime</em></font>
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since reset at $resettime</em></font>
            </td>
          </tr>
        </tbody>
        <tbody>
          <tr>
            <td colspan="5" class="sectionHeader" onmousedown=
            "toggleTbody('StatItem7')">
              Message Statistics
            </td>
          </tr>
        </tbody>
        <tbody id="StatItem7" class="on">
          <tr>
            <td class="statsOptionTitle">
              Message OK:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{bhams}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{bhams}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Whitelisted:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{whites}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{whites}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Local:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{locals}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{locals}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Noprocessing:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{noprocessing}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{noprocessing}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Spamlover Spams Passed:
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $Stats{spamlover}
            </td>
            <td class="statsOptionValue positive" colspan="2">
              $AllStats{spamlover}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Bayesian Spams:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{bspams}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{bspams}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Domains Blacklisted:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{blacklisted}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{blacklisted}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              HELO Blacklisted:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{helolisted}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{helolisted}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              HELO Invalid:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{invalidHelo}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{invalidHelo}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              HELO Forged:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{forgedHelo}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{forgedHelo}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Missing MX and A Record:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{mxaMissing}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{mxaMissing}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Missing PTR Record:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{ptrMissing}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{ptrMissing}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Invalid PTR Record:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{ptrInvalid}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{ptrInvalid}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Spam Collect Messages:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{spambucket}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{spambucket}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Penalty Trap Messages:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{penaltytrap}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{penaltytrap}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Bad Attachments:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{viri}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{viri}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Viruses Detected:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{viridetected}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{viridetected}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Sender Regex:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{bombSender}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{bombSender}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Black Regex:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{bombBlack}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{bombBlack}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Bomb Regex:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{bombs}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{bombs}
            </td>
          </tr>

          <tr>
            <td class="statsOptionTitle">
              PenaltyBox:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{pbdenied}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{pbdenied}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              PenaltyBox Extreme:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{pbextreme}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{pbextreme}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Deny Connection:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{denyConnection}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{denyConnection}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              CountryCode blocked:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{sbblocked}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{sbblocked}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Message Scoring:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgscoring}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgscoring}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Invalid Local Sender:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{senderInvalidLocals}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{senderInvalidLocals}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Invalid Internal Mail:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{internaladdresses}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{internaladdresses}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Scripts:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{scripts}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{scripts}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              SPF Failures:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{spffails}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{spffails}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              RBL Failures:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{rblfails}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{rblfails}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              URIBL Failures:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{uriblfails}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{uriblfails}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Max Errors Exceeded:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgMaxErrors}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgMaxErrors}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              BackScatter Errors:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgBackscatterErrors}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgBackscatterErrors}
            </td>
          </tr>
          
          <tr>
            <td class="statsOptionTitle">
              Delayed/Greylisted:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgDelayed}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgDelayed}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Empty Recipient:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgNoRcpt}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgNoRcpt}
            </td>
          </tr>
          <tr>
            <td class="statsOptionTitle">
              Unsigned SRS Bounces:
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $Stats{msgNoSRSBounce}
            </td>
            <td class="statsOptionValue negative" colspan="2">
              $AllStats{msgNoSRSBounce}
            </td>
          </tr>
          <tr>
            <td class="statsOptionValue" style="background-color: #FFFFFF">
              &nbsp;
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since restart at $starttime</em></font>
            </td>
            <td class="statsOptionValue" style="background-color: #FFFFFF"
            colspan="2">
              <font size="1" color="#C0C0C0"><em>since reset at $resettime</em></font>
            </td>
          </tr>
        </tbody>
        
      </table><br />
      $kudos<br />
    </div>
</body></html>
EOT
  }

sub ConfigStatsRaw {
    SaveStats();
    my %tots    = statsTotals();
    my $upt     = ( time - $Stats{starttime} ) / ( 24 * 3600 );
    my $upt2    = ( time - $AllStats{starttime} ) / ( 24 * 3600 );
    my $uptime  = sprintf( "%.3f", $upt );
    my $uptime2 = sprintf( "%.3f", $upt2 );
    my $mpd     = sprintf( "%.1f", $upt == 0 ? 0 : $tots{msgTotal} / $upt );
    my $mpd2    = sprintf( "%.1f", $upt2 == 0 ? 0 : $tots{msgTotal2} / $upt2 );
    my $pct     = sprintf( "%.1f",
        $tots{msgTotal} - $Stats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal} / ( $tots{msgTotal} - $Stats{locals} ) );
    my $pct2 = sprintf( "%.1f",
        $tots{msgTotal2} - $AllStats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal2} / ( $tots{msgTotal2} - $AllStats{locals} ) );
    my $cpu = $CanStatCPU ? sprintf( "%.2f\%", 100 * $cpuUsage ) : 'n/a';
    my $cpuAvg = sprintf( " (%.2f\% avg)", $Stats{cpuTime} == 0 ? 0 : 100 * $Stats{cpuBusyTime} / $Stats{cpuTime} )
      if $CanStatCPU;
    my $cpuAvg2 =
      $CanStatCPU
      ? sprintf(
        "%.2f\% avg", $AllStats{cpuTime} == 0
        ? 0
        : 100 * $AllStats{cpuBusyTime} / $AllStats{cpuTime}
      )
      : 'n/a';
    <<EOT;
$headerHTTP
ASSP Proxy Uptime | $uptime days| $uptime2 days 
Messages Processed | $tots{msgTotal} ($mpd per day) | $tots{msgTotal2} ($mpd2 per day)
Non-Local Mail Blocked | $pct% | $pct2%
CPU Usage | $cpu$cpuAvg | $cpuAvg2
Concurrent SMTP Sessions | $smtpConcurrentSessions ($Stats{smtpMaxConcurrentSessions} max) | $AllStats{smtpMaxConcurrentSessions} max


SMTP Connections Received | $tots{smtpConnTotal} | $tots{smtpConnTotal2}
SMTP Connections Accepted | $tots{smtpConnAcceptedTotal} | $tots{smtpConnAcceptedTotal2}
SMTP Connections Rejected | $tots{smtpConnRejectedTotal} | $tots{smtpConnRejectedTotal2}
Envelope Recipients Processed | $tots{rcptTotal} | $tots{rcptTotal2}
Envelope Recipients Accepted | $tots{rcptAcceptedTotal} | $tots{rcptAcceptedTotal2}
Envelope Recipients Rejected | $tots{rcptRejectedTotal} | $tots{rcptRejectedTotal2}
Messages Processed | $tots{msgTotal} | $tots{msgTotal2}
Messages Passed | $tots{msgAcceptedTotal} | $tots{msgAcceptedTotal2}
Messages Rejected | $tots{msgRejectedTotal} | $tots{msgRejectedTotal2}
Admin Connections Received | $tots{admConnTotal} | $tots{admConnTotal2}
Admin Connections Accepted | $Stats{admConn} | $AllStats{admConn}
Admin Connections Rejected | $Stats{admConnDenied} | $AllStats{admConnDenied}
Stat Connections Received | $tots{statConnTotal} | $tots{statConnTotal2}
Stat Connections Accepted | $Stats{statConn} | $AllStats{statConn}
Stat Connections Rejected | $Stats{statConnDenied} | $AllStats{statConnDenied}


Accepted Logged SMTP Connections | $Stats{smtpConn} | $AllStats{smtpConn}
Not Logged SMTP Connections | $Stats{smtpConnNotLogged} | $AllStats{smtpConnNotLogged}
SMTP Connection Limits | $tots{smtpConnLimit} | $tots{smtpConnLimit2}
Overall Limits | $Stats{smtpConnLimit} | $AllStats{smtpConnLimit}
By IP Limits | $Stats{smtpConnLimitIP} | $AllStats{smtpConnLimitIP}
By IP Frequency Limits | $Stats{smtpConnLimitFreq} | $AllStats{smtpConnLimitFreq}
By Domain IP Limits | $Stats{smtpConnDomainIP} | $AllStats{smtpConnDomainIP}
SMTP Connections Timeout | $tots{smtpConnIdleTimeout} | $tots{smtpConnIdleTimeout2}
Denied SMTP Connections | $Stats{smtpConnDenied} | $AllStats{smtpConnDenied}

Local Recipients Accepted | $tots{rcptAcceptedLocal} | $tots{rcptAcceptedLocal2}
Validated Recipients | $Stats{rcptValidated} | $AllStats{rcptValidated}
Unchecked Recipients | $Stats{rcptUnchecked} | $AllStats{rcptUnchecked}
SpamLover Recipients | $Stats{rcptSpamLover} | $AllStats{rcptSpamLover}
Remote Recipients Accepted | $tots{rcptAcceptedRemote} | $tots{rcptAcceptedRemote2}
Whitelisted Recipients | $Stats{rcptWhitelisted} | $AllStats{rcptWhitelisted}
Not Whitelisted Recipients | $Stats{rcptNotWhitelisted} | $AllStats{rcptNotWhitelisted}
Noprocessed Recipients | $Stats{rcptUnprocessed} | $AllStats{rcptUnprocessed}
Email Reports | $tots{rcptReport} | $tots{rcptReport2}
Spam Reports | $Stats{rcptReportSpam} | $AllStats{rcptReportSpam}
Ham Reports | $Stats{rcptReportHam} | $AllStats{rcptReportHam}
Whitelist Additions | $Stats{rcptReportWhitelistAdd} | $AllStats{rcptReportWhitelistAdd}
Whitelist Deletions | $Stats{rcptReportWhitelistRemove} | $AllStats{rcptReportWhitelistRemove}
Redlist Additions | $Stats{rcptReportRedlistAdd} | $AllStats{rcptReportRedlistAdd}
Redlist Deletions | $Stats{rcptReportRedlistRemove} | $AllStats{rcptReportRedlistRemove}
Local Recipients Rejected | $tots{rcptRejectedLocal} | $tots{rcptRejectedLocal2}
Nonexistent Recipients | $Stats{rcptNonexistent} | $AllStats{rcptNonexistent}
Delayed Recipients | $Stats{rcptDelayed} | $AllStats{rcptDelayed}
Delayed (Late) Recipients | $Stats{rcptDelayedLate} | $AllStats{rcptDelayedLate}
Delayed (Expired) Recipients | $Stats{rcptDelayedExpired} | $AllStats{rcptDelayedExpired}
Embargoed Recipients | $Stats{rcptEmbargoed} | $AllStats{rcptEmbargoed}
Spam Bucketed Recipients | $Stats{rcptSpamBucket} | $AllStats{rcptSpamBucket}
Remote Recipients Rejected | $tots{rcptRejectedRemote} | $tots{rcptRejectedRemote2}
Relay Attempts Rejected | $Stats{rcptRelayRejected} | $AllStats{rcptRelayRejected}


Bayesian Hams | $Stats{bhams} | $AllStats{bhams}
Whitelisted | $Stats{whites} | $AllStats{whites}
Local | $Stats{locals} | $AllStats{locals}
Noprocessing | $Stats{noprocessing} | $AllStats{noprocessing}
Spamlover Spams Passed | $Stats{spamlover} | $AllStats{spamlover}
Bayesian Spams | $Stats{bspams} | $AllStats{bspams}
Domains Blacklisted | $Stats{blacklisted} | $AllStats{blacklisted}
HELO Blacklisted | $Stats{helolisted} | $AllStats{helolisted}
HELO Invalid | $Stats{invalidHelo} | $AllStats{invalidHelo}
HELO Forged | $Stats{forgedHelo} | $AllStats{forgedHelo}
Missing MX | $Stats{mxaMissing} | $AllStats{mxaMissing}
Missing PTR | $Stats{ptrMissing} | $AllStats{ptrMissing}
Invalid PTR | $Stats{ptrInvalid} | $AllStats{ptrInvalid}
Spam Collect Messages | $Stats{spambucket} | $AllStats{spambucket}
Penalty Trap Messages | $Stats{penaltytrap} | $AllStats{penaltytrap}
Bad Attachments | $Stats{viri} | $AllStats{viri}
Viruses Detected | $Stats{viridetected} | $AllStats{viridetected}
Sender Regex | $Stats{bombSender} | $AllStats{bombSender}
Bomb Regex | $Stats{bombs} | $AllStats{bombs}
PenaltyBox | $Stats{pbdenied} | $AllStats{pbdenied}
Message Scoring | $Stats{msgscoring} | $AllStats{msgscoring}
Invalid Local Sender | $Stats{senderInvalidLocals} | $AllStats{senderInvalidLocals}
Invalid Internal Mail | $Stats{internaladdresses} | $AllStats{internaladdresses}
Scripts | $Stats{scripts} | $AllStats{scripts}
SPF Failures | $Stats{spffails} | $AllStats{spffails}
RBL Failures | $Stats{rblfails} | $AllStats{rblfails}
URIBL Failures | $Stats{uriblfails} | $AllStats{uriblfails}
Max Errors Exceeded | $Stats{msgMaxErrors} | $AllStats{msgMaxErrors}
Delayed | $Stats{msgDelayed} | $AllStats{msgDelayed}
Empty Recipient | $Stats{msgNoRcpt} | $AllStats{msgNoRcpt}
Not SRS Signed Bounces | $Stats{msgNoSRSBounce} | $AllStats{msgNoSRSBounce}

EOT
  }

sub ConfigStatsXml {

    # must pass by ref
    my ( $href, $qsref ) = @_;
    my %head = %$href;
    my %qs   = %$qsref;

    my %totStats = &ComputeStatTotals;
    my %tots     = statsTotals(%totStats);

    my $statstart  = localtime( $Stats{starttime} );
    my $statstart2 = localtime( $totStats{starttime} );

    my $tstatstime = ( time - $totStats{starttime} ) / ( 24 * 3600 );
    my $cstatstime = ( time - $Stats{starttime} ) /    ( 24 * 3600 );

    my $uptime = getTimeDiffAsString( time - $starttime, 1 );
    my $uptime2 = getTimeDiffAsString( time - $totStats{starttime} );

    my $mpd  = sprintf( "%.1f", $cstatstime == 0 ? 0 : $tots{msgTotal} / $cstatstime );
    my $mpd2 = sprintf( "%.1f", $tstatstime == 0 ? 0 : $tots{msgTotal2} / $tstatstime );
    my $pct  = sprintf( "%.1f",
        $tots{msgTotal} - $Stats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal} / ( $tots{msgTotal} - $Stats{locals} ) );
    my $pct2 = sprintf( "%.1f",
        $tots{msgTotal2} - $totStats{locals} == 0
        ? 0
        : 100 * $tots{msgRejectedTotal2} / ( $tots{msgTotal2} - $totStats{locals} ) );
    my $cpu = $CanStatCPU ? sprintf( "%.2f\%", 100 * $cpuUsage ) : 'na';
    my $cpuAvg =
      $CanStatCPU
      ? sprintf( "%.2f\%", $Stats{cpuTime} == 0 ? 0 : 100 * $Stats{cpuBusyTime} / $Stats{cpuTime} )
      : 'na';
    my $cpuAvg2 =
      $CanStatCPU
      ? sprintf(
        "%.2f\%", $totStats{cpuTime} == 0
        ? 0
        : 100 * $totStats{cpuBusyTime} / $totStats{cpuTime}
      )
      : 'na';

    my $r = '';
    foreach my $k ( keys %tots ) {
        next unless $k;

        my $s = $k;
        if ( $s =~ tr/2//d ) {
            $r .= "<stat name='$s' type='cumulativetotal'>$tots{$k}</stat>";
          } else {
            $r .= "<stat name='$s' type='currenttotal'>$tots{$k}</stat>";
          }
      }
    foreach my $k ( keys %Stats ) {
        next unless $k;
        $r .= "<stat name='$k' type='currentstat'>$Stats{$k}</stat>";
      }
    foreach my $k ( keys %totStats ) {
        next unless $k;
        $r .= "<stat name='$k' type='cumulativestat'>$totStats{$k}</stat>";
      }

    <<EOT;
$headerHTTP

<?xml version='1.0' encoding='UTF-8'?>
<stats>
<stat name='statstart' type='currentstat'>$statstart</stat>
<stat name='statstart' type='cumulativestat'>$statstart2</stat>
<stat name='uptime' type='currentstat'>$uptime</stat>
<stat name='uptime' type='cumulativestat'>$uptime2</stat>
<stat name='msgPerDay' type='currentstat'>$mpd</stat>
<stat name='msgPerDay' type='cumulativestat'>$mpd2</stat>
<stat name='pctBlocked' type='currentstat'>$pct</stat>
<stat name='pctBlocked' type='cumulativestat'>$pct2</stat>
<stat name='cpuAvg' type='currentstat'>$cpuAvg</stat>
<stat name='cpuAvg' type='cumulativestat'>$cpuAvg2</stat>
<stat name='smtpConcurrentSessions' type='currentstat'>$smtpConcurrentSessions</stat>
$r
</stats>
EOT

  }

sub ConfigLists {
    my $s;
    my $a;
    my $act = $qs{action};
    if ($act) {
        if ( $qs{list} eq 'tuplets' ) {
            my $ip;
            my $hash;
            my $t;
            my $interval;
            my $intervalFormatted;
            while ( $qs{addresses} =~ /(\d+\.\d+\.\d+\.\d+),<?(?:$EmailAdrRe\@)?($EmailDomainRe|)>?/go ) {
                $ip = ipNetwork( $1, ( $DelayUseNetblocks ? 24 : 32 ) );
                $a = lc $2;
                if ($DelayNormalizeVERPs) {

                    # strip extension
                    $a =~ s/\+.*(?=@)//;

                    # replace numbers with '#'
                    $a =~ s/\b\d+\b(?=.*@)/#/g;
                  }

                # get sender domain
                $a =~ s/.*@//;
                $hash = "$ip $a";
                $hash = Digest::MD5::md5_hex($hash)
                  if $CanUseMD5Keys && $DelayMD5;
                $t = time;
                $s .= "<div class=\"text\">($ip,$a) ";
                if ( $act eq 'v' ) {

                    if ( !exists $DelayWhite{$hash} ) {
                        $s .= "<span class=\"negative\">tuplet NOT safelisted</span>";
                      } else {
                        $interval          = $t - $DelayWhite{$hash};
                        $intervalFormatted = formatTimeInterval($interval);
                        if ( $interval < $DelayExpiryTime * 24 * 3600 ) {
                            $s .= "tuplet safelisted, age: $intervalFormatted";
                          } else {
                            $s .= "tuplet expired, age: $intervalFormatted";
                          }
                      }
                  } elsif ( $act eq 'a' ) {
                    if ( !exists $DelayWhite{$hash}
                        || ( $t - $DelayWhite{$hash} >= $DelayExpiryTime * 24 * 3600 ) ) {
                        if ( localmail( '@' . $a ) ) {
                            $s .= "<span class=\"negative\">local addresses not allowed on safelisted tuplets</span>";
                          } else {
                            $s .= "tuplet added";
                            $DelayWhite{$hash} = $t;
                            mlog( 0, "AdminInfo: safelisted tuplets addition: ($ip,$a) (admin)" );
                          }
                      } else {
                        $s .= "<span class=\"positive\">tuplet already safelisted</span>";
                      }
                  } elsif ( $act eq 'r' ) {
                    if ( !exists $DelayWhite{$hash} ) {
                        $s .= "<span class=\"negative\">tuplet NOT safelisted</span>";
                      } else {
                        $interval          = $t - $DelayWhite{$hash};
                        $intervalFormatted = formatTimeInterval($interval);
                        if ( $interval < $DelayExpiryTime * 24 * 3600 ) {
                            $s .= "tuplet removed, age: $intervalFormatted";
                          } else {
                            $s .= "expired tuplet removed, age: $intervalFormatted";
                          }
                        delete $DelayWhite{$hash};
                        mlog( 0, "AdminInfo: safelisted tuplets deletion: ($ip,$a) (admin)" );
                      }
                  }
                $s .= "</div>\n";
              }
          } else {
            my $color = $qs{list} eq 'red' ? 'Red' : 'White';
            my $list = $color . "list";
            while ( $qs{addresses} =~ /($EmailAdrRe\@$EmailDomainRe)/go ) {
                $a = $1;
                $s .= "<div class=\"text\">$a ";
                $a = lc $a;
                if ( $act eq 'v' ) {
                    if ( $list->{$a} ) {
                        $s .= "${color}listed";
                      } else {
                        $s .= "<span class=\"negative\">NOT $qs{list}listed</span>";
                      }
                  } elsif ( $act eq 'a' ) {
                    if ( $list->{$a} ) {
                        $s .= "<span class=\"positive\">already $qs{list}listed</span>";
                      } else {

                        # if($color eq 'White' && localmail($a)) {
                        # $s.="<span class=\"negative\">local addresses not allowed on whitelist</span>";
                        # } else {
                        $s .= "added";
                        $list->{$a} = time;
                        mlog( 0, "AdminInfo: $qs{list}list addition: $a (admin)" );

                        # }
                      }
                  } elsif ( $act eq 'r' ) {
                    if ( $list->{$a} ) {
                        $s .= "removed";
                        delete $list->{$a};
                        mlog( 0, "AdminInfo: $qs{list}list deletion: $a (admin)" );
                      } else {
                        $s .= "not $qs{list}listed";
                      }
                  }
                $s .= "</div>\n";
              }
          }
      }
    if ( $qs{B1} =~ /^Show (.)/i ) {
        local $/ = "\n";
        if ( $1 eq 'R' ) {
            $qs{list} = "red";    # update radios
            $RedlistObject->flush() if $RedlistObject && $redlistdb !~ /mysql/;
            open( F, "<$base/$redlistdb" ) if $redlistdb !~ /mysql/;
            $s .= '<div class="textbox"><b>Redlist</b></div>';
            if ( $redlistdb =~ /mysql/ ) {
                $s .= '<div class="textbox"><b>mysql</b></div>';
                while ( my ($v) = each(%Redlist) ) {
                    my ( $a, $time ) = split( "\002", $v );
                    $s .= "<div class=\"textbox\">$a</div>";
                  }
              }
          } else {
            $qs{list} = "white";    # update radios
            $WhitelistObject->flush()
              if $WhitelistObject && $whitelistdb !~ /mysql/;
            open( F, "<$base/$whitelistdb" ) if $whitelistdb !~ /mysql/;
            $s .= '<div class="textbox"><b>Whitelist</b></div>';
            if ( $whitelistdb =~ /mysql/ ) {
                $s .= '<div class="textbox"><b>mysql</b></div>';
                while ( my ($v) = each(%Whitelist) ) {
                    my ( $a, $time ) = split( "\002", $v );
                    $s .= "<div class=\"textbox\">$a</div>";

                  }
              }
          }
        if ( $whitelistdb !~ /mysql/ ) {
            my $l;
            while ( $l = <F> ) {
                my ($a) = $l =~ /([^\002]*)/;
                $s .= "<div class=\"textbox\">$a</div>";
              }
            close F;
          }
      }
    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>Update or Verify the Whitelist/Redlist</h2>
$s
<form method="post" action=\"\">
    <table class="textBox" style="width: 99%;">
        <tr>
            <td class="noBorder">Do you want to work with the:
            </td>
            <td class="noBorder">
            <input type="radio" name="list" value="white"${\((!$qs{list} || $qs{list} eq 'white') ? ' checked="checked" ' : ' ')} /> Whitelist or<br />
            <input type="radio" name="list" value="red"${\($qs{list} eq 'red' ? ' checked="checked" ' : ' ')} /> Redlist or<br />
            <input type="radio" name="list" value="tuplets"${\($qs{list} eq 'tuplets' ? ' checked="checked" ' : ' ')} /> Tuplets
            </td>
        </tr>
        <tr>
            <td class="noBorder">Do you want to: </td>
            <td class="noBorder"><input type="radio" name="action" value="a" />add<br />
            <input type="radio" name="action" value="r" />remove<br />
            <input type="radio" checked="checked" name="action" value="v" />or verify</td>
            <td class="noBorder">
                List the addresses in this box:<br />
                (for tuplets put: ip-address,domain-name)<br />
                <p><textarea name="addresses" rows="5" cols="40" wrap="off">$qs{addresses}</textarea></p>
            </td>
        </tr>
        <tr>
            <td class="noBorder">&nbsp;</td>
            <td class="noBorder"><input type="submit" name="B1" value="  Submit  " /></td>
            <td class="noBorder">&nbsp;</td>
        </tr>
    </table>
</form>
<div class="textBox">
<p>Post less than 1 megabyte of data at a time.</p>
Note: The redlist is not a blacklist. The redlist is a list of addresses that cannot
contribute to the whitelist, and who are not considered local, even if their mail is
from a local computer. For example, if someone goes on a vacation and turns on their
email's autoresponder, put them on the redlist until they return. Then as they reply
to every spam they receive they won't corrupt your non-spam collection or whitelist.

  <form action="" method="post">
  <table style="width: 90%; margin-left: 5%;">
    <tr>
      <td align="center" class="noBorder"><input type="submit" name="B1" value="Show Whitelist" /></td>
      <td align="center" class="noBorder"><input type="submit" name="B1" value="Show Redlist" /></td>
    </tr>
  </table>
  </form>
      <p class="warning">Warning: If your whitelist or redlist is long, pushing these buttons
      is ill-advised. Use these for testing and while your whitelist is short.</p>
</div>
</div>
$footers
</body></html>
EOT
  }

sub SearchBomb {
    my ( $name, $srch ) = @_;
	my $mystatus;
    my $fil = $Config{"$name"};
    if ( $fil =~ /^\s*file:\s*(.+)\s*$/i ) {
        $fil = $1;
      } else {
        return 0;
      }
    open( BOMBFILE, "<$fil" );
    my $counter = 0;
    while ( my $i = <BOMBFILE> ) {
        $counter++;
        $i =~ s/#.*$//g;
        $i =~ s/\s*\n\s*//g;
        eval { $srch =~ m/($i)/i };
        mlog( 0, "ConfigError: regular expression error in line $counter of '$fil' for '$i': $@" ) if $@;
        next if $@;
        next if !$i;
        if ( $srch =~ m/($i)/i ) {
            return $i;
          }
      }
    close(BOMBFILE);
  }

sub ConfigAnalyze {
    my ( $ba, $st, $fm, %fm, %wl, $ip, $helo, $text, $ip3, $received );
    my $mail = $qs{mail};
    my $mystatus;
    my @t;
    my $ret;

    if ($mail) {
        my $name = $myName;
        $name =~ s/(\W)/\\$1/g;
        if ( $mail =~ /^ip=(\d+\.\d+\.\d+\.\d+)/ ) {

            $ip = $1;
            $mystatus="ip";
          } else {
            while ( $mail =~ /Received: from ([0-9\.]+).*?by\s+$name/isg ) {
                $ip = $1;
              }
          }

        if ( !$ip ) {
            while ( $mail =~ /Received: from.*?\(\[([0-9\.]+).*?helo=/isg ) {
                $ip = $1;
              }
          }

        ($ip3) = $ip =~ /(.*)\.\d+$/;
        if ( $mail =~ /^helo=(.+)/i ) {
            $helo = $1;
            $mystatus="helo";
          } else {
            while ( $mail =~ /helo=(\S+?)\)/isg ) {
                $helo = $1;
              }
          }
        if ( $mail =~ /^text=(.+)/i ) {
            $text = $1;
            $mystatus="text";
          } else {
            $text = $mail;
          }
        $fm .= "<div class=\"textBox\"><br />";
        eval {
        if ($ispHostnames) {
            while ( $mail =~ /(Received: from (.{1,50}) \(\[?(\d+\.\d+\.\d+\.\d+).{1,80}by.{1,20}($ispHostnamesRE))/gis ) {

                $helo = $2;
                $received = $1;
                $ip = $3;
                
                ($ip3) = $ip =~ /(.*)\.\d+$/;

              }
            $fm .= "<b><font color='orange'>&bull;</font>ISP/Secondary Header:</b>'$received'<br />\n"
              if $received;
            $fm .= "<b><font color='orange'>&bull;</font>Switched to ISP/Secondary IP:</b> '$ip'<br /><br />\n"
              if $received;
          }
		};
        $fm .= "<b><font size=\"3\" color=\"#003366\">Feature Matching:</font></b><br /><br />";
        while ( $mail =~ /($EmailAdrRe\@$EmailDomainRe)/go ) {
            my $a    = lc $1;
            my $mf   = $a;
            my $mfd  = $1 if $mf =~ /\@(.*)/;
            my $mfdd = $1 if $mf =~ /(\@.*)/;
            next if $fm{$a}++;
            my $r1 = matchSL( $mf, 'noProcessing' );

            if ($r1) {
                $fm .=
                  "<b><font color='orange'>&bull;</font> <a href='./#noProcessing'>NoProcessing</a></b>: '$mf'<br />\n";
              }
            if (   $BLDRE1 != ""
                && $blackListedDomains
                && $mf =~ ( '(' . $BLDRE1 . ')' ) ) {
                $fm .=
"<b><font color='red'>&bull;</font> <a href='./#blackListedDomains'>Blacklisted Domains</a></b>: '$1'<br />\n";
              }
            if (   $WLDRE != ""
                && $whiteListedDomains
                && $mf =~ ( '(' . $WLDRE . ')' ) ) {
                $fm .=
"<b><font color=#66CC66>&bull;</font> <a href='./#whiteListedDomains'>Whitelisted Domains</a></b>: '$1'<br />\n";
              }

            $fm .= "<b><font color='orange'>&bull;</font> <a href='./lists'>Redlist</a></b>: '$a'<br />\n"
              if $Redlist{$a};
            $fm .=
"<b><font color=#66CC66>&bull;</font> <a href='./lists'>Redlisted Domain/ Wildcard</a></b>: '$wildcardUser$mfdd'<br />\n"
              if $Redlist{"_all_$mfdd"};

            $fm .= "<b><font color=#66CC66>&bull;</font> <a href='./lists'>Whitelist</a></b>: '$a'<br />\n"
              if $Whitelist{$a};
            $fm .=
"<b><font color=#66CC66>&bull;</font> <a href='./lists'>Whitelisted WildcardDomain</a></b>: '$wildcardUser$mfdd'<br />\n"
              if $Whitelist{"$wildcardUser$mfdd"};

          }

        if ( $noSPFReRE && $text =~ ( '(' . $noSPFReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#noSPFRe'>No SPF RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "noSPFRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching noSPFRe($Config{'noSPFRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if ( $strictSPFReRE && $text =~ ( '(' . $strictSPFReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#strictSPFRe'>Strict SPF RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "strictSPFRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching strictSPFRe($Config{'strictSPFRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        
         if ( $blockstrictSPFReRE && $text =~ ( '(' . $blockstrictSPFReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#blockstrictSPFRe'>Block Strict SPF RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "blockstrictSPFRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching blockstrictSPFRe($Config{'blockstrictSPFRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }

        if ( $noURIBLReRE && $text =~ ( '(' . $noURIBLReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#noURIBLRe'>No URIBL RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "noURIBLRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching noURIBLRe($Config{'noURIBLRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }

        if (   $whiteRe
            && $whiteReRE != ""
            && $text =~ ( '(' . $whiteReRE . ')' ) ) {
            
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#whiteRe'>White RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "whiteRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching whiteRe($Config{'whiteRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if ( $redRe && $redReRE != "" && $text =~ ( '(' . $redReRE . ')' ) ) {
        	
            $fm .= "<b><font color='yellow'>&bull;</font> <a href='./#redRe'>Red RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "redRe", $1 );
            $fm .= "<font color='yellow'>&bull;</font> matching redRe($Config{'redRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }

        if ( $npRe && $npReRE != "" && $text =~ ( '(' . $npReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#npRe'>No Processing RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "npRe", $1 );
            $fm .= "<font color='green'>&bull;</font> matching npRe($Config{'npRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $baysSpamLoversRe
            && $baysSpamLoversReRE != ""
            && $text =~ ( '(' . $baysSpamLoversReRE . ')' ) ) {
            
            $fm .=
"<b><font color='green'>&bull;</font> <a href='./#baysSpamLoversRe'>Bayes Spamlover RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "baysSpamLoversRe", $1 );

            $fm .=
"<font color='green'>&bull;</font> matching baysSpamLoversRe($Config{'baysSpamLoversRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if ( $SpamLoversRe && $text =~ ( '(' . $SpamLoversReRE . ')' ) ) {
        	
            $fm .= "<b><font color='green'>&bull;</font> <a href='./#SpamLoversRe'>Spamlover RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "SpamLoversRe", $1 );
            $fm .=
              "<font color='green'>&bull;</font> matching SpamLoversRe($Config{'SpamLoversRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if ( $testRe && $testReRE != "" && $text =~ ( '(' . $testReRE . ')' ) ) {
        	
            $fm .= "<b><font color='yellow'>&bull;</font> <a href='./#testRe'>Test RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "testRe", $1 );
            $fm .= "<font color='yellow'>&bull;</font> matching testRe($Config{'testRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $contentOnlyRe
            && $contentOnlyReRE != ""
            && $text =~ ( '(' . $contentOnlyReRE . ')' ) ) {
            
            $fm .=
"<b><font color='yellow'>&bull;</font> <a href='./#contentOnlyRe'>Restrict to Content Only RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "contentOnlyRe", $1 );
            $fm .=
              "<font color='yellow'>&bull;</font> matching contentOnlyRe($Config{'contentOnlyRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        my $textdata;
        my $textheader;
        if ( $text =~ /^(.*X-Assp-Copy-Spam: Yes)(.*)$/ ) {
            $textheader = $1;
            $textdata   = $2;
          } else {
            $textheader = $text;
            $textdata   = $text;
          }

        if ( $bombRe && $bombReRE != "" && $text =~ ( '(' . $bombReRE . ')' ) ) {
            if ( !$DoBombRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombRe'>BombRaw RE</a> is <b>disabled because DoBombRe is disabled</b></i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#bombRe'>BombRaw RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching bombRe($Config{'bombRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $bombDataRe
            && $bombDataReRE != ""
            && $textdata =~ ( '(' . $bombDataReRE . ')' ) ) {
            if ( !$DoBombRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombRe'>BombData RE</a> is <b>disabled because DoBombRe is disabled</b></i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#bombDataRe'>BombData RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombDataRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching bombDataRe($Config{'bombDataRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $bombHeaderRe
            && $bombHeaderReRE != ""
            && $textheader =~ ( '(' . $bombHeaderReRE . ')' ) ) {
            if ( !$DoBombHeaderRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombHeaderRe'>BombHeader RE</a> is <b>disabled</b></i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#bombHeaderRe'>BombHeader RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombHeaderRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching bombHeaderRe($Config{'bombHeaderRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $bombSubjectRe
            && $bombSubjectReRE != ""
            && $textheader =~ ( '(' . $bombSubjectReRE . ')' ) ) {
            if ( !$DoBombHeaderRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombHeaderRe'>BombSubject RE</a> is <b>disabled</b> because DoBombHeaderRe is disabled</i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#bombSubjectRe'>BombSubject RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombSubjectRe", $1 );
            $fm .=
              "<font color='red'>&bull;</font> matching bombSubjectRe($Config{'bombSubjectRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $bombCharSets
            && $bombCharSetsRE != ""
            && $textheader =~ ( '(' . $bombCharSetsRE . ')' ) ) {
            if ( !$DoBombHeaderRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombHeaderRe'>bombCharSets</a> is <b>disabled</b> because DoBombHeaderRe is disabled</i><br />\n";
              }
            $fm .=
              "<b><font color='red'>&bull;</font> <a href='./#bombCharSetsRe'>BombCharsets RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombCharSets", $1 );
            $fm .= "<font color='red'>&bull;</font> matching bombCharSets($Config{'bombCharSets'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $bombSuspiciousRe
            && $bombSuspiciousReRE != ""
            && $text =~ ( '(' . $bombSuspiciousReRE . ')' ) ) {
            $fm .=
"<b><font color='red'>&bull;</font> <a href='./#bombSuspiciousRe'>BombSuspiciousRe RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "bombSuspiciousRe", $1 );
            $fm .=
"<font color='red'>&bull;</font> matching bombSuspiciousRe($Config{'bombSuspiciousRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if ( $textheader =~ ( '(' . $localdomainre . ')' ) ) {
            if ( !$DoBombHeaderByLocalDomain ) {
                $fm .= "<i><font color='red'>&bull;</font> Suspicious Local Domain in Header disabled</i><br />\n";
              }
            if ( !$DoBombHeaderRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBombHeaderRe'>Suspicious Local Domain</a> is <b>disabled</b> because DoBombHeaderRe is disabled</i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> Suspicious Local Domain in Header: '$1'<br />\n";
          }

        if (   $blackRe
            && $blackReRE != ""
            && $text =~ ( '(' . $blackReRE . ')' ) ) {
            if ( !$DoBlackRe ) {
                $fm .=
"<i><font color='red'>&bull;</font> <a href='./#DoBlackRe'>Black RE</a> is  <b>disabled</b></i><br />\n";
              }
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#blackRe'>Black RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "blackRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching blackRe($Config{'blackRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        if (   $scriptRe
            && $scriptReRE != ""
            && $text =~ ( '(' . $scriptReRE . ')' ) ) {
            $fm .= "<b><font color='red'>&bull;</font> <a href='./#scriptRe'>Script RE</a></b>: '$1'<br />\n";
            my $bombsrch = SearchBomb( "scriptRe", $1 );
            $fm .= "<font color='red'>&bull;</font> matching scriptRe($Config{'scriptRe'}): '$bombsrch'<br />\n"
              if $bombsrch;
          }
        $mail = clean( substr( $mail, 0, $MaxBytes ) );
        my $decob = decodeMimeWords($mail);

        if ($helo) {
            $fm .= "<b><font color='red'>&bull;</font> HELO Blacklist</b>: '$helo'</b><br />\n"
              if ( $HeloBlack{ lc $helo } );
            $fm .=
"<b><font color='#66CC66'>&bull;</font> <a href='./#heloBlacklistIgnore'>HELO Blacklist Ignore</a></b>: '$helo'</b><br />\n"
              if ( $heloBlacklistIgnore && $helo =~ $HBIRE );
            if ( !$DoValidFormatHelo ) {
                $fm .= "<b><font color='orange'>&bull;</font>Valid Format of HELO not activated</b><br />\n";
              }
            if ($validFormatHeloRe) {
                if ( $helo =~ ( '(' . $validFormatHeloReRE . ')' ) ) {
                    $fm .=
"<b><font color=#66CC66>&bull;</font> <a href='./#DoValidFormatHelo'>Valid Format of HELO</a></b>: '$helo'<br />\n";
                  } else {
                    $fm .=
"<b><font color='red'>&bull;</font> <a href='./#DoValidFormatHelo'>Not a Valid Format of HELO</a></b>: '$helo'<br />\n";
                  }
              }
            if ( !$DoInvalidFormatHelo ) {
                $fm .= "<b><font color='orange'>&bull;</font>Invalid Format of HELO not activated</b><br />\n";
              }
            if (   $invalidFormatHeloRe
                && $helo =~ ( '(' . $invalidFormatHeloReRE . ')' ) ) {
                $fm .=
"<b><font color='red'>&bull;</font> <a href='./#DoInvalidFormatHelo'>Invalid Format of HELO</a></b>: '$helo'<br />\n";
              }
          }

        if ( exists $PBBlack{$ip} ) {
            my ( $ct, $ut, $pbstatus, $value, $sip, $reason ) =
              split( " ", $PBBlack{$ip} );
            push( @t, 0.97 );

            $fm .=
"<b><font color='red'>&bull;</font> $ip is in <a href='./#pbdb'>PB Black</a></b>: score:$value, last event - $reason<br />\n";
          }
        if ( exists $PBWhite{$ip} ) {
            my ( $ct, $ut, $pbstatus, $sip, $reason ) =
              split( " ", $PBWhite{$ip} );
            push( @t, 0.03 );

            $fm .= "<b><font color=#66CC66>&bull;</font> $ip is in <a href='./#pbdb'>PB White</a></b><br />\n";
          }

        if ( $ret = matchIP( $ip, 'noProcessingIPs', 0, 1 ) ) {
            $fm .=
"<b><font color='green'>&bull;</font> IP $ip is in <a href='./#noProcessingIPs'>noProcessing IPs</a> ($ret)</b><br />\n";
          }
        if ( $ret = matchIP( $ip, 'whiteListedIPs', 0, 1 ) ) {
            $fm .=
"<b><font color='green'>&bull;</font> IP $ip is in <a href='./#whiteListedIPs'>whiteListed IPs</a> ($ret)</b><br />\n";
          }
        if ( $ret = matchIP( $ip, 'noPB', 0, 1 ) ) {
            $fm .=
              "<b><font color='green'>&bull;</font> IP $ip is in <a href='./#noPB'>noPB IPs</a> ($ret)</b><br />\n";
          }
        if ( exists $RBLCache{$ip} ) {
            my ( $ct, $status, $rbllists ) = split( " ", $RBLCache{$ip} );
            $status = ( $status == 2 ? 'ok' : 'not ok' );
            $fm .=
              "<b><font color='red'>&bull;</font> $ip is in RBLCache</b>: inserted at $status by $rbllists<br />\n";
          }
        if ( exists $SPFCache{$ip} ) {
            my ( $ct, $status, $result ) = split( " ", $SPFCache{$ip} );
            $fm .= "<b><font color='orange'>&bull;</font> $ip is in SPFCache</b>: status=$result<br />\n";
          }

        if ( exists $PTRCache{$ip} ) {
            my ( $ct, $status, $dns ) = split( " ", $PTRCache{$ip} );
            $status = ( $status == 2 ? 'ok' : 'not ok' );
            $fm .= "<b><font color='orange'>&bull;</font> $ip is in PTRCache</b>: status=$status-$dns<br />\n";
          }
        if ( exists $RWLCache{$ip} ) {
            my ( $ct, $status ) = split( " ", $RWLCache{$ip} );
            $status = ( $status == 2 ? 'not listed' : 'listed' );
            $fm .= "<b><font color='green'>&bull;</font> $ip is in RWLCache</b>: status=$status<br />\n";
          }
        my $logsub = ( $subjectLogging ? "" : "" );
        if ( exists $SBCache{$ip} ) {
            my ( $ct, $status ) = split( " ", $SBCache{$ip} );
            $fm .= "<b><font color='orange'>&bull;</font> $ip is in CountryCache</b>: status=$status<br />\n";
          }
        if ( $ret = matchIP( $ip, 'acceptAllMail', 0, 1 ) ) {
            $fm .=
"<b><font color='green'>&bull;</font> IP $ip is in <a href='./#acceptAllMail'>Accept All Mail</a> ($ret)</b><br />\n";
          }
        if ( $ret = matchIP( $ip, 'ispip', 0, 1 ) ) {
            $fm .=
"<b><font color='green'>&bull;</font> IP $ip is in <a href='./#ispip'>ISP/Secondary MX Servers</a> ($ret)</b><br />\n";
          }
        if ( $ret = matchIP( $ip, 'denySMTPConnectionsFrom', 0, 1 ) ) {
            $fm .=
"<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFrom'>denySMTPConnectionsFrom</a> ($ret)</b><br />\n";
          }
        if ( $ret = matchIP( $ip, 'denySMTPConnectionsFromAlways', 0, 1 ) ) {
            $fm .=
"<b><font color='red'>&bull;</font> IP $ip is in <a href='./#denySMTPConnectionsFromAlways'>denySMTPConnectionsFromAlways</a>($ret)</b><br />\n";
          }
        my @t;
        my %got;
        if ( defined( $Dnsbl{$ip} ) || defined( $Dnsbl{$ip3} ) ) {
            $fm .= "<b>* $ip dnsbl hit</b>: (adds 0.97 0.97)<br />\n";
            push( @t, 0.97 );
            push( @t, 0.97 );
          }
        if ($griplist && ( !$mystatus ||  $mystatus eq "ip" )) {
            my $v;
            if ( $ispip && matchIP( $ip, 'ispip', 0, 1 ) ) {
                if ($ispgreyvalue) {
                    $v = $ispgreyvalue;
                  } else {
                    $v = $Griplist{x};
                  }
              } else {
                $v = $Griplist{$ip3} || $Griplist{x};
              }

            $fm .= "<b><font color='gray'>&bull;</font> $ip3 has a Griplist value of $v</b>: (adds $v $v)<br />\n";
            push( @t, $v, $v ) if $v;
          }

        $fm .= "<br /><hr><br />";
        my ( $v, $lt, $t, %seen );
        while ( $mail =~ /([-\$A-Za-z0-9\'\.!\240-\377]+)/g ) {
            next if length($1) > 20;
            $lt = $t;
            $t  = lc $1;
            $t =~ s/[,.']+$//;
            $t =~ s/!!!+/!!/g;
            $t =~ s/--+/-/g;
            my $j = "$lt $t";
            next if $seen{$j}++ > 1;
            push( @t, $v ) if ( $v = $Spamdb{$j} );
            $got{$j} = $v if $v;
          }
        my $cnt       = 0;
        if (!$mystatus) {
        my $bayestext = "<font color='red'>&bull; Bayesian Check is disabled</font>"
          if !$DoBayesian;
        $ba .=
"<b><font size='3' color='#003366'>Bayesian Analysis: $bayestext</font></b><br /><br /><table cellspacing='0' cellpadding='0'>";
        $ba .= "<tr>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:right; font-size:small;\"><b>Bad Words</b></td>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:left; font-size:small; background-color:#F4F4F4\"><b>Bad Prob&nbsp;</b></td>
  <td style=\"padding-left:20px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:right; font-size:small;\"><b>Good Words</b></td>
  <td style=\"padding-left:5px; padding-right:5px; padding-top:5; padding-bottom:5; text-align:left; font-size:small; background-color:#F4F4F4\"><b>Good Prob</b></td>
  </tr>\n";
        foreach (
            sort { abs( $got{$b} - .5 ) <=> abs( $got{$a} - .5 ) }
            keys %got
          ) {
            my $g = sprintf( "%.4f", $got{$_} );
            if ( $g < 0.5 ) {
                $ba .= "<tr>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"></td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\"></td>
    <td style=\"padding-left:20px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\">$_</td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\">$g</td>
    </tr>\n";
              } else {
                $ba .= "<tr>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\">$_</td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\">$g</td>
    <td style=\"padding-left:20px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"></td>
    <td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:left; font-size:small; background-color:#F4F4F4\"></td>
    </tr>\n";
              }
            last if $cnt++ > 20;
          }
        $ba .= "</td></tr></table>\n";
        @t  = sort { abs( $b - .5 ) <=> abs( $a - .5 ) } @t;
        @t  = @t[ 0 .. 30 ];
        $st = "<br />Totals: ";
        foreach (@t) { $st .= sprintf( "%.4f ", $_ ) if $_; }
        $st .= "\n";

        #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p);}}
        #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p)*2;}}

        my $p1 = 1;
        my $p2 = 1;
        foreach my $p (@t) {
            if ($p) { $p1 *= $p; $p2 *= ( 1 - $p ); }
          }
        $SpamProb = $p1 / ( $p1 + $p2 );
        $SpamProbConfidence = abs( $p1 - $p2 );
        $st .=
"<br /><hr><br /><b><font size=\"3\" color=\"#003366\">Spam/Ham Probabilities:</font></b><br /><br />\n<table cellspacing=\"0\" cellpadding=\"0\">"
          if $baysConf;
        $st .=
"<br /><hr><br /><b><font size=\"3\" color=\"#003366\">Spam Probability:</font></b><br /><br />\n<table cellspacing=\"0\" cellpadding=\"0\">"
          if !$baysConf;
        $st .= sprintf(
" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>spamprobability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",
            $p1 )
          if $baysConf;
        $st .= sprintf(
" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>hamprobability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",
            $p2 )
          if $baysConf;
        $st .= sprintf(
" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>combined probability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",
            $SpamProb )
          if $baysConf;
        $st .= sprintf(
" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>probability</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.4f</td></tr>\n",
            $SpamProb )
          if !$baysConf;
        $st .= sprintf(
" <tr><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; text-align:right; font-size:small;\"><b>bayesian confidence</b>:</td><td style=\"padding-left:5px; padding-right:5px; padding-top:0; padding-bottom:0; font-size:small;\">%.40f</td></tr>\n",
            $SpamProbConfidence )
          if $baysConf;
 		}
        $st .= " </table><br /></div><br />";
        $mail =~ s/([^\n]{70,84}[^\w\n<\@])/$1\n/g;
        $mail =~ s/\s*\n+/\n/g;
        $mail =~ s/<\/textarea>/\/textarea/ig;
      }
    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Mail Analyzer</h2>
<div class="note">This page will show you how ASSP analyzes and pre-processes an email to come up with the assigned spam probability. Regular Expressions will always check the full message.
</div><br />
$fm$ba$st
<form action="" method="post">
    <table class="textBox">
        <tr>
            <td class="noBorder" align="center">Copy and paste the mail header and
            body here:<br />
            <textarea name="mail" rows="10" cols="60" wrap="off">$mail</textarea>
            </td>


        </tr>
        <tr>
            <td class="noBorder" align="center"><input type="submit" name="B1" value=" Analyze " /></td>

        </tr>
    </table>
</form>
<br />
<p class="note" ><small><b>You may put here helo=aaa.bbb.helo or ip=123.123.123.123 to look up the helo/ip information. text=abc will start a lookup in the regular expression files for the "abc" matching regex.</b>
<p>Note: Analysis is performed using the current spam database --
if yours was rebuilt since the time the mail was received you'll
receive a different result.</p>
<div class="textbox">
<p>To use this form using <i>Outlook Express</i> do the following. Right-click on the message
of interest. Select <i>Properties</i>. Click the <i>Details</i> tab. Click the <i>message
source</i> button. Right-click on the message source and click <i>Select All</i>. Right-click
again and click <i>Copy</i>. Click on the text box above and paste (Ctrl-V perhaps). Click
the <i>Analyze</i> button.</p>
<p>The page will update to show you the following: if any of the email's addresses are in
the redlist or whitelist, the most and least spammy phrases together with their spaminess,
the resulting probabilities (probabilities may repeat one time), and the final spam probability
score.</small></p>
  
</div>
</div>

$footers
</body></html>
EOT
  }

#
sub AnalyzeText {
    my ( $fh, $mail ) = @_;
    my $this = $Con{$fh};
    my @t;

    my ( $ba, $st, $fm, %fm, %wl, $ip, $ip3, $helo, $text, $header, $received );
    my $mail = $this->{header};
    my $bod  = $this->{header};
    my ($sub) = $this->{header} =~ /Subject: (.*)/i;
    $sub =~ s/^.*\]\s//gi;
    $sub =~ s/^fwd.\s//gi;
    $sub =~ s/^fw.\s//gi;
    $sub =~ s/^aw.\s//gi;
    $sub =~ s/^re.\s//gi;
    $sub = decodeMimeWords($sub);

    # remove the spam subject header addition if present
    my $spamsub = $spamSubject;
    if ($spamsub) {
        $spamsub =~ s/(\W)/\\$1/g;
        $sub     =~ s/$spamsub//gi;
      }
    $sub =~ s/\r//;

    $header = "Subject: " . $sub . "\n" if $sub;
    $received = $1 if $bod =~ /(Received: from.*?\(\[[0-9\.]+.*?helo=.*?\))/i;
    $header .= $received . "\n" if $received;

    $header .= $1 if $bod =~ /(X-Assp-ID: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Tag: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Envelope-From: .*)/i;

    $header .= $1 if $bod =~ /(X-Assp-Intended-For: .*)/i;

    $bod =~ s/^.*?\n\r?\n\s*//s;

    $bod =~ s/X-Assp-Spam-Prob: .*\n//gi;
    if ( $bod =~ /\nReceived: / ) {
        $bod =~ s/^.*?\nReceived: /Received: /s;
      } else {
        $bod =~ s/^.*?\n((\w[^\n]*\n)*Subject:)/$1/si;
        $bod =~ s/\n> /\n/g;
      }

    if ($mail) {
        my $name = $myName;
        $name =~ s/(\W)/\\$1/g;
        if ( $mail =~ /^ip=(\d+\.\d+\.\d+\.\d+)/ ) {

            $ip = $1;
          } else {
            while ( $mail =~ /Received: from ([0-9\.]+).*?by\s+$name/isg ) {
                $ip = $1;
              }
          }

        if ( !$ip ) {
            while ( $mail =~ /Received: from.*?\(\[([0-9\.]+).*?helo=/isg ) {
                $ip = $1;
              }
          }

        $fm .= "Connecting IP: $ip\n" if $ip;
        $ip3 = $1 if $ip =~ /(.*)\.\d+$/;
        if ( $mail =~ /^helo=(.+)/i ) {
            $helo = $1;
          } else {
            while ( $mail =~ /helo=(\S+?)\)/isg ) {
                $helo = $1;
              }
          }
        $fm .= "Connecting HELO: $helo\n\n" if $helo;
        if ( $mail =~ /^text=(.+)/i ) {
            $text = $1;
          } else {
            $text = $mail;
          }
        if ($ispHostnames) {
            while ( $mail =~ /Received: from (.{1,50}) \(\[?(\d+\.\d+\.\d+\.\d+).{1,80}by.{1,20}($ispHostnamesRE)/gis ) {
				$helo = $1;
                $received = $2;
                ($ip) = $received =~ /(\d+\.\d+\.\d+\.\d+)/i;
                
                ($ip3) = $ip =~ /(.*)\.\d+$/;

              }
            $fm .= "\nISP/Secondary Header:'$received'\n"    if $received;
            $fm .= "Switched to ISP/Secondary IP: '$ip'\n\n" if $received;
          }

        $fm .= "Feature Matching:\n\n";
        while ( $mail =~ /($EmailAdrRe\@$EmailDomainRe)/go ) {
            my $a    = lc $1;
            my $mf   = $a;
            my $mfd  = $1 if $mf =~ /\@(.*)/;
            my $mfdd = $1 if $mf =~ /(\@.*)/;
            next if $fm{$a}++;
            my $r1 = matchSL( $mf, 'noProcessing' );

            if ($r1) { $fm .= "NoProcessing: '$mf'\n"; }
            if ( $noProcessingDomains && $mf =~ ( '(' . $NPDRE . ')' ) ) {
                $fm .= "NoProcessingDomains: '$1'\n";
              }
            if (   $WLDRE != ""
                && $whiteListedDomains
                && $mf =~ ( '(' . $WLDRE . ')' ) ) {
                $fm .= "Whitelisted Domains: '$1'\n";
              }

            $fm .= "Redlist: '$a'\n" if $Redlist{$a};
            $fm .= "Redlisted Domain/ Wildcard: '$wildcardUser$mfdd'\n"
              if $Redlist{"_all_$mfdd"};

            $fm .= "Whitelist: '$a'\n" if $Whitelist{$a};
            $fm .= "Whitelisted Domain/ Wildcard</a></b>: '$wildcardUser$mfdd'\n"
              if $Whitelist{"_all_$mfdd"};
          }
      }

    if ( $noSPFReRE && $text =~ ( '(' . $noSPFReRE . ')' ) ) {
    	
        $fm .= "No SPF RE: '$1'\n";
        my $bombsrch = SearchBomb( "noSPFRe", $1 );
        $fm .= " matching noSPFRe($Config{'noSPFRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $strictSPFReRE && $text =~ ( '(' . $strictSPFReRE . ')' ) ) {
    	
        $fm .= "Strict SPF RE: '$1'\n";
        my $bombsrch = SearchBomb( "strictSPFRe", $1 );
        $fm .= " matching strictSPFRe($Config{'strictSPFRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $blockstrictSPFReRE && $text =~ ( '(' . $blockstrictSPFReRE . ')' ) ) {
    	
        $fm .= "Block Strict SPF RE: '$1'\n";
        my $bombsrch = SearchBomb( "blockstrictSPFRe", $1 );
        $fm .= " matching blockstrictSPFRe($Config{'blockstrictSPFRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $noURIBLReRE && $text =~ ( '(' . $noURIBLReRE . ')' ) ) {
    	
        $fm .= "No URIBL RE: '$1'\n";
        my $bombsrch = SearchBomb( "noURIBLRe", $1 );
        $fm .= " matching noURIBLRe($Config{'noURIBLRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $whiteRe && $whiteReRE != "" && $text =~ ( '(' . $whiteReRE . ')' ) ) {
    	
        $fm .= "White RE: '$1'\n";
        my $bombsrch = SearchBomb( "whiteRe", $1 );
        $fm .= " matching whiteRe($Config{'whiteRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $redRe && $redReRE != "" && $text =~ ( '(' . $redReRE . ')' ) ) {
    	
        $fm .= "Red RE: '$1'\n";
        my $bombsrch = SearchBomb( "redRe", $1 );
        $fm .= " matching redRe($Config{'redRe'}): '$bombsrch'\n" if $bombsrch;
      }
    if ( $npRe && $npReRE != "" && $text =~ ( '(' . $npReRE . ')' ) ) {
    	
        $fm .= "No Processing RE: '$1'\n";
        my $bombsrch = SearchBomb( "npRe", $1 );
        $fm .= " matching npRe($Config{'npRe'}): '$bombsrch'\n" if $bombsrch;
      }
    if (   $baysSpamLoversRe
        && $baysSpamLoversReRE != ""
        && $text =~ ( '(' . $baysSpamLoversReRE . ')' ) ) {
        
        $fm .= "Bayes Spamlover RE: '$1'\n";
        my $bombsrch = SearchBomb( "baysSpamLoversRe", $1 );

        $fm .= " matching baysSpamLoversRe($Config{'baysSpamLoversRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $SpamLoversRe && $text =~ ( '(' . $SpamLoversReRE . ')' ) ) {
    	
        $fm .= "Spamlover RE: '$1'\n";
        my $bombsrch = SearchBomb( "SpamLoversRe", $1 );
        $fm .= " matching SpamLoversRe($Config{'SpamLoversRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $testRe && $testReRE != "" && $text =~ ( '(' . $testReRE . ')' ) ) {
    	
        $fm .= "Test RE: '$1'\n";
        my $bombsrch = SearchBomb( "testRe", $1 );
        $fm .= " matching testRe($Config{'testRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $contentOnlyRe
        && $contentOnlyReRE != ""
        && $text =~ ( '(' . $contentOnlyReRE . ')' ) ) {
        
        $fm .= "Restrict to Content Only RE<: '$1'\n";
        my $bombsrch = SearchBomb( "contentOnlyRe", $1 );
        $fm .= " matching contentOnlyRe($Config{'contentOnlyRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    my $textdata;
    my $textheader;
    if ( $text =~ /^(.*X-Assp-Copy-Spam: Yes)(.*)$/ ) {
        $textheader = $1;
        $textdata   = $2;
      } else {
        $textheader = $text;
        $textdata   = $text;
      }

    if ( $bombRe && $bombReRE != "" && $text =~ ( '(' . $bombReRE . ')' ) ) {
        if ( !$DoBombRe ) {
            $fm .= "BombRawRE is disabled because DoBombRe is disabled\n";
          }
        $fm .= "BombRaw RE: '$1'\n";
        my $bombsrch = SearchBomb( "bombRe", $1 );
        $fm .= " matching bombRe($Config{'bombRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $bombDataRe
        && $bombDataReRE != ""
        && $textdata =~ ( '(' . $bombDataReRE . ')' ) ) {
        if ( !$DoBombRe ) {
            $fm .= "BombDataRE is disabled because DoBombRe is disabled\n";
          }
        $fm .= "BombData RE: '$1'\n";
        my $bombsrch = SearchBomb( "bombDataRe", $1 );
        $fm .= " matching bombDataRe($Config{'bombDataRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $bombHeaderRe
        && $bombHeaderReRE != ""
        && $textheader =~ ( '(' . $bombHeaderReRE . ')' ) ) {
        if ( !$DoBombHeaderRe ) {
            $fm .= "BombHeaderRE is disabled\n";
          }
        $fm .= "BombHeader RE: '$1'\n";
        my $bombsrch = SearchBomb( "bombHeaderRe", $1 );
        $fm .= " matching bombHeaderRe($Config{'bombHeaderRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $bombSubjectRe
        && $bombSubjectReRE != ""
        && $textheader =~ ( '(' . $bombSubjectReRE . ')' ) ) {
        if ( !$DoBombHeaderRe ) {
            $fm .= "BombSubjectRE is disabled because DoBombHeaderRe is disabled\n";
          }
        $fm .= "BombSubject RE: '$1'\n";
        my $bombsrch = SearchBomb( "bombSubjectRe", $1 );
        $fm .= " matching bombSubjectRe($Config{'bombSubjectRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $bombCharSets
        && $bombCharSetsRE != ""
        && $textheader =~ ( '(' . $bombCharSetsRE . ')' ) ) {
        if ( !$DoBombHeaderRe ) {
            $fm .= "BombCharsets is disabled because DoBombHeaderRe is disabled\n";
          }
        $fm .= "BombCharsets: '$1'\n";
        my $bombsrch = SearchBomb( "bombCharSets", $1 );
        $fm .= " matching bombCharSets($Config{'bombCharSets'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $bombSuspiciousRe
        && $bombSuspiciousReRE != ""
        && $text =~ ( '(' . $bombSuspiciousReRE . ')' ) ) {
        $fm .= "BombSuspiciousRe RE: '$1'\n";
        my $bombsrch = SearchBomb( "bombSuspiciousRe", $1 );
        $fm .= " matching bombSuspiciousRe($Config{'bombSuspiciousRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if ( $textheader =~ ( '(' . $localdomainre . ')' ) ) {
        if ( !$DoBombHeaderByLocalDomain ) {
            $fm .= " Suspicious Local Domain in Header disabled\n";
          }

        if ( !$DoBombHeaderRe ) {
            $fm .= "'Suspicious Local Domain' is disabled because DoBombHeaderRe is disabled\n";
          }
        $fm .= " Suspicious Local Domain in Header: '$1'\n";
      }

    if ( $blackRe && $blackReRE != "" && $text =~ ( '(' . $blackReRE . ')' ) ) {
        if ( !$DoBlackRe ) {
            $fm .= "BlackRE is disabled\n";
          }
        $fm .= "Black RE: '$1'\n";
        my $bombsrch = SearchBomb( "blackRe", $1 );
        $fm .= " matching blackRe($Config{'blackRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    if (   $scriptRe
        && $scriptReRE != ""
        && $text =~ ( '(' . $scriptReRE . ')' ) ) {
        $fm .= "Script RE: '$1'\n";
        my $bombsrch = SearchBomb( "scriptRe", $1 );
        $fm .= " matching scriptRe($Config{'scriptRe'}): '$bombsrch'\n"
          if $bombsrch;
      }
    $mail = clean( substr( $mail, 0, $MaxBytes ) );
    my $decob = decodeMimeWords($mail);

    if ($helo) {
        $fm .= "HELO Blacklist: '$helo'\n" if ( $HeloBlack{ lc $helo } );
        $fm .= "HELO Blacklist Ignore: '$helo'\n"
          if ( $heloBlacklistIgnore && $helo =~ $HBIRE );

        if (   $validFormatHeloRe
            && $helo !~ ( '(' . $validFormatHeloReRE . ')' ) ) {
            if ( !$DoValidFormatHelo ) {
                $fm .= "Valid Format Check of HELO not activated\n";
              }
            $fm .= "Not a Valid Format of HELO: '$helo'\n";
          }
        if (   $invalidFormatHeloRe
            && $helo =~ ( '(' . $invalidFormatHeloReRE . ')' ) ) {
            if ( !$DoInvalidFormatHelo ) {
                $fm .= "Invalid Format Check of HELO not activated\n";
              }
            $fm .= "Invalid Format of HELO: '$helo'\n";
          }
      }

    if ( exists $PBBlack{$ip} ) {
        my ( $ct, $ut, $pbstatus, $value, $sip, $reason ) =
          split( " ", $PBBlack{$ip} );
        push( @t, 0.97 );

        $fm .= "IP $ip is in PB Black: score:$value, last event - $reason\n";
      }
    if ( exists $PBWhite{$ip} ) {
        my ( $ct, $ut, $pbstatus, $sip, $reason ) = split( " ", $PBWhite{$ip} );
        push( @t, 0.03 );

        $fm .= "IP $ip is in PB White\n";
      }
    my $ret;
    if ( $ret = matchIP( $ip, 'noProcessingIPs', 0, 1 ) ) {
        $fm .= "IP $ip is in noProcessing IPs ($ret)\n";
      }
    if ( $ret = matchIP( $ip, 'whiteListedIPs', 0, 1 ) ) {
        $fm .= "IP $ip is in whiteListed IPs ($ret)\n";
      }
    if ( $ret = matchIP( $ip, 'noPB', 0, 1 ) ) {
        $fm .= "IP $ip is in noPB IPs ($ret)\n";
      }
    if ( exists $RBLCache{$ip} ) {
        my ( $ct, $mm, $rbllists ) = split( " ", $RBLCache{$ip} );
        $fm .= "IP $ip is in RBLCache: inserted at $mm by $rbllists\n";
      }
    if ( exists $SPFCache{$ip} ) {
        my ( $ct, $result, $domain ) = split( " ", $SPFCache{$ip} );
        $fm .= "IP $ip is in SPFCache: $result, $domain\n";
      }

    if ( exists $PTRCache{$ip} ) {
        my ( $ct, $status, $dns ) = split( " ", $PTRCache{$ip} );
        $fm .= "IP $ip is in PTRCache: status=$status-$dns\n";
      }
    if ( exists $RWLCache{$ip} ) {
        my ( $ct, $status ) = split( " ", $RWLCache{$ip} );
        $fm .= "IP $ip is in RWLCache: status=$status\n";
      }
    if ( exists $SBCache{$ip} ) {
        my ( $ct, $status ) = split( " ", $SBCache{$ip} );
        $fm .= "IP $ip is in CountryCache: status=$status\n";
      }
    if ( $ret = matchIP( $ip, 'acceptAllMail', 0, 1 ) ) {
        $fm .= "IP $ip is in Accept All Mail ($ret)\n";
      }
    if ( $ret = matchIP( $ip, 'ispip', 0, 1 ) ) {
        $fm .= "IP $ip is in ISP/Secondary MX Servers ($ret)\n";
      }
    if ( $ret = matchIP( $ip, 'denySMTPConnectionsFrom', 0, 1 ) ) {
        $fm .= "IP $ip is in denySMTPConnectionsFrom ($ret)\n";
      }
    if ( $ret = matchIP( $ip, 'denySMTPConnectionsFromAlways', 0, 1 ) ) {
        $fm .= "IP $ip is in denySMTPConnectionsFromAlways ($ret)\n";
      }
    my @t;
    my %got;
    if ( defined( $Dnsbl{$ip} ) || defined( $Dnsbl{$ip3} ) ) {
        $fm .= "* $ip dnsbl hit: (adds 0.97 0.97)\n";
        push( @t, 0.97 );
        push( @t, 0.97 );
      }
    if ($griplist) {
        my $v;
        if ( $ispip && matchIP( $ip, 'ispip', 0, 1 ) ) {
            if ($ispgreyvalue) {
                $v = $ispgreyvalue;
              } else {
                $v = $Griplist{x};
              }
          } else {
            $v = $Griplist{$ip3} || $Griplist{x};
          }

        $fm .= "$ip3 has a Griplist value of $v: (adds $v $v)\n";
        push( @t, $v, $v ) if $v;
      }

    $fm .= "\n";
    my ( $v, $lt, $t, %seen );
    while ( $mail =~ /([-\$A-Za-z0-9\'\.!\240-\377]+)/g ) {
        next if length($1) > 20;
        $lt = $t;
        $t  = lc $1;
        $t =~ s/[,.']+$//;
        $t =~ s/!!!+/!!/g;
        $t =~ s/--+/-/g;
        my $j = "$lt $t";
        next if $seen{$j}++ > 1;
        push( @t, $v ) if ( $v = $Spamdb{$j} );
        $got{$j} = $v if $v;
      }
    my $cnt = 0;
    my $bayestext = "Bayesian Check is disabled" if !$DoBayesian;
    $ba .= "Bayesian Analysis: $bayestext\n";
    $ba .= "Bad Words:Bad Prob\t\t\tGood Words:Good Prob\n";
    foreach ( sort { abs( $got{$b} - .5 ) <=> abs( $got{$a} - .5 ) } keys %got ) {
        my $g = sprintf( "%.4f", $got{$_} );
        if ( $g < 0.5 ) {

            $ba .= "\t\t\t\t\t\t$_:$g\n";
          } else {
            $ba .= "$_:$g\n";
          }
        last if $cnt++ > 20;
      }

    $ba .= "\n";
    @t  = sort { abs( $b - .5 ) <=> abs( $a - .5 ) } @t;
    @t  = @t[ 0 .. 30 ];
    $st = "Totals: ";
    foreach (@t) { $st .= sprintf( "%.4f ", $_ ) if $_; }
    $st .= "\n";

    #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p);}}
    #my $p1=1; my $p2=1; foreach $p (@t) {if($p) {$p1*=$p; $p2*=(1-$p)*2;}}

    my $p1 = 1;
    my $p2 = 1;
    foreach my $p (@t) {
        if ($p) { $p1 *= $p; $p2 *= ( 1 - $p ); }
      }
    $SpamProb = $p1 / ( $p1 + $p2 );
    $this->{spamconf} = abs( $p1 - $p2 );
    $st .= "\n\nSpam/Ham Probabilities:\n";
    $st .= "\n\nSpam Probability:\n" if !$baysConf;
    $st .= sprintf( " spamprobability: %.40f\n", $p1 ) if $baysConf;
    $st .= sprintf( " hamprobability: %.40f\n", $p2 ) if $baysConf;
    $st .= sprintf( " combined probability %.40f\n", $SpamProb ) if $baysConf;
    $st .= sprintf( " probability %.4f\n", $SpamProb ) if !$baysConf;
    $st .= sprintf( " bayesian confidence %.40f\n", $this->{spamconf} )
      if $baysConf;

    $st .= " \n";

    $this->{report} = "$header$fm$ba$st$bod";
    return $sub;
  }

sub needEs {
    my ( $count, $text, $es ) = @_;
    return $count . $text . ( $count == 1 ? '' : $es );
  }

# wrap long log lines
sub logWrap {
    my ( $line, $indent ) = @_;
    my $wraps = $MaillogTailWrapColumn + 11;    # has to be >= $indent, or while line loops infinitely
    my $wrape = $wraps + 15;

    # wrap anchors are: space;-,.:= (but not &lt; &gt;)
    # matches are greedy to minimize number of line breaks
    # not a danger code as long as $wraps >= $indent
    while ( $line =~
s/(?:([^\r\n]{$wraps,$wrape}) |([^\r\n]{$wraps,$wrape}(?<![lg]t);)|([^\r\n]{$wraps,$wrape}[-,.:=])) {0,5}(?=[^\r\n]{5,}$)/$1$2$3\r\n$indent/
      ) {
      }
    return $line;
  }

sub encodeHTMLEntities {
    my $s = shift;
    $s =~ s/&/&amp;/gs;
    $s =~ s/</&lt;/gs;
    $s =~ s/>/&gt;/gs;
    $s =~ s/"/&quot;/gs;
    return $s;
  }

sub decodeHTMLEntities {
    my $s = shift;
    $s =~ s/&quot;?/"/gis;
    $s =~ s/&gt;?/>/gis;
    $s =~ s/&lt;?/</gis;
    $s =~ s/&amp;?/&/gis;
    return $s;
  }

sub ConfigMaillog {
    my $pat = $qs{search};
    my $s   = '';
    my $res = '';

    # calculate indent
    my $m = localtime();
    $m =~ s/^... (...) +(\d+) (\S+) ..(..)/$1-$2-$4 $3 /;
    my $indent = " " x length($m);
    if ( !$pat ) {
        open( F, "<$base/$logfile" );
        seek( F, -$MaillogTailBytes, 2 ) || seek( F, 0, 0 );
        local $/;
        $s = <F>;
        close F;
        $s = encodeHTMLEntities($s);
        if ( $MaillogTailWrapColumn > 0 ) {
            my @sary = map { $_ . "\n" } split( /\r?\n|\r/, $s );
            foreach (@sary) {
                $_ = logWrap( $_, $indent );
                s/(\r\n\Q$indent\E)/<span style="background-color:white">$1<\/span>/g;
              }
            $s = join( '', @sary );
          }
      } elsif ($CanSearchLogs) {
        my @sary;
        my $matches = 0;
        my $lines   = 0;
        my $files   = 0;
        my ( $logdir, $logdirfile ) = $logfile =~ /^(.*[\/\\])?(.*?)$/;
        my @logfiles = reverse sort glob("$base/$logdir*$logdirfile");
        my $logf = File::ReadBackwards->new( shift(@logfiles), '(?:\r?\n|\r)', 1 );    # line terminator regex
        if ($logf) {
            $files++;
            my $maxmatches =
                $qs{limit} eq '1000' ? 1000
              : $qs{limit} eq '100'  ? 100
              : $qs{limit} eq '10'   ? 10
              : $qs{limit} eq '1'    ? 1
              :                        0;
            my $maxlines = lc $qs{files} eq 'lines' ? 10000 : 0;
            my $maxfiles = lc $qs{files} eq 'last'  ? 2     : 0;
            $pat = encodeHTMLEntities($pat);

            # mormalize and strip redundand minuses
            $pat =~ s/(?<!(?:-|\w))(-(?:\s+|\z))+/-/g;
            $pat =~ s/\s+-$//;
            my $l = $logf->readline();

            # make line terminators uniform
            $l =~ s/(.*?)(?:\r?\n|\r)/$1\n/;
            $l = encodeHTMLEntities($l);
            $l = addShowPath($l);
            my @ary;
            push( @ary, $l );
            my $infinity   = 10000;
            my $precontext = my $postcontext = $qs{nocontext} ? 0 : 6;
            my $notmatched = 0;
            my $currentpre = 0;
            my $seq        = 0;
            my $lastoutput = $infinity;
            my $cur        = $ary[0];
            my $i          = 0;
            my @words      = map /^\d+\_(.*)/, sort values %{
                {
                    map { lc $_ => sprintf( "%02d", $i++ ) . '_' . $_ }
                      split( ' ', $pat )
                }
              };
            $pat = join( ' ', @words );
            my @highlights = (
                '<span style="color:black; background-color:#ffff66">',
                '<span style="color:black; background-color:#A0FFFF">',
                '<span style="color:black; background-color:#99ff99">',
                '<span style="color:black; background-color:#ff9999">',
                '<span style="color:black; background-color:#ff66ff">',
                '<span style="color:white; background-color:#880000">',
                '<span style="color:white; background-color:#00aa00">',
                '<span style="color:white; background-color:#886800">',
                '<span style="color:white; background-color:#004699">',
                '<span style="color:white; background-color:#990099">'
            );
            my $findExpr = join(
                ' && ',
                (
                    (
                        map { '$cur=~/' . quotemeta($_) . '/io' }
                          map /^([^-].*)/, split( ' ', $pat )
                    ),
                    ( map { '$cur!~/' . quotemeta($_) . '/io' } map /^-(.*)/, split( ' ', $pat ) )
                )
            );
            my %replace;
            my $j             = 0;
            my $highlightExpr = '=~s/(';

            foreach ( map /^([^-].*)/, split( ' ', $pat ) ) {
                $replace{ lc $_ } = $highlights[ $j % @highlights ];    # pick highlight style
                $highlightExpr .= quotemeta($_) . '|';
                if ( $MaillogTailWrapColumn > 0 ) {
                    for ( $i = 1 ; $i < length($_) ; $i++ ) {

                        # cover all possible positions of wrapping whitespaces
                        my $word = $_;
                        $word =~ s/^(.{$i})/$1\r\n$indent/;
                        $replace{ lc $word } = $highlights[ $j % @highlights ];
                        $highlightExpr .= quotemeta($word) . '|';
                      }
                  }
                $j++;
              }
            $highlightExpr =~ s/\|$//;
            $highlightExpr .= ')/$replace{lc $1}$1<\/span>/gio';
            my $loop = <<'LOOP';
   while ($cur && !($maxmatches && $matches>=$maxmatches && $notmatched>$postcontext) && !($maxlines && $notmatched>=$maxlines)) {
LOOP
            $loop .= 'if (!($maxmatches && $matches>=$maxmatches) && ' . $findExpr . ') {' . <<'LOOP';
     $matches++;
     $cur=logWrap($cur,$indent) if $MaillogTailWrapColumn>0;
LOOP
            $loop .= '$cur' . $highlightExpr . ' unless $qs{nohighlight};' . <<'LOOP';
     if ($lastoutput<=$postcontext) {
      push(@sary,$cur);
     } else {
      push(@sary,"\r\n") if ($seq++ && ($precontext+$postcontext>0));
      for ($i=0; $i<@ary; $i++) {
       $ary[$i]=logWrap($ary[$i],$indent) if $MaillogTailWrapColumn>0;
       if ($i<$precontext && $currentpre==$precontext || $i<$currentpre) {
        $ary[$i]=~s/^(.*?)(\r?\n)$/<span style="color:#999999">$1<\/span>$2/s;
       } else {
LOOP
            $loop .= '$ary[$i]' . $highlightExpr . ' unless $qs{nohighlight};' . <<'LOOP';
       }
       push(@sary,$ary[$i]);
      }
     }
     $lastoutput=0;
     $notmatched=0;
    } elsif ($logf->eof) {
     for (; $currentpre>=0; $currentpre--) {
      shift(@ary);
     }
     $logf->close if exists $logf->{'handle'};
     if (!($maxfiles && $files>=$maxfiles)) {
      $logf=File::ReadBackwards->new(shift(@logfiles),'(?:\r?\n|\r)',1);
      $files++ if $logf;
     }
     $lastoutput=$infinity;
    } elsif ($lastoutput<=$postcontext) {
     $cur=logWrap($cur,$indent) if $MaillogTailWrapColumn>0;
     $cur=~s/^(.*?)(\r?\n)$/<span style="color:#999999">$1<\/span>$2/s;
     push(@sary,$cur);
    }
    $lastoutput++;
    $notmatched++;
    if ($l) {
     $l=$logf->readline();
     # make line terminators uniform
     $l=~s/(.*?)(?:\r?\n|\r)/$1\n/;
     $l=encodeHTMLEntities($l);
     $lines++;
    }
    push(@ary,$l);
    if ($currentpre<$precontext) {
     $currentpre++;
    } else {
     shift(@ary);
    }
    $cur=$ary[$currentpre];
    MainLoop2();
   }
LOOP
            eval $loop;
            $logf->close if exists $logf->{'handle'};
          }
        if ( $matches > 0 ) {
            $res =
                'found '
              . needEs( $matches, ' matching line', 's' )
              . ', searched in '
              . needEs( $files, ' log file', 's' ) . ' ('
              . needEs( $lines, ' line',     's' ) . ')';
            s/\-\> (.*\.eml)/\-\> <span onclick="popFileEditor(this,4);">$1<\/span>/g foreach @sary;
            if ( $MaillogTailWrapColumn > 0 ) {

                # wipe out highlighted wrapping whitespaces
                s/(\r\n\Q$indent\E)/<span style="background-color:white">$1<\/span>/g foreach @sary;

              }
            $s = join( '', reverse @sary );
          } else {
            $res =
                'no results found, searched in '
              . needEs( $files, ' log file', 's' ) . ' ('
              . needEs( $lines, ' line',     's' ) . ')';
          }
      } else {
        $s =
'<p class="warning">Please install required module <a href="http://search.cpan.org/~uri/File-ReadBackwards-1.03/" rel="external">File::ReadBackwards</a>.</p>';
      }
    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Maillog Tail</h2>
<div class="note">
Press your browser's refresh to update this screen. Newest entries are at the end.
</div>
<form action="" method="get">
  <table class="textBox" style="width: 750px;">
    <tr>
      <td align="right">
        <input type="text" name="search" value='$pat' size="20"/>
        <input type="submit" name="" value="Search" />
      </td>
      <td align="center">
      <label>Search in</label>
        <select size="1" name="files">
          <option selected="selected" value="lines">last 10000 lines</option>
          <option value="last">last two log files</option>
          <option value="all">all log files</option>
        </select>
        <label>Results</label>
        <select size="1" name="limit">
          <option  value="1">1</option>
          <option selected="selected" value="10">10</option>
          <option value="100">100</option>
          <option value="1000">1.000</option>
     <!-- <option value="0">display all matches</option> -->
        </select>
      </td>
      <td>
        <input type="checkbox" name="nocontext"${\($qs{nocontext} ? ' checked="checked" ' : ' ')}value='1' />hide&nbsp;context&nbsp;lines<br />
        <input type="checkbox" name="nohighlight"${\($qs{nohighlight} ? ' checked="checked" ' : ' ')}value='1' />no&nbsp;highlighting
      </td>
    </tr>
  </table>
</form>
<div class="log">
$res
<pre>
$s
</pre>
</div>
$maillogJump
</div>
$footers
</body></html>
EOT
  }

sub ConfigEdit {
    my $fil  = $qs{file};
    my $note = q{};
    my ( $cidr, $regexp1, $regexp2 );
    my ( $s1,   $s2,      $editButtons );

    $cidr = $regexp1 = $regexp2 = q{};

    if ( $qs{note} eq '1' ) {
        $note =
'<div class="note" id="notebox">File should have one entry per line; anything on a line following a numbersign ( #) is ignored (a comment). Whitespace at the beginning or end of the line is ignored.</div>';
      } elsif ( $qs{note} eq '2' ) {
        $note =
'<div class="note" id="notebox">First line specifies text that appears in the subject of report message. The remaining lines are the report message body. </div>';
      } elsif ( $qs{note} eq '3' ) {
        $note = '<div class="note" id="notebox">Put here comments to your assp installation.</div>';
      } elsif ( $qs{note} eq '4' ) {
        $note =
'<div class="note" id="notebox">For removal of entries from BlackBox  use <a onmousedown="toggleDisp(\'8\')" target="main" href="./#noPB">noPB</a>. 
For removal of entries from WhiteBox  use <a onmousedown="toggleDisp(\'8\')" target="main" href="./#noPBwhite">noPBwhite</a>. For  whitelisting IP\'s use <a onmousedown="toggleDisp(\'5\')" target="main" href="./#whiteListedIPs">Whitelisted IP\'s</a> or <a onmousedown="toggleDisp(\'4\')" target="main" href="./#noProcessingIPs">No Processing IP\'s</a>. For blacklisting use <a onmousedown="toggleDisp(\'2\')" target="main" href="./#denySMTPConnectionsFrom">Deny SMTP Connections From these IP\'s</a> and <a onmousedown="toggleDisp(\'2\')" target="main" href="./#denySMTPConnectionsFromAlways">Deny SMTP Connections From these IP\'s Strictly</a>.</div>';
      } elsif ( $qs{note} eq '5' ) {
        $note = '<div class="note" id="notebox"></div>';
      } elsif ( $qs{note} eq '6' ) {
        $note =
'<div class="note" id="notebox">CacheEntry: IP/Domain \'11\' CacheIntervalStart 1=fail/2=pass Result/Comment</div\>';
      } elsif ( $qs{note} eq '8' ) {
        $note = '<div class="note" id="notebox"></div>';
      }
    $regexp1 = "<br />If Net::IP::Match::Regexp is installed  CIDR notation is allowed(182.82.10.0/24)."
      if !$CanMatchCIDR;
    $regexp2 =
"<br />If Net::IP::Match::Regexp is installed, Text after the range (and before a numbersign) will be accepted as comment which will be shown in a match (for example: 182.82.10.0/24 Yahoo Groups #comment not shown)."
      if !$CanMatchCIDR;
    $regexp1 = "<br />CIDR notation is available (182.82.10.0/24)."
      if $CanMatchCIDR;
    $regexp2 =
"<br />Text after the IP range but before a numbersign will be used as comment to be shown in a match. For example:<br />182.82.10.0/24 Yahoo #comment to be removed"
      if $CanMatchCIDR;

    $cidr = "<br />If Net::CIDR::Lite is installed, hyphenated ranges can be used (182.82.10.0-182.82.10.255)."
      if !$CanUseCIDRlite;
    $cidr = "<br />hyphenated ranges can be used (182.82.10.0-182.82.10.255)."
      if $CanUseCIDRlite;
    if ( $qs{note} eq '7' ) {
        $note = "<div class='note' id='notebox'>IP ranges are defined as '182.82.10.' $regexp1 $cidr $regexp2</div>";
      }

    $s2 = '';
    if ( $fil =~ /\.\./ ) {
        $s2 .= '<div class="text"><span class="negative">File path includes \'..\' -- access denied</span></div>';
        mlog( 0, "file path not allowed while editing file '$fil'" );
      }

    else {

        #$fil="$base/$fil" if $fil!~/^(([a-z]:)?[\/\\]|\Q$base\E)/;
        $fil = "$base/$fil" if $fil !~ /^\Q$base\E/i;
        if ( $qs{B1} =~ /delete/i ) {
            unlink($fil);
          } else {
            if ( defined( $qs{contents} ) ) {
                $s1 = $qs{contents};
                $s1 = decodeHTMLEntities($s1);
                $s1 =~ s/\n$//;    # prevents ASSP from appending a newline to the file each time it is saved.
                $s1 =~ s/\r$//;
                $s1 =~ s/\s+$//;
                open( F, ">", $fil );
                print F $s1;
                close F;
                $s2 = '<span class="positive">File saved successfully</span>';
              }
          }
        if ( open( F, "<$fil" ) ) {
            local $/;
            $s1 = <F>;

            # make line terminators uniform
            $s1 =~ s/(?:\r?\n|\r)/\n/g;
            $s1 = encodeHTMLEntities($s1);
            close F;
          } else {
            $s2 = '<span class="negative">' . ucfirst($!) . '</span>';
          }
        if ( -e $fil ) {
            $editButtons =
'<div style="float: left"><input type="submit" name="B1" value="Save changes" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" name="B1" value="Delete file" onclick="return confirmDelete(\''
              . $fil
              . '\');"/></div>
        <div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>'
              if ( $qs{note} ne '8' );

            $editButtons =
'<div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>'
              if ( $qs{note} eq '8' );
          } else {
            $s2 = '<div class="text"><span class="positive">File deleted</span></div>'
              if $qs{B1} =~ /delete/i;
            $editButtons =
'<div style="float: left"><input type="submit" name="B1" value="Save changes" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" name="B1" value="Delete file" disabled="disabled" /></div>
        <div style="float: right">        	<input type="button" value="Close" onclick="javascript:window.close();"/></div>';

          }
      }
    return <<EOT;
$headerHTTP

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <title>ASSP File Editor ($myName $fil)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/editor.css\" type=\"text/css\" />
    <script type="text/javascript">
//<![CDATA[
	// Javascript code and layout adapted from TinyMCE
	// http://tinymce.moxiecode.com/
    <!--
        var wHeight=0, wWidth=0, owHeight=0, owWidth=0;
	
	    function resizeInputs() {
	    var contents = document.getElementById('contents');
	    var notebox = document.getElementById('notebox');
		//alert(el2.offsetHeight);
	
	    if (!isIE()) {
	    	 //alert(navigator.userAgent);
	         wHeight = self.innerHeight - (notebox.offsetHeight+60);
	         wWidth = self.innerWidth - 16;
	    } else {
			 //alert(navigator.userAgent);
	         wHeight = document.body.clientHeight - (notebox.offsetHeight+60);
	         wWidth = document.body.clientWidth - 16;
	    }
	
	    contents.style.height = Math.abs(wHeight) + 'px';
	    contents.style.width  = Math.abs(wWidth) + 'px';
    }
    
	function isIE () {
		var check,agent;
		check=/MSIE/i;
		agent=navigator.userAgent;
		if(check.test(agent)) {
			return true;
		} 
		else {
			return false;
		}
	}


	function confirmDelete(FileName)
	{
		var strmsg ="Are you sure you wish to delete: \\n" + FileName  + "\\n This action cannot be undone";
		var agree=confirm( strmsg );
		if (agree)
			return true;
		else
			return false;
	}
      //-->
    //]]>
    </script>
</head>
<body onresize="resizeInputs();" onload="resizeInputs();" style=" overflow:hidden;">
    <div class="content">
      <form action="" method="post">
        <span style="float: left;">Contents of $fil file:</span>
        <div id="message" style="float: right">$s2</div>
        <br style="clear: both" />
        <textarea id="contents" name="contents" rows="15" cols="100" style="width: 100%; height: 60%; font-family: 'Courier New',Courier,monospace; " wrap="off">$s1
</textarea>
        $editButtons
	</form><br />
		$note
		</div>
    </div>
  </body>
</html>

EOT

  }

sub webConfig {
    my $r = '';
    my @tmp;
    $ConfigChanged = 0;

    # don't post partial data if somebody's browser's busted
    undef %qs unless $qs{theButton} || $qs{theButtonX};
    my $counter = 0;
    foreach my $c (@ConfigArray) {
        if ( @{$c} == 5 ) {

            # Is a header
            @tmp = @{$c};
            push( @tmp, "setupItem$counter" );
            $r .= $c->[3]->(@tmp);
            $counter++;
          } else {

            # Is a variable
            $r .= $c->[3]->( @{$c} );
          }
      }
    if ($ConfigChanged) {
        SaveConfig();
        renderConfigHTML();
        PrintConfigSettings();
      }
    my $regexp1 = "";
    my $regexp2 = "";
my $reload  = '<table class="textBox" style="width: 99%;">
 <tr><td class="noBorder" align="left"></td><td class="noBorder" align="right">Panic Button:</td></tr>
<tr><td class="noBorder" align="left"></td><td class="noBorder" align="right"><form action="quit" method="post"><input type="submit" value="Terminate Now!" /></form></td></tr>
</table>';
    $regexp1 = "If Net::IP::Match::Regexp is installed  CIDR notation is allowed(182.82.10.0/24)."
      if !$CanMatchCIDR;
    $regexp2 =
"<br />If Net::IP::Match::Regexp is installed, Text after the range (and before a numbersign) will be accepted as comment which will be shown in a match (for example: 182.82.10.0/24 Yahoo Groups #comment not shown)."
      if !$CanMatchCIDR;
    $regexp1 = "CIDR notation is accepted (182.82.10.0/24)." if $CanMatchCIDR;
    $regexp2 =
"<br />Text after the range (and before a numbersign) will be accepted as comment to be shown in a match. For example:<br />182.82.10.0/24 Yahoo #comment to be removed"
      if $CanMatchCIDR;
    my $cidr = "";

    $cidr = "If Net::CIDR::Lite is installed, hyphenated ranges can be used (182.82.10.0-182.82.10.255)."
      if !$CanUseCIDRlite;
    $cidr = "Hyphenated ranges can be used (182.82.10.0-182.82.10.255)."
      if $CanUseCIDRlite;
    my $quit = '<form action="quit" method="post">
<table class="textBox" style="width: 99%;">
  <tr><td class="noBorder" align="center">Panic button: </td></tr>
  <tr><td class="noBorder" align="center"><input type="submit" value="Terminate Now!" /></td></tr>
</table>
</form>' unless $AsAService;
    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Configuration</h2>
<form name="ASSPconfig" id="ASSPconfig" action="" method="post">
<div>
$r
</div>
<div class="rightButton">
  <input name="theButton" type="submit" value="Apply Changes" />
  <input name="theButtonX" type="hidden" value="" />
</div>
<div class="textBox">
Fields marked with an asterisk (*) accept a list separated by | or a file designated as follows (path relative to the ASSP directory): 'file:files/filename.txt'.  Putting in the <i>file:</i> will prompt ASSP to put up a button to edit that file. <i>files</i> is the subdirectory for files. The file must not exist, you can create it by saving it. The file should have one entry per line; anything on a line following a numbersign ( #) is ignored (a comment).<br />
IP ranges are defined as for example 182.82.10. $regexp1 $cidr $regexp2.

</div>
</form>
$reload

<br />
$kudos
<br />
</div>
$footers
<script type="text/javascript">
<!--
  expand(0, 0);
  string = new String(document.location);
  string = string.substr(string.indexOf('#')+1);
  if(document.forms[0].length) {
    for(i = 0; i < document.forms[0].elements.length; i++) {
      if(string == document.forms[0].elements[i].name) {
        document.forms[0].elements[i].focus();
      }
    }
  }
// -->
</script>
</body></html>
EOT
  }
sub Donations {
<<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Kudos</h2>
<div class="note">
ASSP is here thanks to the following people:
</div>
<br />
<table style="width: 99%;" class="textBox">
<tr>
<td class="underline">John Hanna the founder and developer of ASSP's first versions.</td>
<td class="underline"></td>
</tr>
<tr>
<td class="underline">AJ the designer behind ASSP's web interface &amp; site.</td>
<td class="underline">&nbsp;</td>
</tr>
<tr>
<td class="underline">John Calvi the developer of ASSP from version 1.0.12.</td>
<td class="underline"></td>
</tr>
<tr>
<td class="underline">Robert Orso the developer of ASSP's LDAP functions.</td>
<td class="underline"></td>
</tr>
<tr>
<td class="underline">Przemek Czerkas the developer behind SRS, Greylisting/Delaying, Maillog Search.</td>
<td class="underline">&nbsp;</td>
</tr>
<tr>
<td class="underline">Fritz Borgstedt the developer of ASSP since 1.2.0</td>
<td class="underline"></td>
</tr>
<tr>
<td>&nbsp;</td>
<td></td>
</tr>
<tr>
<td colspan="2">
<div class="note">Special thanks go to......<br />
&nbsp;&nbsp;  Nigel Barling for his contributions to SPF &amp; RBL.<br />
&nbsp;&nbsp;  Mark Pizzolato for his contributions to SMTP Session Limits.<br />
&nbsp;&nbsp;  Craig Schmitt for his contributions to SPF2.<br />
&nbsp;&nbsp;  Thomas Eckardt for his contributions to Backscatter Check.<br />
&nbsp;&nbsp;  Wim Borghs, Micheal Espinola, Doug Traylor, Lars Troen, Andrew Macpherson, Javier Albinarrate for their contributions since 1.2.x.<br />

</div>
</td>
</tr>
</table>
<br />
$kudos
<br />
</div>
$footers
</body></html>
EOT
}

sub HTTPStrToTime {
    my $str = shift;
    if ( $str =~ /[SMTWF][a-z][a-z], (\d\d) ([JFMAJSOND][a-z][a-z]) (\d\d\d\d) (\d\d):(\d\d):(\d\d) GMT/ ) {
        my %MoY = qw(Jan 1 Feb 2 Mar 3 Apr 4 May 5 Jun 6 Jul 7 Aug 8 Sep 9 Oct 10 Nov 11 Dec 12);
        return eval {
            my $t = Time::Local::timegm( $6, $5, $4, $1, $MoY{$2} - 1, $3 - 1900 );
            $t < 0 ? undef : $t;
        };
      } else {
        return undef;
      }
  }

sub GetFile {
    my $fil = $qs{file};
    my %mimeTypes;
    if ( $fil =~ /\.\./ ) {
        mlog( 0, "file path not allowed while getting file '$fil'" );
        return <<EOT;
HTTP/1.1 403 Forbidden
Content-type: text/html

<html><body><h1>Forbidden</h1>
</body></html>
EOT
      }

    if ( $fil !~ /^\Q$base\E/i ) {
        $fil = "$base/$fil";
      }
    if ( -e $fil ) {
        my $mtime;
        if ( defined( $mtime = $head{'if-modified-since'} ) ) {
            if ( defined( $mtime = HTTPStrToTime($mtime) ) ) {
                if ( $mtime >= [ stat($fil) ]->[9] ) {
                    return "HTTP/1.1 304 Not Modified\n\r\n\r";
                  }
              }
          }
        if ( open( F, "<$fil" ) ) {
            binmode F;
            local $/;
            my $s = <F>;
            close F;
            %mimeTypes = (
                'log|txt|pl' => 'text/plain',
                'htm|html'   => 'text/html',
                'css'        => 'text/css',
                'bmp'        => 'image/bmp',
                'gif'        => 'image/gif',
                'jpg|jpeg'   => 'image/jpeg',
                'png'        => 'image/png',
                'zip'        => 'application/zip',
                'sh'         => 'application/x-sh',
                'gz|gzip'    => 'application/x-gzip',
                'exe'        => 'application/octet-stream',
                'js'         => 'application/x-javascript'
            );
            my $ct = 'text/plain';    # default content-type
            foreach my $key ( keys %mimeTypes ) {
                $ct = $mimeTypes{$key} if $fil =~ /\.($key)$/i;
              }
            $mtime = [ stat($fil) ]->[9];
            $mtime = gmtime($mtime);
            $mtime =~ s/(...) (...) +(\d+) (........) (....)/$1, $3 $2 $5 $4 GMT/;
            return <<EOT;
HTTP/1.1 200 OK
Content-type: $ct
Last-Modified: $mtime

$s
EOT
          }
      }
    return <<EOT;
HTTP/1.1 404 Not Found
Content-type: text/html

<html><body><h1>Not found</h1>
</body></html>
EOT

  }

sub Shutdown {
    <<EOT;
$headerHTTP
$headerDTDTransitional
$headers
<div class="content">
<h2>ASSP Shutdown/Restart</h2>
<div class="note">
Note: It's possible to restart, if ASSP runs as a service or in a script that restarts it after it stops,
otherwise this function can only shut ASSP down. In either case, shutdown is clean -- SMTP sessions are not
interrupted.
</div>
<br />
<table style="background-color: white; border-width: 0px; width: 500px">
<tr>
<td style="background-color: white; padding: 0px;">
<iframe src="/shutdown_frame" width="100%" height="300" frameborder="0" marginwidth="0" marginheight="0" scrolling="no"></iframe>
</td>
</tr>
</table>

</div>
$footers
</body></html>
EOT
  }

sub ShutdownFrame {
    my $action = $qs{action};
    my ( $s1, $s2, $editButtons, $query, $refresh );
    my $shutdownDelay = 2;

    my $timerJS = '
<script type="text/javascript">
  var ns=(navigator.appName.indexOf("Netscape")!=-1);
  var timerVal=parseInt(ns ? document.getElementById("myTimer1").childNodes[0].nodeValue : myTimer1.innerText);
  function countDown() {
    if (isNaN(timerVal)==0 && timerVal>=0) {
      if (ns) {
        document.getElementById("myTimer1").childNodes[0].nodeValue=timerVal--;
      } else {
        myTimer1.innerText=timerVal--;
      }
      setTimeout("countDown()",1000);
    }
  }
  countDown();
</script>';
    if ( $action =~ /abort/i ) {
        $shuttingDown = 0;
        $refresh      = 3;
        $s1           = 'Shutdown request aborted';
        $editButtons  = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />';
        $doShutdown = 0;
        $query      = '?nocache';
        mlog( 0, "shutdown/restart process aborted per admin request; SMTP session count:$smtpConcurrentSessions" );
      } elsif ( $action =~ /proceed/i || $shuttingDown ) {
        $shuttingDown = 1;
        $refresh = $smtpConcurrentSessions > 0 ? 2 : 60;
        $s1 =
          $smtpConcurrentSessions > 0
          ? 'Waiting for ' . needEs( $smtpConcurrentSessions, ' SMTP session', 's' ) . ' to finish ...'
          : "Shutdown in progress, please wait: <span id=\"myTimer1\">$refresh</span>s$timerJS";
        $editButtons = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort "'
          . ( $smtpConcurrentSessions > 0 ? '' : ' disabled="disabled"' ) . ' />
'
          . (
            $refresh > 1
            ? ''
            : '&nbsp;<input type="button" name="action" value=" View " onclick="javascript:window.open(\'shutdown_list?\',\'SMTP_Connections\',\'width=600,height=600,toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=yes,status=no,directories=no,resizable=yes\')" />'
          ) . '';

        $doShutdown = $smtpConcurrentSessions > 0 ? 0          : time + $shutdownDelay;
        $query      = $smtpConcurrentSessions > 0 ? '?nocache' : '?action=Success';
        mlog( 0, "shutdown/restart process initiated per admin request; SMTP session count:$smtpConcurrentSessions" )
          if $action =~ /proceed/i;
      } elsif ( $action =~ /success/i ) {
        $refresh     = 3;
        $s1          = 'ASSP restarted successfully.';
        $editButtons = '<input type="submit" name="action" value=" Proceed " disabled="disabled" />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />';
        $doShutdown = 0;
        $query      = '?nocache';
      } else {
        $refresh = 1;

        $s1 =
          $smtpConcurrentSessions > 0
          ? ( $smtpConcurrentSessions > 1 ? 'There are ' : 'There is ' )
          . needEs( $smtpConcurrentSessions, ' SMTP session', 's' )
          . ' active'
          : 'There are no active SMTP sessions';
        $editButtons = '<input type="submit" name="action" value=" Proceed " />&nbsp;
<input type="submit" name="action" value=" Abort " disabled="disabled" />&nbsp;
<input type="button" name="action" value=" View " onclick="javascript:window.open(\'shutdown_list?\',\'SMTP_Connections\',\'width=600,height=600,toolbar=no,menubar=no,location=no,personalbar=no,scrollbars=yes,status=no,directories=no,resizable=yes\')" />';
        $doShutdown = 0;
        $query      = '?nocache';
      }
    my $quit = '<form action="quit" method="post">
<table class="textBox" style="width: 99%;">
  <tr><td class="noBorder" align="center">Panic button:</td></tr>
  <tr><td class="noBorder" align="center"><input type="submit" value="Terminate ASSP now!" /></td></tr>
</table>
</form>' unless $AsAService;
    <<EOT;
$headerHTTP
$headerDTDTransitional
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <meta http-equiv="refresh" content="$refresh;url=/shutdown_frame$query" />
  <title>ASSP ($myName)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/shutdown.css\" type=\"text/css\" />
</head>
<body>
<div class="content">
<form action="" method="get">
  <table class="textBox">
    <tr>
      <td class="noBorder" nowrap>
        $editButtons&nbsp;&nbsp;&nbsp;$s1
      </td>
    </tr>
  </table>
</form>
</div>
<div class="content">

$quit
</div>
</body></html>
EOT
  }

# Micheal Espinola - Add new pop-up window for listing SMTP connection information, allowing
# the main window to be used for other tasks simultaniously. Window is fully resizable and
# scrollable. SMTP Connection list has been slightly reformatted for asthetics and readability.
sub ShutdownList {
    my $action = $qs{action};
    my ( $s1, $s2, $editButtons, $query, $refresh );
    my $rowclass;
    my $shutdownDelay = 2;

    my $timerJS = '
<script type="text/javascript">
  var ns=(navigator.appName.indexOf("Netscape")!=-1);
  var timerVal=parseInt(ns ? document.getElementById("myTimer1").childNodes[0].nodeValue : myTimer1.innerText);
  function countDown() {
    if (isNaN(timerVal)==0 && timerVal>=0) {
      if (ns) {
        document.getElementById("myTimer1").childNodes[0].nodeValue=timerVal--;
      } else {
        myTimer1.innerText=timerVal--;
      }
      setTimeout("countDown()",1000);
    }
  }
  countDown();
</script>';
    $refresh = 1;
    $query   = '?nocache';
    $s1      = '<div style="float: left;">';
    $s1 .=
      $smtpConcurrentSessions > 0
      ? ( $smtpConcurrentSessions > 1 ? 'There are ' : 'There is ' )
      . needEs( $smtpConcurrentSessions, ' SMTP session', 's' )
      . ' active.</div>'
      : 'There are no active SMTP sessions.' . '</div>';
    $s1 .= '<div style="float: right;">' . localtime() . '</div><br />';

    $s2 =
"<tr><td class=\"conTabletitle\">#</td><td class=\"conTabletitle\">Remote IP</td><td class=\"conTabletitle\">HELO</td><td class=\"conTabletitle\">From</td><td class=\"conTabletitle\">Rcpt</td><td class=\"conTabletitle\">Relaying</td><td class=\"conTabletitle\">SPAM</td><td class=\"conTabletitle\">Bytes</td><td class=\"conTabletitle\">Duration</td><td class=\"conTabletitle\">Inactive</td></tr>";

    my $tmpTimeNow = time();

    my @tmpConKeys = keys(%Con);
    my @tmpConSortedKeys =
      sort { $Con{$a}->{timestart} <=> $Con{$b}->{timestart} } @tmpConKeys;
    my $tmpCount = 0;
    foreach my $key (@tmpConSortedKeys) {
        if ( $Con{$key}->{ip} ) {
            $tmpCount++;
            my $tmpDuration = $tmpTimeNow - $Con{$key}->{timestart};
            my $tmpInactive = $tmpTimeNow - $Con{$key}->{timelast};
            if ( $tmpCount % 2 == 1 ) {
                $rowclass = "\n<tr>";
              } else {
                $rowclass = "\n<tr class=\"even\">";
              }
            $s2 .=
                $rowclass
              . '<td><b>'
              . ($tmpCount)
              . '</b></td><td>'
              . $Con{$key}->{ip}
              . '</td><td>'
              . substr( $Con{$key}->{helo}, 0, 25 )
              . '</td><td>'
              . substr( $Con{$key}->{mailfrom}, 0, 30 )
              . '</td><td>'
              . substr( $Con{$key}->{rcpt}, 0, 30 )
              . '</td><td>'
              . $Con{$key}->{relayok}
              . '</td><td>'
              . $Con{$key}->{spamfound}
              . '</td><td>'
              . $Con{$key}->{maillength}
              . '</td><td>'
              . $tmpDuration
              . '</td><td>'
              . $tmpInactive
              . '</td></tr>';
          }
      }

    <<EOT;
$headerHTTP
$headerDTDTransitional
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <meta http-equiv="refresh" content="$refresh;url=/shutdown_list$query" />
  <title>ASSP ($myName)</title>
  <link rel=\"stylesheet\" href=\"get?file=images/assp.css\" type=\"text/css\" />
</head>
<body>
<div >
<div style="float: right"><input type="button" value="Close" onclick="javascript:window.close();"/></div>
<h2>SMTP Connections List</h2>
$s1
<table cellspacing="0" id="conTable">
$s2
</table>
<br />
</div>
</body></html>
EOT
  }

sub SaveConfig {

    rename( "$base/assp.cfg.bak.bak", "$base/assp.cfg.bak.bak.bak" );
    rename( "$base/assp.cfg.bak",     "$base/assp.cfg.bak.bak" );
    rename( "$base/assp.cfg",         "$base/assp.cfg.bak" );
    open( F, ">$base/assp.cfg" );
    foreach my $c (@ConfigArray) {
        next if $c->[0] eq "0";
        print F "$c->[0]:=$Config{$c->[0]}\n";
      }
    print F "globalRegisterURL:=$globalRegisterURL\n";
    print F "globalUploadURL:=$globalUploadURL\n";
    close F;
    my @s = stat("$base/assp.cfg");
    $cfgtime = $s[9];

  }

sub backupFile {
    return;    # unless $BackupCopies > 0;
    my $f  = shift;
    my $bf = $f;
    $bf =~ s/.*[\\\/]|/bak\//;
    my $i;

    #    my $i = $BackupCopies - 1;
    unlink("$base/$bf.$i");
    for ( ; $i > 0 ; $i-- ) {
        rename( "$base/$bf." . ( $i - 1 ), "$base/$bf.$i" );
      }
    rename( $f, "$base/$bf.0" );
  }

sub textinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption,$note)=@_;
 my $Error = checkUpdate($name,$valid,$onchange);
 my $value = encodeHTMLEntities($Config{$name});
 #my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
# my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
my $hdefault = encodeHTMLEntities($default);
$hdefault =~ s/'|"|\n//g;
$hdefault =~ s/\\/\\\\/g;
$hdefault = '&nbsp;' unless $hdefault;
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmousedown=\"document.forms['ASSPconfig'].$name.value='$default';return false;\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>click to reset<br />to default value</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";
 my $edit  = '';
 $note=1 if !$note;

 if ($value=~/^\s*file:\s*(.+)\s*/i){
  # the optionlist is actually saved in a file.
  my $fil = $1;
  # escape query string
  $fil  =~ s/([^\w\-.!~*\'() ])/sprintf("%%%02X",ord($1))/eg;
  $fil  =~ s/ /+/g;
  $edit = "<input type=\"button\" value=\" Edit file \" onclick=\"javascript:popFileEditor(\'$fil\',$note);\" />";
 }
 # get rid of google autofill
 #$name=~s/(e)(mail)/$1_$2/gi;
 return "<a name=\"$name\"></a>
 <div class=\"shadow\">
  <div class=\"option\">
   <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
   <div class=\"optionValue\">
    <input name=\"$name\" size=\"$size\" value=\"$value\" />
    $edit<br />
    $Error
    $description\n
   </div>
  </div>
  &nbsp;
 </div>";

}

sub textnoinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption,$note)=@_;
 my $Error = checkUpdate($name,$valid,$onchange);
 my $value = encodeHTMLEntities($Config{$name});
 #my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
# my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
my $hdefault = encodeHTMLEntities($default);
$hdefault =~ s/'|"|\n//g;
$hdefault =~ s/\\/\\\\/g;
$hdefault = '&nbsp;' unless $hdefault;
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>default value:</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";
 my $edit  = '';
 $note=1 if !$note;

 if ($value=~/^\s*file:\s*(.+)\s*/i){
  # the optionlist is actually saved in a file.
  my $fil = $1;
  # escape query string
  $fil  =~ s/([^\w\-.!~*\'() ])/sprintf("%%%02X",ord($1))/eg;
  $fil  =~ s/ /+/g;
  $edit = "<input type=\"button\" value=\" Edit file \" onclick=\"javascript:popFileEditor(\'$fil\',$note);\" />";
 }
 # get rid of google autofill
 #$name=~s/(e)(mail)/$1_$2/gi;
 return "<a name=\"$name\"></a>
 <div class=\"shadow\">
  <div class=\"option\">
   <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
   <div class=\"optionValue\">
    <input name=\"$name\" readonly style=\"background:#eee none; color:#222; font-style: italic\" size=\"$size\" value=\"$value\" />
    $edit<br />
    $Error
    $description\n
   </div>
  </div>
  &nbsp;
 </div>";

}

# everybody wants this, but I hate it -- use it if you care.
sub passinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $value=encodeHTMLEntities($Config{$name});
 #my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
#my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
my $hdefault = encodeHTMLEntities($default);
$hdefault =~ s/'|"|\n//g;
$hdefault =~ s/\\/\\\\/g;
$hdefault = '&nbsp;' unless $hdefault;
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>default value:</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";
"<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
  <div class=\"optionValue\"><input type=\"password\" name=\"$name\" size=\"$size\" value=\"$value\" /><br />\n$Error$description
  </div>
 </div>
 &nbsp;
 </div>";
}
sub passnoinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $value=encodeHTMLEntities($Config{$name});
# my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
my $hdefault = encodeHTMLEntities($default);
$hdefault =~ s/'|"|\n//g;
$hdefault =~ s/\\/\\\\/g;
$hdefault = '&nbsp;' unless $hdefault;
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>default value:</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";
"<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
  <div class=\"optionValue\"><input type=\"password\" readonly style=\"background:#eee none; color:#222; font-style: italic\" name=\"$name\" size=\"$size\" value=\"$value\" /><br />\n$Error$description
  </div>
 </div>
 &nbsp;
 </div>";
}
sub listbox {
	
	my ( $name, $nicename, $values, $func, $default, $valid, $onchange, $description, $cssoption ) = @_;
	my $Error = checkUpdate( $name, $valid, $onchange);

	my $options;
        my $hdefault;
	foreach my $opt ( split( /\|/, $values ) ) {
		my ( $v, $d ) = split( /:/, $opt, 2 );
		$d = $v unless $d;
		if ( $Config{$name} eq $v ) {
			$options .= "<option selected=\"selected\" value=\"$v\">$d</option>";
		} else {
			$options .= "<option value=\"$v\">$d</option>";
		}
                $hdefault = $d if ( $default eq $v );
	}

#	my $cfgname = $EnableInternalNamesInDesc ? "<i>($name)</i>" : "";
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmousedown=\"document.forms['ASSPconfig'].$name.value='$default';return false;\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>click to reset<br />to default value</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";

	"<a name=\"$name\"></a>
 	<div class=\"shadow\">
 	<div class=\"option\">
  <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
  <div class=\"optionValue\">
  <span style=\"z-Index:100;\"><select size=\"1\" name=\"$name\">
	$options
	</select></span>
  <br />\n$Error$description
  </div>
 </div>
 &nbsp;
 </div>";
}
sub checkbox {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $checked=$Config{$name}?'checked="checked"':'';
 my $disabled = "";
 my $isrun = "";
 my $script = "";


 if (($name =~ /forceLDAPcrossCheck/) && ($isrunLDAPcrossCheck or ! $CanUseLDAP or ! $ldaplistdb)) {
   $disabled = "disabled";
   $isrun = 'LDAP-CrossCheck is just running - not available now!<br />';
   $isrun = 'LDAPlist is not configured - not available now!<br />' if (! $ldaplistdb);
   $isrun = 'module Net::LDAP is not available!<br />' if (! $CanUseLDAP);
   if ($Config{$name}) {
     $script = "<script type=\"text/javascript\">alert(\'you browser will be restarted\');open(location.href);window.close();</script>";
#     $script = "<script type=\"text/javascript\">open(location.href);window.close();</script>";
     $Config{$name} = "";
     ${$name} = "";
     $checked = "";
   }
 }
 

 #my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
#my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
my $hdefault = $default ? 'on' : 'off' ;
my $cdefault = $default ? 'true' : 'false' ;
my $cfgname = $EnableInternalNamesInDesc?"<a href=\"#$name\" onmousedown=\"document.forms['ASSPconfig'].$name.checked=$cdefault;return false;\" onmouseover=\"showhint('<table BORDER CELLSPACING=0 CELLPADDING=4 WIDTH=\\'100%\\'><tr><td>click to reset<br />to default value</td><td>$hdefault</td></tr></table>', this, event, '450px', ''); return true;\" onmouseout=\"window.status='';return true;\"><i>($name)</i></a>":"";

 "<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">
   <input type=\"checkbox\" $disabled name=\"$name\" value=\"1\" $checked /><span style=\"color:red\">$isrun</span>$nicename $cfgname<br /></div>
  <div class=\"optionValue\">\n$Error$description
  </div>
 </div>
 &nbsp;
 </div>$script";
}

sub heading {
    my ( $description, $nodeId ) = @_[ 4, 5, 6 ];

    
    "</div>
<div onmousedown=\"toggleDisp('$nodeId')\" class=\"contentHead\">
 $description
</div>
<div id=\"$nodeId\">\n";
  }

sub checkUpdate {
    my ( $name, $valid, $onchange ) = @_;
    return '' unless %qs;
    if ( $qs{$name} ne $Config{$name} ) {
        if ( $qs{$name} =~ /$valid/i ) {
            my $new = $1;
            my $info;
            my $old = $Config{$name};
            $Config{$name} = $new;
            if ($onchange) {
                $info = $onchange->( $name, $old, $new );
              } else {
                mlog( 0, "AdminUpdate: $name changed from '$old' to '$new'" )
                  unless $new eq $old;
                ${$name} = $new;

                # -- this sets the variable name with the same name as the config key to the new value
                # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
              }
            $ConfigChanged = 1;
            return "<span class=\"positive\"><b>*** Updated $info</b></span><br />"
              unless $new eq $old;
          } else {
            return "<span class=\"negative\"><b>*** Invalid: '$qs{$name}'</b></span><br />";
          }
      }
  }

sub PrintConfigSettings {
    my $desc;
    open( F, ">$base/notes/configdefaults.txt" );
    foreach my $c (@ConfigArray) {
        print F "########## $c->[4] ##########\n" if $c->[0] eq "0";
        next if $c->[0] eq "0";
        $desc = $c->[1];

        $desc =~ s/\<.*\>//g;
        my $c0 = uc $c->[0];

        if ( $c->[4] != $Config{ $c->[0] } ) {
            print F "$c->[0] -- $desc: $Config{$c->[0]} (Default: $c->[4]) \n";
          } else {

            #print F "$c->[0] -- $desc: $Config{$c->[0]}  \n";
          }
      }
    close F;

    open( F, ">$base/notes/config.txt" );
    foreach my $c (@ConfigArray) {
        $desc = $c->[7];
        $desc =~ s/\<b\>//g;
        $desc =~ s/\<i\>//g;
        $desc =~ s/\<p\>//g;
        $desc =~ s/\<small\>//g;
        $desc =~ s/\<br \/\>//g;
        $desc =~ s/\<\/i\>//g;
        $desc =~ s/\<\/b\>//g;
        $desc =~ s/\<\/p\>//g;
        $desc =~ s/\<\/small\>//g;
        $desc =~ s/\<.*\>//g;
        $desc =~ s/\<.*\>//g;

        my $c0  = uc $c->[0];
        my $act = "actual: $Config{$c->[0]}" if $Config{ $c->[0] };
        my $def = "default: $c->[4]" if $c->[4];
        print F "$c->[0]: $c->[1] -- $desc $def \n"
          if $Config{ $c->[0] } eq $c->[4] && $c->[0] ne "0";
        print F "$c->[0]: $c->[1] -- $desc $def  \n"
          if $Config{ $c->[0] } ne $c->[4] && $c->[0] ne "0";
        print F "########## $c->[4] ##########\n" if $c->[0] eq "0";

      }
    close F;

  }

sub SaveConfigSettings {
    return if $Config{asspCfgVersion} eq "$version$modversion";
    $Config{asspCfgVersion} = "$version$modversion";

    SaveConfig();

    # load new configuration file
    reloadConfigFile();

    PrintConfigSettings();
  }

sub PrintConfigHistory {
    my ($text) = @_;
    my $lt = localtime(time);
    $text =~ s/^AdminUpdate://i;
    open( F, ">>$base/notes/confighistory.txt" );
    print F "$lt:  $text\n";
    close F;
  }

sub PrintAdminInfo {
    my ($text) = @_;
    my $lt = localtime(time);
    $text =~ s/^AdminUpdate://i;
    open( F, ">>$base/notes/admininfo.txt" );
    print F "$lt:  $text\n";
    close F;
  }

# This function is called on startup to clean up some settings
# Primarily these are settings that might be absent from assp.cfg
# or settings that are not needed anymore after an upgrade
sub fixConfigSettings {
    $Config{base} = $base;

    $Config{webAdminPassword} = crypt( $Config{webAdminPassword}, "45" )
      if substr( $Config{webAdminPassword}, 0, 2 ) ne "45";
      
	$Config{DoPenalty} = 2
	  if $Config{DoPenalty} == 3;
    $Config{redRe} = "file:files/redre.txt"
      if $Config{redRe} =~ /file:redre.txt/i;
    $Config{noDelay} = "file:files/nodelay.txt"
      if $Config{noDelay} =~ /file:nodelay.txt/i;
    my $mydelaydb = $Config{delaydb};

    $Config{DelayShowDBwhite} = "file:$mydelaydb.white";
    $Config{DelayShowDB}      = "file:$mydelaydb";
    if ( exists $Config{DNSTimeout} ) {
        delete $Config{DNSTimeout};
      }
    if ( exists $Config{CleanCacheInterval} ) {
        delete $Config{CleanCacheInterval};
      }
    if ( exists $Config{DNSServer} ) {
        delete $Config{DNSServer};
      }
    if ( exists $Config{ExtensionsToBlock} ) {
        $Config{BadAttachL1} = $Config{ExtensionsToBlock};

        # ExtensionsToBlock is not used in this version
        delete $Config{ExtensionsToBlock};
      }
    if ( exists $Config{EmailWhitelist} ) {
        $Config{EmailWhitelistAdd} = $Config{EmailWhitelist};

        # EmailWhitelist is not used in this version
        delete $Config{EmailWhitelist};
      }

    # -- this sets the variable name with the same name as the config key to the new value
    # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
    foreach ( keys %Config ) { ${$_} = $Config{$_}; }

    # turn settings into regular expressions

    @PossibleOptionFiles = ();
    foreach my $c (@ConfigArray) {
        next if @{$c} == 1;    # skip headings
        if (   $c->[6] eq 'ConfigMakeRe'
            || $c->[6] eq 'ConfigMakeSLRe'
            || $c->[6] eq 'ConfigMakeIPRe'
            || $c->[6] eq 'ConfigCompileRe' ) {
            $c->[6]->( $c->[0], '', ${ $c->[0] }, 'Initializing', $c->[1] );
            push( @PossibleOptionFiles, [ $c->[0], $c->[1], $c->[6] ] );
          } elsif ( $c->[6] == \&configMakeSubTagRe ) {

            # turn subject prepends into regular expressions
            $c->[6]->( $c->[0], '', ${ $c->[0] }, 'Initializing', $c->[1] );
          }
      }
    #updateDNS( 'DNSServers', '', $Config{DNSServers}, 'Initializing' );
    updateBadAttachL1( 'BadAttachL1', '', $Config{BadAttachL1}, 'Initializing' );
    updateGoodAttach( 'GoodAttach', '', $Config{GoodAttach}, 'Initializing' );

    configUpdateSPFfall( 'configUpdateSPFfall', '', $Config{SPFfallback}, 'Initializing' );
    configUpdateSPFover( 'configUpdateSPFover', '', $Config{SPFoverride}, 'Initializing' );
    configChangeRT( 'configChangeRT', '', $Config{smtpDestinationRT}, 'Initializing' );
    configUpdateRBL( 'configUpdateRBL', '', $Config{ValidateRBL}, 'Initializing' );
    configUpdateRWL( 'configUpdateRWL', '', $Config{ValidateRWL}, 'Initializing' );
    configUpdateURIBL( 'configUpdateURIBL', '', $Config{ValidateURIBL}, 'Initializing' );
    configUpdateCA( 'configUpdateCA', '', $Config{CatchAll}, 'Initializing' );
    configUpdateCCD( 'configUpdateCCD', '', $Config{ccSpamInDomain}, 'Initializing' );

    updateSRS( 'updateSRS', '', $Config{EnableSRS}, 'Initializing' );
    updateLog2( 'updateLog2', '', $Config{freqNonSpam}, 'Initializing' );
    updateLog3( 'updateLog3', '', $Config{freqSpam}, 'Initializing' );

  }

sub optionFilesReload {

    # check if options files have been updated and need to be re-read
    foreach my $f (@PossibleOptionFiles) {
        $f->[2]->( $f->[0], $Config{ $f->[0] }, $Config{ $f->[0] }, '', $f->[1] )
          if $Config{ $f->[0] } =~ /^ *file: *(.+)/i && fileUpdated( $1, $f->[0] );
      }
  }

sub ConfigMakeRe {
 my ($name, $old, $new, $init)=@_;
 mlog(0,"AdminUpdate: $name changed from '$old' to '$new'") unless $init || $new eq $old;
 $new=checkOptionList($new,$name,$init);
 if ($name eq "localDomains") {
        my @entry = split(/\|/,$new);
        $new = '';
        my $ld;
        my $lds;
        my $mta;
        %DomainVRFYMTA = ();
        foreach my $a (@entry) {
           ($ld,$mta) = split(/\=\>/,$a);
           $DomainVRFYMTA{lc $ld} = $mta if $mta;
           $ld=~s/([\.\[\]\-\(\)\+\\])/\\$1/g;
           $ld=~s/\*/\.\{0,32\}/g;
           $lds .= $ld.'|';
           $new .= $ld.'|';
        }
        chop($new);
        chop($lds);
 	$lds=~s/\|/\|by /g;
  	$localdomainre="by $lds";
        $new||='^(?!)'; # regexp that never matches
        $MakeRE{$name}->($new);
        return '';
 }
 $new=~s/([\.\[\]\-\(\)\+\\])/\\$1/g;
 $new=~s/\*/\.\{0,32\}/g;
 $new||='^(?!)'; # regexp that never matches

 $MakeRE{$name}->($new);
 '';
}

# make spamlover RE
sub ConfigMakeSLRe {
    my ( $name, $old, $new, $init, $desc ) = @_;
    mlog( 0, "admin update: $name changed from '$old' to '$new'" )
      unless $init || $new eq $old;
    $new = checkOptionList( $new, $name, $init );
    $new =~ s/\*/\.\{0,32\}/g;
    my ( @uad, @u, @d );
    foreach my $a ( split( /\|/, $new ) ) {
        if ( $a =~ /\S\@\S/ ) {
            push( @uad, $a );
          } elsif ( $a =~ /^\@/  || $name eq "LocalAddresses_Flat" && $LocalAddresses_Flat_Domains) {
            push( @d, $a );
          } else {
            push( @u, $a );
          }
      }
    my @s;
    push( @s, '^(' . join( '|', @uad ) . ')$' ) if @uad;
    push( @s, '^(' . join( '|', @u ) . ')@' )   if @u;
    push( @s, '(' . join( '|', @d ) . ')$' ) if @d;
    my $s = join( '|', @s );
    $s ||= '^(?!)';    # regexp that never matches
    SetRE( $MakeSLRE{$name}, $s, 'i', $desc );
    '';
  }

# make IP address RE
# allow for CIDR notation if Net::IP::Match::Regexp available
sub ConfigMakeIPRe {

 my ($name, $old, $new, $init, $desc)=@_;
 my $newexpanded;
 my $cips;
 mlog(0,"AdminUpdate: $name changed from '$old' to '$new'") unless $init || $new eq $old;
 $new=~s/\s*\-\s*/\-/g;
 $new=checkOptionList($new,$name,$init) ;
 
if ($CanMatchCIDR) {
	foreach my $l (split(/\|/,$new)) {

		$l=~s/\.\./\./g;
		$l=~s/--+/*/g;
		$l=~s/#.*//g;


		
		$l=~s/^(\d+\.\d+\.\d+\.\d+)\s+(\d+\.\d+\.\d+\.\d+)/$1-$2/g;


		if ($CanUseCIDRlite && $l=~/^\d+\.\d+\.\d+\.\d+-\d+\.\d+\.\d+\.\d+/ ) {

				$l=~s/(\d+\.\d+\.\d+\.\d+-\d+\.\d+\.\d+\.\d+)(.*)/$1/g;
				$desc=$2;

                my $cidr = Net::CIDR::Lite->new;
                eval { $cidr->add_any($l); };
                if ($@) {
                    $@ =~ /^(.+?)\sat\s/;
                    mlog( 0, "AdminInfo: $name: $1 ($l)" );
                    next;
                }
                my @cidr_list = $cidr->list;
                my $cidr_join = join( "$desc|", @cidr_list );
                $newexpanded .= $cidr_join . "$desc|";
                next;
         }
            $newexpanded .= $l . "|";
          }
        $newexpanded =~ s/\|$//;
        $new = $newexpanded;

      }
    $new =~ s/\|\|/\|/g;
    if ($CanMatchCIDR) {
        my %ips;
        foreach my $l ( split( /\|/, $new ) ) {

            #if (my @matches=$l=~/^($IPQuadRE)\.?(\/\d{1,2})?\s*(.*)\s*$/io) {
            if ( my @matches = $l =~ /(\d{1,3}\.)(\d{1,3}\.?)?(\d{1,3}\.?)?(\d{1,3})?(\/)?(\d{1,3})?\s*(.*)\s*$/io ) {
                mlog( 0, "AdminInfo: $name, error in line $l, Dotted Quad Number > 255 " )
                  if $1 > 255 || $2 > 255 || $3 > 255 || $4 > 255;

                next if $1 > 255 || $2 > 255 || $3 > 255 || $4 > 255;
                my $description = $7;
                my $ip          = $1 . $2 . $3 . $4;

                $ip =~ s/\.$//g;

                my $bits = $5 . $6;
                $bits = "" if !$bits;

                $desc = "$ip$bits $description" if $description;
                $desc = "$ip$bits" if !$description;

                my $dcnt = ( $ip =~ tr/\.// );
                if ( $dcnt >= 3 ) {
                    $bits ||= '/32';
                  } elsif ( $dcnt >= 2 ) {
                    $ip .= '.0';
                    $bits ||= '/24';
                  } elsif ( $dcnt >= 1 ) {
                    $ip .= '.0' x 2;
                    $bits ||= '/16';
                  } else {
                    $ip .= '.0' x 3;
                    $bits ||= '/8';
                  }

                $desc =~ s/'/\\'/g;
                $desc ||= 1;
                mlog( 0, "AdminInfo: $name error in line $l, IP notation: $ip$bits" )
                  if "$ip$bits" !~ /\d{1,3}\.(\d{1,3}\.)(\d{1,3}\.)(\d{1,3})(\/)(\d{1,2})/;
                next
                  if "$ip$bits" !~ /(\d{1,3}\.)(\d{1,3}\.)(\d{1,3}\.)(\d{1,3})(\/)(\d{1,2})/;
                $ips{"$ip$bits"} = $desc;
                $cips++;

              }
          }

        if ( scalar keys %ips ) {
            eval { $new = Net::IP::Match::Regexp::create_iprange_regexp( \%ips ); };
            mlog( 0, "AdminInfo:$name $@" ) if $@;
          } else {
            $new = qr/^(?!)/;    # regexp that never matches
          }
        ${ $MakeIPRE{$name} } = $new;
      } else {
        my %ips;
        foreach my $l ( split( /\|/, $new ) ) {
            if ( my @matches = $l =~ /(\d{1,3}\.)(\d{1,3}\.?)?(\d{1,3}\.?)?(\d{1,3})?(\/)?(\d{1,3})?\s*(.*)\s*$/io ) {
                my $description = $7;
                my $ip          = $1 . $2 . $3 . $4;

                $desc = "$ip $description" if $description;
                $desc = "$ip" if !$description;
                $desc =~ s/'/\\'/g;
                $desc ||= 1;
                $ips{$ip} = $desc;
                $cips++;
              }
          }

        my @ips;
        while ( my ( $ip, $desc ) = each(%ips) ) {
            $ip =~ s/([\.\[\]\-\(\)\*\+\\])/\\$1/g;
            $ip ||= '^(?!)';    # regexp that never matches
            $desc =~ s/'/\\'/g;
            $desc ||= 1;
            push( @ips, "$ip(?{'$desc'})" );
          }
        $new = join( '|', @ips );
        use re 'eval';
        eval { ${ $MakeIPRE{$name} } = qr/^($new)/ };
        mlog( 0, "AdminInfo: regular expression error in '$name:$new' for $desc: $@" ) if $@;
      }
    '';
  }

# check if IP address matches RE
sub matchIP {
    my ( $ip, $re, $fh, $donotmlog ) = @_;
    my $reRE = ${ $MakeIPRE{$re} };

    return 0 unless $ip && $reRE;
    my $ret;
    local $^R;
    use re 'eval';
    if ($CanMatchCIDR) {
        ( '4' . unpack 'B32', pack 'C4', split /\./xms, $ip ) =~ /$reRE/xms;
      } else {
        $ip =~ /$reRE/xms;
      }
    $ret = $^R;
    return $ret if $re eq 'noLog';
    mlog( $fh, "IP $ip" . ( $ret == 1 ? '' : " ($ret)" ) . " matches $re", 1 )
      if $ipmatchLogging && !matchIP( $ip, 'noLog' ) && $ret && !$donotmlog;
    return $ret;
  }

# check if email address matches RE
sub matchSL {
    my ( $a, $re, $nolog ) = @_;
    my $reRE = ${ $MakeSLRE{$re} };
    return 0 unless $reRE;
    mlog( 0, "$a matches $1 in $re", 1 )
      if $slmatchLogging && $a =~ ( '(' . $reRE . ')' ) && !$nolog;
    return $a =~ /$reRE/;
  }

# check if email address or IP address matches RE
sub matchSLIP {
    my ( $a, $ip, $re ) = @_;
    return matchSL( $a, $re ) || matchIP( $ip, $re );
  }

# this checks and corrects a | separated list
# and handles the options in a file
sub checkOptionList {
    my ( $value, $name, $init ) = @_;
    my $fromfile = 0;
    if ( $value =~ /^ *file: *(.+)/i ) {

        # the option list is actually saved in a file.
        $fromfile = 1;
        my $fil = $1;
        $fil = "$base/$fil" if $fil !~ /^\Q$base\E/i;
        local $/;
        my @s     = stat($fil);
        my $mtime = $s[9];
        $FileUpdate{"$fil$name"} = $mtime;
        $FileUpdate{$fil} = $mtime;
        if ( open( F, '<', $fil ) ) {
            $value = <F>;

            # clean off comments

            $value =~ s/#.*//g;

            # replace newlines (and the whitespace that surrounds them) with a |
            $value =~ s/\s*\n\s*/|/g;
            close F;
            mlog( 0, "option list file '$fil' reloaded ($name)" )
              unless ( ( $init || !$MaintenanceLog ) );
          } else {
            mlog( 0, "AdminInfo: failed to open option list file for reading '$fil' ($name): $!" );
            $value = '';
          }
      }
    $value =~ s/\|\|/\|/g;
    $value =~ s/\s*\|/\|/g;
    $value =~ s/\|\s*/\|/g;
    $value =~ s/\|\|+/\|/g;
    $value =~ s/^\s*\|?//;
    $value =~ s/\|?\s*$//;
    $value =~ s/\|$//;
    $value =~ s/^\|?//;

    # set corrected value back in Config
    ${$name} = $Config{$name} = $value unless $fromfile;
    return $value;
  }

sub ConfigCompileRe {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: $name changed from '$old' to '$new'" )
      unless $init || $new eq $old;
    $new = checkOptionList( $new, $name, $init );
    if ( $name eq "MyCountryCodeRe" && !$new && $localhostip ) {
        $new = SenderBaseMyIP( 0, $localhostip );

      }

    $new ||= '^(?!)';    # regexp that never matches
    $new =~ s/\.\*/\.\{0,32\}/g;
   # trim long matches to 32 chars including '...' at the end
    my $reLength=$RegExLength || 32;
		SetRE($name.'RE',"($new)(?{length(\$1)>$reLength?substr(\$1,0,$reLength-3).'...':\$1})",'is',$name);

 #SetRE( $name . 'RE', $new, 'si', $name );
    '';
  }

sub optionList {

    # this converts a | separated list into a RE
    my ( $d, $configname ) = @_;
    $d = checkOptionList( $d, $configname );
    $d =~ s/([\.\[\]\-\(\)\*\+\\])/\\$1/g;
    $MakeRE{$configname}->($d);
    $d;
  }

sub fileUpdated {

    my ( $fil, $configname ) = @_;

    $fil = "$base/$fil" if $fil !~ /^(([a-z]:)?[\/\\]|\Q$base\E)/;

    #$fil="$base/$fil" if $fil!~/^\Q$base\E/i;
    return 1 unless $FileUpdate{"$fil$configname"};
    my @s     = stat($fil);
    my $mtime = $s[9];
    $FileUpdate{"$fil$configname"} != $mtime;
  }

sub configChangeRT {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SMTP Destination Routing Table updated from '$old' to '$new'" ) unless $init || $new eq $old;
    $smtpDestinationRT = $new;
    $new = checkOptionList( $new, 'smtpDestinationRT', $init );
    my $v;
    for $v ( split( /\|/, $new ) ) {
        $v =~ /(.*)\=\>(.*)/;
        $crtable{$1} = $2;
      }

  }

sub ConfigChangeMailPort {
    my ( $name, $old, $new ) = @_;
    if ( $> == 0 || $new >= 1024 ) {

        # change the listenport
        $listenPort = $new;
        if ($lsn) {
            $readable->remove($lsn);
            $lsn->close();
          }
        $lsn = newListen( $listenPort, \&NewSMTPConnection );
        mlog( 0, "AdminUpdate: listening on new mail port $listenPort (changed from $old) " );
        return '';
      } else {

        # don't have permissions to change
        mlog( 0,
            "AdminUpdate: request to listen on new mail port $new (changed from $old) -- restart required; euid=$>" );
        return "<br />Restart required; euid=$>";
      }
  }

sub ConfigChangeMailPort2 {
    my ( $name, $old, $new ) = @_;
    if ( $> == 0 || $new >= 1024 ) {

        # change the listenport2
        $listenPort2 = $new;
        if ($lsn2) {
            $readable->remove($lsn2);
            $lsn2->close();
          }
        $lsn2 = newListen( $listenPort2, \&NewSMTPConnection );
        mlog( 0, "AdminUpdate: listening on new secondary mail port $listenPort2 (changed from $old)" );
        return '';
      } else {

        # don't have permissions to change
        mlog( 0,
"AdminUpdate: request to listen on new secondary mail port $new (changed from $old) -- restart required; euid=$>"
        );
        return "<br />Restart required; euid=$>";
      }
  }

sub ConfigChangeAdminPort {
    my ( $name, $old, $new ) = @_;
    if ( $> == 0 || $new >= 1024 ) {

        # change the listenport
        $webAdminPort = $new;
        $readable->remove($WebSocket);
        $WebSocket->close();
        $WebSocket = newListen( $webAdminPort, \&NewWebConnection );
        if ($WebSocket) {
            mlog( 0, "AdminUpdate: listening on new admin port $new (changed from $old)" );
          } else {

            # couldn't open the port -- switch back
            $webAdminPort = $old;
            $WebSocket = newListen( $webAdminPort, \&NewWebConnection );
            mlog( 0, "AdminUpdate: couldn't open new port -- still listening on $old" );
            $Config{$name} = $old;
            return "<span class=\"negative\">Couldn't open new port $new</span>";
          }
        return '';
      } else {

        # don't have permissions to change
        mlog( 0,
            "AdminUpdate: request to listen on new admin port $new (changed from $old) -- restart required; euid=$>" );
        return "<br />Restart required; euid=$>";
      }
  }

sub ConfigChangeStatPort {
    my ( $name, $old, $new ) = @_;
    if ( $> == 0 || $new >= 1024 ) {

        # change the listenport
        $webStatPort = $new;
        $readable->remove($StatSocket);
        $StatSocket->close();
        $StatSocket = newListen( $webStatPort, \&NewStatConnection );
        if ($StatSocket) {
            mlog( 0, "AdminUpdate: listening on new stat port $new (changed from $old)" );
          } else {

            # couldn't open the port -- switch back
            $webStatPort = $old;
            $StatSocket = newListen( $webStatPort, \&NewStatConnection );
            mlog( 0, "AdminUpdate: couldn't open new port -- still listening on $old" );
            $Config{$name} = $old;
            return "<span class=\"negative\">Couldn't open new port $new</span>";
          }
        return '';
      } else {

        # don't have permissions to change
        mlog( 0,
            "AdminUpdate: request to listen on new stat port $new (changed from $old) -- restart required; euid=$>" );
        return "<br />Restart required; euid=$>";
      }
  }

sub ConfigChangePassword {
    my ( $name, $old, $new, $init ) = @_;

    # change the Password
    if ( !$init ) {
        $webAdminPassword         = $new;
        $webAdminPassword         = crypt( $webAdminPassword, "45" );
        $Config{webAdminPassword} = $webAdminPassword;
        mlog( 0, "AdminUpdate: Password changed" );
        return '';

      }
  }

sub ConfigChangeRelayPort {
    my ( $name, $old, $new ) = @_;
    unless ( $relayHost && $new ) {
        if ($Relay) {
            $readable->remove($Relay);
            $Relay->close();
            mlog( 0, "AdminUpdate: relay port disabled" );
            return '<br />relay port disabled';
          } else {
            return "<br />relayHost ($relayHost) and relayPort ($new) must be defined to enable relaying";
          }
      }
    if ( $> == 0 || $new >= 1024 ) {

        # change the listenport
        $relayPort = $new;
        if ($Relay) {
            $readable->remove($Relay);
            $Relay->close();
          }
        $Relay = newListen( $relayPort, \&NewSMTPConnection );
        mlog( 0, "AdminUpdate: listening for relay connections at $relayPort " );
        return '';
      } else {

        # don't have permissions to change
        mlog( 0,
            "AdminUpdate: request to listen on new relay port $new (changed from $old) -- restart required; euid=$>" );
        return "<br />Restart required; euid=$>";
      }
  }

sub ConfigChangeLogfile {
    my ( $name, $old, $new ) = @_;
    close LOG if $logfile;
    $logfile = $new;
    if ( $logfile && open( LOG, ">>$base/$logfile" ) ) {
        my $oldfh = select(LOG);
        $| = 1;
        select($oldfh);
      }
    mlog( 0, "AdminUpdate: log file changed to '$new' from '$old'" );
    '';
  }

sub ConfigDEBUG {
    my ( $name, $old, $new ) = @_;
    close DEBUG if $DEBUG;
    $DEBUG = $new;
    if ($DEBUG) {
        open( DEBUG, ">$base/" . time . ".dbg" );
        binmode(DEBUG);
        my $oldfh = select(DEBUG);
        $| = 1;
        select($oldfh);
        eval(
            q[sub d {
   my $time=gmtime(); $time=~s/... (...) +(\d+) (........) ..(..)/$2 $1 $4 $3/;
   my $debugprint = $_[0];
           $debugprint =~ s/\n//;
           $debugprint =~ s/\r//;
           $debugprint =~ s/\s+$//;
   
   print DEBUG "$time <$debugprint>\n";
  }
  ]
        );
      } else {
        eval(q[sub d{return;}]);
      }
    mlog( 0, "AdminUpdate: debug file changed to '$new' from '$old' " );
    '';
  }

#Content-Type: application/octet-stream; name="assp.pl"
#Content-Disposition: attachment; filename="assp.pl"
# Good Attachment Settings, Checks and Update.
sub updateGoodAttach {my ($name, $old, $new, $init)=@_;

    mlog(0,"AdminUpdate: Goodattach Level 4 updated from '$old' to '$new'") unless $init || $new eq $old;
    SetRE('goodattachRE',qq[\\.($new)\$],'i',"Good Attachment");
}

# bad attachment Settings, Checks and Update.
sub updateBadAttachL1 {my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Badattach Level 1 updated from '$old' to '$new'") unless $init || $new eq $old;
    SetRE('badattachL1RE',qq[\\.($new)\$],'i',"bad attachment L1");
    updateBadAttachL2('BadAttachL2','',$Config{BadAttachL2},$new);
}
sub updateBadAttachL2 {my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Badattach Level 2 updated from '$old' to '$new'") unless $init || $new eq $old;
    $new.='|'.$init;
    SetRE('badattachL2RE',qq[\\.($new)\$],'i',"bad attachment L2");
    updateBadAttachL3('BadAttachL3','',$Config{BadAttachL3},$new);
}
sub updateBadAttachL3 {my ($name, $old, $new, $init)=@_;
    mlog(0,"Badattach Level 3 updated from '$old' to '$new'") unless $init || $new eq $old;
    $new.='|'.$init;
    SetRE('badattachL3RE',qq[\\.($new)\$],'i',"bad attachment L3");
    $badattachRE[1]=$badattachL1RE;
    $badattachRE[2]=$badattachL2RE;
    $badattachRE[3]=$badattachL3RE;
    '';
}
sub updateSuspiciousAttach {my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Suspicious Attach updated from '$old' to '$new'") unless $init || $new eq $old;
    $new.='|'.$init;
    SetRE('suspiciousattachRE',qq[\\.($new)\$],'i',"suspicious attachment ");
    '';
}
sub updateUseLocalDNS {
    my ( $name, $old, $new, $init ) = @_;
    my $ret;
    unless ($init || $new eq $old ) {
        mlog( 0, "AdminUpdate: UseLocalDNS updated from '$old' to '$new'" );
        $UseLocalDNS = $new;
        $ret = updateDNS ( 'updateDNS', '', $Config{DNSServers}, $init );
    }
    return $ret;
}

sub updateDNS {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: DNS Name Servers updated from '$old' to '$new'" )
      unless $init || $new eq $old || $name eq 'updateDNS';

    if ($CanUseDNS) {
        my @ns = split( /\|/, $new );

        my $res = Net::DNS::Resolver->new(tcp_timeout => $DNStimeout,
                                          udp_timeout => $DNStimeout,
                                          retrans     => $DNSretrans,
                                          retry       => $DNSretry
                                          );
        if ( @ns && !$UseLocalDNS ) {
            $res->nameservers(@ns);
        }

        @nameservers = $res->nameservers;

        my @availDNS;
        my @diedDNS;
        my $domainName = "sourceforge.net";
        foreach my $dnsServerIP (@nameservers) {
            my $res = Net::DNS::Resolver->new(tcp_timeout => $DNStimeout,
                                              udp_timeout => $DNStimeout,
                                              retrans     => $DNSretrans,
                                              retry       => $DNSretry
                                              );
			my $btime       = Time::HiRes::time();                                              
            $res->nameservers($dnsServerIP);
            my $response = $res->search($domainName);
            my $atime       = int((Time::HiRes::time() - $btime) * 1000);
            mlog( 0, "Name Server $dnsServerIP: ResponseTime = $atime ms" ) if $DNSResponseLog;
            
	    if ($response) {
	    		
                push (@availDNS,$dnsServerIP);
            } else {
                push (@diedDNS,$dnsServerIP);
            }
        }

#to prevent shared @nameservers to get empty - duplicate entries will be deleted at the end!
        my $numDNS = @nameservers;
        foreach (@availDNS) {
            push (@nameservers,$_);
            
        }
        foreach (@diedDNS) {
            push (@nameservers,$_);
	    mlog( 0, "AdminInfo: Name Server $_: does not respond or timed out " ) ;
        }
        while ($numDNS) {
            shift @nameservers;
            $numDNS--;
        }
        $nameserversrt="";
        if (@diedDNS) {
        	$nameserversrt = '<span class="negative">*** '.join(' , ',@diedDNS).' timed out </span>';
           
        }
        $nameserversrt .= 'using DNS-Servers: '.join(' , ',@nameservers);
        return $nameserversrt;
        
    }
    return '<span class="negative">*** module Net::DNS is not installed </span>';
}


sub configUpdateRBLCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RBL Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheRBL unless $init || $new eq $old;
  }

sub configUpdatePTRCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: PTR Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCachePTR unless $init || $new eq $old;
  }

sub configUpdateRWLCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RWL Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheRWL unless $init || $new eq $old;
  }

sub configUpdateMXACR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: MXA Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheMXA;
  }

sub configUpdateSBCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SenderBase Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheSB unless $init || $new eq $old;
  }

sub configUpdateTrapCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: Invalid Addresses Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanTrapPB unless $init || $new eq $old;
  }

sub configUpdateSPFCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SPF Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheSPF unless $init || $new eq $old;;
  }

sub configUpdateURIBLCR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: URIBL Cache Refresh updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &cleanCacheURI unless $init || $new eq $old;;
  }

# URIBL Settings Checks, and Update.
sub configUpdateURIBL {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: URIBL-Enable updated from '$old' to '$new'" )
      unless $init || $new eq $old;

    $ValidateURIBL = $Config{ValidateURIBL} = $new;
    unless ($CanUseURIBL) {
        mlog( 0, "AdminUpdate:error URIBL-Enable updated from '1' to '0', Net::DNS not installed" )
          if $Config{ValidateURIBL};
        ( $ValidateURIBL, $Config{ValidateURIBL} ) = 0;
        return '<span class="negative">*** Net::DNS must be installed before enabling URIBL.</span>';
      } else {
        configUpdateURIBLMH( 'URIBLmaxhits', '', $Config{URIBLmaxhits}, 'Cascading' );
      }
  }

# RWL Settings Checks, and Update.
sub configUpdateRWL {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RWL-Enable updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $ValidateRWL = $Config{ValidateRWL} = $new;
    unless ($CanUseRWL) {
        mlog( 0, "AdminUpdate:error RWL-Enable updated from '1' to '', Net::DNS not installed" )
          if $Config{ValidateRWL};
        ( $ValidateRWL, $Config{ValidateRWL} ) = ();
        return '<span class="negative">*** Net::DNS must be installed before enabling RWL.</span>';
      } else {
        configUpdateRWLMH( 'RWLminhits', '', $Config{RWLminhits}, 'Cascading' );
      }
  }

sub configUpdateRWLMH {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RWL Minimum Hits updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RWLminhits = $new;
    if ( $new <= 0 ) {
        mlog( 0, "AdminUpdate:error RWL-Enable updated from '1' to '', RWLminhits must be defined and positive" )
          if $Config{ValidateRWL};
        ( $ValidateRWL, $Config{ValidateRWL} ) = ();
        return '<span class="negative">*** RWLminhits must be defined and positive before enabling RWL.</span>';
      } else {
        configUpdateRWLMR( 'RWLmaxreplies', '', $Config{RWLmaxreplies}, 'Cascading' );
      }
  }

sub configUpdateRWLMR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RWL Maximum Replies updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RWLmaxreplies = $new;
    if ( $new < $RWLminhits ) {
        mlog( 0, "AdminUpdate:error RWL-Enable updated from '1' to '', RWLmaxreplies not >= RWLminhits" )
          if $Config{ValidateRWL};
        ( $ValidateRWL, $Config{ValidateRWL} ) = ();
        return
'<span class="negative">*** RWLmaxreplies must be more than or equal to RWLminhits before enabling RWL.</span>';
      } else {
        configUpdateRWLSP( 'RWLServiceProvider', '', $Config{RWLServiceProvider}, 'Cascading' );
      }
  }

sub configUpdateRWLSP {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: RWL Service Providers updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RWLServiceProvider = $new;
    $new = checkOptionList( $new, 'RWLServiceProvider', $init );
    my $domains = ( $new =~ s/\|/|/g ) + 1;
    $RWLmaxreplies = $domains;
    if ( $domains < $RWLmaxreplies ) {
        mlog( 0, "AdminUpdate:error RWL-Enable updated from '1' to '',RWLServiceProvider not >= RWLmaxreplies " )
          if $Config{ValidateRWL};
        ( $ValidateRWL, $Config{ValidateRWL} ) = ();
        return 
'<span class="negative">*** RWLServiceProvider must contain more than or equal to RWLmaxreplies  before enabling RWL. RWL deactivated. </span>';
      } elsif ($CanUseRWL) {

        @rwllist = split( /\|/, $new );
        if (  $ValidateRWL ) {
            return ' & RWL activated';
          } 
      }
  }

sub configUpdateBACKSctrSP {
    my ($name, $old, $new, $init)=@_;
    mlog(0,"AdminUpdate: Backscatter Service Providers updated from '$old' to '$new'") unless $init || $new eq $old;
    $BackSctrServiceProvider=$new;
    $new=checkOptionList($new,'BackSctrServiceProvider',$init);
    my $domains=($new=~s/\|/|/g)+1;
    @backsctrlist=split(/\|/,$new);
    if (@backsctrlist && $DoBackSctr) {
        return ' & Backscatterer check is activated';
    } else {
        return ' Backscatterer check is deactivated';
    }
}

# SPF Fallback Domains.
sub configUpdateSPFfall {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SPF-Fallback updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $SPFfallback = $Config{SPFfallback} = $new;
    $new = checkOptionList( $new, 'SPFfallback', $init );
    @SPFfallbackDomains = split( /\|/, $new );
    $fallback = "";
    foreach my $c (@SPFfallbackDomains) {

        if ( $c =~ /(\S+)\s*=>\s*(.*)/ ) {
            $fallback .= "'$1' => '$2',";
          } else {
            $fallback .= "'$c' => '$SPFlocalRecord',";
          }
      }
    $fallback =~ s/,$//g;

  }

# SPF Override Domains.
sub configUpdateSPFover {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SPF-Override updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $SPFoverride = $Config{SPFoverride} = $new;
    $new = checkOptionList( $new, 'SPFoverride', $init );
    @SPFoverrideDomains = split( /\|/, $new );
    $override = "";
    foreach my $c (@SPFoverrideDomains) {

        if ( $c =~ /(\S+)\s*=>\s*(.*)/ ) {
            $override .= "'$1' => '$2',";
          } else {
            $override .= "'$c' => '$SPFlocalRecord',";
          }
      }
    $override =~ s/,$//g;

  }

# DNSBL Settings Checks, and Update.
sub configUpdateRBL {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: DNSBL-Enable updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $ValidateRBL = $Config{ValidateRBL} = $new;
    unless ($CanUseRBL) {
        mlog( 0, "AdminUpdate:error DNSBL-Enable updated from '1' to '0', Net::DNS not installed " )
          if $Config{ValidateRBL};
        ( $ValidateRBL, $Config{ValidateRBL} ) = 0;
        return '<span class="negative">*** Net::DNS must be installed before enabling DNSBL.</span>';
      } else {
        configUpdateRBLMH( 'RBLmaxhits', '', $Config{RBLmaxhits}, 'Cascading' );
      }
  }

sub configUpdateRBLMH {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: DNSBL Maximum Hits updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RBLmaxhits = $new;
    if ( $new <= 0 ) {
        mlog( 0,
"AdminUpdate:error DNSBL-Enable updated from '1' to '0', RBLmaxhits must be defined and positive before enabling DNSBL.</span>';"
        ) if $Config{ValidateRBL};
        ( $ValidateRBL, $Config{ValidateRBL} ) = 0;
        return '<span class="negative">*** RBLmaxhits must be defined and positive before enabling DNSBL.</span>';
      } else {
        configUpdateRBLMR( 'RBLmaxreplies', '', $Config{RBLmaxreplies}, 'Cascading' );
      }
  }

sub configUpdateRBLMR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: DNSBL Maximum Replies updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RBLmaxreplies = $new;
    if ( $new < $RBLmaxhits ) {
        mlog( 0, "AdminUpdate:error DNSBL-Enable updated from '1' to '0',RBLmaxreplies not >= RBLmaxhits" )
          if $Config{ValidateRBL};
        ( $ValidateRBL, $Config{ValidateRBL} ) = 0;
        return
'<span class="negative">*** RBLmaxreplies must be more than or equal to RBLmaxhits before enabling DNSBL.</span>';
      } else {
        configUpdateRBLSP( 'RBLServiceProvider', '', $Config{RBLServiceProvider}, 'Cascading' );
      }
  }

sub configUpdateRBLSP {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: DNSBL Service Providers updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $RBLServiceProvider = $new;
    $new = checkOptionList( $new, 'DNSBLServiceProvider', $init );
    my $domains = ( $new =~ s/\|/|/g ) + 1;
    $RBLmaxreplies = $domains;
    if ( $domains < $RBLmaxreplies ) {
        mlog( 0, "AdminUpdate:error DNSBL-Enable updated from '1' to '0', DNSBLServiceProvider not >= maxreplies" )
          if $Config{ValidateRBL};
        ( $ValidateRBL, $Config{ValidateRBL} ) = 0;
        return
'<span class="negative">*** DNSBLServiceProvider must contain more than or equal to maxreplies  before enabling DNSBL.</span>';
      } elsif ($CanUseRBL) {

        @rbllist = split( /\|/, $new );
        &cleanCacheRBL() unless $init || $new eq $old;
        
        if ($ValidateRBL) {
            return ' & DNSBL activated';
          } else {
            return 'DNSBL deactivated';
          }
      }
  }

sub configUpdateURIBLMH {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: URIBL Maximum Hits updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $URIBLmaxhits = $new;
    if ( $new <= 0 ) {
        mlog( 0, "AdminUpdate:error URIBL-Enable updated from '1' to '0', URIBLmaxhits not > 0" )
          if $Config{ValidateURIBL};
        ( $ValidateURIBL, $Config{ValidateURIBL} ) = 0;
        return '<span class="negative">*** URIBLmaxhits must be defined and positive before enabling URIBL.</span>';
      } else {
        configUpdateURIBLMR( 'URIBLmaxreplies', '', $Config{URIBLmaxreplies}, 'Cascading' );
      }
  }

sub configUpdateURIBLMR {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: URIBL Maximum Replies updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $URIBLmaxreplies = $new;
    if ( $new < $URIBLmaxhits ) {
        mlog( 0, "AdminUpdate:error URIBL-Enable updated from '1' to '0': URIBLmaxreplies not >=  URIBLmaxhits" )
          if $Config{ValidateURIBL};
        ( $ValidateURIBL, $Config{ValidateURIBL} ) = 0;
        return
'<span class="negative">*** URIBLmaxreplies must be more than or equal to URIBLmaxhits before enabling URIBL.</span>';
      } else {
        configUpdateURIBLSP( 'URIBLServiceProvider', '', $Config{URIBLServiceProvider}, 'Cascading' );
      }
  }

sub configUpdateURIBLSP {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: URIBL Service Providers updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $URIBLServiceProvider = $new;
    $new = checkOptionList( $new, 'URIBLServiceProvider', $init );
    my $domains = ( $new =~ s/\|/|/g ) + 1;
    $URIBLmaxreplies = $domains;
    if ( $domains < $URIBLmaxreplies ) {
        mlog( 0, "AdminUpdate:error URIBL-Enable updated from '1' to '0', URIBLServiceProvider not >= URIBLmaxreplies" )
          if $Config{ValidateURIBL};
        ( $ValidateURIBL, $Config{ValidateURIBL} ) = 0;
        return
'<span class="negative">*** URIBLServiceProvider must contain more than or equal to URIBLmaxreplies before enabling URIBL.</span>';
      } elsif ($CanUseURIBL) {

        @uribllist = split( /\|/, $new );
        if ($ValidateURIBL) {
            return ' & URIBL activated';
          } else {
            return 'URIBL deactivated';
          }
      }
  }

sub updateLDAPHost {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: LDAP Hosts updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $LDAPHost = $new;
    if ( $CanUseLDAP && $DoLDAP ) {
        my @ldaplist = split( /\|/, $LDAPHost );
        my $ldaplist = \@ldaplist;
        mlog( 0, "checking LDAP server at $LDAPHost -- " );
        my $ldap = Net::LDAP->new($ldaplist);

        if ( !$ldap ) {
            mlog( 0, "AdminUpdate:error couldn't contact LDAP server at $LDAPHost -- " );

            if ( !$init ) {
                return ' & LDAP not activated';
              } else {
                return '';
              }
          } else {
            mlog( 0, "AdminUpdate: LDAP server at $LDAPHost contacted -- " );
            if ( !$init ) {
                return ' & LDAP activated';
              } else {
                return '';
              }
          }
      }
  }

sub configUpdateCA {
    my ( $name, $old, $new, $init ) = @_;
    my $a;
    %calist = "";
    mlog( 0, "AdminUpdate: $name updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $CatchAll = $new;
    $new = checkOptionList( $new, 'CatchAll', $init );
    for $a ( split( /\|/, $new ) ) {

        if ( $a =~ /(\S*)\@(\S*)/ ) {

            $calist{$2} = "$1";
          }
      }
  }

sub configUpdateCCD {
    my ( $name, $old, $new, $init ) = @_;
    my $a;
    %calist = "";
    mlog( 0, "AdminUpdate: $name updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $ccSpamInDomain = $new;
    $new = checkOptionList( $new, 'ccSpamInDomain', $init );
    for $a ( split( /\|/, $new ) ) {

        if ( $a =~ /(\S*)\@(\S*)/ ) {

            $ccdlist{$2} = "$1";
          }
      }
  }

sub configTestmode {
    my ( $name, $old, $new, $init ) = @_;
    return "";
  }

sub updatePenaltyDuration {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: $name updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &CleanPB unless $init || $new eq $old;
    return "";
  }

sub updatePenaltyExpiration {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: $name updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    &CleanPB unless $init || $new eq $old;
    return "";
  }

sub cleanBlackPB {
    if ( $PenaltyExpiration == 0 ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%PBBlack) ) {
                delete $PBBlack{$k};
              }
          } else {
            $PBBlackObject->flush() if $PBBlackObject;
            unlink "$base/$pbdb.black.db.bak";
            rename( "$base/$pbdb.black.db", "$base/$pbdb.black.db.bak" );
            $PBBlackObject->DESTROY() if $PBBlackObject;
          }
        return;
      }

    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $tdif;
    my $tdifut;
    my $newscore = 0;
    my $mcount;
    my ( $ct, $ut, $pbstatus, $score, $sip, $reason );
    my $expmin = $PenaltyExpiration * 60;
    delete $PBBlack{"0.0.0.0"};
    delete $PBBlack{""};

    while ( my ( $k, $v ) = each(%PBBlack) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $ut, $pbstatus, $score, $sip, $reason ) = split( " ", $v );
        $tdif   = $t - $ct;
        $tdifut = $t - $ut;
        $ips_before++;
        
   
        if ($k =~ /$IPprivate/) {
            delete $PBBlack{$k};
            $ips_deleted++;
            next;
        }



        if ( $tdif > $PenaltyDuration * 60 && $score < $PenaltyLimit ) {
            delete $PBBlack{$k};
            $ips_deleted++;
            next;
          }
        if ( $tdif > $PenaltyExpiration * 60 && $score < $PenaltyExtreme ) {
            delete $PBBlack{$k};
            $ips_deleted++;
            next;
          }

        if (
               exists $PBWhite{$k}
            || ( $ispip && matchIP( $k, 'ispip', 0, 1 ) )
            || matchIP( $k, 'noProcessingIPs', 0, 1 )
            || matchIP( $k, 'whiteListedIPs',  0, 1 )
            || ( $noDelay && matchIP( $k, 'noDelay', 0, 1 ) )
            || ( $noPB    && matchIP( $k, 'noPB',    0, 1 ) )
            || (   $contentOnlyRe
                && $contentOnlyReRE != ""
                && $k =~ ( '(' . $contentOnlyReRE . ')' ) )
          ) {
            delete $PBBlack{$k};
            $ips_deleted++;
            next;
          }
        if (   $tdif > $ExtremeExpiration * 60 * 60 * 24
            && $score >= $PenaltyExtreme ) {
            delete $PBBlack{$k};
            $ips_deleted++;
            next;
          }
        MainLoop2();
      }
    if ( $ips_before == 0 ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%PBBlack) ) { delete $PBBlack{$k}; }
          } else {
            $PBBlackObject->flush() if $PBBlackObject;
            unlink "$base/$pbdb.black.db.bak";
            rename( "$base/$pbdb.black.db", "$base/$pbdb.black.db.bak" );
            $PBBlackObject->DESTROY() if $PBBlackObject;
          }
      }
    mlog( 0, "PenaltyBox: cleaning BlackBox  finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
      if $MaintenanceLog;
    MainLoop2();
  }

sub cleanWhitePB {
    my $ips_before = my $ips_deleted = 0;
    my $t          = time;
    my $newscore   = 0;
    my $mcount;
    delete $PBWhite{"0.0.0.0"};
    delete $PBWhite{""};

    while ( my ( $k, $v ) = each(%PBWhite) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        my ( $ct, $ut, $pbstatus, $score ) = split( " ", $v );
        $ips_before++;


        if ( matchIP( $k, 'denySMTPConnectionsFromAlways', 0, 1 ) ) {
            delete $PBWhite{$k};
            $ips_deleted++;
            next;
          }
        if ( matchIP( $k, 'noPBwhite', 0, 1 ) ) {
            delete $PBWhite{$k};
            $ips_deleted++;
            next;
          }
        if ($k =~ /$IPprivate/) {
            delete $PBWhite{$k};
            $ips_deleted++;
            next;
        }
        if ( $t - $ut >= $WhiteExpiration * 24 * 3600 ) {
            delete $PBWhite{$k};
            $ips_deleted++;
          }
        MainLoop2();
      }
    if ( $ips_before == 0 ) {

      } else {
        mlog( 0, "PenaltyBox: cleaning WhiteBox finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
          if $MaintenanceLog;
      }
  }

sub cleanCacheRBL {
    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $datetime;
    my $status;
    my $sp1;
    my $sp2;
    my $mcount;
    my $rblsp = join("|",@rbllist);
    while ( my ( $k, $v ) = each(%RBLCache) ) {
        ( $ct, $datetime, $status, $sp1, $sp2 ) = split( " ", $v );
        $mcount++;
        if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }

        $ips_before++;
		if ($status = 1) {
        if ( ($sp1 && $sp1 !~ /$rblsp/) || ($sp2 && $sp2 !~ /$rblsp/)) {
            delete $RBLCache{$k};
            $ips_deleted++;
            next;
        }}

        if ( $t - $ct >= $RBLCacheExp * 3600 ) {
            delete $RBLCache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "DNSBLCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%RBLCache) ) { delete $RBLCache{$k}; }
          } else {
          	if ($RBLCacheObject) {
            $RBLCacheObject->flush();
            unlink "$base/$pbdb.rbl.db.bak";
            rename( "$base/$pbdb.rbl.db", "$base/$pbdb.rbl.db.bak" );
            $RBLCacheObject->DESTROY();
            $RBLCache{""} = "" if $ips_before == 0;
          } }
      }
  }

sub cleanCachePTR {
    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $mcount;
    while ( my ( $k, $v ) = each(%PTRCache) ) {
    	$mcount++;
        if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $PTRCacheInterval * 3600 * 24 ) {
            delete $PTRCache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "PTRCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%PTRCache) ) { delete $PTRCache{$k}; }
          } else {
            $PTRCacheObject->flush();
            unlink "$base/$pbdb.ptr.db.bak";
            rename( "$base/$pbdb.ptr.db", "$base/$pbdb.ptr.db.bak" );
            $PTRCacheObject->DESTROY();
            $PTRCache{""} = "" if $ips_before == 0;
          }
      }
  }

sub cleanCacheRWL {
    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $mcount;
    while ( my ( $k, $v ) = each(%RWLCache) ) {
        ( $ct, $status ) = split( " ", $v );
        if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }

        $ips_before++;
        if ( $t - $ct >= $RWLCacheExp * 3600 ) {
            delete $RWLCache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "RWLCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%RWLCache) ) { delete $RWLCache{$k}; }
          } else {
            $RWLCacheObject->flush();
            unlink "$base/$pbdb.rwl.db.bak";
            rename( "$base/$pbdb.rwl.db", "$base/$pbdb.rwl.db.bak" );
            $RWLCacheObject->DESTROY();
            $RWLCache{""} = "" if $ips_before == 0;
          }
      }
  }

sub cleanCacheMXA {

    my $ips_before = my $ips_deleted = 0;
    my $ct;
    my $status;
    my $t = time;
    my $mcount;
    while ( my ( $k, $v ) = each(%MXACache) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $status ) = split( " ", $v );

        $ips_before++;

        if ( $t - $ct >= $MXACacheInterval * 3600 * 24 ) {
            delete $MXACache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "MXACache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;

    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%MXACache) ) { delete $MXACache{$k}; }
          } else {
            $MXACacheObject->flush();
            unlink "$base/$pbdb.mxa.db.bak";
            rename( "$base/$pbdb.mxa.db", "$base/$pbdb.mxa.db.bak" );
            $MXACacheObject->DESTROY();
            $MXACache{""} = "" if $ips_before == 0;
          }
      }
  }

sub cleanCacheSB {
    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $mcount;
    while ( my ( $k, $v ) = each(%SBCache) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $status ) = split( " ", $v );

        $ips_before++;
        if ( $t - $ct >= $SBCacheInterval * 3600 * 24 ) {
            delete $SBCache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "SenderBaseCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" )
      if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%SBCache) ) { delete $SBCache{$k}; }
          } else {
            $SBCacheObject->flush();
            unlink "$base/$pbdb.sb.db.bak";
            rename( "$base/$pbdb.sb.db", "$base/$pbdb.sb.db.bak" );
            $SBCacheObject->DESTROY();
            $SBCache{""} = "" if $ips_before == 0;
          }
      }
  }

sub cleanCacheSPF {
    my $ips_before = my $ips_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $result;
    my $mcount;
    while ( my ( $k, $v ) = each(%SPFCache) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $status, $result ) = split( " ", $v );

        $ips_before++;

        if ( $t - $ct >= $SPFCacheInterval * 3600 * 24 ) {
            delete $SPFCache{$k};
            $ips_deleted++;
          }
      }
    mlog( 0, "SPFCache: cleaning cache finished; IP\'s before=$ips_before, deleted=$ips_deleted" ) if $MaintenanceLog;
    if ( $ips_before == 0 || ( $ips_before >= 5000 && $ips_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%SPFCache) ) { delete $SPFCache{$k}; }
          } else {
            $SPFCacheObject->flush();
            unlink "$base/$pbdb.spf.db.bak";
            rename( "$base/$pbdb.spf.db", "$base/$pbdb.spf.db.bak" );
            $SPFCacheObject->DESTROY();
            $SPFCache{""} = "" if $ips_before == 0;
          }
      }
  }

sub cleanCacheURI {
    my $domains_before = my $domains_deleted = 0;
    my $t = time;
    my $ct;
    my $status;
    my $mcount;
    while ( my ( $k, $v ) = each(%URIBLCache) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        ( $ct, $status ) = split( " ", $v );
        $domains_before++;

        if ( $t - $ct >= $URIBLCacheExp * 3600 ) {
            delete $URIBLCache{$k};
            $domains_deleted++;
          }
      }
    mlog( 0, "URIBLCache: cleaning cache finished; Domains before=$domains_before, deleted=$domains_deleted" )
      if $MaintenanceLog;
    if ( $domains_before == 0
        || ( $domains_before >= 5000 && $domains_deleted == 0 ) ) {
        if ( $pbdb =~ /mysql/ ) {
            while ( my ( $k, $v ) = each(%URIBLCache) ) { delete $URIBLCache{$k}; }
          } else {
            $URIBLCacheObject->flush();
            unlink "$base/$pbdb.uribl.db.bak";
            rename( "$base/$pbdb.uribl.db", "$base/$pbdb.uribl.db.bak" );
            $URIBLCacheObject->DESTROY();
            $URIBLCache{""} = "" if $domains_before == 0;
          }
      }
  }

sub cleanTrapPB {
    my $addresses_before = my $addresses_deleted = 0;
    my $t = time;
    my $mcount;

    while ( my ( $k, $v ) = each(%PBTrap) ) {
    	if ($mcount == 100) {
                $mcount = 0;
                &MainLoop2();
        }
        my ( $ct, $ut, $count ) = split( " ", $v );
        $addresses_before++;

        if (   $t - $ct >= $PBTrapInterval * 3600 * 24
            && $count < $PenaltyMakeTraps ) {
            delete $PBTrap{$k};
            $addresses_deleted++;
          }
      }
    mlog( 0, "PBTrap: cleaning finished; before=$addresses_before, deleted=$addresses_deleted" ) if $MaintenanceLog;
  }

sub saveSMTPconnections {
    mlog( 0, "sig USR1 -- saving concurrent session stats" );
    open( SMTP, ">$base/smtp.txt" );
    print SMTP "$smtpConcurrentSessions\n";
    close(SMTP);
  }

sub exportExtreme {
    return 0 unless $DoExtremeExport;

    my $myexport = $exportExtremeBlack;
    my $fil;
    if ( $myexport =~ /^\s*file:\s*(.+)\s*$/i ) {
        $fil = $1;
    } else {
        return;
    }
    $fil = "$base/$fil" if $fil !~ /^(([a-z]:)?[\/\\]|\Q$base\E)/;

    my %extremeips;
    my $extremeObject = tie %extremeips, 'orderedtie', "$fil.hash";
    %extremeips = ();
    $extremeObject->flush();
    # import existing extreme IP's
    my $counter = 0;
    if ( $DoExtremeExportAppend ) {
        my $r;
        open( IMPORT, "<$fil" );
        local $/ = "\n";
        while ( $r = <IMPORT> ) {
            $r =~ y/\r\n\t //d;
            next unless $r;
            $extremeips{$r} = 1;
            $counter++;
        }
        close IMPORT;
        mlog( 0, "PenaltyBox: $fil read, imported:$counter" ) if $MaintenanceLog;
    }

    # get additional extreme IP's from PenaltyBlack
    my ( $k, $v, $ct, $ut, $pbstatus, $score, $sip, $reason );
    while ( ( my $k, my $v ) = each(%PBBlack) ) {
        ( $ct, $ut, $pbstatus, $score, $sip, $reason ) = split( " ", $v );

        next if $k =~ /\.0$/;
        next if $reason =~ /GLOBALPB/i;

        # skip, IP already exists in extreme file
        next if $extremeips{$k};

        if ( $score >= $PenaltyExtreme ) {
            $extremeips{$k} = 1;
            $counter++;
        }
    }

    # write extreme temp file
    open( EXPORT, ">$fil.tmp" );
    foreach my $e ( sort keys %extremeips ) {
        next unless $e;
        print EXPORT "$e\n";
    }
    close EXPORT;

    # backup and swap in new extreme file
    unlink( "$fil.bak" );
    move( "$fil", "$fil.bak" );
    move( "$fil.tmp", "$fil" );

    mlog( 0, "PenaltyBox: $fil exported, entries:$counter" ) if $MaintenanceLog;
    untie %extremeips;
    undef $extremeObject;
    unlink "$fil.hash";
    return 1;
}

sub deleteNP {
    return if $EmailNoNPRemove;
    my ( $name, $reason ) = @_;
    my $fil;
    my $mynp = $Config{"noProcessing"};
    if ( $mynp =~ /^\s*file:\s*(.+)\s*$/i ) {
        $fil = $1;
      } else {
        return;
      }
    $fil = "$base/$fil" if $fil !~ /^(([a-z]:)?[\/\\]|\Q$base\E)/;
    return if ( !-e "$fil" );
    my ( @lines, $nlines, $kk );
    open( NP, $fil );
    @lines = <NP>;
    close(NP);
    unlink "$fil.bak";
    rename( "$fil", "$fil.bak" );
    open( NP, ">$fil" );

    foreach my $k (@lines) {
        mlog( 0, "email: $name deleted from NoProcessing-List - $reason", 1 )
          if $k =~ /$name/i;

        next if $k =~ /$name/i;
        print NP "$k";
      }
    close(NP);
  }

# SRS Settin Checks, and Update.
sub updateSRS {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SRS-Enable updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $EnableSRS = $Config{EnableSRS} = $new;
    if ( !$CanUseSRS ) {
        mlog( 0, "AdminUpdate: SRS-Enable updated from '1' to '', Mail::SRS not installed" ) if $Config{EnableSRS};
        $EnableSRS = $Config{EnableSRS} = undef;
        return '<span class="negative">*** Mail::SRS must be installed before enabling SRS.</span>';
      } else {
        updateSRSAD( 'updateSRSAD', '', $Config{SRSAliasDomain}, 'Cascading' );
      }
  }

sub updateSRSAD {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SRS Alias Domain updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $SRSAliasDomain = $new;
    if ( $new eq '' ) {
        mlog( 0, "AdminUpdate: SRS-Enable updated from '1' to '', SRSAliasDomain not defined " ) if $Config{EnableSRS};
        $EnableSRS = $Config{EnableSRS} = undef;
        return '<span class="negative">*** SRSAliasDomain must be defined before enabling SRS.</span>';
      } else {
        updateSRSSK( 'updateSRSSK', '', $Config{SRSSecretKey}, 'Cascading' );
      }
  }

sub updateSRSSK {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: SRS Secret Key updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $SRSSecretKey = $new;
    if ( length($new) < 5 ) {
        mlog( 0, "AdminUpdate: SRS-Enable updated from '1' to '', SRSSecretKey not at least 5 characters long " )
          if $Config{EnableSRS};
        $EnableSRS = $Config{EnableSRS} = undef;
        return '<span class="negative">*** SRSSecretKey must be at least 5 characters long before enabling SRS.</span>';
      } elsif ($CanUseSRS) {
        if ( $init && $EnableSRS ) {
            return ' & SRS activated';
          } else {
            return '';
          }
      }
  }

# Database File Logging Frequency Setup.
sub updateLog2 {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: Non Spam Logging Frequency updated from '$old' to '$new'" ) unless $init || $new eq $old;
    $logFreq[2] = $new;

  }

sub updateLog3 {
    my ( $name, $old, $new, $init ) = @_;
    mlog( 0, "AdminUpdate: Spam Logging Frequency updated from '$old' to '$new'" )
      unless $init || $new eq $old;
    $logFreq[3] = $new;
    return '';
  }

sub reloadConfigFile {

    # called on SIG HUP
    my %newConfig;
    mlog( 0, "reloading config", 1 );
    open( F, "<$base/assp.cfg" );
    local $/;
    (%newConfig) = split( /:=|\n/, <F> );
    close F;
    foreach my $c (@ConfigArray) {
        my ( $name, $nicename, $size, $func, $default, $valid, $onchange, $description ) = @$c;
        if ( $Config{$name} ne $newConfig{$name} ) {
            if ( $newConfig{$name} =~ /$valid/i ) {
                my $new = $1;
                my $info;
                if ($onchange) {
                    $info = $onchange->( $name, $Config{$name}, $new );
                  } else {
                    mlog( 0, "AdminUpdate: $name changed from '$Config{$name}' to '$new'" );
                    ${$name} = $new;

                    # -- this sets the variable name with the same name as the config key to the new value
                    # -- for example $Config{myName}="ASSP-nospam" -> $myName="ASSP-nospam";
                  }
                $Config{$name} = $new;
              } else {
                mlog( 0, "AdminUpdate:error: invalid '$newConfig{$name}' -- not changed" );
              }
          }
      }
    foreach my $f (@PossibleOptionFiles) {
        ${$f} = optionList( $Config{$f}, $f )
          if $Config{$f} =~ /^\s*file:\s*(.+)\s*$/i && fileUpdated( $1, $f );
      }
    foreach my $f (@PossibleOptionFiles2) {
        ConfigCompileRe( $f, '', ${$f}, 'Initializing' )
          if $Config{$f} =~ /^\s*file:\s*(.+)\s*$/i && fileUpdated( $1, $f );
      }

    # reopen log file, just for fun.
    close LOG;
    if ( open( LOG, ">>$base/$logfile" ) ) {
        my $oldfh = select(LOG);
        $| = 1;
        select($oldfh);
      }
    print LOG "Logfile reopened on HUP\n";
    renderConfigHTML();
  }

####### global PB Client #######



sub textnoinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption,$note)=@_;
 my $Error = checkUpdate($name,$valid,$onchange);
 my $value = encodeHTMLEntities($Config{$name});
 #my $cfgname = $EnableInternalNamesInDesc?"<p><span class=\"internalName\">Internal Name: $name</span></p>":"";
 my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
 my $edit  = '';
 $note=1 if !$note;

 if ($value=~/^\s*file:\s*(.+)\s*/i){
  # the optionlist is actually saved in a file.
  my $fil = $1;
  # escape query string
  $fil  =~ s/([^\w\-.!~*\'() ])/sprintf("%%%02X",ord($1))/eg;
  $fil  =~ s/ /+/g;
  $edit = "<input type=\"button\" value=\" Edit file \" onclick=\"javascript:popFileEditor(\'$fil\',$note);\" />";
 }
 # get rid of google autofill
 #$name=~s/(e)(mail)/$1_$2/gi;
 return "<a name=\"$name\"></a>
 <div class=\"shadow\">
  <div class=\"option\">
   <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
   <div class=\"optionValue\">
    <input name=\"$name\" readonly size=\"$size\" value=\"$value\" />
    $edit<br />
    $Error
    $description\n
   </div>
  </div>
  &nbsp;
 </div>";

}

sub passnoinput {my ($name,$nicename,$size,$func,$default,$valid,$onchange,$description,$cssoption)=@_;
 my $Error=checkUpdate($name,$valid,$onchange);
 my $value=encodeHTMLEntities($Config{$name});
 my $cfgname = $EnableInternalNamesInDesc?"<i>($name)</i>":"";
"<a name=\"$name\"></a>
 <div class=\"shadow\">
 <div class=\"option\">
  <div class=\"optionTitle$cssoption\">$nicename $cfgname</div>
  <div class=\"optionValue\"><input type=\"password\" readonly name=\"$name\" size=\"$size\" value=\"$value\" /><br />\n$Error$description
  </div>
 </div>
 &nbsp;
 </div>";
}

sub unzipgz {
  my ($infile,$outfile) = @_;
  my $buffer ;
  my $gzerrno;
  my $ip;
  my $mask;
  my $reason;
  my $rest;
  return 0 unless $CanUseHTTPCompression;
  mlog(0,"deflating file $infile to $outfile") if $MaintenanceLog;
  eval{
  open OUTFILE, ">$outfile" or die "unable to open $outfile";
  binmode OUTFILE;
  my $gz = gzopen($infile, "rb") or die "unable to open $infile";
  while ($gz->gzread($buffer) > 0) {
      print OUTFILE "$buffer";
  }
  $gzerrno != Z_STREAM_END() or die "unable to read from $infile: $gzerrno" . ($gzerrno+0);
  $gz->gzclose() ;
  close OUTFILE;
  };
  if ($@) {
      mlog(0,"error : gz - $@");
      return 0;
  }
  return 1;
}

sub zipgz {
    my ($infile,$outfile) = @_;
    my $gzerrno;
    mlog(0,"inflating file $infile to $outfile") if $MaintenanceLog;
    open IN, "<$infile"
       or mlog(0,"Cannot open $infile:\n") && return 0;

    my $gz = gzopen($outfile, "wb")
      or mlog(0,"Cannot open $outfile: $gzerrno\n") && return 0;

    while (<IN>) {
        $gz->gzwrite($_)
          or mlog(0,"error writing $outfile: $gzerrno\n") && return 0;
    }

    $gz->gzclose ;
    close IN;
    return 1;
}

sub genGlobalPBBlack {
    return 0 if (! $pbdir);
    my $outfile = "$base/$pbdir/global/out/pbdb.black.db";
    my $tmpfile = "$base/$pbdir/global/out/pbdb.black.tmp";
    my $bakfile = "$base/$pbdir/global/out/pbdb.black.db.bak";
    $outfile =~ s/\\/\//g;
    $tmpfile =~ s/\\/\//g;
    $bakfile =~ s/\\/\//g;
    my $count = 0;
    my @s     = stat($outfile);
    my $t = $s[9];
    open OUT, ">$tmpfile" or return 0;
    binmode OUT;
    while (my ($k,$v)=each(%PBBlack)) {
        my ($ct,$ut,$pbstatus,$score,$sip,$reason)=split(" ",$v);
        my $tdifc=$t-$ct;
        my $tdifu=$t-$ut;
        next if ($reason =~ /GLOBALPB/i);    # no global back to server
        next if (exists $PBWhite{$k});       # should not be in PBWhite
        next if ($pbstatus < 3);             # must be min 3 times in local PB
        next if ($tdifu > 0);                # was already processed before
		next if ($score < 1);				 # no negative Black
        print OUT "$k\002$v\n";
        $count++;
    }
    close OUT;
    return 1 if ($count == 0);
    $! = undef;
    if (-e "$bakfile") {
        unlink "$bakfile";
        if ($!) {
           mlog(0,"unable to delete file $bakfile - $!");
           return 0;
        }
    }
    $! =undef;
    rename("$outfile", "$bakfile") if (-e "$outfile");
    if ($! && -e "$outfile") {
        mlog(0,"unable to rename file $outfile to $bakfile - $!");
        return 0;
    }
    $! = undef;
    rename("$tmpfile", "$outfile");
    if ($! && -e "$tmpfile") {
        mlog(0,"unable to rename file $tmpfile to $outfile - $!");
        return 0;
    }
    mlog(0,"Info: global PBBlack with $count records created") if $MaintenanceLog;
    return 1;
}

sub genGlobalPBWhite {
    return 0 if (! $pbdir);
    my $outfile = "$base/$pbdir/global/out/pbdb.white.db";
    my $tmpfile = "$base/$pbdir/global/out/pbdb.white.tmp";
    my $bakfile = "$base/$pbdir/global/out/pbdb.white.db.bak";
    $outfile =~ s/\\/\//g;
    $tmpfile =~ s/\\/\//g;
    $bakfile =~ s/\\/\//g;
    my $count = 0;
    my @s     = stat($outfile);
    my $t = $s[9];
    open OUT, ">$tmpfile" or return 0;
    binmode OUT;
    while (my ($k,$v)=each(%PBWhite)) {
        my ($ct,$ut,$pbstatus)=split(" ",$v);
        my $tdifc=$t-$ct;
        my $tdifu=$t-$ut;
        next if ($pbstatus != 2);
        next if (exists $PBBlack{$k});       # should not be in PBBlack
        next if ($tdifu > 0);                # was already processed before
        print OUT "$k\002$v\n";
        $count++;
    }
    close OUT;
    return 1 if ($count == 0);
    $! = undef;
    if (-e "$bakfile") {
        unlink "$bakfile";
        if ($!) {
           mlog(0,"unable to delete file $bakfile - $!");
           return 0;
        }
    }
    $! =undef;
    rename("$outfile", "$bakfile") if (-e "$outfile");
    if ($! && -e "$outfile") {
        mlog(0,"unable to rename file $outfile to $bakfile - $!");
        return 0;
    }
    $! = undef;
    rename("$tmpfile", "$outfile");
    if ($! && -e "$tmpfile") {
        mlog(0,"unable to rename file $tmpfile to $outfile - $!");
        return 0;
    }
    mlog(0,"Info: global PBWhite with $count records created") if $MaintenanceLog;
    return 1;
}






sub printallCon {
    my $fh = shift;
    my $this = $Con{$fh};
    return unless $this;
    return unless scalar(keys %$this);
    my $friend = $Con{$this->{friend}};
    -d "$base/debug" or mkdir "$base/debug",0777;
    my $c = 1;
    while(-s "$base/debug/con$c.txt") {$c++}
    my $file = "$base/debug/con$c.txt";
    my $OUT;
    open $OUT, ">$file";
    binmode $OUT;
    print $OUT "this --------------------------------------\n";
    foreach (keys %$this) {
       print $OUT "this->$_ = $this->{$_}\n";
    }
    if ($friend) {
        print $OUT "\nfriend --------------------------------------\n";
        foreach (keys %$friend) {
            print $OUT "friend->$_ = $friend->{$_}\n";
        }
    }
    close $OUT;
}

#####################################################################################
#                orderedtie
{

    package orderedtie;

    # This is a tied value that caches lookups from a sorted file; \n separates records,
    # \002 separates the key from the value. After main::OrderedTieHashTableSize lookups the cache is
    # cleared. This give us most of the speed of the hash without the huge memory overhead of storing
    # the entire hash and should be totally portable. Picking the best value for n requires some
    # tuning. A \n is required to start the file.

    # if you're updating entries it behoves you to call flush every so often to make sure that your
    # changes are saved. This also frees the memory used to remember updated values.

    # for my purposes a value of undef and a nonexistant key are the same

    # Obviously if your keys or values contain \n or \002 it will totally goof things up.

    sub TIEHASH {
        my ( $c, $fn ) = @_;
        my $self = {
            fn      => $fn,
            age     => mtime($fn),
            cnt     => 0,
            cache   => {},
            updated => {},
            ptr     => 1,
        };
        bless $self, $c;
        return $self;
      }
    sub DESTROY { $_[0]->flush(); }

    sub mtime { my @s = stat( $_[0] ); $s[9]; }

    sub flush {
        my $this = shift;
        return unless %{ $this->{updated} };
        my $f = $this->{fn};
        open( O, ">$f.tmp" ) || return undef;
        binmode(O);
        open( I, "<$f" ) || print O "\n";
        binmode(I);
        local $/ = "\n";
        my @l = ( sort keys %{ $this->{updated} } );
        my ( $k, $d, $r, $v );

        while ( $r = <I> ) {
            ( $k, $d ) = split( "\002", $r );
            while ( @l && $l[0] lt $k ) {
                $v = $this->{updated}{ $l[0] };
                print O "$l[0]\002$v\n" if $v;
                shift(@l);
              }
            if ( $l[0] eq $k ) {
                $v = $this->{updated}{ $l[0] };
                print O "$l[0]\002$v\n" if $v;
                shift(@l);
              } else {
                print O $r;
              }
          }
        while (@l) {
            $v = $this->{updated}{ $l[0] };
            print O "$l[0]\002$v\n" if $v;
            shift(@l);
          }
        close I;
        close O;
        unlink($f);
        rename( "$f.tmp", $f );
        $this->{updated} = {};
      }

    sub STORE {
        my ( $this, $key, $value ) = @_;
        $this->{cache}{$key} = $this->{updated}{$key} = $value;
      }

    sub FETCH {
        my ( $this, $key ) = @_;
        return $this->{cache}{$key} if exists $this->{cache}{$key};
        $this->resetCache()
          if ( $this->{cnt}++ > $main::OrderedTieHashTableSize
            || ( $this->{cnt} & 0x1f ) == 0 && mtime( $this->{fn} ) != $this->{age} );

        return $this->{cache}{$key} = binsearch( $this->{fn}, $key );
      }

    sub resetCache {
        my $this = shift;
        $this->{cnt}   = 0;
        $this->{age}   = mtime( $this->{fn} );
        $this->{cache} = { %{ $this->{updated} } };

      }

    sub binsearch {
        my ( $f, $k ) = @_;
        open( F, "<$f" ) || return undef;
        binmode(F);
        my $count = 0;
        my $siz = my $h = -s $f;
        $siz -= 1024;
        my $l  = 0;
        my $k0 = $k;
        $k =~ s/([\[\]\(\)\*\^\!\|\+\.\\\/\?\`\$\@\{\}])/\\$1/g;    # make sure there's no re chars unqutoed in the key

        while (1) {
            my $m = ( ( $l + $h ) >> 1 ) - 1024;
            $m = 0 if $m < 0;
            seek( F, $m, 0 );
            my $d;
            my $read = read( F, $d, 2048 );
            if ( $d =~ /\n$k\002([^\n]*)\n/ ) {
                close F;
                return $1;
              }
            my ( $pre, $first, $last, $post ) = $d =~ /^(.*?)\n(.*?)\002.*\n(.*?)\002.*?\n(.*?)$/s;
            last unless defined $first;
            if ( $k0 gt $first && $k0 lt $last ) {
                last;
              }
            if ( $k0 lt $first ) {
                last if $m == 0;
                $h = $m - 1024 + length($pre);
                $h = 0 if $h < 0;
              }
            if ( $k0 gt $last ) {
                last if $m >= $siz;
                $l = $m + $read - length($post);
              }
            if ( $count++ > 100 ) {

                #main::mlog(0,"Warning: $this->{fn} must be repaired ($k0)");
                last;
              }
          }
        close F;
        return undef;
      }

    sub FIRSTKEY {
        my $this = shift;
        $this->flush();
        $this->{ptr} = 1;
        $this->NEXTKEY();
      }

    sub NEXTKEY {
        my ( $this, $lastkey ) = @_;
        local $/ = "\n";
        open( F, "<$this->{fn}" ) || return undef;
        binmode(F);
        seek( F, $this->{ptr}, 0 );
        my $r = <F>;
        return undef unless $r;
        $this->{ptr} = tell F;
        close F;
        my ( $k, $v ) = $r =~ /(.*?)\002(.*?)\n/s;

        if ( !exists( $this->{cache}{$k} )
            && $this->{cnt}++ > $main::OrderedTieHashTableSize ) {
            $this->{cnt}   = 0;
            $this->{cache} = { %{ $this->{updated} } };
          }
        $this->{cache}{$k} = $v;
        $k;
      }

    sub EXISTS {
        my ( $this, $key ) = @_;
        return FETCH( $this, $key );
      }

    sub DELETE {
        my ( $this, $key ) = @_;
        $this->{cache}{$key} = $this->{updated}{$key} = undef;
      }

    sub CLEAR {
        my ($this) = @_;
        open( F, ">$this->{fn}" );
        binmode(F);
        print F "\n";
        close F;
        $this->{cache}   = {};
        $this->{updated} = {};
        $this->{cnt}     = 0;
      }
}

#################################################################
# this package implements realtime blacklisting
# it is based on Net::RBLClient by Asher Blum <asher@wildspark.com>
# CREDITS Martin H. Sluka <martin@sluka.de>
# Copyright (C) 2002 Asher Blum.  All rights reserved.
# This code is free software; you can redistribute it and/or modify it under
# the same terms as Perl itself.
# Modified for integration with ASSP by John Calvi.

package RBL;

use IO::Socket;

sub new {

    # This avoids compile time errors if Net::DNS is not installed.
    # The error will be returned on the lookup function call.
    if ($main::CanUseDNS) {
        require Net::DNS::Packet;
        $CanUseDNS = 1;
      }
    my ( $class, %args ) = @_;
    my $self = {
        lists       => [ lists() ],
        query_txt   => 1,
        max_time    => 10,
        timeout     => 1,
        max_hits    => 3,
        max_replies => 6,
        udp_maxlen  => 4000,
        server      => '127.0.0.1',
    };
    bless $self, $class;
    foreach my $key ( keys %args ) {
        defined( $self->{$key} )
          or return "Invalid key: $key";
        $self->{$key} = $args{$key};
      }

    $self;
  }

sub lookup {
    return "Net::DNS package required" unless $CanUseDNS;
    my($self, $target, $type) = @_;
    my $start_time = time;
    my $qtarget;
    my $dur;
    $target =~ s/[^\w\-\.].*$//;
    if ($target=~/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) {
     $qtarget = join ('.', reverse(split /\./, $target))
    } else {
     $qtarget=$target;
    }
    my $deadline = time + $self->{ max_time };

    my $sock = IO::Socket::INET->new(
        Proto     => 'udp',
        PeerPort  => 53,
        PeerAddr  => $self->{ server },
    );
    if (! $sock) {
        return "Failed to create UDP client";
    }
    $sock->blocking(0);
    if ( $self->{ query_txt } ) {
      foreach my $list(@{ $self->{ lists } }) {
        if (length($qtarget.$list) >62) {
          $sock->close;
          return "domain name too long";
        }
        my($msg_a, $msg_t) = mk_packet($qtarget, $list);
        &main::mlog(0,"sending DNS-query to $self->{server} on $list for $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
        foreach ($msg_a, $msg_t) {
          if (! $sock->send($_)) {
              $sock->close;
              return "send: $!" ;
          }
        }
      }
    } else {
        foreach my $list(@{ $self->{ lists } }) {
          if (length($qtarget.$list) >62) {
            $sock->close;
            return "domain name too long";
          }
          my $msg = mk_packet($qtarget, $list);
          &main::mlog(0,"sending DNS-query to $self->{server} on $list for $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
          if (! $sock->send($msg)) {
              $sock->close;
              return "send: $!" ;
          }
        }
    }

    $self->{ results } = {};
    $self->{ txt } = {};

    my $needed = 0;
    if ($self->{ max_replies} > @{ $self->{ lists } }) {
      $needed = @{ $self->{ lists } };
    } else {
      $needed = $self->{ max_replies };
    }
    $needed <<= 1 if $self->{ query_txt }; # how many packets needed back

    my $hits = my $replies = 0;

    my $select = new IO::Select;
    $select->add($sock);

    # Keep receiving packets until one of the exit conditions is met:
    &main::mlog(0,"Commencing $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
    my $countansw = 0;
    while($needed && time < $deadline) {
      my $msg = '';
      if ( my @ready = $select->can_read( $self->{timeout} ) ) {
        if (! $sock->recv( $msg, $self->{udp_maxlen} )) {
            $sock->close;
            return "recv: $!" ;
        }
      } else {
        next; # there are no data on socket -> next loop
      }
      $dur = time - $start_time;
      if($msg) {
        $countansw++;
        my ($domain, $res, $type) = decode_packet($msg);
        if ( defined $type && $type eq 'TXT' ) {
          $self->{ txt }{ $domain } = $res
        }
        elsif ($res) {
          $replies ++;
          $hits ++ if $res;
          $self->{ results }{ $domain } = $res;

          if ((! $main::Showmaxreplies && $hits >= $self->{ max_hits }) || $replies >= $self->{ max_replies }) {
              $dur = time - $start_time;
              &main::mlog(0,"got $countansw answers, $replies replies and $hits hits after $dur seconds for $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
              $sock->close;
              return 1;
          }
        }
        $needed --;
      }
    }
    $dur = time - $start_time;
    &main::mlog(0,"got $countansw answers, $replies replies and $hits hits after $dur seconds for $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
    &main::mlog(0,"Completed $type checks on $target") if $main::RBLLog==2 && $type eq "RBL" || $main::URIBLLog==2 && $type eq "URIBL" || $main::RWLLog==2 && $type eq "RWL" || $main::BacksctrLog==2 && $type eq "BACKSCATTER";
    $sock->close;
    1;
}
sub listed_by {
    my $self = shift;
    sort keys %{ $self->{results} };
  }

sub listed_hash {
    my $self = shift;
    %{ $self->{results} };
  }

sub txt_hash {
    my $self = shift;
    warn <<_ unless $self->{query_txt};
Without query_txt turned on, you won't get any results from ->txt_hash().
_
    if   (wantarray) { %{ $self->{txt} } }
    else             { $self->{txt} }
  }

# End methods - begin internal functions

sub mk_packet {

    # pass me a REVERSED dotted quad ip (qip) and a blocklist domain
    my ( $qip, $list ) = @_;
    my ( $packet, $txt_packet, $error );
    ( $packet, $error ) = new Net::DNS::Packet( my $fqdn = "$qip.$list", 'A' );
    return "Cannot build DNS query for $fqdn, type A: $error" unless $packet;
    return $packet->data unless wantarray;
    ( $txt_packet, $error ) = new Net::DNS::Packet( $fqdn, 'TXT', 'IN' );
    return "Cannot build DNS query for $fqdn, type TXT: $error"
      unless $txt_packet;
    $packet->data, $txt_packet->data;
  }

sub decode_packet {

    # takes a raw DNS response packet
    # returns domain, response
    my $data   = shift;
    my $packet = Net::DNS::Packet->new( \$data );
    my @answer;
    eval{@answer = $packet->answer;};

    {
        my ( $res, $domain, $type );
        foreach my $answer (@answer) {
            {
                my $name = lc $answer->name;

                $domain = $answer->name;
            }
            $domain =~ s/^\d+\.\d+\.\d+\.\d+\.//;
            $type = $answer->type;
            $res =
                $type eq 'A'     ? inet_ntoa( $answer->rdata )
              : $type eq 'CNAME' ? cleanup( $answer->rdata )
              : $type eq 'TXT' ? ( defined $res && "$res; " ) . $answer->txtdata
              :                  '?';
            last unless $type eq 'TXT';
          }
        return $domain, $res, $type if defined $res;
    }

    # OK, there were no answers -
    # need to determine which domain
    # sent the packet.
	my @question;
    eval{@question = $packet->question;};
    foreach my $question (@question) {
        my $domain = $question->qname;
        $domain =~ s/^\d+\.\d+\.\d+\.\d+\.//;
        return ( $domain, undef );
      }
  }

sub cleanup {

    # remove control chars and stuff
    $_[0] =~ tr/a-zA-Z0-9./ /cs;
    $_[0];
  }

sub lists {
    qw(
      bl.spamcop.net
      zen.spamhaus.org

    );
  }
1;

