#!/usr/bin/perl

# renames files to numbers
# (c) John Hanna, John Calvi 2003 under the terms of the GPL

open(F,"<assp.cfg"); local $/; (%Config)=split(/:=|\n/,<F>); close F;
$spamlog=$Config{spamlog} && "$Config{base}/$Config{spamlog}" || 'spam';
$notspamlog=$Config{notspamlog} && "$Config{base}/$Config{notspamlog}" || 'notspam';
$MaxFiles=$Config{MaxFiles} || 14003;
$maillogExt=$Config{maillogExt};

unless($ARGV[0]=~/-[r]/) {
 print "This program renames files to numbers

Usage:
 perl move2num.pl -r              actually rename the files
";
exit;
}

# we'll move files whose numbers are > $MaxFiles or files without numbered names to
# numbered names < $MaxFiles -- if there are more files than $MaxFiles we'll randomly overwrite
# some.

$c=1;
for $fn (glob("$spamlog/*")) {
 next if -d $fn;
 next if $fn=~/\/(\d+)$maillogExt$/i && $1 < $MaxFiles;
 $|=1;
 print "." if $c++ % 100==0;
 $|=0;
 $fn0=$fn;
 while($c < $MaxFiles && -s "$spamlog/$c$maillogExt") {$c++}
 $d=$c<$MaxFiles? $c: int(rand()*$MaxFiles);
 $fn=~s#/[^/]*$#/$d$maillogExt#;
 unlink($fn);
 rename($fn0,$fn);
}
$c=1;
for $fn (glob("$notspamlog/*")) {
 next if -d $fn;
 next if $fn=~/\/(\d+)$maillogExt$/i && $1 < $MaxFiles;
 print "." if $c++ % 100==0;
 $fn0=$fn;
 while($c < $MaxFiles && -s "$notspamlog/$c$maillogExt") {$c++}
 $d=$c<$MaxFiles? $c: int(rand()*$MaxFiles);
 $fn=~s#/[^/]*$#/$d$maillogExt#;
 unlink($fn);
 rename($fn0,$fn);
}
