# get the header part of the DATA.
sub getheader {
    my ( $fh, $l ) = @_;
    d('getheader');
    my $reply;
    my $done;
    my $done2;
    my $this = $Con{$fh};
	if ( $this->{inerror} ) {
        my $server = $this->{friend};
        $this->{getline} = \&getline;
        sendque( $server, $l );
        return;
    }
	
    $this->{header} .= $l;
    my $headerlength = length( $this->{header} );
    my $maxheaderlength=$HeaderMaxLength;

    if($HeaderMaxLength && $headerlength>$maxheaderlength) {
        delayWhiteExpire($fh);
        $this->{prepend}="[OversizedHeader]";
        mlog($fh,"Possible Mailloop: Headerlength ($headerlength) > $maxheaderlength");
        seterror($fh,"554 5.7.1 possible mailloop - oversized header ($headerlength)",1);
        return;
    }
    
	if ($MaxEqualXHeader 
		&& ! $this->{relayok}
        && ! ($this->{noprocessing} & 1)
        && ! $this->{whitelisted}
		&& ($l =~ /^X-(?!:ASSP)/i or $l =~ /^Content-Transfer-Encoding/i ) 
		&& $l !~ /X-Notes-Item/i) {
        my $line = $l;
        $line =~ s/\r?\n//g;
        my ($xh) = $line =~ /^($HeaderNameRe)\:/;
        if ($xh && ++${$this->{Xheaders}}{$xh} > $MaxEqualXHeader) {
            delayWhiteExpire($fh);
            $this->{prepend}="[Max-Equal-X-Header]";
            mlog($fh,"too many equal X-header lines - ($xh:)");
            seterror($fh,"554 5.7.7 too many equal X-headers ($xh:)",1);
            return;
        }
    }
    
    if (! $this->{relayok} && ! $this->{received}) {
        $this->{received} = $l =~ /^(?:Received:)|(?:Origin(?:at(?:ing|ed))?|Source)[\s\-_]?IP:/oi;
    }
    
    if ( $l =~ /^\.?[\r\n]*$/ ) {
    	$done2 = $l=~/^\.[\r\n]*$/;
        $this->{maillength}=$headerlength;
        $this->{noprocessing} = $this->{ismaxsize} if $this->{ismaxsize};
        my $slok;
        $this->{headerpassed} = 1;
		$this->{localmail} = localmail($this->{mailfrom});
		if (! $this->{relayok} && (my @bccRCPT = $this->{header} =~ /\nbcc:($HeaderValueRe)/igso)) {
            mlog($fh,"info: found and checking unexpected BCC recipient addresses in incoming mail") if $ValidateUserLog >= 2;
            foreach my $bcc (@bccRCPT) {
                while ($bcc =~ /($EmailAdrRe\@$EmailDomainRe)/igos) {
                    my $addr = $1;
                    if ($isThreaded && eval('return $ReplaceRecpt;') && !$@) {    # only in V2
                        my $newadr = RcptReplace($addr,batv_remove_tag('',$this->{mailfrom},0),'RecRepRegex');
                        if (lc $newadr ne lc $addr) {
                            $this->{header} =~ s/(\nbcc:(?:$HeaderValueRe)*?)$addr/$1$newadr/is;
                            mlog(0,"BCC - recipient $addr replaced with $newadr") if $ValidateUserLog;
                            $addr = $newadr;
                        }
                    }
                    next if localmail($addr);
                
                    pbAdd($fh,$this->{ip},$rlValencePB,"RelayAttempt",0) if $rlValencePB>0;
                    $this->{prepend} = "[RelayAttempt]";
                    my $fn = $this->{maillogfilename};
                    unless ($fn) {
                        $fn=Maillog($fh,'',6); # tell maillog what this is.
                    }
                    $fn=' -> '.$fn if $fn ne '';
                    $fn='' if !$fileLogging;
                    NoLoopSyswrite( $fh, "530 Relaying not allowed - BCC recipient ($addr) is not local\r\n" );
                    $this->{messagereason} = "relay attempt blocked for non local BCC recipient";
                    mlog( $fh, "[spam found] ('$this->{messagereason}')$fn",0,2 );
                    $Stats{rcptRelayRejected}++;
                    delayWhiteExpire($fh);
                    $this->{intemperror} = 1;
                    done($fh);
                    return;
                }
            }
        }
        if(! &MailLoopOK($fh)) {
            $this->{prepend}="[MailLoop]";
            mlog($fh,"warning: possible mailloop - found own received header more than $detectMailLoop times");
            my $bod = "Possible Mailloop: found own received header more often than set in detectMailLoop ($detectMailLoop)\r\n";
            $bod = "Message ID: $this->{msgtime}\r\n";
        	$bod .= "Remote IP: $this->{ip}\r\n";
        	$bod .= "Subject: $this->{subject}\r\n";
        	$bod .= "Sender: $this->{mailfrom}\r\n";
        	$bod .= "Recipients(s): $this->{rcpt}\r\n";
        	$bod .= "Mailbody: $this->{header}\r\n";
         	if ($canNotify && $Notify && $EmailFrom) {
              &sendNotification(
                $EmailFrom,
                $Notify,
                "ASSP error notification from $myName",
                $bod);
			}
            seterror($fh,"554 5.7.1 possible mailloop - found own received header more than $detectMailLoop times",1);
            return;
        }
        my $tip = $this->{ip};
        $tip = $this->{cip} if $this->{cip};
        if (   !$this->{relayok}
            && !$this->{contentonly}
            && pbWhiteFind($tip) )
        {
			$this->{contentonly} = "whitebox:$tip";

		}
        
        if (   !$this->{relayok}
            && !$this->{contentonly}
            && $contentOnlyRe
            && $contentOnlyReRE != ""
            && $this->{header} =~ ( '(' . $contentOnlyReRE . ')' ) )
        {
			$this->{contentonly} = $1;
			$this->{noblockingips} = 1;
            pbBlackDelete( $fh, $this->{ip} );           

        }


        if (   $allLogRe
            && $allLogReRE != ""
            && $this->{header} =~ ( '(' . $allLogReRE . ')' ) )
        {
            $this->{alllog} = 1;
        }
    	if (!$this->{whitelisted} && $whiteReRE ) {
        	WhiteOk($fh);
    	}
    	
    	if ( ! $this->{red}
            && $this->{header} =~ /(auto-submitted\:|subject\:.*?auto\:)/i )
            # RFC 3834
        {
            mlogRe( $fh, $1, "Red" );
            $this->{red} = $1;
        }

        if ( ! $this->{red}
            && $redRe
            && $redReRE ne ''
            && $this->{header} =~ ( '(' . $redReRE . ')' ) ) {

            mlogRe( $fh, $1, "Red" );
            $this->{red} = $1;
        }


        

        $this->{prepend} = '';

    	
        if ( ($this->{received} || $this->{relayok}) && $this->{ispip} && $this->{header} =~ /X-Forwarded-For: ($IPRe)/io) {
	        $this->{cipdone} = 1;
            $this->{cip} = ipv4TOipv6($1);
            my $cip = ipv6expand($1);
            my $cip2 = $1;
            my $orgHelo = $this->{helo};
	        while ( $this->{header} =~ /Received:\s+from\s*(.{1,50})\s*\(\[?(?:$this->{cip}|$cip|$cip2)\]?\)(.{1,80})by.{1,20}/gis ) {

                $this->{ciphelo} = $1;
                $this->{helo} = $1 if $1;
                my $rhelo = $2;
                $rhelo =~ s/\r?\n/ /go;
                $rhelo =~ /.+?helo\s*=\s*([^\s]+)/io;
                if ($1) {
                    $this->{ciphelo} = $1;
                    $this->{helo} = $1;
                }
            }
            if ($this->{cip} && matchIP($this->{cip},'ispip',$fh)) {
                delete $this->{cip};
                delete $this->{ciphelo};
                $this->{helo} = $orgHelo;
            } else {
                $this->{nohelo} = 1 if ( $this->{cip} && matchIP( $this->{cip}, 'noHelo', $fh ) );
                mlog( $fh, "Found X-Forwarded-For: $this->{ciphelo} ($this->{cip})", 1, 2 ) if $this->{cip};
            }
	    } elsif ( ($this->{received} || $this->{relayok}) && $this->{ispip} && $ispHostnames && !$this->{cipdone} ) {
            $this->{cipdone} = 1;
            my $orgHelo = $this->{helo};
            while ( $this->{header} =~ /Received:\s+from\s+(?:(.{1,50})\s+\()?\[?($IPRe)(.{1,80})by.{1,20}($ispHostnamesRE)/gis ) {
                my $cip = ipv6expand(ipv6TOipv4($2));
                my $helo = $1;
                my $rhelo = $3;
                next if $cip =~ /$IPprivate/o;

                $this->{cip} = $cip;
                $this->{ciphelo} = $helo || $cip;
                $rhelo =~ s/\r?\n/ /go;
                $rhelo =~ /.+?helo\s*[= ]?\s*([^\s\)]+)/io;
                $this->{ciphelo} = $1 if $1;
            }
            if ($this->{cip} && matchIP($this->{cip},'ispip',$fh)) {
                delete $this->{cip};
                delete $this->{ciphelo};
                $this->{helo} = $orgHelo;
            } else {
                $this->{nohelo} = 1 if ( $this->{cip} && matchIP( $this->{cip}, 'noHelo', $fh ) );
                mlog( $fh, "Originating IP/HELO:  $this->{cip} / $this->{ciphelo}", 1, 2 ) if $this->{cip};
            }
        }

        if ( $enhancedOrginIPDetect && $this->{received} && ! $this->{relayok} ) {
            pos($this->{header}) = 0;
            my %ips;
            while ( $this->{header} =~ /Received:\s+from\s+(?:($IPRe)|.{1,50}\s+\()?\[?($IPRe)?|(?:Origin(?:at(?:ing|ed))?|Source)[\s\-_]?IP:[\s\(\[\-\+]*($IPRe)/gois ) {
                my $sip = $1 || $2 || $3;
                next unless $sip;
                my $sip = ipv6expand(ipv6TOipv4($sip));
                next if $sip eq $this->{ip};
                next if $sip eq $this->{cip};
                next if exists $ips{$sip};
                next if $sip =~ /$IPprivate/o;
                next if matchIP($sip,'ispip',$fh);

                push @{"$this.sip"}, $sip;

                $this->{sip} = $sip;
                $ips{$sip} = 1;
            }
            if ($this->{sip}) {
                @{"$this.sip"} = reverse @{"$this.sip"};
                mlog( $fh, 'info: detected IP\'s on the mail routing way: '.join(', ',@{"$this.sip"}) ) if $ConnectionLog;
                mlog( $fh, "info: detected source IP: $this->{sip}" ) if $ConnectionLog;
            }
        }
        
        if (! &DomainIPOK($fh)) {
            	$this->{skipnotspam} = 0;return;
        	}
            
		if (! &FrequencyIPOK($fh)) {
            	$this->{skipnotspam} = 0;return;
        	}

		&makeSubject($fh);


        HistoryOK( $fh, $this->{ip} );

            


        if ( !ForgedHeloOK($fh) ) {
            $reply =
                      $SenderInvalidError
                      ? "$SenderInvalidError"
                      : "$SpamError";
            $reply =~ s/REASON/$this->{messagereason}/g;
            thisIsSpam( $fh, "ForgedHELO:'$this->{helo}'", $forgedHeloLog,
                $reply, $fhTestMode, 0, 0 );
            return;
        }
		if ( !BlackDomainOK($fh) ) {
            my $slok = $this->{allLoveBlSpam} == 1;
            $Stats{blacklisted}++ unless $slok;
            $reply = $SenderInvalidError;
            $reply =~ s/REASON/$this->{messagereason}/g;
            thisIsSpam( $fh, $this->{messagereason},
                $blDomainLog, $reply, $blTestMode, $slok, $done2 );
            return;
        }

 		if ($this->{blackdomainscore}  && TestMessageScore($fh)) {

           MessageScore( $fh, $done2 );
           return;
        }
        if ( !LocalSenderOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLoveISSpam} == 1;
            $Stats{senderInvalidLocals}++ unless $slok;
            $reply = $SenderInvalidError;
            $reply =~ s/REASON/$this->{messagereason}/g;
            thisIsSpam( $fh, "$this->{messagereason}", $spamISLog, $reply,
                $flsTestMode, $slok, $done2 );
            return;
        }

    	if ($this->{subject2} !~ ( '(' . $whiteReRE . ')' ) ) {
        if ( !NoSpoofingOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLoveISSpam} == 1;
            $Stats{senderInvalidLocals}++ unless $slok;
            $reply = $SenderInvalidError;
            $reply =~ s/REASON/$this->{messagereason}/g;
            thisIsSpam( $fh, "$this->{messagereason}", $spamISLog, $reply,
                $flsTestMode, $slok, $done2 );
            return;
        }}

        if (	$this->{relayok}
          	&&	!$this->{red}
            && 	$redRe
            && 	$redReRE != ""
            && 	$this->{header} =~ ( '(' . $redReRE . ')' ) )
        {

            my $subre = mlogRe( $fh, $1, "Red" );
            $this->{red} = "RedRe";
        }

        # if RELAYOK check localdomains if approprate
        if (   $this->{relayok}
            && !$this->{red}
            && $DoLocalSenderDomain
            && !$nolocalDomains
            && ($localDomains or $localDomainsFile or $ldLDAP or $DoLocalIMailDomains)
            && !localmail( $this->{mailfrom} )
            && $this->{mailfrom} !~ $BSRE
            && !localmail( $this->{rcpt} ) )
        {

            $this->{prepend} = "[RelayAttempt]";
            $this->{messagereason} =
              "relay attempt blocked because DoLocalSenderDomain is set";
            mlog( $fh, $this->{messagereason} );
            $Stats{rcptRelayRejected}++;
     
            NoLoopSyswrite( $fh, "530 Relaying not allowed - sender domain not local\r\n" );
    
            done($fh);
            return;
        }

        # if RELAYOK check localaddresses if approprate
        if (   $this->{relayok}
            && $DoLocalSenderAddress
            && !$nolocalDomains
            && (isvrfy( $fh, $this->{mailfrom})  or $DoLDAP or isflat( $fh, $this->{mailfrom}))
            && !$this->{red}
            && $this->{mailfrom} !~ $BSRE
            && !LocalAddressOK($fh)
            && !localmail( $this->{rcpt} ) )
        {
            $this->{prepend} = "[RelayAttempt]";

            $this->{messagereason} =
              "relay attempt blocked because DoLocalSenderAddress is set";
            mlog( $fh, $this->{messagereason} );
            $Stats{rcptRelayRejected}++;
            delayWhiteExpire($fh);
            NoLoopSyswrite( $fh, "530 Relaying not allowed - local sender address unknown\r\n" );

            done($fh);
            return;
        }
        
        if ( !DenyOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLovePBSpam} == 1;
			$Stats{denyConnection}++ unless $slok;
            my $er = $SpamError;
            $er = $DenyError if $DenyError;
            $this->{test} = "pbTestMode";
            thisIsSpam( $fh, $this->{messagereason}, $spamDenyLog, $er,
                $pbTestMode, $slok, $done2 );
                return; 
        }
		if ( !PBExtremeOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLovePBSpam} == 1;
			$Stats{pbextreme}++ unless $slok;
            my $er = $SpamError;
            $this->{test} = "pbTestMode";
            $er = $PenaltyError if $PenaltyError;
            thisIsSpam( $fh, $this->{messagereason}, $spamPBLog, $er,
                $pbTestMode, $slok, $done2 );
                return; 
        }
                

        if (! $this->{msgid} && $this->{header}=~/\nMessage-ID:($HeaderValueRe)/si) {
            $this->{msgid} = decodeMimeWords2UTF8($1);
            $this->{msgid}=~s/[\s>]+$//;
            $this->{msgid}=~s/^[\s<]+//;
        }


        MsgIDOK( $fh, $this->{msgid} );
  
  
        

		
        # header is done





        if ( !$this->{noprocessing} && $npRe
        	&& !$this->{relayok}
        	&& !$this->{addressedToSpamBucket}
            && $npReRE != ""
            && $this->{header} =~ ( '(' . $npReRE . ')' ) )
        {
			mlogRe( $fh, $1, "npRe" );
            pbBlackDelete( $fh, $this->{ip} );
            $this->{noprocessing}  = 1;
            $this->{passingreason} = "npRe '$1'";
  
        }
        
        if ( $npLocalRe
            && $this->{relayok} 
            && $this->{header} =~ ( '(' . $npLocalReRE . ')' ) )
        {
			mlogRe( $fh, $1, "npLocalRe" );

            $this->{noprocessing}  = 1;
            $this->{passingreason} = "npLocalRe '$1'";
  
        }

        if ( $blockLocalRe
            && $this->{relayok} 
            && "$this->{mailfrom}$this->{header}" =~ ( '(' . $blockLocalReRE . ')' ) )
        {
			mlogRe( $fh, $1, "blockLocalRe" );
			NoLoopSyswrite( $fh, "554 5.7.1 blocked - because of '$1'\r\n" );
			$this->{prepend} = "[BlockLocal]" ;
			mlog( $fh, "[blocked] -- '$1' found in blockLocalRe -- $this->{logsubject};");
			done($fh);
			return;
  
        }



        if (  !$this->{spamlover}
            && $SpamLoversRe
            && !$this->{addressedToSpamBucket}
            && !$this->{relayok}
            && $SpamLoversReRE != ""
            && $this->{header} =~ ( '(' . $SpamLoversReRE . ')' ) )
        {
            mlogRe( $fh, $1, "SpamLover" );
            $this->{spamlover} = 1;
        }
		

		if (! $this->{relayok} && 
    		!$this->{whitelisted} &&
    		$DoMSGIDsig &&
            $CanUseSHA1 &&
            
            ! $this->{noprocessing} &&
            ! $this->{addressedToSpamBucket} &&
			$this->{header} =~ /([^\r\n]+\:)[\r\n\s]*\<$MSGIDpreTag\.(\d)(\d\d\d)(\w{6})\.([^\r\n]+)\>/ &&

            &MSGIDsigCheck($fh,1)
           )
        {
            $this->{msgidsigdone} = 1;
            $this->{noprocessing}  = 1;
            $this->{prepend} = '[NoProcessing]';
            $this->{passingreason} = 'Valid MSGID signature';
            pbBlackDelete($fh,$this->{ip});
 
    	}

        if (!$this->{addressedToSpamBucket} && !BombHeaderOK( $fh, \$this->{header} ) ) {
            delayWhiteExpire($fh);
            my $slok = $this->{allLoveBoSpam} == 1;

 
            $Stats{bombs}++ unless $slok;
			$this->{test} = "bombTestMode";
            thisIsSpam( $fh, "$this->{messagereason}", $spamBombLog, $bombError, $bombTestMode, $slok, $done2 );
			return;
 		}
 		
 		if (TestMessageScore($fh)) {

           MessageScore( $fh, $done2 );
           return;
        }
 		if (!$this->{addressedToSpamBucket} &&  !SenderBaseOK( $fh, $this->{ip} ) ) {
            my $slok = $this->{allLoveSBSpam} == 1;
            $Stats{sbblocked}++ unless $slok;
            $reply = $SenderInvalidError;

            $reply =~ s/REASON/$this->{messagereason}/g;
            $this->{test} = "sbTestMode";
            thisIsSpam( $fh, $this->{messagereason},
                $spamSBLog, $reply, $sbTestMode, $slok, $done2 );
            return;
 
		}

 		if (@{"$this.sip"}) {
            mlog($fh,"info: check IP's on mail route for IP-blocking") if $ConnectionLog >= 2;
            my $res = 1;
            foreach my $ip (@{"$this.sip"}) {
               $res &= PBExtremeOK( $fh, $ip , 1);
            }
            if (! $res) {
                my $slok = $this->{allLovePBSpam} == 1;
                my $er = $SpamError;
                $er = $PenaltyError if $PenaltyError;
                thisIsSpam( $fh, $this->{messagereason}, $spamPBLog, $er,$this->{testmode}, $slok, 1 );
                return;}
            }

        }
        
 		if (TestMessageScore($fh)) {

           MessageScore( $fh, $done2 );
           return;
        }
        
		RWLok( $fh, $this->{ip} );


        if ( $this->{noprocessing} ) {
			
            if ( $SPFNP && !SPFok($fh) ) {
                return;
            }
            if ( $RBLNP && !RBLok($fh, $done) ) {
                return;
            }

            if ($this->{noprocessing}==1 && ($URIBLNP || $BayesNP || $bombReNP || $blackReNP ||  $BlockNPExes || ( $ScanNP &&  ($UseAvClamd or $DoFileScan) ) )) {
                if ($done2) {
                    &whitebodyNoExe($fh,$l);
                    $this->{getline}=\&getline;
                    return;
                } else {

                    $this->{getline}=\&whitebodyNoExe;
                }
            } else {
                $this->{prepend} = "[NoProcessing]";
                $this->{prepend} = "[Local]" if $this->{relayok};
                addSpamProb($fh);
                $this->{myheader} .= "X-Assp-Passing: $this->{passingreason}\r\n" if $this->{passingreason};
				&makeSubject($fh);
				my $fn;
				if ($noProcessingLog) {
                    $fn=Maillog($fh,'',$noProcessingLog); # tell maillog this isn't spam

                    $fn=' -> '.$fn if $fn ne '';
                    $fn='' if ! $fileLogging;
                }
                mlog(
                    $fh,
"passing without processing -- $this->{passingreason}$this->{attachcomment} -- $this->{logsubject}$fn",
                    0,
                    2
                ) if $this->{attachcomment};
                mlog(
                    $fh,
"passing without processing -- $this->{passingreason} -- $this->{logsubject}$fn",
                    0,
                    2
                ) if !$this->{attachcomment} ;
                $Stats{noprocessing}++ if !$this->{relayok};
                $Stats{locals}++ if $this->{relayok};
                isnotspam($fh,$done2);
            }
       } elsif ( onwhitelist( $fh, $this->{header} ) || $this->{whitelisted}) {

        	if ($RBLWL && ! RBLCacheOK($fh,$this->{ip},$done2)) {
                return;
            }

			if ($RBLWL && ! RBLok($fh,$this->{ip},$done2)) {
                return;
            }

			if ($RBLWL && @{"$this.sip"}) {
                mlog($fh,"info: check IP's on mail route for DNSBL") if $RBLLog >= 2;
                my $res = 1;
                foreach my $ip (@{"$this.sip"}) {
                   return if  !&RBLCacheOK($fh,$ip,$done2,1);
                   return if  !&RBLok($fh,$ip,$done2,1);

                }

            }
             
            if   ( $SPFWL && !SPFok($fh))  {
                return;
            }



           if (   $URIBLWL
                    || $URIBLLocal
                    || $BayesLocal
                    || $BayesWL
  
                    || $BlockWLExes
                    || $bombReWL
                    || $bombReLocal
                    || $blackReWL
                    || $blackReLocal
                    || ( ( $ScanWL || $ScanLocal ) && ($UseAvClamd or $DoFileScan) ) )
                {
                    if ($done2) {
                    	&whitebodyNoExe($fh,$l);
                    	$this->{getline}=\&getline;
                    	return;
                	} else {

                    	$this->{getline}=\&whitebodyNoExe;
                	}
                	

                
            } else {
                
 					if (TestMessageScore($fh)) {

           				MessageScore( $fh, $done2 );
           				return;
             
			 		} elsif ($DoPenaltyMessage
			 			&& $MessageScoringWL
                		&& $MessageScoringLowerLimit
                		&& $this->{messagescore} > $MessageScoringLowerLimit
                		&& $MessageScoringUpperLimit
                
                		&& $this->{messagescore} <= $MessageScoringUpperLimit ) {

                			$this->{messagelow} = 1;
                			$this->{messagereason} = "MessageScore in warning range";                
                			my $er           = $SpamError;
                			$er              = $PenaltyError if $PenaltyError;
                			$this->{prepend} = "[MessageScore]";
                			$this->{test} = "msTestMode";
                			thisIsSpam( $fh, $this->{messagereason},  $spamMSLog, $er,1 , 0,$done2 );
                			return;
                	} 

                    my $fn = Maillog( $fh, '', $NonSpamLog )
                      ;    # tell maillog this isn't spam
                    $fn = ' -> ' . $fn if $fn;
                    $fn = ""           if !$fileLogging && !$inclResendLink;
                   
                    $SpamProb = 0;
                    addSpamProb( $fh, 1 );
                    $this->{myheader} .= "X-Assp-Passing: $this->{passingreason}\r\n" if $this->{passingreason};
                    
                    $this->{prepend} = "[Local]"       if $this->{relayok};
                    $this->{prepend} = "[Whitelisted]" if !$this->{relayok};
                    
                    mlog( $fh, "local -- $this->{passingreason} $this->{attachcomment} -- $this->{logsubject}$fn", 0, 2 )
                      	if $this->{relayok};
                    mlog($fh, "whitelisted -- $this->{passingreason} $this->{attachcomment} -- $this->{logsubject}$fn", 0, 2 ) 
                    	if !$this->{relayok};
                    	
					isnotspam($fh,$done2);
                
            }


                

	
        } elsif (!$this->{addressedToSpamBucket} &&  !invalidHeloOK( $fh, $this->{helo} ) ) {
            my $slok = $this->{allLoveHiSpam} == 1;
            $Stats{invalidHelo}++ unless $slok;
            $reply = $SenderInvalidError;
            $this->{prepend} = "[InvalidHELO]";
            $reply =~ s/REASON/Invalid HELO Format/g;
            $this->{test} = "ihTestMode";
            thisIsSpam( $fh, "Invalid HELO: '$this->{helo}'",
                $invalidHeloLog, $reply, $ihTestMode, $slok, $done2 );

       

        } elsif (!$this->{addressedToSpamBucket} &&  !BlackHeloOK( $fh, $this->{helo} ) ) {

                
        } elsif (TestMessageScore($fh)) {
           MessageScore( $fh, $done2 );
           return;

		} elsif (!$this->{addressedToSpamBucket} &&  !RBLCacheOK($fh,$this->{ip},$done2) ) {
			return;
		} elsif (!$this->{addressedToSpamBucket} &&  !RBLok($fh,$this->{ip},$done2) ) {
			return;
		} elsif (!$this->{addressedToSpamBucket} &&  !FromStrictOK( $fh) ) {
			return;
      
        } elsif (@{"$this.sip"}) {
            mlog($fh,"info: check IP's on mail route for DNSBL") if $RBLLog >= 2;
            my $res = 1;
            foreach my $ip (@{"$this.sip"}) {
               return if !RBLCacheOK($fh,$ip,$done2,1);
               return if !RBLok($fh,$ip,$done2,1);

            }


        } elsif (TestMessageScore($fh)) {
           MessageScore( $fh, $done2 );
           return;

        } elsif (!$this->{addressedToSpamBucket} &&  !SPFok($fh,$done2) ) {
        
        } elsif (!$this->{addressedToSpamBucket} &&  !MXAOK($fh) ) {
            my $slok=$this->{allLoveMXASpam}==1;
            unless ($slok) {$Stats{mxaMissing}++;}
            $reply=$SenderInvalidError;
            $this->{prepend}="[MissingMXA]";
            $reply =~ s/REASON/Missing MX and A record/go;
            thisIsSpam($fh,"missing MX and A record",$spamMXALog,$reply,$mxaTestMode,$slok,$done);
            return;


        } elsif (!$this->{addressedToSpamBucket} && !PTROK($fh) ) {
			return;

        } elsif($this->{isbounce} && ! &MSGIDsigOK($fh)) {
           	return;
        
        } elsif($this->{isbounce} && ! &BackSctrCheckOK($fh,$this->{ip})) {
           	return;

               # remove Disposition-Notification headers if needed
        } elsif ($removeDispositionNotification 
        	&& !$this->{relayok} 
        	&& !$this->{whitelisted}
        	&& !$this->{noprocessing} 
        	&& $this->{header} =~ s/(?:ReturnReceipt|Return-Receipt-To|Disposition-Notification-To):$HeaderValueRe//gio
            ) {
            $this->{maillength} = length($this->{header});
            mlog($fh,"removed Disposition-Notification headers from mail",1) if $ValidateSenderLog > 1;


        } elsif (!$this->{addressedToSpamBucket} &&  $this->{invalidSRSBounce}
            && $SRSValidateBounce
            && !( $this->{ispip} )
            && !$this->{validatebounce}
            && !( $noSRS && matchIP( $this->{ip}, 'noSRS', 0, 1 ) ) )
        {

            my $slok = $this->{allLoveSRSSpam} == 1;
            $Stats{msgNoSRSBounce}++ unless $slok;
            $this->{prepend} = "[SRS]";
            $this->{validatebounce} = 1;
            $this->{messagereason} =
              "bounce address not SRS signed";
            pbAdd( $fh, $this->{ip}, $srsValencePB, "Not_SRS_Signed" ) if $SRSValidateBounce !=2;
            my $tlit = tlit($SRSValidateBounce);
            mlog( $fh, "$tlit ($this->{messagereason})" )if $SRSValidateBounce !=1;
            $this->{test} = "srsTestMode";
            thisIsSpam(
                $fh, $this->{messagereason},
                $SRSFailLog, '554 5.7.5 Bounce address not SRS signed',
                $srsTestMode, $slok, 0
            ) if $SRSValidateBounce ==1;
       
 # cleared all the above rules - off to Bayesian testmode is set if SPF and DNSBL is OK.
 # and no testcheck was successful.
        } else {

            $this->{getline} = \&getbody;
        }
    }

}
