sub uploadgriplist {
    local $/ = "\n";

    &checkDBCon() if ($CanUseTieRDBM && $DBisUsed);

    &printlog("building new GripList records and bounce report\n") if !$noGripListUpload;


    #&printlog("Start building Griplist \n");
    my ( $date, $ip, $peeraddress, $hostaddress, $connect, $day, $gooddays, $last2days, $st );
    my $buf;
    my ($logdir, $logdirfile) = $logfile=~/^(.*[\/\\])?(.*?)$/o;
    my @logfiles1=reverse sort glob("$base/$logdir*$logdirfile");
    my @logfiles;
    while (@logfiles1) {
        my $k = shift @logfiles1;
        push(@logfiles, $k) if $k !~ /b$logdirfile/;
    }

    #build list of the last 4 days
    $day = &timestring(undef,'d');
    $gooddays .= "\Q$day\E|";
    $last2days .= "\Q$day\E|";
    $day = &timestring( time - 24 * 3600 , 'd');
    $gooddays .= "\Q$day\E|";
    $last2days .= "\Q$day\E";
    $day = &timestring( time - 36 * 3600 , 'd');
    $gooddays .= "\Q$day\E|";
    $day = &timestring( time - 72 * 3600 , 'd');
    $gooddays .= "\Q$day\E";
    undef $day;

    my $time = time;
    my $dayoffset = $time % ( 24 * 3600 );
    my %bounces = ();
    my $IPprivate = $IPprivate;
    while (@logfiles) {
        my $File = shift @logfiles;
        my @s = stat($File);
        next if ( ( $s[9] + 4 * 24 * 3600 ) < ( $time - $dayoffset ) );
        &printlog("processing Logfile $File\n");

        next unless (open( my $FLogFile, '<', "$File" ));
        while (<$FLogFile>) {
            next unless ( $date, $ip ) = /($gooddays) .*\s($IPRe)[ \]].* to: \S+ .*/i;
            next if $ip =~ /$IPprivate/o;                         # ignore private IP ranges
            $ip =~ s/\.\d+$//o;
            if (! $noGripListUpload && m/(?:\[Local]|\[MessageOK]|\[RWL]|\[Whitelisted]|\[NoProcessing])/io) {

                #Good IP
                $GpCnt{ $ip }  += 1;
                $GpOK{ $ip } += 1;
                next;
            }
            if (! $noGripListUpload && m/(?:\[Attachment]|\[Backscatter]|\[Bayesian]|\[BlackDomain]|\[BlackHELO]|\[BombBlack]|\[BombData]|\[BombHeader]|\[BombRe]|\[BombScript]|\[BombSender]|\[BounceAddress]|\[Collect]|\[Connection]|\[CountryCode]|\[DNSBL]|\[Delayed]|\[DenyIP]|\[DenyStrict]|\[Extreme]|\[ForgedHELO]|\[ForgedLocalSender]|\[FromMissing]|\[History]|\[IPfrequency]|\[IPperDomain]|\[InternalAddress]|\[InvalidAddress]|\[InvalidHELO]|\[MalformedAddress]|\[MaxErrors]|\[MessageScore]|\[MissingMX]|\[MsgID]|\[Organization]|\[OversizedHeader]|\[PTRinvalid]|\[PTRmissing]|\[PenaltyBox]|\[Penalty]|\[RelayAttempt]|\[SPF]|\[SRS]|\[SpoofedSender]|\[SuspiciousHelo]|\[Trap]|\[URIBL]|\[VIRUS]|\[ValidHELO]|\[WhitelistOnly]|spam found)/io) {

                #Bad IP
                $GpCnt{ $ip }  += 1;
                $GpOK{ $ip } += 0;
                next;
            }
#            &ThreadYield();
            my $to;
            next unless ($date,$to) = /^($last2days) .*\[isbounce\].*\sto:\s([^\s]+)\s.*/i;
            $to = lc $to;
            $bounces{$to}++;
        }
        close $FLogFile;
    }
    if (my $numbounces = scalar keys %bounces) {
        &printlog("\nbounce report for the last two days: $numbounces bounces received\n");
        &printlog("\nlist of addresses that received at least ten bounces in the last two days:\n\n");
        foreach my $adr (reverse sort {$bounces{$a} cmp $bounces{$b} } keys %bounces) {
            &printlog("$adr : $bounces{$adr}\n") if $bounces{$adr} > 9;
        }
        &printlog("\nend of bounce report\n\n");
    } else {
        &printlog("\nbounce report for the last two days: no bounces received\n\n");
    }
    return if $noGripListUpload;

    if ( !%GpCnt ) {
        &printlog("Skipping GrIPlist upload. Not enough messages processed.\n");

        return;
    }
    my ($n6, $n4);
#    $n4 = &BDB_getRecordCount('GpCnt') || scalar keys %GpCnt;
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        if (/:/o) {
            $n6++;
        }
        else {
            $n4++;
        }
    }
    $st = pack("N2", $n6 / 2**32, $n6);
    $st .= pack("N", $n4);
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        next if ($k !~ /:/o);
        my $ip = $k;
        $ip =~ s/([0-9a-f]*):/0000$1:/gio;
        $ip =~ s/0*([0-9a-f]{4}):/$1:/gio;
        $st .= pack("H4H4H4H4", split(/:/o, $ip));
        $st .= pack("C", (1 - $GpOK{$k} / $v) * 255);
    }
    my $count = 0;
    while (my ($k,$v) = each %GpCnt) {
        next if (!$v);
        $count++;
        next if ($k =~ /:/o);
        $st .= pack("C3C", split(/\./o, $k), (1 - $GpOK{$k} / $v) * 255);
    }

    &downloadGripConf();  # reload the griplist.conf
    if ($proxyserver) {
        &printlog("Uploading Griplist via Proxy: $proxyserver\n");

        my $user = $proxyuser ? "$proxyuser:$proxypass\@": '';
        $peeraddress = $user . $proxyserver;
        $hostaddress = $proxyserver;
        $connect     = "POST $gripListUpUrl HTTP/1.0";
    } else {
        &printlog("Uploading Griplist via Direct Connection\n");
        $peeraddress = $gripListUpHost . ':80';
        $hostaddress = $gripListUpHost;
        my ($url) = $gripListUpUrl =~ /http:\/\/[^\/](\/.+)/oi;
        $connect     = <<"EOF";
POST $url HTTP/1.1
User-Agent: ASSP/$VERSION$modversion ($^O; Perl/$];)
Host: $gripListUpHost
EOF
    }
    my $socket = $CanUseIOSocketINET6
                ? IO::Socket::INET6->new(Proto=>'tcp',PeerAddr=>$peeraddress,Timeout=>2,&getDestSockDom($hostaddress))
                : IO::Socket::INET->new(Proto=>'tcp',PeerAddr=>$peeraddress,Timeout=>2);

    if ( defined $socket ) {
        my $len = length($st);
        $connect .= <<"EOF";
Content-Type: application/x-www-form-urlencoded
Content-Length: $len

$st
EOF
        print $socket $connect;
        eval{$socket->read($buf, 4096);close($socket);};
        &printlog("Submitted $len bytes: $n6 IPv6 addresses, $n4 IPv4 addresses\n");

    }
    else {
        &printlog("unable to connect to $gripListUpHost to upload griplist\n");
        
    }
    return;
} ## end sub uploadgriplist
