#!/usr/bin/perl

# calculates statistics for the ASSP maillog file
# (c) John Hanna 2003 under the terms of the GPL
#
# Thanks to R.Toth for his suggestions
if (!$ARGV[0] ) {

    print "Usage: perl stat.pl logfile(s)\n\n";
    exit;

   }
$con=$bs=$dns=$dbs=$ndbs=$local=$white=$whiteadd=$badattach=$spamad=$spamlover=
 $connects=$relayblks=$mok=$dnsc=$dmok=$ndmok=0;

while(<>) {
 if(/Connected: /) {
  $con++;
  next;
 }
 if( /spam found/i ){
  $sf++;
  if($dns) {$dbs++} else {$ndbs++}
 }

 $local++ if /local/i;
 $white++ if /whitelisted/i;
 $noprocessing++ if /noprocessing/i;
 $whiteadd++ if /whitelist addition/i;

 $spamad++ if /collect/i;
 $bs++ if /bayesian/i;
 $spamlover++ if /spamlover/i;	# So we can see just how much is passing thru
 $relayblks++ if /relay attempt/i;	# Got 'em... and dropped them like a stone...

 if( /message ok/i ) {
  $mok++;
  if($dns) {$dmok++} else {$ndmok++}
 }
 ($dns)=/(dnsbl hit)/;
 $dnsc++ if $dns;
 $d{$1}++ if /^(\S+)/;
}
@d=keys %d;
$days=@d;
die "No data found\n" unless $days;
$spams=$sf;
$nonspam=$mok + $local+ $white+$noprocessing;
$tot=$spams + $nonspam +$relayblks;


open(F,"<whitelist"); {local $/="\n"; my $n=0; $n++ while(<F>); $numwhite=$n-1;}
printf "As of ".localtime()." the mail logfile shows:
$con proxy / smtp connections
$relayblks were dropped for attempted relays (%.1f%% of total).
$tot messages for %.1f messages per day
$spams were spam (%.1f%%) or %.1f spams per day
$whiteadd additions to / verifications of the whitelist (%.1f per day)
$bs were judged spam by the bayesian filter (%.1f%% of spam)
$spamad were to spam addresses (%.1f%% of spam)
$nonspam were nonspam (%.1f%%) or %.1f nonspam per day
$local were sent from local clients (%.1f%% of nonspam)
$white were from whitelisted addresses (%.1f%% of nonspam)
$noprocessing were from/to noprocessing addresses (%.1f%% of nonspam)
$spamlover messages were passed to SPAMLOVERs
$mok were ok after all checks (%.1f%% of nonspam)
$numwhite addresses are on the whitelist


",
p($relayblks,$con),
p($tot,$days)/100,
p($spams,$tot), p($spams,$days)/100,
p($whiteadd,$days)/100,
p($bs,$spams),
p($spamad,$spams),
p($nonspam,$tot), p($nonspam,$days)/100,

p($local,$nonspam),
p($white,$nonspam),
p($noprocessing,$nonspam),
p($mok,$nonspam),

;

# return percent and not die if denominator is 0
sub p {my ($a,$b)=@_; my $p=$b? $a/$b*100:0; $p;}
