#!/usr/local/bin/perl

# mod_inst.pl

# Installs Perl modules used by ASSP an needed Software - tesseract / ImageMagick

# http://assp.sourceforge.net/

use strict;

use warnings;
use File::Copy;
#use 5.010;

my $myversion = '1.401';   # 2011.07.02 Thomas Eckardt

###########################################
# please change the following to your needs
#
# uncomment and change the following line(s) if you use a HTTP-Proxy and ENV is not set
#$ENV{HTTP_proxy} = 'http://yourproxy:port';
#$ENV{HTTP_proxy_user} = 'proxy-user';
#$ENV{HTTP_proxy_pass} = 'proxy-user-password';
###########################################

print "Perl " . $] . "  ASSP module installation helper version $myversion\n\n";


my $cmd;
our %Config;
our $asspdir;
our $V1=1;
my $perl;
my $perlbindir;
my $perldosbindir;

if ( $ARGV[0] ) {
    $asspdir = $ARGV[0];
} else {
    if ($^O ne "MSWin32") {
        foreach ( '../..','.','assp', '/usr/local/assp', '/home/assp','/etc/assp', '/usr/assp', '/applications/assp', '/assp', '/opt/assp') {
            if (-e "$_/assp.cfg") {
                $asspdir = $_;
                last;
            }
        }
    }
}

# get / set assp-install-dir and proxy
if ($^O eq "MSWin32") {
    $perl = $^X;
    ($perldosbindir) = $perl =~ /^(\S:\\.*)\\[^\\]+$/;
    $perldosbindir =~ s/\\/\\\\/g;
    $perl =~ s/\\/\//g;
    ($perlbindir) = $perl =~ /^(\S:\/.*)\/[^\/]+$/;

    if (! $asspdir) {
        $cmd = 'DIR';
        my $out = `$cmd`;
        ($asspdir) = $out =~ /(\S:\\.*)\\[^\\]+\\[^\\]+/;
    }

    if (! $asspdir || ! -e $asspdir."\\assp.cfg") {
        $asspdir = "..\\.." unless $asspdir;
        die "$asspdir\\assp.cfg not found!\nASSP has to be installed and configured (proxyserver) before running this script!\nThis script has to run in the [ASSP_install_DIR]/assp.mod/install directory!\nFor example C:\\assp\\assp.mod\\install\nOr call \>perl modinst.pl [Full_Path_To_ASSP_Install_DIR]\nPlease correct this!\n";
    }

    if (-e "$asspdir\\assp.cfg") {
        print "reading proxy settings from assp.cfg\n";
        open(CFG,"<$asspdir\\assp.cfg"); local $/; (%Config)=split(/:=|\n/,<CFG>); close CFG;
        $ENV{HTTP_proxy} = $Config{proxyserver} if ($Config{proxyserver} && ! $ENV{HTTP_proxy});
    } else {
        if ($^O eq "MSWin32" && ! $ENV{HTTP_proxy}) {
            my $rkey;
            my $Registry;
            print "reading IE proxy settings from windows-registry\n";
            eval("use Win32::TieRegistry ( Delimiter=>'/', ArrayValues=>1 );");
            $rkey=$Registry->{'CUser/Software/Microsoft/Windows/CurrentVersion/Internet Settings'};
            if (unpack("N", pack("H8", substr($rkey->GetValue( "ProxyEnable" ), -8)))) {
                $ENV{HTTP_proxy} = $rkey->GetValue( "ProxyServer" );
            }
        }
    }
} else {
    $asspdir = "../.." unless $asspdir;
    if (! -e "$asspdir/assp.cfg") {
        die "$asspdir/assp.cfg not found!\nASSP has to be installed and configured (proxyserver) before running this script!\nThis script has to run in the [ASSP_install_DIR]/assp.mod/install directory!\nFor example /opt/assp/assp.mod/install\nOr call \>perl modinst.pl [Full_Path_To_ASSP_Install_DIR]\nPlease correct this!\n";
    } else {
        print "reading proxy settings from assp.cfg\n";
        open(CFG,"<$asspdir/assp.cfg"); local $/; (%Config)=split(/:=|\n/,<CFG>); close CFG;
        $ENV{HTTP_proxy} = $Config{proxyserver} if ($Config{proxyserver} && ! $ENV{HTTP_proxy});
    }
}

if ($ENV{HTTP_proxy}) {
    print "will make downloads via proxy $ENV{HTTP_proxy}\n";
} else {
    print "\%HTTP_proxy\% is not set - will make downloads via direct connect\n";
}

if ($^O eq "MSWin32") {
    print "copying needed binary files to $perldosbindir\n";
    $cmd = "copy ".$asspdir."\\assp.mod\\bin\\*.* ".$perldosbindir;
    system($cmd);
    print "checking and adding PPM-repositories for module installation\n";
    $cmd = 'ppm rep';
    my $out = `$cmd`;
    if ($out !~ /trouchelle/i && $] eq '5.008008') {
        print "adding respository 'trouchelle' 'http://trouchelle.com/ppm/' to ppm\n";
        $cmd = 'ppm rep add trouchelle http://trouchelle.com/ppm/';
        system($cmd);
    }
    if ($out !~ /trouchelle\.510/i && substr($],0,5) eq '5.010') {
        print "adding respository 'trouchelle.510' 'http://trouchelle.com/ppm10/' to ppm\n";
        $cmd = 'ppm rep add trouchelle.510 http://trouchelle.com/ppm10/';
        system($cmd);
    }
    if ($out !~ /trouchelle\.512/i && substr($],0,5) eq '5.012') {
        print "adding respository 'trouchelle.512' 'http://trouchelle.com/ppm12/' to ppm\n";
        $cmd = 'ppm rep add trouchelle.512 http://trouchelle.com/ppm12/';
        system($cmd);
    }
    if ($out !~ /trouchelle\.514/i && substr($],0,5) eq '5.014') {
        print "adding respository 'trouchelle.514' 'http://trouchelle.com/ppm14/' to ppm\n";
        $cmd = 'ppm rep add trouchelle.514 http://trouchelle.com/ppm14/';
        system($cmd);
    }
    if ($out !~ /trouch\-act/i && substr($],0,5) eq '5.010') {
        print "adding respository 'trouch-act' 'http://trouchelle.com/ppm10/activestate/1000/' to ppm\n";
        $cmd = 'ppm rep add trouch-act http://trouchelle.com/ppm10/activestate/1000/';
        system($cmd);
    }
    if ($out !~ /winnipeg/i && $] eq '5.008008') {
        print "adding respository 'uni_winnipeg' 'http://theoryx5.uwinnipeg.ca/ppms/' to ppm\n";
        $cmd = 'ppm rep add uni_winnipeg http://theoryx5.uwinnipeg.ca/ppms/';
        system($cmd);
    }
    if ($out !~ /winnipeg\.510/i && substr($],0,5) eq '5.010') {
        print "adding respository 'uni_winnipeg.510' 'http://cpan.uwinnipeg.ca/PPMPackages/10xx/' to ppm\n";
        $cmd = 'ppm rep add uni_winnipeg.510 http://cpan.uwinnipeg.ca/PPMPackages/10xx/';
        system($cmd);
    }
    if ($out !~ /winnipeg\.512/i && substr($],0,5) eq '5.012') {
        print "adding respository 'uni_winnipeg.512' 'http://cpan.uwinnipeg.ca/PPMPackages/12xx/' to ppm\n";
        $cmd = 'ppm rep add uni_winnipeg.512 http://cpan.uwinnipeg.ca/PPMPackages/12xx/';
        system($cmd);
    }
    if ($out !~ /winnipeg\.514/i && substr($],0,5) eq '5.014') {
        print "adding respository 'uni_winnipeg.514' 'http://cpan.uwinnipeg.ca/PPMPackages/14xx/' to ppm\n";
        $cmd = 'ppm rep add uni_winnipeg.514 http://cpan.uwinnipeg.ca/PPMPackages/14xx/';
        system($cmd);
    }
    if ($out !~ /bribes/i) {
        print "adding respository 'bribes.org' 'http://www.bribes.org/perl/ppm/' to ppm\n";
        $cmd = 'ppm rep add bribes.org http://www.bribes.org/perl/ppm/';
        system($cmd);
    }
    if ($out !~ /assp/i) {
        my $moddir = $asspdir.'\\assp.mod\\';
        print "adding respository '$moddir' to ppm\n";
        $cmd = "ppm rep add $moddir";
        system($cmd);
    }
    $cmd = "ppm rep sync";
    system($cmd);
}

my $ver = eval("use LWP::Simple; LWP::Simple->VERSION;");
if (! $ver) {
    print "================================\n";
    print "= Installing module LWP::Simple=\n";
    print "================================\n";
    my $cmd = "ppm install LWP-Simple";
    $cmd = "cpan LWP::Simple" if ($^O ne "MSWin32");
    system($cmd);
    $ver = eval("use LWP::Simple; LWP::Simple->VERSION;");
    if (! $ver) {
        print "\n\nmodule LWP::Simple is not installed - cancel installation\n\n";
        exit;
    }
}




# array of required perl modules.

my (@Modules) = qw{

  AnyEvent::Watchdog/1.0
  Text::Glob/0
  Number::Compare/0
  Compress::Zlib/2.008
  IO::Wrap/2.110
  Convert::TNEF/0.17
  Digest::MD5/2.36
  Digest::SHA1/2.11
  Email::MIME/1.442
  Email::Send/2.192
  Email::Valid/0.176
  File::ReadBackwards/1.04
  File::Scan::ClamAV/1.8
  LWP::Simple/1.41
  MIME::Types/1.23
  Mail::DKIM::Verifier/0.30_1
  Error/0.17016
  NetAddr::IP/4.007
  Mail::SPF/2.007/--force--nodep
  Mail::SRS/0.31
  Net::CIDR::Lite/0.20
  Net::DNS/0.61
  Net::IP::Match::Regexp/1.00
  Net::LDAP/0.33
  Net::SMTP/2.31
  Net::SenderBase/1.01
  Net::Syslog/0.03
  PerlIO::scalar/0.05
  Tie::DBI/1.02
  Time::HiRes/1.9707
  Schedule::Cron/0.97
  Sys::MemInfo/0.91
  IO::Socket::SSL/1.22
  BerkeleyDB/0.31
  Crypt::CBC/2.30
  Crypt::OpenSSL::AES/0.02
  Authen::SASL/2.1401
  Data::Dumper/2.125
  Devel::Peek/1.04
  Devel::Size/0.71
  Convert::Scalar/1.04
  Net::SMTP::TLS/0.12
  Socket6/0.22
  IO::Socket::INET6/2.67



  };

if ($^O eq "MSWin32") {
    push (@Modules,'Net::Syslog/0.03');
    push (@Modules,'Win32::Daemon/20030617/--force');
} else {
    push (@Modules,'Sys::Syslog/0.25');
}

print "================================\n";

print "= Installing perl modules      =\n";

print "================================\n";

foreach my $moduleName (@Modules) {
    my ($module,$version,$force) = split (/\//,$moduleName);
    $force = ' ' unless $force;
    $force =~ s/\-\-/ \-\-/g;
    $force =~ s/\-\-nodep/\-\-nofollow/g if($] eq '5.008008');
    my $ver;
    $ver = eval("use $module; $module->VERSION;");
#    print "$@" if $@;
    if ($ver) {
        if ($ver && ($ver lt $version)) {
            print "install/upgrade module $module from version $ver to version $version\n";
            $cmd = "cpan $module" if ($^O ne "MSWin32");
            $module =~ s/\:\:/\-/g;
            $module =~ s/Net\-LDAP/Perl\-LDAP/;
            $module =~ s/Mail\-DKIM\-Verifier/Mail\-DKIM/;
            $cmd = "ppm install $force $module" if ($^O eq "MSWin32");
            system($cmd);
            next;
        } else {
            print "module $module version $ver is already installed\n";
            next;
        }
    } else {
        print "install module $module version $version\n";
        $cmd = "cpan $module" if ($^O ne "MSWin32");
        $module =~ s/\:\:/\-/g;
        $module =~ s/Net\-LDAP/Perl\-LDAP/;
        $module =~ s/Mail\-DKIM\-Verifier/Mail\-DKIM/;
        $cmd = "ppm install $force $module" if ($^O eq "MSWin32");
        system($cmd);
        next;
    }
}

print "\nfinished module installation for ASSP\n\n";

my $haveerror = 0;
print "\nchecking module installation for ASSP\n\n";

foreach my $moduleName (@Modules) {
    my ($module,$version) = split (/\//,$moduleName);
    my $ver;
    $ver = eval("no $module; use $module;$module->VERSION;");
    if ($ver) {
        if ($ver ge $version) {
            print "module $module $ver is installed\t[OK]\n";
        } else {
            print "module $module $ver is installed - should be version $version\t[upgrade needed]\n";
            $haveerror = 1 if ($module !~ /thread/i);
        }
        next;
    } else {
        print "module $module is not installed\t[FAILED]\n";
        $haveerror = 1;
        next;
    }
}

if ($haveerror && $^O eq "MSWin32") {
    print "\n\n there where errors - to correct them do the following:\n\n";
    print "- start cmd.exe\n";
    print "- type >ppm\n";
    print "- if the error was '*** package PACKAGENAME not installed ***'\n";
    print "- type >install PACKAGENAME\n";
    print "- if the error was 'ppm install failed: Can't determine best'\n";
    print "- type >s PACKAGENAME\n";
    print "- look for the line with the highest modules-versionnumber and keep in mind the NUMBER on the left site\n";
    print "- type >install NUMBER   or   >upgrade --install NUMBER\n";
    print "- if you need more help on ppm  type  help\n\n\n";

    print "- or you may use CPAN to install some modules\n";
    print "- for this you'll need to download  ftp://ftp.microsoft.com/softlib/mslfiles/nmake15.exe\n";
    print "- extract nmake15.exe  to your  perl/bin  Directory\n";
    print "- as long, as you have no C-compiler installed on your system, you can only install\n";
    print "- modules that have no XS-code!\n\n";
} elsif ($haveerror) {
    print "\n\n there where errors for some modules \n\n";
} else {
    print "\n\nall modules where installed successful\n\n";
}

exit;

