/****************************************************************************
** $Id:  cmds/cmdcube.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDCUBE_H
#define CMDCUBE_H
#include "cmds.h"
#include <math.h>


void cmds::cmdcube(){
	int j;
	double var[3];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(currentcmd);
				tempdataF[0]=1.0;tempdataF[1]=1.0;tempdataF[2]=1.0;
				instruction=tr("Cube Position:");emit instru(instruction);
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==0){/*Global*/
					tempdataF[3]=currentdata.v[0];tempdataF[4]=currentdata.v[1];tempdataF[5]=currentdata.v[2];
				}
				
				if(currentdata.format==1){/*Relativa ("@")*/
					tempdataF[3]=currentdata.v[0];tempdataF[4]=currentdata.v[1];tempdataF[5]=currentdata.v[2];
				}
				
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				/*/////////*/
				instruction=tr("Cube (Width1):<1>");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				instruction=tr("Cube (Width2):<1>");emit instru(instruction);
				step++;
				return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					tempdataF[0]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];var[2]=currentdata.v[2];
					tempdataF[0]=sqrt(var[0]*var[0]+var[1]*var[1]+var[2]*var[2]);
				}
				
				if(currentdata.format>1){
					tempdataF[0]=currentdata.v[0];
				}
				
				/*/////////*/
				instruction=tr("Cube (Width2):<1>");emit instru(instruction);
				step++;
				return;
			}
		break;
		case 3:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				instruction=tr("Cube (Height):<1>");emit instru(instruction);
				step++;
				return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					tempdataF[1]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];var[2]=currentdata.v[2];
					tempdataF[1]=sqrt(var[0]*var[0]+var[1]*var[1]+var[2]*var[2]);
				}
				
				if(currentdata.format>1){
					tempdataF[1]=currentdata.v[0];
				}
				
				/*/////////*/
				instruction=tr("Cube (Height):<1>");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 4:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				currentdata.format=2;
				currentdata.v[0]=1.0;
				SecCmd="setCmdData";
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-rtlines->v[0];var[1]=currentdata.v[1]-rtlines->v[1];
					tempdataF[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];var[2]=currentdata.v[2];
					tempdataF[2]=sqrt(var[0]*var[0]+var[1]*var[1]+var[2]*var[2]);
				}
				
				if(currentdata.format>1){
					tempdataF[2]=currentdata.v[0];
				}
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				
				DTV[j].v1[0]=tempdataF[3];DTV[j].v1[1]=tempdataF[4];DTV[j].v1[2]=tempdataF[5];
				DTV[j].v2[0]=tempdataF[3]+tempdataF[0];DTV[j].v2[1]=tempdataF[4]+tempdataF[1];DTV[j].v2[2]=tempdataF[5];
				DTV[j].v3[0]=tempdataF[3]+tempdataF[0];DTV[j].v3[1]=tempdataF[4];DTV[j].v3[2]=tempdataF[5];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=0;DTV[j].n1[2]=-1;
				DTV[j].n2[0]=0;DTV[j].n2[1]=0;DTV[j].n2[2]=-1;
				DTV[j].n3[0]=0;DTV[j].n3[1]=0;DTV[j].n3[2]=-1;
				DTV[j].texture=0;
				DTV[j].t1[0]=1;DTV[j].t1[1]=0;
				DTV[j].t2[0]=0;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=0;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				DTV[j].v1[0]=DTV[j-1].v1[0];DTV[j].v1[1]=DTV[j-1].v1[1];DTV[j].v1[2]=DTV[j-1].v1[2]+tempdataF[2];
				DTV[j].v3[0]=DTV[j-1].v2[0];DTV[j].v3[1]=DTV[j-1].v2[1];DTV[j].v3[2]=DTV[j-1].v2[2]+tempdataF[2];
				DTV[j].v2[0]=DTV[j-1].v3[0];DTV[j].v2[1]=DTV[j-1].v3[1];DTV[j].v2[2]=DTV[j-1].v3[2]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=0;DTV[j].n1[2]=1;
				DTV[j].n2[0]=0;DTV[j].n2[1]=0;DTV[j].n2[2]=1;
				DTV[j].n3[0]=0;DTV[j].n3[1]=0;DTV[j].n3[2]=1;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=0;
				DTV[j].t3[0]=1;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				DTV[j].v1[0]=DTV[j-1].v1[0];DTV[j].v1[1]=DTV[j-1].v1[1];DTV[j].v1[2]=DTV[j-1].v1[2];
				DTV[j].v2[0]=DTV[j-1].v3[0];DTV[j].v2[1]=DTV[j-1].v3[1];DTV[j].v2[2]=DTV[j-1].v3[2];
				DTV[j].v3[0]=DTV[j].v1[0];DTV[j].v3[1]=DTV[j].v1[1]+tempdataF[1];DTV[j].v3[2]=DTV[j].v1[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=0;DTV[j].n1[2]=1;
				DTV[j].n2[0]=0;DTV[j].n2[1]=0;DTV[j].n2[2]=1;
				DTV[j].n3[0]=0;DTV[j].n3[1]=0;DTV[j].n3[2]=1;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				DTV[j].v1[0]=DTV[j-1].v1[0];DTV[j].v1[1]=DTV[j-1].v1[1];DTV[j].v1[2]=DTV[j-1].v1[2]-tempdataF[2];
				DTV[j].v3[0]=DTV[j-1].v2[0];DTV[j].v3[1]=DTV[j-1].v2[1];DTV[j].v3[2]=DTV[j-1].v2[2]-tempdataF[2];
				DTV[j].v2[0]=DTV[j-1].v3[0];DTV[j].v2[1]=DTV[j-1].v3[1];DTV[j].v2[2]=DTV[j-1].v3[2]-tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=0;DTV[j].n1[2]=-1;
				DTV[j].n2[0]=0;DTV[j].n2[1]=0;DTV[j].n2[2]=-1;
				DTV[j].n3[0]=0;DTV[j].n3[1]=0;DTV[j].n3[2]=-1;
				DTV[j].texture=0;
				DTV[j].t1[0]=1;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				DTV[j].v1[0]=tempdataF[3];DTV[j].v1[1]=tempdataF[4];DTV[j].v1[2]=tempdataF[5];
				DTV[j].v2[0]=tempdataF[3]+tempdataF[0];DTV[j].v2[1]=tempdataF[4];DTV[j].v2[2]=tempdataF[5];
				DTV[j].v3[0]=tempdataF[3]+tempdataF[0];DTV[j].v3[1]=tempdataF[4];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=-1;DTV[j].n1[2]=0;
				DTV[j].n2[0]=0;DTV[j].n2[1]=-1;DTV[j].n2[2]=0;
				DTV[j].n3[0]=0;DTV[j].n3[1]=-1;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=0;
				DTV[j].t3[0]=1;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
				DTV[j].v1[0]=tempdataF[3];DTV[j].v1[1]=tempdataF[4];DTV[j].v1[2]=tempdataF[5];
				DTV[j].v2[0]=tempdataF[3]+tempdataF[0];DTV[j].v2[1]=tempdataF[4];DTV[j].v2[2]=tempdataF[5]+tempdataF[2];
				DTV[j].v3[0]=tempdataF[3];DTV[j].v3[1]=tempdataF[4];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=-1;DTV[j].n1[2]=0;
				DTV[j].n2[0]=0;DTV[j].n2[1]=-1;DTV[j].n2[2]=0;
				DTV[j].n3[0]=0;DTV[j].n3[1]=-1;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3]+tempdataF[0];DTV[j].v1[1]=tempdataF[4];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3]+tempdataF[0];DTV[j].v2[1]=tempdataF[4]+tempdataF[1];DTV[j].v2[2]=tempdataF[5];
			DTV[j].v3[0]=tempdataF[3]+tempdataF[0];DTV[j].v3[1]=tempdataF[4]+tempdataF[1];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=1;DTV[j].n1[1]=0;DTV[j].n1[2]=0;
				DTV[j].n2[0]=1;DTV[j].n2[1]=0;DTV[j].n2[2]=0;
				DTV[j].n3[0]=1;DTV[j].n3[1]=0;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=0;
				DTV[j].t3[0]=1;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3]+tempdataF[0];DTV[j].v1[1]=tempdataF[4];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3]+tempdataF[0];DTV[j].v2[1]=tempdataF[4]+tempdataF[1];DTV[j].v2[2]=tempdataF[5]+tempdataF[2];
			DTV[j].v3[0]=tempdataF[3]+tempdataF[0];DTV[j].v3[1]=tempdataF[4];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=1;DTV[j].n1[1]=0;DTV[j].n1[2]=0;
				DTV[j].n2[0]=1;DTV[j].n2[1]=0;DTV[j].n2[2]=0;
				DTV[j].n3[0]=1;DTV[j].n3[1]=0;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3]+tempdataF[0];DTV[j].v1[1]=tempdataF[4]+tempdataF[1];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3];DTV[j].v2[1]=tempdataF[4]+tempdataF[1];DTV[j].v2[2]=tempdataF[5];
			DTV[j].v3[0]=tempdataF[3];DTV[j].v3[1]=tempdataF[4]+tempdataF[1];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=1;DTV[j].n1[2]=0;
				DTV[j].n2[0]=0;DTV[j].n2[1]=1;DTV[j].n2[2]=0;
				DTV[j].n3[0]=0;DTV[j].n3[1]=1;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=0;
				DTV[j].t3[0]=1;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3]+tempdataF[0];DTV[j].v1[1]=tempdataF[4]+tempdataF[1];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3];DTV[j].v2[1]=tempdataF[4]+tempdataF[1];DTV[j].v2[2]=tempdataF[5]+tempdataF[2];
			DTV[j].v3[0]=tempdataF[3]+tempdataF[0];DTV[j].v3[1]=tempdataF[4]+tempdataF[1];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=0;DTV[j].n1[1]=1;DTV[j].n1[2]=0;
				DTV[j].n2[0]=0;DTV[j].n2[1]=1;DTV[j].n2[2]=0;
				DTV[j].n3[0]=0;DTV[j].n3[1]=1;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3];DTV[j].v1[1]=tempdataF[4]+tempdataF[1];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3];DTV[j].v2[1]=tempdataF[4];DTV[j].v2[2]=tempdataF[5];
			DTV[j].v3[0]=tempdataF[3];DTV[j].v3[1]=tempdataF[4];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=-1;DTV[j].n1[1]=0;DTV[j].n1[2]=0;
				DTV[j].n2[0]=-1;DTV[j].n2[1]=0;DTV[j].n2[2]=0;
				DTV[j].n3[0]=-1;DTV[j].n3[1]=0;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=0;
				DTV[j].t3[0]=1;DTV[j].t3[1]=1;
				
				j=DataTV->size();DataTV->resize(j+1);DTV=DataTV->data();
			DTV[j].v1[0]=tempdataF[3];DTV[j].v1[1]=tempdataF[4]+tempdataF[1];DTV[j].v1[2]=tempdataF[5];
			DTV[j].v2[0]=tempdataF[3];DTV[j].v2[1]=tempdataF[4];DTV[j].v2[2]=tempdataF[5]+tempdataF[2];
			DTV[j].v3[0]=tempdataF[3];DTV[j].v3[1]=tempdataF[4]+tempdataF[1];DTV[j].v3[2]=tempdataF[5]+tempdataF[2];
				DTV[j].c1[0]=currentcolor[0];DTV[j].c1[1]=currentcolor[1];DTV[j].c1[2]=currentcolor[2];
				DTV[j].c2[0]=currentcolor[0];DTV[j].c2[1]=currentcolor[1];DTV[j].c2[2]=currentcolor[2];
				DTV[j].c3[0]=currentcolor[0];DTV[j].c3[1]=currentcolor[1];DTV[j].c3[2]=currentcolor[2];
				DTV[j].n1[0]=-1;DTV[j].n1[1]=0;DTV[j].n1[2]=0;
				DTV[j].n2[0]=-1;DTV[j].n2[1]=0;DTV[j].n2[2]=0;
				DTV[j].n3[0]=-1;DTV[j].n3[1]=0;DTV[j].n3[2]=0;
				DTV[j].texture=0;
				DTV[j].t1[0]=0;DTV[j].t1[1]=0;
				DTV[j].t2[0]=1;DTV[j].t2[1]=1;
				DTV[j].t3[0]=0;DTV[j].t3[1]=1;
				
				CmdCancel();
				return;
			}
		break;


	
	
	
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
